/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a response from an automated agent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.AutomatedAgentReply}
 */
public final class AutomatedAgentReply extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.AutomatedAgentReply)
    AutomatedAgentReplyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutomatedAgentReply.newBuilder() to construct.
  private AutomatedAgentReply(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutomatedAgentReply() {
    responseMessages_ = java.util.Collections.emptyList();
    automatedAgentReplyType_ = 0;
    cxCurrentPage_ = "";
    callCompanionAuthCode_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutomatedAgentReply();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_AutomatedAgentReply_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_AutomatedAgentReply_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.class,
            com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents different automated agent reply types.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType}
   */
  public enum AutomatedAgentReplyType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This should never happen.
     * </pre>
     *
     * <code>AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED = 0;</code>
     */
    AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Partial reply. e.g. Aggregated responses in a `Fulfillment` that enables
     * `return_partial_response` can be returned as partial reply.
     * WARNING: partial reply is not eligible for barge-in.
     * </pre>
     *
     * <code>PARTIAL = 1;</code>
     */
    PARTIAL(1),
    /**
     *
     *
     * <pre>
     * Final reply.
     * </pre>
     *
     * <code>FINAL = 2;</code>
     */
    FINAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This should never happen.
     * </pre>
     *
     * <code>AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Partial reply. e.g. Aggregated responses in a `Fulfillment` that enables
     * `return_partial_response` can be returned as partial reply.
     * WARNING: partial reply is not eligible for barge-in.
     * </pre>
     *
     * <code>PARTIAL = 1;</code>
     */
    public static final int PARTIAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Final reply.
     * </pre>
     *
     * <code>FINAL = 2;</code>
     */
    public static final int FINAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AutomatedAgentReplyType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AutomatedAgentReplyType forNumber(int value) {
      switch (value) {
        case 0:
          return AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED;
        case 1:
          return PARTIAL;
        case 2:
          return FINAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AutomatedAgentReplyType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AutomatedAgentReplyType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AutomatedAgentReplyType>() {
              public AutomatedAgentReplyType findValueByNumber(int number) {
                return AutomatedAgentReplyType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AutomatedAgentReplyType[] VALUES = values();

    public static AutomatedAgentReplyType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AutomatedAgentReplyType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType)
  }

  private int bitField0_;
  private int responseCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object response_;

  public enum ResponseCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DETECT_INTENT_RESPONSE(1),
    RESPONSE_NOT_SET(0);
    private final int value;

    private ResponseCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResponseCase forNumber(int value) {
      switch (value) {
        case 1:
          return DETECT_INTENT_RESPONSE;
        case 0:
          return RESPONSE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResponseCase getResponseCase() {
    return ResponseCase.forNumber(responseCase_);
  }

  private int matchCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object match_;

  public enum MatchCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTENT(4),
    EVENT(5),
    MATCH_NOT_SET(0);
    private final int value;

    private MatchCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MatchCase valueOf(int value) {
      return forNumber(value);
    }

    public static MatchCase forNumber(int value) {
      switch (value) {
        case 4:
          return INTENT;
        case 5:
          return EVENT;
        case 0:
          return MATCH_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MatchCase getMatchCase() {
    return MatchCase.forNumber(matchCase_);
  }

  public static final int DETECT_INTENT_RESPONSE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Response of the Dialogflow
   * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
   * call.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;</code>
   *
   * @return Whether the detectIntentResponse field is set.
   */
  @java.lang.Override
  public boolean hasDetectIntentResponse() {
    return responseCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Response of the Dialogflow
   * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
   * call.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;</code>
   *
   * @return The detectIntentResponse.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.DetectIntentResponse getDetectIntentResponse() {
    if (responseCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_;
    }
    return com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Response of the Dialogflow
   * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
   * call.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.DetectIntentResponseOrBuilder
      getDetectIntentResponseOrBuilder() {
    if (responseCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_;
    }
    return com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance();
  }

  public static final int RESPONSE_MESSAGES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.ResponseMessage> responseMessages_;
  /**
   *
   *
   * <pre>
   * Response messages from the automated agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.ResponseMessage>
      getResponseMessagesList() {
    return responseMessages_;
  }
  /**
   *
   *
   * <pre>
   * Response messages from the automated agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ResponseMessageOrBuilder>
      getResponseMessagesOrBuilderList() {
    return responseMessages_;
  }
  /**
   *
   *
   * <pre>
   * Response messages from the automated agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
   */
  @java.lang.Override
  public int getResponseMessagesCount() {
    return responseMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * Response messages from the automated agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ResponseMessage getResponseMessages(int index) {
    return responseMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Response messages from the automated agent.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ResponseMessageOrBuilder getResponseMessagesOrBuilder(
      int index) {
    return responseMessages_.get(index);
  }

  public static final int INTENT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Name of the intent if an intent is matched for the query.
   * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
   * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
   * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
   * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the intent field is set.
   */
  public boolean hasIntent() {
    return matchCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Name of the intent if an intent is matched for the query.
   * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
   * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
   * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
   * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The intent.
   */
  public java.lang.String getIntent() {
    java.lang.Object ref = "";
    if (matchCase_ == 4) {
      ref = match_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (matchCase_ == 4) {
        match_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the intent if an intent is matched for the query.
   * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
   * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
   * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
   * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for intent.
   */
  public com.google.protobuf.ByteString getIntentBytes() {
    java.lang.Object ref = "";
    if (matchCase_ == 4) {
      ref = match_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (matchCase_ == 4) {
        match_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Event name if an event is triggered for the query.
   * </pre>
   *
   * <code>string event = 5;</code>
   *
   * @return Whether the event field is set.
   */
  public boolean hasEvent() {
    return matchCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Event name if an event is triggered for the query.
   * </pre>
   *
   * <code>string event = 5;</code>
   *
   * @return The event.
   */
  public java.lang.String getEvent() {
    java.lang.Object ref = "";
    if (matchCase_ == 5) {
      ref = match_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (matchCase_ == 5) {
        match_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Event name if an event is triggered for the query.
   * </pre>
   *
   * <code>string event = 5;</code>
   *
   * @return The bytes for event.
   */
  public com.google.protobuf.ByteString getEventBytes() {
    java.lang.Object ref = "";
    if (matchCase_ == 5) {
      ref = match_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (matchCase_ == 5) {
        match_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCH_CONFIDENCE_FIELD_NUMBER = 9;
  private float matchConfidence_ = 0F;
  /**
   *
   *
   * <pre>
   * The confidence of the match. Values range from 0.0 (completely uncertain)
   * to 1.0 (completely certain).
   * This value is for informational purpose only and is only used to help match
   * the best intent within the classification threshold. This value may change
   * for the same end-user expression at any time due to a model retraining or
   * change in implementation.
   * </pre>
   *
   * <code>float match_confidence = 9;</code>
   *
   * @return The matchConfidence.
   */
  @java.lang.Override
  public float getMatchConfidence() {
    return matchConfidence_;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 10;
  private com.google.protobuf.Struct parameters_;
  /**
   *
   *
   * <pre>
   * The collection of current parameters at the time of this response.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 10;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The collection of current parameters at the time of this response.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 10;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParameters() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * The collection of current parameters at the time of this response.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }

  public static final int CX_SESSION_PARAMETERS_FIELD_NUMBER = 6;
  private com.google.protobuf.Struct cxSessionParameters_;
  /**
   *
   *
   * <pre>
   * The collection of current Dialogflow CX agent session parameters at the
   * time of this response.
   * Deprecated: Use `parameters` instead.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.AutomatedAgentReply.cx_session_parameters is
   *     deprecated. See google/cloud/dialogflow/v2beta1/participant.proto;l=541
   * @return Whether the cxSessionParameters field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasCxSessionParameters() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The collection of current Dialogflow CX agent session parameters at the
   * time of this response.
   * Deprecated: Use `parameters` instead.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.AutomatedAgentReply.cx_session_parameters is
   *     deprecated. See google/cloud/dialogflow/v2beta1/participant.proto;l=541
   * @return The cxSessionParameters.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.Struct getCxSessionParameters() {
    return cxSessionParameters_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : cxSessionParameters_;
  }
  /**
   *
   *
   * <pre>
   * The collection of current Dialogflow CX agent session parameters at the
   * time of this response.
   * Deprecated: Use `parameters` instead.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.StructOrBuilder getCxSessionParametersOrBuilder() {
    return cxSessionParameters_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : cxSessionParameters_;
  }

  public static final int AUTOMATED_AGENT_REPLY_TYPE_FIELD_NUMBER = 7;
  private int automatedAgentReplyType_ = 0;
  /**
   *
   *
   * <pre>
   * AutomatedAgentReply type.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType automated_agent_reply_type = 7;
   * </code>
   *
   * @return The enum numeric value on the wire for automatedAgentReplyType.
   */
  @java.lang.Override
  public int getAutomatedAgentReplyTypeValue() {
    return automatedAgentReplyType_;
  }
  /**
   *
   *
   * <pre>
   * AutomatedAgentReply type.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType automated_agent_reply_type = 7;
   * </code>
   *
   * @return The automatedAgentReplyType.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
      getAutomatedAgentReplyType() {
    com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType result =
        com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType.forNumber(
            automatedAgentReplyType_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
            .UNRECOGNIZED
        : result;
  }

  public static final int ALLOW_CANCELLATION_FIELD_NUMBER = 8;
  private boolean allowCancellation_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether the partial automated agent reply is interruptible when a
   * later reply message arrives. e.g. if the agent specified some music as
   * partial response, it can be cancelled.
   * </pre>
   *
   * <code>bool allow_cancellation = 8;</code>
   *
   * @return The allowCancellation.
   */
  @java.lang.Override
  public boolean getAllowCancellation() {
    return allowCancellation_;
  }

  public static final int CX_CURRENT_PAGE_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cxCurrentPage_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the current Dialogflow CX conversation page.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string cx_current_page = 11;</code>
   *
   * @return The cxCurrentPage.
   */
  @java.lang.Override
  public java.lang.String getCxCurrentPage() {
    java.lang.Object ref = cxCurrentPage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cxCurrentPage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the current Dialogflow CX conversation page.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   * </pre>
   *
   * <code>string cx_current_page = 11;</code>
   *
   * @return The bytes for cxCurrentPage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCxCurrentPageBytes() {
    java.lang.Object ref = cxCurrentPage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cxCurrentPage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALL_COMPANION_AUTH_CODE_FIELD_NUMBER = 12;
  private com.google.protobuf.ByteString callCompanionAuthCode_ =
      com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The auth code for accessing Call Companion UI.
   * </pre>
   *
   * <code>bytes call_companion_auth_code = 12;</code>
   *
   * @return The callCompanionAuthCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCallCompanionAuthCode() {
    return callCompanionAuthCode_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (responseCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_);
    }
    for (int i = 0; i < responseMessages_.size(); i++) {
      output.writeMessage(3, responseMessages_.get(i));
    }
    if (matchCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, match_);
    }
    if (matchCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, match_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getCxSessionParameters());
    }
    if (automatedAgentReplyType_
        != com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
            .AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, automatedAgentReplyType_);
    }
    if (allowCancellation_ != false) {
      output.writeBool(8, allowCancellation_);
    }
    if (java.lang.Float.floatToRawIntBits(matchConfidence_) != 0) {
      output.writeFloat(9, matchConfidence_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(10, getParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cxCurrentPage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, cxCurrentPage_);
    }
    if (!callCompanionAuthCode_.isEmpty()) {
      output.writeBytes(12, callCompanionAuthCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (responseCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_);
    }
    for (int i = 0; i < responseMessages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, responseMessages_.get(i));
    }
    if (matchCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, match_);
    }
    if (matchCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, match_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCxSessionParameters());
    }
    if (automatedAgentReplyType_
        != com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
            .AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, automatedAgentReplyType_);
    }
    if (allowCancellation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, allowCancellation_);
    }
    if (java.lang.Float.floatToRawIntBits(matchConfidence_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(9, matchConfidence_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cxCurrentPage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, cxCurrentPage_);
    }
    if (!callCompanionAuthCode_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(12, callCompanionAuthCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply other =
        (com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply) obj;

    if (!getResponseMessagesList().equals(other.getResponseMessagesList())) return false;
    if (java.lang.Float.floatToIntBits(getMatchConfidence())
        != java.lang.Float.floatToIntBits(other.getMatchConfidence())) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (hasCxSessionParameters() != other.hasCxSessionParameters()) return false;
    if (hasCxSessionParameters()) {
      if (!getCxSessionParameters().equals(other.getCxSessionParameters())) return false;
    }
    if (automatedAgentReplyType_ != other.automatedAgentReplyType_) return false;
    if (getAllowCancellation() != other.getAllowCancellation()) return false;
    if (!getCxCurrentPage().equals(other.getCxCurrentPage())) return false;
    if (!getCallCompanionAuthCode().equals(other.getCallCompanionAuthCode())) return false;
    if (!getResponseCase().equals(other.getResponseCase())) return false;
    switch (responseCase_) {
      case 1:
        if (!getDetectIntentResponse().equals(other.getDetectIntentResponse())) return false;
        break;
      case 0:
      default:
    }
    if (!getMatchCase().equals(other.getMatchCase())) return false;
    switch (matchCase_) {
      case 4:
        if (!getIntent().equals(other.getIntent())) return false;
        break;
      case 5:
        if (!getEvent().equals(other.getEvent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResponseMessagesCount() > 0) {
      hash = (37 * hash) + RESPONSE_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getResponseMessagesList().hashCode();
    }
    hash = (37 * hash) + MATCH_CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getMatchConfidence());
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    if (hasCxSessionParameters()) {
      hash = (37 * hash) + CX_SESSION_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getCxSessionParameters().hashCode();
    }
    hash = (37 * hash) + AUTOMATED_AGENT_REPLY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + automatedAgentReplyType_;
    hash = (37 * hash) + ALLOW_CANCELLATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowCancellation());
    hash = (37 * hash) + CX_CURRENT_PAGE_FIELD_NUMBER;
    hash = (53 * hash) + getCxCurrentPage().hashCode();
    hash = (37 * hash) + CALL_COMPANION_AUTH_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCallCompanionAuthCode().hashCode();
    switch (responseCase_) {
      case 1:
        hash = (37 * hash) + DETECT_INTENT_RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getDetectIntentResponse().hashCode();
        break;
      case 0:
      default:
    }
    switch (matchCase_) {
      case 4:
        hash = (37 * hash) + INTENT_FIELD_NUMBER;
        hash = (53 * hash) + getIntent().hashCode();
        break;
      case 5:
        hash = (37 * hash) + EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getEvent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a response from an automated agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.AutomatedAgentReply}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.AutomatedAgentReply)
      com.google.cloud.dialogflow.v2beta1.AutomatedAgentReplyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_AutomatedAgentReply_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_AutomatedAgentReply_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.class,
              com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResponseMessagesFieldBuilder();
        getParametersFieldBuilder();
        getCxSessionParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (detectIntentResponseBuilder_ != null) {
        detectIntentResponseBuilder_.clear();
      }
      if (responseMessagesBuilder_ == null) {
        responseMessages_ = java.util.Collections.emptyList();
      } else {
        responseMessages_ = null;
        responseMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      matchConfidence_ = 0F;
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      cxSessionParameters_ = null;
      if (cxSessionParametersBuilder_ != null) {
        cxSessionParametersBuilder_.dispose();
        cxSessionParametersBuilder_ = null;
      }
      automatedAgentReplyType_ = 0;
      allowCancellation_ = false;
      cxCurrentPage_ = "";
      callCompanionAuthCode_ = com.google.protobuf.ByteString.EMPTY;
      responseCase_ = 0;
      response_ = null;
      matchCase_ = 0;
      match_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_AutomatedAgentReply_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply build() {
      com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply buildPartial() {
      com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply result =
          new com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply result) {
      if (responseMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          responseMessages_ = java.util.Collections.unmodifiableList(responseMessages_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.responseMessages_ = responseMessages_;
      } else {
        result.responseMessages_ = responseMessagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.matchConfidence_ = matchConfidence_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cxSessionParameters_ =
            cxSessionParametersBuilder_ == null
                ? cxSessionParameters_
                : cxSessionParametersBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.automatedAgentReplyType_ = automatedAgentReplyType_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.allowCancellation_ = allowCancellation_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.cxCurrentPage_ = cxCurrentPage_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.callCompanionAuthCode_ = callCompanionAuthCode_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply result) {
      result.responseCase_ = responseCase_;
      result.response_ = this.response_;
      if (responseCase_ == 1 && detectIntentResponseBuilder_ != null) {
        result.response_ = detectIntentResponseBuilder_.build();
      }
      result.matchCase_ = matchCase_;
      result.match_ = this.match_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply other) {
      if (other == com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.getDefaultInstance())
        return this;
      if (responseMessagesBuilder_ == null) {
        if (!other.responseMessages_.isEmpty()) {
          if (responseMessages_.isEmpty()) {
            responseMessages_ = other.responseMessages_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureResponseMessagesIsMutable();
            responseMessages_.addAll(other.responseMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.responseMessages_.isEmpty()) {
          if (responseMessagesBuilder_.isEmpty()) {
            responseMessagesBuilder_.dispose();
            responseMessagesBuilder_ = null;
            responseMessages_ = other.responseMessages_;
            bitField0_ = (bitField0_ & ~0x00000002);
            responseMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResponseMessagesFieldBuilder()
                    : null;
          } else {
            responseMessagesBuilder_.addAllMessages(other.responseMessages_);
          }
        }
      }
      if (other.getMatchConfidence() != 0F) {
        setMatchConfidence(other.getMatchConfidence());
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      if (other.hasCxSessionParameters()) {
        mergeCxSessionParameters(other.getCxSessionParameters());
      }
      if (other.automatedAgentReplyType_ != 0) {
        setAutomatedAgentReplyTypeValue(other.getAutomatedAgentReplyTypeValue());
      }
      if (other.getAllowCancellation() != false) {
        setAllowCancellation(other.getAllowCancellation());
      }
      if (!other.getCxCurrentPage().isEmpty()) {
        cxCurrentPage_ = other.cxCurrentPage_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.getCallCompanionAuthCode() != com.google.protobuf.ByteString.EMPTY) {
        setCallCompanionAuthCode(other.getCallCompanionAuthCode());
      }
      switch (other.getResponseCase()) {
        case DETECT_INTENT_RESPONSE:
          {
            mergeDetectIntentResponse(other.getDetectIntentResponse());
            break;
          }
        case RESPONSE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getMatchCase()) {
        case INTENT:
          {
            matchCase_ = 4;
            match_ = other.match_;
            onChanged();
            break;
          }
        case EVENT:
          {
            matchCase_ = 5;
            match_ = other.match_;
            onChanged();
            break;
          }
        case MATCH_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getDetectIntentResponseFieldBuilder().getBuilder(), extensionRegistry);
                responseCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                com.google.cloud.dialogflow.v2beta1.ResponseMessage m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.ResponseMessage.parser(),
                        extensionRegistry);
                if (responseMessagesBuilder_ == null) {
                  ensureResponseMessagesIsMutable();
                  responseMessages_.add(m);
                } else {
                  responseMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                matchCase_ = 4;
                match_ = s;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                matchCase_ = 5;
                match_ = s;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getCxSessionParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                automatedAgentReplyType_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 64:
              {
                allowCancellation_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 64
            case 77:
              {
                matchConfidence_ = input.readFloat();
                bitField0_ |= 0x00000010;
                break;
              } // case 77
            case 82:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 82
            case 90:
              {
                cxCurrentPage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                callCompanionAuthCode_ = input.readBytes();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int responseCase_ = 0;
    private java.lang.Object response_;

    public ResponseCase getResponseCase() {
      return ResponseCase.forNumber(responseCase_);
    }

    public Builder clearResponse() {
      responseCase_ = 0;
      response_ = null;
      onChanged();
      return this;
    }

    private int matchCase_ = 0;
    private java.lang.Object match_;

    public MatchCase getMatchCase() {
      return MatchCase.forNumber(matchCase_);
    }

    public Builder clearMatch() {
      matchCase_ = 0;
      match_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponse,
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponseOrBuilder>
        detectIntentResponseBuilder_;
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     *
     * @return Whether the detectIntentResponse field is set.
     */
    @java.lang.Override
    public boolean hasDetectIntentResponse() {
      return responseCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     *
     * @return The detectIntentResponse.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DetectIntentResponse getDetectIntentResponse() {
      if (detectIntentResponseBuilder_ == null) {
        if (responseCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_;
        }
        return com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance();
      } else {
        if (responseCase_ == 1) {
          return detectIntentResponseBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     */
    public Builder setDetectIntentResponse(
        com.google.cloud.dialogflow.v2beta1.DetectIntentResponse value) {
      if (detectIntentResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        response_ = value;
        onChanged();
      } else {
        detectIntentResponseBuilder_.setMessage(value);
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     */
    public Builder setDetectIntentResponse(
        com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.Builder builderForValue) {
      if (detectIntentResponseBuilder_ == null) {
        response_ = builderForValue.build();
        onChanged();
      } else {
        detectIntentResponseBuilder_.setMessage(builderForValue.build());
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     */
    public Builder mergeDetectIntentResponse(
        com.google.cloud.dialogflow.v2beta1.DetectIntentResponse value) {
      if (detectIntentResponseBuilder_ == null) {
        if (responseCase_ == 1
            && response_
                != com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance()) {
          response_ =
              com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          response_ = value;
        }
        onChanged();
      } else {
        if (responseCase_ == 1) {
          detectIntentResponseBuilder_.mergeFrom(value);
        } else {
          detectIntentResponseBuilder_.setMessage(value);
        }
      }
      responseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     */
    public Builder clearDetectIntentResponse() {
      if (detectIntentResponseBuilder_ == null) {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
          onChanged();
        }
      } else {
        if (responseCase_ == 1) {
          responseCase_ = 0;
          response_ = null;
        }
        detectIntentResponseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.Builder
        getDetectIntentResponseBuilder() {
      return getDetectIntentResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DetectIntentResponseOrBuilder
        getDetectIntentResponseOrBuilder() {
      if ((responseCase_ == 1) && (detectIntentResponseBuilder_ != null)) {
        return detectIntentResponseBuilder_.getMessageOrBuilder();
      } else {
        if (responseCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_;
        }
        return com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Response of the Dialogflow
     * [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
     * call.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.DetectIntentResponse detect_intent_response = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponse,
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponseOrBuilder>
        getDetectIntentResponseFieldBuilder() {
      if (detectIntentResponseBuilder_ == null) {
        if (!(responseCase_ == 1)) {
          response_ = com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance();
        }
        detectIntentResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.DetectIntentResponse,
                com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.Builder,
                com.google.cloud.dialogflow.v2beta1.DetectIntentResponseOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) response_,
                getParentForChildren(),
                isClean());
        response_ = null;
      }
      responseCase_ = 1;
      onChanged();
      return detectIntentResponseBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.ResponseMessage> responseMessages_ =
        java.util.Collections.emptyList();

    private void ensureResponseMessagesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        responseMessages_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.ResponseMessage>(
                responseMessages_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.ResponseMessage,
            com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder,
            com.google.cloud.dialogflow.v2beta1.ResponseMessageOrBuilder>
        responseMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.ResponseMessage>
        getResponseMessagesList() {
      if (responseMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(responseMessages_);
      } else {
        return responseMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public int getResponseMessagesCount() {
      if (responseMessagesBuilder_ == null) {
        return responseMessages_.size();
      } else {
        return responseMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.ResponseMessage getResponseMessages(int index) {
      if (responseMessagesBuilder_ == null) {
        return responseMessages_.get(index);
      } else {
        return responseMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder setResponseMessages(
        int index, com.google.cloud.dialogflow.v2beta1.ResponseMessage value) {
      if (responseMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseMessagesIsMutable();
        responseMessages_.set(index, value);
        onChanged();
      } else {
        responseMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder setResponseMessages(
        int index, com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder builderForValue) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        responseMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder addResponseMessages(com.google.cloud.dialogflow.v2beta1.ResponseMessage value) {
      if (responseMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseMessagesIsMutable();
        responseMessages_.add(value);
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder addResponseMessages(
        int index, com.google.cloud.dialogflow.v2beta1.ResponseMessage value) {
      if (responseMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseMessagesIsMutable();
        responseMessages_.add(index, value);
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder addResponseMessages(
        com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder builderForValue) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.add(builderForValue.build());
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder addResponseMessages(
        int index, com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder builderForValue) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        responseMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder addAllResponseMessages(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.ResponseMessage> values) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseMessages_);
        onChanged();
      } else {
        responseMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder clearResponseMessages() {
      if (responseMessagesBuilder_ == null) {
        responseMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        responseMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public Builder removeResponseMessages(int index) {
      if (responseMessagesBuilder_ == null) {
        ensureResponseMessagesIsMutable();
        responseMessages_.remove(index);
        onChanged();
      } else {
        responseMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder getResponseMessagesBuilder(
        int index) {
      return getResponseMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.ResponseMessageOrBuilder
        getResponseMessagesOrBuilder(int index) {
      if (responseMessagesBuilder_ == null) {
        return responseMessages_.get(index);
      } else {
        return responseMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ResponseMessageOrBuilder>
        getResponseMessagesOrBuilderList() {
      if (responseMessagesBuilder_ != null) {
        return responseMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(responseMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder
        addResponseMessagesBuilder() {
      return getResponseMessagesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder addResponseMessagesBuilder(
        int index) {
      return getResponseMessagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.ResponseMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Response messages from the automated agent.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.ResponseMessage response_messages = 3;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder>
        getResponseMessagesBuilderList() {
      return getResponseMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.ResponseMessage,
            com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder,
            com.google.cloud.dialogflow.v2beta1.ResponseMessageOrBuilder>
        getResponseMessagesFieldBuilder() {
      if (responseMessagesBuilder_ == null) {
        responseMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.ResponseMessage,
                com.google.cloud.dialogflow.v2beta1.ResponseMessage.Builder,
                com.google.cloud.dialogflow.v2beta1.ResponseMessageOrBuilder>(
                responseMessages_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        responseMessages_ = null;
      }
      return responseMessagesBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Name of the intent if an intent is matched for the query.
     * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
     * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the intent field is set.
     */
    @java.lang.Override
    public boolean hasIntent() {
      return matchCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Name of the intent if an intent is matched for the query.
     * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
     * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The intent.
     */
    @java.lang.Override
    public java.lang.String getIntent() {
      java.lang.Object ref = "";
      if (matchCase_ == 4) {
        ref = match_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (matchCase_ == 4) {
          match_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the intent if an intent is matched for the query.
     * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
     * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for intent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIntentBytes() {
      java.lang.Object ref = "";
      if (matchCase_ == 4) {
        ref = match_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (matchCase_ == 4) {
          match_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the intent if an intent is matched for the query.
     * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
     * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The intent to set.
     * @return This builder for chaining.
     */
    public Builder setIntent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      matchCase_ = 4;
      match_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the intent if an intent is matched for the query.
     * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
     * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntent() {
      if (matchCase_ == 4) {
        matchCase_ = 0;
        match_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the intent if an intent is matched for the query.
     * For a V2 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agent/intents/&lt;Intent ID&gt;`.
     * For a V3 query, the value format is `projects/&lt;Project ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string intent = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for intent to set.
     * @return This builder for chaining.
     */
    public Builder setIntentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      matchCase_ = 4;
      match_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Event name if an event is triggered for the query.
     * </pre>
     *
     * <code>string event = 5;</code>
     *
     * @return Whether the event field is set.
     */
    @java.lang.Override
    public boolean hasEvent() {
      return matchCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Event name if an event is triggered for the query.
     * </pre>
     *
     * <code>string event = 5;</code>
     *
     * @return The event.
     */
    @java.lang.Override
    public java.lang.String getEvent() {
      java.lang.Object ref = "";
      if (matchCase_ == 5) {
        ref = match_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (matchCase_ == 5) {
          match_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Event name if an event is triggered for the query.
     * </pre>
     *
     * <code>string event = 5;</code>
     *
     * @return The bytes for event.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEventBytes() {
      java.lang.Object ref = "";
      if (matchCase_ == 5) {
        ref = match_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (matchCase_ == 5) {
          match_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Event name if an event is triggered for the query.
     * </pre>
     *
     * <code>string event = 5;</code>
     *
     * @param value The event to set.
     * @return This builder for chaining.
     */
    public Builder setEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      matchCase_ = 5;
      match_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event name if an event is triggered for the query.
     * </pre>
     *
     * <code>string event = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvent() {
      if (matchCase_ == 5) {
        matchCase_ = 0;
        match_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event name if an event is triggered for the query.
     * </pre>
     *
     * <code>string event = 5;</code>
     *
     * @param value The bytes for event to set.
     * @return This builder for chaining.
     */
    public Builder setEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      matchCase_ = 5;
      match_ = value;
      onChanged();
      return this;
    }

    private float matchConfidence_;
    /**
     *
     *
     * <pre>
     * The confidence of the match. Values range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to help match
     * the best intent within the classification threshold. This value may change
     * for the same end-user expression at any time due to a model retraining or
     * change in implementation.
     * </pre>
     *
     * <code>float match_confidence = 9;</code>
     *
     * @return The matchConfidence.
     */
    @java.lang.Override
    public float getMatchConfidence() {
      return matchConfidence_;
    }
    /**
     *
     *
     * <pre>
     * The confidence of the match. Values range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to help match
     * the best intent within the classification threshold. This value may change
     * for the same end-user expression at any time due to a model retraining or
     * change in implementation.
     * </pre>
     *
     * <code>float match_confidence = 9;</code>
     *
     * @param value The matchConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setMatchConfidence(float value) {

      matchConfidence_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The confidence of the match. Values range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to help match
     * the best intent within the classification threshold. This value may change
     * for the same end-user expression at any time due to a model retraining or
     * change in implementation.
     * </pre>
     *
     * <code>float match_confidence = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatchConfidence() {
      bitField0_ = (bitField0_ & ~0x00000010);
      matchConfidence_ = 0F;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Struct getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && parameters_ != null
            && parameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      if (parameters_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000020);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     */
    public com.google.protobuf.Struct.Builder getParametersBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     */
    public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of current parameters at the time of this response.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private com.google.protobuf.Struct cxSessionParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        cxSessionParametersBuilder_;
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.AutomatedAgentReply.cx_session_parameters is
     *     deprecated. See google/cloud/dialogflow/v2beta1/participant.proto;l=541
     * @return Whether the cxSessionParameters field is set.
     */
    @java.lang.Deprecated
    public boolean hasCxSessionParameters() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.AutomatedAgentReply.cx_session_parameters is
     *     deprecated. See google/cloud/dialogflow/v2beta1/participant.proto;l=541
     * @return The cxSessionParameters.
     */
    @java.lang.Deprecated
    public com.google.protobuf.Struct getCxSessionParameters() {
      if (cxSessionParametersBuilder_ == null) {
        return cxSessionParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : cxSessionParameters_;
      } else {
        return cxSessionParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setCxSessionParameters(com.google.protobuf.Struct value) {
      if (cxSessionParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cxSessionParameters_ = value;
      } else {
        cxSessionParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setCxSessionParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (cxSessionParametersBuilder_ == null) {
        cxSessionParameters_ = builderForValue.build();
      } else {
        cxSessionParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeCxSessionParameters(com.google.protobuf.Struct value) {
      if (cxSessionParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && cxSessionParameters_ != null
            && cxSessionParameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCxSessionParametersBuilder().mergeFrom(value);
        } else {
          cxSessionParameters_ = value;
        }
      } else {
        cxSessionParametersBuilder_.mergeFrom(value);
      }
      if (cxSessionParameters_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearCxSessionParameters() {
      bitField0_ = (bitField0_ & ~0x00000040);
      cxSessionParameters_ = null;
      if (cxSessionParametersBuilder_ != null) {
        cxSessionParametersBuilder_.dispose();
        cxSessionParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.Struct.Builder getCxSessionParametersBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCxSessionParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.StructOrBuilder getCxSessionParametersOrBuilder() {
      if (cxSessionParametersBuilder_ != null) {
        return cxSessionParametersBuilder_.getMessageOrBuilder();
      } else {
        return cxSessionParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : cxSessionParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of current Dialogflow CX agent session parameters at the
     * time of this response.
     * Deprecated: Use `parameters` instead.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_session_parameters = 6 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCxSessionParametersFieldBuilder() {
      if (cxSessionParametersBuilder_ == null) {
        cxSessionParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCxSessionParameters(), getParentForChildren(), isClean());
        cxSessionParameters_ = null;
      }
      return cxSessionParametersBuilder_;
    }

    private int automatedAgentReplyType_ = 0;
    /**
     *
     *
     * <pre>
     * AutomatedAgentReply type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType automated_agent_reply_type = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for automatedAgentReplyType.
     */
    @java.lang.Override
    public int getAutomatedAgentReplyTypeValue() {
      return automatedAgentReplyType_;
    }
    /**
     *
     *
     * <pre>
     * AutomatedAgentReply type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType automated_agent_reply_type = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for automatedAgentReplyType to set.
     * @return This builder for chaining.
     */
    public Builder setAutomatedAgentReplyTypeValue(int value) {
      automatedAgentReplyType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AutomatedAgentReply type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType automated_agent_reply_type = 7;
     * </code>
     *
     * @return The automatedAgentReplyType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
        getAutomatedAgentReplyType() {
      com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType result =
          com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType.forNumber(
              automatedAgentReplyType_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * AutomatedAgentReply type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType automated_agent_reply_type = 7;
     * </code>
     *
     * @param value The automatedAgentReplyType to set.
     * @return This builder for chaining.
     */
    public Builder setAutomatedAgentReplyType(
        com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      automatedAgentReplyType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * AutomatedAgentReply type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType automated_agent_reply_type = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutomatedAgentReplyType() {
      bitField0_ = (bitField0_ & ~0x00000080);
      automatedAgentReplyType_ = 0;
      onChanged();
      return this;
    }

    private boolean allowCancellation_;
    /**
     *
     *
     * <pre>
     * Indicates whether the partial automated agent reply is interruptible when a
     * later reply message arrives. e.g. if the agent specified some music as
     * partial response, it can be cancelled.
     * </pre>
     *
     * <code>bool allow_cancellation = 8;</code>
     *
     * @return The allowCancellation.
     */
    @java.lang.Override
    public boolean getAllowCancellation() {
      return allowCancellation_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the partial automated agent reply is interruptible when a
     * later reply message arrives. e.g. if the agent specified some music as
     * partial response, it can be cancelled.
     * </pre>
     *
     * <code>bool allow_cancellation = 8;</code>
     *
     * @param value The allowCancellation to set.
     * @return This builder for chaining.
     */
    public Builder setAllowCancellation(boolean value) {

      allowCancellation_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the partial automated agent reply is interruptible when a
     * later reply message arrives. e.g. if the agent specified some music as
     * partial response, it can be cancelled.
     * </pre>
     *
     * <code>bool allow_cancellation = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowCancellation() {
      bitField0_ = (bitField0_ & ~0x00000100);
      allowCancellation_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object cxCurrentPage_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the current Dialogflow CX conversation page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string cx_current_page = 11;</code>
     *
     * @return The cxCurrentPage.
     */
    public java.lang.String getCxCurrentPage() {
      java.lang.Object ref = cxCurrentPage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cxCurrentPage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the current Dialogflow CX conversation page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string cx_current_page = 11;</code>
     *
     * @return The bytes for cxCurrentPage.
     */
    public com.google.protobuf.ByteString getCxCurrentPageBytes() {
      java.lang.Object ref = cxCurrentPage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cxCurrentPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the current Dialogflow CX conversation page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string cx_current_page = 11;</code>
     *
     * @param value The cxCurrentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCxCurrentPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cxCurrentPage_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the current Dialogflow CX conversation page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string cx_current_page = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCxCurrentPage() {
      cxCurrentPage_ = getDefaultInstance().getCxCurrentPage();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the current Dialogflow CX conversation page.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     * </pre>
     *
     * <code>string cx_current_page = 11;</code>
     *
     * @param value The bytes for cxCurrentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCxCurrentPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cxCurrentPage_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString callCompanionAuthCode_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The auth code for accessing Call Companion UI.
     * </pre>
     *
     * <code>bytes call_companion_auth_code = 12;</code>
     *
     * @return The callCompanionAuthCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCallCompanionAuthCode() {
      return callCompanionAuthCode_;
    }
    /**
     *
     *
     * <pre>
     * The auth code for accessing Call Companion UI.
     * </pre>
     *
     * <code>bytes call_companion_auth_code = 12;</code>
     *
     * @param value The callCompanionAuthCode to set.
     * @return This builder for chaining.
     */
    public Builder setCallCompanionAuthCode(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      callCompanionAuthCode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The auth code for accessing Call Companion UI.
     * </pre>
     *
     * <code>bytes call_companion_auth_code = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCallCompanionAuthCode() {
      bitField0_ = (bitField0_ & ~0x00000400);
      callCompanionAuthCode_ = getDefaultInstance().getCallCompanionAuthCode();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.AutomatedAgentReply)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.AutomatedAgentReply)
  private static final com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply();
  }

  public static com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutomatedAgentReply> PARSER =
      new com.google.protobuf.AbstractParser<AutomatedAgentReply>() {
        @java.lang.Override
        public AutomatedAgentReply parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutomatedAgentReply> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutomatedAgentReply> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AutomatedAgentReply getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
