/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/sip_trunk.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a connection for SIP Trunk.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Connection}
 */
public final class Connection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Connection)
    ConnectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Connection.newBuilder() to construct.
  private Connection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Connection() {
    connectionId_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Connection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
        .internal_static_google_cloud_dialogflow_v2beta1_Connection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
        .internal_static_google_cloud_dialogflow_v2beta1_Connection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Connection.class,
            com.google.cloud.dialogflow.v2beta1.Connection.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of Sip Trunk connection.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Connection.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * SIP Trunk connection state is Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * SIP Trunk connection is connected.
     * </pre>
     *
     * <code>CONNECTED = 1;</code>
     */
    CONNECTED(1),
    /**
     *
     *
     * <pre>
     * SIP Trunk connection is disconnected.
     * </pre>
     *
     * <code>DISCONNECTED = 2;</code>
     */
    DISCONNECTED(2),
    /**
     *
     *
     * <pre>
     * SIP Trunk connection has authentication error.
     * </pre>
     *
     * <code>AUTHENTICATION_FAILED = 3;</code>
     */
    AUTHENTICATION_FAILED(3),
    /**
     *
     *
     * <pre>
     * SIP Trunk connection is keepalive.
     * </pre>
     *
     * <code>KEEPALIVE = 4;</code>
     */
    KEEPALIVE(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * SIP Trunk connection state is Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * SIP Trunk connection is connected.
     * </pre>
     *
     * <code>CONNECTED = 1;</code>
     */
    public static final int CONNECTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * SIP Trunk connection is disconnected.
     * </pre>
     *
     * <code>DISCONNECTED = 2;</code>
     */
    public static final int DISCONNECTED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * SIP Trunk connection has authentication error.
     * </pre>
     *
     * <code>AUTHENTICATION_FAILED = 3;</code>
     */
    public static final int AUTHENTICATION_FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * SIP Trunk connection is keepalive.
     * </pre>
     *
     * <code>KEEPALIVE = 4;</code>
     */
    public static final int KEEPALIVE_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CONNECTED;
        case 2:
          return DISCONNECTED;
        case 3:
          return AUTHENTICATION_FAILED;
        case 4:
          return KEEPALIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Connection.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Connection.State)
  }

  /**
   *
   *
   * <pre>
   * The state of Sip Trunk certificate authentication.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Connection.CertificateState}
   */
  public enum CertificateState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Certificate state is not specified.
     * </pre>
     *
     * <code>CERTIFICATE_STATE_UNSPECIFIED = 0;</code>
     */
    CERTIFICATE_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Certificate is valid.
     * </pre>
     *
     * <code>CERTIFICATE_VALID = 1;</code>
     */
    CERTIFICATE_VALID(1),
    /**
     *
     *
     * <pre>
     * Catch all for any error not specified.
     * </pre>
     *
     * <code>CERTIFICATE_INVALID = 2;</code>
     */
    CERTIFICATE_INVALID(2),
    /**
     *
     *
     * <pre>
     * Certificate leaf node has expired.
     * </pre>
     *
     * <code>CERTIFICATE_EXPIRED = 3;</code>
     */
    CERTIFICATE_EXPIRED(3),
    /**
     *
     *
     * <pre>
     * There is no hostname defined to authenticate in SipTrunkingServer.
     * </pre>
     *
     * <code>CERTIFICATE_HOSTNAME_NOT_FOUND = 4;</code>
     */
    CERTIFICATE_HOSTNAME_NOT_FOUND(4),
    /**
     *
     *
     * <pre>
     * No path found from the leaf certificate to any root.
     * </pre>
     *
     * <code>CERTIFICATE_UNAUTHENTICATED = 5;</code>
     */
    CERTIFICATE_UNAUTHENTICATED(5),
    /**
     *
     *
     * <pre>
     * Trust store does not exist.
     * </pre>
     *
     * <code>CERTIFICATE_TRUST_STORE_NOT_FOUND = 6;</code>
     */
    CERTIFICATE_TRUST_STORE_NOT_FOUND(6),
    /**
     *
     *
     * <pre>
     * Hostname has invalid format.
     * </pre>
     *
     * <code>CERTIFICATE_HOSTNAME_INVALID_FORMAT = 7;</code>
     */
    CERTIFICATE_HOSTNAME_INVALID_FORMAT(7),
    /**
     *
     *
     * <pre>
     * Certificate has exhausted its quota.
     * </pre>
     *
     * <code>CERTIFICATE_QUOTA_EXCEEDED = 8;</code>
     */
    CERTIFICATE_QUOTA_EXCEEDED(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Certificate state is not specified.
     * </pre>
     *
     * <code>CERTIFICATE_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int CERTIFICATE_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Certificate is valid.
     * </pre>
     *
     * <code>CERTIFICATE_VALID = 1;</code>
     */
    public static final int CERTIFICATE_VALID_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Catch all for any error not specified.
     * </pre>
     *
     * <code>CERTIFICATE_INVALID = 2;</code>
     */
    public static final int CERTIFICATE_INVALID_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Certificate leaf node has expired.
     * </pre>
     *
     * <code>CERTIFICATE_EXPIRED = 3;</code>
     */
    public static final int CERTIFICATE_EXPIRED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * There is no hostname defined to authenticate in SipTrunkingServer.
     * </pre>
     *
     * <code>CERTIFICATE_HOSTNAME_NOT_FOUND = 4;</code>
     */
    public static final int CERTIFICATE_HOSTNAME_NOT_FOUND_VALUE = 4;
    /**
     *
     *
     * <pre>
     * No path found from the leaf certificate to any root.
     * </pre>
     *
     * <code>CERTIFICATE_UNAUTHENTICATED = 5;</code>
     */
    public static final int CERTIFICATE_UNAUTHENTICATED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Trust store does not exist.
     * </pre>
     *
     * <code>CERTIFICATE_TRUST_STORE_NOT_FOUND = 6;</code>
     */
    public static final int CERTIFICATE_TRUST_STORE_NOT_FOUND_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Hostname has invalid format.
     * </pre>
     *
     * <code>CERTIFICATE_HOSTNAME_INVALID_FORMAT = 7;</code>
     */
    public static final int CERTIFICATE_HOSTNAME_INVALID_FORMAT_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Certificate has exhausted its quota.
     * </pre>
     *
     * <code>CERTIFICATE_QUOTA_EXCEEDED = 8;</code>
     */
    public static final int CERTIFICATE_QUOTA_EXCEEDED_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CertificateState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CertificateState forNumber(int value) {
      switch (value) {
        case 0:
          return CERTIFICATE_STATE_UNSPECIFIED;
        case 1:
          return CERTIFICATE_VALID;
        case 2:
          return CERTIFICATE_INVALID;
        case 3:
          return CERTIFICATE_EXPIRED;
        case 4:
          return CERTIFICATE_HOSTNAME_NOT_FOUND;
        case 5:
          return CERTIFICATE_UNAUTHENTICATED;
        case 6:
          return CERTIFICATE_TRUST_STORE_NOT_FOUND;
        case 7:
          return CERTIFICATE_HOSTNAME_INVALID_FORMAT;
        case 8:
          return CERTIFICATE_QUOTA_EXCEEDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CertificateState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CertificateState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CertificateState>() {
              public CertificateState findValueByNumber(int number) {
                return CertificateState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Connection.getDescriptor().getEnumTypes().get(1);
    }

    private static final CertificateState[] VALUES = values();

    public static CertificateState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CertificateState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Connection.CertificateState)
  }

  public interface ErrorDetailsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Connection.ErrorDetails)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The status of the certificate authentication.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the certificateState field is set.
     */
    boolean hasCertificateState();
    /**
     *
     *
     * <pre>
     * Output only. The status of the certificate authentication.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for certificateState.
     */
    int getCertificateStateValue();
    /**
     *
     *
     * <pre>
     * Output only. The status of the certificate authentication.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The certificateState.
     */
    com.google.cloud.dialogflow.v2beta1.Connection.CertificateState getCertificateState();

    /**
     *
     *
     * <pre>
     * The error message provided from SIP trunking auth service
     * </pre>
     *
     * <code>optional string error_message = 2;</code>
     *
     * @return Whether the errorMessage field is set.
     */
    boolean hasErrorMessage();
    /**
     *
     *
     * <pre>
     * The error message provided from SIP trunking auth service
     * </pre>
     *
     * <code>optional string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    java.lang.String getErrorMessage();
    /**
     *
     *
     * <pre>
     * The error message provided from SIP trunking auth service
     * </pre>
     *
     * <code>optional string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    com.google.protobuf.ByteString getErrorMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * The error details of Sip Trunk connection authentication.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Connection.ErrorDetails}
   */
  public static final class ErrorDetails extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Connection.ErrorDetails)
      ErrorDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ErrorDetails.newBuilder() to construct.
    private ErrorDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ErrorDetails() {
      certificateState_ = 0;
      errorMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ErrorDetails();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_Connection_ErrorDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_Connection_ErrorDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.class,
              com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.Builder.class);
    }

    private int bitField0_;
    public static final int CERTIFICATE_STATE_FIELD_NUMBER = 1;
    private int certificateState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The status of the certificate authentication.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the certificateState field is set.
     */
    @java.lang.Override
    public boolean hasCertificateState() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the certificate authentication.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for certificateState.
     */
    @java.lang.Override
    public int getCertificateStateValue() {
      return certificateState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the certificate authentication.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The certificateState.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Connection.CertificateState getCertificateState() {
      com.google.cloud.dialogflow.v2beta1.Connection.CertificateState result =
          com.google.cloud.dialogflow.v2beta1.Connection.CertificateState.forNumber(
              certificateState_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Connection.CertificateState.UNRECOGNIZED
          : result;
    }

    public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * The error message provided from SIP trunking auth service
     * </pre>
     *
     * <code>optional string error_message = 2;</code>
     *
     * @return Whether the errorMessage field is set.
     */
    @java.lang.Override
    public boolean hasErrorMessage() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The error message provided from SIP trunking auth service
     * </pre>
     *
     * <code>optional string error_message = 2;</code>
     *
     * @return The errorMessage.
     */
    @java.lang.Override
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The error message provided from SIP trunking auth service
     * </pre>
     *
     * <code>optional string error_message = 2;</code>
     *
     * @return The bytes for errorMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, certificateState_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, certificateState_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails other =
          (com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails) obj;

      if (hasCertificateState() != other.hasCertificateState()) return false;
      if (hasCertificateState()) {
        if (certificateState_ != other.certificateState_) return false;
      }
      if (hasErrorMessage() != other.hasErrorMessage()) return false;
      if (hasErrorMessage()) {
        if (!getErrorMessage().equals(other.getErrorMessage())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCertificateState()) {
        hash = (37 * hash) + CERTIFICATE_STATE_FIELD_NUMBER;
        hash = (53 * hash) + certificateState_;
      }
      if (hasErrorMessage()) {
        hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getErrorMessage().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The error details of Sip Trunk connection authentication.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.Connection.ErrorDetails}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Connection.ErrorDetails)
        com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetailsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
            .internal_static_google_cloud_dialogflow_v2beta1_Connection_ErrorDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
            .internal_static_google_cloud_dialogflow_v2beta1_Connection_ErrorDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.class,
                com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        certificateState_ = 0;
        errorMessage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
            .internal_static_google_cloud_dialogflow_v2beta1_Connection_ErrorDetails_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails build() {
        com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails buildPartial() {
        com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails result =
            new com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.certificateState_ = certificateState_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.errorMessage_ = errorMessage_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails) {
          return mergeFrom((com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.getDefaultInstance())
          return this;
        if (other.hasCertificateState()) {
          setCertificateState(other.getCertificateState());
        }
        if (other.hasErrorMessage()) {
          errorMessage_ = other.errorMessage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  certificateState_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  errorMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int certificateState_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. The status of the certificate authentication.
       * </pre>
       *
       * <code>
       * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the certificateState field is set.
       */
      @java.lang.Override
      public boolean hasCertificateState() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The status of the certificate authentication.
       * </pre>
       *
       * <code>
       * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for certificateState.
       */
      @java.lang.Override
      public int getCertificateStateValue() {
        return certificateState_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The status of the certificate authentication.
       * </pre>
       *
       * <code>
       * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for certificateState to set.
       * @return This builder for chaining.
       */
      public Builder setCertificateStateValue(int value) {
        certificateState_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The status of the certificate authentication.
       * </pre>
       *
       * <code>
       * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The certificateState.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Connection.CertificateState getCertificateState() {
        com.google.cloud.dialogflow.v2beta1.Connection.CertificateState result =
            com.google.cloud.dialogflow.v2beta1.Connection.CertificateState.forNumber(
                certificateState_);
        return result == null
            ? com.google.cloud.dialogflow.v2beta1.Connection.CertificateState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. The status of the certificate authentication.
       * </pre>
       *
       * <code>
       * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The certificateState to set.
       * @return This builder for chaining.
       */
      public Builder setCertificateState(
          com.google.cloud.dialogflow.v2beta1.Connection.CertificateState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        certificateState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The status of the certificate authentication.
       * </pre>
       *
       * <code>
       * optional .google.cloud.dialogflow.v2beta1.Connection.CertificateState certificate_state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCertificateState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        certificateState_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       *
       *
       * <pre>
       * The error message provided from SIP trunking auth service
       * </pre>
       *
       * <code>optional string error_message = 2;</code>
       *
       * @return Whether the errorMessage field is set.
       */
      public boolean hasErrorMessage() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The error message provided from SIP trunking auth service
       * </pre>
       *
       * <code>optional string error_message = 2;</code>
       *
       * @return The errorMessage.
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error message provided from SIP trunking auth service
       * </pre>
       *
       * <code>optional string error_message = 2;</code>
       *
       * @return The bytes for errorMessage.
       */
      public com.google.protobuf.ByteString getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The error message provided from SIP trunking auth service
       * </pre>
       *
       * <code>optional string error_message = 2;</code>
       *
       * @param value The errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error message provided from SIP trunking auth service
       * </pre>
       *
       * <code>optional string error_message = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearErrorMessage() {
        errorMessage_ = getDefaultInstance().getErrorMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error message provided from SIP trunking auth service
       * </pre>
       *
       * <code>optional string error_message = 2;</code>
       *
       * @param value The bytes for errorMessage to set.
       * @return This builder for chaining.
       */
      public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        errorMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Connection.ErrorDetails)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Connection.ErrorDetails)
    private static final com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails();
    }

    public static com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ErrorDetails> PARSER =
        new com.google.protobuf.AbstractParser<ErrorDetails>() {
          @java.lang.Override
          public ErrorDetails parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ErrorDetails> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ErrorDetails> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CONNECTION_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object connectionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of the SIP Trunk connection.
   * </pre>
   *
   * <code>string connection_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The connectionId.
   */
  @java.lang.Override
  public java.lang.String getConnectionId() {
    java.lang.Object ref = connectionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      connectionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of the SIP Trunk connection.
   * </pre>
   *
   * <code>string connection_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for connectionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConnectionIdBytes() {
    java.lang.Object ref = connectionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      connectionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the connection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Connection.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the connection.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Connection.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Connection.State getState() {
    com.google.cloud.dialogflow.v2beta1.Connection.State result =
        com.google.cloud.dialogflow.v2beta1.Connection.State.forNumber(state_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.Connection.State.UNRECOGNIZED
        : result;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. When the connection status changed.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. When the connection status changed.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. When the connection status changed.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ERROR_DETAILS_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails errorDetails_;
  /**
   *
   *
   * <pre>
   * Output only. The error details for the connection. Only populated when
   * authentication errors occur.
   * </pre>
   *
   * <code>
   * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the errorDetails field is set.
   */
  @java.lang.Override
  public boolean hasErrorDetails() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The error details for the connection. Only populated when
   * authentication errors occur.
   * </pre>
   *
   * <code>
   * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The errorDetails.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails getErrorDetails() {
    return errorDetails_ == null
        ? com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.getDefaultInstance()
        : errorDetails_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The error details for the connection. Only populated when
   * authentication errors occur.
   * </pre>
   *
   * <code>
   * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetailsOrBuilder
      getErrorDetailsOrBuilder() {
    return errorDetails_ == null
        ? com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.getDefaultInstance()
        : errorDetails_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, connectionId_);
    }
    if (state_
        != com.google.cloud.dialogflow.v2beta1.Connection.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getErrorDetails());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(connectionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, connectionId_);
    }
    if (state_
        != com.google.cloud.dialogflow.v2beta1.Connection.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getErrorDetails());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Connection)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Connection other =
        (com.google.cloud.dialogflow.v2beta1.Connection) obj;

    if (!getConnectionId().equals(other.getConnectionId())) return false;
    if (state_ != other.state_) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasErrorDetails() != other.hasErrorDetails()) return false;
    if (hasErrorDetails()) {
      if (!getErrorDetails().equals(other.getErrorDetails())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONNECTION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getConnectionId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasErrorDetails()) {
      hash = (37 * hash) + ERROR_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorDetails().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Connection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a connection for SIP Trunk.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Connection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Connection)
      com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_Connection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_Connection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Connection.class,
              com.google.cloud.dialogflow.v2beta1.Connection.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Connection.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateTimeFieldBuilder();
        getErrorDetailsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      connectionId_ = "";
      state_ = 0;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      errorDetails_ = null;
      if (errorDetailsBuilder_ != null) {
        errorDetailsBuilder_.dispose();
        errorDetailsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_Connection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Connection getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Connection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Connection build() {
      com.google.cloud.dialogflow.v2beta1.Connection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Connection buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Connection result =
          new com.google.cloud.dialogflow.v2beta1.Connection(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Connection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.connectionId_ = connectionId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.errorDetails_ =
            errorDetailsBuilder_ == null ? errorDetails_ : errorDetailsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Connection) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Connection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Connection other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Connection.getDefaultInstance()) return this;
      if (!other.getConnectionId().isEmpty()) {
        connectionId_ = other.connectionId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasErrorDetails()) {
        mergeErrorDetails(other.getErrorDetails());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                connectionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getErrorDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object connectionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the SIP Trunk connection.
     * </pre>
     *
     * <code>string connection_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The connectionId.
     */
    public java.lang.String getConnectionId() {
      java.lang.Object ref = connectionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the SIP Trunk connection.
     * </pre>
     *
     * <code>string connection_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for connectionId.
     */
    public com.google.protobuf.ByteString getConnectionIdBytes() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        connectionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the SIP Trunk connection.
     * </pre>
     *
     * <code>string connection_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The connectionId to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      connectionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the SIP Trunk connection.
     * </pre>
     *
     * <code>string connection_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionId() {
      connectionId_ = getDefaultInstance().getConnectionId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of the SIP Trunk connection.
     * </pre>
     *
     * <code>string connection_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for connectionId to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      connectionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Connection.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Connection.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Connection.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Connection.State getState() {
      com.google.cloud.dialogflow.v2beta1.Connection.State result =
          com.google.cloud.dialogflow.v2beta1.Connection.State.forNumber(state_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Connection.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Connection.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dialogflow.v2beta1.Connection.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the connection.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Connection.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. When the connection status changed.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails errorDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails,
            com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.Builder,
            com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetailsOrBuilder>
        errorDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the errorDetails field is set.
     */
    public boolean hasErrorDetails() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The errorDetails.
     */
    public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails getErrorDetails() {
      if (errorDetailsBuilder_ == null) {
        return errorDetails_ == null
            ? com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.getDefaultInstance()
            : errorDetails_;
      } else {
        return errorDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrorDetails(
        com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails value) {
      if (errorDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorDetails_ = value;
      } else {
        errorDetailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrorDetails(
        com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.Builder builderForValue) {
      if (errorDetailsBuilder_ == null) {
        errorDetails_ = builderForValue.build();
      } else {
        errorDetailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeErrorDetails(
        com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails value) {
      if (errorDetailsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && errorDetails_ != null
            && errorDetails_
                != com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails
                    .getDefaultInstance()) {
          getErrorDetailsBuilder().mergeFrom(value);
        } else {
          errorDetails_ = value;
        }
      } else {
        errorDetailsBuilder_.mergeFrom(value);
      }
      if (errorDetails_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrorDetails() {
      bitField0_ = (bitField0_ & ~0x00000008);
      errorDetails_ = null;
      if (errorDetailsBuilder_ != null) {
        errorDetailsBuilder_.dispose();
        errorDetailsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.Builder
        getErrorDetailsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getErrorDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetailsOrBuilder
        getErrorDetailsOrBuilder() {
      if (errorDetailsBuilder_ != null) {
        return errorDetailsBuilder_.getMessageOrBuilder();
      } else {
        return errorDetails_ == null
            ? com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.getDefaultInstance()
            : errorDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The error details for the connection. Only populated when
     * authentication errors occur.
     * </pre>
     *
     * <code>
     * optional .google.cloud.dialogflow.v2beta1.Connection.ErrorDetails error_details = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails,
            com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.Builder,
            com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetailsOrBuilder>
        getErrorDetailsFieldBuilder() {
      if (errorDetailsBuilder_ == null) {
        errorDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails,
                com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetails.Builder,
                com.google.cloud.dialogflow.v2beta1.Connection.ErrorDetailsOrBuilder>(
                getErrorDetails(), getParentForChildren(), isClean());
        errorDetails_ = null;
      }
      return errorDetailsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Connection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Connection)
  private static final com.google.cloud.dialogflow.v2beta1.Connection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Connection();
  }

  public static com.google.cloud.dialogflow.v2beta1.Connection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Connection> PARSER =
      new com.google.protobuf.AbstractParser<Connection>() {
        @java.lang.Override
        public Connection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Connection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Connection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Connection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
