/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/conversation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a conversation.
 * A conversation is an interaction between an agent, including live agents
 * and Dialogflow agents, and a support customer. Conversations can
 * include phone calls and text-based chat sessions.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Conversation}
 */
public final class Conversation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Conversation)
    ConversationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Conversation.newBuilder() to construct.
  private Conversation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Conversation() {
    name_ = "";
    lifecycleState_ = 0;
    conversationProfile_ = "";
    conversationStage_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Conversation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_Conversation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_Conversation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Conversation.class,
            com.google.cloud.dialogflow.v2beta1.Conversation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enumeration of the completion status of the conversation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Conversation.LifecycleState}
   */
  public enum LifecycleState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>LIFECYCLE_STATE_UNSPECIFIED = 0;</code>
     */
    LIFECYCLE_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Conversation is currently open for media analysis.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    IN_PROGRESS(1),
    /**
     *
     *
     * <pre>
     * Conversation has been completed.
     * </pre>
     *
     * <code>COMPLETED = 2;</code>
     */
    COMPLETED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>LIFECYCLE_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int LIFECYCLE_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Conversation is currently open for media analysis.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    public static final int IN_PROGRESS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Conversation has been completed.
     * </pre>
     *
     * <code>COMPLETED = 2;</code>
     */
    public static final int COMPLETED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LifecycleState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LifecycleState forNumber(int value) {
      switch (value) {
        case 0:
          return LIFECYCLE_STATE_UNSPECIFIED;
        case 1:
          return IN_PROGRESS;
        case 2:
          return COMPLETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LifecycleState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LifecycleState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LifecycleState>() {
          public LifecycleState findValueByNumber(int number) {
            return LifecycleState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Conversation.getDescriptor().getEnumTypes().get(0);
    }

    private static final LifecycleState[] VALUES = values();

    public static LifecycleState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LifecycleState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Conversation.LifecycleState)
  }

  /**
   *
   *
   * <pre>
   * Enumeration of the different conversation stages a conversation can be in.
   * Reference:
   * https://cloud.google.com/agent-assist/docs/basics#conversation_stages
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Conversation.ConversationStage}
   */
  public enum ConversationStage implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown. Should never be used after a conversation is successfully
     * created.
     * </pre>
     *
     * <code>CONVERSATION_STAGE_UNSPECIFIED = 0;</code>
     */
    CONVERSATION_STAGE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The conversation should return virtual agent responses into the
     * conversation.
     * </pre>
     *
     * <code>VIRTUAL_AGENT_STAGE = 1;</code>
     */
    VIRTUAL_AGENT_STAGE(1),
    /**
     *
     *
     * <pre>
     * The conversation should not provide responses, just listen and provide
     * suggestions.
     * </pre>
     *
     * <code>HUMAN_ASSIST_STAGE = 2;</code>
     */
    HUMAN_ASSIST_STAGE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown. Should never be used after a conversation is successfully
     * created.
     * </pre>
     *
     * <code>CONVERSATION_STAGE_UNSPECIFIED = 0;</code>
     */
    public static final int CONVERSATION_STAGE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The conversation should return virtual agent responses into the
     * conversation.
     * </pre>
     *
     * <code>VIRTUAL_AGENT_STAGE = 1;</code>
     */
    public static final int VIRTUAL_AGENT_STAGE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The conversation should not provide responses, just listen and provide
     * suggestions.
     * </pre>
     *
     * <code>HUMAN_ASSIST_STAGE = 2;</code>
     */
    public static final int HUMAN_ASSIST_STAGE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConversationStage valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConversationStage forNumber(int value) {
      switch (value) {
        case 0:
          return CONVERSATION_STAGE_UNSPECIFIED;
        case 1:
          return VIRTUAL_AGENT_STAGE;
        case 2:
          return HUMAN_ASSIST_STAGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConversationStage>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConversationStage>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConversationStage>() {
              public ConversationStage findValueByNumber(int number) {
                return ConversationStage.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Conversation.getDescriptor().getEnumTypes().get(1);
    }

    private static final ConversationStage[] VALUES = values();

    public static ConversationStage valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConversationStage(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Conversation.ConversationStage)
  }

  public interface TelephonyConnectionInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The number dialed to connect this call in E.164 format.
     * </pre>
     *
     * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dialedNumber.
     */
    java.lang.String getDialedNumber();
    /**
     *
     *
     * <pre>
     * Output only. The number dialed to connect this call in E.164 format.
     * </pre>
     *
     * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dialedNumber.
     */
    com.google.protobuf.ByteString getDialedNumberBytes();

    /**
     *
     *
     * <pre>
     * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
     * but maybe later updated for the purpose of making the link active, etc.
     * </pre>
     *
     * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sdp.
     */
    java.lang.String getSdp();
    /**
     *
     *
     * <pre>
     * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
     * but maybe later updated for the purpose of making the link active, etc.
     * </pre>
     *
     * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for sdp.
     */
    com.google.protobuf.ByteString getSdpBytes();

    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader>
        getSipHeadersList();
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
        getSipHeaders(int index);
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getSipHeadersCount();
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                    .SipHeaderOrBuilder>
        getSipHeadersOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeaderOrBuilder
        getSipHeadersOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent>
        getExtraMimeContentsList();
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
        getExtraMimeContents(int index);
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getExtraMimeContentsCount();
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                    .MimeContentOrBuilder>
        getExtraMimeContentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContentOrBuilder
        getExtraMimeContentsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The information about phone calls connected via phone gateway to the
   * conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo}
   */
  public static final class TelephonyConnectionInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo)
      TelephonyConnectionInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TelephonyConnectionInfo.newBuilder() to construct.
    private TelephonyConnectionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TelephonyConnectionInfo() {
      dialedNumber_ = "";
      sdp_ = "";
      sipHeaders_ = java.util.Collections.emptyList();
      extraMimeContents_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TelephonyConnectionInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.class,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.Builder
                  .class);
    }

    public interface SipHeaderOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The name of the header.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The name.
       */
      java.lang.String getName();
      /**
       *
       *
       * <pre>
       * Optional. The name of the header.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. The value of the header.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The value.
       */
      java.lang.String getValue();
      /**
       *
       *
       * <pre>
       * Optional. The value of the header.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for value.
       */
      com.google.protobuf.ByteString getValueBytes();
    }
    /**
     *
     *
     * <pre>
     * The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader}
     */
    public static final class SipHeader extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)
        SipHeaderOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SipHeader.newBuilder() to construct.
      private SipHeader(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SipHeader() {
        name_ = "";
        value_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SipHeader();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_SipHeader_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_SipHeader_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                    .class,
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                    .Builder.class);
      }

      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The name of the header.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The name of the header.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The value of the header.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The value of the header.
       * </pre>
       *
       * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader other =
            (com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)
                obj;

        if (!getName().equals(other.getName())) return false;
        if (!getValue().equals(other.getValue())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeaderOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProto
              .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_SipHeader_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProto
              .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_SipHeader_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                      .class,
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          value_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProto
              .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_SipHeader_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
            build() {
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
            buildPartial() {
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              result =
                  new com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .SipHeader(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = value_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                other) {
          if (other
              == com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getValue().isEmpty()) {
            value_ = other.value_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    value_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The name of the header.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the header.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the header.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the header.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of the header.
         * </pre>
         *
         * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object value_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The value of the header.
         * </pre>
         *
         * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The value.
         */
        public java.lang.String getValue() {
          java.lang.Object ref = value_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            value_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The value of the header.
         * </pre>
         *
         * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for value.
         */
        public com.google.protobuf.ByteString getValueBytes() {
          java.lang.Object ref = value_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            value_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The value of the header.
         * </pre>
         *
         * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The value of the header.
         * </pre>
         *
         * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          value_ = getDefaultInstance().getValue();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The value of the header.
         * </pre>
         *
         * <code>string value = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for value to set.
         * @return This builder for chaining.
         */
        public Builder setValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          value_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader)
      private static final com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                .SipHeader();
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeader
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SipHeader> PARSER =
          new com.google.protobuf.AbstractParser<SipHeader>() {
            @java.lang.Override
            public SipHeader parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SipHeader> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SipHeader> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MimeContentOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The mime type of the content.
       * </pre>
       *
       * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The mimeType.
       */
      java.lang.String getMimeType();
      /**
       *
       *
       * <pre>
       * Optional. The mime type of the content.
       * </pre>
       *
       * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for mimeType.
       */
      com.google.protobuf.ByteString getMimeTypeBytes();

      /**
       *
       *
       * <pre>
       * Optional. The content payload.
       * </pre>
       *
       * <code>bytes content = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The content.
       */
      com.google.protobuf.ByteString getContent();
    }
    /**
     *
     *
     * <pre>
     * The mime content from the initial SIP INVITE.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent}
     */
    public static final class MimeContent extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent)
        MimeContentOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use MimeContent.newBuilder() to construct.
      private MimeContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MimeContent() {
        mimeType_ = "";
        content_ = com.google.protobuf.ByteString.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MimeContent();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_MimeContent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_MimeContent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                    .class,
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                    .Builder.class);
      }

      public static final int MIME_TYPE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object mimeType_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The mime type of the content.
       * </pre>
       *
       * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The mimeType.
       */
      @java.lang.Override
      public java.lang.String getMimeType() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mimeType_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The mime type of the content.
       * </pre>
       *
       * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for mimeType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getMimeTypeBytes() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mimeType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CONTENT_FIELD_NUMBER = 2;
      private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * Optional. The content payload.
       * </pre>
       *
       * <code>bytes content = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The content.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContent() {
        return content_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mimeType_);
        }
        if (!content_.isEmpty()) {
          output.writeBytes(2, content_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mimeType_);
        }
        if (!content_.isEmpty()) {
          size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, content_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent other =
            (com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent)
                obj;

        if (!getMimeType().equals(other.getMimeType())) return false;
        if (!getContent().equals(other.getContent())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getMimeType().hashCode();
        hash = (37 * hash) + CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getContent().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * The mime content from the initial SIP INVITE.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent)
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContentOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProto
              .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_MimeContent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProto
              .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_MimeContent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContent.class,
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContent.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          mimeType_ = "";
          content_ = com.google.protobuf.ByteString.EMPTY;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProto
              .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_MimeContent_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
            build() {
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
            buildPartial() {
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              result =
                  new com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContent(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.mimeType_ = mimeType_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.content_ = content_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                  .MimeContent) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                        .MimeContent)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                other) {
          if (other
              == com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                  .MimeContent.getDefaultInstance()) return this;
          if (!other.getMimeType().isEmpty()) {
            mimeType_ = other.mimeType_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getContent() != com.google.protobuf.ByteString.EMPTY) {
            setContent(other.getContent());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    mimeType_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    content_ = input.readBytes();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object mimeType_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The mime type of the content.
         * </pre>
         *
         * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The mimeType.
         */
        public java.lang.String getMimeType() {
          java.lang.Object ref = mimeType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            mimeType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The mime type of the content.
         * </pre>
         *
         * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for mimeType.
         */
        public com.google.protobuf.ByteString getMimeTypeBytes() {
          java.lang.Object ref = mimeType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            mimeType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The mime type of the content.
         * </pre>
         *
         * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The mimeType to set.
         * @return This builder for chaining.
         */
        public Builder setMimeType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          mimeType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The mime type of the content.
         * </pre>
         *
         * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMimeType() {
          mimeType_ = getDefaultInstance().getMimeType();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The mime type of the content.
         * </pre>
         *
         * <code>string mime_type = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for mimeType to set.
         * @return This builder for chaining.
         */
        public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          mimeType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
        /**
         *
         *
         * <pre>
         * Optional. The content payload.
         * </pre>
         *
         * <code>bytes content = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The content.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getContent() {
          return content_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The content payload.
         * </pre>
         *
         * <code>bytes content = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The content to set.
         * @return This builder for chaining.
         */
        public Builder setContent(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The content payload.
         * </pre>
         *
         * <code>bytes content = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContent() {
          bitField0_ = (bitField0_ & ~0x00000002);
          content_ = getDefaultInstance().getContent();
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent)
      private static final com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                .MimeContent();
      }

      public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContent
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MimeContent> PARSER =
          new com.google.protobuf.AbstractParser<MimeContent>() {
            @java.lang.Override
            public MimeContent parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MimeContent> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MimeContent> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int DIALED_NUMBER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dialedNumber_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The number dialed to connect this call in E.164 format.
     * </pre>
     *
     * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The dialedNumber.
     */
    @java.lang.Override
    public java.lang.String getDialedNumber() {
      java.lang.Object ref = dialedNumber_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dialedNumber_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The number dialed to connect this call in E.164 format.
     * </pre>
     *
     * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for dialedNumber.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDialedNumberBytes() {
      java.lang.Object ref = dialedNumber_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dialedNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SDP_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sdp_ = "";
    /**
     *
     *
     * <pre>
     * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
     * but maybe later updated for the purpose of making the link active, etc.
     * </pre>
     *
     * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sdp.
     */
    @java.lang.Override
    public java.lang.String getSdp() {
      java.lang.Object ref = sdp_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sdp_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
     * but maybe later updated for the purpose of making the link active, etc.
     * </pre>
     *
     * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for sdp.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSdpBytes() {
      java.lang.Object ref = sdp_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sdp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIP_HEADERS_FIELD_NUMBER = 12;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader>
        sipHeaders_;
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader>
        getSipHeadersList() {
      return sipHeaders_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                    .SipHeaderOrBuilder>
        getSipHeadersOrBuilderList() {
      return sipHeaders_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getSipHeadersCount() {
      return sipHeaders_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
        getSipHeaders(int index) {
      return sipHeaders_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The SIP headers from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
            .SipHeaderOrBuilder
        getSipHeadersOrBuilder(int index) {
      return sipHeaders_.get(index);
    }

    public static final int EXTRA_MIME_CONTENTS_FIELD_NUMBER = 13;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent>
        extraMimeContents_;
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent>
        getExtraMimeContentsList() {
      return extraMimeContents_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                    .MimeContentOrBuilder>
        getExtraMimeContentsOrBuilderList() {
      return extraMimeContents_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getExtraMimeContentsCount() {
      return extraMimeContents_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
        getExtraMimeContents(int index) {
      return extraMimeContents_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The mime content from the initial SIP INVITE.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
            .MimeContentOrBuilder
        getExtraMimeContentsOrBuilder(int index) {
      return extraMimeContents_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialedNumber_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dialedNumber_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sdp_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, sdp_);
      }
      for (int i = 0; i < sipHeaders_.size(); i++) {
        output.writeMessage(12, sipHeaders_.get(i));
      }
      for (int i = 0; i < extraMimeContents_.size(); i++) {
        output.writeMessage(13, extraMimeContents_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialedNumber_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dialedNumber_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sdp_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, sdp_);
      }
      for (int i = 0; i < sipHeaders_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, sipHeaders_.get(i));
      }
      for (int i = 0; i < extraMimeContents_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(13, extraMimeContents_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo other =
          (com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo) obj;

      if (!getDialedNumber().equals(other.getDialedNumber())) return false;
      if (!getSdp().equals(other.getSdp())) return false;
      if (!getSipHeadersList().equals(other.getSipHeadersList())) return false;
      if (!getExtraMimeContentsList().equals(other.getExtraMimeContentsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DIALED_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getDialedNumber().hashCode();
      hash = (37 * hash) + SDP_FIELD_NUMBER;
      hash = (53 * hash) + getSdp().hashCode();
      if (getSipHeadersCount() > 0) {
        hash = (37 * hash) + SIP_HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + getSipHeadersList().hashCode();
      }
      if (getExtraMimeContentsCount() > 0) {
        hash = (37 * hash) + EXTRA_MIME_CONTENTS_FIELD_NUMBER;
        hash = (53 * hash) + getExtraMimeContentsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The information about phone calls connected via phone gateway to the
     * conversation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo)
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.class,
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dialedNumber_ = "";
        sdp_ = "";
        if (sipHeadersBuilder_ == null) {
          sipHeaders_ = java.util.Collections.emptyList();
        } else {
          sipHeaders_ = null;
          sipHeadersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (extraMimeContentsBuilder_ == null) {
          extraMimeContents_ = java.util.Collections.emptyList();
        } else {
          extraMimeContents_ = null;
          extraMimeContentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_Conversation_TelephonyConnectionInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo build() {
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo result =
            new com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo result) {
        if (sipHeadersBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            sipHeaders_ = java.util.Collections.unmodifiableList(sipHeaders_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.sipHeaders_ = sipHeaders_;
        } else {
          result.sipHeaders_ = sipHeadersBuilder_.build();
        }
        if (extraMimeContentsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            extraMimeContents_ = java.util.Collections.unmodifiableList(extraMimeContents_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.extraMimeContents_ = extraMimeContents_;
        } else {
          result.extraMimeContents_ = extraMimeContentsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dialedNumber_ = dialedNumber_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.sdp_ = sdp_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                .getDefaultInstance()) return this;
        if (!other.getDialedNumber().isEmpty()) {
          dialedNumber_ = other.dialedNumber_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSdp().isEmpty()) {
          sdp_ = other.sdp_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (sipHeadersBuilder_ == null) {
          if (!other.sipHeaders_.isEmpty()) {
            if (sipHeaders_.isEmpty()) {
              sipHeaders_ = other.sipHeaders_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureSipHeadersIsMutable();
              sipHeaders_.addAll(other.sipHeaders_);
            }
            onChanged();
          }
        } else {
          if (!other.sipHeaders_.isEmpty()) {
            if (sipHeadersBuilder_.isEmpty()) {
              sipHeadersBuilder_.dispose();
              sipHeadersBuilder_ = null;
              sipHeaders_ = other.sipHeaders_;
              bitField0_ = (bitField0_ & ~0x00000004);
              sipHeadersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSipHeadersFieldBuilder()
                      : null;
            } else {
              sipHeadersBuilder_.addAllMessages(other.sipHeaders_);
            }
          }
        }
        if (extraMimeContentsBuilder_ == null) {
          if (!other.extraMimeContents_.isEmpty()) {
            if (extraMimeContents_.isEmpty()) {
              extraMimeContents_ = other.extraMimeContents_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureExtraMimeContentsIsMutable();
              extraMimeContents_.addAll(other.extraMimeContents_);
            }
            onChanged();
          }
        } else {
          if (!other.extraMimeContents_.isEmpty()) {
            if (extraMimeContentsBuilder_.isEmpty()) {
              extraMimeContentsBuilder_.dispose();
              extraMimeContentsBuilder_ = null;
              extraMimeContents_ = other.extraMimeContents_;
              bitField0_ = (bitField0_ & ~0x00000008);
              extraMimeContentsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getExtraMimeContentsFieldBuilder()
                      : null;
            } else {
              extraMimeContentsBuilder_.addAllMessages(other.extraMimeContents_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  dialedNumber_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              case 42:
                {
                  sdp_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 42
              case 98:
                {
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                      m =
                          input.readMessage(
                              com.google.cloud.dialogflow.v2beta1.Conversation
                                  .TelephonyConnectionInfo.SipHeader.parser(),
                              extensionRegistry);
                  if (sipHeadersBuilder_ == null) {
                    ensureSipHeadersIsMutable();
                    sipHeaders_.add(m);
                  } else {
                    sipHeadersBuilder_.addMessage(m);
                  }
                  break;
                } // case 98
              case 106:
                {
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                          .MimeContent
                      m =
                          input.readMessage(
                              com.google.cloud.dialogflow.v2beta1.Conversation
                                  .TelephonyConnectionInfo.MimeContent.parser(),
                              extensionRegistry);
                  if (extraMimeContentsBuilder_ == null) {
                    ensureExtraMimeContentsIsMutable();
                    extraMimeContents_.add(m);
                  } else {
                    extraMimeContentsBuilder_.addMessage(m);
                  }
                  break;
                } // case 106
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dialedNumber_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The number dialed to connect this call in E.164 format.
       * </pre>
       *
       * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The dialedNumber.
       */
      public java.lang.String getDialedNumber() {
        java.lang.Object ref = dialedNumber_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dialedNumber_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The number dialed to connect this call in E.164 format.
       * </pre>
       *
       * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for dialedNumber.
       */
      public com.google.protobuf.ByteString getDialedNumberBytes() {
        java.lang.Object ref = dialedNumber_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dialedNumber_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The number dialed to connect this call in E.164 format.
       * </pre>
       *
       * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The dialedNumber to set.
       * @return This builder for chaining.
       */
      public Builder setDialedNumber(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialedNumber_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number dialed to connect this call in E.164 format.
       * </pre>
       *
       * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDialedNumber() {
        dialedNumber_ = getDefaultInstance().getDialedNumber();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number dialed to connect this call in E.164 format.
       * </pre>
       *
       * <code>string dialed_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for dialedNumber to set.
       * @return This builder for chaining.
       */
      public Builder setDialedNumberBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dialedNumber_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object sdp_ = "";
      /**
       *
       *
       * <pre>
       * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
       * but maybe later updated for the purpose of making the link active, etc.
       * </pre>
       *
       * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The sdp.
       */
      public java.lang.String getSdp() {
        java.lang.Object ref = sdp_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sdp_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
       * but maybe later updated for the purpose of making the link active, etc.
       * </pre>
       *
       * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for sdp.
       */
      public com.google.protobuf.ByteString getSdpBytes() {
        java.lang.Object ref = sdp_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sdp_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
       * but maybe later updated for the purpose of making the link active, etc.
       * </pre>
       *
       * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The sdp to set.
       * @return This builder for chaining.
       */
      public Builder setSdp(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sdp_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
       * but maybe later updated for the purpose of making the link active, etc.
       * </pre>
       *
       * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSdp() {
        sdp_ = getDefaultInstance().getSdp();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. SDP of the call. It's initially the SDP answer to the endpoint,
       * but maybe later updated for the purpose of making the link active, etc.
       * </pre>
       *
       * <code>string sdp = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for sdp to set.
       * @return This builder for chaining.
       */
      public Builder setSdpBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sdp_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader>
          sipHeaders_ = java.util.Collections.emptyList();

      private void ensureSipHeadersIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          sipHeaders_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .SipHeader>(sipHeaders_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                  .SipHeaderOrBuilder>
          sipHeadersBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader>
          getSipHeadersList() {
        if (sipHeadersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(sipHeaders_);
        } else {
          return sipHeadersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getSipHeadersCount() {
        if (sipHeadersBuilder_ == null) {
          return sipHeaders_.size();
        } else {
          return sipHeadersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
          getSipHeaders(int index) {
        if (sipHeadersBuilder_ == null) {
          return sipHeaders_.get(index);
        } else {
          return sipHeadersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSipHeaders(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              value) {
        if (sipHeadersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSipHeadersIsMutable();
          sipHeaders_.set(index, value);
          onChanged();
        } else {
          sipHeadersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setSipHeaders(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader.Builder
              builderForValue) {
        if (sipHeadersBuilder_ == null) {
          ensureSipHeadersIsMutable();
          sipHeaders_.set(index, builderForValue.build());
          onChanged();
        } else {
          sipHeadersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSipHeaders(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              value) {
        if (sipHeadersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSipHeadersIsMutable();
          sipHeaders_.add(value);
          onChanged();
        } else {
          sipHeadersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSipHeaders(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              value) {
        if (sipHeadersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSipHeadersIsMutable();
          sipHeaders_.add(index, value);
          onChanged();
        } else {
          sipHeadersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSipHeaders(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader.Builder
              builderForValue) {
        if (sipHeadersBuilder_ == null) {
          ensureSipHeadersIsMutable();
          sipHeaders_.add(builderForValue.build());
          onChanged();
        } else {
          sipHeadersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addSipHeaders(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader.Builder
              builderForValue) {
        if (sipHeadersBuilder_ == null) {
          ensureSipHeadersIsMutable();
          sipHeaders_.add(index, builderForValue.build());
          onChanged();
        } else {
          sipHeadersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllSipHeaders(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                          .SipHeader>
              values) {
        if (sipHeadersBuilder_ == null) {
          ensureSipHeadersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sipHeaders_);
          onChanged();
        } else {
          sipHeadersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearSipHeaders() {
        if (sipHeadersBuilder_ == null) {
          sipHeaders_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          sipHeadersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeSipHeaders(int index) {
        if (sipHeadersBuilder_ == null) {
          ensureSipHeadersIsMutable();
          sipHeaders_.remove(index);
          onChanged();
        } else {
          sipHeadersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              .Builder
          getSipHeadersBuilder(int index) {
        return getSipHeadersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .SipHeaderOrBuilder
          getSipHeadersOrBuilder(int index) {
        if (sipHeadersBuilder_ == null) {
          return sipHeaders_.get(index);
        } else {
          return sipHeadersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .SipHeaderOrBuilder>
          getSipHeadersOrBuilderList() {
        if (sipHeadersBuilder_ != null) {
          return sipHeadersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(sipHeaders_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              .Builder
          addSipHeadersBuilder() {
        return getSipHeadersFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
              .Builder
          addSipHeadersBuilder(int index) {
        return getSipHeadersFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The SIP headers from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader sip_headers = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                  .Builder>
          getSipHeadersBuilderList() {
        return getSipHeadersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                  .SipHeaderOrBuilder>
          getSipHeadersFieldBuilder() {
        if (sipHeadersBuilder_ == null) {
          sipHeadersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .SipHeader,
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.SipHeader
                      .Builder,
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .SipHeaderOrBuilder>(
                  sipHeaders_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          sipHeaders_ = null;
        }
        return sipHeadersBuilder_;
      }

      private java.util.List<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent>
          extraMimeContents_ = java.util.Collections.emptyList();

      private void ensureExtraMimeContentsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          extraMimeContents_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContent>(extraMimeContents_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                  .MimeContentOrBuilder>
          extraMimeContentsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent>
          getExtraMimeContentsList() {
        if (extraMimeContentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(extraMimeContents_);
        } else {
          return extraMimeContentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getExtraMimeContentsCount() {
        if (extraMimeContentsBuilder_ == null) {
          return extraMimeContents_.size();
        } else {
          return extraMimeContentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
          getExtraMimeContents(int index) {
        if (extraMimeContentsBuilder_ == null) {
          return extraMimeContents_.get(index);
        } else {
          return extraMimeContentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setExtraMimeContents(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              value) {
        if (extraMimeContentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtraMimeContentsIsMutable();
          extraMimeContents_.set(index, value);
          onChanged();
        } else {
          extraMimeContentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setExtraMimeContents(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                  .Builder
              builderForValue) {
        if (extraMimeContentsBuilder_ == null) {
          ensureExtraMimeContentsIsMutable();
          extraMimeContents_.set(index, builderForValue.build());
          onChanged();
        } else {
          extraMimeContentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addExtraMimeContents(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              value) {
        if (extraMimeContentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtraMimeContentsIsMutable();
          extraMimeContents_.add(value);
          onChanged();
        } else {
          extraMimeContentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addExtraMimeContents(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              value) {
        if (extraMimeContentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureExtraMimeContentsIsMutable();
          extraMimeContents_.add(index, value);
          onChanged();
        } else {
          extraMimeContentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addExtraMimeContents(
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                  .Builder
              builderForValue) {
        if (extraMimeContentsBuilder_ == null) {
          ensureExtraMimeContentsIsMutable();
          extraMimeContents_.add(builderForValue.build());
          onChanged();
        } else {
          extraMimeContentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addExtraMimeContents(
          int index,
          com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                  .Builder
              builderForValue) {
        if (extraMimeContentsBuilder_ == null) {
          ensureExtraMimeContentsIsMutable();
          extraMimeContents_.add(index, builderForValue.build());
          onChanged();
        } else {
          extraMimeContentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllExtraMimeContents(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                          .MimeContent>
              values) {
        if (extraMimeContentsBuilder_ == null) {
          ensureExtraMimeContentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, extraMimeContents_);
          onChanged();
        } else {
          extraMimeContentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearExtraMimeContents() {
        if (extraMimeContentsBuilder_ == null) {
          extraMimeContents_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          extraMimeContentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeExtraMimeContents(int index) {
        if (extraMimeContentsBuilder_ == null) {
          ensureExtraMimeContentsIsMutable();
          extraMimeContents_.remove(index);
          onChanged();
        } else {
          extraMimeContentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              .Builder
          getExtraMimeContentsBuilder(int index) {
        return getExtraMimeContentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
              .MimeContentOrBuilder
          getExtraMimeContentsOrBuilder(int index) {
        if (extraMimeContentsBuilder_ == null) {
          return extraMimeContents_.get(index);
        } else {
          return extraMimeContentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContentOrBuilder>
          getExtraMimeContentsOrBuilderList() {
        if (extraMimeContentsBuilder_ != null) {
          return extraMimeContentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(extraMimeContents_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              .Builder
          addExtraMimeContentsBuilder() {
        return getExtraMimeContentsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
              .Builder
          addExtraMimeContentsBuilder(int index) {
        return getExtraMimeContentsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The mime content from the initial SIP INVITE.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent extra_mime_contents = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                  .Builder>
          getExtraMimeContentsBuilderList() {
        return getExtraMimeContentsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.MimeContent
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                  .MimeContentOrBuilder>
          getExtraMimeContentsFieldBuilder() {
        if (extraMimeContentsBuilder_ == null) {
          extraMimeContentsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContent,
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContent.Builder,
                  com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                      .MimeContentOrBuilder>(
                  extraMimeContents_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          extraMimeContents_ = null;
        }
        return extraMimeContentsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo)
    private static final com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo();
    }

    public static com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TelephonyConnectionInfo> PARSER =
        new com.google.protobuf.AbstractParser<TelephonyConnectionInfo>() {
          @java.lang.Override
          public TelephonyConnectionInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TelephonyConnectionInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TelephonyConnectionInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The unique identifier of this conversation.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The unique identifier of this conversation.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LIFECYCLE_STATE_FIELD_NUMBER = 2;
  private int lifecycleState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the Conversation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Conversation.LifecycleState lifecycle_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for lifecycleState.
   */
  @java.lang.Override
  public int getLifecycleStateValue() {
    return lifecycleState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the Conversation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Conversation.LifecycleState lifecycle_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lifecycleState.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState getLifecycleState() {
    com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState result =
        com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState.forNumber(lifecycleState_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState.UNRECOGNIZED
        : result;
  }

  public static final int CONVERSATION_PROFILE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversationProfile_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Conversation Profile to be used to configure this
   * Conversation. This field cannot be updated.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>
   * string conversation_profile = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The conversationProfile.
   */
  @java.lang.Override
  public java.lang.String getConversationProfile() {
    java.lang.Object ref = conversationProfile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversationProfile_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Conversation Profile to be used to configure this
   * Conversation. This field cannot be updated.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>
   * string conversation_profile = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for conversationProfile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationProfileBytes() {
    java.lang.Object ref = conversationProfile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversationProfile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHONE_NUMBER_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phoneNumber_;
  /**
   *
   *
   * <pre>
   * Output only. Required if the conversation is to be connected over
   * telephony.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the phoneNumber field is set.
   */
  @java.lang.Override
  public boolean hasPhoneNumber() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Required if the conversation is to be connected over
   * telephony.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The phoneNumber.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber getPhoneNumber() {
    return phoneNumber_ == null
        ? com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.getDefaultInstance()
        : phoneNumber_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Required if the conversation is to be connected over
   * telephony.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumberOrBuilder
      getPhoneNumberOrBuilder() {
    return phoneNumber_ == null
        ? com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.getDefaultInstance()
        : phoneNumber_;
  }

  public static final int CONVERSATION_STAGE_FIELD_NUMBER = 7;
  private int conversationStage_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The stage of a conversation. It indicates whether the virtual
   * agent or a human agent is handling the conversation.
   *
   * If the conversation is created with the conversation profile that has
   * Dialogflow config set, defaults to
   * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
   * Otherwise, defaults to
   * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
   *
   * If the conversation is created with the conversation profile that has
   * Dialogflow config set but explicitly sets conversation_stage to
   * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
   * it skips
   * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
   * stage and directly goes to
   * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Conversation.ConversationStage conversation_stage = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for conversationStage.
   */
  @java.lang.Override
  public int getConversationStageValue() {
    return conversationStage_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The stage of a conversation. It indicates whether the virtual
   * agent or a human agent is handling the conversation.
   *
   * If the conversation is created with the conversation profile that has
   * Dialogflow config set, defaults to
   * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
   * Otherwise, defaults to
   * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
   *
   * If the conversation is created with the conversation profile that has
   * Dialogflow config set but explicitly sets conversation_stage to
   * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
   * it skips
   * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
   * stage and directly goes to
   * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Conversation.ConversationStage conversation_stage = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The conversationStage.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage getConversationStage() {
    com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage result =
        com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.forNumber(
            conversationStage_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.UNRECOGNIZED
        : result;
  }

  public static final int START_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the conversation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the conversation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the conversation was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the conversation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the conversation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the conversation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int TELEPHONY_CONNECTION_INFO_FIELD_NUMBER = 10;
  private com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
      telephonyConnectionInfo_;
  /**
   *
   *
   * <pre>
   * Output only. The telephony connection information.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the telephonyConnectionInfo field is set.
   */
  @java.lang.Override
  public boolean hasTelephonyConnectionInfo() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The telephony connection information.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The telephonyConnectionInfo.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
      getTelephonyConnectionInfo() {
    return telephonyConnectionInfo_ == null
        ? com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
            .getDefaultInstance()
        : telephonyConnectionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The telephony connection information.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfoOrBuilder
      getTelephonyConnectionInfoOrBuilder() {
    return telephonyConnectionInfo_ == null
        ? com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
            .getDefaultInstance()
        : telephonyConnectionInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (lifecycleState_
        != com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState
            .LIFECYCLE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, lifecycleState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationProfile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, conversationProfile_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getPhoneNumber());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getEndTime());
    }
    if (conversationStage_
        != com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage
            .CONVERSATION_STAGE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, conversationStage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getTelephonyConnectionInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (lifecycleState_
        != com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState
            .LIFECYCLE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, lifecycleState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationProfile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, conversationProfile_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPhoneNumber());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStartTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEndTime());
    }
    if (conversationStage_
        != com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage
            .CONVERSATION_STAGE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, conversationStage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getTelephonyConnectionInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Conversation)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Conversation other =
        (com.google.cloud.dialogflow.v2beta1.Conversation) obj;

    if (!getName().equals(other.getName())) return false;
    if (lifecycleState_ != other.lifecycleState_) return false;
    if (!getConversationProfile().equals(other.getConversationProfile())) return false;
    if (hasPhoneNumber() != other.hasPhoneNumber()) return false;
    if (hasPhoneNumber()) {
      if (!getPhoneNumber().equals(other.getPhoneNumber())) return false;
    }
    if (conversationStage_ != other.conversationStage_) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasTelephonyConnectionInfo() != other.hasTelephonyConnectionInfo()) return false;
    if (hasTelephonyConnectionInfo()) {
      if (!getTelephonyConnectionInfo().equals(other.getTelephonyConnectionInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LIFECYCLE_STATE_FIELD_NUMBER;
    hash = (53 * hash) + lifecycleState_;
    hash = (37 * hash) + CONVERSATION_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getConversationProfile().hashCode();
    if (hasPhoneNumber()) {
      hash = (37 * hash) + PHONE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getPhoneNumber().hashCode();
    }
    hash = (37 * hash) + CONVERSATION_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + conversationStage_;
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasTelephonyConnectionInfo()) {
      hash = (37 * hash) + TELEPHONY_CONNECTION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getTelephonyConnectionInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Conversation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a conversation.
   * A conversation is an interaction between an agent, including live agents
   * and Dialogflow agents, and a support customer. Conversations can
   * include phone calls and text-based chat sessions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Conversation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Conversation)
      com.google.cloud.dialogflow.v2beta1.ConversationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_Conversation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_Conversation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Conversation.class,
              com.google.cloud.dialogflow.v2beta1.Conversation.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Conversation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPhoneNumberFieldBuilder();
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getTelephonyConnectionInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      lifecycleState_ = 0;
      conversationProfile_ = "";
      phoneNumber_ = null;
      if (phoneNumberBuilder_ != null) {
        phoneNumberBuilder_.dispose();
        phoneNumberBuilder_ = null;
      }
      conversationStage_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      telephonyConnectionInfo_ = null;
      if (telephonyConnectionInfoBuilder_ != null) {
        telephonyConnectionInfoBuilder_.dispose();
        telephonyConnectionInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_Conversation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Conversation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation build() {
      com.google.cloud.dialogflow.v2beta1.Conversation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Conversation result =
          new com.google.cloud.dialogflow.v2beta1.Conversation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Conversation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.lifecycleState_ = lifecycleState_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.conversationProfile_ = conversationProfile_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.phoneNumber_ =
            phoneNumberBuilder_ == null ? phoneNumber_ : phoneNumberBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.conversationStage_ = conversationStage_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.telephonyConnectionInfo_ =
            telephonyConnectionInfoBuilder_ == null
                ? telephonyConnectionInfo_
                : telephonyConnectionInfoBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Conversation) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Conversation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Conversation other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Conversation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.lifecycleState_ != 0) {
        setLifecycleStateValue(other.getLifecycleStateValue());
      }
      if (!other.getConversationProfile().isEmpty()) {
        conversationProfile_ = other.conversationProfile_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasPhoneNumber()) {
        mergePhoneNumber(other.getPhoneNumber());
      }
      if (other.conversationStage_ != 0) {
        setConversationStageValue(other.getConversationStageValue());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasTelephonyConnectionInfo()) {
        mergeTelephonyConnectionInfo(other.getTelephonyConnectionInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                lifecycleState_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                conversationProfile_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPhoneNumberFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 56:
              {
                conversationStage_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 56
            case 82:
              {
                input.readMessage(
                    getTelephonyConnectionInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The unique identifier of this conversation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The unique identifier of this conversation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The unique identifier of this conversation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The unique identifier of this conversation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The unique identifier of this conversation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int lifecycleState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.LifecycleState lifecycle_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for lifecycleState.
     */
    @java.lang.Override
    public int getLifecycleStateValue() {
      return lifecycleState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.LifecycleState lifecycle_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleStateValue(int value) {
      lifecycleState_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.LifecycleState lifecycle_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lifecycleState.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState getLifecycleState() {
      com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState result =
          com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState.forNumber(
              lifecycleState_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.LifecycleState lifecycle_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleState(
        com.google.cloud.dialogflow.v2beta1.Conversation.LifecycleState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      lifecycleState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the Conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.LifecycleState lifecycle_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLifecycleState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      lifecycleState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object conversationProfile_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to be used to configure this
     * Conversation. This field cannot be updated.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>
     * string conversation_profile = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The conversationProfile.
     */
    public java.lang.String getConversationProfile() {
      java.lang.Object ref = conversationProfile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversationProfile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to be used to configure this
     * Conversation. This field cannot be updated.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>
     * string conversation_profile = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for conversationProfile.
     */
    public com.google.protobuf.ByteString getConversationProfileBytes() {
      java.lang.Object ref = conversationProfile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversationProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to be used to configure this
     * Conversation. This field cannot be updated.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>
     * string conversation_profile = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The conversationProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConversationProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversationProfile_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to be used to configure this
     * Conversation. This field cannot be updated.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>
     * string conversation_profile = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationProfile() {
      conversationProfile_ = getDefaultInstance().getConversationProfile();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to be used to configure this
     * Conversation. This field cannot be updated.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>
     * string conversation_profile = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for conversationProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConversationProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversationProfile_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phoneNumber_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber,
            com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.Builder,
            com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumberOrBuilder>
        phoneNumberBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the phoneNumber field is set.
     */
    public boolean hasPhoneNumber() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The phoneNumber.
     */
    public com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber getPhoneNumber() {
      if (phoneNumberBuilder_ == null) {
        return phoneNumber_ == null
            ? com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.getDefaultInstance()
            : phoneNumber_;
      } else {
        return phoneNumberBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPhoneNumber(
        com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber value) {
      if (phoneNumberBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        phoneNumber_ = value;
      } else {
        phoneNumberBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPhoneNumber(
        com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.Builder builderForValue) {
      if (phoneNumberBuilder_ == null) {
        phoneNumber_ = builderForValue.build();
      } else {
        phoneNumberBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePhoneNumber(
        com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber value) {
      if (phoneNumberBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && phoneNumber_ != null
            && phoneNumber_
                != com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber
                    .getDefaultInstance()) {
          getPhoneNumberBuilder().mergeFrom(value);
        } else {
          phoneNumber_ = value;
        }
      } else {
        phoneNumberBuilder_.mergeFrom(value);
      }
      if (phoneNumber_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPhoneNumber() {
      bitField0_ = (bitField0_ & ~0x00000008);
      phoneNumber_ = null;
      if (phoneNumberBuilder_ != null) {
        phoneNumberBuilder_.dispose();
        phoneNumberBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.Builder
        getPhoneNumberBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPhoneNumberFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumberOrBuilder
        getPhoneNumberOrBuilder() {
      if (phoneNumberBuilder_ != null) {
        return phoneNumberBuilder_.getMessageOrBuilder();
      } else {
        return phoneNumber_ == null
            ? com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.getDefaultInstance()
            : phoneNumber_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Required if the conversation is to be connected over
     * telephony.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.ConversationPhoneNumber phone_number = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber,
            com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.Builder,
            com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumberOrBuilder>
        getPhoneNumberFieldBuilder() {
      if (phoneNumberBuilder_ == null) {
        phoneNumberBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber,
                com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumber.Builder,
                com.google.cloud.dialogflow.v2beta1.ConversationPhoneNumberOrBuilder>(
                getPhoneNumber(), getParentForChildren(), isClean());
        phoneNumber_ = null;
      }
      return phoneNumberBuilder_;
    }

    private int conversationStage_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The stage of a conversation. It indicates whether the virtual
     * agent or a human agent is handling the conversation.
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set, defaults to
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
     * Otherwise, defaults to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set but explicitly sets conversation_stage to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
     * it skips
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
     * stage and directly goes to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.ConversationStage conversation_stage = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for conversationStage.
     */
    @java.lang.Override
    public int getConversationStageValue() {
      return conversationStage_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The stage of a conversation. It indicates whether the virtual
     * agent or a human agent is handling the conversation.
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set, defaults to
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
     * Otherwise, defaults to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set but explicitly sets conversation_stage to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
     * it skips
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
     * stage and directly goes to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.ConversationStage conversation_stage = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for conversationStage to set.
     * @return This builder for chaining.
     */
    public Builder setConversationStageValue(int value) {
      conversationStage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The stage of a conversation. It indicates whether the virtual
     * agent or a human agent is handling the conversation.
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set, defaults to
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
     * Otherwise, defaults to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set but explicitly sets conversation_stage to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
     * it skips
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
     * stage and directly goes to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.ConversationStage conversation_stage = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The conversationStage.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage
        getConversationStage() {
      com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage result =
          com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.forNumber(
              conversationStage_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The stage of a conversation. It indicates whether the virtual
     * agent or a human agent is handling the conversation.
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set, defaults to
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
     * Otherwise, defaults to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set but explicitly sets conversation_stage to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
     * it skips
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
     * stage and directly goes to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.ConversationStage conversation_stage = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The conversationStage to set.
     * @return This builder for chaining.
     */
    public Builder setConversationStage(
        com.google.cloud.dialogflow.v2beta1.Conversation.ConversationStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      conversationStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The stage of a conversation. It indicates whether the virtual
     * agent or a human agent is handling the conversation.
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set, defaults to
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE];
     * Otherwise, defaults to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     *
     * If the conversation is created with the conversation profile that has
     * Dialogflow config set but explicitly sets conversation_stage to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE],
     * it skips
     * [ConversationStage.VIRTUAL_AGENT_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.VIRTUAL_AGENT_STAGE]
     * stage and directly goes to
     * [ConversationStage.HUMAN_ASSIST_STAGE][google.cloud.dialogflow.v2beta1.Conversation.ConversationStage.HUMAN_ASSIST_STAGE].
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.ConversationStage conversation_stage = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationStage() {
      bitField0_ = (bitField0_ & ~0x00000010);
      conversationStage_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the conversation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        telephonyConnectionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo,
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.Builder,
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfoOrBuilder>
        telephonyConnectionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the telephonyConnectionInfo field is set.
     */
    public boolean hasTelephonyConnectionInfo() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The telephonyConnectionInfo.
     */
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
        getTelephonyConnectionInfo() {
      if (telephonyConnectionInfoBuilder_ == null) {
        return telephonyConnectionInfo_ == null
            ? com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                .getDefaultInstance()
            : telephonyConnectionInfo_;
      } else {
        return telephonyConnectionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTelephonyConnectionInfo(
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo value) {
      if (telephonyConnectionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        telephonyConnectionInfo_ = value;
      } else {
        telephonyConnectionInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTelephonyConnectionInfo(
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.Builder
            builderForValue) {
      if (telephonyConnectionInfoBuilder_ == null) {
        telephonyConnectionInfo_ = builderForValue.build();
      } else {
        telephonyConnectionInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTelephonyConnectionInfo(
        com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo value) {
      if (telephonyConnectionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && telephonyConnectionInfo_ != null
            && telephonyConnectionInfo_
                != com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                    .getDefaultInstance()) {
          getTelephonyConnectionInfoBuilder().mergeFrom(value);
        } else {
          telephonyConnectionInfo_ = value;
        }
      } else {
        telephonyConnectionInfoBuilder_.mergeFrom(value);
      }
      if (telephonyConnectionInfo_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTelephonyConnectionInfo() {
      bitField0_ = (bitField0_ & ~0x00000080);
      telephonyConnectionInfo_ = null;
      if (telephonyConnectionInfoBuilder_ != null) {
        telephonyConnectionInfoBuilder_.dispose();
        telephonyConnectionInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.Builder
        getTelephonyConnectionInfoBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getTelephonyConnectionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfoOrBuilder
        getTelephonyConnectionInfoOrBuilder() {
      if (telephonyConnectionInfoBuilder_ != null) {
        return telephonyConnectionInfoBuilder_.getMessageOrBuilder();
      } else {
        return telephonyConnectionInfo_ == null
            ? com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo
                .getDefaultInstance()
            : telephonyConnectionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The telephony connection information.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo telephony_connection_info = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo,
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.Builder,
            com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfoOrBuilder>
        getTelephonyConnectionInfoFieldBuilder() {
      if (telephonyConnectionInfoBuilder_ == null) {
        telephonyConnectionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo,
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfo.Builder,
                com.google.cloud.dialogflow.v2beta1.Conversation.TelephonyConnectionInfoOrBuilder>(
                getTelephonyConnectionInfo(), getParentForChildren(), isClean());
        telephonyConnectionInfo_ = null;
      }
      return telephonyConnectionInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Conversation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Conversation)
  private static final com.google.cloud.dialogflow.v2beta1.Conversation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Conversation();
  }

  public static com.google.cloud.dialogflow.v2beta1.Conversation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Conversation> PARSER =
      new com.google.protobuf.AbstractParser<Conversation>() {
        @java.lang.Override
        public Conversation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Conversation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Conversation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Conversation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
