/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/generator.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents the section of summarization.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.SummarizationSection}
 */
public final class SummarizationSection extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.SummarizationSection)
    SummarizationSectionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SummarizationSection.newBuilder() to construct.
  private SummarizationSection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SummarizationSection() {
    key_ = "";
    definition_ = "";
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SummarizationSection();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2beta1_SummarizationSection_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2beta1_SummarizationSection_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.SummarizationSection.class,
            com.google.cloud.dialogflow.v2beta1.SummarizationSection.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type enum of the summarization sections.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.SummarizationSection.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Undefined section type, does not return anything.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * What the customer needs help with or has question about.
     * Section name: "situation".
     * </pre>
     *
     * <code>SITUATION = 1;</code>
     */
    SITUATION(1),
    /**
     *
     *
     * <pre>
     * What the agent does to help the customer.
     * Section name: "action".
     * </pre>
     *
     * <code>ACTION = 2;</code>
     */
    ACTION(2),
    /**
     *
     *
     * <pre>
     * Result of the customer service. A single word describing the result
     * of the conversation.
     * Section name: "resolution".
     * </pre>
     *
     * <code>RESOLUTION = 3;</code>
     */
    RESOLUTION(3),
    /**
     *
     *
     * <pre>
     * Reason for cancellation if the customer requests for a cancellation.
     * "N/A" otherwise.
     * Section name: "reason_for_cancellation".
     * </pre>
     *
     * <code>REASON_FOR_CANCELLATION = 4;</code>
     */
    REASON_FOR_CANCELLATION(4),
    /**
     *
     *
     * <pre>
     * "Unsatisfied" or "Satisfied" depending on the customer's feelings at
     * the end of the conversation.
     * Section name: "customer_satisfaction".
     * </pre>
     *
     * <code>CUSTOMER_SATISFACTION = 5;</code>
     */
    CUSTOMER_SATISFACTION(5),
    /**
     *
     *
     * <pre>
     * Key entities extracted from the conversation, such as ticket number,
     * order number, dollar amount, etc.
     * Section names are prefixed by "entities/".
     * </pre>
     *
     * <code>ENTITIES = 6;</code>
     */
    ENTITIES(6),
    /**
     *
     *
     * <pre>
     * Customer defined sections.
     * </pre>
     *
     * <code>CUSTOMER_DEFINED = 7;</code>
     */
    CUSTOMER_DEFINED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Undefined section type, does not return anything.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * What the customer needs help with or has question about.
     * Section name: "situation".
     * </pre>
     *
     * <code>SITUATION = 1;</code>
     */
    public static final int SITUATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * What the agent does to help the customer.
     * Section name: "action".
     * </pre>
     *
     * <code>ACTION = 2;</code>
     */
    public static final int ACTION_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Result of the customer service. A single word describing the result
     * of the conversation.
     * Section name: "resolution".
     * </pre>
     *
     * <code>RESOLUTION = 3;</code>
     */
    public static final int RESOLUTION_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Reason for cancellation if the customer requests for a cancellation.
     * "N/A" otherwise.
     * Section name: "reason_for_cancellation".
     * </pre>
     *
     * <code>REASON_FOR_CANCELLATION = 4;</code>
     */
    public static final int REASON_FOR_CANCELLATION_VALUE = 4;
    /**
     *
     *
     * <pre>
     * "Unsatisfied" or "Satisfied" depending on the customer's feelings at
     * the end of the conversation.
     * Section name: "customer_satisfaction".
     * </pre>
     *
     * <code>CUSTOMER_SATISFACTION = 5;</code>
     */
    public static final int CUSTOMER_SATISFACTION_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Key entities extracted from the conversation, such as ticket number,
     * order number, dollar amount, etc.
     * Section names are prefixed by "entities/".
     * </pre>
     *
     * <code>ENTITIES = 6;</code>
     */
    public static final int ENTITIES_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Customer defined sections.
     * </pre>
     *
     * <code>CUSTOMER_DEFINED = 7;</code>
     */
    public static final int CUSTOMER_DEFINED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return SITUATION;
        case 2:
          return ACTION;
        case 3:
          return RESOLUTION;
        case 4:
          return REASON_FOR_CANCELLATION;
        case 5:
          return CUSTOMER_SATISFACTION;
        case 6:
          return ENTITIES;
        case 7:
          return CUSTOMER_DEFINED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SummarizationSection.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.SummarizationSection.Type)
  }

  public static final int KEY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object key_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Name of the section, for example, "situation".
   * </pre>
   *
   * <code>string key = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The key.
   */
  @java.lang.Override
  public java.lang.String getKey() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      key_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Name of the section, for example, "situation".
   * </pre>
   *
   * <code>string key = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for key.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyBytes() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      key_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFINITION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object definition_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Definition of the section, for example, "what the customer needs
   * help with or has question about."
   * </pre>
   *
   * <code>string definition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The definition.
   */
  @java.lang.Override
  public java.lang.String getDefinition() {
    java.lang.Object ref = definition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      definition_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Definition of the section, for example, "what the customer needs
   * help with or has question about."
   * </pre>
   *
   * <code>string definition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for definition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefinitionBytes() {
    java.lang.Object ref = definition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      definition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Type of the summarization section.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SummarizationSection.Type type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Type of the summarization section.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SummarizationSection.Type type = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type getType() {
    com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type result =
        com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(definition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, definition_);
    }
    if (type_
        != com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(definition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, definition_);
    }
    if (type_
        != com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.SummarizationSection)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.SummarizationSection other =
        (com.google.cloud.dialogflow.v2beta1.SummarizationSection) obj;

    if (!getKey().equals(other.getKey())) return false;
    if (!getDefinition().equals(other.getDefinition())) return false;
    if (type_ != other.type_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKey().hashCode();
    hash = (37 * hash) + DEFINITION_FIELD_NUMBER;
    hash = (53 * hash) + getDefinition().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.SummarizationSection prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the section of summarization.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.SummarizationSection}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.SummarizationSection)
      com.google.cloud.dialogflow.v2beta1.SummarizationSectionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2beta1_SummarizationSection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2beta1_SummarizationSection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.SummarizationSection.class,
              com.google.cloud.dialogflow.v2beta1.SummarizationSection.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.SummarizationSection.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      key_ = "";
      definition_ = "";
      type_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2beta1_SummarizationSection_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SummarizationSection getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.SummarizationSection.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SummarizationSection build() {
      com.google.cloud.dialogflow.v2beta1.SummarizationSection result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SummarizationSection buildPartial() {
      com.google.cloud.dialogflow.v2beta1.SummarizationSection result =
          new com.google.cloud.dialogflow.v2beta1.SummarizationSection(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.SummarizationSection result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.key_ = key_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.definition_ = definition_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.type_ = type_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.SummarizationSection) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.SummarizationSection) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.SummarizationSection other) {
      if (other == com.google.cloud.dialogflow.v2beta1.SummarizationSection.getDefaultInstance())
        return this;
      if (!other.getKey().isEmpty()) {
        key_ = other.key_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDefinition().isEmpty()) {
        definition_ = other.definition_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                key_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                definition_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the section, for example, "situation".
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The key.
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the section, for example, "situation".
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for key.
     */
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the section, for example, "situation".
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The key to set.
     * @return This builder for chaining.
     */
    public Builder setKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      key_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the section, for example, "situation".
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKey() {
      key_ = getDefaultInstance().getKey();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the section, for example, "situation".
     * </pre>
     *
     * <code>string key = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for key to set.
     * @return This builder for chaining.
     */
    public Builder setKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      key_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object definition_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Definition of the section, for example, "what the customer needs
     * help with or has question about."
     * </pre>
     *
     * <code>string definition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The definition.
     */
    public java.lang.String getDefinition() {
      java.lang.Object ref = definition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        definition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Definition of the section, for example, "what the customer needs
     * help with or has question about."
     * </pre>
     *
     * <code>string definition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for definition.
     */
    public com.google.protobuf.ByteString getDefinitionBytes() {
      java.lang.Object ref = definition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        definition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Definition of the section, for example, "what the customer needs
     * help with or has question about."
     * </pre>
     *
     * <code>string definition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The definition to set.
     * @return This builder for chaining.
     */
    public Builder setDefinition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      definition_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Definition of the section, for example, "what the customer needs
     * help with or has question about."
     * </pre>
     *
     * <code>string definition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefinition() {
      definition_ = getDefaultInstance().getDefinition();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Definition of the section, for example, "what the customer needs
     * help with or has question about."
     * </pre>
     *
     * <code>string definition = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for definition to set.
     * @return This builder for chaining.
     */
    public Builder setDefinitionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      definition_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Type of the summarization section.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SummarizationSection.Type type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the summarization section.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SummarizationSection.Type type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the summarization section.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SummarizationSection.Type type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type getType() {
      com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type result =
          com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the summarization section.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SummarizationSection.Type type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.dialogflow.v2beta1.SummarizationSection.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the summarization section.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SummarizationSection.Type type = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      type_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.SummarizationSection)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.SummarizationSection)
  private static final com.google.cloud.dialogflow.v2beta1.SummarizationSection DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.SummarizationSection();
  }

  public static com.google.cloud.dialogflow.v2beta1.SummarizationSection getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SummarizationSection> PARSER =
      new com.google.protobuf.AbstractParser<SummarizationSection>() {
        @java.lang.Override
        public SummarizationSection parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SummarizationSection> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SummarizationSection> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SummarizationSection getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
