/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/generator.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * LLM generator.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Generator}
 */
public final class Generator extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Generator)
    GeneratorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Generator.newBuilder() to construct.
  private Generator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Generator() {
    name_ = "";
    description_ = "";
    triggerEvent_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Generator();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2beta1_Generator_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2beta1_Generator_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Generator.class,
            com.google.cloud.dialogflow.v2beta1.Generator.Builder.class);
  }

  private int bitField0_;
  private int contextCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object context_;

  public enum ContextCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FREE_FORM_CONTEXT(11),
    SUMMARIZATION_CONTEXT(13),
    CONTEXT_NOT_SET(0);
    private final int value;

    private ContextCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContextCase valueOf(int value) {
      return forNumber(value);
    }

    public static ContextCase forNumber(int value) {
      switch (value) {
        case 11:
          return FREE_FORM_CONTEXT;
        case 13:
          return SUMMARIZATION_CONTEXT;
        case 0:
          return CONTEXT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ContextCase getContextCase() {
    return ContextCase.forNumber(contextCase_);
  }

  private int foundationModelCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object foundationModel_;

  public enum FoundationModelCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PUBLISHED_MODEL(15),
    FOUNDATIONMODEL_NOT_SET(0);
    private final int value;

    private FoundationModelCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FoundationModelCase valueOf(int value) {
      return forNumber(value);
    }

    public static FoundationModelCase forNumber(int value) {
      switch (value) {
        case 15:
          return PUBLISHED_MODEL;
        case 0:
          return FOUNDATIONMODEL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FoundationModelCase getFoundationModelCase() {
    return FoundationModelCase.forNumber(foundationModelCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The resource name of the generator. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Identifier. The resource name of the generator. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Human readable description of the generator.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Human readable description of the generator.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FREE_FORM_CONTEXT_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Input of free from generator to LLM.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
   *
   * @return Whether the freeFormContext field is set.
   */
  @java.lang.Override
  public boolean hasFreeFormContext() {
    return contextCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Input of free from generator to LLM.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
   *
   * @return The freeFormContext.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.FreeFormContext getFreeFormContext() {
    if (contextCase_ == 11) {
      return (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_;
    }
    return com.google.cloud.dialogflow.v2beta1.FreeFormContext.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input of free from generator to LLM.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.FreeFormContextOrBuilder
      getFreeFormContextOrBuilder() {
    if (contextCase_ == 11) {
      return (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_;
    }
    return com.google.cloud.dialogflow.v2beta1.FreeFormContext.getDefaultInstance();
  }

  public static final int SUMMARIZATION_CONTEXT_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Input of Summarization feature.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;</code>
   *
   * @return Whether the summarizationContext field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationContext() {
    return contextCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Input of Summarization feature.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;</code>
   *
   * @return The summarizationContext.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SummarizationContext getSummarizationContext() {
    if (contextCase_ == 13) {
      return (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_;
    }
    return com.google.cloud.dialogflow.v2beta1.SummarizationContext.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input of Summarization feature.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SummarizationContextOrBuilder
      getSummarizationContextOrBuilder() {
    if (contextCase_ == 13) {
      return (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_;
    }
    return com.google.cloud.dialogflow.v2beta1.SummarizationContext.getDefaultInstance();
  }

  public static final int INFERENCE_PARAMETER_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2beta1.InferenceParameter inferenceParameter_;
  /**
   *
   *
   * <pre>
   * Optional. Inference parameters for this generator.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the inferenceParameter field is set.
   */
  @java.lang.Override
  public boolean hasInferenceParameter() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Inference parameters for this generator.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The inferenceParameter.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InferenceParameter getInferenceParameter() {
    return inferenceParameter_ == null
        ? com.google.cloud.dialogflow.v2beta1.InferenceParameter.getDefaultInstance()
        : inferenceParameter_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Inference parameters for this generator.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InferenceParameterOrBuilder
      getInferenceParameterOrBuilder() {
    return inferenceParameter_ == null
        ? com.google.cloud.dialogflow.v2beta1.InferenceParameter.getDefaultInstance()
        : inferenceParameter_;
  }

  public static final int TRIGGER_EVENT_FIELD_NUMBER = 5;
  private int triggerEvent_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The trigger event of the generator. It defines when the generator
   * is triggered in a conversation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_event = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for triggerEvent.
   */
  @java.lang.Override
  public int getTriggerEventValue() {
    return triggerEvent_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The trigger event of the generator. It defines when the generator
   * is triggered in a conversation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_event = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The triggerEvent.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TriggerEvent getTriggerEvent() {
    com.google.cloud.dialogflow.v2beta1.TriggerEvent result =
        com.google.cloud.dialogflow.v2beta1.TriggerEvent.forNumber(triggerEvent_);
    return result == null ? com.google.cloud.dialogflow.v2beta1.TriggerEvent.UNRECOGNIZED : result;
  }

  public static final int PUBLISHED_MODEL_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Optional. The published Large Language Model name.
   * * To use the latest model version, specify the model name without version
   *   number. Example: `text-bison`
   * * To use a stable model version, specify the version number as well.
   *   Example: `text-bison&#64;002`.
   * </pre>
   *
   * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the publishedModel field is set.
   */
  public boolean hasPublishedModel() {
    return foundationModelCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Optional. The published Large Language Model name.
   * * To use the latest model version, specify the model name without version
   *   number. Example: `text-bison`
   * * To use a stable model version, specify the version number as well.
   *   Example: `text-bison&#64;002`.
   * </pre>
   *
   * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The publishedModel.
   */
  public java.lang.String getPublishedModel() {
    java.lang.Object ref = "";
    if (foundationModelCase_ == 15) {
      ref = foundationModel_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (foundationModelCase_ == 15) {
        foundationModel_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The published Large Language Model name.
   * * To use the latest model version, specify the model name without version
   *   number. Example: `text-bison`
   * * To use a stable model version, specify the version number as well.
   *   Example: `text-bison&#64;002`.
   * </pre>
   *
   * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for publishedModel.
   */
  public com.google.protobuf.ByteString getPublishedModelBytes() {
    java.lang.Object ref = "";
    if (foundationModelCase_ == 15) {
      ref = foundationModel_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (foundationModelCase_ == 15) {
        foundationModel_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this generator.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this generator.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this generator.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update time of this generator.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of this generator.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of this generator.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getInferenceParameter());
    }
    if (triggerEvent_
        != com.google.cloud.dialogflow.v2beta1.TriggerEvent.TRIGGER_EVENT_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, triggerEvent_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getUpdateTime());
    }
    if (contextCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_);
    }
    if (contextCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_);
    }
    if (foundationModelCase_ == 15) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, foundationModel_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInferenceParameter());
    }
    if (triggerEvent_
        != com.google.cloud.dialogflow.v2beta1.TriggerEvent.TRIGGER_EVENT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, triggerEvent_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    if (contextCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_);
    }
    if (contextCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_);
    }
    if (foundationModelCase_ == 15) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, foundationModel_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Generator)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Generator other =
        (com.google.cloud.dialogflow.v2beta1.Generator) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasInferenceParameter() != other.hasInferenceParameter()) return false;
    if (hasInferenceParameter()) {
      if (!getInferenceParameter().equals(other.getInferenceParameter())) return false;
    }
    if (triggerEvent_ != other.triggerEvent_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getContextCase().equals(other.getContextCase())) return false;
    switch (contextCase_) {
      case 11:
        if (!getFreeFormContext().equals(other.getFreeFormContext())) return false;
        break;
      case 13:
        if (!getSummarizationContext().equals(other.getSummarizationContext())) return false;
        break;
      case 0:
      default:
    }
    if (!getFoundationModelCase().equals(other.getFoundationModelCase())) return false;
    switch (foundationModelCase_) {
      case 15:
        if (!getPublishedModel().equals(other.getPublishedModel())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasInferenceParameter()) {
      hash = (37 * hash) + INFERENCE_PARAMETER_FIELD_NUMBER;
      hash = (53 * hash) + getInferenceParameter().hashCode();
    }
    hash = (37 * hash) + TRIGGER_EVENT_FIELD_NUMBER;
    hash = (53 * hash) + triggerEvent_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (contextCase_) {
      case 11:
        hash = (37 * hash) + FREE_FORM_CONTEXT_FIELD_NUMBER;
        hash = (53 * hash) + getFreeFormContext().hashCode();
        break;
      case 13:
        hash = (37 * hash) + SUMMARIZATION_CONTEXT_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationContext().hashCode();
        break;
      case 0:
      default:
    }
    switch (foundationModelCase_) {
      case 15:
        hash = (37 * hash) + PUBLISHED_MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getPublishedModel().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Generator prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * LLM generator.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Generator}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Generator)
      com.google.cloud.dialogflow.v2beta1.GeneratorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2beta1_Generator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2beta1_Generator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Generator.class,
              com.google.cloud.dialogflow.v2beta1.Generator.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Generator.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInferenceParameterFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      if (freeFormContextBuilder_ != null) {
        freeFormContextBuilder_.clear();
      }
      if (summarizationContextBuilder_ != null) {
        summarizationContextBuilder_.clear();
      }
      inferenceParameter_ = null;
      if (inferenceParameterBuilder_ != null) {
        inferenceParameterBuilder_.dispose();
        inferenceParameterBuilder_ = null;
      }
      triggerEvent_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      contextCase_ = 0;
      context_ = null;
      foundationModelCase_ = 0;
      foundationModel_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2beta1_Generator_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Generator getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Generator.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Generator build() {
      com.google.cloud.dialogflow.v2beta1.Generator result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Generator buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Generator result =
          new com.google.cloud.dialogflow.v2beta1.Generator(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Generator result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.inferenceParameter_ =
            inferenceParameterBuilder_ == null
                ? inferenceParameter_
                : inferenceParameterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.triggerEvent_ = triggerEvent_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.v2beta1.Generator result) {
      result.contextCase_ = contextCase_;
      result.context_ = this.context_;
      if (contextCase_ == 11 && freeFormContextBuilder_ != null) {
        result.context_ = freeFormContextBuilder_.build();
      }
      if (contextCase_ == 13 && summarizationContextBuilder_ != null) {
        result.context_ = summarizationContextBuilder_.build();
      }
      result.foundationModelCase_ = foundationModelCase_;
      result.foundationModel_ = this.foundationModel_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Generator) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Generator) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Generator other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Generator.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasInferenceParameter()) {
        mergeInferenceParameter(other.getInferenceParameter());
      }
      if (other.triggerEvent_ != 0) {
        setTriggerEventValue(other.getTriggerEventValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getContextCase()) {
        case FREE_FORM_CONTEXT:
          {
            mergeFreeFormContext(other.getFreeFormContext());
            break;
          }
        case SUMMARIZATION_CONTEXT:
          {
            mergeSummarizationContext(other.getSummarizationContext());
            break;
          }
        case CONTEXT_NOT_SET:
          {
            break;
          }
      }
      switch (other.getFoundationModelCase()) {
        case PUBLISHED_MODEL:
          {
            foundationModelCase_ = 15;
            foundationModel_ = other.foundationModel_;
            onChanged();
            break;
          }
        case FOUNDATIONMODEL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(
                    getInferenceParameterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                triggerEvent_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(getFreeFormContextFieldBuilder().getBuilder(), extensionRegistry);
                contextCase_ = 11;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(
                    getSummarizationContextFieldBuilder().getBuilder(), extensionRegistry);
                contextCase_ = 13;
                break;
              } // case 106
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                foundationModelCase_ = 15;
                foundationModel_ = s;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int contextCase_ = 0;
    private java.lang.Object context_;

    public ContextCase getContextCase() {
      return ContextCase.forNumber(contextCase_);
    }

    public Builder clearContext() {
      contextCase_ = 0;
      context_ = null;
      onChanged();
      return this;
    }

    private int foundationModelCase_ = 0;
    private java.lang.Object foundationModel_;

    public FoundationModelCase getFoundationModelCase() {
      return FoundationModelCase.forNumber(foundationModelCase_);
    }

    public Builder clearFoundationModel() {
      foundationModelCase_ = 0;
      foundationModel_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier. The resource name of the generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IDENTIFIER, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Human readable description of the generator.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Human readable description of the generator.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Human readable description of the generator.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Human readable description of the generator.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Human readable description of the generator.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.FreeFormContext,
            com.google.cloud.dialogflow.v2beta1.FreeFormContext.Builder,
            com.google.cloud.dialogflow.v2beta1.FreeFormContextOrBuilder>
        freeFormContextBuilder_;
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     *
     * @return Whether the freeFormContext field is set.
     */
    @java.lang.Override
    public boolean hasFreeFormContext() {
      return contextCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     *
     * @return The freeFormContext.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.FreeFormContext getFreeFormContext() {
      if (freeFormContextBuilder_ == null) {
        if (contextCase_ == 11) {
          return (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_;
        }
        return com.google.cloud.dialogflow.v2beta1.FreeFormContext.getDefaultInstance();
      } else {
        if (contextCase_ == 11) {
          return freeFormContextBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.FreeFormContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     */
    public Builder setFreeFormContext(com.google.cloud.dialogflow.v2beta1.FreeFormContext value) {
      if (freeFormContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        freeFormContextBuilder_.setMessage(value);
      }
      contextCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     */
    public Builder setFreeFormContext(
        com.google.cloud.dialogflow.v2beta1.FreeFormContext.Builder builderForValue) {
      if (freeFormContextBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        freeFormContextBuilder_.setMessage(builderForValue.build());
      }
      contextCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     */
    public Builder mergeFreeFormContext(com.google.cloud.dialogflow.v2beta1.FreeFormContext value) {
      if (freeFormContextBuilder_ == null) {
        if (contextCase_ == 11
            && context_
                != com.google.cloud.dialogflow.v2beta1.FreeFormContext.getDefaultInstance()) {
          context_ =
              com.google.cloud.dialogflow.v2beta1.FreeFormContext.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        if (contextCase_ == 11) {
          freeFormContextBuilder_.mergeFrom(value);
        } else {
          freeFormContextBuilder_.setMessage(value);
        }
      }
      contextCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     */
    public Builder clearFreeFormContext() {
      if (freeFormContextBuilder_ == null) {
        if (contextCase_ == 11) {
          contextCase_ = 0;
          context_ = null;
          onChanged();
        }
      } else {
        if (contextCase_ == 11) {
          contextCase_ = 0;
          context_ = null;
        }
        freeFormContextBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.FreeFormContext.Builder getFreeFormContextBuilder() {
      return getFreeFormContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.FreeFormContextOrBuilder
        getFreeFormContextOrBuilder() {
      if ((contextCase_ == 11) && (freeFormContextBuilder_ != null)) {
        return freeFormContextBuilder_.getMessageOrBuilder();
      } else {
        if (contextCase_ == 11) {
          return (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_;
        }
        return com.google.cloud.dialogflow.v2beta1.FreeFormContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input of free from generator to LLM.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.FreeFormContext free_form_context = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.FreeFormContext,
            com.google.cloud.dialogflow.v2beta1.FreeFormContext.Builder,
            com.google.cloud.dialogflow.v2beta1.FreeFormContextOrBuilder>
        getFreeFormContextFieldBuilder() {
      if (freeFormContextBuilder_ == null) {
        if (!(contextCase_ == 11)) {
          context_ = com.google.cloud.dialogflow.v2beta1.FreeFormContext.getDefaultInstance();
        }
        freeFormContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.FreeFormContext,
                com.google.cloud.dialogflow.v2beta1.FreeFormContext.Builder,
                com.google.cloud.dialogflow.v2beta1.FreeFormContextOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.FreeFormContext) context_,
                getParentForChildren(),
                isClean());
        context_ = null;
      }
      contextCase_ = 11;
      onChanged();
      return freeFormContextBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SummarizationContext,
            com.google.cloud.dialogflow.v2beta1.SummarizationContext.Builder,
            com.google.cloud.dialogflow.v2beta1.SummarizationContextOrBuilder>
        summarizationContextBuilder_;
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     *
     * @return Whether the summarizationContext field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationContext() {
      return contextCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     *
     * @return The summarizationContext.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SummarizationContext getSummarizationContext() {
      if (summarizationContextBuilder_ == null) {
        if (contextCase_ == 13) {
          return (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_;
        }
        return com.google.cloud.dialogflow.v2beta1.SummarizationContext.getDefaultInstance();
      } else {
        if (contextCase_ == 13) {
          return summarizationContextBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.SummarizationContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     */
    public Builder setSummarizationContext(
        com.google.cloud.dialogflow.v2beta1.SummarizationContext value) {
      if (summarizationContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        summarizationContextBuilder_.setMessage(value);
      }
      contextCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     */
    public Builder setSummarizationContext(
        com.google.cloud.dialogflow.v2beta1.SummarizationContext.Builder builderForValue) {
      if (summarizationContextBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        summarizationContextBuilder_.setMessage(builderForValue.build());
      }
      contextCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     */
    public Builder mergeSummarizationContext(
        com.google.cloud.dialogflow.v2beta1.SummarizationContext value) {
      if (summarizationContextBuilder_ == null) {
        if (contextCase_ == 13
            && context_
                != com.google.cloud.dialogflow.v2beta1.SummarizationContext.getDefaultInstance()) {
          context_ =
              com.google.cloud.dialogflow.v2beta1.SummarizationContext.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        if (contextCase_ == 13) {
          summarizationContextBuilder_.mergeFrom(value);
        } else {
          summarizationContextBuilder_.setMessage(value);
        }
      }
      contextCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     */
    public Builder clearSummarizationContext() {
      if (summarizationContextBuilder_ == null) {
        if (contextCase_ == 13) {
          contextCase_ = 0;
          context_ = null;
          onChanged();
        }
      } else {
        if (contextCase_ == 13) {
          contextCase_ = 0;
          context_ = null;
        }
        summarizationContextBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SummarizationContext.Builder
        getSummarizationContextBuilder() {
      return getSummarizationContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SummarizationContextOrBuilder
        getSummarizationContextOrBuilder() {
      if ((contextCase_ == 13) && (summarizationContextBuilder_ != null)) {
        return summarizationContextBuilder_.getMessageOrBuilder();
      } else {
        if (contextCase_ == 13) {
          return (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_;
        }
        return com.google.cloud.dialogflow.v2beta1.SummarizationContext.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input of Summarization feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SummarizationContext summarization_context = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SummarizationContext,
            com.google.cloud.dialogflow.v2beta1.SummarizationContext.Builder,
            com.google.cloud.dialogflow.v2beta1.SummarizationContextOrBuilder>
        getSummarizationContextFieldBuilder() {
      if (summarizationContextBuilder_ == null) {
        if (!(contextCase_ == 13)) {
          context_ = com.google.cloud.dialogflow.v2beta1.SummarizationContext.getDefaultInstance();
        }
        summarizationContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SummarizationContext,
                com.google.cloud.dialogflow.v2beta1.SummarizationContext.Builder,
                com.google.cloud.dialogflow.v2beta1.SummarizationContextOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.SummarizationContext) context_,
                getParentForChildren(),
                isClean());
        context_ = null;
      }
      contextCase_ = 13;
      onChanged();
      return summarizationContextBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.InferenceParameter inferenceParameter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InferenceParameter,
            com.google.cloud.dialogflow.v2beta1.InferenceParameter.Builder,
            com.google.cloud.dialogflow.v2beta1.InferenceParameterOrBuilder>
        inferenceParameterBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the inferenceParameter field is set.
     */
    public boolean hasInferenceParameter() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The inferenceParameter.
     */
    public com.google.cloud.dialogflow.v2beta1.InferenceParameter getInferenceParameter() {
      if (inferenceParameterBuilder_ == null) {
        return inferenceParameter_ == null
            ? com.google.cloud.dialogflow.v2beta1.InferenceParameter.getDefaultInstance()
            : inferenceParameter_;
      } else {
        return inferenceParameterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInferenceParameter(
        com.google.cloud.dialogflow.v2beta1.InferenceParameter value) {
      if (inferenceParameterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inferenceParameter_ = value;
      } else {
        inferenceParameterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInferenceParameter(
        com.google.cloud.dialogflow.v2beta1.InferenceParameter.Builder builderForValue) {
      if (inferenceParameterBuilder_ == null) {
        inferenceParameter_ = builderForValue.build();
      } else {
        inferenceParameterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeInferenceParameter(
        com.google.cloud.dialogflow.v2beta1.InferenceParameter value) {
      if (inferenceParameterBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && inferenceParameter_ != null
            && inferenceParameter_
                != com.google.cloud.dialogflow.v2beta1.InferenceParameter.getDefaultInstance()) {
          getInferenceParameterBuilder().mergeFrom(value);
        } else {
          inferenceParameter_ = value;
        }
      } else {
        inferenceParameterBuilder_.mergeFrom(value);
      }
      if (inferenceParameter_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInferenceParameter() {
      bitField0_ = (bitField0_ & ~0x00000010);
      inferenceParameter_ = null;
      if (inferenceParameterBuilder_ != null) {
        inferenceParameterBuilder_.dispose();
        inferenceParameterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.InferenceParameter.Builder
        getInferenceParameterBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getInferenceParameterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.InferenceParameterOrBuilder
        getInferenceParameterOrBuilder() {
      if (inferenceParameterBuilder_ != null) {
        return inferenceParameterBuilder_.getMessageOrBuilder();
      } else {
        return inferenceParameter_ == null
            ? com.google.cloud.dialogflow.v2beta1.InferenceParameter.getDefaultInstance()
            : inferenceParameter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Inference parameters for this generator.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.InferenceParameter inference_parameter = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InferenceParameter,
            com.google.cloud.dialogflow.v2beta1.InferenceParameter.Builder,
            com.google.cloud.dialogflow.v2beta1.InferenceParameterOrBuilder>
        getInferenceParameterFieldBuilder() {
      if (inferenceParameterBuilder_ == null) {
        inferenceParameterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.InferenceParameter,
                com.google.cloud.dialogflow.v2beta1.InferenceParameter.Builder,
                com.google.cloud.dialogflow.v2beta1.InferenceParameterOrBuilder>(
                getInferenceParameter(), getParentForChildren(), isClean());
        inferenceParameter_ = null;
      }
      return inferenceParameterBuilder_;
    }

    private int triggerEvent_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The trigger event of the generator. It defines when the generator
     * is triggered in a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for triggerEvent.
     */
    @java.lang.Override
    public int getTriggerEventValue() {
      return triggerEvent_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The trigger event of the generator. It defines when the generator
     * is triggered in a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEventValue(int value) {
      triggerEvent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The trigger event of the generator. It defines when the generator
     * is triggered in a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The triggerEvent.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TriggerEvent getTriggerEvent() {
      com.google.cloud.dialogflow.v2beta1.TriggerEvent result =
          com.google.cloud.dialogflow.v2beta1.TriggerEvent.forNumber(triggerEvent_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.TriggerEvent.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The trigger event of the generator. It defines when the generator
     * is triggered in a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The triggerEvent to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEvent(com.google.cloud.dialogflow.v2beta1.TriggerEvent value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      triggerEvent_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The trigger event of the generator. It defines when the generator
     * is triggered in a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_event = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerEvent() {
      bitField0_ = (bitField0_ & ~0x00000020);
      triggerEvent_ = 0;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The published Large Language Model name.
     * * To use the latest model version, specify the model name without version
     *   number. Example: `text-bison`
     * * To use a stable model version, specify the version number as well.
     *   Example: `text-bison&#64;002`.
     * </pre>
     *
     * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the publishedModel field is set.
     */
    @java.lang.Override
    public boolean hasPublishedModel() {
      return foundationModelCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Optional. The published Large Language Model name.
     * * To use the latest model version, specify the model name without version
     *   number. Example: `text-bison`
     * * To use a stable model version, specify the version number as well.
     *   Example: `text-bison&#64;002`.
     * </pre>
     *
     * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The publishedModel.
     */
    @java.lang.Override
    public java.lang.String getPublishedModel() {
      java.lang.Object ref = "";
      if (foundationModelCase_ == 15) {
        ref = foundationModel_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (foundationModelCase_ == 15) {
          foundationModel_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The published Large Language Model name.
     * * To use the latest model version, specify the model name without version
     *   number. Example: `text-bison`
     * * To use a stable model version, specify the version number as well.
     *   Example: `text-bison&#64;002`.
     * </pre>
     *
     * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for publishedModel.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPublishedModelBytes() {
      java.lang.Object ref = "";
      if (foundationModelCase_ == 15) {
        ref = foundationModel_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (foundationModelCase_ == 15) {
          foundationModel_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The published Large Language Model name.
     * * To use the latest model version, specify the model name without version
     *   number. Example: `text-bison`
     * * To use a stable model version, specify the version number as well.
     *   Example: `text-bison&#64;002`.
     * </pre>
     *
     * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The publishedModel to set.
     * @return This builder for chaining.
     */
    public Builder setPublishedModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      foundationModelCase_ = 15;
      foundationModel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The published Large Language Model name.
     * * To use the latest model version, specify the model name without version
     *   number. Example: `text-bison`
     * * To use a stable model version, specify the version number as well.
     *   Example: `text-bison&#64;002`.
     * </pre>
     *
     * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublishedModel() {
      if (foundationModelCase_ == 15) {
        foundationModelCase_ = 0;
        foundationModel_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The published Large Language Model name.
     * * To use the latest model version, specify the model name without version
     *   number. Example: `text-bison`
     * * To use a stable model version, specify the version number as well.
     *   Example: `text-bison&#64;002`.
     * </pre>
     *
     * <code>string published_model = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for publishedModel to set.
     * @return This builder for chaining.
     */
    public Builder setPublishedModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      foundationModelCase_ = 15;
      foundationModel_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of this generator.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Generator)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Generator)
  private static final com.google.cloud.dialogflow.v2beta1.Generator DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Generator();
  }

  public static com.google.cloud.dialogflow.v2beta1.Generator getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Generator> PARSER =
      new com.google.protobuf.AbstractParser<Generator>() {
        @java.lang.Override
        public Generator parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Generator> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Generator> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Generator getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
