/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/audio_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Instructs the speech recognizer on how to process the audio content.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.InputAudioConfig}
 */
public final class InputAudioConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.InputAudioConfig)
    InputAudioConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InputAudioConfig.newBuilder() to construct.
  private InputAudioConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InputAudioConfig() {
    audioEncoding_ = 0;
    languageCode_ = "";
    phraseHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
    speechContexts_ = java.util.Collections.emptyList();
    model_ = "";
    modelVariant_ = 0;
    phraseSets_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InputAudioConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_v2beta1_InputAudioConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_v2beta1_InputAudioConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.class,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder.class);
  }

  private int bitField0_;
  public static final int AUDIO_ENCODING_FIELD_NUMBER = 1;
  private int audioEncoding_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Audio encoding of the audio content to process.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for audioEncoding.
   */
  @java.lang.Override
  public int getAudioEncodingValue() {
    return audioEncoding_;
  }
  /**
   *
   *
   * <pre>
   * Required. Audio encoding of the audio content to process.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The audioEncoding.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AudioEncoding getAudioEncoding() {
    com.google.cloud.dialogflow.v2beta1.AudioEncoding result =
        com.google.cloud.dialogflow.v2beta1.AudioEncoding.forNumber(audioEncoding_);
    return result == null ? com.google.cloud.dialogflow.v2beta1.AudioEncoding.UNRECOGNIZED : result;
  }

  public static final int SAMPLE_RATE_HERTZ_FIELD_NUMBER = 2;
  private int sampleRateHertz_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Sample rate (in Hertz) of the audio content sent in the query.
   * Refer to [Cloud Speech API
   * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
   * more details.
   * </pre>
   *
   * <code>int32 sample_rate_hertz = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sampleRateHertz.
   */
  @java.lang.Override
  public int getSampleRateHertz() {
    return sampleRateHertz_;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. The language of the supplied audio. Dialogflow does not do
   * translations. See [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. Note that queries in
   * the same session do not necessarily need to specify the same language.
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The language of the supplied audio. Dialogflow does not do
   * translations. See [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. Note that queries in
   * the same session do not necessarily need to specify the same language.
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_WORD_INFO_FIELD_NUMBER = 13;
  private boolean enableWordInfo_ = false;
  /**
   *
   *
   * <pre>
   * If `true`, Dialogflow returns
   * [SpeechWordInfo][google.cloud.dialogflow.v2beta1.SpeechWordInfo] in
   * [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult]
   * with information about the recognized speech words, e.g. start and end time
   * offsets. If false or unspecified, Speech doesn't return any word-level
   * information.
   * </pre>
   *
   * <code>bool enable_word_info = 13;</code>
   *
   * @return The enableWordInfo.
   */
  @java.lang.Override
  public boolean getEnableWordInfo() {
    return enableWordInfo_;
  }

  public static final int PHRASE_HINTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList phraseHints_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   *
   * This field is deprecated. Please use [`speech_contexts`]() instead. If you
   * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
   * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
   * </pre>
   *
   * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
   *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
   * @return A list containing the phraseHints.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getPhraseHintsList() {
    return phraseHints_;
  }
  /**
   *
   *
   * <pre>
   * A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   *
   * This field is deprecated. Please use [`speech_contexts`]() instead. If you
   * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
   * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
   * </pre>
   *
   * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
   *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
   * @return The count of phraseHints.
   */
  @java.lang.Deprecated
  public int getPhraseHintsCount() {
    return phraseHints_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   *
   * This field is deprecated. Please use [`speech_contexts`]() instead. If you
   * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
   * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
   * </pre>
   *
   * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
   *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
   * @param index The index of the element to return.
   * @return The phraseHints at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getPhraseHints(int index) {
    return phraseHints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of strings containing words and phrases that the speech
   * recognizer should recognize with higher likelihood.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   *
   * This field is deprecated. Please use [`speech_contexts`]() instead. If you
   * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
   * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
   * </pre>
   *
   * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
   *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
   * @param index The index of the value to return.
   * @return The bytes of the phraseHints at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getPhraseHintsBytes(int index) {
    return phraseHints_.getByteString(index);
  }

  public static final int SPEECH_CONTEXTS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.SpeechContext> speechContexts_;
  /**
   *
   *
   * <pre>
   * Context information to assist speech recognition.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.SpeechContext> getSpeechContextsList() {
    return speechContexts_;
  }
  /**
   *
   *
   * <pre>
   * Context information to assist speech recognition.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.SpeechContextOrBuilder>
      getSpeechContextsOrBuilderList() {
    return speechContexts_;
  }
  /**
   *
   *
   * <pre>
   * Context information to assist speech recognition.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
   */
  @java.lang.Override
  public int getSpeechContextsCount() {
    return speechContexts_.size();
  }
  /**
   *
   *
   * <pre>
   * Context information to assist speech recognition.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SpeechContext getSpeechContexts(int index) {
    return speechContexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Context information to assist speech recognition.
   *
   * See [the Cloud Speech
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
   * for more details.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SpeechContextOrBuilder getSpeechContextsOrBuilder(
      int index) {
    return speechContexts_.get(index);
  }

  public static final int MODEL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Which Speech model to select for the given request.
   * For more information, see
   * [Speech models](https://cloud.google.com/dialogflow/es/docs/speech-models).
   * </pre>
   *
   * <code>string model = 7;</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Which Speech model to select for the given request.
   * For more information, see
   * [Speech models](https://cloud.google.com/dialogflow/es/docs/speech-models).
   * </pre>
   *
   * <code>string model = 7;</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VARIANT_FIELD_NUMBER = 10;
  private int modelVariant_ = 0;
  /**
   *
   *
   * <pre>
   * Which variant of the [Speech
   * model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant model_variant = 10;</code>
   *
   * @return The enum numeric value on the wire for modelVariant.
   */
  @java.lang.Override
  public int getModelVariantValue() {
    return modelVariant_;
  }
  /**
   *
   *
   * <pre>
   * Which variant of the [Speech
   * model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant model_variant = 10;</code>
   *
   * @return The modelVariant.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SpeechModelVariant getModelVariant() {
    com.google.cloud.dialogflow.v2beta1.SpeechModelVariant result =
        com.google.cloud.dialogflow.v2beta1.SpeechModelVariant.forNumber(modelVariant_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.SpeechModelVariant.UNRECOGNIZED
        : result;
  }

  public static final int SINGLE_UTTERANCE_FIELD_NUMBER = 8;
  private boolean singleUtterance_ = false;
  /**
   *
   *
   * <pre>
   * If `false` (default), recognition does not cease until the
   * client closes the stream.
   * If `true`, the recognizer will detect a single spoken utterance in input
   * audio. Recognition ceases when it detects the audio's voice has
   * stopped or paused. In this case, once a detected intent is received, the
   * client should close the stream and start a new request with a new stream as
   * needed.
   * Note: This setting is relevant only for streaming methods.
   * Note: When specified, InputAudioConfig.single_utterance takes precedence
   * over StreamingDetectIntentRequest.single_utterance.
   * </pre>
   *
   * <code>bool single_utterance = 8;</code>
   *
   * @return The singleUtterance.
   */
  @java.lang.Override
  public boolean getSingleUtterance() {
    return singleUtterance_;
  }

  public static final int DISABLE_NO_SPEECH_RECOGNIZED_EVENT_FIELD_NUMBER = 14;
  private boolean disableNoSpeechRecognizedEvent_ = false;
  /**
   *
   *
   * <pre>
   * Only used in
   * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
   * and
   * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent].
   * If `false` and recognition doesn't return any result, trigger
   * `NO_SPEECH_RECOGNIZED` event to Dialogflow agent.
   * </pre>
   *
   * <code>bool disable_no_speech_recognized_event = 14;</code>
   *
   * @return The disableNoSpeechRecognizedEvent.
   */
  @java.lang.Override
  public boolean getDisableNoSpeechRecognizedEvent() {
    return disableNoSpeechRecognizedEvent_;
  }

  public static final int BARGE_IN_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.dialogflow.v2beta1.BargeInConfig bargeInConfig_;
  /**
   *
   *
   * <pre>
   * Configuration of barge-in behavior during the streaming of input audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
   *
   * @return Whether the bargeInConfig field is set.
   */
  @java.lang.Override
  public boolean hasBargeInConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration of barge-in behavior during the streaming of input audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
   *
   * @return The bargeInConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.BargeInConfig getBargeInConfig() {
    return bargeInConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.BargeInConfig.getDefaultInstance()
        : bargeInConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration of barge-in behavior during the streaming of input audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.BargeInConfigOrBuilder getBargeInConfigOrBuilder() {
    return bargeInConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.BargeInConfig.getDefaultInstance()
        : bargeInConfig_;
  }

  public static final int ENABLE_AUTOMATIC_PUNCTUATION_FIELD_NUMBER = 17;
  private boolean enableAutomaticPunctuation_ = false;
  /**
   *
   *
   * <pre>
   * Enable automatic punctuation option at the speech backend.
   * </pre>
   *
   * <code>bool enable_automatic_punctuation = 17;</code>
   *
   * @return The enableAutomaticPunctuation.
   */
  @java.lang.Override
  public boolean getEnableAutomaticPunctuation() {
    return enableAutomaticPunctuation_;
  }

  public static final int DEFAULT_NO_SPEECH_TIMEOUT_FIELD_NUMBER = 18;
  private com.google.protobuf.Duration defaultNoSpeechTimeout_;
  /**
   *
   *
   * <pre>
   * If set, use this no-speech timeout when the agent does not provide a
   * no-speech timeout itself.
   * </pre>
   *
   * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
   *
   * @return Whether the defaultNoSpeechTimeout field is set.
   */
  @java.lang.Override
  public boolean hasDefaultNoSpeechTimeout() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set, use this no-speech timeout when the agent does not provide a
   * no-speech timeout itself.
   * </pre>
   *
   * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
   *
   * @return The defaultNoSpeechTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDefaultNoSpeechTimeout() {
    return defaultNoSpeechTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : defaultNoSpeechTimeout_;
  }
  /**
   *
   *
   * <pre>
   * If set, use this no-speech timeout when the agent does not provide a
   * no-speech timeout itself.
   * </pre>
   *
   * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDefaultNoSpeechTimeoutOrBuilder() {
    return defaultNoSpeechTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : defaultNoSpeechTimeout_;
  }

  public static final int PHRASE_SETS_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList phraseSets_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * A collection of phrase set resources to use for speech adaptation.
   * </pre>
   *
   * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the phraseSets.
   */
  public com.google.protobuf.ProtocolStringList getPhraseSetsList() {
    return phraseSets_;
  }
  /**
   *
   *
   * <pre>
   * A collection of phrase set resources to use for speech adaptation.
   * </pre>
   *
   * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of phraseSets.
   */
  public int getPhraseSetsCount() {
    return phraseSets_.size();
  }
  /**
   *
   *
   * <pre>
   * A collection of phrase set resources to use for speech adaptation.
   * </pre>
   *
   * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The phraseSets at the given index.
   */
  public java.lang.String getPhraseSets(int index) {
    return phraseSets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A collection of phrase set resources to use for speech adaptation.
   * </pre>
   *
   * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the phraseSets at the given index.
   */
  public com.google.protobuf.ByteString getPhraseSetsBytes(int index) {
    return phraseSets_.getByteString(index);
  }

  public static final int OPT_OUT_CONFORMER_MODEL_MIGRATION_FIELD_NUMBER = 26;
  private boolean optOutConformerModelMigration_ = false;
  /**
   *
   *
   * <pre>
   * If `true`, the request will opt out for STT conformer model migration.
   * This field will be deprecated once force migration takes place in June
   * 2024. Please refer to [Dialogflow ES Speech model
   * migration](https://cloud.google.com/dialogflow/es/docs/speech-model-migration).
   * </pre>
   *
   * <code>bool opt_out_conformer_model_migration = 26;</code>
   *
   * @return The optOutConformerModelMigration.
   */
  @java.lang.Override
  public boolean getOptOutConformerModelMigration() {
    return optOutConformerModelMigration_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (audioEncoding_
        != com.google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, audioEncoding_);
    }
    if (sampleRateHertz_ != 0) {
      output.writeInt32(2, sampleRateHertz_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languageCode_);
    }
    for (int i = 0; i < phraseHints_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, phraseHints_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, model_);
    }
    if (singleUtterance_ != false) {
      output.writeBool(8, singleUtterance_);
    }
    if (modelVariant_
        != com.google.cloud.dialogflow.v2beta1.SpeechModelVariant.SPEECH_MODEL_VARIANT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, modelVariant_);
    }
    for (int i = 0; i < speechContexts_.size(); i++) {
      output.writeMessage(11, speechContexts_.get(i));
    }
    if (enableWordInfo_ != false) {
      output.writeBool(13, enableWordInfo_);
    }
    if (disableNoSpeechRecognizedEvent_ != false) {
      output.writeBool(14, disableNoSpeechRecognizedEvent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(15, getBargeInConfig());
    }
    if (enableAutomaticPunctuation_ != false) {
      output.writeBool(17, enableAutomaticPunctuation_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(18, getDefaultNoSpeechTimeout());
    }
    for (int i = 0; i < phraseSets_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, phraseSets_.getRaw(i));
    }
    if (optOutConformerModelMigration_ != false) {
      output.writeBool(26, optOutConformerModelMigration_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (audioEncoding_
        != com.google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, audioEncoding_);
    }
    if (sampleRateHertz_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, sampleRateHertz_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, languageCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < phraseHints_.size(); i++) {
        dataSize += computeStringSizeNoTag(phraseHints_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPhraseHintsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, model_);
    }
    if (singleUtterance_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, singleUtterance_);
    }
    if (modelVariant_
        != com.google.cloud.dialogflow.v2beta1.SpeechModelVariant.SPEECH_MODEL_VARIANT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, modelVariant_);
    }
    for (int i = 0; i < speechContexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, speechContexts_.get(i));
    }
    if (enableWordInfo_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, enableWordInfo_);
    }
    if (disableNoSpeechRecognizedEvent_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              14, disableNoSpeechRecognizedEvent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getBargeInConfig());
    }
    if (enableAutomaticPunctuation_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(17, enableAutomaticPunctuation_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(18, getDefaultNoSpeechTimeout());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < phraseSets_.size(); i++) {
        dataSize += computeStringSizeNoTag(phraseSets_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getPhraseSetsList().size();
    }
    if (optOutConformerModelMigration_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(26, optOutConformerModelMigration_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.InputAudioConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.InputAudioConfig other =
        (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) obj;

    if (audioEncoding_ != other.audioEncoding_) return false;
    if (getSampleRateHertz() != other.getSampleRateHertz()) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (getEnableWordInfo() != other.getEnableWordInfo()) return false;
    if (!getPhraseHintsList().equals(other.getPhraseHintsList())) return false;
    if (!getSpeechContextsList().equals(other.getSpeechContextsList())) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (modelVariant_ != other.modelVariant_) return false;
    if (getSingleUtterance() != other.getSingleUtterance()) return false;
    if (getDisableNoSpeechRecognizedEvent() != other.getDisableNoSpeechRecognizedEvent())
      return false;
    if (hasBargeInConfig() != other.hasBargeInConfig()) return false;
    if (hasBargeInConfig()) {
      if (!getBargeInConfig().equals(other.getBargeInConfig())) return false;
    }
    if (getEnableAutomaticPunctuation() != other.getEnableAutomaticPunctuation()) return false;
    if (hasDefaultNoSpeechTimeout() != other.hasDefaultNoSpeechTimeout()) return false;
    if (hasDefaultNoSpeechTimeout()) {
      if (!getDefaultNoSpeechTimeout().equals(other.getDefaultNoSpeechTimeout())) return false;
    }
    if (!getPhraseSetsList().equals(other.getPhraseSetsList())) return false;
    if (getOptOutConformerModelMigration() != other.getOptOutConformerModelMigration())
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUDIO_ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + audioEncoding_;
    hash = (37 * hash) + SAMPLE_RATE_HERTZ_FIELD_NUMBER;
    hash = (53 * hash) + getSampleRateHertz();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + ENABLE_WORD_INFO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableWordInfo());
    if (getPhraseHintsCount() > 0) {
      hash = (37 * hash) + PHRASE_HINTS_FIELD_NUMBER;
      hash = (53 * hash) + getPhraseHintsList().hashCode();
    }
    if (getSpeechContextsCount() > 0) {
      hash = (37 * hash) + SPEECH_CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechContextsList().hashCode();
    }
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (37 * hash) + MODEL_VARIANT_FIELD_NUMBER;
    hash = (53 * hash) + modelVariant_;
    hash = (37 * hash) + SINGLE_UTTERANCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSingleUtterance());
    hash = (37 * hash) + DISABLE_NO_SPEECH_RECOGNIZED_EVENT_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableNoSpeechRecognizedEvent());
    if (hasBargeInConfig()) {
      hash = (37 * hash) + BARGE_IN_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBargeInConfig().hashCode();
    }
    hash = (37 * hash) + ENABLE_AUTOMATIC_PUNCTUATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableAutomaticPunctuation());
    if (hasDefaultNoSpeechTimeout()) {
      hash = (37 * hash) + DEFAULT_NO_SPEECH_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultNoSpeechTimeout().hashCode();
    }
    if (getPhraseSetsCount() > 0) {
      hash = (37 * hash) + PHRASE_SETS_FIELD_NUMBER;
      hash = (53 * hash) + getPhraseSetsList().hashCode();
    }
    hash = (37 * hash) + OPT_OUT_CONFORMER_MODEL_MIGRATION_FIELD_NUMBER;
    hash =
        (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOptOutConformerModelMigration());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.InputAudioConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer on how to process the audio content.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.InputAudioConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.InputAudioConfig)
      com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_InputAudioConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_InputAudioConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.InputAudioConfig.class,
              com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.InputAudioConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpeechContextsFieldBuilder();
        getBargeInConfigFieldBuilder();
        getDefaultNoSpeechTimeoutFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      audioEncoding_ = 0;
      sampleRateHertz_ = 0;
      languageCode_ = "";
      enableWordInfo_ = false;
      phraseHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (speechContextsBuilder_ == null) {
        speechContexts_ = java.util.Collections.emptyList();
      } else {
        speechContexts_ = null;
        speechContextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      model_ = "";
      modelVariant_ = 0;
      singleUtterance_ = false;
      disableNoSpeechRecognizedEvent_ = false;
      bargeInConfig_ = null;
      if (bargeInConfigBuilder_ != null) {
        bargeInConfigBuilder_.dispose();
        bargeInConfigBuilder_ = null;
      }
      enableAutomaticPunctuation_ = false;
      defaultNoSpeechTimeout_ = null;
      if (defaultNoSpeechTimeoutBuilder_ != null) {
        defaultNoSpeechTimeoutBuilder_.dispose();
        defaultNoSpeechTimeoutBuilder_ = null;
      }
      phraseSets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      optOutConformerModelMigration_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_InputAudioConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig build() {
      com.google.cloud.dialogflow.v2beta1.InputAudioConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig buildPartial() {
      com.google.cloud.dialogflow.v2beta1.InputAudioConfig result =
          new com.google.cloud.dialogflow.v2beta1.InputAudioConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.InputAudioConfig result) {
      if (speechContextsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          speechContexts_ = java.util.Collections.unmodifiableList(speechContexts_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.speechContexts_ = speechContexts_;
      } else {
        result.speechContexts_ = speechContextsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.InputAudioConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.audioEncoding_ = audioEncoding_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sampleRateHertz_ = sampleRateHertz_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enableWordInfo_ = enableWordInfo_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        phraseHints_.makeImmutable();
        result.phraseHints_ = phraseHints_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.model_ = model_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.modelVariant_ = modelVariant_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.singleUtterance_ = singleUtterance_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.disableNoSpeechRecognizedEvent_ = disableNoSpeechRecognizedEvent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.bargeInConfig_ =
            bargeInConfigBuilder_ == null ? bargeInConfig_ : bargeInConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.enableAutomaticPunctuation_ = enableAutomaticPunctuation_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.defaultNoSpeechTimeout_ =
            defaultNoSpeechTimeoutBuilder_ == null
                ? defaultNoSpeechTimeout_
                : defaultNoSpeechTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        phraseSets_.makeImmutable();
        result.phraseSets_ = phraseSets_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.optOutConformerModelMigration_ = optOutConformerModelMigration_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.InputAudioConfig) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.InputAudioConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.InputAudioConfig other) {
      if (other == com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance())
        return this;
      if (other.audioEncoding_ != 0) {
        setAudioEncodingValue(other.getAudioEncodingValue());
      }
      if (other.getSampleRateHertz() != 0) {
        setSampleRateHertz(other.getSampleRateHertz());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getEnableWordInfo() != false) {
        setEnableWordInfo(other.getEnableWordInfo());
      }
      if (!other.phraseHints_.isEmpty()) {
        if (phraseHints_.isEmpty()) {
          phraseHints_ = other.phraseHints_;
          bitField0_ |= 0x00000010;
        } else {
          ensurePhraseHintsIsMutable();
          phraseHints_.addAll(other.phraseHints_);
        }
        onChanged();
      }
      if (speechContextsBuilder_ == null) {
        if (!other.speechContexts_.isEmpty()) {
          if (speechContexts_.isEmpty()) {
            speechContexts_ = other.speechContexts_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureSpeechContextsIsMutable();
            speechContexts_.addAll(other.speechContexts_);
          }
          onChanged();
        }
      } else {
        if (!other.speechContexts_.isEmpty()) {
          if (speechContextsBuilder_.isEmpty()) {
            speechContextsBuilder_.dispose();
            speechContextsBuilder_ = null;
            speechContexts_ = other.speechContexts_;
            bitField0_ = (bitField0_ & ~0x00000020);
            speechContextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpeechContextsFieldBuilder()
                    : null;
          } else {
            speechContextsBuilder_.addAllMessages(other.speechContexts_);
          }
        }
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.modelVariant_ != 0) {
        setModelVariantValue(other.getModelVariantValue());
      }
      if (other.getSingleUtterance() != false) {
        setSingleUtterance(other.getSingleUtterance());
      }
      if (other.getDisableNoSpeechRecognizedEvent() != false) {
        setDisableNoSpeechRecognizedEvent(other.getDisableNoSpeechRecognizedEvent());
      }
      if (other.hasBargeInConfig()) {
        mergeBargeInConfig(other.getBargeInConfig());
      }
      if (other.getEnableAutomaticPunctuation() != false) {
        setEnableAutomaticPunctuation(other.getEnableAutomaticPunctuation());
      }
      if (other.hasDefaultNoSpeechTimeout()) {
        mergeDefaultNoSpeechTimeout(other.getDefaultNoSpeechTimeout());
      }
      if (!other.phraseSets_.isEmpty()) {
        if (phraseSets_.isEmpty()) {
          phraseSets_ = other.phraseSets_;
          bitField0_ |= 0x00002000;
        } else {
          ensurePhraseSetsIsMutable();
          phraseSets_.addAll(other.phraseSets_);
        }
        onChanged();
      }
      if (other.getOptOutConformerModelMigration() != false) {
        setOptOutConformerModelMigration(other.getOptOutConformerModelMigration());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                audioEncoding_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                sampleRateHertz_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePhraseHintsIsMutable();
                phraseHints_.add(s);
                break;
              } // case 34
            case 58:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                singleUtterance_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 64
            case 80:
              {
                modelVariant_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 80
            case 90:
              {
                com.google.cloud.dialogflow.v2beta1.SpeechContext m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.SpeechContext.parser(),
                        extensionRegistry);
                if (speechContextsBuilder_ == null) {
                  ensureSpeechContextsIsMutable();
                  speechContexts_.add(m);
                } else {
                  speechContextsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 104:
              {
                enableWordInfo_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 104
            case 112:
              {
                disableNoSpeechRecognizedEvent_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 112
            case 122:
              {
                input.readMessage(getBargeInConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 122
            case 136:
              {
                enableAutomaticPunctuation_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 136
            case 146:
              {
                input.readMessage(
                    getDefaultNoSpeechTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 146
            case 162:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePhraseSetsIsMutable();
                phraseSets_.add(s);
                break;
              } // case 162
            case 208:
              {
                optOutConformerModelMigration_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 208
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int audioEncoding_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for audioEncoding.
     */
    @java.lang.Override
    public int getAudioEncodingValue() {
      return audioEncoding_;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for audioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setAudioEncodingValue(int value) {
      audioEncoding_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The audioEncoding.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AudioEncoding getAudioEncoding() {
      com.google.cloud.dialogflow.v2beta1.AudioEncoding result =
          com.google.cloud.dialogflow.v2beta1.AudioEncoding.forNumber(audioEncoding_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.AudioEncoding.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The audioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setAudioEncoding(com.google.cloud.dialogflow.v2beta1.AudioEncoding value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      audioEncoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the audio content to process.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioEncoding() {
      bitField0_ = (bitField0_ & ~0x00000001);
      audioEncoding_ = 0;
      onChanged();
      return this;
    }

    private int sampleRateHertz_;
    /**
     *
     *
     * <pre>
     * Required. Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sampleRateHertz.
     */
    @java.lang.Override
    public int getSampleRateHertz() {
      return sampleRateHertz_;
    }
    /**
     *
     *
     * <pre>
     * Required. Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sampleRateHertz to set.
     * @return This builder for chaining.
     */
    public Builder setSampleRateHertz(int value) {

      sampleRateHertz_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleRateHertz() {
      bitField0_ = (bitField0_ & ~0x00000002);
      sampleRateHertz_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language of the supplied audio. Dialogflow does not do
     * translations. See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. Note that queries in
     * the same session do not necessarily need to specify the same language.
     * </pre>
     *
     * <code>string language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean enableWordInfo_;
    /**
     *
     *
     * <pre>
     * If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.v2beta1.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     * </pre>
     *
     * <code>bool enable_word_info = 13;</code>
     *
     * @return The enableWordInfo.
     */
    @java.lang.Override
    public boolean getEnableWordInfo() {
      return enableWordInfo_;
    }
    /**
     *
     *
     * <pre>
     * If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.v2beta1.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     * </pre>
     *
     * <code>bool enable_word_info = 13;</code>
     *
     * @param value The enableWordInfo to set.
     * @return This builder for chaining.
     */
    public Builder setEnableWordInfo(boolean value) {

      enableWordInfo_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.v2beta1.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     * </pre>
     *
     * <code>bool enable_word_info = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableWordInfo() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enableWordInfo_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList phraseHints_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePhraseHintsIsMutable() {
      if (!phraseHints_.isModifiable()) {
        phraseHints_ = new com.google.protobuf.LazyStringArrayList(phraseHints_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @return A list containing the phraseHints.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getPhraseHintsList() {
      phraseHints_.makeImmutable();
      return phraseHints_;
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @return The count of phraseHints.
     */
    @java.lang.Deprecated
    public int getPhraseHintsCount() {
      return phraseHints_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @param index The index of the element to return.
     * @return The phraseHints at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getPhraseHints(int index) {
      return phraseHints_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @param index The index of the value to return.
     * @return The bytes of the phraseHints at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getPhraseHintsBytes(int index) {
      return phraseHints_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @param index The index to set the value at.
     * @param value The phraseHints to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setPhraseHints(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseHintsIsMutable();
      phraseHints_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @param value The phraseHints to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addPhraseHints(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseHintsIsMutable();
      phraseHints_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @param values The phraseHints to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllPhraseHints(java.lang.Iterable<java.lang.String> values) {
      ensurePhraseHintsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phraseHints_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearPhraseHints() {
      phraseHints_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * This field is deprecated. Please use [`speech_contexts`]() instead. If you
     * specify both [`phrase_hints`]() and [`speech_contexts`](), Dialogflow will
     * treat the [`phrase_hints`]() as a single additional [`SpeechContext`]().
     * </pre>
     *
     * <code>repeated string phrase_hints = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.InputAudioConfig.phrase_hints is deprecated. See
     *     google/cloud/dialogflow/v2beta1/audio_config.proto;l=173
     * @param value The bytes of the phraseHints to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addPhraseHintsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePhraseHintsIsMutable();
      phraseHints_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.SpeechContext> speechContexts_ =
        java.util.Collections.emptyList();

    private void ensureSpeechContextsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        speechContexts_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.SpeechContext>(
                speechContexts_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SpeechContext,
            com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder,
            com.google.cloud.dialogflow.v2beta1.SpeechContextOrBuilder>
        speechContextsBuilder_;

    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.SpeechContext>
        getSpeechContextsList() {
      if (speechContextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(speechContexts_);
      } else {
        return speechContextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public int getSpeechContextsCount() {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.size();
      } else {
        return speechContextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.SpeechContext getSpeechContexts(int index) {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.get(index);
      } else {
        return speechContextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder setSpeechContexts(
        int index, com.google.cloud.dialogflow.v2beta1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.set(index, value);
        onChanged();
      } else {
        speechContextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder setSpeechContexts(
        int index, com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder addSpeechContexts(com.google.cloud.dialogflow.v2beta1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.add(value);
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder addSpeechContexts(
        int index, com.google.cloud.dialogflow.v2beta1.SpeechContext value) {
      if (speechContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechContextsIsMutable();
        speechContexts_.add(index, value);
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder addSpeechContexts(
        com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.add(builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder addSpeechContexts(
        int index, com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder builderForValue) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        speechContextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder addAllSpeechContexts(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.SpeechContext> values) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, speechContexts_);
        onChanged();
      } else {
        speechContextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder clearSpeechContexts() {
      if (speechContextsBuilder_ == null) {
        speechContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        speechContextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public Builder removeSpeechContexts(int index) {
      if (speechContextsBuilder_ == null) {
        ensureSpeechContextsIsMutable();
        speechContexts_.remove(index);
        onChanged();
      } else {
        speechContextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder getSpeechContextsBuilder(
        int index) {
      return getSpeechContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.SpeechContextOrBuilder getSpeechContextsOrBuilder(
        int index) {
      if (speechContextsBuilder_ == null) {
        return speechContexts_.get(index);
      } else {
        return speechContextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.SpeechContextOrBuilder>
        getSpeechContextsOrBuilderList() {
      if (speechContextsBuilder_ != null) {
        return speechContextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(speechContexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder addSpeechContextsBuilder() {
      return getSpeechContextsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.SpeechContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder addSpeechContextsBuilder(
        int index) {
      return getSpeechContextsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.SpeechContext.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Context information to assist speech recognition.
     *
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SpeechContext speech_contexts = 11;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder>
        getSpeechContextsBuilderList() {
      return getSpeechContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SpeechContext,
            com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder,
            com.google.cloud.dialogflow.v2beta1.SpeechContextOrBuilder>
        getSpeechContextsFieldBuilder() {
      if (speechContextsBuilder_ == null) {
        speechContextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SpeechContext,
                com.google.cloud.dialogflow.v2beta1.SpeechContext.Builder,
                com.google.cloud.dialogflow.v2beta1.SpeechContextOrBuilder>(
                speechContexts_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        speechContexts_ = null;
      }
      return speechContextsBuilder_;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request.
     * For more information, see
     * [Speech models](https://cloud.google.com/dialogflow/es/docs/speech-models).
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request.
     * For more information, see
     * [Speech models](https://cloud.google.com/dialogflow/es/docs/speech-models).
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request.
     * For more information, see
     * [Speech models](https://cloud.google.com/dialogflow/es/docs/speech-models).
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request.
     * For more information, see
     * [Speech models](https://cloud.google.com/dialogflow/es/docs/speech-models).
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Which Speech model to select for the given request.
     * For more information, see
     * [Speech models](https://cloud.google.com/dialogflow/es/docs/speech-models).
     * </pre>
     *
     * <code>string model = 7;</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int modelVariant_ = 0;
    /**
     *
     *
     * <pre>
     * Which variant of the [Speech
     * model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant model_variant = 10;</code>
     *
     * @return The enum numeric value on the wire for modelVariant.
     */
    @java.lang.Override
    public int getModelVariantValue() {
      return modelVariant_;
    }
    /**
     *
     *
     * <pre>
     * Which variant of the [Speech
     * model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant model_variant = 10;</code>
     *
     * @param value The enum numeric value on the wire for modelVariant to set.
     * @return This builder for chaining.
     */
    public Builder setModelVariantValue(int value) {
      modelVariant_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which variant of the [Speech
     * model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant model_variant = 10;</code>
     *
     * @return The modelVariant.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SpeechModelVariant getModelVariant() {
      com.google.cloud.dialogflow.v2beta1.SpeechModelVariant result =
          com.google.cloud.dialogflow.v2beta1.SpeechModelVariant.forNumber(modelVariant_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.SpeechModelVariant.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Which variant of the [Speech
     * model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant model_variant = 10;</code>
     *
     * @param value The modelVariant to set.
     * @return This builder for chaining.
     */
    public Builder setModelVariant(com.google.cloud.dialogflow.v2beta1.SpeechModelVariant value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      modelVariant_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which variant of the [Speech
     * model][google.cloud.dialogflow.v2beta1.InputAudioConfig.model] to use.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant model_variant = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVariant() {
      bitField0_ = (bitField0_ & ~0x00000080);
      modelVariant_ = 0;
      onChanged();
      return this;
    }

    private boolean singleUtterance_;
    /**
     *
     *
     * <pre>
     * If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     * Note: When specified, InputAudioConfig.single_utterance takes precedence
     * over StreamingDetectIntentRequest.single_utterance.
     * </pre>
     *
     * <code>bool single_utterance = 8;</code>
     *
     * @return The singleUtterance.
     */
    @java.lang.Override
    public boolean getSingleUtterance() {
      return singleUtterance_;
    }
    /**
     *
     *
     * <pre>
     * If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     * Note: When specified, InputAudioConfig.single_utterance takes precedence
     * over StreamingDetectIntentRequest.single_utterance.
     * </pre>
     *
     * <code>bool single_utterance = 8;</code>
     *
     * @param value The singleUtterance to set.
     * @return This builder for chaining.
     */
    public Builder setSingleUtterance(boolean value) {

      singleUtterance_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     * Note: When specified, InputAudioConfig.single_utterance takes precedence
     * over StreamingDetectIntentRequest.single_utterance.
     * </pre>
     *
     * <code>bool single_utterance = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSingleUtterance() {
      bitField0_ = (bitField0_ & ~0x00000100);
      singleUtterance_ = false;
      onChanged();
      return this;
    }

    private boolean disableNoSpeechRecognizedEvent_;
    /**
     *
     *
     * <pre>
     * Only used in
     * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
     * and
     * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent].
     * If `false` and recognition doesn't return any result, trigger
     * `NO_SPEECH_RECOGNIZED` event to Dialogflow agent.
     * </pre>
     *
     * <code>bool disable_no_speech_recognized_event = 14;</code>
     *
     * @return The disableNoSpeechRecognizedEvent.
     */
    @java.lang.Override
    public boolean getDisableNoSpeechRecognizedEvent() {
      return disableNoSpeechRecognizedEvent_;
    }
    /**
     *
     *
     * <pre>
     * Only used in
     * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
     * and
     * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent].
     * If `false` and recognition doesn't return any result, trigger
     * `NO_SPEECH_RECOGNIZED` event to Dialogflow agent.
     * </pre>
     *
     * <code>bool disable_no_speech_recognized_event = 14;</code>
     *
     * @param value The disableNoSpeechRecognizedEvent to set.
     * @return This builder for chaining.
     */
    public Builder setDisableNoSpeechRecognizedEvent(boolean value) {

      disableNoSpeechRecognizedEvent_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only used in
     * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
     * and
     * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent].
     * If `false` and recognition doesn't return any result, trigger
     * `NO_SPEECH_RECOGNIZED` event to Dialogflow agent.
     * </pre>
     *
     * <code>bool disable_no_speech_recognized_event = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableNoSpeechRecognizedEvent() {
      bitField0_ = (bitField0_ & ~0x00000200);
      disableNoSpeechRecognizedEvent_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.BargeInConfig bargeInConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.BargeInConfig,
            com.google.cloud.dialogflow.v2beta1.BargeInConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.BargeInConfigOrBuilder>
        bargeInConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     *
     * @return Whether the bargeInConfig field is set.
     */
    public boolean hasBargeInConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     *
     * @return The bargeInConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.BargeInConfig getBargeInConfig() {
      if (bargeInConfigBuilder_ == null) {
        return bargeInConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.BargeInConfig.getDefaultInstance()
            : bargeInConfig_;
      } else {
        return bargeInConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     */
    public Builder setBargeInConfig(com.google.cloud.dialogflow.v2beta1.BargeInConfig value) {
      if (bargeInConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bargeInConfig_ = value;
      } else {
        bargeInConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     */
    public Builder setBargeInConfig(
        com.google.cloud.dialogflow.v2beta1.BargeInConfig.Builder builderForValue) {
      if (bargeInConfigBuilder_ == null) {
        bargeInConfig_ = builderForValue.build();
      } else {
        bargeInConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     */
    public Builder mergeBargeInConfig(com.google.cloud.dialogflow.v2beta1.BargeInConfig value) {
      if (bargeInConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && bargeInConfig_ != null
            && bargeInConfig_
                != com.google.cloud.dialogflow.v2beta1.BargeInConfig.getDefaultInstance()) {
          getBargeInConfigBuilder().mergeFrom(value);
        } else {
          bargeInConfig_ = value;
        }
      } else {
        bargeInConfigBuilder_.mergeFrom(value);
      }
      if (bargeInConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     */
    public Builder clearBargeInConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      bargeInConfig_ = null;
      if (bargeInConfigBuilder_ != null) {
        bargeInConfigBuilder_.dispose();
        bargeInConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.BargeInConfig.Builder getBargeInConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getBargeInConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.BargeInConfigOrBuilder getBargeInConfigOrBuilder() {
      if (bargeInConfigBuilder_ != null) {
        return bargeInConfigBuilder_.getMessageOrBuilder();
      } else {
        return bargeInConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.BargeInConfig.getDefaultInstance()
            : bargeInConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration of barge-in behavior during the streaming of input audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.BargeInConfig barge_in_config = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.BargeInConfig,
            com.google.cloud.dialogflow.v2beta1.BargeInConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.BargeInConfigOrBuilder>
        getBargeInConfigFieldBuilder() {
      if (bargeInConfigBuilder_ == null) {
        bargeInConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.BargeInConfig,
                com.google.cloud.dialogflow.v2beta1.BargeInConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.BargeInConfigOrBuilder>(
                getBargeInConfig(), getParentForChildren(), isClean());
        bargeInConfig_ = null;
      }
      return bargeInConfigBuilder_;
    }

    private boolean enableAutomaticPunctuation_;
    /**
     *
     *
     * <pre>
     * Enable automatic punctuation option at the speech backend.
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 17;</code>
     *
     * @return The enableAutomaticPunctuation.
     */
    @java.lang.Override
    public boolean getEnableAutomaticPunctuation() {
      return enableAutomaticPunctuation_;
    }
    /**
     *
     *
     * <pre>
     * Enable automatic punctuation option at the speech backend.
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 17;</code>
     *
     * @param value The enableAutomaticPunctuation to set.
     * @return This builder for chaining.
     */
    public Builder setEnableAutomaticPunctuation(boolean value) {

      enableAutomaticPunctuation_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable automatic punctuation option at the speech backend.
     * </pre>
     *
     * <code>bool enable_automatic_punctuation = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableAutomaticPunctuation() {
      bitField0_ = (bitField0_ & ~0x00000800);
      enableAutomaticPunctuation_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration defaultNoSpeechTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        defaultNoSpeechTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     *
     * @return Whether the defaultNoSpeechTimeout field is set.
     */
    public boolean hasDefaultNoSpeechTimeout() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     *
     * @return The defaultNoSpeechTimeout.
     */
    public com.google.protobuf.Duration getDefaultNoSpeechTimeout() {
      if (defaultNoSpeechTimeoutBuilder_ == null) {
        return defaultNoSpeechTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : defaultNoSpeechTimeout_;
      } else {
        return defaultNoSpeechTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     */
    public Builder setDefaultNoSpeechTimeout(com.google.protobuf.Duration value) {
      if (defaultNoSpeechTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultNoSpeechTimeout_ = value;
      } else {
        defaultNoSpeechTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     */
    public Builder setDefaultNoSpeechTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (defaultNoSpeechTimeoutBuilder_ == null) {
        defaultNoSpeechTimeout_ = builderForValue.build();
      } else {
        defaultNoSpeechTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     */
    public Builder mergeDefaultNoSpeechTimeout(com.google.protobuf.Duration value) {
      if (defaultNoSpeechTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && defaultNoSpeechTimeout_ != null
            && defaultNoSpeechTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDefaultNoSpeechTimeoutBuilder().mergeFrom(value);
        } else {
          defaultNoSpeechTimeout_ = value;
        }
      } else {
        defaultNoSpeechTimeoutBuilder_.mergeFrom(value);
      }
      if (defaultNoSpeechTimeout_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     */
    public Builder clearDefaultNoSpeechTimeout() {
      bitField0_ = (bitField0_ & ~0x00001000);
      defaultNoSpeechTimeout_ = null;
      if (defaultNoSpeechTimeoutBuilder_ != null) {
        defaultNoSpeechTimeoutBuilder_.dispose();
        defaultNoSpeechTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     */
    public com.google.protobuf.Duration.Builder getDefaultNoSpeechTimeoutBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getDefaultNoSpeechTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDefaultNoSpeechTimeoutOrBuilder() {
      if (defaultNoSpeechTimeoutBuilder_ != null) {
        return defaultNoSpeechTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return defaultNoSpeechTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : defaultNoSpeechTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, use this no-speech timeout when the agent does not provide a
     * no-speech timeout itself.
     * </pre>
     *
     * <code>.google.protobuf.Duration default_no_speech_timeout = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDefaultNoSpeechTimeoutFieldBuilder() {
      if (defaultNoSpeechTimeoutBuilder_ == null) {
        defaultNoSpeechTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDefaultNoSpeechTimeout(), getParentForChildren(), isClean());
        defaultNoSpeechTimeout_ = null;
      }
      return defaultNoSpeechTimeoutBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList phraseSets_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePhraseSetsIsMutable() {
      if (!phraseSets_.isModifiable()) {
        phraseSets_ = new com.google.protobuf.LazyStringArrayList(phraseSets_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the phraseSets.
     */
    public com.google.protobuf.ProtocolStringList getPhraseSetsList() {
      phraseSets_.makeImmutable();
      return phraseSets_;
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of phraseSets.
     */
    public int getPhraseSetsCount() {
      return phraseSets_.size();
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The phraseSets at the given index.
     */
    public java.lang.String getPhraseSets(int index) {
      return phraseSets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the phraseSets at the given index.
     */
    public com.google.protobuf.ByteString getPhraseSetsBytes(int index) {
      return phraseSets_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The phraseSets to set.
     * @return This builder for chaining.
     */
    public Builder setPhraseSets(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseSetsIsMutable();
      phraseSets_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The phraseSets to add.
     * @return This builder for chaining.
     */
    public Builder addPhraseSets(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseSetsIsMutable();
      phraseSets_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The phraseSets to add.
     * @return This builder for chaining.
     */
    public Builder addAllPhraseSets(java.lang.Iterable<java.lang.String> values) {
      ensurePhraseSetsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phraseSets_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhraseSets() {
      phraseSets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of phrase set resources to use for speech adaptation.
     * </pre>
     *
     * <code>repeated string phrase_sets = 20 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the phraseSets to add.
     * @return This builder for chaining.
     */
    public Builder addPhraseSetsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePhraseSetsIsMutable();
      phraseSets_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private boolean optOutConformerModelMigration_;
    /**
     *
     *
     * <pre>
     * If `true`, the request will opt out for STT conformer model migration.
     * This field will be deprecated once force migration takes place in June
     * 2024. Please refer to [Dialogflow ES Speech model
     * migration](https://cloud.google.com/dialogflow/es/docs/speech-model-migration).
     * </pre>
     *
     * <code>bool opt_out_conformer_model_migration = 26;</code>
     *
     * @return The optOutConformerModelMigration.
     */
    @java.lang.Override
    public boolean getOptOutConformerModelMigration() {
      return optOutConformerModelMigration_;
    }
    /**
     *
     *
     * <pre>
     * If `true`, the request will opt out for STT conformer model migration.
     * This field will be deprecated once force migration takes place in June
     * 2024. Please refer to [Dialogflow ES Speech model
     * migration](https://cloud.google.com/dialogflow/es/docs/speech-model-migration).
     * </pre>
     *
     * <code>bool opt_out_conformer_model_migration = 26;</code>
     *
     * @param value The optOutConformerModelMigration to set.
     * @return This builder for chaining.
     */
    public Builder setOptOutConformerModelMigration(boolean value) {

      optOutConformerModelMigration_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `true`, the request will opt out for STT conformer model migration.
     * This field will be deprecated once force migration takes place in June
     * 2024. Please refer to [Dialogflow ES Speech model
     * migration](https://cloud.google.com/dialogflow/es/docs/speech-model-migration).
     * </pre>
     *
     * <code>bool opt_out_conformer_model_migration = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOptOutConformerModelMigration() {
      bitField0_ = (bitField0_ & ~0x00004000);
      optOutConformerModelMigration_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.InputAudioConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.InputAudioConfig)
  private static final com.google.cloud.dialogflow.v2beta1.InputAudioConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.InputAudioConfig();
  }

  public static com.google.cloud.dialogflow.v2beta1.InputAudioConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InputAudioConfig> PARSER =
      new com.google.protobuf.AbstractParser<InputAudioConfig>() {
        @java.lang.Override
        public InputAudioConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InputAudioConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InputAudioConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
