/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/phone_number.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a phone number.
 * `PhoneNumber` resources enable phone calls to be answered by Dialogflow
 * services and are added to a project through a
 * [PhoneNumberOrder][google.cloud.dialogflow.v2beta1.PhoneNumberOrder].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.PhoneNumber}
 */
public final class PhoneNumber extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.PhoneNumber)
    PhoneNumberOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PhoneNumber.newBuilder() to construct.
  private PhoneNumber(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PhoneNumber() {
    name_ = "";
    phoneNumber_ = "";
    conversationProfile_ = "";
    lifecycleState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PhoneNumber();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.PhoneNumberProto
        .internal_static_google_cloud_dialogflow_v2beta1_PhoneNumber_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.PhoneNumberProto
        .internal_static_google_cloud_dialogflow_v2beta1_PhoneNumber_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.PhoneNumber.class,
            com.google.cloud.dialogflow.v2beta1.PhoneNumber.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The states that a `PhoneNumber` can be in.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState}
   */
  public enum LifecycleState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * This value is never used.
     * </pre>
     *
     * <code>LIFECYCLE_STATE_UNSPECIFIED = 0;</code>
     */
    LIFECYCLE_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Number is active and can receive phone calls.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Number is pending deletion, and cannot receive calls.
     * </pre>
     *
     * <code>DELETE_REQUESTED = 2;</code>
     */
    DELETE_REQUESTED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * This value is never used.
     * </pre>
     *
     * <code>LIFECYCLE_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int LIFECYCLE_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Number is active and can receive phone calls.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Number is pending deletion, and cannot receive calls.
     * </pre>
     *
     * <code>DELETE_REQUESTED = 2;</code>
     */
    public static final int DELETE_REQUESTED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LifecycleState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LifecycleState forNumber(int value) {
      switch (value) {
        case 0:
          return LIFECYCLE_STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return DELETE_REQUESTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LifecycleState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LifecycleState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LifecycleState>() {
          public LifecycleState findValueByNumber(int number) {
            return LifecycleState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.PhoneNumber.getDescriptor().getEnumTypes().get(0);
    }

    private static final LifecycleState[] VALUES = values();

    public static LifecycleState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LifecycleState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The unique identifier of this phone number.
   * Required for
   * [PhoneNumbers.UpdatePhoneNumber][google.cloud.dialogflow.v2beta1.PhoneNumbers.UpdatePhoneNumber]
   * method. Format: `projects/&lt;Project ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The unique identifier of this phone number.
   * Required for
   * [PhoneNumbers.UpdatePhoneNumber][google.cloud.dialogflow.v2beta1.PhoneNumbers.UpdatePhoneNumber]
   * method. Format: `projects/&lt;Project ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHONE_NUMBER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object phoneNumber_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Phone number in [E.164](https://en.wikipedia.org/wiki/E.164)
   * format. An example of a correctly formatted phone number: +15556767888.
   * </pre>
   *
   * <code>string phone_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The phoneNumber.
   */
  @java.lang.Override
  public java.lang.String getPhoneNumber() {
    java.lang.Object ref = phoneNumber_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      phoneNumber_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Phone number in [E.164](https://en.wikipedia.org/wiki/E.164)
   * format. An example of a correctly formatted phone number: +15556767888.
   * </pre>
   *
   * <code>string phone_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for phoneNumber.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPhoneNumberBytes() {
    java.lang.Object ref = phoneNumber_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      phoneNumber_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_PROFILE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversationProfile_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The conversation profile calls to this `PhoneNumber` should use.
   * The project ID here should be the same as the one in
   * [name][google.cloud.dialogflow.v2beta1.PhoneNumber.name].
   * Format: `projects/&lt;Project ID&gt;/conversationProfiles/&lt;ConversationProfile
   * ID&gt;`.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;ConversationProfile ID&gt;`.
   * </pre>
   *
   * <code>string conversation_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The conversationProfile.
   */
  @java.lang.Override
  public java.lang.String getConversationProfile() {
    java.lang.Object ref = conversationProfile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversationProfile_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The conversation profile calls to this `PhoneNumber` should use.
   * The project ID here should be the same as the one in
   * [name][google.cloud.dialogflow.v2beta1.PhoneNumber.name].
   * Format: `projects/&lt;Project ID&gt;/conversationProfiles/&lt;ConversationProfile
   * ID&gt;`.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;ConversationProfile ID&gt;`.
   * </pre>
   *
   * <code>string conversation_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for conversationProfile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationProfileBytes() {
    java.lang.Object ref = conversationProfile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversationProfile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LIFECYCLE_STATE_FIELD_NUMBER = 4;
  private int lifecycleState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the `PhoneNumber`. Defaults to `ACTIVE`.
   * `PhoneNumber` objects set to `DELETE_REQUESTED` always decline incoming
   * calls and can be removed completely within 30 days.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for lifecycleState.
   */
  @java.lang.Override
  public int getLifecycleStateValue() {
    return lifecycleState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the `PhoneNumber`. Defaults to `ACTIVE`.
   * `PhoneNumber` objects set to `DELETE_REQUESTED` always decline incoming
   * calls and can be removed completely within 30 days.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lifecycleState.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState getLifecycleState() {
    com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState result =
        com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.forNumber(lifecycleState_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, phoneNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationProfile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, conversationProfile_);
    }
    if (lifecycleState_
        != com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState
            .LIFECYCLE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, lifecycleState_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, phoneNumber_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationProfile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, conversationProfile_);
    }
    if (lifecycleState_
        != com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState
            .LIFECYCLE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, lifecycleState_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.PhoneNumber)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.PhoneNumber other =
        (com.google.cloud.dialogflow.v2beta1.PhoneNumber) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getPhoneNumber().equals(other.getPhoneNumber())) return false;
    if (!getConversationProfile().equals(other.getConversationProfile())) return false;
    if (lifecycleState_ != other.lifecycleState_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PHONE_NUMBER_FIELD_NUMBER;
    hash = (53 * hash) + getPhoneNumber().hashCode();
    hash = (37 * hash) + CONVERSATION_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getConversationProfile().hashCode();
    hash = (37 * hash) + LIFECYCLE_STATE_FIELD_NUMBER;
    hash = (53 * hash) + lifecycleState_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.PhoneNumber prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a phone number.
   * `PhoneNumber` resources enable phone calls to be answered by Dialogflow
   * services and are added to a project through a
   * [PhoneNumberOrder][google.cloud.dialogflow.v2beta1.PhoneNumberOrder].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.PhoneNumber}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.PhoneNumber)
      com.google.cloud.dialogflow.v2beta1.PhoneNumberOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.PhoneNumberProto
          .internal_static_google_cloud_dialogflow_v2beta1_PhoneNumber_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.PhoneNumberProto
          .internal_static_google_cloud_dialogflow_v2beta1_PhoneNumber_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.PhoneNumber.class,
              com.google.cloud.dialogflow.v2beta1.PhoneNumber.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.PhoneNumber.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      phoneNumber_ = "";
      conversationProfile_ = "";
      lifecycleState_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.PhoneNumberProto
          .internal_static_google_cloud_dialogflow_v2beta1_PhoneNumber_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.PhoneNumber getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.PhoneNumber.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.PhoneNumber build() {
      com.google.cloud.dialogflow.v2beta1.PhoneNumber result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.PhoneNumber buildPartial() {
      com.google.cloud.dialogflow.v2beta1.PhoneNumber result =
          new com.google.cloud.dialogflow.v2beta1.PhoneNumber(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.PhoneNumber result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.phoneNumber_ = phoneNumber_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.conversationProfile_ = conversationProfile_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lifecycleState_ = lifecycleState_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.PhoneNumber) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.PhoneNumber) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.PhoneNumber other) {
      if (other == com.google.cloud.dialogflow.v2beta1.PhoneNumber.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getPhoneNumber().isEmpty()) {
        phoneNumber_ = other.phoneNumber_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getConversationProfile().isEmpty()) {
        conversationProfile_ = other.conversationProfile_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.lifecycleState_ != 0) {
        setLifecycleStateValue(other.getLifecycleStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                phoneNumber_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                conversationProfile_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                lifecycleState_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of this phone number.
     * Required for
     * [PhoneNumbers.UpdatePhoneNumber][google.cloud.dialogflow.v2beta1.PhoneNumbers.UpdatePhoneNumber]
     * method. Format: `projects/&lt;Project ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of this phone number.
     * Required for
     * [PhoneNumbers.UpdatePhoneNumber][google.cloud.dialogflow.v2beta1.PhoneNumbers.UpdatePhoneNumber]
     * method. Format: `projects/&lt;Project ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of this phone number.
     * Required for
     * [PhoneNumbers.UpdatePhoneNumber][google.cloud.dialogflow.v2beta1.PhoneNumbers.UpdatePhoneNumber]
     * method. Format: `projects/&lt;Project ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of this phone number.
     * Required for
     * [PhoneNumbers.UpdatePhoneNumber][google.cloud.dialogflow.v2beta1.PhoneNumbers.UpdatePhoneNumber]
     * method. Format: `projects/&lt;Project ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The unique identifier of this phone number.
     * Required for
     * [PhoneNumbers.UpdatePhoneNumber][google.cloud.dialogflow.v2beta1.PhoneNumbers.UpdatePhoneNumber]
     * method. Format: `projects/&lt;Project ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/phoneNumbers/&lt;PhoneNumber ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object phoneNumber_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Phone number in [E.164](https://en.wikipedia.org/wiki/E.164)
     * format. An example of a correctly formatted phone number: +15556767888.
     * </pre>
     *
     * <code>string phone_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The phoneNumber.
     */
    public java.lang.String getPhoneNumber() {
      java.lang.Object ref = phoneNumber_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phoneNumber_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Phone number in [E.164](https://en.wikipedia.org/wiki/E.164)
     * format. An example of a correctly formatted phone number: +15556767888.
     * </pre>
     *
     * <code>string phone_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for phoneNumber.
     */
    public com.google.protobuf.ByteString getPhoneNumberBytes() {
      java.lang.Object ref = phoneNumber_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phoneNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Phone number in [E.164](https://en.wikipedia.org/wiki/E.164)
     * format. An example of a correctly formatted phone number: +15556767888.
     * </pre>
     *
     * <code>string phone_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The phoneNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneNumber(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      phoneNumber_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Phone number in [E.164](https://en.wikipedia.org/wiki/E.164)
     * format. An example of a correctly formatted phone number: +15556767888.
     * </pre>
     *
     * <code>string phone_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhoneNumber() {
      phoneNumber_ = getDefaultInstance().getPhoneNumber();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Phone number in [E.164](https://en.wikipedia.org/wiki/E.164)
     * format. An example of a correctly formatted phone number: +15556767888.
     * </pre>
     *
     * <code>string phone_number = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for phoneNumber to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneNumberBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      phoneNumber_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object conversationProfile_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The conversation profile calls to this `PhoneNumber` should use.
     * The project ID here should be the same as the one in
     * [name][google.cloud.dialogflow.v2beta1.PhoneNumber.name].
     * Format: `projects/&lt;Project ID&gt;/conversationProfiles/&lt;ConversationProfile
     * ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;ConversationProfile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The conversationProfile.
     */
    public java.lang.String getConversationProfile() {
      java.lang.Object ref = conversationProfile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversationProfile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The conversation profile calls to this `PhoneNumber` should use.
     * The project ID here should be the same as the one in
     * [name][google.cloud.dialogflow.v2beta1.PhoneNumber.name].
     * Format: `projects/&lt;Project ID&gt;/conversationProfiles/&lt;ConversationProfile
     * ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;ConversationProfile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for conversationProfile.
     */
    public com.google.protobuf.ByteString getConversationProfileBytes() {
      java.lang.Object ref = conversationProfile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversationProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The conversation profile calls to this `PhoneNumber` should use.
     * The project ID here should be the same as the one in
     * [name][google.cloud.dialogflow.v2beta1.PhoneNumber.name].
     * Format: `projects/&lt;Project ID&gt;/conversationProfiles/&lt;ConversationProfile
     * ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;ConversationProfile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The conversationProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConversationProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversationProfile_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The conversation profile calls to this `PhoneNumber` should use.
     * The project ID here should be the same as the one in
     * [name][google.cloud.dialogflow.v2beta1.PhoneNumber.name].
     * Format: `projects/&lt;Project ID&gt;/conversationProfiles/&lt;ConversationProfile
     * ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;ConversationProfile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationProfile() {
      conversationProfile_ = getDefaultInstance().getConversationProfile();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The conversation profile calls to this `PhoneNumber` should use.
     * The project ID here should be the same as the one in
     * [name][google.cloud.dialogflow.v2beta1.PhoneNumber.name].
     * Format: `projects/&lt;Project ID&gt;/conversationProfiles/&lt;ConversationProfile
     * ID&gt;`.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;ConversationProfile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for conversationProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConversationProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversationProfile_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int lifecycleState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the `PhoneNumber`. Defaults to `ACTIVE`.
     * `PhoneNumber` objects set to `DELETE_REQUESTED` always decline incoming
     * calls and can be removed completely within 30 days.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for lifecycleState.
     */
    @java.lang.Override
    public int getLifecycleStateValue() {
      return lifecycleState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `PhoneNumber`. Defaults to `ACTIVE`.
     * `PhoneNumber` objects set to `DELETE_REQUESTED` always decline incoming
     * calls and can be removed completely within 30 days.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleStateValue(int value) {
      lifecycleState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `PhoneNumber`. Defaults to `ACTIVE`.
     * `PhoneNumber` objects set to `DELETE_REQUESTED` always decline incoming
     * calls and can be removed completely within 30 days.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lifecycleState.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState getLifecycleState() {
      com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState result =
          com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.forNumber(lifecycleState_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `PhoneNumber`. Defaults to `ACTIVE`.
     * `PhoneNumber` objects set to `DELETE_REQUESTED` always decline incoming
     * calls and can be removed completely within 30 days.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleState(
        com.google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      lifecycleState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `PhoneNumber`. Defaults to `ACTIVE`.
     * `PhoneNumber` objects set to `DELETE_REQUESTED` always decline incoming
     * calls and can be removed completely within 30 days.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLifecycleState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lifecycleState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.PhoneNumber)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.PhoneNumber)
  private static final com.google.cloud.dialogflow.v2beta1.PhoneNumber DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.PhoneNumber();
  }

  public static com.google.cloud.dialogflow.v2beta1.PhoneNumber getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PhoneNumber> PARSER =
      new com.google.protobuf.AbstractParser<PhoneNumber>() {
        @java.lang.Override
        public PhoneNumber parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PhoneNumber> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PhoneNumber> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.PhoneNumber getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
