/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnvironmentName
implements ResourceName {
    private static final PathTemplate PROJECT_ENVIRONMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}");
    private static final PathTemplate PROJECT_LOCATION_ENVIRONMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/environments/{environment}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String environment;
    private final String location;

    @Deprecated
    protected EnvironmentName() {
        this.project = null;
        this.environment = null;
        this.location = null;
    }

    private EnvironmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.location = null;
        this.pathTemplate = PROJECT_ENVIRONMENT;
    }

    private EnvironmentName(ProjectLocationEnvironmentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.pathTemplate = PROJECT_LOCATION_ENVIRONMENT;
    }

    public String getProject() {
        return this.project;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectEnvironmentBuilder() {
        return new Builder();
    }

    public static ProjectLocationEnvironmentBuilder newProjectLocationEnvironmentBuilder() {
        return new ProjectLocationEnvironmentBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EnvironmentName of(String project, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setEnvironment(environment).build();
    }

    public static EnvironmentName ofProjectEnvironmentName(String project, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setEnvironment(environment).build();
    }

    public static EnvironmentName ofProjectLocationEnvironmentName(String project, String location, String environment) {
        return EnvironmentName.newProjectLocationEnvironmentBuilder().setProject(project).setLocation(location).setEnvironment(environment).build();
    }

    public static String format(String project, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setEnvironment(environment).build().toString();
    }

    public static String formatProjectEnvironmentName(String project, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setEnvironment(environment).build().toString();
    }

    public static String formatProjectLocationEnvironmentName(String project, String location, String environment) {
        return EnvironmentName.newProjectLocationEnvironmentBuilder().setProject(project).setLocation(location).setEnvironment(environment).build().toString();
    }

    public static EnvironmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_ENVIRONMENT.matches(formattedString)) {
            Map matchMap = PROJECT_ENVIRONMENT.match(formattedString);
            return EnvironmentName.ofProjectEnvironmentName((String)matchMap.get("project"), (String)matchMap.get("environment"));
        }
        if (PROJECT_LOCATION_ENVIRONMENT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENVIRONMENT.match(formattedString);
            return EnvironmentName.ofProjectLocationEnvironmentName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("environment"));
        }
        throw new ValidationException("EnvironmentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<EnvironmentName> parseList(List<String> formattedStrings) {
        ArrayList<EnvironmentName> list = new ArrayList<EnvironmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnvironmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnvironmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnvironmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ENVIRONMENT.matches(formattedString) || PROJECT_LOCATION_ENVIRONMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnvironmentName environmentName = this;
            synchronized (environmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EnvironmentName that = (EnvironmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.environment, that.environment) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationEnvironmentBuilder {
        private String project;
        private String location;
        private String environment;

        protected ProjectLocationEnvironmentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public ProjectLocationEnvironmentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEnvironmentBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEnvironmentBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public EnvironmentName build() {
            return new EnvironmentName(this);
        }
    }

    public static class Builder {
        private String project;
        private String environment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        private Builder(EnvironmentName environmentName) {
            Preconditions.checkArgument((boolean)Objects.equals(environmentName.pathTemplate, PROJECT_ENVIRONMENT), (Object)"toBuilder is only supported when EnvironmentName has the pattern of projects/{project}/agent/environments/{environment}");
            this.project = environmentName.project;
            this.environment = environmentName.environment;
        }

        public EnvironmentName build() {
            return new EnvironmentName(this);
        }
    }
}

