/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GeneratorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GENERATOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/generators/{generator}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String generator;

    @Deprecated
    protected GeneratorName() {
        this.project = null;
        this.location = null;
        this.generator = null;
    }

    private GeneratorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.generator = (String)Preconditions.checkNotNull((Object)builder.getGenerator());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGenerator() {
        return this.generator;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GeneratorName of(String project, String location, String generator) {
        return GeneratorName.newBuilder().setProject(project).setLocation(location).setGenerator(generator).build();
    }

    public static String format(String project, String location, String generator) {
        return GeneratorName.newBuilder().setProject(project).setLocation(location).setGenerator(generator).build().toString();
    }

    public static GeneratorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GENERATOR.validatedMatch(formattedString, "GeneratorName.parse: formattedString not in valid format");
        return GeneratorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("generator"));
    }

    public static List<GeneratorName> parseList(List<String> formattedStrings) {
        ArrayList<GeneratorName> list = new ArrayList<GeneratorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GeneratorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GeneratorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GeneratorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GENERATOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GeneratorName generatorName = this;
            synchronized (generatorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.generator != null) {
                        fieldMapBuilder.put((Object)"generator", (Object)this.generator);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GENERATOR.instantiate(new String[]{"project", this.project, "location", this.location, "generator", this.generator});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GeneratorName that = (GeneratorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.generator, that.generator);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.generator);
    }

    public static class Builder {
        private String project;
        private String location;
        private String generator;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGenerator() {
            return this.generator;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGenerator(String generator) {
            this.generator = generator;
            return this;
        }

        private Builder(GeneratorName generatorName) {
            this.project = generatorName.project;
            this.location = generatorName.location;
            this.generator = generatorName.generator;
        }

        public GeneratorName build() {
            return new GeneratorName(this);
        }
    }
}

