/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/session.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Cloud conversation info for easier debugging.
 * It will get populated in `StreamingDetectIntentResponse` or
 * `StreamingAnalyzeContentResponse` when the flag `enable_debugging_info` is
 * set to true in corresponding requests.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo}
 */
public final class CloudConversationDebuggingInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo)
    CloudConversationDebuggingInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CloudConversationDebuggingInfo.newBuilder() to construct.
  private CloudConversationDebuggingInfo(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudConversationDebuggingInfo() {
    speechPartialResultsEndTimes_ = java.util.Collections.emptyList();
    speechFinalResultsEndTimes_ = java.util.Collections.emptyList();
    dtmfPartialResultsTimes_ = java.util.Collections.emptyList();
    dtmfFinalResultsTimes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudConversationDebuggingInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_CloudConversationDebuggingInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_CloudConversationDebuggingInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo.class,
            com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo.Builder.class);
  }

  private int bitField0_;
  public static final int AUDIO_DATA_CHUNKS_FIELD_NUMBER = 1;
  private int audioDataChunks_ = 0;

  /**
   *
   *
   * <pre>
   * Number of input audio data chunks in streaming requests.
   * </pre>
   *
   * <code>int32 audio_data_chunks = 1;</code>
   *
   * @return The audioDataChunks.
   */
  @java.lang.Override
  public int getAudioDataChunks() {
    return audioDataChunks_;
  }

  public static final int RESULT_END_TIME_OFFSET_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration resultEndTimeOffset_;

  /**
   *
   *
   * <pre>
   * Time offset of the end of speech utterance relative to the
   * beginning of the first audio chunk.
   * </pre>
   *
   * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
   *
   * @return Whether the resultEndTimeOffset field is set.
   */
  @java.lang.Override
  public boolean hasResultEndTimeOffset() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Time offset of the end of speech utterance relative to the
   * beginning of the first audio chunk.
   * </pre>
   *
   * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
   *
   * @return The resultEndTimeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getResultEndTimeOffset() {
    return resultEndTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : resultEndTimeOffset_;
  }

  /**
   *
   *
   * <pre>
   * Time offset of the end of speech utterance relative to the
   * beginning of the first audio chunk.
   * </pre>
   *
   * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getResultEndTimeOffsetOrBuilder() {
    return resultEndTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : resultEndTimeOffset_;
  }

  public static final int FIRST_AUDIO_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration firstAudioDuration_;

  /**
   *
   *
   * <pre>
   * Duration of first audio chunk.
   * </pre>
   *
   * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
   *
   * @return Whether the firstAudioDuration field is set.
   */
  @java.lang.Override
  public boolean hasFirstAudioDuration() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Duration of first audio chunk.
   * </pre>
   *
   * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
   *
   * @return The firstAudioDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getFirstAudioDuration() {
    return firstAudioDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : firstAudioDuration_;
  }

  /**
   *
   *
   * <pre>
   * Duration of first audio chunk.
   * </pre>
   *
   * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getFirstAudioDurationOrBuilder() {
    return firstAudioDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : firstAudioDuration_;
  }

  public static final int SINGLE_UTTERANCE_FIELD_NUMBER = 5;
  private boolean singleUtterance_ = false;

  /**
   *
   *
   * <pre>
   * Whether client used single utterance mode.
   * </pre>
   *
   * <code>bool single_utterance = 5;</code>
   *
   * @return The singleUtterance.
   */
  @java.lang.Override
  public boolean getSingleUtterance() {
    return singleUtterance_;
  }

  public static final int SPEECH_PARTIAL_RESULTS_END_TIMES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Duration> speechPartialResultsEndTimes_;

  /**
   *
   *
   * <pre>
   * Time offsets of the speech partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Duration> getSpeechPartialResultsEndTimesList() {
    return speechPartialResultsEndTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
      getSpeechPartialResultsEndTimesOrBuilderList() {
    return speechPartialResultsEndTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
   */
  @java.lang.Override
  public int getSpeechPartialResultsEndTimesCount() {
    return speechPartialResultsEndTimes_.size();
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Duration getSpeechPartialResultsEndTimes(int index) {
    return speechPartialResultsEndTimes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getSpeechPartialResultsEndTimesOrBuilder(int index) {
    return speechPartialResultsEndTimes_.get(index);
  }

  public static final int SPEECH_FINAL_RESULTS_END_TIMES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Duration> speechFinalResultsEndTimes_;

  /**
   *
   *
   * <pre>
   * Time offsets of the speech final results (is_final=true) relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Duration> getSpeechFinalResultsEndTimesList() {
    return speechFinalResultsEndTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech final results (is_final=true) relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
      getSpeechFinalResultsEndTimesOrBuilderList() {
    return speechFinalResultsEndTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech final results (is_final=true) relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
   */
  @java.lang.Override
  public int getSpeechFinalResultsEndTimesCount() {
    return speechFinalResultsEndTimes_.size();
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech final results (is_final=true) relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Duration getSpeechFinalResultsEndTimes(int index) {
    return speechFinalResultsEndTimes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the speech final results (is_final=true) relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getSpeechFinalResultsEndTimesOrBuilder(int index) {
    return speechFinalResultsEndTimes_.get(index);
  }

  public static final int PARTIAL_RESPONSES_FIELD_NUMBER = 8;
  private int partialResponses_ = 0;

  /**
   *
   *
   * <pre>
   * Total number of partial responses.
   * </pre>
   *
   * <code>int32 partial_responses = 8;</code>
   *
   * @return The partialResponses.
   */
  @java.lang.Override
  public int getPartialResponses() {
    return partialResponses_;
  }

  public static final int SPEAKER_ID_PASSIVE_LATENCY_MS_OFFSET_FIELD_NUMBER = 9;
  private int speakerIdPassiveLatencyMsOffset_ = 0;

  /**
   *
   *
   * <pre>
   * Time offset of Speaker ID stream close time relative to the Speech stream
   * close time in milliseconds. Only meaningful for conversations involving
   * passive verification.
   * </pre>
   *
   * <code>int32 speaker_id_passive_latency_ms_offset = 9;</code>
   *
   * @return The speakerIdPassiveLatencyMsOffset.
   */
  @java.lang.Override
  public int getSpeakerIdPassiveLatencyMsOffset() {
    return speakerIdPassiveLatencyMsOffset_;
  }

  public static final int BARGEIN_EVENT_TRIGGERED_FIELD_NUMBER = 10;
  private boolean bargeinEventTriggered_ = false;

  /**
   *
   *
   * <pre>
   * Whether a barge-in event is triggered in this request.
   * </pre>
   *
   * <code>bool bargein_event_triggered = 10;</code>
   *
   * @return The bargeinEventTriggered.
   */
  @java.lang.Override
  public boolean getBargeinEventTriggered() {
    return bargeinEventTriggered_;
  }

  public static final int SPEECH_SINGLE_UTTERANCE_FIELD_NUMBER = 11;
  private boolean speechSingleUtterance_ = false;

  /**
   *
   *
   * <pre>
   * Whether speech uses single utterance mode.
   * </pre>
   *
   * <code>bool speech_single_utterance = 11;</code>
   *
   * @return The speechSingleUtterance.
   */
  @java.lang.Override
  public boolean getSpeechSingleUtterance() {
    return speechSingleUtterance_;
  }

  public static final int DTMF_PARTIAL_RESULTS_TIMES_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Duration> dtmfPartialResultsTimes_;

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Duration> getDtmfPartialResultsTimesList() {
    return dtmfPartialResultsTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
      getDtmfPartialResultsTimesOrBuilderList() {
    return dtmfPartialResultsTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
   */
  @java.lang.Override
  public int getDtmfPartialResultsTimesCount() {
    return dtmfPartialResultsTimes_.size();
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDtmfPartialResultsTimes(int index) {
    return dtmfPartialResultsTimes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF partial results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDtmfPartialResultsTimesOrBuilder(int index) {
    return dtmfPartialResultsTimes_.get(index);
  }

  public static final int DTMF_FINAL_RESULTS_TIMES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Duration> dtmfFinalResultsTimes_;

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF final results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Duration> getDtmfFinalResultsTimesList() {
    return dtmfFinalResultsTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF final results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
      getDtmfFinalResultsTimesOrBuilderList() {
    return dtmfFinalResultsTimes_;
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF final results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
   */
  @java.lang.Override
  public int getDtmfFinalResultsTimesCount() {
    return dtmfFinalResultsTimes_.size();
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF final results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDtmfFinalResultsTimes(int index) {
    return dtmfFinalResultsTimes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Time offsets of the DTMF final results relative to the beginning of
   * the stream.
   * </pre>
   *
   * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDtmfFinalResultsTimesOrBuilder(int index) {
    return dtmfFinalResultsTimes_.get(index);
  }

  public static final int SINGLE_UTTERANCE_END_TIME_OFFSET_FIELD_NUMBER = 14;
  private com.google.protobuf.Duration singleUtteranceEndTimeOffset_;

  /**
   *
   *
   * <pre>
   * Time offset of the end-of-single-utterance signal relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
   *
   * @return Whether the singleUtteranceEndTimeOffset field is set.
   */
  @java.lang.Override
  public boolean hasSingleUtteranceEndTimeOffset() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Time offset of the end-of-single-utterance signal relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
   *
   * @return The singleUtteranceEndTimeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getSingleUtteranceEndTimeOffset() {
    return singleUtteranceEndTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : singleUtteranceEndTimeOffset_;
  }

  /**
   *
   *
   * <pre>
   * Time offset of the end-of-single-utterance signal relative to the
   * beginning of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getSingleUtteranceEndTimeOffsetOrBuilder() {
    return singleUtteranceEndTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : singleUtteranceEndTimeOffset_;
  }

  public static final int NO_SPEECH_TIMEOUT_FIELD_NUMBER = 15;
  private com.google.protobuf.Duration noSpeechTimeout_;

  /**
   *
   *
   * <pre>
   * No speech timeout settings for the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
   *
   * @return Whether the noSpeechTimeout field is set.
   */
  @java.lang.Override
  public boolean hasNoSpeechTimeout() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * No speech timeout settings for the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
   *
   * @return The noSpeechTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getNoSpeechTimeout() {
    return noSpeechTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : noSpeechTimeout_;
  }

  /**
   *
   *
   * <pre>
   * No speech timeout settings for the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getNoSpeechTimeoutOrBuilder() {
    return noSpeechTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : noSpeechTimeout_;
  }

  public static final int ENDPOINTING_TIMEOUT_FIELD_NUMBER = 19;
  private com.google.protobuf.Duration endpointingTimeout_;

  /**
   *
   *
   * <pre>
   * Speech endpointing timeout settings for the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
   *
   * @return Whether the endpointingTimeout field is set.
   */
  @java.lang.Override
  public boolean hasEndpointingTimeout() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Speech endpointing timeout settings for the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
   *
   * @return The endpointingTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getEndpointingTimeout() {
    return endpointingTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : endpointingTimeout_;
  }

  /**
   *
   *
   * <pre>
   * Speech endpointing timeout settings for the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getEndpointingTimeoutOrBuilder() {
    return endpointingTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : endpointingTimeout_;
  }

  public static final int IS_INPUT_TEXT_FIELD_NUMBER = 16;
  private boolean isInputText_ = false;

  /**
   *
   *
   * <pre>
   * Whether the streaming terminates with an injected text query.
   * </pre>
   *
   * <code>bool is_input_text = 16;</code>
   *
   * @return The isInputText.
   */
  @java.lang.Override
  public boolean getIsInputText() {
    return isInputText_;
  }

  public static final int CLIENT_HALF_CLOSE_TIME_OFFSET_FIELD_NUMBER = 17;
  private com.google.protobuf.Duration clientHalfCloseTimeOffset_;

  /**
   *
   *
   * <pre>
   * Client half close time in terms of input audio duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
   *
   * @return Whether the clientHalfCloseTimeOffset field is set.
   */
  @java.lang.Override
  public boolean hasClientHalfCloseTimeOffset() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Client half close time in terms of input audio duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
   *
   * @return The clientHalfCloseTimeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getClientHalfCloseTimeOffset() {
    return clientHalfCloseTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : clientHalfCloseTimeOffset_;
  }

  /**
   *
   *
   * <pre>
   * Client half close time in terms of input audio duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getClientHalfCloseTimeOffsetOrBuilder() {
    return clientHalfCloseTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : clientHalfCloseTimeOffset_;
  }

  public static final int CLIENT_HALF_CLOSE_STREAMING_TIME_OFFSET_FIELD_NUMBER = 18;
  private com.google.protobuf.Duration clientHalfCloseStreamingTimeOffset_;

  /**
   *
   *
   * <pre>
   * Client half close time in terms of API streaming duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
   *
   * @return Whether the clientHalfCloseStreamingTimeOffset field is set.
   */
  @java.lang.Override
  public boolean hasClientHalfCloseStreamingTimeOffset() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Client half close time in terms of API streaming duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
   *
   * @return The clientHalfCloseStreamingTimeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getClientHalfCloseStreamingTimeOffset() {
    return clientHalfCloseStreamingTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : clientHalfCloseStreamingTimeOffset_;
  }

  /**
   *
   *
   * <pre>
   * Client half close time in terms of API streaming duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getClientHalfCloseStreamingTimeOffsetOrBuilder() {
    return clientHalfCloseStreamingTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : clientHalfCloseStreamingTimeOffset_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (audioDataChunks_ != 0) {
      output.writeInt32(1, audioDataChunks_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getResultEndTimeOffset());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getFirstAudioDuration());
    }
    if (singleUtterance_ != false) {
      output.writeBool(5, singleUtterance_);
    }
    for (int i = 0; i < speechPartialResultsEndTimes_.size(); i++) {
      output.writeMessage(6, speechPartialResultsEndTimes_.get(i));
    }
    for (int i = 0; i < speechFinalResultsEndTimes_.size(); i++) {
      output.writeMessage(7, speechFinalResultsEndTimes_.get(i));
    }
    if (partialResponses_ != 0) {
      output.writeInt32(8, partialResponses_);
    }
    if (speakerIdPassiveLatencyMsOffset_ != 0) {
      output.writeInt32(9, speakerIdPassiveLatencyMsOffset_);
    }
    if (bargeinEventTriggered_ != false) {
      output.writeBool(10, bargeinEventTriggered_);
    }
    if (speechSingleUtterance_ != false) {
      output.writeBool(11, speechSingleUtterance_);
    }
    for (int i = 0; i < dtmfPartialResultsTimes_.size(); i++) {
      output.writeMessage(12, dtmfPartialResultsTimes_.get(i));
    }
    for (int i = 0; i < dtmfFinalResultsTimes_.size(); i++) {
      output.writeMessage(13, dtmfFinalResultsTimes_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(14, getSingleUtteranceEndTimeOffset());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(15, getNoSpeechTimeout());
    }
    if (isInputText_ != false) {
      output.writeBool(16, isInputText_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(17, getClientHalfCloseTimeOffset());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(18, getClientHalfCloseStreamingTimeOffset());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(19, getEndpointingTimeout());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (audioDataChunks_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, audioDataChunks_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResultEndTimeOffset());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFirstAudioDuration());
    }
    if (singleUtterance_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, singleUtterance_);
    }
    for (int i = 0; i < speechPartialResultsEndTimes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, speechPartialResultsEndTimes_.get(i));
    }
    for (int i = 0; i < speechFinalResultsEndTimes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, speechFinalResultsEndTimes_.get(i));
    }
    if (partialResponses_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, partialResponses_);
    }
    if (speakerIdPassiveLatencyMsOffset_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              9, speakerIdPassiveLatencyMsOffset_);
    }
    if (bargeinEventTriggered_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, bargeinEventTriggered_);
    }
    if (speechSingleUtterance_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, speechSingleUtterance_);
    }
    for (int i = 0; i < dtmfPartialResultsTimes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, dtmfPartialResultsTimes_.get(i));
    }
    for (int i = 0; i < dtmfFinalResultsTimes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, dtmfFinalResultsTimes_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, getSingleUtteranceEndTimeOffset());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getNoSpeechTimeout());
    }
    if (isInputText_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, isInputText_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getClientHalfCloseTimeOffset());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, getClientHalfCloseStreamingTimeOffset());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getEndpointingTimeout());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo other =
        (com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo) obj;

    if (getAudioDataChunks() != other.getAudioDataChunks()) return false;
    if (hasResultEndTimeOffset() != other.hasResultEndTimeOffset()) return false;
    if (hasResultEndTimeOffset()) {
      if (!getResultEndTimeOffset().equals(other.getResultEndTimeOffset())) return false;
    }
    if (hasFirstAudioDuration() != other.hasFirstAudioDuration()) return false;
    if (hasFirstAudioDuration()) {
      if (!getFirstAudioDuration().equals(other.getFirstAudioDuration())) return false;
    }
    if (getSingleUtterance() != other.getSingleUtterance()) return false;
    if (!getSpeechPartialResultsEndTimesList().equals(other.getSpeechPartialResultsEndTimesList()))
      return false;
    if (!getSpeechFinalResultsEndTimesList().equals(other.getSpeechFinalResultsEndTimesList()))
      return false;
    if (getPartialResponses() != other.getPartialResponses()) return false;
    if (getSpeakerIdPassiveLatencyMsOffset() != other.getSpeakerIdPassiveLatencyMsOffset())
      return false;
    if (getBargeinEventTriggered() != other.getBargeinEventTriggered()) return false;
    if (getSpeechSingleUtterance() != other.getSpeechSingleUtterance()) return false;
    if (!getDtmfPartialResultsTimesList().equals(other.getDtmfPartialResultsTimesList()))
      return false;
    if (!getDtmfFinalResultsTimesList().equals(other.getDtmfFinalResultsTimesList())) return false;
    if (hasSingleUtteranceEndTimeOffset() != other.hasSingleUtteranceEndTimeOffset()) return false;
    if (hasSingleUtteranceEndTimeOffset()) {
      if (!getSingleUtteranceEndTimeOffset().equals(other.getSingleUtteranceEndTimeOffset()))
        return false;
    }
    if (hasNoSpeechTimeout() != other.hasNoSpeechTimeout()) return false;
    if (hasNoSpeechTimeout()) {
      if (!getNoSpeechTimeout().equals(other.getNoSpeechTimeout())) return false;
    }
    if (hasEndpointingTimeout() != other.hasEndpointingTimeout()) return false;
    if (hasEndpointingTimeout()) {
      if (!getEndpointingTimeout().equals(other.getEndpointingTimeout())) return false;
    }
    if (getIsInputText() != other.getIsInputText()) return false;
    if (hasClientHalfCloseTimeOffset() != other.hasClientHalfCloseTimeOffset()) return false;
    if (hasClientHalfCloseTimeOffset()) {
      if (!getClientHalfCloseTimeOffset().equals(other.getClientHalfCloseTimeOffset()))
        return false;
    }
    if (hasClientHalfCloseStreamingTimeOffset() != other.hasClientHalfCloseStreamingTimeOffset())
      return false;
    if (hasClientHalfCloseStreamingTimeOffset()) {
      if (!getClientHalfCloseStreamingTimeOffset()
          .equals(other.getClientHalfCloseStreamingTimeOffset())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUDIO_DATA_CHUNKS_FIELD_NUMBER;
    hash = (53 * hash) + getAudioDataChunks();
    if (hasResultEndTimeOffset()) {
      hash = (37 * hash) + RESULT_END_TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getResultEndTimeOffset().hashCode();
    }
    if (hasFirstAudioDuration()) {
      hash = (37 * hash) + FIRST_AUDIO_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getFirstAudioDuration().hashCode();
    }
    hash = (37 * hash) + SINGLE_UTTERANCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSingleUtterance());
    if (getSpeechPartialResultsEndTimesCount() > 0) {
      hash = (37 * hash) + SPEECH_PARTIAL_RESULTS_END_TIMES_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechPartialResultsEndTimesList().hashCode();
    }
    if (getSpeechFinalResultsEndTimesCount() > 0) {
      hash = (37 * hash) + SPEECH_FINAL_RESULTS_END_TIMES_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechFinalResultsEndTimesList().hashCode();
    }
    hash = (37 * hash) + PARTIAL_RESPONSES_FIELD_NUMBER;
    hash = (53 * hash) + getPartialResponses();
    hash = (37 * hash) + SPEAKER_ID_PASSIVE_LATENCY_MS_OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + getSpeakerIdPassiveLatencyMsOffset();
    hash = (37 * hash) + BARGEIN_EVENT_TRIGGERED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBargeinEventTriggered());
    hash = (37 * hash) + SPEECH_SINGLE_UTTERANCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSpeechSingleUtterance());
    if (getDtmfPartialResultsTimesCount() > 0) {
      hash = (37 * hash) + DTMF_PARTIAL_RESULTS_TIMES_FIELD_NUMBER;
      hash = (53 * hash) + getDtmfPartialResultsTimesList().hashCode();
    }
    if (getDtmfFinalResultsTimesCount() > 0) {
      hash = (37 * hash) + DTMF_FINAL_RESULTS_TIMES_FIELD_NUMBER;
      hash = (53 * hash) + getDtmfFinalResultsTimesList().hashCode();
    }
    if (hasSingleUtteranceEndTimeOffset()) {
      hash = (37 * hash) + SINGLE_UTTERANCE_END_TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getSingleUtteranceEndTimeOffset().hashCode();
    }
    if (hasNoSpeechTimeout()) {
      hash = (37 * hash) + NO_SPEECH_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getNoSpeechTimeout().hashCode();
    }
    if (hasEndpointingTimeout()) {
      hash = (37 * hash) + ENDPOINTING_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointingTimeout().hashCode();
    }
    hash = (37 * hash) + IS_INPUT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsInputText());
    if (hasClientHalfCloseTimeOffset()) {
      hash = (37 * hash) + CLIENT_HALF_CLOSE_TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getClientHalfCloseTimeOffset().hashCode();
    }
    if (hasClientHalfCloseStreamingTimeOffset()) {
      hash = (37 * hash) + CLIENT_HALF_CLOSE_STREAMING_TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getClientHalfCloseStreamingTimeOffset().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Cloud conversation info for easier debugging.
   * It will get populated in `StreamingDetectIntentResponse` or
   * `StreamingAnalyzeContentResponse` when the flag `enable_debugging_info` is
   * set to true in corresponding requests.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo)
      com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_CloudConversationDebuggingInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_CloudConversationDebuggingInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo.class,
              com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultEndTimeOffsetFieldBuilder();
        getFirstAudioDurationFieldBuilder();
        getSpeechPartialResultsEndTimesFieldBuilder();
        getSpeechFinalResultsEndTimesFieldBuilder();
        getDtmfPartialResultsTimesFieldBuilder();
        getDtmfFinalResultsTimesFieldBuilder();
        getSingleUtteranceEndTimeOffsetFieldBuilder();
        getNoSpeechTimeoutFieldBuilder();
        getEndpointingTimeoutFieldBuilder();
        getClientHalfCloseTimeOffsetFieldBuilder();
        getClientHalfCloseStreamingTimeOffsetFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      audioDataChunks_ = 0;
      resultEndTimeOffset_ = null;
      if (resultEndTimeOffsetBuilder_ != null) {
        resultEndTimeOffsetBuilder_.dispose();
        resultEndTimeOffsetBuilder_ = null;
      }
      firstAudioDuration_ = null;
      if (firstAudioDurationBuilder_ != null) {
        firstAudioDurationBuilder_.dispose();
        firstAudioDurationBuilder_ = null;
      }
      singleUtterance_ = false;
      if (speechPartialResultsEndTimesBuilder_ == null) {
        speechPartialResultsEndTimes_ = java.util.Collections.emptyList();
      } else {
        speechPartialResultsEndTimes_ = null;
        speechPartialResultsEndTimesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (speechFinalResultsEndTimesBuilder_ == null) {
        speechFinalResultsEndTimes_ = java.util.Collections.emptyList();
      } else {
        speechFinalResultsEndTimes_ = null;
        speechFinalResultsEndTimesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      partialResponses_ = 0;
      speakerIdPassiveLatencyMsOffset_ = 0;
      bargeinEventTriggered_ = false;
      speechSingleUtterance_ = false;
      if (dtmfPartialResultsTimesBuilder_ == null) {
        dtmfPartialResultsTimes_ = java.util.Collections.emptyList();
      } else {
        dtmfPartialResultsTimes_ = null;
        dtmfPartialResultsTimesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      if (dtmfFinalResultsTimesBuilder_ == null) {
        dtmfFinalResultsTimes_ = java.util.Collections.emptyList();
      } else {
        dtmfFinalResultsTimes_ = null;
        dtmfFinalResultsTimesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      singleUtteranceEndTimeOffset_ = null;
      if (singleUtteranceEndTimeOffsetBuilder_ != null) {
        singleUtteranceEndTimeOffsetBuilder_.dispose();
        singleUtteranceEndTimeOffsetBuilder_ = null;
      }
      noSpeechTimeout_ = null;
      if (noSpeechTimeoutBuilder_ != null) {
        noSpeechTimeoutBuilder_.dispose();
        noSpeechTimeoutBuilder_ = null;
      }
      endpointingTimeout_ = null;
      if (endpointingTimeoutBuilder_ != null) {
        endpointingTimeoutBuilder_.dispose();
        endpointingTimeoutBuilder_ = null;
      }
      isInputText_ = false;
      clientHalfCloseTimeOffset_ = null;
      if (clientHalfCloseTimeOffsetBuilder_ != null) {
        clientHalfCloseTimeOffsetBuilder_.dispose();
        clientHalfCloseTimeOffsetBuilder_ = null;
      }
      clientHalfCloseStreamingTimeOffset_ = null;
      if (clientHalfCloseStreamingTimeOffsetBuilder_ != null) {
        clientHalfCloseStreamingTimeOffsetBuilder_.dispose();
        clientHalfCloseStreamingTimeOffsetBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_CloudConversationDebuggingInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo build() {
      com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo buildPartial() {
      com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo result =
          new com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo result) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          speechPartialResultsEndTimes_ =
              java.util.Collections.unmodifiableList(speechPartialResultsEndTimes_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.speechPartialResultsEndTimes_ = speechPartialResultsEndTimes_;
      } else {
        result.speechPartialResultsEndTimes_ = speechPartialResultsEndTimesBuilder_.build();
      }
      if (speechFinalResultsEndTimesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          speechFinalResultsEndTimes_ =
              java.util.Collections.unmodifiableList(speechFinalResultsEndTimes_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.speechFinalResultsEndTimes_ = speechFinalResultsEndTimes_;
      } else {
        result.speechFinalResultsEndTimes_ = speechFinalResultsEndTimesBuilder_.build();
      }
      if (dtmfPartialResultsTimesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          dtmfPartialResultsTimes_ =
              java.util.Collections.unmodifiableList(dtmfPartialResultsTimes_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.dtmfPartialResultsTimes_ = dtmfPartialResultsTimes_;
      } else {
        result.dtmfPartialResultsTimes_ = dtmfPartialResultsTimesBuilder_.build();
      }
      if (dtmfFinalResultsTimesBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          dtmfFinalResultsTimes_ = java.util.Collections.unmodifiableList(dtmfFinalResultsTimes_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.dtmfFinalResultsTimes_ = dtmfFinalResultsTimes_;
      } else {
        result.dtmfFinalResultsTimes_ = dtmfFinalResultsTimesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.audioDataChunks_ = audioDataChunks_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resultEndTimeOffset_ =
            resultEndTimeOffsetBuilder_ == null
                ? resultEndTimeOffset_
                : resultEndTimeOffsetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.firstAudioDuration_ =
            firstAudioDurationBuilder_ == null
                ? firstAudioDuration_
                : firstAudioDurationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.singleUtterance_ = singleUtterance_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.partialResponses_ = partialResponses_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.speakerIdPassiveLatencyMsOffset_ = speakerIdPassiveLatencyMsOffset_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.bargeinEventTriggered_ = bargeinEventTriggered_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.speechSingleUtterance_ = speechSingleUtterance_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.singleUtteranceEndTimeOffset_ =
            singleUtteranceEndTimeOffsetBuilder_ == null
                ? singleUtteranceEndTimeOffset_
                : singleUtteranceEndTimeOffsetBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.noSpeechTimeout_ =
            noSpeechTimeoutBuilder_ == null ? noSpeechTimeout_ : noSpeechTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.endpointingTimeout_ =
            endpointingTimeoutBuilder_ == null
                ? endpointingTimeout_
                : endpointingTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.isInputText_ = isInputText_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.clientHalfCloseTimeOffset_ =
            clientHalfCloseTimeOffsetBuilder_ == null
                ? clientHalfCloseTimeOffset_
                : clientHalfCloseTimeOffsetBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.clientHalfCloseStreamingTimeOffset_ =
            clientHalfCloseStreamingTimeOffsetBuilder_ == null
                ? clientHalfCloseStreamingTimeOffset_
                : clientHalfCloseStreamingTimeOffsetBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo) {
        return mergeFrom(
            (com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
              .getDefaultInstance()) return this;
      if (other.getAudioDataChunks() != 0) {
        setAudioDataChunks(other.getAudioDataChunks());
      }
      if (other.hasResultEndTimeOffset()) {
        mergeResultEndTimeOffset(other.getResultEndTimeOffset());
      }
      if (other.hasFirstAudioDuration()) {
        mergeFirstAudioDuration(other.getFirstAudioDuration());
      }
      if (other.getSingleUtterance() != false) {
        setSingleUtterance(other.getSingleUtterance());
      }
      if (speechPartialResultsEndTimesBuilder_ == null) {
        if (!other.speechPartialResultsEndTimes_.isEmpty()) {
          if (speechPartialResultsEndTimes_.isEmpty()) {
            speechPartialResultsEndTimes_ = other.speechPartialResultsEndTimes_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureSpeechPartialResultsEndTimesIsMutable();
            speechPartialResultsEndTimes_.addAll(other.speechPartialResultsEndTimes_);
          }
          onChanged();
        }
      } else {
        if (!other.speechPartialResultsEndTimes_.isEmpty()) {
          if (speechPartialResultsEndTimesBuilder_.isEmpty()) {
            speechPartialResultsEndTimesBuilder_.dispose();
            speechPartialResultsEndTimesBuilder_ = null;
            speechPartialResultsEndTimes_ = other.speechPartialResultsEndTimes_;
            bitField0_ = (bitField0_ & ~0x00000010);
            speechPartialResultsEndTimesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpeechPartialResultsEndTimesFieldBuilder()
                    : null;
          } else {
            speechPartialResultsEndTimesBuilder_.addAllMessages(
                other.speechPartialResultsEndTimes_);
          }
        }
      }
      if (speechFinalResultsEndTimesBuilder_ == null) {
        if (!other.speechFinalResultsEndTimes_.isEmpty()) {
          if (speechFinalResultsEndTimes_.isEmpty()) {
            speechFinalResultsEndTimes_ = other.speechFinalResultsEndTimes_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureSpeechFinalResultsEndTimesIsMutable();
            speechFinalResultsEndTimes_.addAll(other.speechFinalResultsEndTimes_);
          }
          onChanged();
        }
      } else {
        if (!other.speechFinalResultsEndTimes_.isEmpty()) {
          if (speechFinalResultsEndTimesBuilder_.isEmpty()) {
            speechFinalResultsEndTimesBuilder_.dispose();
            speechFinalResultsEndTimesBuilder_ = null;
            speechFinalResultsEndTimes_ = other.speechFinalResultsEndTimes_;
            bitField0_ = (bitField0_ & ~0x00000020);
            speechFinalResultsEndTimesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpeechFinalResultsEndTimesFieldBuilder()
                    : null;
          } else {
            speechFinalResultsEndTimesBuilder_.addAllMessages(other.speechFinalResultsEndTimes_);
          }
        }
      }
      if (other.getPartialResponses() != 0) {
        setPartialResponses(other.getPartialResponses());
      }
      if (other.getSpeakerIdPassiveLatencyMsOffset() != 0) {
        setSpeakerIdPassiveLatencyMsOffset(other.getSpeakerIdPassiveLatencyMsOffset());
      }
      if (other.getBargeinEventTriggered() != false) {
        setBargeinEventTriggered(other.getBargeinEventTriggered());
      }
      if (other.getSpeechSingleUtterance() != false) {
        setSpeechSingleUtterance(other.getSpeechSingleUtterance());
      }
      if (dtmfPartialResultsTimesBuilder_ == null) {
        if (!other.dtmfPartialResultsTimes_.isEmpty()) {
          if (dtmfPartialResultsTimes_.isEmpty()) {
            dtmfPartialResultsTimes_ = other.dtmfPartialResultsTimes_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureDtmfPartialResultsTimesIsMutable();
            dtmfPartialResultsTimes_.addAll(other.dtmfPartialResultsTimes_);
          }
          onChanged();
        }
      } else {
        if (!other.dtmfPartialResultsTimes_.isEmpty()) {
          if (dtmfPartialResultsTimesBuilder_.isEmpty()) {
            dtmfPartialResultsTimesBuilder_.dispose();
            dtmfPartialResultsTimesBuilder_ = null;
            dtmfPartialResultsTimes_ = other.dtmfPartialResultsTimes_;
            bitField0_ = (bitField0_ & ~0x00000400);
            dtmfPartialResultsTimesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDtmfPartialResultsTimesFieldBuilder()
                    : null;
          } else {
            dtmfPartialResultsTimesBuilder_.addAllMessages(other.dtmfPartialResultsTimes_);
          }
        }
      }
      if (dtmfFinalResultsTimesBuilder_ == null) {
        if (!other.dtmfFinalResultsTimes_.isEmpty()) {
          if (dtmfFinalResultsTimes_.isEmpty()) {
            dtmfFinalResultsTimes_ = other.dtmfFinalResultsTimes_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureDtmfFinalResultsTimesIsMutable();
            dtmfFinalResultsTimes_.addAll(other.dtmfFinalResultsTimes_);
          }
          onChanged();
        }
      } else {
        if (!other.dtmfFinalResultsTimes_.isEmpty()) {
          if (dtmfFinalResultsTimesBuilder_.isEmpty()) {
            dtmfFinalResultsTimesBuilder_.dispose();
            dtmfFinalResultsTimesBuilder_ = null;
            dtmfFinalResultsTimes_ = other.dtmfFinalResultsTimes_;
            bitField0_ = (bitField0_ & ~0x00000800);
            dtmfFinalResultsTimesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDtmfFinalResultsTimesFieldBuilder()
                    : null;
          } else {
            dtmfFinalResultsTimesBuilder_.addAllMessages(other.dtmfFinalResultsTimes_);
          }
        }
      }
      if (other.hasSingleUtteranceEndTimeOffset()) {
        mergeSingleUtteranceEndTimeOffset(other.getSingleUtteranceEndTimeOffset());
      }
      if (other.hasNoSpeechTimeout()) {
        mergeNoSpeechTimeout(other.getNoSpeechTimeout());
      }
      if (other.hasEndpointingTimeout()) {
        mergeEndpointingTimeout(other.getEndpointingTimeout());
      }
      if (other.getIsInputText() != false) {
        setIsInputText(other.getIsInputText());
      }
      if (other.hasClientHalfCloseTimeOffset()) {
        mergeClientHalfCloseTimeOffset(other.getClientHalfCloseTimeOffset());
      }
      if (other.hasClientHalfCloseStreamingTimeOffset()) {
        mergeClientHalfCloseStreamingTimeOffset(other.getClientHalfCloseStreamingTimeOffset());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                audioDataChunks_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getResultEndTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getFirstAudioDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 40:
              {
                singleUtterance_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                com.google.protobuf.Duration m =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (speechPartialResultsEndTimesBuilder_ == null) {
                  ensureSpeechPartialResultsEndTimesIsMutable();
                  speechPartialResultsEndTimes_.add(m);
                } else {
                  speechPartialResultsEndTimesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.Duration m =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (speechFinalResultsEndTimesBuilder_ == null) {
                  ensureSpeechFinalResultsEndTimesIsMutable();
                  speechFinalResultsEndTimes_.add(m);
                } else {
                  speechFinalResultsEndTimesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 64:
              {
                partialResponses_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 72:
              {
                speakerIdPassiveLatencyMsOffset_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 80:
              {
                bargeinEventTriggered_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 88:
              {
                speechSingleUtterance_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 88
            case 98:
              {
                com.google.protobuf.Duration m =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (dtmfPartialResultsTimesBuilder_ == null) {
                  ensureDtmfPartialResultsTimesIsMutable();
                  dtmfPartialResultsTimes_.add(m);
                } else {
                  dtmfPartialResultsTimesBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                com.google.protobuf.Duration m =
                    input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
                if (dtmfFinalResultsTimesBuilder_ == null) {
                  ensureDtmfFinalResultsTimesIsMutable();
                  dtmfFinalResultsTimes_.add(m);
                } else {
                  dtmfFinalResultsTimesBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getSingleUtteranceEndTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getNoSpeechTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 122
            case 128:
              {
                isInputText_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 128
            case 138:
              {
                input.readMessage(
                    getClientHalfCloseTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getClientHalfCloseStreamingTimeOffsetFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getEndpointingTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 154
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int audioDataChunks_;

    /**
     *
     *
     * <pre>
     * Number of input audio data chunks in streaming requests.
     * </pre>
     *
     * <code>int32 audio_data_chunks = 1;</code>
     *
     * @return The audioDataChunks.
     */
    @java.lang.Override
    public int getAudioDataChunks() {
      return audioDataChunks_;
    }

    /**
     *
     *
     * <pre>
     * Number of input audio data chunks in streaming requests.
     * </pre>
     *
     * <code>int32 audio_data_chunks = 1;</code>
     *
     * @param value The audioDataChunks to set.
     * @return This builder for chaining.
     */
    public Builder setAudioDataChunks(int value) {

      audioDataChunks_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Number of input audio data chunks in streaming requests.
     * </pre>
     *
     * <code>int32 audio_data_chunks = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioDataChunks() {
      bitField0_ = (bitField0_ & ~0x00000001);
      audioDataChunks_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration resultEndTimeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        resultEndTimeOffsetBuilder_;

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     *
     * @return Whether the resultEndTimeOffset field is set.
     */
    public boolean hasResultEndTimeOffset() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     *
     * @return The resultEndTimeOffset.
     */
    public com.google.protobuf.Duration getResultEndTimeOffset() {
      if (resultEndTimeOffsetBuilder_ == null) {
        return resultEndTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : resultEndTimeOffset_;
      } else {
        return resultEndTimeOffsetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     */
    public Builder setResultEndTimeOffset(com.google.protobuf.Duration value) {
      if (resultEndTimeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultEndTimeOffset_ = value;
      } else {
        resultEndTimeOffsetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     */
    public Builder setResultEndTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (resultEndTimeOffsetBuilder_ == null) {
        resultEndTimeOffset_ = builderForValue.build();
      } else {
        resultEndTimeOffsetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     */
    public Builder mergeResultEndTimeOffset(com.google.protobuf.Duration value) {
      if (resultEndTimeOffsetBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && resultEndTimeOffset_ != null
            && resultEndTimeOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getResultEndTimeOffsetBuilder().mergeFrom(value);
        } else {
          resultEndTimeOffset_ = value;
        }
      } else {
        resultEndTimeOffsetBuilder_.mergeFrom(value);
      }
      if (resultEndTimeOffset_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     */
    public Builder clearResultEndTimeOffset() {
      bitField0_ = (bitField0_ & ~0x00000002);
      resultEndTimeOffset_ = null;
      if (resultEndTimeOffsetBuilder_ != null) {
        resultEndTimeOffsetBuilder_.dispose();
        resultEndTimeOffsetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getResultEndTimeOffsetBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getResultEndTimeOffsetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getResultEndTimeOffsetOrBuilder() {
      if (resultEndTimeOffsetBuilder_ != null) {
        return resultEndTimeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return resultEndTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : resultEndTimeOffset_;
      }
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end of speech utterance relative to the
     * beginning of the first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration result_end_time_offset = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getResultEndTimeOffsetFieldBuilder() {
      if (resultEndTimeOffsetBuilder_ == null) {
        resultEndTimeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getResultEndTimeOffset(), getParentForChildren(), isClean());
        resultEndTimeOffset_ = null;
      }
      return resultEndTimeOffsetBuilder_;
    }

    private com.google.protobuf.Duration firstAudioDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        firstAudioDurationBuilder_;

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     *
     * @return Whether the firstAudioDuration field is set.
     */
    public boolean hasFirstAudioDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     *
     * @return The firstAudioDuration.
     */
    public com.google.protobuf.Duration getFirstAudioDuration() {
      if (firstAudioDurationBuilder_ == null) {
        return firstAudioDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : firstAudioDuration_;
      } else {
        return firstAudioDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     */
    public Builder setFirstAudioDuration(com.google.protobuf.Duration value) {
      if (firstAudioDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        firstAudioDuration_ = value;
      } else {
        firstAudioDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     */
    public Builder setFirstAudioDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (firstAudioDurationBuilder_ == null) {
        firstAudioDuration_ = builderForValue.build();
      } else {
        firstAudioDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     */
    public Builder mergeFirstAudioDuration(com.google.protobuf.Duration value) {
      if (firstAudioDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && firstAudioDuration_ != null
            && firstAudioDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getFirstAudioDurationBuilder().mergeFrom(value);
        } else {
          firstAudioDuration_ = value;
        }
      } else {
        firstAudioDurationBuilder_.mergeFrom(value);
      }
      if (firstAudioDuration_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     */
    public Builder clearFirstAudioDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      firstAudioDuration_ = null;
      if (firstAudioDurationBuilder_ != null) {
        firstAudioDurationBuilder_.dispose();
        firstAudioDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getFirstAudioDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getFirstAudioDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getFirstAudioDurationOrBuilder() {
      if (firstAudioDurationBuilder_ != null) {
        return firstAudioDurationBuilder_.getMessageOrBuilder();
      } else {
        return firstAudioDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : firstAudioDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * Duration of first audio chunk.
     * </pre>
     *
     * <code>.google.protobuf.Duration first_audio_duration = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getFirstAudioDurationFieldBuilder() {
      if (firstAudioDurationBuilder_ == null) {
        firstAudioDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getFirstAudioDuration(), getParentForChildren(), isClean());
        firstAudioDuration_ = null;
      }
      return firstAudioDurationBuilder_;
    }

    private boolean singleUtterance_;

    /**
     *
     *
     * <pre>
     * Whether client used single utterance mode.
     * </pre>
     *
     * <code>bool single_utterance = 5;</code>
     *
     * @return The singleUtterance.
     */
    @java.lang.Override
    public boolean getSingleUtterance() {
      return singleUtterance_;
    }

    /**
     *
     *
     * <pre>
     * Whether client used single utterance mode.
     * </pre>
     *
     * <code>bool single_utterance = 5;</code>
     *
     * @param value The singleUtterance to set.
     * @return This builder for chaining.
     */
    public Builder setSingleUtterance(boolean value) {

      singleUtterance_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether client used single utterance mode.
     * </pre>
     *
     * <code>bool single_utterance = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSingleUtterance() {
      bitField0_ = (bitField0_ & ~0x00000008);
      singleUtterance_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Duration> speechPartialResultsEndTimes_ =
        java.util.Collections.emptyList();

    private void ensureSpeechPartialResultsEndTimesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        speechPartialResultsEndTimes_ =
            new java.util.ArrayList<com.google.protobuf.Duration>(speechPartialResultsEndTimes_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        speechPartialResultsEndTimesBuilder_;

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public java.util.List<com.google.protobuf.Duration> getSpeechPartialResultsEndTimesList() {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(speechPartialResultsEndTimes_);
      } else {
        return speechPartialResultsEndTimesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public int getSpeechPartialResultsEndTimesCount() {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        return speechPartialResultsEndTimes_.size();
      } else {
        return speechPartialResultsEndTimesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public com.google.protobuf.Duration getSpeechPartialResultsEndTimes(int index) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        return speechPartialResultsEndTimes_.get(index);
      } else {
        return speechPartialResultsEndTimesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder setSpeechPartialResultsEndTimes(int index, com.google.protobuf.Duration value) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechPartialResultsEndTimesIsMutable();
        speechPartialResultsEndTimes_.set(index, value);
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder setSpeechPartialResultsEndTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        ensureSpeechPartialResultsEndTimesIsMutable();
        speechPartialResultsEndTimes_.set(index, builderForValue.build());
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder addSpeechPartialResultsEndTimes(com.google.protobuf.Duration value) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechPartialResultsEndTimesIsMutable();
        speechPartialResultsEndTimes_.add(value);
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder addSpeechPartialResultsEndTimes(int index, com.google.protobuf.Duration value) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechPartialResultsEndTimesIsMutable();
        speechPartialResultsEndTimes_.add(index, value);
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder addSpeechPartialResultsEndTimes(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        ensureSpeechPartialResultsEndTimesIsMutable();
        speechPartialResultsEndTimes_.add(builderForValue.build());
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder addSpeechPartialResultsEndTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        ensureSpeechPartialResultsEndTimesIsMutable();
        speechPartialResultsEndTimes_.add(index, builderForValue.build());
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder addAllSpeechPartialResultsEndTimes(
        java.lang.Iterable<? extends com.google.protobuf.Duration> values) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        ensureSpeechPartialResultsEndTimesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, speechPartialResultsEndTimes_);
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder clearSpeechPartialResultsEndTimes() {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        speechPartialResultsEndTimes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public Builder removeSpeechPartialResultsEndTimes(int index) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        ensureSpeechPartialResultsEndTimesIsMutable();
        speechPartialResultsEndTimes_.remove(index);
        onChanged();
      } else {
        speechPartialResultsEndTimesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getSpeechPartialResultsEndTimesBuilder(int index) {
      return getSpeechPartialResultsEndTimesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getSpeechPartialResultsEndTimesOrBuilder(
        int index) {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        return speechPartialResultsEndTimes_.get(index);
      } else {
        return speechPartialResultsEndTimesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
        getSpeechPartialResultsEndTimesOrBuilderList() {
      if (speechPartialResultsEndTimesBuilder_ != null) {
        return speechPartialResultsEndTimesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(speechPartialResultsEndTimes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public com.google.protobuf.Duration.Builder addSpeechPartialResultsEndTimesBuilder() {
      return getSpeechPartialResultsEndTimesFieldBuilder()
          .addBuilder(com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public com.google.protobuf.Duration.Builder addSpeechPartialResultsEndTimesBuilder(int index) {
      return getSpeechPartialResultsEndTimesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_partial_results_end_times = 6;</code>
     */
    public java.util.List<com.google.protobuf.Duration.Builder>
        getSpeechPartialResultsEndTimesBuilderList() {
      return getSpeechPartialResultsEndTimesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getSpeechPartialResultsEndTimesFieldBuilder() {
      if (speechPartialResultsEndTimesBuilder_ == null) {
        speechPartialResultsEndTimesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                speechPartialResultsEndTimes_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        speechPartialResultsEndTimes_ = null;
      }
      return speechPartialResultsEndTimesBuilder_;
    }

    private java.util.List<com.google.protobuf.Duration> speechFinalResultsEndTimes_ =
        java.util.Collections.emptyList();

    private void ensureSpeechFinalResultsEndTimesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        speechFinalResultsEndTimes_ =
            new java.util.ArrayList<com.google.protobuf.Duration>(speechFinalResultsEndTimes_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        speechFinalResultsEndTimesBuilder_;

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public java.util.List<com.google.protobuf.Duration> getSpeechFinalResultsEndTimesList() {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(speechFinalResultsEndTimes_);
      } else {
        return speechFinalResultsEndTimesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public int getSpeechFinalResultsEndTimesCount() {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        return speechFinalResultsEndTimes_.size();
      } else {
        return speechFinalResultsEndTimesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public com.google.protobuf.Duration getSpeechFinalResultsEndTimes(int index) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        return speechFinalResultsEndTimes_.get(index);
      } else {
        return speechFinalResultsEndTimesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder setSpeechFinalResultsEndTimes(int index, com.google.protobuf.Duration value) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechFinalResultsEndTimesIsMutable();
        speechFinalResultsEndTimes_.set(index, value);
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder setSpeechFinalResultsEndTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        ensureSpeechFinalResultsEndTimesIsMutable();
        speechFinalResultsEndTimes_.set(index, builderForValue.build());
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder addSpeechFinalResultsEndTimes(com.google.protobuf.Duration value) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechFinalResultsEndTimesIsMutable();
        speechFinalResultsEndTimes_.add(value);
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder addSpeechFinalResultsEndTimes(int index, com.google.protobuf.Duration value) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechFinalResultsEndTimesIsMutable();
        speechFinalResultsEndTimes_.add(index, value);
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder addSpeechFinalResultsEndTimes(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        ensureSpeechFinalResultsEndTimesIsMutable();
        speechFinalResultsEndTimes_.add(builderForValue.build());
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder addSpeechFinalResultsEndTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        ensureSpeechFinalResultsEndTimesIsMutable();
        speechFinalResultsEndTimes_.add(index, builderForValue.build());
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder addAllSpeechFinalResultsEndTimes(
        java.lang.Iterable<? extends com.google.protobuf.Duration> values) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        ensureSpeechFinalResultsEndTimesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, speechFinalResultsEndTimes_);
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder clearSpeechFinalResultsEndTimes() {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        speechFinalResultsEndTimes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public Builder removeSpeechFinalResultsEndTimes(int index) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        ensureSpeechFinalResultsEndTimesIsMutable();
        speechFinalResultsEndTimes_.remove(index);
        onChanged();
      } else {
        speechFinalResultsEndTimesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getSpeechFinalResultsEndTimesBuilder(int index) {
      return getSpeechFinalResultsEndTimesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getSpeechFinalResultsEndTimesOrBuilder(int index) {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        return speechFinalResultsEndTimes_.get(index);
      } else {
        return speechFinalResultsEndTimesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
        getSpeechFinalResultsEndTimesOrBuilderList() {
      if (speechFinalResultsEndTimesBuilder_ != null) {
        return speechFinalResultsEndTimesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(speechFinalResultsEndTimes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public com.google.protobuf.Duration.Builder addSpeechFinalResultsEndTimesBuilder() {
      return getSpeechFinalResultsEndTimesFieldBuilder()
          .addBuilder(com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public com.google.protobuf.Duration.Builder addSpeechFinalResultsEndTimesBuilder(int index) {
      return getSpeechFinalResultsEndTimesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the speech final results (is_final=true) relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration speech_final_results_end_times = 7;</code>
     */
    public java.util.List<com.google.protobuf.Duration.Builder>
        getSpeechFinalResultsEndTimesBuilderList() {
      return getSpeechFinalResultsEndTimesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getSpeechFinalResultsEndTimesFieldBuilder() {
      if (speechFinalResultsEndTimesBuilder_ == null) {
        speechFinalResultsEndTimesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                speechFinalResultsEndTimes_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        speechFinalResultsEndTimes_ = null;
      }
      return speechFinalResultsEndTimesBuilder_;
    }

    private int partialResponses_;

    /**
     *
     *
     * <pre>
     * Total number of partial responses.
     * </pre>
     *
     * <code>int32 partial_responses = 8;</code>
     *
     * @return The partialResponses.
     */
    @java.lang.Override
    public int getPartialResponses() {
      return partialResponses_;
    }

    /**
     *
     *
     * <pre>
     * Total number of partial responses.
     * </pre>
     *
     * <code>int32 partial_responses = 8;</code>
     *
     * @param value The partialResponses to set.
     * @return This builder for chaining.
     */
    public Builder setPartialResponses(int value) {

      partialResponses_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Total number of partial responses.
     * </pre>
     *
     * <code>int32 partial_responses = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartialResponses() {
      bitField0_ = (bitField0_ & ~0x00000040);
      partialResponses_ = 0;
      onChanged();
      return this;
    }

    private int speakerIdPassiveLatencyMsOffset_;

    /**
     *
     *
     * <pre>
     * Time offset of Speaker ID stream close time relative to the Speech stream
     * close time in milliseconds. Only meaningful for conversations involving
     * passive verification.
     * </pre>
     *
     * <code>int32 speaker_id_passive_latency_ms_offset = 9;</code>
     *
     * @return The speakerIdPassiveLatencyMsOffset.
     */
    @java.lang.Override
    public int getSpeakerIdPassiveLatencyMsOffset() {
      return speakerIdPassiveLatencyMsOffset_;
    }

    /**
     *
     *
     * <pre>
     * Time offset of Speaker ID stream close time relative to the Speech stream
     * close time in milliseconds. Only meaningful for conversations involving
     * passive verification.
     * </pre>
     *
     * <code>int32 speaker_id_passive_latency_ms_offset = 9;</code>
     *
     * @param value The speakerIdPassiveLatencyMsOffset to set.
     * @return This builder for chaining.
     */
    public Builder setSpeakerIdPassiveLatencyMsOffset(int value) {

      speakerIdPassiveLatencyMsOffset_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of Speaker ID stream close time relative to the Speech stream
     * close time in milliseconds. Only meaningful for conversations involving
     * passive verification.
     * </pre>
     *
     * <code>int32 speaker_id_passive_latency_ms_offset = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeakerIdPassiveLatencyMsOffset() {
      bitField0_ = (bitField0_ & ~0x00000080);
      speakerIdPassiveLatencyMsOffset_ = 0;
      onChanged();
      return this;
    }

    private boolean bargeinEventTriggered_;

    /**
     *
     *
     * <pre>
     * Whether a barge-in event is triggered in this request.
     * </pre>
     *
     * <code>bool bargein_event_triggered = 10;</code>
     *
     * @return The bargeinEventTriggered.
     */
    @java.lang.Override
    public boolean getBargeinEventTriggered() {
      return bargeinEventTriggered_;
    }

    /**
     *
     *
     * <pre>
     * Whether a barge-in event is triggered in this request.
     * </pre>
     *
     * <code>bool bargein_event_triggered = 10;</code>
     *
     * @param value The bargeinEventTriggered to set.
     * @return This builder for chaining.
     */
    public Builder setBargeinEventTriggered(boolean value) {

      bargeinEventTriggered_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether a barge-in event is triggered in this request.
     * </pre>
     *
     * <code>bool bargein_event_triggered = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBargeinEventTriggered() {
      bitField0_ = (bitField0_ & ~0x00000100);
      bargeinEventTriggered_ = false;
      onChanged();
      return this;
    }

    private boolean speechSingleUtterance_;

    /**
     *
     *
     * <pre>
     * Whether speech uses single utterance mode.
     * </pre>
     *
     * <code>bool speech_single_utterance = 11;</code>
     *
     * @return The speechSingleUtterance.
     */
    @java.lang.Override
    public boolean getSpeechSingleUtterance() {
      return speechSingleUtterance_;
    }

    /**
     *
     *
     * <pre>
     * Whether speech uses single utterance mode.
     * </pre>
     *
     * <code>bool speech_single_utterance = 11;</code>
     *
     * @param value The speechSingleUtterance to set.
     * @return This builder for chaining.
     */
    public Builder setSpeechSingleUtterance(boolean value) {

      speechSingleUtterance_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether speech uses single utterance mode.
     * </pre>
     *
     * <code>bool speech_single_utterance = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeechSingleUtterance() {
      bitField0_ = (bitField0_ & ~0x00000200);
      speechSingleUtterance_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Duration> dtmfPartialResultsTimes_ =
        java.util.Collections.emptyList();

    private void ensureDtmfPartialResultsTimesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        dtmfPartialResultsTimes_ =
            new java.util.ArrayList<com.google.protobuf.Duration>(dtmfPartialResultsTimes_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        dtmfPartialResultsTimesBuilder_;

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public java.util.List<com.google.protobuf.Duration> getDtmfPartialResultsTimesList() {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dtmfPartialResultsTimes_);
      } else {
        return dtmfPartialResultsTimesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public int getDtmfPartialResultsTimesCount() {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        return dtmfPartialResultsTimes_.size();
      } else {
        return dtmfPartialResultsTimesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public com.google.protobuf.Duration getDtmfPartialResultsTimes(int index) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        return dtmfPartialResultsTimes_.get(index);
      } else {
        return dtmfPartialResultsTimesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder setDtmfPartialResultsTimes(int index, com.google.protobuf.Duration value) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDtmfPartialResultsTimesIsMutable();
        dtmfPartialResultsTimes_.set(index, value);
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder setDtmfPartialResultsTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        ensureDtmfPartialResultsTimesIsMutable();
        dtmfPartialResultsTimes_.set(index, builderForValue.build());
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder addDtmfPartialResultsTimes(com.google.protobuf.Duration value) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDtmfPartialResultsTimesIsMutable();
        dtmfPartialResultsTimes_.add(value);
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder addDtmfPartialResultsTimes(int index, com.google.protobuf.Duration value) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDtmfPartialResultsTimesIsMutable();
        dtmfPartialResultsTimes_.add(index, value);
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder addDtmfPartialResultsTimes(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        ensureDtmfPartialResultsTimesIsMutable();
        dtmfPartialResultsTimes_.add(builderForValue.build());
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder addDtmfPartialResultsTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        ensureDtmfPartialResultsTimesIsMutable();
        dtmfPartialResultsTimes_.add(index, builderForValue.build());
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder addAllDtmfPartialResultsTimes(
        java.lang.Iterable<? extends com.google.protobuf.Duration> values) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        ensureDtmfPartialResultsTimesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dtmfPartialResultsTimes_);
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder clearDtmfPartialResultsTimes() {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        dtmfPartialResultsTimes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public Builder removeDtmfPartialResultsTimes(int index) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        ensureDtmfPartialResultsTimesIsMutable();
        dtmfPartialResultsTimes_.remove(index);
        onChanged();
      } else {
        dtmfPartialResultsTimesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public com.google.protobuf.Duration.Builder getDtmfPartialResultsTimesBuilder(int index) {
      return getDtmfPartialResultsTimesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDtmfPartialResultsTimesOrBuilder(int index) {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        return dtmfPartialResultsTimes_.get(index);
      } else {
        return dtmfPartialResultsTimesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
        getDtmfPartialResultsTimesOrBuilderList() {
      if (dtmfPartialResultsTimesBuilder_ != null) {
        return dtmfPartialResultsTimesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dtmfPartialResultsTimes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public com.google.protobuf.Duration.Builder addDtmfPartialResultsTimesBuilder() {
      return getDtmfPartialResultsTimesFieldBuilder()
          .addBuilder(com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public com.google.protobuf.Duration.Builder addDtmfPartialResultsTimesBuilder(int index) {
      return getDtmfPartialResultsTimesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF partial results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_partial_results_times = 12;</code>
     */
    public java.util.List<com.google.protobuf.Duration.Builder>
        getDtmfPartialResultsTimesBuilderList() {
      return getDtmfPartialResultsTimesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDtmfPartialResultsTimesFieldBuilder() {
      if (dtmfPartialResultsTimesBuilder_ == null) {
        dtmfPartialResultsTimesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                dtmfPartialResultsTimes_,
                ((bitField0_ & 0x00000400) != 0),
                getParentForChildren(),
                isClean());
        dtmfPartialResultsTimes_ = null;
      }
      return dtmfPartialResultsTimesBuilder_;
    }

    private java.util.List<com.google.protobuf.Duration> dtmfFinalResultsTimes_ =
        java.util.Collections.emptyList();

    private void ensureDtmfFinalResultsTimesIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        dtmfFinalResultsTimes_ =
            new java.util.ArrayList<com.google.protobuf.Duration>(dtmfFinalResultsTimes_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        dtmfFinalResultsTimesBuilder_;

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public java.util.List<com.google.protobuf.Duration> getDtmfFinalResultsTimesList() {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dtmfFinalResultsTimes_);
      } else {
        return dtmfFinalResultsTimesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public int getDtmfFinalResultsTimesCount() {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        return dtmfFinalResultsTimes_.size();
      } else {
        return dtmfFinalResultsTimesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public com.google.protobuf.Duration getDtmfFinalResultsTimes(int index) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        return dtmfFinalResultsTimes_.get(index);
      } else {
        return dtmfFinalResultsTimesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder setDtmfFinalResultsTimes(int index, com.google.protobuf.Duration value) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDtmfFinalResultsTimesIsMutable();
        dtmfFinalResultsTimes_.set(index, value);
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder setDtmfFinalResultsTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        ensureDtmfFinalResultsTimesIsMutable();
        dtmfFinalResultsTimes_.set(index, builderForValue.build());
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder addDtmfFinalResultsTimes(com.google.protobuf.Duration value) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDtmfFinalResultsTimesIsMutable();
        dtmfFinalResultsTimes_.add(value);
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder addDtmfFinalResultsTimes(int index, com.google.protobuf.Duration value) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDtmfFinalResultsTimesIsMutable();
        dtmfFinalResultsTimes_.add(index, value);
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder addDtmfFinalResultsTimes(com.google.protobuf.Duration.Builder builderForValue) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        ensureDtmfFinalResultsTimesIsMutable();
        dtmfFinalResultsTimes_.add(builderForValue.build());
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder addDtmfFinalResultsTimes(
        int index, com.google.protobuf.Duration.Builder builderForValue) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        ensureDtmfFinalResultsTimesIsMutable();
        dtmfFinalResultsTimes_.add(index, builderForValue.build());
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder addAllDtmfFinalResultsTimes(
        java.lang.Iterable<? extends com.google.protobuf.Duration> values) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        ensureDtmfFinalResultsTimesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dtmfFinalResultsTimes_);
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder clearDtmfFinalResultsTimes() {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        dtmfFinalResultsTimes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public Builder removeDtmfFinalResultsTimes(int index) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        ensureDtmfFinalResultsTimesIsMutable();
        dtmfFinalResultsTimes_.remove(index);
        onChanged();
      } else {
        dtmfFinalResultsTimesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public com.google.protobuf.Duration.Builder getDtmfFinalResultsTimesBuilder(int index) {
      return getDtmfFinalResultsTimesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDtmfFinalResultsTimesOrBuilder(int index) {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        return dtmfFinalResultsTimes_.get(index);
      } else {
        return dtmfFinalResultsTimesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public java.util.List<? extends com.google.protobuf.DurationOrBuilder>
        getDtmfFinalResultsTimesOrBuilderList() {
      if (dtmfFinalResultsTimesBuilder_ != null) {
        return dtmfFinalResultsTimesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dtmfFinalResultsTimes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public com.google.protobuf.Duration.Builder addDtmfFinalResultsTimesBuilder() {
      return getDtmfFinalResultsTimesFieldBuilder()
          .addBuilder(com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public com.google.protobuf.Duration.Builder addDtmfFinalResultsTimesBuilder(int index) {
      return getDtmfFinalResultsTimesFieldBuilder()
          .addBuilder(index, com.google.protobuf.Duration.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Time offsets of the DTMF final results relative to the beginning of
     * the stream.
     * </pre>
     *
     * <code>repeated .google.protobuf.Duration dtmf_final_results_times = 13;</code>
     */
    public java.util.List<com.google.protobuf.Duration.Builder>
        getDtmfFinalResultsTimesBuilderList() {
      return getDtmfFinalResultsTimesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDtmfFinalResultsTimesFieldBuilder() {
      if (dtmfFinalResultsTimesBuilder_ == null) {
        dtmfFinalResultsTimesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                dtmfFinalResultsTimes_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        dtmfFinalResultsTimes_ = null;
      }
      return dtmfFinalResultsTimesBuilder_;
    }

    private com.google.protobuf.Duration singleUtteranceEndTimeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        singleUtteranceEndTimeOffsetBuilder_;

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     *
     * @return Whether the singleUtteranceEndTimeOffset field is set.
     */
    public boolean hasSingleUtteranceEndTimeOffset() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     *
     * @return The singleUtteranceEndTimeOffset.
     */
    public com.google.protobuf.Duration getSingleUtteranceEndTimeOffset() {
      if (singleUtteranceEndTimeOffsetBuilder_ == null) {
        return singleUtteranceEndTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : singleUtteranceEndTimeOffset_;
      } else {
        return singleUtteranceEndTimeOffsetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     */
    public Builder setSingleUtteranceEndTimeOffset(com.google.protobuf.Duration value) {
      if (singleUtteranceEndTimeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        singleUtteranceEndTimeOffset_ = value;
      } else {
        singleUtteranceEndTimeOffsetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     */
    public Builder setSingleUtteranceEndTimeOffset(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (singleUtteranceEndTimeOffsetBuilder_ == null) {
        singleUtteranceEndTimeOffset_ = builderForValue.build();
      } else {
        singleUtteranceEndTimeOffsetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     */
    public Builder mergeSingleUtteranceEndTimeOffset(com.google.protobuf.Duration value) {
      if (singleUtteranceEndTimeOffsetBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && singleUtteranceEndTimeOffset_ != null
            && singleUtteranceEndTimeOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getSingleUtteranceEndTimeOffsetBuilder().mergeFrom(value);
        } else {
          singleUtteranceEndTimeOffset_ = value;
        }
      } else {
        singleUtteranceEndTimeOffsetBuilder_.mergeFrom(value);
      }
      if (singleUtteranceEndTimeOffset_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     */
    public Builder clearSingleUtteranceEndTimeOffset() {
      bitField0_ = (bitField0_ & ~0x00001000);
      singleUtteranceEndTimeOffset_ = null;
      if (singleUtteranceEndTimeOffsetBuilder_ != null) {
        singleUtteranceEndTimeOffsetBuilder_.dispose();
        singleUtteranceEndTimeOffsetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     */
    public com.google.protobuf.Duration.Builder getSingleUtteranceEndTimeOffsetBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getSingleUtteranceEndTimeOffsetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     */
    public com.google.protobuf.DurationOrBuilder getSingleUtteranceEndTimeOffsetOrBuilder() {
      if (singleUtteranceEndTimeOffsetBuilder_ != null) {
        return singleUtteranceEndTimeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return singleUtteranceEndTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : singleUtteranceEndTimeOffset_;
      }
    }

    /**
     *
     *
     * <pre>
     * Time offset of the end-of-single-utterance signal relative to the
     * beginning of the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration single_utterance_end_time_offset = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getSingleUtteranceEndTimeOffsetFieldBuilder() {
      if (singleUtteranceEndTimeOffsetBuilder_ == null) {
        singleUtteranceEndTimeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getSingleUtteranceEndTimeOffset(), getParentForChildren(), isClean());
        singleUtteranceEndTimeOffset_ = null;
      }
      return singleUtteranceEndTimeOffsetBuilder_;
    }

    private com.google.protobuf.Duration noSpeechTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        noSpeechTimeoutBuilder_;

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     *
     * @return Whether the noSpeechTimeout field is set.
     */
    public boolean hasNoSpeechTimeout() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     *
     * @return The noSpeechTimeout.
     */
    public com.google.protobuf.Duration getNoSpeechTimeout() {
      if (noSpeechTimeoutBuilder_ == null) {
        return noSpeechTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : noSpeechTimeout_;
      } else {
        return noSpeechTimeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     */
    public Builder setNoSpeechTimeout(com.google.protobuf.Duration value) {
      if (noSpeechTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        noSpeechTimeout_ = value;
      } else {
        noSpeechTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     */
    public Builder setNoSpeechTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (noSpeechTimeoutBuilder_ == null) {
        noSpeechTimeout_ = builderForValue.build();
      } else {
        noSpeechTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     */
    public Builder mergeNoSpeechTimeout(com.google.protobuf.Duration value) {
      if (noSpeechTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && noSpeechTimeout_ != null
            && noSpeechTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getNoSpeechTimeoutBuilder().mergeFrom(value);
        } else {
          noSpeechTimeout_ = value;
        }
      } else {
        noSpeechTimeoutBuilder_.mergeFrom(value);
      }
      if (noSpeechTimeout_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     */
    public Builder clearNoSpeechTimeout() {
      bitField0_ = (bitField0_ & ~0x00002000);
      noSpeechTimeout_ = null;
      if (noSpeechTimeoutBuilder_ != null) {
        noSpeechTimeoutBuilder_.dispose();
        noSpeechTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     */
    public com.google.protobuf.Duration.Builder getNoSpeechTimeoutBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getNoSpeechTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     */
    public com.google.protobuf.DurationOrBuilder getNoSpeechTimeoutOrBuilder() {
      if (noSpeechTimeoutBuilder_ != null) {
        return noSpeechTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return noSpeechTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : noSpeechTimeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * No speech timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_speech_timeout = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getNoSpeechTimeoutFieldBuilder() {
      if (noSpeechTimeoutBuilder_ == null) {
        noSpeechTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getNoSpeechTimeout(), getParentForChildren(), isClean());
        noSpeechTimeout_ = null;
      }
      return noSpeechTimeoutBuilder_;
    }

    private com.google.protobuf.Duration endpointingTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        endpointingTimeoutBuilder_;

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     *
     * @return Whether the endpointingTimeout field is set.
     */
    public boolean hasEndpointingTimeout() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     *
     * @return The endpointingTimeout.
     */
    public com.google.protobuf.Duration getEndpointingTimeout() {
      if (endpointingTimeoutBuilder_ == null) {
        return endpointingTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : endpointingTimeout_;
      } else {
        return endpointingTimeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     */
    public Builder setEndpointingTimeout(com.google.protobuf.Duration value) {
      if (endpointingTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpointingTimeout_ = value;
      } else {
        endpointingTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     */
    public Builder setEndpointingTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (endpointingTimeoutBuilder_ == null) {
        endpointingTimeout_ = builderForValue.build();
      } else {
        endpointingTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     */
    public Builder mergeEndpointingTimeout(com.google.protobuf.Duration value) {
      if (endpointingTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && endpointingTimeout_ != null
            && endpointingTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getEndpointingTimeoutBuilder().mergeFrom(value);
        } else {
          endpointingTimeout_ = value;
        }
      } else {
        endpointingTimeoutBuilder_.mergeFrom(value);
      }
      if (endpointingTimeout_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     */
    public Builder clearEndpointingTimeout() {
      bitField0_ = (bitField0_ & ~0x00004000);
      endpointingTimeout_ = null;
      if (endpointingTimeoutBuilder_ != null) {
        endpointingTimeoutBuilder_.dispose();
        endpointingTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     */
    public com.google.protobuf.Duration.Builder getEndpointingTimeoutBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getEndpointingTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     */
    public com.google.protobuf.DurationOrBuilder getEndpointingTimeoutOrBuilder() {
      if (endpointingTimeoutBuilder_ != null) {
        return endpointingTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return endpointingTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : endpointingTimeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * Speech endpointing timeout settings for the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration endpointing_timeout = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getEndpointingTimeoutFieldBuilder() {
      if (endpointingTimeoutBuilder_ == null) {
        endpointingTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getEndpointingTimeout(), getParentForChildren(), isClean());
        endpointingTimeout_ = null;
      }
      return endpointingTimeoutBuilder_;
    }

    private boolean isInputText_;

    /**
     *
     *
     * <pre>
     * Whether the streaming terminates with an injected text query.
     * </pre>
     *
     * <code>bool is_input_text = 16;</code>
     *
     * @return The isInputText.
     */
    @java.lang.Override
    public boolean getIsInputText() {
      return isInputText_;
    }

    /**
     *
     *
     * <pre>
     * Whether the streaming terminates with an injected text query.
     * </pre>
     *
     * <code>bool is_input_text = 16;</code>
     *
     * @param value The isInputText to set.
     * @return This builder for chaining.
     */
    public Builder setIsInputText(boolean value) {

      isInputText_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether the streaming terminates with an injected text query.
     * </pre>
     *
     * <code>bool is_input_text = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsInputText() {
      bitField0_ = (bitField0_ & ~0x00008000);
      isInputText_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration clientHalfCloseTimeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        clientHalfCloseTimeOffsetBuilder_;

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     *
     * @return Whether the clientHalfCloseTimeOffset field is set.
     */
    public boolean hasClientHalfCloseTimeOffset() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     *
     * @return The clientHalfCloseTimeOffset.
     */
    public com.google.protobuf.Duration getClientHalfCloseTimeOffset() {
      if (clientHalfCloseTimeOffsetBuilder_ == null) {
        return clientHalfCloseTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : clientHalfCloseTimeOffset_;
      } else {
        return clientHalfCloseTimeOffsetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     */
    public Builder setClientHalfCloseTimeOffset(com.google.protobuf.Duration value) {
      if (clientHalfCloseTimeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientHalfCloseTimeOffset_ = value;
      } else {
        clientHalfCloseTimeOffsetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     */
    public Builder setClientHalfCloseTimeOffset(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (clientHalfCloseTimeOffsetBuilder_ == null) {
        clientHalfCloseTimeOffset_ = builderForValue.build();
      } else {
        clientHalfCloseTimeOffsetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     */
    public Builder mergeClientHalfCloseTimeOffset(com.google.protobuf.Duration value) {
      if (clientHalfCloseTimeOffsetBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && clientHalfCloseTimeOffset_ != null
            && clientHalfCloseTimeOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getClientHalfCloseTimeOffsetBuilder().mergeFrom(value);
        } else {
          clientHalfCloseTimeOffset_ = value;
        }
      } else {
        clientHalfCloseTimeOffsetBuilder_.mergeFrom(value);
      }
      if (clientHalfCloseTimeOffset_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     */
    public Builder clearClientHalfCloseTimeOffset() {
      bitField0_ = (bitField0_ & ~0x00010000);
      clientHalfCloseTimeOffset_ = null;
      if (clientHalfCloseTimeOffsetBuilder_ != null) {
        clientHalfCloseTimeOffsetBuilder_.dispose();
        clientHalfCloseTimeOffsetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     */
    public com.google.protobuf.Duration.Builder getClientHalfCloseTimeOffsetBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getClientHalfCloseTimeOffsetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     */
    public com.google.protobuf.DurationOrBuilder getClientHalfCloseTimeOffsetOrBuilder() {
      if (clientHalfCloseTimeOffsetBuilder_ != null) {
        return clientHalfCloseTimeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return clientHalfCloseTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : clientHalfCloseTimeOffset_;
      }
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of input audio duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_time_offset = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getClientHalfCloseTimeOffsetFieldBuilder() {
      if (clientHalfCloseTimeOffsetBuilder_ == null) {
        clientHalfCloseTimeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getClientHalfCloseTimeOffset(), getParentForChildren(), isClean());
        clientHalfCloseTimeOffset_ = null;
      }
      return clientHalfCloseTimeOffsetBuilder_;
    }

    private com.google.protobuf.Duration clientHalfCloseStreamingTimeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        clientHalfCloseStreamingTimeOffsetBuilder_;

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     *
     * @return Whether the clientHalfCloseStreamingTimeOffset field is set.
     */
    public boolean hasClientHalfCloseStreamingTimeOffset() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     *
     * @return The clientHalfCloseStreamingTimeOffset.
     */
    public com.google.protobuf.Duration getClientHalfCloseStreamingTimeOffset() {
      if (clientHalfCloseStreamingTimeOffsetBuilder_ == null) {
        return clientHalfCloseStreamingTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : clientHalfCloseStreamingTimeOffset_;
      } else {
        return clientHalfCloseStreamingTimeOffsetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     */
    public Builder setClientHalfCloseStreamingTimeOffset(com.google.protobuf.Duration value) {
      if (clientHalfCloseStreamingTimeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clientHalfCloseStreamingTimeOffset_ = value;
      } else {
        clientHalfCloseStreamingTimeOffsetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     */
    public Builder setClientHalfCloseStreamingTimeOffset(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (clientHalfCloseStreamingTimeOffsetBuilder_ == null) {
        clientHalfCloseStreamingTimeOffset_ = builderForValue.build();
      } else {
        clientHalfCloseStreamingTimeOffsetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     */
    public Builder mergeClientHalfCloseStreamingTimeOffset(com.google.protobuf.Duration value) {
      if (clientHalfCloseStreamingTimeOffsetBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && clientHalfCloseStreamingTimeOffset_ != null
            && clientHalfCloseStreamingTimeOffset_
                != com.google.protobuf.Duration.getDefaultInstance()) {
          getClientHalfCloseStreamingTimeOffsetBuilder().mergeFrom(value);
        } else {
          clientHalfCloseStreamingTimeOffset_ = value;
        }
      } else {
        clientHalfCloseStreamingTimeOffsetBuilder_.mergeFrom(value);
      }
      if (clientHalfCloseStreamingTimeOffset_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     */
    public Builder clearClientHalfCloseStreamingTimeOffset() {
      bitField0_ = (bitField0_ & ~0x00020000);
      clientHalfCloseStreamingTimeOffset_ = null;
      if (clientHalfCloseStreamingTimeOffsetBuilder_ != null) {
        clientHalfCloseStreamingTimeOffsetBuilder_.dispose();
        clientHalfCloseStreamingTimeOffsetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     */
    public com.google.protobuf.Duration.Builder getClientHalfCloseStreamingTimeOffsetBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getClientHalfCloseStreamingTimeOffsetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     */
    public com.google.protobuf.DurationOrBuilder getClientHalfCloseStreamingTimeOffsetOrBuilder() {
      if (clientHalfCloseStreamingTimeOffsetBuilder_ != null) {
        return clientHalfCloseStreamingTimeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return clientHalfCloseStreamingTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : clientHalfCloseStreamingTimeOffset_;
      }
    }

    /**
     *
     *
     * <pre>
     * Client half close time in terms of API streaming duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration client_half_close_streaming_time_offset = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getClientHalfCloseStreamingTimeOffsetFieldBuilder() {
      if (clientHalfCloseStreamingTimeOffsetBuilder_ == null) {
        clientHalfCloseStreamingTimeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getClientHalfCloseStreamingTimeOffset(), getParentForChildren(), isClean());
        clientHalfCloseStreamingTimeOffset_ = null;
      }
      return clientHalfCloseStreamingTimeOffsetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo)
  private static final com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo();
  }

  public static com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudConversationDebuggingInfo> PARSER =
      new com.google.protobuf.AbstractParser<CloudConversationDebuggingInfo>() {
        @java.lang.Override
        public CloudConversationDebuggingInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudConversationDebuggingInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudConversationDebuggingInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
