/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a Dialogflow assist answer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer}
 */
public final class DialogflowAssistAnswer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer)
    DialogflowAssistAnswerOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DialogflowAssistAnswer.newBuilder() to construct.
  private DialogflowAssistAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DialogflowAssistAnswer() {
    answerRecord_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DialogflowAssistAnswer();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_DialogflowAssistAnswer_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_DialogflowAssistAnswer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.class,
            com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.Builder.class);
  }

  private int resultCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object result_;

  public enum ResultCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    QUERY_RESULT(1),
    INTENT_SUGGESTION(5),
    RESULT_NOT_SET(0);
    private final int value;

    private ResultCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResultCase forNumber(int value) {
      switch (value) {
        case 1:
          return QUERY_RESULT;
        case 5:
          return INTENT_SUGGESTION;
        case 0:
          return RESULT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResultCase getResultCase() {
    return ResultCase.forNumber(resultCase_);
  }

  public static final int QUERY_RESULT_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Result from v2 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
   *
   * @return Whether the queryResult field is set.
   */
  @java.lang.Override
  public boolean hasQueryResult() {
    return resultCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Result from v2 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
   *
   * @return The queryResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResult getQueryResult() {
    if (resultCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.QueryResult) result_;
    }
    return com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Result from v2 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder getQueryResultOrBuilder() {
    if (resultCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.QueryResult) result_;
    }
    return com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance();
  }

  public static final int INTENT_SUGGESTION_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * An intent suggestion generated from conversation.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
   *
   * @return Whether the intentSuggestion field is set.
   */
  @java.lang.Override
  public boolean hasIntentSuggestion() {
    return resultCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * An intent suggestion generated from conversation.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
   *
   * @return The intentSuggestion.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentSuggestion getIntentSuggestion() {
    if (resultCase_ == 5) {
      return (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_;
    }
    return com.google.cloud.dialogflow.v2beta1.IntentSuggestion.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * An intent suggestion generated from conversation.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentSuggestionOrBuilder
      getIntentSuggestionOrBuilder() {
    if (resultCase_ == 5) {
      return (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_;
    }
    return com.google.cloud.dialogflow.v2beta1.IntentSuggestion.getDefaultInstance();
  }

  public static final int ANSWER_RECORD_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answerRecord_ = "";

  /**
   *
   *
   * <pre>
   * The name of answer record, in the format of
   * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
   * ID&gt;"
   * </pre>
   *
   * <code>string answer_record = 2;</code>
   *
   * @return The answerRecord.
   */
  @java.lang.Override
  public java.lang.String getAnswerRecord() {
    java.lang.Object ref = answerRecord_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answerRecord_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of answer record, in the format of
   * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
   * ID&gt;"
   * </pre>
   *
   * <code>string answer_record = 2;</code>
   *
   * @return The bytes for answerRecord.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerRecordBytes() {
    java.lang.Object ref = answerRecord_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answerRecord_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resultCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.dialogflow.v2beta1.QueryResult) result_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, answerRecord_);
    }
    if (resultCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resultCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dialogflow.v2beta1.QueryResult) result_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, answerRecord_);
    }
    if (resultCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer other =
        (com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer) obj;

    if (!getAnswerRecord().equals(other.getAnswerRecord())) return false;
    if (!getResultCase().equals(other.getResultCase())) return false;
    switch (resultCase_) {
      case 1:
        if (!getQueryResult().equals(other.getQueryResult())) return false;
        break;
      case 5:
        if (!getIntentSuggestion().equals(other.getIntentSuggestion())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANSWER_RECORD_FIELD_NUMBER;
    hash = (53 * hash) + getAnswerRecord().hashCode();
    switch (resultCase_) {
      case 1:
        hash = (37 * hash) + QUERY_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getQueryResult().hashCode();
        break;
      case 5:
        hash = (37 * hash) + INTENT_SUGGESTION_FIELD_NUMBER;
        hash = (53 * hash) + getIntentSuggestion().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a Dialogflow assist answer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer)
      com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_DialogflowAssistAnswer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_DialogflowAssistAnswer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.class,
              com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (queryResultBuilder_ != null) {
        queryResultBuilder_.clear();
      }
      if (intentSuggestionBuilder_ != null) {
        intentSuggestionBuilder_.clear();
      }
      answerRecord_ = "";
      resultCase_ = 0;
      result_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_DialogflowAssistAnswer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer build() {
      com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer buildPartial() {
      com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer result =
          new com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.answerRecord_ = answerRecord_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer result) {
      result.resultCase_ = resultCase_;
      result.result_ = this.result_;
      if (resultCase_ == 1 && queryResultBuilder_ != null) {
        result.result_ = queryResultBuilder_.build();
      }
      if (resultCase_ == 5 && intentSuggestionBuilder_ != null) {
        result.result_ = intentSuggestionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer other) {
      if (other == com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.getDefaultInstance())
        return this;
      if (!other.getAnswerRecord().isEmpty()) {
        answerRecord_ = other.answerRecord_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getResultCase()) {
        case QUERY_RESULT:
          {
            mergeQueryResult(other.getQueryResult());
            break;
          }
        case INTENT_SUGGESTION:
          {
            mergeIntentSuggestion(other.getIntentSuggestion());
            break;
          }
        case RESULT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getQueryResultFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                answerRecord_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 42:
              {
                input.readMessage(
                    getIntentSuggestionFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resultCase_ = 0;
    private java.lang.Object result_;

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public Builder clearResult() {
      resultCase_ = 0;
      result_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        queryResultBuilder_;

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     *
     * @return Whether the queryResult field is set.
     */
    @java.lang.Override
    public boolean hasQueryResult() {
      return resultCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     *
     * @return The queryResult.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryResult getQueryResult() {
      if (queryResultBuilder_ == null) {
        if (resultCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.QueryResult) result_;
        }
        return com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance();
      } else {
        if (resultCase_ == 1) {
          return queryResultBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     */
    public Builder setQueryResult(com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        queryResultBuilder_.setMessage(value);
      }
      resultCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     */
    public Builder setQueryResult(
        com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (queryResultBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        queryResultBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     */
    public Builder mergeQueryResult(com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (resultCase_ == 1
            && result_ != com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()) {
          result_ =
              com.google.cloud.dialogflow.v2beta1.QueryResult.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.QueryResult) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 1) {
          queryResultBuilder_.mergeFrom(value);
        } else {
          queryResultBuilder_.setMessage(value);
        }
      }
      resultCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     */
    public Builder clearQueryResult() {
      if (queryResultBuilder_ == null) {
        if (resultCase_ == 1) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 1) {
          resultCase_ = 0;
          result_ = null;
        }
        queryResultBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder getQueryResultBuilder() {
      return getQueryResultFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder getQueryResultOrBuilder() {
      if ((resultCase_ == 1) && (queryResultBuilder_ != null)) {
        return queryResultBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.QueryResult) result_;
        }
        return com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Result from v2 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        getQueryResultFieldBuilder() {
      if (queryResultBuilder_ == null) {
        if (!(resultCase_ == 1)) {
          result_ = com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance();
        }
        queryResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryResult,
                com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.QueryResult) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 1;
      onChanged();
      return queryResultBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentSuggestion,
            com.google.cloud.dialogflow.v2beta1.IntentSuggestion.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentSuggestionOrBuilder>
        intentSuggestionBuilder_;

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     *
     * @return Whether the intentSuggestion field is set.
     */
    @java.lang.Override
    public boolean hasIntentSuggestion() {
      return resultCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     *
     * @return The intentSuggestion.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.IntentSuggestion getIntentSuggestion() {
      if (intentSuggestionBuilder_ == null) {
        if (resultCase_ == 5) {
          return (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_;
        }
        return com.google.cloud.dialogflow.v2beta1.IntentSuggestion.getDefaultInstance();
      } else {
        if (resultCase_ == 5) {
          return intentSuggestionBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.IntentSuggestion.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     */
    public Builder setIntentSuggestion(com.google.cloud.dialogflow.v2beta1.IntentSuggestion value) {
      if (intentSuggestionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        intentSuggestionBuilder_.setMessage(value);
      }
      resultCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     */
    public Builder setIntentSuggestion(
        com.google.cloud.dialogflow.v2beta1.IntentSuggestion.Builder builderForValue) {
      if (intentSuggestionBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        intentSuggestionBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     */
    public Builder mergeIntentSuggestion(
        com.google.cloud.dialogflow.v2beta1.IntentSuggestion value) {
      if (intentSuggestionBuilder_ == null) {
        if (resultCase_ == 5
            && result_
                != com.google.cloud.dialogflow.v2beta1.IntentSuggestion.getDefaultInstance()) {
          result_ =
              com.google.cloud.dialogflow.v2beta1.IntentSuggestion.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 5) {
          intentSuggestionBuilder_.mergeFrom(value);
        } else {
          intentSuggestionBuilder_.setMessage(value);
        }
      }
      resultCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     */
    public Builder clearIntentSuggestion() {
      if (intentSuggestionBuilder_ == null) {
        if (resultCase_ == 5) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 5) {
          resultCase_ = 0;
          result_ = null;
        }
        intentSuggestionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.IntentSuggestion.Builder
        getIntentSuggestionBuilder() {
      return getIntentSuggestionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.IntentSuggestionOrBuilder
        getIntentSuggestionOrBuilder() {
      if ((resultCase_ == 5) && (intentSuggestionBuilder_ != null)) {
        return intentSuggestionBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 5) {
          return (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_;
        }
        return com.google.cloud.dialogflow.v2beta1.IntentSuggestion.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * An intent suggestion generated from conversation.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentSuggestion intent_suggestion = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentSuggestion,
            com.google.cloud.dialogflow.v2beta1.IntentSuggestion.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentSuggestionOrBuilder>
        getIntentSuggestionFieldBuilder() {
      if (intentSuggestionBuilder_ == null) {
        if (!(resultCase_ == 5)) {
          result_ = com.google.cloud.dialogflow.v2beta1.IntentSuggestion.getDefaultInstance();
        }
        intentSuggestionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.IntentSuggestion,
                com.google.cloud.dialogflow.v2beta1.IntentSuggestion.Builder,
                com.google.cloud.dialogflow.v2beta1.IntentSuggestionOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.IntentSuggestion) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 5;
      onChanged();
      return intentSuggestionBuilder_;
    }

    private java.lang.Object answerRecord_ = "";

    /**
     *
     *
     * <pre>
     * The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 2;</code>
     *
     * @return The answerRecord.
     */
    public java.lang.String getAnswerRecord() {
      java.lang.Object ref = answerRecord_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerRecord_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 2;</code>
     *
     * @return The bytes for answerRecord.
     */
    public com.google.protobuf.ByteString getAnswerRecordBytes() {
      java.lang.Object ref = answerRecord_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerRecord_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 2;</code>
     *
     * @param value The answerRecord to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRecord(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answerRecord_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerRecord() {
      answerRecord_ = getDefaultInstance().getAnswerRecord();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 2;</code>
     *
     * @param value The bytes for answerRecord to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRecordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answerRecord_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer)
  private static final com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer();
  }

  public static com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DialogflowAssistAnswer> PARSER =
      new com.google.protobuf.AbstractParser<DialogflowAssistAnswer>() {
        @java.lang.Override
        public DialogflowAssistAnswer parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DialogflowAssistAnswer> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DialogflowAssistAnswer> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
