/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The top-level message sent by the client to the
 * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
 * method.
 *
 * Multiple request messages should be sent in order:
 *
 * 1.  The first message must contain
 *     [participant][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.participant],
 *     [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
 *     and optionally
 *     [query_params][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.query_params].
 *     If you want to receive an audio response, it should also contain
 *     [reply_audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.reply_audio_config].
 *     The message must not contain
 *     [input][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input].
 *
 * 2.  If
 * [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
 * in the first message
 *     was set to
 *     [audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.audio_config],
 *     all subsequent messages must contain
 *     [input_audio][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_audio]
 *     to continue with Speech recognition. If you decide to rather analyze text
 *     input after you already started Speech recognition, please send a message
 *     with
 *     [StreamingAnalyzeContentRequest.input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
 *
 *     However, note that:
 *
 *     * Dialogflow will bill you for the audio so far.
 *     * Dialogflow discards all Speech recognition results in favor of the
 *       text input.
 *
 *  3. If
 *  [StreamingAnalyzeContentRequest.config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
 *  in the first message was set
 *    to
 *    [StreamingAnalyzeContentRequest.text_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.text_config],
 *    then the second message must contain only
 *    [input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
 *    Moreover, you must not send more than two messages.
 *
 *  After you sent all input, you must half-close or abort the request stream.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest}
 */
public final class StreamingAnalyzeContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
    StreamingAnalyzeContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StreamingAnalyzeContentRequest.newBuilder() to construct.
  private StreamingAnalyzeContentRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingAnalyzeContentRequest() {
    participant_ = "";
    cxCurrentPage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingAnalyzeContentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.class,
            com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.Builder.class);
  }

  private int bitField0_;
  private int configCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object config_;

  public enum ConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUDIO_CONFIG(2),
    TEXT_CONFIG(3),
    CONFIG_NOT_SET(0);
    private final int value;

    private ConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return AUDIO_CONFIG;
        case 3:
          return TEXT_CONFIG;
        case 0:
          return CONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConfigCase getConfigCase() {
    return ConfigCase.forNumber(configCase_);
  }

  private int inputCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object input_;

  public enum InputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INPUT_AUDIO(5),
    INPUT_TEXT(6),
    INPUT_DTMF(9),
    INPUT_INTENT(17),
    INPUT_EVENT(20),
    INPUT_NOT_SET(0);
    private final int value;

    private InputCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InputCase valueOf(int value) {
      return forNumber(value);
    }

    public static InputCase forNumber(int value) {
      switch (value) {
        case 5:
          return INPUT_AUDIO;
        case 6:
          return INPUT_TEXT;
        case 9:
          return INPUT_DTMF;
        case 17:
          return INPUT_INTENT;
        case 20:
          return INPUT_EVENT;
        case 0:
          return INPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InputCase getInputCase() {
    return InputCase.forNumber(inputCase_);
  }

  public static final int PARTICIPANT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object participant_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The participant.
   */
  @java.lang.Override
  public java.lang.String getParticipant() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      participant_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for participant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParticipantBytes() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      participant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIO_CONFIG_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
   *
   * @return Whether the audioConfig field is set.
   */
  @java.lang.Override
  public boolean hasAudioConfig() {
    return configCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
   *
   * @return The audioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getAudioConfig() {
    if (configCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder getAudioConfigOrBuilder() {
    if (configCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
  }

  public static final int TEXT_CONFIG_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
   *
   * @return Whether the textConfig field is set.
   */
  @java.lang.Override
  public boolean hasTextConfig() {
    return configCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
   *
   * @return The textConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputTextConfig getTextConfig() {
    if (configCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder getTextConfigOrBuilder() {
    if (configCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
  }

  public static final int REPLY_AUDIO_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig replyAudioConfig_;

  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * StreamingAnalyzeContent. If this configuration is not supplied, speech
   * synthesis is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
   *
   * @return Whether the replyAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasReplyAudioConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * StreamingAnalyzeContent. If this configuration is not supplied, speech
   * synthesis is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
   *
   * @return The replyAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getReplyAudioConfig() {
    return replyAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : replyAudioConfig_;
  }

  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * StreamingAnalyzeContent. If this configuration is not supplied, speech
   * synthesis is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
      getReplyAudioConfigOrBuilder() {
    return replyAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : replyAudioConfig_;
  }

  public static final int INPUT_AUDIO_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * The input audio content to be recognized. Must be sent if `audio_config`
   * is set in the first message. The complete audio over all streaming
   * messages must not exceed 1 minute.
   * </pre>
   *
   * <code>bytes input_audio = 5;</code>
   *
   * @return Whether the inputAudio field is set.
   */
  @java.lang.Override
  public boolean hasInputAudio() {
    return inputCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * The input audio content to be recognized. Must be sent if `audio_config`
   * is set in the first message. The complete audio over all streaming
   * messages must not exceed 1 minute.
   * </pre>
   *
   * <code>bytes input_audio = 5;</code>
   *
   * @return The inputAudio.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputAudio() {
    if (inputCase_ == 5) {
      return (com.google.protobuf.ByteString) input_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int INPUT_TEXT_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * The UTF-8 encoded natural language text to be processed. Must be sent if
   * `text_config` is set in the first message. Text length must not exceed
   * 256 bytes for virtual agent interactions. The `input_text` field can be
   * only sent once, and would cancel the speech recognition if any ongoing.
   * </pre>
   *
   * <code>string input_text = 6;</code>
   *
   * @return Whether the inputText field is set.
   */
  public boolean hasInputText() {
    return inputCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * The UTF-8 encoded natural language text to be processed. Must be sent if
   * `text_config` is set in the first message. Text length must not exceed
   * 256 bytes for virtual agent interactions. The `input_text` field can be
   * only sent once, and would cancel the speech recognition if any ongoing.
   * </pre>
   *
   * <code>string input_text = 6;</code>
   *
   * @return The inputText.
   */
  public java.lang.String getInputText() {
    java.lang.Object ref = "";
    if (inputCase_ == 6) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (inputCase_ == 6) {
        input_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The UTF-8 encoded natural language text to be processed. Must be sent if
   * `text_config` is set in the first message. Text length must not exceed
   * 256 bytes for virtual agent interactions. The `input_text` field can be
   * only sent once, and would cancel the speech recognition if any ongoing.
   * </pre>
   *
   * <code>string input_text = 6;</code>
   *
   * @return The bytes for inputText.
   */
  public com.google.protobuf.ByteString getInputTextBytes() {
    java.lang.Object ref = "";
    if (inputCase_ == 6) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (inputCase_ == 6) {
        input_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_DTMF_FIELD_NUMBER = 9;

  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   *
   * This input is ignored if the previous response indicated that DTMF input
   * is not accepted.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
   *
   * @return Whether the inputDtmf field is set.
   */
  @java.lang.Override
  public boolean hasInputDtmf() {
    return inputCase_ == 9;
  }

  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   *
   * This input is ignored if the previous response indicated that DTMF input
   * is not accepted.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
   *
   * @return The inputDtmf.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents getInputDtmf() {
    if (inputCase_ == 9) {
      return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   *
   * This input is ignored if the previous response indicated that DTMF input
   * is not accepted.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder getInputDtmfOrBuilder() {
    if (inputCase_ == 9) {
      return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
  }

  public static final int INPUT_INTENT_FIELD_NUMBER = 17;

  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
   * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string input_intent = 17;</code>
   *
   * @return Whether the inputIntent field is set.
   */
  public boolean hasInputIntent() {
    return inputCase_ == 17;
  }

  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
   * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string input_intent = 17;</code>
   *
   * @return The inputIntent.
   */
  public java.lang.String getInputIntent() {
    java.lang.Object ref = "";
    if (inputCase_ == 17) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (inputCase_ == 17) {
        input_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
   * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
   * </pre>
   *
   * <code>string input_intent = 17;</code>
   *
   * @return The bytes for inputIntent.
   */
  public com.google.protobuf.ByteString getInputIntentBytes() {
    java.lang.Object ref = "";
    if (inputCase_ == 17) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (inputCase_ == 17) {
        input_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_EVENT_FIELD_NUMBER = 20;

  /**
   *
   *
   * <pre>
   * The input event name.
   * This can only be sent once and would cancel the ongoing speech
   * recognition if any.
   * </pre>
   *
   * <code>string input_event = 20;</code>
   *
   * @return Whether the inputEvent field is set.
   */
  public boolean hasInputEvent() {
    return inputCase_ == 20;
  }

  /**
   *
   *
   * <pre>
   * The input event name.
   * This can only be sent once and would cancel the ongoing speech
   * recognition if any.
   * </pre>
   *
   * <code>string input_event = 20;</code>
   *
   * @return The inputEvent.
   */
  public java.lang.String getInputEvent() {
    java.lang.Object ref = "";
    if (inputCase_ == 20) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (inputCase_ == 20) {
        input_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The input event name.
   * This can only be sent once and would cancel the ongoing speech
   * recognition if any.
   * </pre>
   *
   * <code>string input_event = 20;</code>
   *
   * @return The bytes for inputEvent.
   */
  public com.google.protobuf.ByteString getInputEventBytes() {
    java.lang.Object ref = "";
    if (inputCase_ == 20) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (inputCase_ == 20) {
        input_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_PARAMS_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.v2beta1.QueryParameters queryParams_;

  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
   *
   * @return Whether the queryParams field is set.
   */
  @java.lang.Override
  public boolean hasQueryParams() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
   *
   * @return The queryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryParameters getQueryParams() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
        : queryParams_;
  }

  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder getQueryParamsOrBuilder() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
        : queryParams_;
  }

  public static final int ASSIST_QUERY_PARAMS_FIELD_NUMBER = 8;
  private com.google.cloud.dialogflow.v2beta1.AssistQueryParameters assistQueryParams_;

  /**
   *
   *
   * <pre>
   * Parameters for a human assist query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
   *
   * @return Whether the assistQueryParams field is set.
   */
  @java.lang.Override
  public boolean hasAssistQueryParams() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Parameters for a human assist query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
   *
   * @return The assistQueryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AssistQueryParameters getAssistQueryParams() {
    return assistQueryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
        : assistQueryParams_;
  }

  /**
   *
   *
   * <pre>
   * Parameters for a human assist query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder
      getAssistQueryParamsOrBuilder() {
    return assistQueryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
        : assistQueryParams_;
  }

  public static final int CX_PARAMETERS_FIELD_NUMBER = 13;
  private com.google.protobuf.Struct cxParameters_;

  /**
   *
   *
   * <pre>
   * Additional parameters to be put into Dialogflow CX session parameters. To
   * remove a parameter from the session, clients should explicitly set the
   * parameter value to null.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_parameters = 13;</code>
   *
   * @return Whether the cxParameters field is set.
   */
  @java.lang.Override
  public boolean hasCxParameters() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Additional parameters to be put into Dialogflow CX session parameters. To
   * remove a parameter from the session, clients should explicitly set the
   * parameter value to null.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_parameters = 13;</code>
   *
   * @return The cxParameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCxParameters() {
    return cxParameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : cxParameters_;
  }

  /**
   *
   *
   * <pre>
   * Additional parameters to be put into Dialogflow CX session parameters. To
   * remove a parameter from the session, clients should explicitly set the
   * parameter value to null.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_parameters = 13;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCxParametersOrBuilder() {
    return cxParameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : cxParameters_;
  }

  public static final int CX_CURRENT_PAGE_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cxCurrentPage_ = "";

  /**
   *
   *
   * <pre>
   * The unique identifier of the Dialogflow CX page to override the
   * `current_page` in the session.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   *
   * If `cx_current_page` is specified, the previous state of the session will
   * be ignored by Dialogflow CX, including the [previous
   * page][QueryResult.current_page] and the [previous session
   * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
   * `cx_parameters` should be configured together to direct a session to a
   * specific state.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>string cx_current_page = 15;</code>
   *
   * @return The cxCurrentPage.
   */
  @java.lang.Override
  public java.lang.String getCxCurrentPage() {
    java.lang.Object ref = cxCurrentPage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cxCurrentPage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The unique identifier of the Dialogflow CX page to override the
   * `current_page` in the session.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   *
   * If `cx_current_page` is specified, the previous state of the session will
   * be ignored by Dialogflow CX, including the [previous
   * page][QueryResult.current_page] and the [previous session
   * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
   * `cx_parameters` should be configured together to direct a session to a
   * specific state.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>string cx_current_page = 15;</code>
   *
   * @return The bytes for cxCurrentPage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCxCurrentPageBytes() {
    java.lang.Object ref = cxCurrentPage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cxCurrentPage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_EXTENDED_STREAMING_FIELD_NUMBER = 11;
  private boolean enableExtendedStreaming_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Enable full bidirectional streaming. You can keep streaming the
   * audio until timeout, and there's no need to half close the stream to get
   * the response.
   *
   * Restrictions:
   *
   * - Timeout: 3 mins.
   * - Audio Encoding: only supports
   * [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
   * and
   * [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
   * - Lifecycle: conversation should be in `Assist Stage`, go to
   *   [Conversation.CreateConversation][] for more information.
   *
   * InvalidArgument Error will be returned if the one of restriction checks
   * failed.
   *
   * You can find more details in
   * https://cloud.google.com/agent-assist/docs/extended-streaming
   * </pre>
   *
   * <code>bool enable_extended_streaming = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableExtendedStreaming.
   */
  @java.lang.Override
  public boolean getEnableExtendedStreaming() {
    return enableExtendedStreaming_;
  }

  public static final int ENABLE_PARTIAL_AUTOMATED_AGENT_REPLY_FIELD_NUMBER = 12;
  private boolean enablePartialAutomatedAgentReply_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Enable partial responses from Dialogflow CX agent. If this flag
   * is not enabled, response stream still contains only one final response even
   * if some `Fulfillment`s in Dialogflow CX agent have been configured to
   * return partial responses.
   * </pre>
   *
   * <code>bool enable_partial_automated_agent_reply = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enablePartialAutomatedAgentReply.
   */
  @java.lang.Override
  public boolean getEnablePartialAutomatedAgentReply() {
    return enablePartialAutomatedAgentReply_;
  }

  public static final int ENABLE_DEBUGGING_INFO_FIELD_NUMBER = 19;
  private boolean enableDebuggingInfo_ = false;

  /**
   *
   *
   * <pre>
   * if true, `StreamingAnalyzeContentResponse.debugging_info` will get
   * populated.
   * </pre>
   *
   * <code>bool enable_debugging_info = 19;</code>
   *
   * @return The enableDebuggingInfo.
   */
  @java.lang.Override
  public boolean getEnableDebuggingInfo() {
    return enableDebuggingInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, participant_);
    }
    if (configCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_);
    }
    if (configCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getReplyAudioConfig());
    }
    if (inputCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) input_);
    }
    if (inputCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, input_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getQueryParams());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getAssistQueryParams());
    }
    if (inputCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_);
    }
    if (enableExtendedStreaming_ != false) {
      output.writeBool(11, enableExtendedStreaming_);
    }
    if (enablePartialAutomatedAgentReply_ != false) {
      output.writeBool(12, enablePartialAutomatedAgentReply_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(13, getCxParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cxCurrentPage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, cxCurrentPage_);
    }
    if (inputCase_ == 17) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, input_);
    }
    if (enableDebuggingInfo_ != false) {
      output.writeBool(19, enableDebuggingInfo_);
    }
    if (inputCase_ == 20) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, input_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, participant_);
    }
    if (configCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_);
    }
    if (configCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getReplyAudioConfig());
    }
    if (inputCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) input_);
    }
    if (inputCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, input_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getQueryParams());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAssistQueryParams());
    }
    if (inputCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_);
    }
    if (enableExtendedStreaming_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, enableExtendedStreaming_);
    }
    if (enablePartialAutomatedAgentReply_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              12, enablePartialAutomatedAgentReply_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCxParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cxCurrentPage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, cxCurrentPage_);
    }
    if (inputCase_ == 17) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, input_);
    }
    if (enableDebuggingInfo_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, enableDebuggingInfo_);
    }
    if (inputCase_ == 20) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, input_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest other =
        (com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest) obj;

    if (!getParticipant().equals(other.getParticipant())) return false;
    if (hasReplyAudioConfig() != other.hasReplyAudioConfig()) return false;
    if (hasReplyAudioConfig()) {
      if (!getReplyAudioConfig().equals(other.getReplyAudioConfig())) return false;
    }
    if (hasQueryParams() != other.hasQueryParams()) return false;
    if (hasQueryParams()) {
      if (!getQueryParams().equals(other.getQueryParams())) return false;
    }
    if (hasAssistQueryParams() != other.hasAssistQueryParams()) return false;
    if (hasAssistQueryParams()) {
      if (!getAssistQueryParams().equals(other.getAssistQueryParams())) return false;
    }
    if (hasCxParameters() != other.hasCxParameters()) return false;
    if (hasCxParameters()) {
      if (!getCxParameters().equals(other.getCxParameters())) return false;
    }
    if (!getCxCurrentPage().equals(other.getCxCurrentPage())) return false;
    if (getEnableExtendedStreaming() != other.getEnableExtendedStreaming()) return false;
    if (getEnablePartialAutomatedAgentReply() != other.getEnablePartialAutomatedAgentReply())
      return false;
    if (getEnableDebuggingInfo() != other.getEnableDebuggingInfo()) return false;
    if (!getConfigCase().equals(other.getConfigCase())) return false;
    switch (configCase_) {
      case 2:
        if (!getAudioConfig().equals(other.getAudioConfig())) return false;
        break;
      case 3:
        if (!getTextConfig().equals(other.getTextConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getInputCase().equals(other.getInputCase())) return false;
    switch (inputCase_) {
      case 5:
        if (!getInputAudio().equals(other.getInputAudio())) return false;
        break;
      case 6:
        if (!getInputText().equals(other.getInputText())) return false;
        break;
      case 9:
        if (!getInputDtmf().equals(other.getInputDtmf())) return false;
        break;
      case 17:
        if (!getInputIntent().equals(other.getInputIntent())) return false;
        break;
      case 20:
        if (!getInputEvent().equals(other.getInputEvent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARTICIPANT_FIELD_NUMBER;
    hash = (53 * hash) + getParticipant().hashCode();
    if (hasReplyAudioConfig()) {
      hash = (37 * hash) + REPLY_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getReplyAudioConfig().hashCode();
    }
    if (hasQueryParams()) {
      hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParams().hashCode();
    }
    if (hasAssistQueryParams()) {
      hash = (37 * hash) + ASSIST_QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getAssistQueryParams().hashCode();
    }
    if (hasCxParameters()) {
      hash = (37 * hash) + CX_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getCxParameters().hashCode();
    }
    hash = (37 * hash) + CX_CURRENT_PAGE_FIELD_NUMBER;
    hash = (53 * hash) + getCxCurrentPage().hashCode();
    hash = (37 * hash) + ENABLE_EXTENDED_STREAMING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableExtendedStreaming());
    hash = (37 * hash) + ENABLE_PARTIAL_AUTOMATED_AGENT_REPLY_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashBoolean(getEnablePartialAutomatedAgentReply());
    hash = (37 * hash) + ENABLE_DEBUGGING_INFO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableDebuggingInfo());
    switch (configCase_) {
      case 2:
        hash = (37 * hash) + AUDIO_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAudioConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TEXT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextConfig().hashCode();
        break;
      case 0:
      default:
    }
    switch (inputCase_) {
      case 5:
        hash = (37 * hash) + INPUT_AUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getInputAudio().hashCode();
        break;
      case 6:
        hash = (37 * hash) + INPUT_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getInputText().hashCode();
        break;
      case 9:
        hash = (37 * hash) + INPUT_DTMF_FIELD_NUMBER;
        hash = (53 * hash) + getInputDtmf().hashCode();
        break;
      case 17:
        hash = (37 * hash) + INPUT_INTENT_FIELD_NUMBER;
        hash = (53 * hash) + getInputIntent().hashCode();
        break;
      case 20:
        hash = (37 * hash) + INPUT_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getInputEvent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The top-level message sent by the client to the
   * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
   * method.
   *
   * Multiple request messages should be sent in order:
   *
   * 1.  The first message must contain
   *     [participant][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.participant],
   *     [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
   *     and optionally
   *     [query_params][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.query_params].
   *     If you want to receive an audio response, it should also contain
   *     [reply_audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.reply_audio_config].
   *     The message must not contain
   *     [input][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input].
   *
   * 2.  If
   * [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
   * in the first message
   *     was set to
   *     [audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.audio_config],
   *     all subsequent messages must contain
   *     [input_audio][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_audio]
   *     to continue with Speech recognition. If you decide to rather analyze text
   *     input after you already started Speech recognition, please send a message
   *     with
   *     [StreamingAnalyzeContentRequest.input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
   *
   *     However, note that:
   *
   *     * Dialogflow will bill you for the audio so far.
   *     * Dialogflow discards all Speech recognition results in favor of the
   *       text input.
   *
   *  3. If
   *  [StreamingAnalyzeContentRequest.config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
   *  in the first message was set
   *    to
   *    [StreamingAnalyzeContentRequest.text_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.text_config],
   *    then the second message must contain only
   *    [input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
   *    Moreover, you must not send more than two messages.
   *
   *  After you sent all input, you must half-close or abort the request stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.class,
              com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReplyAudioConfigFieldBuilder();
        getQueryParamsFieldBuilder();
        getAssistQueryParamsFieldBuilder();
        getCxParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      participant_ = "";
      if (audioConfigBuilder_ != null) {
        audioConfigBuilder_.clear();
      }
      if (textConfigBuilder_ != null) {
        textConfigBuilder_.clear();
      }
      replyAudioConfig_ = null;
      if (replyAudioConfigBuilder_ != null) {
        replyAudioConfigBuilder_.dispose();
        replyAudioConfigBuilder_ = null;
      }
      if (inputDtmfBuilder_ != null) {
        inputDtmfBuilder_.clear();
      }
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      assistQueryParams_ = null;
      if (assistQueryParamsBuilder_ != null) {
        assistQueryParamsBuilder_.dispose();
        assistQueryParamsBuilder_ = null;
      }
      cxParameters_ = null;
      if (cxParametersBuilder_ != null) {
        cxParametersBuilder_.dispose();
        cxParametersBuilder_ = null;
      }
      cxCurrentPage_ = "";
      enableExtendedStreaming_ = false;
      enablePartialAutomatedAgentReply_ = false;
      enableDebuggingInfo_ = false;
      configCase_ = 0;
      config_ = null;
      inputCase_ = 0;
      input_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest build() {
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest buildPartial() {
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest result =
          new com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.participant_ = participant_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.replyAudioConfig_ =
            replyAudioConfigBuilder_ == null ? replyAudioConfig_ : replyAudioConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.queryParams_ =
            queryParamsBuilder_ == null ? queryParams_ : queryParamsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.assistQueryParams_ =
            assistQueryParamsBuilder_ == null
                ? assistQueryParams_
                : assistQueryParamsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.cxParameters_ =
            cxParametersBuilder_ == null ? cxParameters_ : cxParametersBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.cxCurrentPage_ = cxCurrentPage_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.enableExtendedStreaming_ = enableExtendedStreaming_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.enablePartialAutomatedAgentReply_ = enablePartialAutomatedAgentReply_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.enableDebuggingInfo_ = enableDebuggingInfo_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest result) {
      result.configCase_ = configCase_;
      result.config_ = this.config_;
      if (configCase_ == 2 && audioConfigBuilder_ != null) {
        result.config_ = audioConfigBuilder_.build();
      }
      if (configCase_ == 3 && textConfigBuilder_ != null) {
        result.config_ = textConfigBuilder_.build();
      }
      result.inputCase_ = inputCase_;
      result.input_ = this.input_;
      if (inputCase_ == 9 && inputDtmfBuilder_ != null) {
        result.input_ = inputDtmfBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest) {
        return mergeFrom(
            (com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
              .getDefaultInstance()) return this;
      if (!other.getParticipant().isEmpty()) {
        participant_ = other.participant_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasReplyAudioConfig()) {
        mergeReplyAudioConfig(other.getReplyAudioConfig());
      }
      if (other.hasQueryParams()) {
        mergeQueryParams(other.getQueryParams());
      }
      if (other.hasAssistQueryParams()) {
        mergeAssistQueryParams(other.getAssistQueryParams());
      }
      if (other.hasCxParameters()) {
        mergeCxParameters(other.getCxParameters());
      }
      if (!other.getCxCurrentPage().isEmpty()) {
        cxCurrentPage_ = other.cxCurrentPage_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.getEnableExtendedStreaming() != false) {
        setEnableExtendedStreaming(other.getEnableExtendedStreaming());
      }
      if (other.getEnablePartialAutomatedAgentReply() != false) {
        setEnablePartialAutomatedAgentReply(other.getEnablePartialAutomatedAgentReply());
      }
      if (other.getEnableDebuggingInfo() != false) {
        setEnableDebuggingInfo(other.getEnableDebuggingInfo());
      }
      switch (other.getConfigCase()) {
        case AUDIO_CONFIG:
          {
            mergeAudioConfig(other.getAudioConfig());
            break;
          }
        case TEXT_CONFIG:
          {
            mergeTextConfig(other.getTextConfig());
            break;
          }
        case CONFIG_NOT_SET:
          {
            break;
          }
      }
      switch (other.getInputCase()) {
        case INPUT_AUDIO:
          {
            setInputAudio(other.getInputAudio());
            break;
          }
        case INPUT_TEXT:
          {
            inputCase_ = 6;
            input_ = other.input_;
            onChanged();
            break;
          }
        case INPUT_DTMF:
          {
            mergeInputDtmf(other.getInputDtmf());
            break;
          }
        case INPUT_INTENT:
          {
            inputCase_ = 17;
            input_ = other.input_;
            onChanged();
            break;
          }
        case INPUT_EVENT:
          {
            inputCase_ = 20;
            input_ = other.input_;
            onChanged();
            break;
          }
        case INPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                participant_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                configCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTextConfigFieldBuilder().getBuilder(), extensionRegistry);
                configCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getReplyAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input_ = input.readBytes();
                inputCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                inputCase_ = 6;
                input_ = s;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getQueryParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getAssistQueryParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getInputDtmfFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 9;
                break;
              } // case 74
            case 88:
              {
                enableExtendedStreaming_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 88
            case 96:
              {
                enablePartialAutomatedAgentReply_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getCxParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            case 122:
              {
                cxCurrentPage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 122
            case 138:
              {
                java.lang.String s = input.readStringRequireUtf8();
                inputCase_ = 17;
                input_ = s;
                break;
              } // case 138
            case 152:
              {
                enableDebuggingInfo_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 152
            case 162:
              {
                java.lang.String s = input.readStringRequireUtf8();
                inputCase_ = 20;
                input_ = s;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int configCase_ = 0;
    private java.lang.Object config_;

    public ConfigCase getConfigCase() {
      return ConfigCase.forNumber(configCase_);
    }

    public Builder clearConfig() {
      configCase_ = 0;
      config_ = null;
      onChanged();
      return this;
    }

    private int inputCase_ = 0;
    private java.lang.Object input_;

    public InputCase getInputCase() {
      return InputCase.forNumber(inputCase_);
    }

    public Builder clearInput() {
      inputCase_ = 0;
      input_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object participant_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The participant.
     */
    public java.lang.String getParticipant() {
      java.lang.Object ref = participant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        participant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for participant.
     */
    public com.google.protobuf.ByteString getParticipantBytes() {
      java.lang.Object ref = participant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        participant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      participant_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipant() {
      participant_ = getDefaultInstance().getParticipant();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      participant_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>
        audioConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     *
     * @return Whether the audioConfig field is set.
     */
    @java.lang.Override
    public boolean hasAudioConfig() {
      return configCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     *
     * @return The audioConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getAudioConfig() {
      if (audioConfigBuilder_ == null) {
        if (configCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      } else {
        if (configCase_ == 2) {
          return audioConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder setAudioConfig(com.google.cloud.dialogflow.v2beta1.InputAudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(value);
      }
      configCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder setAudioConfig(
        com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder builderForValue) {
      if (audioConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder mergeAudioConfig(com.google.cloud.dialogflow.v2beta1.InputAudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (configCase_ == 2
            && config_
                != com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance()) {
          config_ =
              com.google.cloud.dialogflow.v2beta1.InputAudioConfig.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 2) {
          audioConfigBuilder_.mergeFrom(value);
        } else {
          audioConfigBuilder_.setMessage(value);
        }
      }
      configCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder clearAudioConfig() {
      if (audioConfigBuilder_ == null) {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
        }
        audioConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder getAudioConfigBuilder() {
      return getAudioConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder getAudioConfigOrBuilder() {
      if ((configCase_ == 2) && (audioConfigBuilder_ != null)) {
        return audioConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>
        getAudioConfigFieldBuilder() {
      if (audioConfigBuilder_ == null) {
        if (!(configCase_ == 2)) {
          config_ = com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
        }
        audioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 2;
      onChanged();
      return audioConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputTextConfig,
            com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder>
        textConfigBuilder_;

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     *
     * @return Whether the textConfig field is set.
     */
    @java.lang.Override
    public boolean hasTextConfig() {
      return configCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     *
     * @return The textConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputTextConfig getTextConfig() {
      if (textConfigBuilder_ == null) {
        if (configCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
      } else {
        if (configCase_ == 3) {
          return textConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder setTextConfig(com.google.cloud.dialogflow.v2beta1.InputTextConfig value) {
      if (textConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        textConfigBuilder_.setMessage(value);
      }
      configCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder setTextConfig(
        com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder builderForValue) {
      if (textConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        textConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder mergeTextConfig(com.google.cloud.dialogflow.v2beta1.InputTextConfig value) {
      if (textConfigBuilder_ == null) {
        if (configCase_ == 3
            && config_
                != com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance()) {
          config_ =
              com.google.cloud.dialogflow.v2beta1.InputTextConfig.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 3) {
          textConfigBuilder_.mergeFrom(value);
        } else {
          textConfigBuilder_.setMessage(value);
        }
      }
      configCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder clearTextConfig() {
      if (textConfigBuilder_ == null) {
        if (configCase_ == 3) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 3) {
          configCase_ = 0;
          config_ = null;
        }
        textConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder getTextConfigBuilder() {
      return getTextConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder getTextConfigOrBuilder() {
      if ((configCase_ == 3) && (textConfigBuilder_ != null)) {
        return textConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputTextConfig,
            com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder>
        getTextConfigFieldBuilder() {
      if (textConfigBuilder_ == null) {
        if (!(configCase_ == 3)) {
          config_ = com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
        }
        textConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.InputTextConfig,
                com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 3;
      onChanged();
      return textConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig replyAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        replyAudioConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     *
     * @return Whether the replyAudioConfig field is set.
     */
    public boolean hasReplyAudioConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     *
     * @return The replyAudioConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getReplyAudioConfig() {
      if (replyAudioConfigBuilder_ == null) {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      } else {
        return replyAudioConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder setReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replyAudioConfig_ = value;
      } else {
        replyAudioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder setReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder builderForValue) {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = builderForValue.build();
      } else {
        replyAudioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder mergeReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && replyAudioConfig_ != null
            && replyAudioConfig_
                != com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()) {
          getReplyAudioConfigBuilder().mergeFrom(value);
        } else {
          replyAudioConfig_ = value;
        }
      } else {
        replyAudioConfigBuilder_.mergeFrom(value);
      }
      if (replyAudioConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder clearReplyAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      replyAudioConfig_ = null;
      if (replyAudioConfigBuilder_ != null) {
        replyAudioConfigBuilder_.dispose();
        replyAudioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder
        getReplyAudioConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getReplyAudioConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
        getReplyAudioConfigOrBuilder() {
      if (replyAudioConfigBuilder_ != null) {
        return replyAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        getReplyAudioConfigFieldBuilder() {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>(
                getReplyAudioConfig(), getParentForChildren(), isClean());
        replyAudioConfig_ = null;
      }
      return replyAudioConfigBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @return Whether the inputAudio field is set.
     */
    public boolean hasInputAudio() {
      return inputCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @return The inputAudio.
     */
    public com.google.protobuf.ByteString getInputAudio() {
      if (inputCase_ == 5) {
        return (com.google.protobuf.ByteString) input_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }

    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @param value The inputAudio to set.
     * @return This builder for chaining.
     */
    public Builder setInputAudio(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputCase_ = 5;
      input_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputAudio() {
      if (inputCase_ == 5) {
        inputCase_ = 0;
        input_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes for virtual agent interactions. The `input_text` field can be
     * only sent once, and would cancel the speech recognition if any ongoing.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return Whether the inputText field is set.
     */
    @java.lang.Override
    public boolean hasInputText() {
      return inputCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes for virtual agent interactions. The `input_text` field can be
     * only sent once, and would cancel the speech recognition if any ongoing.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return The inputText.
     */
    @java.lang.Override
    public java.lang.String getInputText() {
      java.lang.Object ref = "";
      if (inputCase_ == 6) {
        ref = input_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (inputCase_ == 6) {
          input_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes for virtual agent interactions. The `input_text` field can be
     * only sent once, and would cancel the speech recognition if any ongoing.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return The bytes for inputText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputTextBytes() {
      java.lang.Object ref = "";
      if (inputCase_ == 6) {
        ref = input_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (inputCase_ == 6) {
          input_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes for virtual agent interactions. The `input_text` field can be
     * only sent once, and would cancel the speech recognition if any ongoing.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @param value The inputText to set.
     * @return This builder for chaining.
     */
    public Builder setInputText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputCase_ = 6;
      input_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes for virtual agent interactions. The `input_text` field can be
     * only sent once, and would cancel the speech recognition if any ongoing.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputText() {
      if (inputCase_ == 6) {
        inputCase_ = 0;
        input_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes for virtual agent interactions. The `input_text` field can be
     * only sent once, and would cancel the speech recognition if any ongoing.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @param value The bytes for inputText to set.
     * @return This builder for chaining.
     */
    public Builder setInputTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputCase_ = 6;
      input_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>
        inputDtmfBuilder_;

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     *
     * @return Whether the inputDtmf field is set.
     */
    @java.lang.Override
    public boolean hasInputDtmf() {
      return inputCase_ == 9;
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     *
     * @return The inputDtmf.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents getInputDtmf() {
      if (inputDtmfBuilder_ == null) {
        if (inputCase_ == 9) {
          return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      } else {
        if (inputCase_ == 9) {
          return inputDtmfBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder setInputDtmf(com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents value) {
      if (inputDtmfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        inputDtmfBuilder_.setMessage(value);
      }
      inputCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder setInputDtmf(
        com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder builderForValue) {
      if (inputDtmfBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        inputDtmfBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder mergeInputDtmf(com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents value) {
      if (inputDtmfBuilder_ == null) {
        if (inputCase_ == 9
            && input_
                != com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 9) {
          inputDtmfBuilder_.mergeFrom(value);
        } else {
          inputDtmfBuilder_.setMessage(value);
        }
      }
      inputCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder clearInputDtmf() {
      if (inputDtmfBuilder_ == null) {
        if (inputCase_ == 9) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 9) {
          inputCase_ = 0;
          input_ = null;
        }
        inputDtmfBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder getInputDtmfBuilder() {
      return getInputDtmfFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder
        getInputDtmfOrBuilder() {
      if ((inputCase_ == 9) && (inputDtmfBuilder_ != null)) {
        return inputDtmfBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 9) {
          return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     *
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>
        getInputDtmfFieldBuilder() {
      if (inputDtmfBuilder_ == null) {
        if (!(inputCase_ == 9)) {
          input_ = com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
        }
        inputDtmfBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 9;
      onChanged();
      return inputDtmfBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string input_intent = 17;</code>
     *
     * @return Whether the inputIntent field is set.
     */
    @java.lang.Override
    public boolean hasInputIntent() {
      return inputCase_ == 17;
    }

    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string input_intent = 17;</code>
     *
     * @return The inputIntent.
     */
    @java.lang.Override
    public java.lang.String getInputIntent() {
      java.lang.Object ref = "";
      if (inputCase_ == 17) {
        ref = input_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (inputCase_ == 17) {
          input_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string input_intent = 17;</code>
     *
     * @return The bytes for inputIntent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputIntentBytes() {
      java.lang.Object ref = "";
      if (inputCase_ == 17) {
        ref = input_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (inputCase_ == 17) {
          input_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string input_intent = 17;</code>
     *
     * @param value The inputIntent to set.
     * @return This builder for chaining.
     */
    public Builder setInputIntent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputCase_ = 17;
      input_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string input_intent = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputIntent() {
      if (inputCase_ == 17) {
        inputCase_ = 0;
        input_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/locations/
     * &lt;Location ID&gt;/agents/&lt;Agent ID&gt;/intents/&lt;Intent ID&gt;`.
     * </pre>
     *
     * <code>string input_intent = 17;</code>
     *
     * @param value The bytes for inputIntent to set.
     * @return This builder for chaining.
     */
    public Builder setInputIntentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputCase_ = 17;
      input_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The input event name.
     * This can only be sent once and would cancel the ongoing speech
     * recognition if any.
     * </pre>
     *
     * <code>string input_event = 20;</code>
     *
     * @return Whether the inputEvent field is set.
     */
    @java.lang.Override
    public boolean hasInputEvent() {
      return inputCase_ == 20;
    }

    /**
     *
     *
     * <pre>
     * The input event name.
     * This can only be sent once and would cancel the ongoing speech
     * recognition if any.
     * </pre>
     *
     * <code>string input_event = 20;</code>
     *
     * @return The inputEvent.
     */
    @java.lang.Override
    public java.lang.String getInputEvent() {
      java.lang.Object ref = "";
      if (inputCase_ == 20) {
        ref = input_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (inputCase_ == 20) {
          input_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The input event name.
     * This can only be sent once and would cancel the ongoing speech
     * recognition if any.
     * </pre>
     *
     * <code>string input_event = 20;</code>
     *
     * @return The bytes for inputEvent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputEventBytes() {
      java.lang.Object ref = "";
      if (inputCase_ == 20) {
        ref = input_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (inputCase_ == 20) {
          input_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The input event name.
     * This can only be sent once and would cancel the ongoing speech
     * recognition if any.
     * </pre>
     *
     * <code>string input_event = 20;</code>
     *
     * @param value The inputEvent to set.
     * @return This builder for chaining.
     */
    public Builder setInputEvent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputCase_ = 20;
      input_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The input event name.
     * This can only be sent once and would cancel the ongoing speech
     * recognition if any.
     * </pre>
     *
     * <code>string input_event = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputEvent() {
      if (inputCase_ == 20) {
        inputCase_ = 0;
        input_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The input event name.
     * This can only be sent once and would cancel the ongoing speech
     * recognition if any.
     * </pre>
     *
     * <code>string input_event = 20;</code>
     *
     * @param value The bytes for inputEvent to set.
     * @return This builder for chaining.
     */
    public Builder setInputEventBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputCase_ = 20;
      input_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.QueryParameters queryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryParameters,
            com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>
        queryParamsBuilder_;

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     *
     * @return Whether the queryParams field is set.
     */
    public boolean hasQueryParams() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     *
     * @return The queryParams.
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParameters getQueryParams() {
      if (queryParamsBuilder_ == null) {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
            : queryParams_;
      } else {
        return queryParamsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder setQueryParams(com.google.cloud.dialogflow.v2beta1.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryParams_ = value;
      } else {
        queryParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder setQueryParams(
        com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder builderForValue) {
      if (queryParamsBuilder_ == null) {
        queryParams_ = builderForValue.build();
      } else {
        queryParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder mergeQueryParams(com.google.cloud.dialogflow.v2beta1.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && queryParams_ != null
            && queryParams_
                != com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()) {
          getQueryParamsBuilder().mergeFrom(value);
        } else {
          queryParams_ = value;
        }
      } else {
        queryParamsBuilder_.mergeFrom(value);
      }
      if (queryParams_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder clearQueryParams() {
      bitField0_ = (bitField0_ & ~0x00000200);
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder getQueryParamsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getQueryParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder getQueryParamsOrBuilder() {
      if (queryParamsBuilder_ != null) {
        return queryParamsBuilder_.getMessageOrBuilder();
      } else {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
            : queryParams_;
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryParameters,
            com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>
        getQueryParamsFieldBuilder() {
      if (queryParamsBuilder_ == null) {
        queryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryParameters,
                com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>(
                getQueryParams(), getParentForChildren(), isClean());
        queryParams_ = null;
      }
      return queryParamsBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.AssistQueryParameters assistQueryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder>
        assistQueryParamsBuilder_;

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     *
     * @return Whether the assistQueryParams field is set.
     */
    public boolean hasAssistQueryParams() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     *
     * @return The assistQueryParams.
     */
    public com.google.cloud.dialogflow.v2beta1.AssistQueryParameters getAssistQueryParams() {
      if (assistQueryParamsBuilder_ == null) {
        return assistQueryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
            : assistQueryParams_;
      } else {
        return assistQueryParamsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     */
    public Builder setAssistQueryParams(
        com.google.cloud.dialogflow.v2beta1.AssistQueryParameters value) {
      if (assistQueryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assistQueryParams_ = value;
      } else {
        assistQueryParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     */
    public Builder setAssistQueryParams(
        com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder builderForValue) {
      if (assistQueryParamsBuilder_ == null) {
        assistQueryParams_ = builderForValue.build();
      } else {
        assistQueryParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     */
    public Builder mergeAssistQueryParams(
        com.google.cloud.dialogflow.v2beta1.AssistQueryParameters value) {
      if (assistQueryParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && assistQueryParams_ != null
            && assistQueryParams_
                != com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()) {
          getAssistQueryParamsBuilder().mergeFrom(value);
        } else {
          assistQueryParams_ = value;
        }
      } else {
        assistQueryParamsBuilder_.mergeFrom(value);
      }
      if (assistQueryParams_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     */
    public Builder clearAssistQueryParams() {
      bitField0_ = (bitField0_ & ~0x00000400);
      assistQueryParams_ = null;
      if (assistQueryParamsBuilder_ != null) {
        assistQueryParamsBuilder_.dispose();
        assistQueryParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder
        getAssistQueryParamsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getAssistQueryParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder
        getAssistQueryParamsOrBuilder() {
      if (assistQueryParamsBuilder_ != null) {
        return assistQueryParamsBuilder_.getMessageOrBuilder();
      } else {
        return assistQueryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
            : assistQueryParams_;
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder>
        getAssistQueryParamsFieldBuilder() {
      if (assistQueryParamsBuilder_ == null) {
        assistQueryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.AssistQueryParameters,
                com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder,
                com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder>(
                getAssistQueryParams(), getParentForChildren(), isClean());
        assistQueryParams_ = null;
      }
      return assistQueryParamsBuilder_;
    }

    private com.google.protobuf.Struct cxParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        cxParametersBuilder_;

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     *
     * @return Whether the cxParameters field is set.
     */
    public boolean hasCxParameters() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     *
     * @return The cxParameters.
     */
    public com.google.protobuf.Struct getCxParameters() {
      if (cxParametersBuilder_ == null) {
        return cxParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : cxParameters_;
      } else {
        return cxParametersBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     */
    public Builder setCxParameters(com.google.protobuf.Struct value) {
      if (cxParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cxParameters_ = value;
      } else {
        cxParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     */
    public Builder setCxParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (cxParametersBuilder_ == null) {
        cxParameters_ = builderForValue.build();
      } else {
        cxParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     */
    public Builder mergeCxParameters(com.google.protobuf.Struct value) {
      if (cxParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && cxParameters_ != null
            && cxParameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCxParametersBuilder().mergeFrom(value);
        } else {
          cxParameters_ = value;
        }
      } else {
        cxParametersBuilder_.mergeFrom(value);
      }
      if (cxParameters_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     */
    public Builder clearCxParameters() {
      bitField0_ = (bitField0_ & ~0x00000800);
      cxParameters_ = null;
      if (cxParametersBuilder_ != null) {
        cxParametersBuilder_.dispose();
        cxParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     */
    public com.google.protobuf.Struct.Builder getCxParametersBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCxParametersFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     */
    public com.google.protobuf.StructOrBuilder getCxParametersOrBuilder() {
      if (cxParametersBuilder_ != null) {
        return cxParametersBuilder_.getMessageOrBuilder();
      } else {
        return cxParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : cxParameters_;
      }
    }

    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCxParametersFieldBuilder() {
      if (cxParametersBuilder_ == null) {
        cxParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCxParameters(), getParentForChildren(), isClean());
        cxParameters_ = null;
      }
      return cxParametersBuilder_;
    }

    private java.lang.Object cxCurrentPage_ = "";

    /**
     *
     *
     * <pre>
     * The unique identifier of the Dialogflow CX page to override the
     * `current_page` in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 15;</code>
     *
     * @return The cxCurrentPage.
     */
    public java.lang.String getCxCurrentPage() {
      java.lang.Object ref = cxCurrentPage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cxCurrentPage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique identifier of the Dialogflow CX page to override the
     * `current_page` in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 15;</code>
     *
     * @return The bytes for cxCurrentPage.
     */
    public com.google.protobuf.ByteString getCxCurrentPageBytes() {
      java.lang.Object ref = cxCurrentPage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cxCurrentPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unique identifier of the Dialogflow CX page to override the
     * `current_page` in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 15;</code>
     *
     * @param value The cxCurrentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCxCurrentPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cxCurrentPage_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique identifier of the Dialogflow CX page to override the
     * `current_page` in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCxCurrentPage() {
      cxCurrentPage_ = getDefaultInstance().getCxCurrentPage();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unique identifier of the Dialogflow CX page to override the
     * `current_page` in the session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 15;</code>
     *
     * @param value The bytes for cxCurrentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCxCurrentPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cxCurrentPage_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private boolean enableExtendedStreaming_;

    /**
     *
     *
     * <pre>
     * Optional. Enable full bidirectional streaming. You can keep streaming the
     * audio until timeout, and there's no need to half close the stream to get
     * the response.
     *
     * Restrictions:
     *
     * - Timeout: 3 mins.
     * - Audio Encoding: only supports
     * [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
     * and
     * [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
     * - Lifecycle: conversation should be in `Assist Stage`, go to
     *   [Conversation.CreateConversation][] for more information.
     *
     * InvalidArgument Error will be returned if the one of restriction checks
     * failed.
     *
     * You can find more details in
     * https://cloud.google.com/agent-assist/docs/extended-streaming
     * </pre>
     *
     * <code>bool enable_extended_streaming = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableExtendedStreaming.
     */
    @java.lang.Override
    public boolean getEnableExtendedStreaming() {
      return enableExtendedStreaming_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enable full bidirectional streaming. You can keep streaming the
     * audio until timeout, and there's no need to half close the stream to get
     * the response.
     *
     * Restrictions:
     *
     * - Timeout: 3 mins.
     * - Audio Encoding: only supports
     * [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
     * and
     * [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
     * - Lifecycle: conversation should be in `Assist Stage`, go to
     *   [Conversation.CreateConversation][] for more information.
     *
     * InvalidArgument Error will be returned if the one of restriction checks
     * failed.
     *
     * You can find more details in
     * https://cloud.google.com/agent-assist/docs/extended-streaming
     * </pre>
     *
     * <code>bool enable_extended_streaming = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableExtendedStreaming to set.
     * @return This builder for chaining.
     */
    public Builder setEnableExtendedStreaming(boolean value) {

      enableExtendedStreaming_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enable full bidirectional streaming. You can keep streaming the
     * audio until timeout, and there's no need to half close the stream to get
     * the response.
     *
     * Restrictions:
     *
     * - Timeout: 3 mins.
     * - Audio Encoding: only supports
     * [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
     * and
     * [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
     * - Lifecycle: conversation should be in `Assist Stage`, go to
     *   [Conversation.CreateConversation][] for more information.
     *
     * InvalidArgument Error will be returned if the one of restriction checks
     * failed.
     *
     * You can find more details in
     * https://cloud.google.com/agent-assist/docs/extended-streaming
     * </pre>
     *
     * <code>bool enable_extended_streaming = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableExtendedStreaming() {
      bitField0_ = (bitField0_ & ~0x00002000);
      enableExtendedStreaming_ = false;
      onChanged();
      return this;
    }

    private boolean enablePartialAutomatedAgentReply_;

    /**
     *
     *
     * <pre>
     * Optional. Enable partial responses from Dialogflow CX agent. If this flag
     * is not enabled, response stream still contains only one final response even
     * if some `Fulfillment`s in Dialogflow CX agent have been configured to
     * return partial responses.
     * </pre>
     *
     * <code>
     * bool enable_partial_automated_agent_reply = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enablePartialAutomatedAgentReply.
     */
    @java.lang.Override
    public boolean getEnablePartialAutomatedAgentReply() {
      return enablePartialAutomatedAgentReply_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enable partial responses from Dialogflow CX agent. If this flag
     * is not enabled, response stream still contains only one final response even
     * if some `Fulfillment`s in Dialogflow CX agent have been configured to
     * return partial responses.
     * </pre>
     *
     * <code>
     * bool enable_partial_automated_agent_reply = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enablePartialAutomatedAgentReply to set.
     * @return This builder for chaining.
     */
    public Builder setEnablePartialAutomatedAgentReply(boolean value) {

      enablePartialAutomatedAgentReply_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enable partial responses from Dialogflow CX agent. If this flag
     * is not enabled, response stream still contains only one final response even
     * if some `Fulfillment`s in Dialogflow CX agent have been configured to
     * return partial responses.
     * </pre>
     *
     * <code>
     * bool enable_partial_automated_agent_reply = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnablePartialAutomatedAgentReply() {
      bitField0_ = (bitField0_ & ~0x00004000);
      enablePartialAutomatedAgentReply_ = false;
      onChanged();
      return this;
    }

    private boolean enableDebuggingInfo_;

    /**
     *
     *
     * <pre>
     * if true, `StreamingAnalyzeContentResponse.debugging_info` will get
     * populated.
     * </pre>
     *
     * <code>bool enable_debugging_info = 19;</code>
     *
     * @return The enableDebuggingInfo.
     */
    @java.lang.Override
    public boolean getEnableDebuggingInfo() {
      return enableDebuggingInfo_;
    }

    /**
     *
     *
     * <pre>
     * if true, `StreamingAnalyzeContentResponse.debugging_info` will get
     * populated.
     * </pre>
     *
     * <code>bool enable_debugging_info = 19;</code>
     *
     * @param value The enableDebuggingInfo to set.
     * @return This builder for chaining.
     */
    public Builder setEnableDebuggingInfo(boolean value) {

      enableDebuggingInfo_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * if true, `StreamingAnalyzeContentResponse.debugging_info` will get
     * populated.
     * </pre>
     *
     * <code>bool enable_debugging_info = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableDebuggingInfo() {
      bitField0_ = (bitField0_ & ~0x00008000);
      enableDebuggingInfo_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
  private static final com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest();
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingAnalyzeContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamingAnalyzeContentRequest>() {
        @java.lang.Override
        public StreamingAnalyzeContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingAnalyzeContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingAnalyzeContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
