/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KnowledgeBaseName
implements ResourceName {
    private static final PathTemplate PROJECT_KNOWLEDGE_BASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/knowledgeBases/{knowledge_base}");
    private static final PathTemplate PROJECT_LOCATION_KNOWLEDGE_BASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/knowledgeBases/{knowledge_base}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String knowledgeBase;
    private final String location;

    @Deprecated
    protected KnowledgeBaseName() {
        this.project = null;
        this.knowledgeBase = null;
        this.location = null;
    }

    private KnowledgeBaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.knowledgeBase = (String)Preconditions.checkNotNull((Object)builder.getKnowledgeBase());
        this.location = null;
        this.pathTemplate = PROJECT_KNOWLEDGE_BASE;
    }

    private KnowledgeBaseName(ProjectLocationKnowledgeBaseBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.knowledgeBase = (String)Preconditions.checkNotNull((Object)builder.getKnowledgeBase());
        this.pathTemplate = PROJECT_LOCATION_KNOWLEDGE_BASE;
    }

    public String getProject() {
        return this.project;
    }

    public String getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectKnowledgeBaseBuilder() {
        return new Builder();
    }

    public static ProjectLocationKnowledgeBaseBuilder newProjectLocationKnowledgeBaseBuilder() {
        return new ProjectLocationKnowledgeBaseBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KnowledgeBaseName of(String project, String knowledgeBase) {
        return KnowledgeBaseName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).build();
    }

    public static KnowledgeBaseName ofProjectKnowledgeBaseName(String project, String knowledgeBase) {
        return KnowledgeBaseName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).build();
    }

    public static KnowledgeBaseName ofProjectLocationKnowledgeBaseName(String project, String location, String knowledgeBase) {
        return KnowledgeBaseName.newProjectLocationKnowledgeBaseBuilder().setProject(project).setLocation(location).setKnowledgeBase(knowledgeBase).build();
    }

    public static String format(String project, String knowledgeBase) {
        return KnowledgeBaseName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).build().toString();
    }

    public static String formatProjectKnowledgeBaseName(String project, String knowledgeBase) {
        return KnowledgeBaseName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).build().toString();
    }

    public static String formatProjectLocationKnowledgeBaseName(String project, String location, String knowledgeBase) {
        return KnowledgeBaseName.newProjectLocationKnowledgeBaseBuilder().setProject(project).setLocation(location).setKnowledgeBase(knowledgeBase).build().toString();
    }

    public static KnowledgeBaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_KNOWLEDGE_BASE.matches(formattedString)) {
            Map matchMap = PROJECT_KNOWLEDGE_BASE.match(formattedString);
            return KnowledgeBaseName.ofProjectKnowledgeBaseName((String)matchMap.get("project"), (String)matchMap.get("knowledge_base"));
        }
        if (PROJECT_LOCATION_KNOWLEDGE_BASE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_KNOWLEDGE_BASE.match(formattedString);
            return KnowledgeBaseName.ofProjectLocationKnowledgeBaseName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("knowledge_base"));
        }
        throw new ValidationException("KnowledgeBaseName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<KnowledgeBaseName> parseList(List<String> formattedStrings) {
        ArrayList<KnowledgeBaseName> list = new ArrayList<KnowledgeBaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KnowledgeBaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KnowledgeBaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KnowledgeBaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_KNOWLEDGE_BASE.matches(formattedString) || PROJECT_LOCATION_KNOWLEDGE_BASE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KnowledgeBaseName knowledgeBaseName = this;
            synchronized (knowledgeBaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.knowledgeBase != null) {
                        fieldMapBuilder.put((Object)"knowledge_base", (Object)this.knowledgeBase);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KnowledgeBaseName that = (KnowledgeBaseName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.knowledgeBase, that.knowledgeBase) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.knowledgeBase);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationKnowledgeBaseBuilder {
        private String project;
        private String location;
        private String knowledgeBase;

        protected ProjectLocationKnowledgeBaseBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKnowledgeBase() {
            return this.knowledgeBase;
        }

        public ProjectLocationKnowledgeBaseBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationKnowledgeBaseBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationKnowledgeBaseBuilder setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        public KnowledgeBaseName build() {
            return new KnowledgeBaseName(this);
        }
    }

    public static class Builder {
        private String project;
        private String knowledgeBase;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getKnowledgeBase() {
            return this.knowledgeBase;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        private Builder(KnowledgeBaseName knowledgeBaseName) {
            Preconditions.checkArgument((boolean)Objects.equals(knowledgeBaseName.pathTemplate, PROJECT_KNOWLEDGE_BASE), (Object)"toBuilder is only supported when KnowledgeBaseName has the pattern of projects/{project}/knowledgeBases/{knowledge_base}");
            this.project = knowledgeBaseName.project;
            this.knowledgeBase = knowledgeBaseName.knowledgeBase;
        }

        public KnowledgeBaseName build() {
            return new KnowledgeBaseName(this);
        }
    }
}

