/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/conversation.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [Conversations.GenerateSuggestions][google.cloud.dialogflow.v2beta1.Conversations.GenerateSuggestions].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest}
 */
public final class GenerateSuggestionsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest)
    GenerateSuggestionsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerateSuggestionsRequest.newBuilder() to construct.
  private GenerateSuggestionsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateSuggestionsRequest() {
    conversation_ = "";
    latestMessage_ = "";
    triggerEvents_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateSuggestionsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_GenerateSuggestionsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_GenerateSuggestionsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest.class,
            com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest.Builder.class);
  }

  public static final int CONVERSATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversation_ = "";

  /**
   *
   *
   * <pre>
   * Required. The conversation for which the suggestions are generated. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;`.
   *
   * The conversation must be created with a conversation profile which has
   * generators configured in it to be able to get suggestions.
   * </pre>
   *
   * <code>
   * string conversation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The conversation.
   */
  @java.lang.Override
  public java.lang.String getConversation() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The conversation for which the suggestions are generated. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;`.
   *
   * The conversation must be created with a conversation profile which has
   * generators configured in it to be able to get suggestions.
   * </pre>
   *
   * <code>
   * string conversation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for conversation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationBytes() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LATEST_MESSAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestMessage_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The name of the latest conversation message for which the request
   * is triggered. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>
   * string latest_message = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The latestMessage.
   */
  @java.lang.Override
  public java.lang.String getLatestMessage() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestMessage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The name of the latest conversation message for which the request
   * is triggered. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>
   * string latest_message = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for latestMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestMessageBytes() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_EVENTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> triggerEvents_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.dialogflow.v2beta1.TriggerEvent>
      triggerEvents_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.dialogflow.v2beta1.TriggerEvent>() {
            public com.google.cloud.dialogflow.v2beta1.TriggerEvent convert(
                java.lang.Integer from) {
              com.google.cloud.dialogflow.v2beta1.TriggerEvent result =
                  com.google.cloud.dialogflow.v2beta1.TriggerEvent.forNumber(from);
              return result == null
                  ? com.google.cloud.dialogflow.v2beta1.TriggerEvent.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Only generators configured in the
   * conversation_profile whose trigger_event is listed here will be triggered.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the triggerEvents.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.TriggerEvent> getTriggerEventsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.dialogflow.v2beta1.TriggerEvent>(
        triggerEvents_, triggerEvents_converter_);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Only generators configured in the
   * conversation_profile whose trigger_event is listed here will be triggered.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of triggerEvents.
   */
  @java.lang.Override
  public int getTriggerEventsCount() {
    return triggerEvents_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Only generators configured in the
   * conversation_profile whose trigger_event is listed here will be triggered.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The triggerEvents at the given index.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TriggerEvent getTriggerEvents(int index) {
    return triggerEvents_converter_.convert(triggerEvents_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Only generators configured in the
   * conversation_profile whose trigger_event is listed here will be triggered.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for triggerEvents.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getTriggerEventsValueList() {
    return triggerEvents_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Only generators configured in the
   * conversation_profile whose trigger_event is listed here will be triggered.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of triggerEvents at the given index.
   */
  @java.lang.Override
  public int getTriggerEventsValue(int index) {
    return triggerEvents_.get(index);
  }

  private int triggerEventsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, conversation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, latestMessage_);
    }
    if (getTriggerEventsList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(triggerEventsMemoizedSerializedSize);
    }
    for (int i = 0; i < triggerEvents_.size(); i++) {
      output.writeEnumNoTag(triggerEvents_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, conversation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, latestMessage_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < triggerEvents_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(triggerEvents_.get(i));
      }
      size += dataSize;
      if (!getTriggerEventsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      triggerEventsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest other =
        (com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest) obj;

    if (!getConversation().equals(other.getConversation())) return false;
    if (!getLatestMessage().equals(other.getLatestMessage())) return false;
    if (!triggerEvents_.equals(other.triggerEvents_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONVERSATION_FIELD_NUMBER;
    hash = (53 * hash) + getConversation().hashCode();
    hash = (37 * hash) + LATEST_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getLatestMessage().hashCode();
    if (getTriggerEventsCount() > 0) {
      hash = (37 * hash) + TRIGGER_EVENTS_FIELD_NUMBER;
      hash = (53 * hash) + triggerEvents_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request message for
   * [Conversations.GenerateSuggestions][google.cloud.dialogflow.v2beta1.Conversations.GenerateSuggestions].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest)
      com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_GenerateSuggestionsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_GenerateSuggestionsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest.class,
              com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      conversation_ = "";
      latestMessage_ = "";
      triggerEvents_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_GenerateSuggestionsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest build() {
      com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest buildPartial() {
      com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest result =
          new com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        triggerEvents_ = java.util.Collections.unmodifiableList(triggerEvents_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.triggerEvents_ = triggerEvents_;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.conversation_ = conversation_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.latestMessage_ = latestMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest.getDefaultInstance())
        return this;
      if (!other.getConversation().isEmpty()) {
        conversation_ = other.conversation_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLatestMessage().isEmpty()) {
        latestMessage_ = other.latestMessage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.triggerEvents_.isEmpty()) {
        if (triggerEvents_.isEmpty()) {
          triggerEvents_ = other.triggerEvents_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureTriggerEventsIsMutable();
          triggerEvents_.addAll(other.triggerEvents_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                conversation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                latestMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureTriggerEventsIsMutable();
                triggerEvents_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureTriggerEventsIsMutable();
                  triggerEvents_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object conversation_ = "";

    /**
     *
     *
     * <pre>
     * Required. The conversation for which the suggestions are generated. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     *
     * The conversation must be created with a conversation profile which has
     * generators configured in it to be able to get suggestions.
     * </pre>
     *
     * <code>
     * string conversation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The conversation.
     */
    public java.lang.String getConversation() {
      java.lang.Object ref = conversation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The conversation for which the suggestions are generated. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     *
     * The conversation must be created with a conversation profile which has
     * generators configured in it to be able to get suggestions.
     * </pre>
     *
     * <code>
     * string conversation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for conversation.
     */
    public com.google.protobuf.ByteString getConversationBytes() {
      java.lang.Object ref = conversation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The conversation for which the suggestions are generated. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     *
     * The conversation must be created with a conversation profile which has
     * generators configured in it to be able to get suggestions.
     * </pre>
     *
     * <code>
     * string conversation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversation_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The conversation for which the suggestions are generated. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     *
     * The conversation must be created with a conversation profile which has
     * generators configured in it to be able to get suggestions.
     * </pre>
     *
     * <code>
     * string conversation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversation() {
      conversation_ = getDefaultInstance().getConversation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The conversation for which the suggestions are generated. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;`.
     *
     * The conversation must be created with a conversation profile which has
     * generators configured in it to be able to get suggestions.
     * </pre>
     *
     * <code>
     * string conversation = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversation_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object latestMessage_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The name of the latest conversation message for which the request
     * is triggered. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>
     * string latest_message = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The latestMessage.
     */
    public java.lang.String getLatestMessage() {
      java.lang.Object ref = latestMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the latest conversation message for which the request
     * is triggered. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>
     * string latest_message = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for latestMessage.
     */
    public com.google.protobuf.ByteString getLatestMessageBytes() {
      java.lang.Object ref = latestMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the latest conversation message for which the request
     * is triggered. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>
     * string latest_message = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the latest conversation message for which the request
     * is triggered. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>
     * string latest_message = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestMessage() {
      latestMessage_ = getDefaultInstance().getLatestMessage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the latest conversation message for which the request
     * is triggered. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>
     * string latest_message = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> triggerEvents_ = java.util.Collections.emptyList();

    private void ensureTriggerEventsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        triggerEvents_ = new java.util.ArrayList<java.lang.Integer>(triggerEvents_);
        bitField0_ |= 0x00000004;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the triggerEvents.
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.TriggerEvent> getTriggerEventsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.dialogflow.v2beta1.TriggerEvent>(
          triggerEvents_, triggerEvents_converter_);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of triggerEvents.
     */
    public int getTriggerEventsCount() {
      return triggerEvents_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The triggerEvents at the given index.
     */
    public com.google.cloud.dialogflow.v2beta1.TriggerEvent getTriggerEvents(int index) {
      return triggerEvents_converter_.convert(triggerEvents_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The triggerEvents to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEvents(
        int index, com.google.cloud.dialogflow.v2beta1.TriggerEvent value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTriggerEventsIsMutable();
      triggerEvents_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addTriggerEvents(com.google.cloud.dialogflow.v2beta1.TriggerEvent value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTriggerEventsIsMutable();
      triggerEvents_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addAllTriggerEvents(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.TriggerEvent> values) {
      ensureTriggerEventsIsMutable();
      for (com.google.cloud.dialogflow.v2beta1.TriggerEvent value : values) {
        triggerEvents_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerEvents() {
      triggerEvents_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for triggerEvents.
     */
    public java.util.List<java.lang.Integer> getTriggerEventsValueList() {
      return java.util.Collections.unmodifiableList(triggerEvents_);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of triggerEvents at the given index.
     */
    public int getTriggerEventsValue(int index) {
      return triggerEvents_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for triggerEvents to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEventsValue(int index, int value) {
      ensureTriggerEventsIsMutable();
      triggerEvents_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addTriggerEventsValue(int value) {
      ensureTriggerEventsIsMutable();
      triggerEvents_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Only generators configured in the
     * conversation_profile whose trigger_event is listed here will be triggered.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.TriggerEvent trigger_events = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addAllTriggerEventsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureTriggerEventsIsMutable();
      for (int value : values) {
        triggerEvents_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest)
  private static final com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest();
  }

  public static com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateSuggestionsRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateSuggestionsRequest>() {
        @java.lang.Override
        public GenerateSuggestionsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateSuggestionsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateSuggestionsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.GenerateSuggestionsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
