/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/sip_trunk.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * SipTrunk is the resource that represents a SIP trunk to connect to Google
 * Telephony platform SIP trunking service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.SipTrunk}
 */
public final class SipTrunk extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.SipTrunk)
    SipTrunkOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SipTrunk.newBuilder() to construct.
  private SipTrunk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SipTrunk() {
    name_ = "";
    expectedHostname_ = com.google.protobuf.LazyStringArrayList.emptyList();
    connections_ = java.util.Collections.emptyList();
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SipTrunk();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
        .internal_static_google_cloud_dialogflow_v2beta1_SipTrunk_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
        .internal_static_google_cloud_dialogflow_v2beta1_SipTrunk_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.SipTrunk.class,
            com.google.cloud.dialogflow.v2beta1.SipTrunk.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. The unique identifier of the SIP trunk.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/sipTrunks/&lt;SipTrunk
   * ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. The unique identifier of the SIP trunk.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/sipTrunks/&lt;SipTrunk
   * ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPECTED_HOSTNAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList expectedHostname_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Required. The expected hostnames in the peer certificate from partner that
   * is used for TLS authentication.
   * </pre>
   *
   * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the expectedHostname.
   */
  public com.google.protobuf.ProtocolStringList getExpectedHostnameList() {
    return expectedHostname_;
  }

  /**
   *
   *
   * <pre>
   * Required. The expected hostnames in the peer certificate from partner that
   * is used for TLS authentication.
   * </pre>
   *
   * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of expectedHostname.
   */
  public int getExpectedHostnameCount() {
    return expectedHostname_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The expected hostnames in the peer certificate from partner that
   * is used for TLS authentication.
   * </pre>
   *
   * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The expectedHostname at the given index.
   */
  public java.lang.String getExpectedHostname(int index) {
    return expectedHostname_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The expected hostnames in the peer certificate from partner that
   * is used for TLS authentication.
   * </pre>
   *
   * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the expectedHostname at the given index.
   */
  public com.google.protobuf.ByteString getExpectedHostnameBytes(int index) {
    return expectedHostname_.getByteString(index);
  }

  public static final int CONNECTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Connection> connections_;

  /**
   *
   *
   * <pre>
   * Output only. Connections of the SIP trunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Connection> getConnectionsList() {
    return connections_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Connections of the SIP trunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder>
      getConnectionsOrBuilderList() {
    return connections_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Connections of the SIP trunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConnectionsCount() {
    return connections_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. Connections of the SIP trunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Connection getConnections(int index) {
    return connections_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. Connections of the SIP trunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder getConnectionsOrBuilder(
      int index) {
    return connections_.get(index);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Human readable alias for this trunk.
   * </pre>
   *
   * <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Human readable alias for this trunk.
   * </pre>
   *
   * <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < expectedHostname_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, expectedHostname_.getRaw(i));
    }
    for (int i = 0; i < connections_.size(); i++) {
      output.writeMessage(3, connections_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < expectedHostname_.size(); i++) {
        dataSize += computeStringSizeNoTag(expectedHostname_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExpectedHostnameList().size();
    }
    for (int i = 0; i < connections_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, connections_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.SipTrunk)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.SipTrunk other =
        (com.google.cloud.dialogflow.v2beta1.SipTrunk) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getExpectedHostnameList().equals(other.getExpectedHostnameList())) return false;
    if (!getConnectionsList().equals(other.getConnectionsList())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getExpectedHostnameCount() > 0) {
      hash = (37 * hash) + EXPECTED_HOSTNAME_FIELD_NUMBER;
      hash = (53 * hash) + getExpectedHostnameList().hashCode();
    }
    if (getConnectionsCount() > 0) {
      hash = (37 * hash) + CONNECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConnectionsList().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.SipTrunk prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * SipTrunk is the resource that represents a SIP trunk to connect to Google
   * Telephony platform SIP trunking service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.SipTrunk}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.SipTrunk)
      com.google.cloud.dialogflow.v2beta1.SipTrunkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_SipTrunk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_SipTrunk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.SipTrunk.class,
              com.google.cloud.dialogflow.v2beta1.SipTrunk.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.SipTrunk.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      expectedHostname_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (connectionsBuilder_ == null) {
        connections_ = java.util.Collections.emptyList();
      } else {
        connections_ = null;
        connectionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      displayName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunkProto
          .internal_static_google_cloud_dialogflow_v2beta1_SipTrunk_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SipTrunk getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.SipTrunk.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SipTrunk build() {
      com.google.cloud.dialogflow.v2beta1.SipTrunk result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SipTrunk buildPartial() {
      com.google.cloud.dialogflow.v2beta1.SipTrunk result =
          new com.google.cloud.dialogflow.v2beta1.SipTrunk(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.v2beta1.SipTrunk result) {
      if (connectionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          connections_ = java.util.Collections.unmodifiableList(connections_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.connections_ = connections_;
      } else {
        result.connections_ = connectionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.SipTrunk result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        expectedHostname_.makeImmutable();
        result.expectedHostname_ = expectedHostname_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.SipTrunk) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.SipTrunk) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.SipTrunk other) {
      if (other == com.google.cloud.dialogflow.v2beta1.SipTrunk.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.expectedHostname_.isEmpty()) {
        if (expectedHostname_.isEmpty()) {
          expectedHostname_ = other.expectedHostname_;
          bitField0_ |= 0x00000002;
        } else {
          ensureExpectedHostnameIsMutable();
          expectedHostname_.addAll(other.expectedHostname_);
        }
        onChanged();
      }
      if (connectionsBuilder_ == null) {
        if (!other.connections_.isEmpty()) {
          if (connections_.isEmpty()) {
            connections_ = other.connections_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureConnectionsIsMutable();
            connections_.addAll(other.connections_);
          }
          onChanged();
        }
      } else {
        if (!other.connections_.isEmpty()) {
          if (connectionsBuilder_.isEmpty()) {
            connectionsBuilder_.dispose();
            connectionsBuilder_ = null;
            connections_ = other.connections_;
            bitField0_ = (bitField0_ & ~0x00000004);
            connectionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConnectionsFieldBuilder()
                    : null;
          } else {
            connectionsBuilder_.addAllMessages(other.connections_);
          }
        }
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExpectedHostnameIsMutable();
                expectedHostname_.add(s);
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dialogflow.v2beta1.Connection m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Connection.parser(), extensionRegistry);
                if (connectionsBuilder_ == null) {
                  ensureConnectionsIsMutable();
                  connections_.add(m);
                } else {
                  connectionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. The unique identifier of the SIP trunk.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/sipTrunks/&lt;SipTrunk
     * ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The unique identifier of the SIP trunk.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/sipTrunks/&lt;SipTrunk
     * ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. The unique identifier of the SIP trunk.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/sipTrunks/&lt;SipTrunk
     * ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The unique identifier of the SIP trunk.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/sipTrunks/&lt;SipTrunk
     * ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. The unique identifier of the SIP trunk.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/sipTrunks/&lt;SipTrunk
     * ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList expectedHostname_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExpectedHostnameIsMutable() {
      if (!expectedHostname_.isModifiable()) {
        expectedHostname_ = new com.google.protobuf.LazyStringArrayList(expectedHostname_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the expectedHostname.
     */
    public com.google.protobuf.ProtocolStringList getExpectedHostnameList() {
      expectedHostname_.makeImmutable();
      return expectedHostname_;
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of expectedHostname.
     */
    public int getExpectedHostnameCount() {
      return expectedHostname_.size();
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The expectedHostname at the given index.
     */
    public java.lang.String getExpectedHostname(int index) {
      return expectedHostname_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the expectedHostname at the given index.
     */
    public com.google.protobuf.ByteString getExpectedHostnameBytes(int index) {
      return expectedHostname_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The expectedHostname to set.
     * @return This builder for chaining.
     */
    public Builder setExpectedHostname(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExpectedHostnameIsMutable();
      expectedHostname_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The expectedHostname to add.
     * @return This builder for chaining.
     */
    public Builder addExpectedHostname(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExpectedHostnameIsMutable();
      expectedHostname_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The expectedHostname to add.
     * @return This builder for chaining.
     */
    public Builder addAllExpectedHostname(java.lang.Iterable<java.lang.String> values) {
      ensureExpectedHostnameIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, expectedHostname_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExpectedHostname() {
      expectedHostname_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The expected hostnames in the peer certificate from partner that
     * is used for TLS authentication.
     * </pre>
     *
     * <code>repeated string expected_hostname = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the expectedHostname to add.
     * @return This builder for chaining.
     */
    public Builder addExpectedHostnameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExpectedHostnameIsMutable();
      expectedHostname_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Connection> connections_ =
        java.util.Collections.emptyList();

    private void ensureConnectionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        connections_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Connection>(connections_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Connection,
            com.google.cloud.dialogflow.v2beta1.Connection.Builder,
            com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder>
        connectionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Connection> getConnectionsList() {
      if (connectionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(connections_);
      } else {
        return connectionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConnectionsCount() {
      if (connectionsBuilder_ == null) {
        return connections_.size();
      } else {
        return connectionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Connection getConnections(int index) {
      if (connectionsBuilder_ == null) {
        return connections_.get(index);
      } else {
        return connectionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConnections(int index, com.google.cloud.dialogflow.v2beta1.Connection value) {
      if (connectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectionsIsMutable();
        connections_.set(index, value);
        onChanged();
      } else {
        connectionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConnections(
        int index, com.google.cloud.dialogflow.v2beta1.Connection.Builder builderForValue) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.set(index, builderForValue.build());
        onChanged();
      } else {
        connectionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnections(com.google.cloud.dialogflow.v2beta1.Connection value) {
      if (connectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectionsIsMutable();
        connections_.add(value);
        onChanged();
      } else {
        connectionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnections(int index, com.google.cloud.dialogflow.v2beta1.Connection value) {
      if (connectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConnectionsIsMutable();
        connections_.add(index, value);
        onChanged();
      } else {
        connectionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnections(
        com.google.cloud.dialogflow.v2beta1.Connection.Builder builderForValue) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.add(builderForValue.build());
        onChanged();
      } else {
        connectionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConnections(
        int index, com.google.cloud.dialogflow.v2beta1.Connection.Builder builderForValue) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.add(index, builderForValue.build());
        onChanged();
      } else {
        connectionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConnections(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Connection> values) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, connections_);
        onChanged();
      } else {
        connectionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConnections() {
      if (connectionsBuilder_ == null) {
        connections_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        connectionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConnections(int index) {
      if (connectionsBuilder_ == null) {
        ensureConnectionsIsMutable();
        connections_.remove(index);
        onChanged();
      } else {
        connectionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Connection.Builder getConnectionsBuilder(int index) {
      return getConnectionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder getConnectionsOrBuilder(
        int index) {
      if (connectionsBuilder_ == null) {
        return connections_.get(index);
      } else {
        return connectionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder>
        getConnectionsOrBuilderList() {
      if (connectionsBuilder_ != null) {
        return connectionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(connections_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Connection.Builder addConnectionsBuilder() {
      return getConnectionsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.Connection.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Connection.Builder addConnectionsBuilder(int index) {
      return getConnectionsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2beta1.Connection.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. Connections of the SIP trunk.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.Connection connections = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Connection.Builder>
        getConnectionsBuilderList() {
      return getConnectionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Connection,
            com.google.cloud.dialogflow.v2beta1.Connection.Builder,
            com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder>
        getConnectionsFieldBuilder() {
      if (connectionsBuilder_ == null) {
        connectionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Connection,
                com.google.cloud.dialogflow.v2beta1.Connection.Builder,
                com.google.cloud.dialogflow.v2beta1.ConnectionOrBuilder>(
                connections_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        connections_ = null;
      }
      return connectionsBuilder_;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Human readable alias for this trunk.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human readable alias for this trunk.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Human readable alias for this trunk.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human readable alias for this trunk.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Human readable alias for this trunk.
     * </pre>
     *
     * <code>string display_name = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.SipTrunk)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.SipTrunk)
  private static final com.google.cloud.dialogflow.v2beta1.SipTrunk DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.SipTrunk();
  }

  public static com.google.cloud.dialogflow.v2beta1.SipTrunk getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SipTrunk> PARSER =
      new com.google.protobuf.AbstractParser<SipTrunk>() {
        @java.lang.Override
        public SipTrunk parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SipTrunk> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SipTrunk> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SipTrunk getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
