/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/audio_config.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Configuration of how speech should be synthesized.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig}
 */
public final class SynthesizeSpeechConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig)
    SynthesizeSpeechConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SynthesizeSpeechConfig.newBuilder() to construct.
  private SynthesizeSpeechConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SynthesizeSpeechConfig() {
    effectsProfileId_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SynthesizeSpeechConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_v2beta1_SynthesizeSpeechConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_v2beta1_SynthesizeSpeechConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.class,
            com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.Builder.class);
  }

  private int bitField0_;
  public static final int SPEAKING_RATE_FIELD_NUMBER = 1;
  private double speakingRate_ = 0D;

  /**
   *
   *
   * <pre>
   * Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is the normal
   * native speed supported by the specific voice. 2.0 is twice as fast, and 0.5
   * is half as fast. If unset(0.0), defaults to the native 1.0 speed. Any other
   * values &lt; 0.25 or &gt; 4.0 will return an error.
   * </pre>
   *
   * <code>double speaking_rate = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The speakingRate.
   */
  @java.lang.Override
  public double getSpeakingRate() {
    return speakingRate_;
  }

  public static final int PITCH_FIELD_NUMBER = 2;
  private double pitch_ = 0D;

  /**
   *
   *
   * <pre>
   * Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means increase 20
   * semitones from the original pitch. -20 means decrease 20 semitones from the
   * original pitch.
   * </pre>
   *
   * <code>double pitch = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pitch.
   */
  @java.lang.Override
  public double getPitch() {
    return pitch_;
  }

  public static final int VOLUME_GAIN_DB_FIELD_NUMBER = 3;
  private double volumeGainDb_ = 0D;

  /**
   *
   *
   * <pre>
   * Optional. Volume gain (in dB) of the normal native volume supported by the
   * specific voice, in the range [-96.0, 16.0]. If unset, or set to a value of
   * 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
   * will play at approximately half the amplitude of the normal native signal
   * amplitude. A value of +6.0 (dB) will play at approximately twice the
   * amplitude of the normal native signal amplitude. We strongly recommend not
   * to exceed +10 (dB) as there's usually no effective increase in loudness for
   * any value greater than that.
   * </pre>
   *
   * <code>double volume_gain_db = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The volumeGainDb.
   */
  @java.lang.Override
  public double getVolumeGainDb() {
    return volumeGainDb_;
  }

  public static final int EFFECTS_PROFILE_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList effectsProfileId_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. An identifier which selects 'audio effects' profiles that are
   * applied on (post synthesized) text to speech. Effects are applied on top of
   * each other in the order they are given.
   * </pre>
   *
   * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the effectsProfileId.
   */
  public com.google.protobuf.ProtocolStringList getEffectsProfileIdList() {
    return effectsProfileId_;
  }

  /**
   *
   *
   * <pre>
   * Optional. An identifier which selects 'audio effects' profiles that are
   * applied on (post synthesized) text to speech. Effects are applied on top of
   * each other in the order they are given.
   * </pre>
   *
   * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of effectsProfileId.
   */
  public int getEffectsProfileIdCount() {
    return effectsProfileId_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. An identifier which selects 'audio effects' profiles that are
   * applied on (post synthesized) text to speech. Effects are applied on top of
   * each other in the order they are given.
   * </pre>
   *
   * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The effectsProfileId at the given index.
   */
  public java.lang.String getEffectsProfileId(int index) {
    return effectsProfileId_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. An identifier which selects 'audio effects' profiles that are
   * applied on (post synthesized) text to speech. Effects are applied on top of
   * each other in the order they are given.
   * </pre>
   *
   * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the effectsProfileId at the given index.
   */
  public com.google.protobuf.ByteString getEffectsProfileIdBytes(int index) {
    return effectsProfileId_.getByteString(index);
  }

  public static final int VOICE_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice_;

  /**
   *
   *
   * <pre>
   * Optional. The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the voice field is set.
   */
  @java.lang.Override
  public boolean hasVoice() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The voice.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams getVoice() {
    return voice_ == null
        ? com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.getDefaultInstance()
        : voice_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.VoiceSelectionParamsOrBuilder getVoiceOrBuilder() {
    return voice_ == null
        ? com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.getDefaultInstance()
        : voice_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (java.lang.Double.doubleToRawLongBits(speakingRate_) != 0) {
      output.writeDouble(1, speakingRate_);
    }
    if (java.lang.Double.doubleToRawLongBits(pitch_) != 0) {
      output.writeDouble(2, pitch_);
    }
    if (java.lang.Double.doubleToRawLongBits(volumeGainDb_) != 0) {
      output.writeDouble(3, volumeGainDb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getVoice());
    }
    for (int i = 0; i < effectsProfileId_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, effectsProfileId_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (java.lang.Double.doubleToRawLongBits(speakingRate_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, speakingRate_);
    }
    if (java.lang.Double.doubleToRawLongBits(pitch_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, pitch_);
    }
    if (java.lang.Double.doubleToRawLongBits(volumeGainDb_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, volumeGainDb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getVoice());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < effectsProfileId_.size(); i++) {
        dataSize += computeStringSizeNoTag(effectsProfileId_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEffectsProfileIdList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig other =
        (com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig) obj;

    if (java.lang.Double.doubleToLongBits(getSpeakingRate())
        != java.lang.Double.doubleToLongBits(other.getSpeakingRate())) return false;
    if (java.lang.Double.doubleToLongBits(getPitch())
        != java.lang.Double.doubleToLongBits(other.getPitch())) return false;
    if (java.lang.Double.doubleToLongBits(getVolumeGainDb())
        != java.lang.Double.doubleToLongBits(other.getVolumeGainDb())) return false;
    if (!getEffectsProfileIdList().equals(other.getEffectsProfileIdList())) return false;
    if (hasVoice() != other.hasVoice()) return false;
    if (hasVoice()) {
      if (!getVoice().equals(other.getVoice())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SPEAKING_RATE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getSpeakingRate()));
    hash = (37 * hash) + PITCH_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getPitch()));
    hash = (37 * hash) + VOLUME_GAIN_DB_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getVolumeGainDb()));
    if (getEffectsProfileIdCount() > 0) {
      hash = (37 * hash) + EFFECTS_PROFILE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getEffectsProfileIdList().hashCode();
    }
    if (hasVoice()) {
      hash = (37 * hash) + VOICE_FIELD_NUMBER;
      hash = (53 * hash) + getVoice().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration of how speech should be synthesized.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig)
      com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_SynthesizeSpeechConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_SynthesizeSpeechConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.class,
              com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVoiceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      speakingRate_ = 0D;
      pitch_ = 0D;
      volumeGainDb_ = 0D;
      effectsProfileId_ = com.google.protobuf.LazyStringArrayList.emptyList();
      voice_ = null;
      if (voiceBuilder_ != null) {
        voiceBuilder_.dispose();
        voiceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_SynthesizeSpeechConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig build() {
      com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig buildPartial() {
      com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig result =
          new com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.speakingRate_ = speakingRate_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pitch_ = pitch_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.volumeGainDb_ = volumeGainDb_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        effectsProfileId_.makeImmutable();
        result.effectsProfileId_ = effectsProfileId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.voice_ = voiceBuilder_ == null ? voice_ : voiceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig other) {
      if (other == com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig.getDefaultInstance())
        return this;
      if (other.getSpeakingRate() != 0D) {
        setSpeakingRate(other.getSpeakingRate());
      }
      if (other.getPitch() != 0D) {
        setPitch(other.getPitch());
      }
      if (other.getVolumeGainDb() != 0D) {
        setVolumeGainDb(other.getVolumeGainDb());
      }
      if (!other.effectsProfileId_.isEmpty()) {
        if (effectsProfileId_.isEmpty()) {
          effectsProfileId_ = other.effectsProfileId_;
          bitField0_ |= 0x00000008;
        } else {
          ensureEffectsProfileIdIsMutable();
          effectsProfileId_.addAll(other.effectsProfileId_);
        }
        onChanged();
      }
      if (other.hasVoice()) {
        mergeVoice(other.getVoice());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 9:
              {
                speakingRate_ = input.readDouble();
                bitField0_ |= 0x00000001;
                break;
              } // case 9
            case 17:
              {
                pitch_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case 17
            case 25:
              {
                volumeGainDb_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 34:
              {
                input.readMessage(getVoiceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEffectsProfileIdIsMutable();
                effectsProfileId_.add(s);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private double speakingRate_;

    /**
     *
     *
     * <pre>
     * Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is the normal
     * native speed supported by the specific voice. 2.0 is twice as fast, and 0.5
     * is half as fast. If unset(0.0), defaults to the native 1.0 speed. Any other
     * values &lt; 0.25 or &gt; 4.0 will return an error.
     * </pre>
     *
     * <code>double speaking_rate = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The speakingRate.
     */
    @java.lang.Override
    public double getSpeakingRate() {
      return speakingRate_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is the normal
     * native speed supported by the specific voice. 2.0 is twice as fast, and 0.5
     * is half as fast. If unset(0.0), defaults to the native 1.0 speed. Any other
     * values &lt; 0.25 or &gt; 4.0 will return an error.
     * </pre>
     *
     * <code>double speaking_rate = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The speakingRate to set.
     * @return This builder for chaining.
     */
    public Builder setSpeakingRate(double value) {

      speakingRate_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is the normal
     * native speed supported by the specific voice. 2.0 is twice as fast, and 0.5
     * is half as fast. If unset(0.0), defaults to the native 1.0 speed. Any other
     * values &lt; 0.25 or &gt; 4.0 will return an error.
     * </pre>
     *
     * <code>double speaking_rate = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeakingRate() {
      bitField0_ = (bitField0_ & ~0x00000001);
      speakingRate_ = 0D;
      onChanged();
      return this;
    }

    private double pitch_;

    /**
     *
     *
     * <pre>
     * Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means increase 20
     * semitones from the original pitch. -20 means decrease 20 semitones from the
     * original pitch.
     * </pre>
     *
     * <code>double pitch = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pitch.
     */
    @java.lang.Override
    public double getPitch() {
      return pitch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means increase 20
     * semitones from the original pitch. -20 means decrease 20 semitones from the
     * original pitch.
     * </pre>
     *
     * <code>double pitch = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pitch to set.
     * @return This builder for chaining.
     */
    public Builder setPitch(double value) {

      pitch_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Speaking pitch, in the range [-20.0, 20.0]. 20 means increase 20
     * semitones from the original pitch. -20 means decrease 20 semitones from the
     * original pitch.
     * </pre>
     *
     * <code>double pitch = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPitch() {
      bitField0_ = (bitField0_ & ~0x00000002);
      pitch_ = 0D;
      onChanged();
      return this;
    }

    private double volumeGainDb_;

    /**
     *
     *
     * <pre>
     * Optional. Volume gain (in dB) of the normal native volume supported by the
     * specific voice, in the range [-96.0, 16.0]. If unset, or set to a value of
     * 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
     * will play at approximately half the amplitude of the normal native signal
     * amplitude. A value of +6.0 (dB) will play at approximately twice the
     * amplitude of the normal native signal amplitude. We strongly recommend not
     * to exceed +10 (dB) as there's usually no effective increase in loudness for
     * any value greater than that.
     * </pre>
     *
     * <code>double volume_gain_db = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The volumeGainDb.
     */
    @java.lang.Override
    public double getVolumeGainDb() {
      return volumeGainDb_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Volume gain (in dB) of the normal native volume supported by the
     * specific voice, in the range [-96.0, 16.0]. If unset, or set to a value of
     * 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
     * will play at approximately half the amplitude of the normal native signal
     * amplitude. A value of +6.0 (dB) will play at approximately twice the
     * amplitude of the normal native signal amplitude. We strongly recommend not
     * to exceed +10 (dB) as there's usually no effective increase in loudness for
     * any value greater than that.
     * </pre>
     *
     * <code>double volume_gain_db = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The volumeGainDb to set.
     * @return This builder for chaining.
     */
    public Builder setVolumeGainDb(double value) {

      volumeGainDb_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Volume gain (in dB) of the normal native volume supported by the
     * specific voice, in the range [-96.0, 16.0]. If unset, or set to a value of
     * 0.0 (dB), will play at normal native signal amplitude. A value of -6.0 (dB)
     * will play at approximately half the amplitude of the normal native signal
     * amplitude. A value of +6.0 (dB) will play at approximately twice the
     * amplitude of the normal native signal amplitude. We strongly recommend not
     * to exceed +10 (dB) as there's usually no effective increase in loudness for
     * any value greater than that.
     * </pre>
     *
     * <code>double volume_gain_db = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVolumeGainDb() {
      bitField0_ = (bitField0_ & ~0x00000004);
      volumeGainDb_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList effectsProfileId_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEffectsProfileIdIsMutable() {
      if (!effectsProfileId_.isModifiable()) {
        effectsProfileId_ = new com.google.protobuf.LazyStringArrayList(effectsProfileId_);
      }
      bitField0_ |= 0x00000008;
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the effectsProfileId.
     */
    public com.google.protobuf.ProtocolStringList getEffectsProfileIdList() {
      effectsProfileId_.makeImmutable();
      return effectsProfileId_;
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of effectsProfileId.
     */
    public int getEffectsProfileIdCount() {
      return effectsProfileId_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The effectsProfileId at the given index.
     */
    public java.lang.String getEffectsProfileId(int index) {
      return effectsProfileId_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the effectsProfileId at the given index.
     */
    public com.google.protobuf.ByteString getEffectsProfileIdBytes(int index) {
      return effectsProfileId_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The effectsProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setEffectsProfileId(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEffectsProfileIdIsMutable();
      effectsProfileId_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The effectsProfileId to add.
     * @return This builder for chaining.
     */
    public Builder addEffectsProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEffectsProfileIdIsMutable();
      effectsProfileId_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The effectsProfileId to add.
     * @return This builder for chaining.
     */
    public Builder addAllEffectsProfileId(java.lang.Iterable<java.lang.String> values) {
      ensureEffectsProfileIdIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, effectsProfileId_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEffectsProfileId() {
      effectsProfileId_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. An identifier which selects 'audio effects' profiles that are
     * applied on (post synthesized) text to speech. Effects are applied on top of
     * each other in the order they are given.
     * </pre>
     *
     * <code>repeated string effects_profile_id = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the effectsProfileId to add.
     * @return This builder for chaining.
     */
    public Builder addEffectsProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEffectsProfileIdIsMutable();
      effectsProfileId_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams,
            com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.Builder,
            com.google.cloud.dialogflow.v2beta1.VoiceSelectionParamsOrBuilder>
        voiceBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the voice field is set.
     */
    public boolean hasVoice() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The voice.
     */
    public com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams getVoice() {
      if (voiceBuilder_ == null) {
        return voice_ == null
            ? com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.getDefaultInstance()
            : voice_;
      } else {
        return voiceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVoice(com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams value) {
      if (voiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        voice_ = value;
      } else {
        voiceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVoice(
        com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.Builder builderForValue) {
      if (voiceBuilder_ == null) {
        voice_ = builderForValue.build();
      } else {
        voiceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVoice(com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams value) {
      if (voiceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && voice_ != null
            && voice_
                != com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.getDefaultInstance()) {
          getVoiceBuilder().mergeFrom(value);
        } else {
          voice_ = value;
        }
      } else {
        voiceBuilder_.mergeFrom(value);
      }
      if (voice_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVoice() {
      bitField0_ = (bitField0_ & ~0x00000010);
      voice_ = null;
      if (voiceBuilder_ != null) {
        voiceBuilder_.dispose();
        voiceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.Builder getVoiceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getVoiceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.VoiceSelectionParamsOrBuilder getVoiceOrBuilder() {
      if (voiceBuilder_ != null) {
        return voiceBuilder_.getMessageOrBuilder();
      } else {
        return voice_ == null
            ? com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.getDefaultInstance()
            : voice_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.VoiceSelectionParams voice = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams,
            com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.Builder,
            com.google.cloud.dialogflow.v2beta1.VoiceSelectionParamsOrBuilder>
        getVoiceFieldBuilder() {
      if (voiceBuilder_ == null) {
        voiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams,
                com.google.cloud.dialogflow.v2beta1.VoiceSelectionParams.Builder,
                com.google.cloud.dialogflow.v2beta1.VoiceSelectionParamsOrBuilder>(
                getVoice(), getParentForChildren(), isClean());
        voice_ = null;
      }
      return voiceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig)
  private static final com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig();
  }

  public static com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SynthesizeSpeechConfig> PARSER =
      new com.google.protobuf.AbstractParser<SynthesizeSpeechConfig>() {
        @java.lang.Override
        public SynthesizeSpeechConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SynthesizeSpeechConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SynthesizeSpeechConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
