/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntityTypeName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/entityTypes/{entity_type}");
    private final String project;
    private final String entityType;

    public String getProject() {
        return this.project;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EntityTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
    }

    public static EntityTypeName of(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build();
    }

    public static String format(String project, String entityType) {
        return EntityTypeName.newBuilder().setProject(project).setEntityType(entityType).build().toString();
    }

    public static EntityTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EntityTypeName.parse: formattedString not in valid format");
        return EntityTypeName.of((String)matchMap.get("project"), (String)matchMap.get("entity_type"));
    }

    public static List<EntityTypeName> parseList(List<String> formattedStrings) {
        ArrayList<EntityTypeName> list = new ArrayList<EntityTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntityTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntityTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntityTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("EntityTypeName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "entity_type", this.entityType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EntityTypeName) {
            EntityTypeName that = (EntityTypeName)o;
            return this.project.equals(that.project) && this.entityType.equals(that.entityType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.entityType.hashCode();
    }

    public static class Builder {
        private String project;
        private String entityType;

        public String getProject() {
            return this.project;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        private Builder() {
        }

        private Builder(EntityTypeName entityTypeName) {
            this.project = entityTypeName.project;
            this.entityType = entityTypeName.entityType;
        }

        public EntityTypeName build() {
            return new EntityTypeName(this);
        }
    }
}

