/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnvironmentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String environment;

    public String getProject() {
        return this.project;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EnvironmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
    }

    public static EnvironmentName of(String project, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setEnvironment(environment).build();
    }

    public static String format(String project, String environment) {
        return EnvironmentName.newBuilder().setProject(project).setEnvironment(environment).build().toString();
    }

    public static EnvironmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EnvironmentName.parse: formattedString not in valid format");
        return EnvironmentName.of((String)matchMap.get("project"), (String)matchMap.get("environment"));
    }

    public static List<EnvironmentName> parseList(List<String> formattedStrings) {
        ArrayList<EnvironmentName> list = new ArrayList<EnvironmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnvironmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnvironmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnvironmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnvironmentName environmentName = this;
            synchronized (environmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "environment", this.environment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EnvironmentName) {
            EnvironmentName that = (EnvironmentName)o;
            return this.project.equals(that.project) && this.environment.equals(that.environment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.environment.hashCode();
    }

    public static class Builder {
        private String project;
        private String environment;

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        private Builder() {
        }

        private Builder(EnvironmentName environmentName) {
            this.project = environmentName.project;
            this.environment = environmentName.environment;
        }

        public EnvironmentName build() {
            return new EnvironmentName(this);
        }
    }
}

