/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/conversation.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a call matcher that describes criteria for matching incoming SIP
 * calls to a conversation. When Dialogflow get a SIP call from a third-party
 * carrier, Dialogflow matches the call to an existing conversation by either:
 * * Extracting the conversation id from the
 *   [Call-Info header](https://tools.ietf.org/html/rfc3261#section-20.9), e.g.
 *   `Call-Info:
 *   &lt;http://dialogflow.googleapis.com/v2beta1/projects/111/conversations/222&gt;
 *   ;purpose=Goog-ContactCenter-Conversation`.
 * * Or, if that doesn't work, matching incoming [SIP
 * headers](https://tools.ietf.org/html/rfc3261#section-7.3)
 *   against any [CallMatcher][google.cloud.dialogflow.v2beta1.CallMatcher] for the conversation.
 * If an incoming SIP call without valid `Call-Info` header matches to zero or
 * multiple conversations with `CallMatcher`, we reject it.
 * A call matcher contains equality conditions for SIP headers that all have
 * to be fulfilled in order for a SIP call to match.
 * The matched SIP headers consist of well-known headers (`To`, `From`,
 * `Call-ID`) and custom headers. A [CallMatcher][google.cloud.dialogflow.v2beta1.CallMatcher] is only valid if it
 * specifies:
 * * At least 1 custom header,
 * * or at least 2 well-known headers.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.CallMatcher}
 */
public final class CallMatcher extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.CallMatcher)
    CallMatcherOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CallMatcher.newBuilder() to construct.
  private CallMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CallMatcher() {
    name_ = "";
    toHeader_ = "";
    fromHeader_ = "";
    callIdHeader_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CallMatcher();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CallMatcher(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              toHeader_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              fromHeader_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              callIdHeader_ = s;
              break;
            }
          case 42:
            {
              com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder subBuilder =
                  null;
              if (customHeaders_ != null) {
                subBuilder = customHeaders_.toBuilder();
              }
              customHeaders_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(customHeaders_);
                customHeaders_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.CallMatcher.class,
            com.google.cloud.dialogflow.v2beta1.CallMatcher.Builder.class);
  }

  public interface CustomHeadersOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cisco's proprietary `Cisco-Guid` header.
     * </pre>
     *
     * <code>string cisco_guid = 1;</code>
     *
     * @return The ciscoGuid.
     */
    java.lang.String getCiscoGuid();
    /**
     *
     *
     * <pre>
     * Cisco's proprietary `Cisco-Guid` header.
     * </pre>
     *
     * <code>string cisco_guid = 1;</code>
     *
     * @return The bytes for ciscoGuid.
     */
    com.google.protobuf.ByteString getCiscoGuidBytes();
  }
  /**
   *
   *
   * <pre>
   * Custom SIP headers. See the [description of headers in
   * the RFC](https://tools.ietf.org/html/rfc3261#section-7.3).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders}
   */
  public static final class CustomHeaders extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders)
      CustomHeadersOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CustomHeaders.newBuilder() to construct.
    private CustomHeaders(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomHeaders() {
      ciscoGuid_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomHeaders();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CustomHeaders(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                ciscoGuid_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_CustomHeaders_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_CustomHeaders_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.class,
              com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder.class);
    }

    public static final int CISCO_GUID_FIELD_NUMBER = 1;
    private volatile java.lang.Object ciscoGuid_;
    /**
     *
     *
     * <pre>
     * Cisco's proprietary `Cisco-Guid` header.
     * </pre>
     *
     * <code>string cisco_guid = 1;</code>
     *
     * @return The ciscoGuid.
     */
    @java.lang.Override
    public java.lang.String getCiscoGuid() {
      java.lang.Object ref = ciscoGuid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ciscoGuid_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cisco's proprietary `Cisco-Guid` header.
     * </pre>
     *
     * <code>string cisco_guid = 1;</code>
     *
     * @return The bytes for ciscoGuid.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCiscoGuidBytes() {
      java.lang.Object ref = ciscoGuid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ciscoGuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getCiscoGuidBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ciscoGuid_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getCiscoGuidBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, ciscoGuid_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders other =
          (com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders) obj;

      if (!getCiscoGuid().equals(other.getCiscoGuid())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CISCO_GUID_FIELD_NUMBER;
      hash = (53 * hash) + getCiscoGuid().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers. See the [description of headers in
     * the RFC](https://tools.ietf.org/html/rfc3261#section-7.3).
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders)
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeadersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_CustomHeaders_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_CustomHeaders_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.class,
                com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        ciscoGuid_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_CustomHeaders_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders build() {
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders buildPartial() {
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders result =
            new com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders(this);
        result.ciscoGuid_ = ciscoGuid_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders) {
          return mergeFrom((com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.getDefaultInstance())
          return this;
        if (!other.getCiscoGuid().isEmpty()) {
          ciscoGuid_ = other.ciscoGuid_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object ciscoGuid_ = "";
      /**
       *
       *
       * <pre>
       * Cisco's proprietary `Cisco-Guid` header.
       * </pre>
       *
       * <code>string cisco_guid = 1;</code>
       *
       * @return The ciscoGuid.
       */
      public java.lang.String getCiscoGuid() {
        java.lang.Object ref = ciscoGuid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ciscoGuid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cisco's proprietary `Cisco-Guid` header.
       * </pre>
       *
       * <code>string cisco_guid = 1;</code>
       *
       * @return The bytes for ciscoGuid.
       */
      public com.google.protobuf.ByteString getCiscoGuidBytes() {
        java.lang.Object ref = ciscoGuid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ciscoGuid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cisco's proprietary `Cisco-Guid` header.
       * </pre>
       *
       * <code>string cisco_guid = 1;</code>
       *
       * @param value The ciscoGuid to set.
       * @return This builder for chaining.
       */
      public Builder setCiscoGuid(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        ciscoGuid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cisco's proprietary `Cisco-Guid` header.
       * </pre>
       *
       * <code>string cisco_guid = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCiscoGuid() {

        ciscoGuid_ = getDefaultInstance().getCiscoGuid();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cisco's proprietary `Cisco-Guid` header.
       * </pre>
       *
       * <code>string cisco_guid = 1;</code>
       *
       * @param value The bytes for ciscoGuid to set.
       * @return This builder for chaining.
       */
      public Builder setCiscoGuidBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        ciscoGuid_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders)
    private static final com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders();
    }

    public static com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomHeaders> PARSER =
        new com.google.protobuf.AbstractParser<CustomHeaders>() {
          @java.lang.Override
          public CustomHeaders parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CustomHeaders(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CustomHeaders> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomHeaders> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this call matcher.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/callMatchers/&lt;Call Matcher ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this call matcher.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/callMatchers/&lt;Call Matcher ID&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TO_HEADER_FIELD_NUMBER = 2;
  private volatile java.lang.Object toHeader_;
  /**
   *
   *
   * <pre>
   * Value of the [`To`
   * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2) to match. If
   * empty or unspecified, we don't match to the
   * [`To` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2).
   * </pre>
   *
   * <code>string to_header = 2;</code>
   *
   * @return The toHeader.
   */
  @java.lang.Override
  public java.lang.String getToHeader() {
    java.lang.Object ref = toHeader_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      toHeader_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Value of the [`To`
   * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2) to match. If
   * empty or unspecified, we don't match to the
   * [`To` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2).
   * </pre>
   *
   * <code>string to_header = 2;</code>
   *
   * @return The bytes for toHeader.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getToHeaderBytes() {
    java.lang.Object ref = toHeader_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      toHeader_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FROM_HEADER_FIELD_NUMBER = 3;
  private volatile java.lang.Object fromHeader_;
  /**
   *
   *
   * <pre>
   * Value of the [`From`
   * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3) to match. If
   * empty or unspecified, we don't match to the
   * [`From` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3).
   * </pre>
   *
   * <code>string from_header = 3;</code>
   *
   * @return The fromHeader.
   */
  @java.lang.Override
  public java.lang.String getFromHeader() {
    java.lang.Object ref = fromHeader_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fromHeader_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Value of the [`From`
   * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3) to match. If
   * empty or unspecified, we don't match to the
   * [`From` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3).
   * </pre>
   *
   * <code>string from_header = 3;</code>
   *
   * @return The bytes for fromHeader.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFromHeaderBytes() {
    java.lang.Object ref = fromHeader_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fromHeader_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CALL_ID_HEADER_FIELD_NUMBER = 4;
  private volatile java.lang.Object callIdHeader_;
  /**
   *
   *
   * <pre>
   * Value of the [`Call-ID`
   * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4) to match. If
   * empty or unspecified, we don't match to the
   * [`Call-ID` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4).
   * </pre>
   *
   * <code>string call_id_header = 4;</code>
   *
   * @return The callIdHeader.
   */
  @java.lang.Override
  public java.lang.String getCallIdHeader() {
    java.lang.Object ref = callIdHeader_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      callIdHeader_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Value of the [`Call-ID`
   * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4) to match. If
   * empty or unspecified, we don't match to the
   * [`Call-ID` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4).
   * </pre>
   *
   * <code>string call_id_header = 4;</code>
   *
   * @return The bytes for callIdHeader.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCallIdHeaderBytes() {
    java.lang.Object ref = callIdHeader_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      callIdHeader_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOM_HEADERS_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders customHeaders_;
  /**
   *
   *
   * <pre>
   * Custom SIP headers that must match.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
   *
   * @return Whether the customHeaders field is set.
   */
  @java.lang.Override
  public boolean hasCustomHeaders() {
    return customHeaders_ != null;
  }
  /**
   *
   *
   * <pre>
   * Custom SIP headers that must match.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
   *
   * @return The customHeaders.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders getCustomHeaders() {
    return customHeaders_ == null
        ? com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.getDefaultInstance()
        : customHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Custom SIP headers that must match.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeadersOrBuilder
      getCustomHeadersOrBuilder() {
    return getCustomHeaders();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getToHeaderBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, toHeader_);
    }
    if (!getFromHeaderBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fromHeader_);
    }
    if (!getCallIdHeaderBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, callIdHeader_);
    }
    if (customHeaders_ != null) {
      output.writeMessage(5, getCustomHeaders());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getToHeaderBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, toHeader_);
    }
    if (!getFromHeaderBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, fromHeader_);
    }
    if (!getCallIdHeaderBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, callIdHeader_);
    }
    if (customHeaders_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCustomHeaders());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.CallMatcher)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.CallMatcher other =
        (com.google.cloud.dialogflow.v2beta1.CallMatcher) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getToHeader().equals(other.getToHeader())) return false;
    if (!getFromHeader().equals(other.getFromHeader())) return false;
    if (!getCallIdHeader().equals(other.getCallIdHeader())) return false;
    if (hasCustomHeaders() != other.hasCustomHeaders()) return false;
    if (hasCustomHeaders()) {
      if (!getCustomHeaders().equals(other.getCustomHeaders())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TO_HEADER_FIELD_NUMBER;
    hash = (53 * hash) + getToHeader().hashCode();
    hash = (37 * hash) + FROM_HEADER_FIELD_NUMBER;
    hash = (53 * hash) + getFromHeader().hashCode();
    hash = (37 * hash) + CALL_ID_HEADER_FIELD_NUMBER;
    hash = (53 * hash) + getCallIdHeader().hashCode();
    if (hasCustomHeaders()) {
      hash = (37 * hash) + CUSTOM_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getCustomHeaders().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.CallMatcher prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a call matcher that describes criteria for matching incoming SIP
   * calls to a conversation. When Dialogflow get a SIP call from a third-party
   * carrier, Dialogflow matches the call to an existing conversation by either:
   * * Extracting the conversation id from the
   *   [Call-Info header](https://tools.ietf.org/html/rfc3261#section-20.9), e.g.
   *   `Call-Info:
   *   &lt;http://dialogflow.googleapis.com/v2beta1/projects/111/conversations/222&gt;
   *   ;purpose=Goog-ContactCenter-Conversation`.
   * * Or, if that doesn't work, matching incoming [SIP
   * headers](https://tools.ietf.org/html/rfc3261#section-7.3)
   *   against any [CallMatcher][google.cloud.dialogflow.v2beta1.CallMatcher] for the conversation.
   * If an incoming SIP call without valid `Call-Info` header matches to zero or
   * multiple conversations with `CallMatcher`, we reject it.
   * A call matcher contains equality conditions for SIP headers that all have
   * to be fulfilled in order for a SIP call to match.
   * The matched SIP headers consist of well-known headers (`To`, `From`,
   * `Call-ID`) and custom headers. A [CallMatcher][google.cloud.dialogflow.v2beta1.CallMatcher] is only valid if it
   * specifies:
   * * At least 1 custom header,
   * * or at least 2 well-known headers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.CallMatcher}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.CallMatcher)
      com.google.cloud.dialogflow.v2beta1.CallMatcherOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.CallMatcher.class,
              com.google.cloud.dialogflow.v2beta1.CallMatcher.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.CallMatcher.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      toHeader_ = "";

      fromHeader_ = "";

      callIdHeader_ = "";

      if (customHeadersBuilder_ == null) {
        customHeaders_ = null;
      } else {
        customHeaders_ = null;
        customHeadersBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_CallMatcher_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.CallMatcher getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.CallMatcher.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.CallMatcher build() {
      com.google.cloud.dialogflow.v2beta1.CallMatcher result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.CallMatcher buildPartial() {
      com.google.cloud.dialogflow.v2beta1.CallMatcher result =
          new com.google.cloud.dialogflow.v2beta1.CallMatcher(this);
      result.name_ = name_;
      result.toHeader_ = toHeader_;
      result.fromHeader_ = fromHeader_;
      result.callIdHeader_ = callIdHeader_;
      if (customHeadersBuilder_ == null) {
        result.customHeaders_ = customHeaders_;
      } else {
        result.customHeaders_ = customHeadersBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.CallMatcher) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.CallMatcher) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.CallMatcher other) {
      if (other == com.google.cloud.dialogflow.v2beta1.CallMatcher.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getToHeader().isEmpty()) {
        toHeader_ = other.toHeader_;
        onChanged();
      }
      if (!other.getFromHeader().isEmpty()) {
        fromHeader_ = other.fromHeader_;
        onChanged();
      }
      if (!other.getCallIdHeader().isEmpty()) {
        callIdHeader_ = other.callIdHeader_;
        onChanged();
      }
      if (other.hasCustomHeaders()) {
        mergeCustomHeaders(other.getCustomHeaders());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.CallMatcher parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2beta1.CallMatcher) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this call matcher.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/callMatchers/&lt;Call Matcher ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this call matcher.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/callMatchers/&lt;Call Matcher ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this call matcher.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/callMatchers/&lt;Call Matcher ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this call matcher.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/callMatchers/&lt;Call Matcher ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this call matcher.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/callMatchers/&lt;Call Matcher ID&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object toHeader_ = "";
    /**
     *
     *
     * <pre>
     * Value of the [`To`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2) to match. If
     * empty or unspecified, we don't match to the
     * [`To` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2).
     * </pre>
     *
     * <code>string to_header = 2;</code>
     *
     * @return The toHeader.
     */
    public java.lang.String getToHeader() {
      java.lang.Object ref = toHeader_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        toHeader_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the [`To`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2) to match. If
     * empty or unspecified, we don't match to the
     * [`To` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2).
     * </pre>
     *
     * <code>string to_header = 2;</code>
     *
     * @return The bytes for toHeader.
     */
    public com.google.protobuf.ByteString getToHeaderBytes() {
      java.lang.Object ref = toHeader_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        toHeader_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the [`To`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2) to match. If
     * empty or unspecified, we don't match to the
     * [`To` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2).
     * </pre>
     *
     * <code>string to_header = 2;</code>
     *
     * @param value The toHeader to set.
     * @return This builder for chaining.
     */
    public Builder setToHeader(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      toHeader_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the [`To`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2) to match. If
     * empty or unspecified, we don't match to the
     * [`To` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2).
     * </pre>
     *
     * <code>string to_header = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearToHeader() {

      toHeader_ = getDefaultInstance().getToHeader();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the [`To`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2) to match. If
     * empty or unspecified, we don't match to the
     * [`To` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.2).
     * </pre>
     *
     * <code>string to_header = 2;</code>
     *
     * @param value The bytes for toHeader to set.
     * @return This builder for chaining.
     */
    public Builder setToHeaderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      toHeader_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object fromHeader_ = "";
    /**
     *
     *
     * <pre>
     * Value of the [`From`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3) to match. If
     * empty or unspecified, we don't match to the
     * [`From` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3).
     * </pre>
     *
     * <code>string from_header = 3;</code>
     *
     * @return The fromHeader.
     */
    public java.lang.String getFromHeader() {
      java.lang.Object ref = fromHeader_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fromHeader_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the [`From`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3) to match. If
     * empty or unspecified, we don't match to the
     * [`From` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3).
     * </pre>
     *
     * <code>string from_header = 3;</code>
     *
     * @return The bytes for fromHeader.
     */
    public com.google.protobuf.ByteString getFromHeaderBytes() {
      java.lang.Object ref = fromHeader_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fromHeader_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the [`From`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3) to match. If
     * empty or unspecified, we don't match to the
     * [`From` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3).
     * </pre>
     *
     * <code>string from_header = 3;</code>
     *
     * @param value The fromHeader to set.
     * @return This builder for chaining.
     */
    public Builder setFromHeader(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      fromHeader_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the [`From`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3) to match. If
     * empty or unspecified, we don't match to the
     * [`From` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3).
     * </pre>
     *
     * <code>string from_header = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFromHeader() {

      fromHeader_ = getDefaultInstance().getFromHeader();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the [`From`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3) to match. If
     * empty or unspecified, we don't match to the
     * [`From` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.3).
     * </pre>
     *
     * <code>string from_header = 3;</code>
     *
     * @param value The bytes for fromHeader to set.
     * @return This builder for chaining.
     */
    public Builder setFromHeaderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      fromHeader_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object callIdHeader_ = "";
    /**
     *
     *
     * <pre>
     * Value of the [`Call-ID`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4) to match. If
     * empty or unspecified, we don't match to the
     * [`Call-ID` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4).
     * </pre>
     *
     * <code>string call_id_header = 4;</code>
     *
     * @return The callIdHeader.
     */
    public java.lang.String getCallIdHeader() {
      java.lang.Object ref = callIdHeader_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        callIdHeader_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the [`Call-ID`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4) to match. If
     * empty or unspecified, we don't match to the
     * [`Call-ID` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4).
     * </pre>
     *
     * <code>string call_id_header = 4;</code>
     *
     * @return The bytes for callIdHeader.
     */
    public com.google.protobuf.ByteString getCallIdHeaderBytes() {
      java.lang.Object ref = callIdHeader_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        callIdHeader_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Value of the [`Call-ID`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4) to match. If
     * empty or unspecified, we don't match to the
     * [`Call-ID` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4).
     * </pre>
     *
     * <code>string call_id_header = 4;</code>
     *
     * @param value The callIdHeader to set.
     * @return This builder for chaining.
     */
    public Builder setCallIdHeader(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      callIdHeader_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the [`Call-ID`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4) to match. If
     * empty or unspecified, we don't match to the
     * [`Call-ID` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4).
     * </pre>
     *
     * <code>string call_id_header = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCallIdHeader() {

      callIdHeader_ = getDefaultInstance().getCallIdHeader();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Value of the [`Call-ID`
     * header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4) to match. If
     * empty or unspecified, we don't match to the
     * [`Call-ID` header](https://tools.ietf.org/html/rfc3261#section-8.1.1.4).
     * </pre>
     *
     * <code>string call_id_header = 4;</code>
     *
     * @param value The bytes for callIdHeader to set.
     * @return This builder for chaining.
     */
    public Builder setCallIdHeaderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      callIdHeader_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders customHeaders_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders,
            com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder,
            com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeadersOrBuilder>
        customHeadersBuilder_;
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     *
     * @return Whether the customHeaders field is set.
     */
    public boolean hasCustomHeaders() {
      return customHeadersBuilder_ != null || customHeaders_ != null;
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     *
     * @return The customHeaders.
     */
    public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders getCustomHeaders() {
      if (customHeadersBuilder_ == null) {
        return customHeaders_ == null
            ? com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.getDefaultInstance()
            : customHeaders_;
      } else {
        return customHeadersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     */
    public Builder setCustomHeaders(
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders value) {
      if (customHeadersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customHeaders_ = value;
        onChanged();
      } else {
        customHeadersBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     */
    public Builder setCustomHeaders(
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder builderForValue) {
      if (customHeadersBuilder_ == null) {
        customHeaders_ = builderForValue.build();
        onChanged();
      } else {
        customHeadersBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     */
    public Builder mergeCustomHeaders(
        com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders value) {
      if (customHeadersBuilder_ == null) {
        if (customHeaders_ != null) {
          customHeaders_ =
              com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.newBuilder(
                      customHeaders_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          customHeaders_ = value;
        }
        onChanged();
      } else {
        customHeadersBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     */
    public Builder clearCustomHeaders() {
      if (customHeadersBuilder_ == null) {
        customHeaders_ = null;
        onChanged();
      } else {
        customHeaders_ = null;
        customHeadersBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder
        getCustomHeadersBuilder() {

      onChanged();
      return getCustomHeadersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeadersOrBuilder
        getCustomHeadersOrBuilder() {
      if (customHeadersBuilder_ != null) {
        return customHeadersBuilder_.getMessageOrBuilder();
      } else {
        return customHeaders_ == null
            ? com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.getDefaultInstance()
            : customHeaders_;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom SIP headers that must match.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders custom_headers = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders,
            com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder,
            com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeadersOrBuilder>
        getCustomHeadersFieldBuilder() {
      if (customHeadersBuilder_ == null) {
        customHeadersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders,
                com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeaders.Builder,
                com.google.cloud.dialogflow.v2beta1.CallMatcher.CustomHeadersOrBuilder>(
                getCustomHeaders(), getParentForChildren(), isClean());
        customHeaders_ = null;
      }
      return customHeadersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.CallMatcher)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.CallMatcher)
  private static final com.google.cloud.dialogflow.v2beta1.CallMatcher DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.CallMatcher();
  }

  public static com.google.cloud.dialogflow.v2beta1.CallMatcher getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CallMatcher> PARSER =
      new com.google.protobuf.AbstractParser<CallMatcher>() {
        @java.lang.Override
        public CallMatcher parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CallMatcher(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CallMatcher> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CallMatcher> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.CallMatcher getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
