/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The top-level message sent by the client to the
 * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent] method.
 * Multiple request messages should be sent in order:
 * 1.  The first message must contain
 *     [participant][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.participant],
 *     [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config] and optionally
 *     [query_params][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.query_params]. If you want
 *     to receive an audio response, it should also contain
 *     [reply_audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.reply_audio_config].
 *     The message must not contain
 *     [input][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input].
 * 2.  If [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config] in the first message
 *     was set to [audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.audio_config],
 *     all subsequent messages must contain
 *     [input_audio][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_audio] to continue
 *     with Speech recognition.
 *     If you decide to rather analyze text input after you already started
 *     Speech recognition, please send a message with
 *     [StreamingAnalyzeContentRequest.input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
 *     However, note that:
 *     * Dialogflow will bill you for the audio so far.
 *     * Dialogflow discards all Speech recognition results in favor of the
 *       text input.
 *  3. If [StreamingAnalyzeContentRequest.config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config] in the first message was set
 *    to [StreamingAnalyzeContentRequest.text_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.text_config], then the second message
 *    must contain only [input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
 *    Moreover, you must not send more than two messages.
 *  After you sent all input, you must half-close or abort the request stream.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest}
 */
public final class StreamingAnalyzeContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
    StreamingAnalyzeContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingAnalyzeContentRequest.newBuilder() to construct.
  private StreamingAnalyzeContentRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingAnalyzeContentRequest() {
    participant_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingAnalyzeContentRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private StreamingAnalyzeContentRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              participant_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder subBuilder = null;
              if (configCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_).toBuilder();
              }
              config_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.InputAudioConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_);
                config_ = subBuilder.buildPartial();
              }
              configCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder subBuilder = null;
              if (configCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_).toBuilder();
              }
              config_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.InputTextConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_);
                config_ = subBuilder.buildPartial();
              }
              configCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder subBuilder = null;
              if (replyAudioConfig_ != null) {
                subBuilder = replyAudioConfig_.toBuilder();
              }
              replyAudioConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(replyAudioConfig_);
                replyAudioConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              inputCase_ = 5;
              input_ = input.readBytes();
              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();
              inputCase_ = 6;
              input_ = s;
              break;
            }
          case 58:
            {
              com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder subBuilder = null;
              if (queryParams_ != null) {
                subBuilder = queryParams_.toBuilder();
              }
              queryParams_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.QueryParameters.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryParams_);
                queryParams_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder subBuilder = null;
              if (inputCase_ == 9) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_).toBuilder();
              }
              input_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_);
                input_ = subBuilder.buildPartial();
              }
              inputCase_ = 9;
              break;
            }
          case 88:
            {
              enableExtendedStreaming_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.class,
            com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.Builder.class);
  }

  private int configCase_ = 0;
  private java.lang.Object config_;

  public enum ConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUDIO_CONFIG(2),
    TEXT_CONFIG(3),
    CONFIG_NOT_SET(0);
    private final int value;

    private ConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return AUDIO_CONFIG;
        case 3:
          return TEXT_CONFIG;
        case 0:
          return CONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConfigCase getConfigCase() {
    return ConfigCase.forNumber(configCase_);
  }

  private int inputCase_ = 0;
  private java.lang.Object input_;

  public enum InputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INPUT_AUDIO(5),
    INPUT_TEXT(6),
    INPUT_DTMF(9),
    INPUT_NOT_SET(0);
    private final int value;

    private InputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InputCase valueOf(int value) {
      return forNumber(value);
    }

    public static InputCase forNumber(int value) {
      switch (value) {
        case 5:
          return INPUT_AUDIO;
        case 6:
          return INPUT_TEXT;
        case 9:
          return INPUT_DTMF;
        case 0:
          return INPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InputCase getInputCase() {
    return InputCase.forNumber(inputCase_);
  }

  public static final int PARTICIPANT_FIELD_NUMBER = 1;
  private volatile java.lang.Object participant_;
  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The participant.
   */
  @java.lang.Override
  public java.lang.String getParticipant() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      participant_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for participant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParticipantBytes() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      participant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUDIO_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
   *
   * @return Whether the audioConfig field is set.
   */
  @java.lang.Override
  public boolean hasAudioConfig() {
    return configCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
   *
   * @return The audioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getAudioConfig() {
    if (configCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder getAudioConfigOrBuilder() {
    if (configCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
  }

  public static final int TEXT_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
   *
   * @return Whether the textConfig field is set.
   */
  @java.lang.Override
  public boolean hasTextConfig() {
    return configCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
   *
   * @return The textConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputTextConfig getTextConfig() {
    if (configCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder getTextConfigOrBuilder() {
    if (configCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
  }

  public static final int REPLY_AUDIO_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig replyAudioConfig_;
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * StreamingAnalyzeContent. If this configuration is not supplied, speech
   * synthesis is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
   *
   * @return Whether the replyAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasReplyAudioConfig() {
    return replyAudioConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * StreamingAnalyzeContent. If this configuration is not supplied, speech
   * synthesis is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
   *
   * @return The replyAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getReplyAudioConfig() {
    return replyAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : replyAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * StreamingAnalyzeContent. If this configuration is not supplied, speech
   * synthesis is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
      getReplyAudioConfigOrBuilder() {
    return getReplyAudioConfig();
  }

  public static final int INPUT_AUDIO_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The input audio content to be recognized. Must be sent if `audio_config`
   * is set in the first message. The complete audio over all streaming
   * messages must not exceed 1 minute.
   * </pre>
   *
   * <code>bytes input_audio = 5;</code>
   *
   * @return Whether the inputAudio field is set.
   */
  @java.lang.Override
  public boolean hasInputAudio() {
    return inputCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The input audio content to be recognized. Must be sent if `audio_config`
   * is set in the first message. The complete audio over all streaming
   * messages must not exceed 1 minute.
   * </pre>
   *
   * <code>bytes input_audio = 5;</code>
   *
   * @return The inputAudio.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputAudio() {
    if (inputCase_ == 5) {
      return (com.google.protobuf.ByteString) input_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int INPUT_TEXT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The UTF-8 encoded natural language text to be processed. Must be sent if
   * `text_config` is set in the first message. Text length must not exceed
   * 256 bytes. The `input_text` field can be only sent once.
   * </pre>
   *
   * <code>string input_text = 6;</code>
   *
   * @return Whether the inputText field is set.
   */
  public boolean hasInputText() {
    return inputCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The UTF-8 encoded natural language text to be processed. Must be sent if
   * `text_config` is set in the first message. Text length must not exceed
   * 256 bytes. The `input_text` field can be only sent once.
   * </pre>
   *
   * <code>string input_text = 6;</code>
   *
   * @return The inputText.
   */
  public java.lang.String getInputText() {
    java.lang.Object ref = "";
    if (inputCase_ == 6) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (inputCase_ == 6) {
        input_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The UTF-8 encoded natural language text to be processed. Must be sent if
   * `text_config` is set in the first message. Text length must not exceed
   * 256 bytes. The `input_text` field can be only sent once.
   * </pre>
   *
   * <code>string input_text = 6;</code>
   *
   * @return The bytes for inputText.
   */
  public com.google.protobuf.ByteString getInputTextBytes() {
    java.lang.Object ref = "";
    if (inputCase_ == 6) {
      ref = input_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (inputCase_ == 6) {
        input_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_DTMF_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   * This input is ignored if the previous response indicated that DTMF input
   * is not accepted.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
   *
   * @return Whether the inputDtmf field is set.
   */
  @java.lang.Override
  public boolean hasInputDtmf() {
    return inputCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   * This input is ignored if the previous response indicated that DTMF input
   * is not accepted.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
   *
   * @return The inputDtmf.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents getInputDtmf() {
    if (inputCase_ == 9) {
      return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   * This input is ignored if the previous response indicated that DTMF input
   * is not accepted.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder getInputDtmfOrBuilder() {
    if (inputCase_ == 9) {
      return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
  }

  public static final int QUERY_PARAMS_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.v2beta1.QueryParameters queryParams_;
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
   *
   * @return Whether the queryParams field is set.
   */
  @java.lang.Override
  public boolean hasQueryParams() {
    return queryParams_ != null;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
   *
   * @return The queryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryParameters getQueryParams() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
        : queryParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder getQueryParamsOrBuilder() {
    return getQueryParams();
  }

  public static final int ENABLE_EXTENDED_STREAMING_FIELD_NUMBER = 11;
  private boolean enableExtendedStreaming_;
  /**
   *
   *
   * <pre>
   * Enable full bidirectional streaming. You can keep streaming the audio until
   * timeout, and there's no need to half close the stream to get the response.
   * Restrictions:
   * - Timeout: 3 mins.
   * - Audio Encoding: only supports [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
   * and [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
   * - Lifecycle: conversation should be in `Assist Stage`, go to
   *   [Conversation.CreateConversation][] for more information.
   * InvalidArgument Error will be returned if the one of restriction checks
   * failed.
   * You can find more details in
   * https://cloud.google.com/dialogflow/priv/docs/agent-assist/analyze-content-streaming
   * </pre>
   *
   * <code>bool enable_extended_streaming = 11;</code>
   *
   * @return The enableExtendedStreaming.
   */
  @java.lang.Override
  public boolean getEnableExtendedStreaming() {
    return enableExtendedStreaming_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getParticipantBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, participant_);
    }
    if (configCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_);
    }
    if (configCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_);
    }
    if (replyAudioConfig_ != null) {
      output.writeMessage(4, getReplyAudioConfig());
    }
    if (inputCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) input_);
    }
    if (inputCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, input_);
    }
    if (queryParams_ != null) {
      output.writeMessage(7, getQueryParams());
    }
    if (inputCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_);
    }
    if (enableExtendedStreaming_ != false) {
      output.writeBool(11, enableExtendedStreaming_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getParticipantBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, participant_);
    }
    if (configCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_);
    }
    if (configCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_);
    }
    if (replyAudioConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getReplyAudioConfig());
    }
    if (inputCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) input_);
    }
    if (inputCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, input_);
    }
    if (queryParams_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getQueryParams());
    }
    if (inputCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_);
    }
    if (enableExtendedStreaming_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, enableExtendedStreaming_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest other =
        (com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest) obj;

    if (!getParticipant().equals(other.getParticipant())) return false;
    if (hasReplyAudioConfig() != other.hasReplyAudioConfig()) return false;
    if (hasReplyAudioConfig()) {
      if (!getReplyAudioConfig().equals(other.getReplyAudioConfig())) return false;
    }
    if (hasQueryParams() != other.hasQueryParams()) return false;
    if (hasQueryParams()) {
      if (!getQueryParams().equals(other.getQueryParams())) return false;
    }
    if (getEnableExtendedStreaming() != other.getEnableExtendedStreaming()) return false;
    if (!getConfigCase().equals(other.getConfigCase())) return false;
    switch (configCase_) {
      case 2:
        if (!getAudioConfig().equals(other.getAudioConfig())) return false;
        break;
      case 3:
        if (!getTextConfig().equals(other.getTextConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getInputCase().equals(other.getInputCase())) return false;
    switch (inputCase_) {
      case 5:
        if (!getInputAudio().equals(other.getInputAudio())) return false;
        break;
      case 6:
        if (!getInputText().equals(other.getInputText())) return false;
        break;
      case 9:
        if (!getInputDtmf().equals(other.getInputDtmf())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARTICIPANT_FIELD_NUMBER;
    hash = (53 * hash) + getParticipant().hashCode();
    if (hasReplyAudioConfig()) {
      hash = (37 * hash) + REPLY_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getReplyAudioConfig().hashCode();
    }
    if (hasQueryParams()) {
      hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParams().hashCode();
    }
    hash = (37 * hash) + ENABLE_EXTENDED_STREAMING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableExtendedStreaming());
    switch (configCase_) {
      case 2:
        hash = (37 * hash) + AUDIO_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAudioConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TEXT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextConfig().hashCode();
        break;
      case 0:
      default:
    }
    switch (inputCase_) {
      case 5:
        hash = (37 * hash) + INPUT_AUDIO_FIELD_NUMBER;
        hash = (53 * hash) + getInputAudio().hashCode();
        break;
      case 6:
        hash = (37 * hash) + INPUT_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getInputText().hashCode();
        break;
      case 9:
        hash = (37 * hash) + INPUT_DTMF_FIELD_NUMBER;
        hash = (53 * hash) + getInputDtmf().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The top-level message sent by the client to the
   * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent] method.
   * Multiple request messages should be sent in order:
   * 1.  The first message must contain
   *     [participant][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.participant],
   *     [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config] and optionally
   *     [query_params][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.query_params]. If you want
   *     to receive an audio response, it should also contain
   *     [reply_audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.reply_audio_config].
   *     The message must not contain
   *     [input][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input].
   * 2.  If [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config] in the first message
   *     was set to [audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.audio_config],
   *     all subsequent messages must contain
   *     [input_audio][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_audio] to continue
   *     with Speech recognition.
   *     If you decide to rather analyze text input after you already started
   *     Speech recognition, please send a message with
   *     [StreamingAnalyzeContentRequest.input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
   *     However, note that:
   *     * Dialogflow will bill you for the audio so far.
   *     * Dialogflow discards all Speech recognition results in favor of the
   *       text input.
   *  3. If [StreamingAnalyzeContentRequest.config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config] in the first message was set
   *    to [StreamingAnalyzeContentRequest.text_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.text_config], then the second message
   *    must contain only [input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
   *    Moreover, you must not send more than two messages.
   *  After you sent all input, you must half-close or abort the request stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.class,
              com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      participant_ = "";

      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = null;
      } else {
        replyAudioConfig_ = null;
        replyAudioConfigBuilder_ = null;
      }
      if (queryParamsBuilder_ == null) {
        queryParams_ = null;
      } else {
        queryParams_ = null;
        queryParamsBuilder_ = null;
      }
      enableExtendedStreaming_ = false;

      configCase_ = 0;
      config_ = null;
      inputCase_ = 0;
      input_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingAnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest build() {
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest buildPartial() {
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest result =
          new com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest(this);
      result.participant_ = participant_;
      if (configCase_ == 2) {
        if (audioConfigBuilder_ == null) {
          result.config_ = config_;
        } else {
          result.config_ = audioConfigBuilder_.build();
        }
      }
      if (configCase_ == 3) {
        if (textConfigBuilder_ == null) {
          result.config_ = config_;
        } else {
          result.config_ = textConfigBuilder_.build();
        }
      }
      if (replyAudioConfigBuilder_ == null) {
        result.replyAudioConfig_ = replyAudioConfig_;
      } else {
        result.replyAudioConfig_ = replyAudioConfigBuilder_.build();
      }
      if (inputCase_ == 5) {
        result.input_ = input_;
      }
      if (inputCase_ == 6) {
        result.input_ = input_;
      }
      if (inputCase_ == 9) {
        if (inputDtmfBuilder_ == null) {
          result.input_ = input_;
        } else {
          result.input_ = inputDtmfBuilder_.build();
        }
      }
      if (queryParamsBuilder_ == null) {
        result.queryParams_ = queryParams_;
      } else {
        result.queryParams_ = queryParamsBuilder_.build();
      }
      result.enableExtendedStreaming_ = enableExtendedStreaming_;
      result.configCase_ = configCase_;
      result.inputCase_ = inputCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest) {
        return mergeFrom(
            (com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
              .getDefaultInstance()) return this;
      if (!other.getParticipant().isEmpty()) {
        participant_ = other.participant_;
        onChanged();
      }
      if (other.hasReplyAudioConfig()) {
        mergeReplyAudioConfig(other.getReplyAudioConfig());
      }
      if (other.hasQueryParams()) {
        mergeQueryParams(other.getQueryParams());
      }
      if (other.getEnableExtendedStreaming() != false) {
        setEnableExtendedStreaming(other.getEnableExtendedStreaming());
      }
      switch (other.getConfigCase()) {
        case AUDIO_CONFIG:
          {
            mergeAudioConfig(other.getAudioConfig());
            break;
          }
        case TEXT_CONFIG:
          {
            mergeTextConfig(other.getTextConfig());
            break;
          }
        case CONFIG_NOT_SET:
          {
            break;
          }
      }
      switch (other.getInputCase()) {
        case INPUT_AUDIO:
          {
            setInputAudio(other.getInputAudio());
            break;
          }
        case INPUT_TEXT:
          {
            inputCase_ = 6;
            input_ = other.input_;
            onChanged();
            break;
          }
        case INPUT_DTMF:
          {
            mergeInputDtmf(other.getInputDtmf());
            break;
          }
        case INPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int configCase_ = 0;
    private java.lang.Object config_;

    public ConfigCase getConfigCase() {
      return ConfigCase.forNumber(configCase_);
    }

    public Builder clearConfig() {
      configCase_ = 0;
      config_ = null;
      onChanged();
      return this;
    }

    private int inputCase_ = 0;
    private java.lang.Object input_;

    public InputCase getInputCase() {
      return InputCase.forNumber(inputCase_);
    }

    public Builder clearInput() {
      inputCase_ = 0;
      input_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object participant_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The participant.
     */
    public java.lang.String getParticipant() {
      java.lang.Object ref = participant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        participant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for participant.
     */
    public com.google.protobuf.ByteString getParticipantBytes() {
      java.lang.Object ref = participant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        participant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      participant_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipant() {

      participant_ = getDefaultInstance().getParticipant();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      participant_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>
        audioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     *
     * @return Whether the audioConfig field is set.
     */
    @java.lang.Override
    public boolean hasAudioConfig() {
      return configCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     *
     * @return The audioConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getAudioConfig() {
      if (audioConfigBuilder_ == null) {
        if (configCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      } else {
        if (configCase_ == 2) {
          return audioConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder setAudioConfig(com.google.cloud.dialogflow.v2beta1.InputAudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(value);
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder setAudioConfig(
        com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder builderForValue) {
      if (audioConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder mergeAudioConfig(com.google.cloud.dialogflow.v2beta1.InputAudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (configCase_ == 2
            && config_
                != com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance()) {
          config_ =
              com.google.cloud.dialogflow.v2beta1.InputAudioConfig.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 2) {
          audioConfigBuilder_.mergeFrom(value);
        }
        audioConfigBuilder_.setMessage(value);
      }
      configCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public Builder clearAudioConfig() {
      if (audioConfigBuilder_ == null) {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 2) {
          configCase_ = 0;
          config_ = null;
        }
        audioConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder getAudioConfigBuilder() {
      return getAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder getAudioConfigOrBuilder() {
      if ((configCase_ == 2) && (audioConfigBuilder_ != null)) {
        return audioConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>
        getAudioConfigFieldBuilder() {
      if (audioConfigBuilder_ == null) {
        if (!(configCase_ == 2)) {
          config_ = com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
        }
        audioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 2;
      onChanged();
      ;
      return audioConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputTextConfig,
            com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder>
        textConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     *
     * @return Whether the textConfig field is set.
     */
    @java.lang.Override
    public boolean hasTextConfig() {
      return configCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     *
     * @return The textConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputTextConfig getTextConfig() {
      if (textConfigBuilder_ == null) {
        if (configCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
      } else {
        if (configCase_ == 3) {
          return textConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder setTextConfig(com.google.cloud.dialogflow.v2beta1.InputTextConfig value) {
      if (textConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        textConfigBuilder_.setMessage(value);
      }
      configCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder setTextConfig(
        com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder builderForValue) {
      if (textConfigBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        textConfigBuilder_.setMessage(builderForValue.build());
      }
      configCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder mergeTextConfig(com.google.cloud.dialogflow.v2beta1.InputTextConfig value) {
      if (textConfigBuilder_ == null) {
        if (configCase_ == 3
            && config_
                != com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance()) {
          config_ =
              com.google.cloud.dialogflow.v2beta1.InputTextConfig.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        if (configCase_ == 3) {
          textConfigBuilder_.mergeFrom(value);
        }
        textConfigBuilder_.setMessage(value);
      }
      configCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public Builder clearTextConfig() {
      if (textConfigBuilder_ == null) {
        if (configCase_ == 3) {
          configCase_ = 0;
          config_ = null;
          onChanged();
        }
      } else {
        if (configCase_ == 3) {
          configCase_ = 0;
          config_ = null;
        }
        textConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder getTextConfigBuilder() {
      return getTextConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder getTextConfigOrBuilder() {
      if ((configCase_ == 3) && (textConfigBuilder_ != null)) {
        return textConfigBuilder_.getMessageOrBuilder();
      } else {
        if (configCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputTextConfig text_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputTextConfig,
            com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder>
        getTextConfigFieldBuilder() {
      if (textConfigBuilder_ == null) {
        if (!(configCase_ == 3)) {
          config_ = com.google.cloud.dialogflow.v2beta1.InputTextConfig.getDefaultInstance();
        }
        textConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.InputTextConfig,
                com.google.cloud.dialogflow.v2beta1.InputTextConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.InputTextConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.InputTextConfig) config_,
                getParentForChildren(),
                isClean());
        config_ = null;
      }
      configCase_ = 3;
      onChanged();
      ;
      return textConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig replyAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        replyAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     *
     * @return Whether the replyAudioConfig field is set.
     */
    public boolean hasReplyAudioConfig() {
      return replyAudioConfigBuilder_ != null || replyAudioConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     *
     * @return The replyAudioConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getReplyAudioConfig() {
      if (replyAudioConfigBuilder_ == null) {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      } else {
        return replyAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder setReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replyAudioConfig_ = value;
        onChanged();
      } else {
        replyAudioConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder setReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder builderForValue) {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = builderForValue.build();
        onChanged();
      } else {
        replyAudioConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder mergeReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (replyAudioConfig_ != null) {
          replyAudioConfig_ =
              com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.newBuilder(replyAudioConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replyAudioConfig_ = value;
        }
        onChanged();
      } else {
        replyAudioConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public Builder clearReplyAudioConfig() {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = null;
        onChanged();
      } else {
        replyAudioConfig_ = null;
        replyAudioConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder
        getReplyAudioConfigBuilder() {

      onChanged();
      return getReplyAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
        getReplyAudioConfigOrBuilder() {
      if (replyAudioConfigBuilder_ != null) {
        return replyAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * StreamingAnalyzeContent. If this configuration is not supplied, speech
     * synthesis is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        getReplyAudioConfigFieldBuilder() {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>(
                getReplyAudioConfig(), getParentForChildren(), isClean());
        replyAudioConfig_ = null;
      }
      return replyAudioConfigBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @return Whether the inputAudio field is set.
     */
    public boolean hasInputAudio() {
      return inputCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @return The inputAudio.
     */
    public com.google.protobuf.ByteString getInputAudio() {
      if (inputCase_ == 5) {
        return (com.google.protobuf.ByteString) input_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @param value The inputAudio to set.
     * @return This builder for chaining.
     */
    public Builder setInputAudio(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputCase_ = 5;
      input_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if `audio_config`
     * is set in the first message. The complete audio over all streaming
     * messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputAudio() {
      if (inputCase_ == 5) {
        inputCase_ = 0;
        input_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes. The `input_text` field can be only sent once.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return Whether the inputText field is set.
     */
    @java.lang.Override
    public boolean hasInputText() {
      return inputCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes. The `input_text` field can be only sent once.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return The inputText.
     */
    @java.lang.Override
    public java.lang.String getInputText() {
      java.lang.Object ref = "";
      if (inputCase_ == 6) {
        ref = input_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (inputCase_ == 6) {
          input_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes. The `input_text` field can be only sent once.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return The bytes for inputText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputTextBytes() {
      java.lang.Object ref = "";
      if (inputCase_ == 6) {
        ref = input_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (inputCase_ == 6) {
          input_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes. The `input_text` field can be only sent once.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @param value The inputText to set.
     * @return This builder for chaining.
     */
    public Builder setInputText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputCase_ = 6;
      input_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes. The `input_text` field can be only sent once.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputText() {
      if (inputCase_ == 6) {
        inputCase_ = 0;
        input_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The UTF-8 encoded natural language text to be processed. Must be sent if
     * `text_config` is set in the first message. Text length must not exceed
     * 256 bytes. The `input_text` field can be only sent once.
     * </pre>
     *
     * <code>string input_text = 6;</code>
     *
     * @param value The bytes for inputText to set.
     * @return This builder for chaining.
     */
    public Builder setInputTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputCase_ = 6;
      input_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>
        inputDtmfBuilder_;
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     *
     * @return Whether the inputDtmf field is set.
     */
    @java.lang.Override
    public boolean hasInputDtmf() {
      return inputCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     *
     * @return The inputDtmf.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents getInputDtmf() {
      if (inputDtmfBuilder_ == null) {
        if (inputCase_ == 9) {
          return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      } else {
        if (inputCase_ == 9) {
          return inputDtmfBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder setInputDtmf(com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents value) {
      if (inputDtmfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        inputDtmfBuilder_.setMessage(value);
      }
      inputCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder setInputDtmf(
        com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder builderForValue) {
      if (inputDtmfBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        inputDtmfBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder mergeInputDtmf(com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents value) {
      if (inputDtmfBuilder_ == null) {
        if (inputCase_ == 9
            && input_
                != com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 9) {
          inputDtmfBuilder_.mergeFrom(value);
        }
        inputDtmfBuilder_.setMessage(value);
      }
      inputCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public Builder clearInputDtmf() {
      if (inputDtmfBuilder_ == null) {
        if (inputCase_ == 9) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 9) {
          inputCase_ = 0;
          input_ = null;
        }
        inputDtmfBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder getInputDtmfBuilder() {
      return getInputDtmfFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder
        getInputDtmfOrBuilder() {
      if ((inputCase_ == 9) && (inputDtmfBuilder_ != null)) {
        return inputDtmfBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 9) {
          return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * This input is ignored if the previous response indicated that DTMF input
     * is not accepted.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents input_dtmf = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>
        getInputDtmfFieldBuilder() {
      if (inputDtmfBuilder_ == null) {
        if (!(inputCase_ == 9)) {
          input_ = com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
        }
        inputDtmfBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 9;
      onChanged();
      ;
      return inputDtmfBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.QueryParameters queryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryParameters,
            com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>
        queryParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     *
     * @return Whether the queryParams field is set.
     */
    public boolean hasQueryParams() {
      return queryParamsBuilder_ != null || queryParams_ != null;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     *
     * @return The queryParams.
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParameters getQueryParams() {
      if (queryParamsBuilder_ == null) {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
            : queryParams_;
      } else {
        return queryParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder setQueryParams(com.google.cloud.dialogflow.v2beta1.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryParams_ = value;
        onChanged();
      } else {
        queryParamsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder setQueryParams(
        com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder builderForValue) {
      if (queryParamsBuilder_ == null) {
        queryParams_ = builderForValue.build();
        onChanged();
      } else {
        queryParamsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder mergeQueryParams(com.google.cloud.dialogflow.v2beta1.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (queryParams_ != null) {
          queryParams_ =
              com.google.cloud.dialogflow.v2beta1.QueryParameters.newBuilder(queryParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryParams_ = value;
        }
        onChanged();
      } else {
        queryParamsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public Builder clearQueryParams() {
      if (queryParamsBuilder_ == null) {
        queryParams_ = null;
        onChanged();
      } else {
        queryParams_ = null;
        queryParamsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder getQueryParamsBuilder() {

      onChanged();
      return getQueryParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder getQueryParamsOrBuilder() {
      if (queryParamsBuilder_ != null) {
        return queryParamsBuilder_.getMessageOrBuilder();
      } else {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
            : queryParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryParameters,
            com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>
        getQueryParamsFieldBuilder() {
      if (queryParamsBuilder_ == null) {
        queryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryParameters,
                com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>(
                getQueryParams(), getParentForChildren(), isClean());
        queryParams_ = null;
      }
      return queryParamsBuilder_;
    }

    private boolean enableExtendedStreaming_;
    /**
     *
     *
     * <pre>
     * Enable full bidirectional streaming. You can keep streaming the audio until
     * timeout, and there's no need to half close the stream to get the response.
     * Restrictions:
     * - Timeout: 3 mins.
     * - Audio Encoding: only supports [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
     * and [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
     * - Lifecycle: conversation should be in `Assist Stage`, go to
     *   [Conversation.CreateConversation][] for more information.
     * InvalidArgument Error will be returned if the one of restriction checks
     * failed.
     * You can find more details in
     * https://cloud.google.com/dialogflow/priv/docs/agent-assist/analyze-content-streaming
     * </pre>
     *
     * <code>bool enable_extended_streaming = 11;</code>
     *
     * @return The enableExtendedStreaming.
     */
    @java.lang.Override
    public boolean getEnableExtendedStreaming() {
      return enableExtendedStreaming_;
    }
    /**
     *
     *
     * <pre>
     * Enable full bidirectional streaming. You can keep streaming the audio until
     * timeout, and there's no need to half close the stream to get the response.
     * Restrictions:
     * - Timeout: 3 mins.
     * - Audio Encoding: only supports [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
     * and [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
     * - Lifecycle: conversation should be in `Assist Stage`, go to
     *   [Conversation.CreateConversation][] for more information.
     * InvalidArgument Error will be returned if the one of restriction checks
     * failed.
     * You can find more details in
     * https://cloud.google.com/dialogflow/priv/docs/agent-assist/analyze-content-streaming
     * </pre>
     *
     * <code>bool enable_extended_streaming = 11;</code>
     *
     * @param value The enableExtendedStreaming to set.
     * @return This builder for chaining.
     */
    public Builder setEnableExtendedStreaming(boolean value) {

      enableExtendedStreaming_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enable full bidirectional streaming. You can keep streaming the audio until
     * timeout, and there's no need to half close the stream to get the response.
     * Restrictions:
     * - Timeout: 3 mins.
     * - Audio Encoding: only supports [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
     * and [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
     * - Lifecycle: conversation should be in `Assist Stage`, go to
     *   [Conversation.CreateConversation][] for more information.
     * InvalidArgument Error will be returned if the one of restriction checks
     * failed.
     * You can find more details in
     * https://cloud.google.com/dialogflow/priv/docs/agent-assist/analyze-content-streaming
     * </pre>
     *
     * <code>bool enable_extended_streaming = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableExtendedStreaming() {

      enableExtendedStreaming_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest)
  private static final com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest();
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingAnalyzeContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamingAnalyzeContentRequest>() {
        @java.lang.Override
        public StreamingAnalyzeContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StreamingAnalyzeContentRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<StreamingAnalyzeContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingAnalyzeContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
