/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/conversation_profile.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Defines the hand off to a live agent, typically on which external agent
 * service provider to connect to a conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig}
 */
public final class HumanAgentHandoffConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig)
    HumanAgentHandoffConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HumanAgentHandoffConfig.newBuilder() to construct.
  private HumanAgentHandoffConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HumanAgentHandoffConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HumanAgentHandoffConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private HumanAgentHandoffConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.Builder
                  subBuilder = null;
              if (agentServiceCase_ == 1) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
                            agentService_)
                        .toBuilder();
              }
              agentService_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
                        agentService_);
                agentService_ = subBuilder.buildPartial();
              }
              agentServiceCase_ = 1;
              break;
            }
          case 18:
            {
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                      .Builder
                  subBuilder = null;
              if (agentServiceCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                                .SalesforceLiveAgentConfig)
                            agentService_)
                        .toBuilder();
              }
              agentService_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                          .SalesforceLiveAgentConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                            .SalesforceLiveAgentConfig)
                        agentService_);
                agentService_ = subBuilder.buildPartial();
              }
              agentServiceCase_ = 2;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.class,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.Builder.class);
  }

  public interface LivePersonConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Account number of the LivePerson account to connect. This is
     * the account number you input at the login page.
     * </pre>
     *
     * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The accountNumber.
     */
    java.lang.String getAccountNumber();
    /**
     *
     *
     * <pre>
     * Required. Account number of the LivePerson account to connect. This is
     * the account number you input at the login page.
     * </pre>
     *
     * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for accountNumber.
     */
    com.google.protobuf.ByteString getAccountNumberBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration specific to LivePerson (https://www.liveperson.com).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig}
   */
  public static final class LivePersonConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
      LivePersonConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LivePersonConfig.newBuilder() to construct.
    private LivePersonConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LivePersonConfig() {
      accountNumber_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LivePersonConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private LivePersonConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                accountNumber_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_LivePersonConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_LivePersonConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.Builder
                  .class);
    }

    public static final int ACCOUNT_NUMBER_FIELD_NUMBER = 1;
    private volatile java.lang.Object accountNumber_;
    /**
     *
     *
     * <pre>
     * Required. Account number of the LivePerson account to connect. This is
     * the account number you input at the login page.
     * </pre>
     *
     * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The accountNumber.
     */
    @java.lang.Override
    public java.lang.String getAccountNumber() {
      java.lang.Object ref = accountNumber_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accountNumber_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Account number of the LivePerson account to connect. This is
     * the account number you input at the login page.
     * </pre>
     *
     * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for accountNumber.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAccountNumberBytes() {
      java.lang.Object ref = accountNumber_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accountNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getAccountNumberBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, accountNumber_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getAccountNumberBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, accountNumber_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig other =
          (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig) obj;

      if (!getAccountNumber().equals(other.getAccountNumber())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCOUNT_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getAccountNumber().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration specific to LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_LivePersonConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_LivePersonConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        accountNumber_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_LivePersonConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig result =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig(this);
        result.accountNumber_ = accountNumber_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
                .getDefaultInstance()) return this;
        if (!other.getAccountNumber().isEmpty()) {
          accountNumber_ = other.accountNumber_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object accountNumber_ = "";
      /**
       *
       *
       * <pre>
       * Required. Account number of the LivePerson account to connect. This is
       * the account number you input at the login page.
       * </pre>
       *
       * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The accountNumber.
       */
      public java.lang.String getAccountNumber() {
        java.lang.Object ref = accountNumber_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          accountNumber_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Account number of the LivePerson account to connect. This is
       * the account number you input at the login page.
       * </pre>
       *
       * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for accountNumber.
       */
      public com.google.protobuf.ByteString getAccountNumberBytes() {
        java.lang.Object ref = accountNumber_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          accountNumber_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Account number of the LivePerson account to connect. This is
       * the account number you input at the login page.
       * </pre>
       *
       * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The accountNumber to set.
       * @return This builder for chaining.
       */
      public Builder setAccountNumber(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        accountNumber_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Account number of the LivePerson account to connect. This is
       * the account number you input at the login page.
       * </pre>
       *
       * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccountNumber() {

        accountNumber_ = getDefaultInstance().getAccountNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Account number of the LivePerson account to connect. This is
       * the account number you input at the login page.
       * </pre>
       *
       * <code>string account_number = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for accountNumber to set.
       * @return This builder for chaining.
       */
      public Builder setAccountNumberBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        accountNumber_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .LivePersonConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LivePersonConfig> PARSER =
        new com.google.protobuf.AbstractParser<LivePersonConfig>() {
          @java.lang.Override
          public LivePersonConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new LivePersonConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<LivePersonConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LivePersonConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SalesforceLiveAgentConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The organization ID of the Salesforce account.
     * </pre>
     *
     * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The organizationId.
     */
    java.lang.String getOrganizationId();
    /**
     *
     *
     * <pre>
     * Required. The organization ID of the Salesforce account.
     * </pre>
     *
     * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for organizationId.
     */
    com.google.protobuf.ByteString getOrganizationIdBytes();

    /**
     *
     *
     * <pre>
     * Required. Live Agent deployment ID.
     * </pre>
     *
     * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deploymentId.
     */
    java.lang.String getDeploymentId();
    /**
     *
     *
     * <pre>
     * Required. Live Agent deployment ID.
     * </pre>
     *
     * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deploymentId.
     */
    com.google.protobuf.ByteString getDeploymentIdBytes();

    /**
     *
     *
     * <pre>
     * Required. Live Agent chat button ID.
     * </pre>
     *
     * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The buttonId.
     */
    java.lang.String getButtonId();
    /**
     *
     *
     * <pre>
     * Required. Live Agent chat button ID.
     * </pre>
     *
     * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for buttonId.
     */
    com.google.protobuf.ByteString getButtonIdBytes();

    /**
     *
     *
     * <pre>
     * Required. Domain of the Live Agent endpoint for this agent. You can find
     * the endpoint URL in the `Live Agent settings` page. For example if URL
     * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
     * you should fill in d.la4-c2-phx.salesforceliveagent.com.
     * </pre>
     *
     * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endpointDomain.
     */
    java.lang.String getEndpointDomain();
    /**
     *
     *
     * <pre>
     * Required. Domain of the Live Agent endpoint for this agent. You can find
     * the endpoint URL in the `Live Agent settings` page. For example if URL
     * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
     * you should fill in d.la4-c2-phx.salesforceliveagent.com.
     * </pre>
     *
     * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for endpointDomain.
     */
    com.google.protobuf.ByteString getEndpointDomainBytes();
  }
  /**
   *
   *
   * <pre>
   * Configuration specific to Salesforce Live Agent.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig}
   */
  public static final class SalesforceLiveAgentConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
      SalesforceLiveAgentConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SalesforceLiveAgentConfig.newBuilder() to construct.
    private SalesforceLiveAgentConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SalesforceLiveAgentConfig() {
      organizationId_ = "";
      deploymentId_ = "";
      buttonId_ = "";
      endpointDomain_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SalesforceLiveAgentConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SalesforceLiveAgentConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                organizationId_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                deploymentId_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                buttonId_ = s;
                break;
              }
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();

                endpointDomain_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_SalesforceLiveAgentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_SalesforceLiveAgentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                  .class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                  .Builder.class);
    }

    public static final int ORGANIZATION_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object organizationId_;
    /**
     *
     *
     * <pre>
     * Required. The organization ID of the Salesforce account.
     * </pre>
     *
     * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The organizationId.
     */
    @java.lang.Override
    public java.lang.String getOrganizationId() {
      java.lang.Object ref = organizationId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        organizationId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The organization ID of the Salesforce account.
     * </pre>
     *
     * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for organizationId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOrganizationIdBytes() {
      java.lang.Object ref = organizationId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        organizationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEPLOYMENT_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object deploymentId_;
    /**
     *
     *
     * <pre>
     * Required. Live Agent deployment ID.
     * </pre>
     *
     * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deploymentId.
     */
    @java.lang.Override
    public java.lang.String getDeploymentId() {
      java.lang.Object ref = deploymentId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deploymentId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Live Agent deployment ID.
     * </pre>
     *
     * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deploymentId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDeploymentIdBytes() {
      java.lang.Object ref = deploymentId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deploymentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BUTTON_ID_FIELD_NUMBER = 3;
    private volatile java.lang.Object buttonId_;
    /**
     *
     *
     * <pre>
     * Required. Live Agent chat button ID.
     * </pre>
     *
     * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The buttonId.
     */
    @java.lang.Override
    public java.lang.String getButtonId() {
      java.lang.Object ref = buttonId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buttonId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Live Agent chat button ID.
     * </pre>
     *
     * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for buttonId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getButtonIdBytes() {
      java.lang.Object ref = buttonId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buttonId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENDPOINT_DOMAIN_FIELD_NUMBER = 4;
    private volatile java.lang.Object endpointDomain_;
    /**
     *
     *
     * <pre>
     * Required. Domain of the Live Agent endpoint for this agent. You can find
     * the endpoint URL in the `Live Agent settings` page. For example if URL
     * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
     * you should fill in d.la4-c2-phx.salesforceliveagent.com.
     * </pre>
     *
     * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endpointDomain.
     */
    @java.lang.Override
    public java.lang.String getEndpointDomain() {
      java.lang.Object ref = endpointDomain_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpointDomain_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Domain of the Live Agent endpoint for this agent. You can find
     * the endpoint URL in the `Live Agent settings` page. For example if URL
     * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
     * you should fill in d.la4-c2-phx.salesforceliveagent.com.
     * </pre>
     *
     * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for endpointDomain.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointDomainBytes() {
      java.lang.Object ref = endpointDomain_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpointDomain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!getOrganizationIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, organizationId_);
      }
      if (!getDeploymentIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deploymentId_);
      }
      if (!getButtonIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, buttonId_);
      }
      if (!getEndpointDomainBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, endpointDomain_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getOrganizationIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, organizationId_);
      }
      if (!getDeploymentIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deploymentId_);
      }
      if (!getButtonIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, buttonId_);
      }
      if (!getEndpointDomainBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, endpointDomain_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig other =
          (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
              obj;

      if (!getOrganizationId().equals(other.getOrganizationId())) return false;
      if (!getDeploymentId().equals(other.getDeploymentId())) return false;
      if (!getButtonId().equals(other.getButtonId())) return false;
      if (!getEndpointDomain().equals(other.getEndpointDomain())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ORGANIZATION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getOrganizationId().hashCode();
      hash = (37 * hash) + DEPLOYMENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDeploymentId().hashCode();
      hash = (37 * hash) + BUTTON_ID_FIELD_NUMBER;
      hash = (53 * hash) + getButtonId().hashCode();
      hash = (37 * hash) + ENDPOINT_DOMAIN_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointDomain().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration specific to Salesforce Live Agent.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_SalesforceLiveAgentConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_SalesforceLiveAgentConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .SalesforceLiveAgentConfig.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .SalesforceLiveAgentConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        organizationId_ = "";

        deploymentId_ = "";

        buttonId_ = "";

        endpointDomain_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_SalesforceLiveAgentConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            result =
                new com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .SalesforceLiveAgentConfig(this);
        result.organizationId_ = organizationId_;
        result.deploymentId_ = deploymentId_;
        result.buttonId_ = buttonId_;
        result.endpointDomain_ = endpointDomain_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                      .SalesforceLiveAgentConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
              other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                .getDefaultInstance()) return this;
        if (!other.getOrganizationId().isEmpty()) {
          organizationId_ = other.organizationId_;
          onChanged();
        }
        if (!other.getDeploymentId().isEmpty()) {
          deploymentId_ = other.deploymentId_;
          onChanged();
        }
        if (!other.getButtonId().isEmpty()) {
          buttonId_ = other.buttonId_;
          onChanged();
        }
        if (!other.getEndpointDomain().isEmpty()) {
          endpointDomain_ = other.endpointDomain_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                      .SalesforceLiveAgentConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object organizationId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The organization ID of the Salesforce account.
       * </pre>
       *
       * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The organizationId.
       */
      public java.lang.String getOrganizationId() {
        java.lang.Object ref = organizationId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          organizationId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The organization ID of the Salesforce account.
       * </pre>
       *
       * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for organizationId.
       */
      public com.google.protobuf.ByteString getOrganizationIdBytes() {
        java.lang.Object ref = organizationId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          organizationId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The organization ID of the Salesforce account.
       * </pre>
       *
       * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The organizationId to set.
       * @return This builder for chaining.
       */
      public Builder setOrganizationId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        organizationId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The organization ID of the Salesforce account.
       * </pre>
       *
       * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOrganizationId() {

        organizationId_ = getDefaultInstance().getOrganizationId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The organization ID of the Salesforce account.
       * </pre>
       *
       * <code>string organization_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for organizationId to set.
       * @return This builder for chaining.
       */
      public Builder setOrganizationIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        organizationId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object deploymentId_ = "";
      /**
       *
       *
       * <pre>
       * Required. Live Agent deployment ID.
       * </pre>
       *
       * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The deploymentId.
       */
      public java.lang.String getDeploymentId() {
        java.lang.Object ref = deploymentId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          deploymentId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent deployment ID.
       * </pre>
       *
       * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for deploymentId.
       */
      public com.google.protobuf.ByteString getDeploymentIdBytes() {
        java.lang.Object ref = deploymentId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          deploymentId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent deployment ID.
       * </pre>
       *
       * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The deploymentId to set.
       * @return This builder for chaining.
       */
      public Builder setDeploymentId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        deploymentId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent deployment ID.
       * </pre>
       *
       * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeploymentId() {

        deploymentId_ = getDefaultInstance().getDeploymentId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent deployment ID.
       * </pre>
       *
       * <code>string deployment_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for deploymentId to set.
       * @return This builder for chaining.
       */
      public Builder setDeploymentIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        deploymentId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object buttonId_ = "";
      /**
       *
       *
       * <pre>
       * Required. Live Agent chat button ID.
       * </pre>
       *
       * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The buttonId.
       */
      public java.lang.String getButtonId() {
        java.lang.Object ref = buttonId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          buttonId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent chat button ID.
       * </pre>
       *
       * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for buttonId.
       */
      public com.google.protobuf.ByteString getButtonIdBytes() {
        java.lang.Object ref = buttonId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          buttonId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent chat button ID.
       * </pre>
       *
       * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The buttonId to set.
       * @return This builder for chaining.
       */
      public Builder setButtonId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        buttonId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent chat button ID.
       * </pre>
       *
       * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearButtonId() {

        buttonId_ = getDefaultInstance().getButtonId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Live Agent chat button ID.
       * </pre>
       *
       * <code>string button_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for buttonId to set.
       * @return This builder for chaining.
       */
      public Builder setButtonIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        buttonId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object endpointDomain_ = "";
      /**
       *
       *
       * <pre>
       * Required. Domain of the Live Agent endpoint for this agent. You can find
       * the endpoint URL in the `Live Agent settings` page. For example if URL
       * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
       * you should fill in d.la4-c2-phx.salesforceliveagent.com.
       * </pre>
       *
       * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The endpointDomain.
       */
      public java.lang.String getEndpointDomain() {
        java.lang.Object ref = endpointDomain_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpointDomain_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Domain of the Live Agent endpoint for this agent. You can find
       * the endpoint URL in the `Live Agent settings` page. For example if URL
       * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
       * you should fill in d.la4-c2-phx.salesforceliveagent.com.
       * </pre>
       *
       * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for endpointDomain.
       */
      public com.google.protobuf.ByteString getEndpointDomainBytes() {
        java.lang.Object ref = endpointDomain_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpointDomain_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Domain of the Live Agent endpoint for this agent. You can find
       * the endpoint URL in the `Live Agent settings` page. For example if URL
       * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
       * you should fill in d.la4-c2-phx.salesforceliveagent.com.
       * </pre>
       *
       * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The endpointDomain to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointDomain(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        endpointDomain_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Domain of the Live Agent endpoint for this agent. You can find
       * the endpoint URL in the `Live Agent settings` page. For example if URL
       * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
       * you should fill in d.la4-c2-phx.salesforceliveagent.com.
       * </pre>
       *
       * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpointDomain() {

        endpointDomain_ = getDefaultInstance().getEndpointDomain();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Domain of the Live Agent endpoint for this agent. You can find
       * the endpoint URL in the `Live Agent settings` page. For example if URL
       * has the form https://d.la4-c2-phx.salesforceliveagent.com/...,
       * you should fill in d.la4-c2-phx.salesforceliveagent.com.
       * </pre>
       *
       * <code>string endpoint_domain = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for endpointDomain to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointDomainBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        endpointDomain_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
              .SalesforceLiveAgentConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SalesforceLiveAgentConfig> PARSER =
        new com.google.protobuf.AbstractParser<SalesforceLiveAgentConfig>() {
          @java.lang.Override
          public SalesforceLiveAgentConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SalesforceLiveAgentConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SalesforceLiveAgentConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SalesforceLiveAgentConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int agentServiceCase_ = 0;
  private java.lang.Object agentService_;

  public enum AgentServiceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LIVE_PERSON_CONFIG(1),
    SALESFORCE_LIVE_AGENT_CONFIG(2),
    AGENTSERVICE_NOT_SET(0);
    private final int value;

    private AgentServiceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AgentServiceCase valueOf(int value) {
      return forNumber(value);
    }

    public static AgentServiceCase forNumber(int value) {
      switch (value) {
        case 1:
          return LIVE_PERSON_CONFIG;
        case 2:
          return SALESFORCE_LIVE_AGENT_CONFIG;
        case 0:
          return AGENTSERVICE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AgentServiceCase getAgentServiceCase() {
    return AgentServiceCase.forNumber(agentServiceCase_);
  }

  public static final int LIVE_PERSON_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Uses LivePerson (https://www.liveperson.com).
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
   * </code>
   *
   * @return Whether the livePersonConfig field is set.
   */
  @java.lang.Override
  public boolean hasLivePersonConfig() {
    return agentServiceCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Uses LivePerson (https://www.liveperson.com).
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
   * </code>
   *
   * @return The livePersonConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
      getLivePersonConfig() {
    if (agentServiceCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
          agentService_;
    }
    return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Uses LivePerson (https://www.liveperson.com).
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfigOrBuilder
      getLivePersonConfigOrBuilder() {
    if (agentServiceCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
          agentService_;
    }
    return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        .getDefaultInstance();
  }

  public static final int SALESFORCE_LIVE_AGENT_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Uses Salesforce Live Agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
   * </code>
   *
   * @return Whether the salesforceLiveAgentConfig field is set.
   */
  @java.lang.Override
  public boolean hasSalesforceLiveAgentConfig() {
    return agentServiceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Uses Salesforce Live Agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
   * </code>
   *
   * @return The salesforceLiveAgentConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
      getSalesforceLiveAgentConfig() {
    if (agentServiceCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
          agentService_;
    }
    return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Uses Salesforce Live Agent.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
          .SalesforceLiveAgentConfigOrBuilder
      getSalesforceLiveAgentConfigOrBuilder() {
    if (agentServiceCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
          agentService_;
    }
    return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (agentServiceCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
              agentService_);
    }
    if (agentServiceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig)
              agentService_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (agentServiceCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
                  agentService_);
    }
    if (agentServiceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                      .SalesforceLiveAgentConfig)
                  agentService_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig other =
        (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig) obj;

    if (!getAgentServiceCase().equals(other.getAgentServiceCase())) return false;
    switch (agentServiceCase_) {
      case 1:
        if (!getLivePersonConfig().equals(other.getLivePersonConfig())) return false;
        break;
      case 2:
        if (!getSalesforceLiveAgentConfig().equals(other.getSalesforceLiveAgentConfig()))
          return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (agentServiceCase_) {
      case 1:
        hash = (37 * hash) + LIVE_PERSON_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getLivePersonConfig().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SALESFORCE_LIVE_AGENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSalesforceLiveAgentConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the hand off to a live agent, typically on which external agent
   * service provider to connect to a conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig)
      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      agentServiceCase_ = 0;
      agentService_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentHandoffConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig build() {
      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig buildPartial() {
      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig result =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig(this);
      if (agentServiceCase_ == 1) {
        if (livePersonConfigBuilder_ == null) {
          result.agentService_ = agentService_;
        } else {
          result.agentService_ = livePersonConfigBuilder_.build();
        }
      }
      if (agentServiceCase_ == 2) {
        if (salesforceLiveAgentConfigBuilder_ == null) {
          result.agentService_ = agentService_;
        } else {
          result.agentService_ = salesforceLiveAgentConfigBuilder_.build();
        }
      }
      result.agentServiceCase_ = agentServiceCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig other) {
      if (other == com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.getDefaultInstance())
        return this;
      switch (other.getAgentServiceCase()) {
        case LIVE_PERSON_CONFIG:
          {
            mergeLivePersonConfig(other.getLivePersonConfig());
            break;
          }
        case SALESFORCE_LIVE_AGENT_CONFIG:
          {
            mergeSalesforceLiveAgentConfig(other.getSalesforceLiveAgentConfig());
            break;
          }
        case AGENTSERVICE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int agentServiceCase_ = 0;
    private java.lang.Object agentService_;

    public AgentServiceCase getAgentServiceCase() {
      return AgentServiceCase.forNumber(agentServiceCase_);
    }

    public Builder clearAgentService() {
      agentServiceCase_ = 0;
      agentService_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfigOrBuilder>
        livePersonConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     *
     * @return Whether the livePersonConfig field is set.
     */
    @java.lang.Override
    public boolean hasLivePersonConfig() {
      return agentServiceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     *
     * @return The livePersonConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
        getLivePersonConfig() {
      if (livePersonConfigBuilder_ == null) {
        if (agentServiceCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
              agentService_;
        }
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
            .getDefaultInstance();
      } else {
        if (agentServiceCase_ == 1) {
          return livePersonConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     */
    public Builder setLivePersonConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig value) {
      if (livePersonConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        agentService_ = value;
        onChanged();
      } else {
        livePersonConfigBuilder_.setMessage(value);
      }
      agentServiceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     */
    public Builder setLivePersonConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.Builder
            builderForValue) {
      if (livePersonConfigBuilder_ == null) {
        agentService_ = builderForValue.build();
        onChanged();
      } else {
        livePersonConfigBuilder_.setMessage(builderForValue.build());
      }
      agentServiceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     */
    public Builder mergeLivePersonConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig value) {
      if (livePersonConfigBuilder_ == null) {
        if (agentServiceCase_ == 1
            && agentService_
                != com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
                    .getDefaultInstance()) {
          agentService_ =
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
                  .newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
                          agentService_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          agentService_ = value;
        }
        onChanged();
      } else {
        if (agentServiceCase_ == 1) {
          livePersonConfigBuilder_.mergeFrom(value);
        }
        livePersonConfigBuilder_.setMessage(value);
      }
      agentServiceCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     */
    public Builder clearLivePersonConfig() {
      if (livePersonConfigBuilder_ == null) {
        if (agentServiceCase_ == 1) {
          agentServiceCase_ = 0;
          agentService_ = null;
          onChanged();
        }
      } else {
        if (agentServiceCase_ == 1) {
          agentServiceCase_ = 0;
          agentService_ = null;
        }
        livePersonConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.Builder
        getLivePersonConfigBuilder() {
      return getLivePersonConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfigOrBuilder
        getLivePersonConfigOrBuilder() {
      if ((agentServiceCase_ == 1) && (livePersonConfigBuilder_ != null)) {
        return livePersonConfigBuilder_.getMessageOrBuilder();
      } else {
        if (agentServiceCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
              agentService_;
        }
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uses LivePerson (https://www.liveperson.com).
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig live_person_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfigOrBuilder>
        getLivePersonConfigFieldBuilder() {
      if (livePersonConfigBuilder_ == null) {
        if (!(agentServiceCase_ == 1)) {
          agentService_ =
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
                  .getDefaultInstance();
        }
        livePersonConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig,
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig
                    .Builder,
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .LivePersonConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.LivePersonConfig)
                    agentService_,
                getParentForChildren(),
                isClean());
        agentService_ = null;
      }
      agentServiceCase_ = 1;
      onChanged();
      ;
      return livePersonConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                .Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                .SalesforceLiveAgentConfigOrBuilder>
        salesforceLiveAgentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     *
     * @return Whether the salesforceLiveAgentConfig field is set.
     */
    @java.lang.Override
    public boolean hasSalesforceLiveAgentConfig() {
      return agentServiceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     *
     * @return The salesforceLiveAgentConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
        getSalesforceLiveAgentConfig() {
      if (salesforceLiveAgentConfigBuilder_ == null) {
        if (agentServiceCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                  .SalesforceLiveAgentConfig)
              agentService_;
        }
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            .getDefaultInstance();
      } else {
        if (agentServiceCase_ == 2) {
          return salesforceLiveAgentConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     */
    public Builder setSalesforceLiveAgentConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            value) {
      if (salesforceLiveAgentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        agentService_ = value;
        onChanged();
      } else {
        salesforceLiveAgentConfigBuilder_.setMessage(value);
      }
      agentServiceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     */
    public Builder setSalesforceLiveAgentConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                .Builder
            builderForValue) {
      if (salesforceLiveAgentConfigBuilder_ == null) {
        agentService_ = builderForValue.build();
        onChanged();
      } else {
        salesforceLiveAgentConfigBuilder_.setMessage(builderForValue.build());
      }
      agentServiceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     */
    public Builder mergeSalesforceLiveAgentConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            value) {
      if (salesforceLiveAgentConfigBuilder_ == null) {
        if (agentServiceCase_ == 2
            && agentService_
                != com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .SalesforceLiveAgentConfig.getDefaultInstance()) {
          agentService_ =
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                  .newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                              .SalesforceLiveAgentConfig)
                          agentService_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          agentService_ = value;
        }
        onChanged();
      } else {
        if (agentServiceCase_ == 2) {
          salesforceLiveAgentConfigBuilder_.mergeFrom(value);
        }
        salesforceLiveAgentConfigBuilder_.setMessage(value);
      }
      agentServiceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     */
    public Builder clearSalesforceLiveAgentConfig() {
      if (salesforceLiveAgentConfigBuilder_ == null) {
        if (agentServiceCase_ == 2) {
          agentServiceCase_ = 0;
          agentService_ = null;
          onChanged();
        }
      } else {
        if (agentServiceCase_ == 2) {
          agentServiceCase_ = 0;
          agentService_ = null;
        }
        salesforceLiveAgentConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            .Builder
        getSalesforceLiveAgentConfigBuilder() {
      return getSalesforceLiveAgentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
            .SalesforceLiveAgentConfigOrBuilder
        getSalesforceLiveAgentConfigOrBuilder() {
      if ((agentServiceCase_ == 2) && (salesforceLiveAgentConfigBuilder_ != null)) {
        return salesforceLiveAgentConfigBuilder_.getMessageOrBuilder();
      } else {
        if (agentServiceCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                  .SalesforceLiveAgentConfig)
              agentService_;
        }
        return com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Uses Salesforce Live Agent.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig salesforce_live_agent_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                .Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                .SalesforceLiveAgentConfigOrBuilder>
        getSalesforceLiveAgentConfigFieldBuilder() {
      if (salesforceLiveAgentConfigBuilder_ == null) {
        if (!(agentServiceCase_ == 2)) {
          agentService_ =
              com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig.SalesforceLiveAgentConfig
                  .getDefaultInstance();
        }
        salesforceLiveAgentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .SalesforceLiveAgentConfig,
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .SalesforceLiveAgentConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                    .SalesforceLiveAgentConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig
                        .SalesforceLiveAgentConfig)
                    agentService_,
                getParentForChildren(),
                isClean());
        agentService_ = null;
      }
      agentServiceCase_ = 2;
      onChanged();
      ;
      return salesforceLiveAgentConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig)
  private static final com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig();
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HumanAgentHandoffConfig> PARSER =
      new com.google.protobuf.AbstractParser<HumanAgentHandoffConfig>() {
        @java.lang.Override
        public HumanAgentHandoffConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new HumanAgentHandoffConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<HumanAgentHandoffConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HumanAgentHandoffConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentHandoffConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
