/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VersionName
implements ResourceName {
    private static final PathTemplate PROJECT_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/versions/{version}");
    private static final PathTemplate PROJECT_LOCATION_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/versions/{version}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String version;
    private final String location;

    @Deprecated
    protected VersionName() {
        this.project = null;
        this.version = null;
        this.location = null;
    }

    private VersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
        this.location = null;
        this.pathTemplate = PROJECT_VERSION;
    }

    private VersionName(ProjectLocationVersionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
        this.pathTemplate = PROJECT_LOCATION_VERSION;
    }

    public String getProject() {
        return this.project;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectVersionBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationVersionBuilder newProjectLocationVersionBuilder() {
        return new ProjectLocationVersionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VersionName of(String project, String version) {
        return VersionName.newBuilder().setProject(project).setVersion(version).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static VersionName ofProjectVersionName(String project, String version) {
        return VersionName.newBuilder().setProject(project).setVersion(version).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static VersionName ofProjectLocationVersionName(String project, String location, String version) {
        return VersionName.newProjectLocationVersionBuilder().setProject(project).setLocation(location).setVersion(version).build();
    }

    public static String format(String project, String version) {
        return VersionName.newBuilder().setProject(project).setVersion(version).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectVersionName(String project, String version) {
        return VersionName.newBuilder().setProject(project).setVersion(version).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationVersionName(String project, String location, String version) {
        return VersionName.newProjectLocationVersionBuilder().setProject(project).setLocation(location).setVersion(version).build().toString();
    }

    public static VersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_VERSION.matches(formattedString)) {
            Map matchMap = PROJECT_VERSION.match(formattedString);
            return VersionName.ofProjectVersionName((String)matchMap.get("project"), (String)matchMap.get("version"));
        }
        if (PROJECT_LOCATION_VERSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_VERSION.match(formattedString);
            return VersionName.ofProjectLocationVersionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("version"));
        }
        throw new ValidationException("VersionName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<VersionName> parseList(List<String> formattedStrings) {
        ArrayList<VersionName> list = new ArrayList<VersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_VERSION.matches(formattedString) || PROJECT_LOCATION_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VersionName versionName = this;
            synchronized (versionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VersionName that = (VersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.version, that.version) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.version);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationVersionBuilder {
        private String project;
        private String location;
        private String version;

        protected ProjectLocationVersionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVersion() {
            return this.version;
        }

        public ProjectLocationVersionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationVersionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationVersionBuilder setVersion(String version) {
            this.version = version;
            return this;
        }

        public VersionName build() {
            return new VersionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String version;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        private Builder(VersionName versionName) {
            Preconditions.checkArgument((boolean)Objects.equals(versionName.pathTemplate, PROJECT_VERSION), (Object)"toBuilder is only supported when VersionName has the pattern of projects/{project}/agent/versions/{version}");
            this.project = versionName.project;
            this.version = versionName.version;
        }

        public VersionName build() {
            return new VersionName(this);
        }
    }
}

