/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/session.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The message returned from the DetectIntent method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.DetectIntentResponse}
 */
public final class DetectIntentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.DetectIntentResponse)
    DetectIntentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DetectIntentResponse.newBuilder() to construct.
  private DetectIntentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DetectIntentResponse() {
    responseId_ = "";
    alternativeQueryResults_ = java.util.Collections.emptyList();
    outputAudio_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DetectIntentResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private DetectIntentResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              responseId_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.dialogflow.v2beta1.QueryResult.Builder subBuilder = null;
              if (queryResult_ != null) {
                subBuilder = queryResult_.toBuilder();
              }
              queryResult_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.QueryResult.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryResult_);
                queryResult_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (webhookStatus_ != null) {
                subBuilder = webhookStatus_.toBuilder();
              }
              webhookStatus_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(webhookStatus_);
                webhookStatus_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              outputAudio_ = input.readBytes();
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                alternativeQueryResults_ =
                    new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.QueryResult>();
                mutable_bitField0_ |= 0x00000001;
              }
              alternativeQueryResults_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.QueryResult.parser(), extensionRegistry));
              break;
            }
          case 50:
            {
              com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder subBuilder = null;
              if (outputAudioConfig_ != null) {
                subBuilder = outputAudioConfig_.toBuilder();
              }
              outputAudioConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputAudioConfig_);
                outputAudioConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        alternativeQueryResults_ = java.util.Collections.unmodifiableList(alternativeQueryResults_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_DetectIntentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_DetectIntentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.class,
            com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.Builder.class);
  }

  public static final int RESPONSE_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object responseId_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the response. It can be used to
   * locate a response in the training example set or for reporting issues.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The responseId.
   */
  @java.lang.Override
  public java.lang.String getResponseId() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the response. It can be used to
   * locate a response in the training example set or for reporting issues.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The bytes for responseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResponseIdBytes() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      responseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_RESULT_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.v2beta1.QueryResult queryResult_;
  /**
   *
   *
   * <pre>
   * The selected results of the conversational query or event processing.
   * See `alternative_query_results` for additional potential results.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
   *
   * @return Whether the queryResult field is set.
   */
  @java.lang.Override
  public boolean hasQueryResult() {
    return queryResult_ != null;
  }
  /**
   *
   *
   * <pre>
   * The selected results of the conversational query or event processing.
   * See `alternative_query_results` for additional potential results.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
   *
   * @return The queryResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResult getQueryResult() {
    return queryResult_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()
        : queryResult_;
  }
  /**
   *
   *
   * <pre>
   * The selected results of the conversational query or event processing.
   * See `alternative_query_results` for additional potential results.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder getQueryResultOrBuilder() {
    return getQueryResult();
  }

  public static final int ALTERNATIVE_QUERY_RESULTS_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult> alternativeQueryResults_;
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult>
      getAlternativeQueryResultsList() {
    return alternativeQueryResults_;
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
      getAlternativeQueryResultsOrBuilderList() {
    return alternativeQueryResults_;
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
   * </code>
   */
  @java.lang.Override
  public int getAlternativeQueryResultsCount() {
    return alternativeQueryResults_.size();
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResult getAlternativeQueryResults(int index) {
    return alternativeQueryResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder
      getAlternativeQueryResultsOrBuilder(int index) {
    return alternativeQueryResults_.get(index);
  }

  public static final int WEBHOOK_STATUS_FIELD_NUMBER = 3;
  private com.google.rpc.Status webhookStatus_;
  /**
   *
   *
   * <pre>
   * Specifies the status of the webhook request.
   * </pre>
   *
   * <code>.google.rpc.Status webhook_status = 3;</code>
   *
   * @return Whether the webhookStatus field is set.
   */
  @java.lang.Override
  public boolean hasWebhookStatus() {
    return webhookStatus_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies the status of the webhook request.
   * </pre>
   *
   * <code>.google.rpc.Status webhook_status = 3;</code>
   *
   * @return The webhookStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getWebhookStatus() {
    return webhookStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : webhookStatus_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the status of the webhook request.
   * </pre>
   *
   * <code>.google.rpc.Status webhook_status = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getWebhookStatusOrBuilder() {
    return getWebhookStatus();
  }

  public static final int OUTPUT_AUDIO_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString outputAudio_;
  /**
   *
   *
   * <pre>
   * The audio data bytes encoded as specified in the request.
   * Note: The output audio is generated based on the values of default platform
   * text responses found in the `query_result.fulfillment_messages` field. If
   * multiple default text responses exist, they will be concatenated when
   * generating audio. If no default platform text responses exist, the
   * generated audio content will be empty.
   * In some scenarios, multiple output audio fields may be present in the
   * response structure. In these cases, only the top-most-level audio output
   * has content.
   * </pre>
   *
   * <code>bytes output_audio = 4;</code>
   *
   * @return The outputAudio.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputAudio() {
    return outputAudio_;
  }

  public static final int OUTPUT_AUDIO_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig outputAudioConfig_;
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
   *
   * @return Whether the outputAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputAudioConfig() {
    return outputAudioConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
   *
   * @return The outputAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getOutputAudioConfig() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
      getOutputAudioConfigOrBuilder() {
    return getOutputAudioConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getResponseIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, responseId_);
    }
    if (queryResult_ != null) {
      output.writeMessage(2, getQueryResult());
    }
    if (webhookStatus_ != null) {
      output.writeMessage(3, getWebhookStatus());
    }
    if (!outputAudio_.isEmpty()) {
      output.writeBytes(4, outputAudio_);
    }
    for (int i = 0; i < alternativeQueryResults_.size(); i++) {
      output.writeMessage(5, alternativeQueryResults_.get(i));
    }
    if (outputAudioConfig_ != null) {
      output.writeMessage(6, getOutputAudioConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getResponseIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, responseId_);
    }
    if (queryResult_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryResult());
    }
    if (webhookStatus_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getWebhookStatus());
    }
    if (!outputAudio_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, outputAudio_);
    }
    for (int i = 0; i < alternativeQueryResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, alternativeQueryResults_.get(i));
    }
    if (outputAudioConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutputAudioConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.DetectIntentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.DetectIntentResponse other =
        (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) obj;

    if (!getResponseId().equals(other.getResponseId())) return false;
    if (hasQueryResult() != other.hasQueryResult()) return false;
    if (hasQueryResult()) {
      if (!getQueryResult().equals(other.getQueryResult())) return false;
    }
    if (!getAlternativeQueryResultsList().equals(other.getAlternativeQueryResultsList()))
      return false;
    if (hasWebhookStatus() != other.hasWebhookStatus()) return false;
    if (hasWebhookStatus()) {
      if (!getWebhookStatus().equals(other.getWebhookStatus())) return false;
    }
    if (!getOutputAudio().equals(other.getOutputAudio())) return false;
    if (hasOutputAudioConfig() != other.hasOutputAudioConfig()) return false;
    if (hasOutputAudioConfig()) {
      if (!getOutputAudioConfig().equals(other.getOutputAudioConfig())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESPONSE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResponseId().hashCode();
    if (hasQueryResult()) {
      hash = (37 * hash) + QUERY_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryResult().hashCode();
    }
    if (getAlternativeQueryResultsCount() > 0) {
      hash = (37 * hash) + ALTERNATIVE_QUERY_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getAlternativeQueryResultsList().hashCode();
    }
    if (hasWebhookStatus()) {
      hash = (37 * hash) + WEBHOOK_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookStatus().hashCode();
    }
    hash = (37 * hash) + OUTPUT_AUDIO_FIELD_NUMBER;
    hash = (53 * hash) + getOutputAudio().hashCode();
    if (hasOutputAudioConfig()) {
      hash = (37 * hash) + OUTPUT_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputAudioConfig().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.DetectIntentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The message returned from the DetectIntent method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.DetectIntentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.DetectIntentResponse)
      com.google.cloud.dialogflow.v2beta1.DetectIntentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_DetectIntentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_DetectIntentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.class,
              com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAlternativeQueryResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      responseId_ = "";

      if (queryResultBuilder_ == null) {
        queryResult_ = null;
      } else {
        queryResult_ = null;
        queryResultBuilder_ = null;
      }
      if (alternativeQueryResultsBuilder_ == null) {
        alternativeQueryResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        alternativeQueryResultsBuilder_.clear();
      }
      if (webhookStatusBuilder_ == null) {
        webhookStatus_ = null;
      } else {
        webhookStatus_ = null;
        webhookStatusBuilder_ = null;
      }
      outputAudio_ = com.google.protobuf.ByteString.EMPTY;

      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfig_ = null;
      } else {
        outputAudioConfig_ = null;
        outputAudioConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_DetectIntentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DetectIntentResponse getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DetectIntentResponse build() {
      com.google.cloud.dialogflow.v2beta1.DetectIntentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.DetectIntentResponse buildPartial() {
      com.google.cloud.dialogflow.v2beta1.DetectIntentResponse result =
          new com.google.cloud.dialogflow.v2beta1.DetectIntentResponse(this);
      int from_bitField0_ = bitField0_;
      result.responseId_ = responseId_;
      if (queryResultBuilder_ == null) {
        result.queryResult_ = queryResult_;
      } else {
        result.queryResult_ = queryResultBuilder_.build();
      }
      if (alternativeQueryResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          alternativeQueryResults_ =
              java.util.Collections.unmodifiableList(alternativeQueryResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.alternativeQueryResults_ = alternativeQueryResults_;
      } else {
        result.alternativeQueryResults_ = alternativeQueryResultsBuilder_.build();
      }
      if (webhookStatusBuilder_ == null) {
        result.webhookStatus_ = webhookStatus_;
      } else {
        result.webhookStatus_ = webhookStatusBuilder_.build();
      }
      result.outputAudio_ = outputAudio_;
      if (outputAudioConfigBuilder_ == null) {
        result.outputAudioConfig_ = outputAudioConfig_;
      } else {
        result.outputAudioConfig_ = outputAudioConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.DetectIntentResponse other) {
      if (other == com.google.cloud.dialogflow.v2beta1.DetectIntentResponse.getDefaultInstance())
        return this;
      if (!other.getResponseId().isEmpty()) {
        responseId_ = other.responseId_;
        onChanged();
      }
      if (other.hasQueryResult()) {
        mergeQueryResult(other.getQueryResult());
      }
      if (alternativeQueryResultsBuilder_ == null) {
        if (!other.alternativeQueryResults_.isEmpty()) {
          if (alternativeQueryResults_.isEmpty()) {
            alternativeQueryResults_ = other.alternativeQueryResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAlternativeQueryResultsIsMutable();
            alternativeQueryResults_.addAll(other.alternativeQueryResults_);
          }
          onChanged();
        }
      } else {
        if (!other.alternativeQueryResults_.isEmpty()) {
          if (alternativeQueryResultsBuilder_.isEmpty()) {
            alternativeQueryResultsBuilder_.dispose();
            alternativeQueryResultsBuilder_ = null;
            alternativeQueryResults_ = other.alternativeQueryResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            alternativeQueryResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAlternativeQueryResultsFieldBuilder()
                    : null;
          } else {
            alternativeQueryResultsBuilder_.addAllMessages(other.alternativeQueryResults_);
          }
        }
      }
      if (other.hasWebhookStatus()) {
        mergeWebhookStatus(other.getWebhookStatus());
      }
      if (other.getOutputAudio() != com.google.protobuf.ByteString.EMPTY) {
        setOutputAudio(other.getOutputAudio());
      }
      if (other.hasOutputAudioConfig()) {
        mergeOutputAudioConfig(other.getOutputAudioConfig());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.DetectIntentResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2beta1.DetectIntentResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object responseId_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The responseId.
     */
    public java.lang.String getResponseId() {
      java.lang.Object ref = responseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The bytes for responseId.
     */
    public com.google.protobuf.ByteString getResponseIdBytes() {
      java.lang.Object ref = responseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      responseId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseId() {

      responseId_ = getDefaultInstance().getResponseId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The bytes for responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      responseId_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.QueryResult queryResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        queryResultBuilder_;
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     *
     * @return Whether the queryResult field is set.
     */
    public boolean hasQueryResult() {
      return queryResultBuilder_ != null || queryResult_ != null;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     *
     * @return The queryResult.
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult getQueryResult() {
      if (queryResultBuilder_ == null) {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()
            : queryResult_;
      } else {
        return queryResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     */
    public Builder setQueryResult(com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryResult_ = value;
        onChanged();
      } else {
        queryResultBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     */
    public Builder setQueryResult(
        com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (queryResultBuilder_ == null) {
        queryResult_ = builderForValue.build();
        onChanged();
      } else {
        queryResultBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     */
    public Builder mergeQueryResult(com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (queryResult_ != null) {
          queryResult_ =
              com.google.cloud.dialogflow.v2beta1.QueryResult.newBuilder(queryResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryResult_ = value;
        }
        onChanged();
      } else {
        queryResultBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     */
    public Builder clearQueryResult() {
      if (queryResultBuilder_ == null) {
        queryResult_ = null;
        onChanged();
      } else {
        queryResult_ = null;
        queryResultBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder getQueryResultBuilder() {

      onChanged();
      return getQueryResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder getQueryResultOrBuilder() {
      if (queryResultBuilder_ != null) {
        return queryResultBuilder_.getMessageOrBuilder();
      } else {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()
            : queryResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        getQueryResultFieldBuilder() {
      if (queryResultBuilder_ == null) {
        queryResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryResult,
                com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>(
                getQueryResult(), getParentForChildren(), isClean());
        queryResult_ = null;
      }
      return queryResultBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult>
        alternativeQueryResults_ = java.util.Collections.emptyList();

    private void ensureAlternativeQueryResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        alternativeQueryResults_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.QueryResult>(
                alternativeQueryResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        alternativeQueryResultsBuilder_;

    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult>
        getAlternativeQueryResultsList() {
      if (alternativeQueryResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(alternativeQueryResults_);
      } else {
        return alternativeQueryResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public int getAlternativeQueryResultsCount() {
      if (alternativeQueryResultsBuilder_ == null) {
        return alternativeQueryResults_.size();
      } else {
        return alternativeQueryResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult getAlternativeQueryResults(int index) {
      if (alternativeQueryResultsBuilder_ == null) {
        return alternativeQueryResults_.get(index);
      } else {
        return alternativeQueryResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder setAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (alternativeQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.set(index, value);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder setAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (alternativeQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(value);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (alternativeQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(index, value);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(builderForValue.build());
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder addAllAlternativeQueryResults(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.QueryResult> values) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, alternativeQueryResults_);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder clearAlternativeQueryResults() {
      if (alternativeQueryResultsBuilder_ == null) {
        alternativeQueryResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public Builder removeAlternativeQueryResults(int index) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.remove(index);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder
        getAlternativeQueryResultsBuilder(int index) {
      return getAlternativeQueryResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder
        getAlternativeQueryResultsOrBuilder(int index) {
      if (alternativeQueryResultsBuilder_ == null) {
        return alternativeQueryResults_.get(index);
      } else {
        return alternativeQueryResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        getAlternativeQueryResultsOrBuilderList() {
      if (alternativeQueryResultsBuilder_ != null) {
        return alternativeQueryResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(alternativeQueryResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder
        addAlternativeQueryResultsBuilder() {
      return getAlternativeQueryResultsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder
        addAlternativeQueryResultsBuilder(int index) {
      return getAlternativeQueryResultsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult.Builder>
        getAlternativeQueryResultsBuilderList() {
      return getAlternativeQueryResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        getAlternativeQueryResultsFieldBuilder() {
      if (alternativeQueryResultsBuilder_ == null) {
        alternativeQueryResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryResult,
                com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>(
                alternativeQueryResults_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        alternativeQueryResults_ = null;
      }
      return alternativeQueryResultsBuilder_;
    }

    private com.google.rpc.Status webhookStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        webhookStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     *
     * @return Whether the webhookStatus field is set.
     */
    public boolean hasWebhookStatus() {
      return webhookStatusBuilder_ != null || webhookStatus_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     *
     * @return The webhookStatus.
     */
    public com.google.rpc.Status getWebhookStatus() {
      if (webhookStatusBuilder_ == null) {
        return webhookStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : webhookStatus_;
      } else {
        return webhookStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     */
    public Builder setWebhookStatus(com.google.rpc.Status value) {
      if (webhookStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhookStatus_ = value;
        onChanged();
      } else {
        webhookStatusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     */
    public Builder setWebhookStatus(com.google.rpc.Status.Builder builderForValue) {
      if (webhookStatusBuilder_ == null) {
        webhookStatus_ = builderForValue.build();
        onChanged();
      } else {
        webhookStatusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     */
    public Builder mergeWebhookStatus(com.google.rpc.Status value) {
      if (webhookStatusBuilder_ == null) {
        if (webhookStatus_ != null) {
          webhookStatus_ =
              com.google.rpc.Status.newBuilder(webhookStatus_).mergeFrom(value).buildPartial();
        } else {
          webhookStatus_ = value;
        }
        onChanged();
      } else {
        webhookStatusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     */
    public Builder clearWebhookStatus() {
      if (webhookStatusBuilder_ == null) {
        webhookStatus_ = null;
        onChanged();
      } else {
        webhookStatus_ = null;
        webhookStatusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     */
    public com.google.rpc.Status.Builder getWebhookStatusBuilder() {

      onChanged();
      return getWebhookStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     */
    public com.google.rpc.StatusOrBuilder getWebhookStatusOrBuilder() {
      if (webhookStatusBuilder_ != null) {
        return webhookStatusBuilder_.getMessageOrBuilder();
      } else {
        return webhookStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : webhookStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getWebhookStatusFieldBuilder() {
      if (webhookStatusBuilder_ == null) {
        webhookStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getWebhookStatus(), getParentForChildren(), isClean());
        webhookStatus_ = null;
      }
      return webhookStatusBuilder_;
    }

    private com.google.protobuf.ByteString outputAudio_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the `query_result.fulfillment_messages` field. If
     * multiple default text responses exist, they will be concatenated when
     * generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 4;</code>
     *
     * @return The outputAudio.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOutputAudio() {
      return outputAudio_;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the `query_result.fulfillment_messages` field. If
     * multiple default text responses exist, they will be concatenated when
     * generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 4;</code>
     *
     * @param value The outputAudio to set.
     * @return This builder for chaining.
     */
    public Builder setOutputAudio(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      outputAudio_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the `query_result.fulfillment_messages` field. If
     * multiple default text responses exist, they will be concatenated when
     * generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputAudio() {

      outputAudio_ = getDefaultInstance().getOutputAudio();
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig outputAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        outputAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     *
     * @return Whether the outputAudioConfig field is set.
     */
    public boolean hasOutputAudioConfig() {
      return outputAudioConfigBuilder_ != null || outputAudioConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     *
     * @return The outputAudioConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getOutputAudioConfig() {
      if (outputAudioConfigBuilder_ == null) {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      } else {
        return outputAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder setOutputAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputAudioConfig_ = value;
        onChanged();
      } else {
        outputAudioConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder setOutputAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder builderForValue) {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfig_ = builderForValue.build();
        onChanged();
      } else {
        outputAudioConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder mergeOutputAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (outputAudioConfig_ != null) {
          outputAudioConfig_ =
              com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.newBuilder(outputAudioConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputAudioConfig_ = value;
        }
        onChanged();
      } else {
        outputAudioConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder clearOutputAudioConfig() {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfig_ = null;
        onChanged();
      } else {
        outputAudioConfig_ = null;
        outputAudioConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder
        getOutputAudioConfigBuilder() {

      onChanged();
      return getOutputAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
        getOutputAudioConfigOrBuilder() {
      if (outputAudioConfigBuilder_ != null) {
        return outputAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        getOutputAudioConfigFieldBuilder() {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>(
                getOutputAudioConfig(), getParentForChildren(), isClean());
        outputAudioConfig_ = null;
      }
      return outputAudioConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.DetectIntentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.DetectIntentResponse)
  private static final com.google.cloud.dialogflow.v2beta1.DetectIntentResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.DetectIntentResponse();
  }

  public static com.google.cloud.dialogflow.v2beta1.DetectIntentResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DetectIntentResponse> PARSER =
      new com.google.protobuf.AbstractParser<DetectIntentResponse>() {
        @java.lang.Override
        public DetectIntentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new DetectIntentResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<DetectIntentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DetectIntentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.DetectIntentResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
