/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/data_store_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request for
 * [DataStoreService.CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.CreateDataStoreRequest}
 */
public final class CreateDataStoreRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.CreateDataStoreRequest)
    CreateDataStoreRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateDataStoreRequest.newBuilder() to construct.
  private CreateDataStoreRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateDataStoreRequest() {
    parent_ = "";
    dataStoreId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateDataStoreRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.DataStoreServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CreateDataStoreRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.DataStoreServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CreateDataStoreRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.CreateDataStoreRequest.class,
            com.google.cloud.discoveryengine.v1.CreateDataStoreRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource name, such as
   * `projects/{project}/locations/{location}/collections/{collection}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource name, such as
   * `projects/{project}/locations/{location}/collections/{collection}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_STORE_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1.DataStore dataStore_;
  /**
   *
   *
   * <pre>
   * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
   * create.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the dataStore field is set.
   */
  @java.lang.Override
  public boolean hasDataStore() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
   * create.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The dataStore.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.DataStore getDataStore() {
    return dataStore_ == null
        ? com.google.cloud.discoveryengine.v1.DataStore.getDefaultInstance()
        : dataStore_;
  }
  /**
   *
   *
   * <pre>
   * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
   * create.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.DataStoreOrBuilder getDataStoreOrBuilder() {
    return dataStore_ == null
        ? com.google.cloud.discoveryengine.v1.DataStore.getDefaultInstance()
        : dataStore_;
  }

  public static final int DATA_STORE_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataStoreId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID to use for the
   * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
   * the final component of the
   * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
   *
   * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The dataStoreId.
   */
  @java.lang.Override
  public java.lang.String getDataStoreId() {
    java.lang.Object ref = dataStoreId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataStoreId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID to use for the
   * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
   * the final component of the
   * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
   *
   * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
   * standard with a length limit of 63 characters. Otherwise, an
   * INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for dataStoreId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDataStoreIdBytes() {
    java.lang.Object ref = dataStoreId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataStoreId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_ADVANCED_SITE_SEARCH_FIELD_NUMBER = 4;
  private boolean createAdvancedSiteSearch_ = false;
  /**
   *
   *
   * <pre>
   * A boolean flag indicating whether user want to directly create an advanced
   * data store for site search.
   * If the data store is not configured as site
   * search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
   * be ignored.
   * </pre>
   *
   * <code>bool create_advanced_site_search = 4;</code>
   *
   * @return The createAdvancedSiteSearch.
   */
  @java.lang.Override
  public boolean getCreateAdvancedSiteSearch() {
    return createAdvancedSiteSearch_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getDataStore());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStoreId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dataStoreId_);
    }
    if (createAdvancedSiteSearch_ != false) {
      output.writeBool(4, createAdvancedSiteSearch_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDataStore());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStoreId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, dataStoreId_);
    }
    if (createAdvancedSiteSearch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, createAdvancedSiteSearch_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.CreateDataStoreRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.CreateDataStoreRequest other =
        (com.google.cloud.discoveryengine.v1.CreateDataStoreRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasDataStore() != other.hasDataStore()) return false;
    if (hasDataStore()) {
      if (!getDataStore().equals(other.getDataStore())) return false;
    }
    if (!getDataStoreId().equals(other.getDataStoreId())) return false;
    if (getCreateAdvancedSiteSearch() != other.getCreateAdvancedSiteSearch()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasDataStore()) {
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
    }
    hash = (37 * hash) + DATA_STORE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDataStoreId().hashCode();
    hash = (37 * hash) + CREATE_ADVANCED_SITE_SEARCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCreateAdvancedSiteSearch());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.CreateDataStoreRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for
   * [DataStoreService.CreateDataStore][google.cloud.discoveryengine.v1.DataStoreService.CreateDataStore]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.CreateDataStoreRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.CreateDataStoreRequest)
      com.google.cloud.discoveryengine.v1.CreateDataStoreRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.DataStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CreateDataStoreRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.DataStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CreateDataStoreRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.CreateDataStoreRequest.class,
              com.google.cloud.discoveryengine.v1.CreateDataStoreRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.CreateDataStoreRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDataStoreFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      dataStore_ = null;
      if (dataStoreBuilder_ != null) {
        dataStoreBuilder_.dispose();
        dataStoreBuilder_ = null;
      }
      dataStoreId_ = "";
      createAdvancedSiteSearch_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.DataStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CreateDataStoreRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CreateDataStoreRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.CreateDataStoreRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CreateDataStoreRequest build() {
      com.google.cloud.discoveryengine.v1.CreateDataStoreRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CreateDataStoreRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.CreateDataStoreRequest result =
          new com.google.cloud.discoveryengine.v1.CreateDataStoreRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.CreateDataStoreRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataStore_ = dataStoreBuilder_ == null ? dataStore_ : dataStoreBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataStoreId_ = dataStoreId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createAdvancedSiteSearch_ = createAdvancedSiteSearch_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.CreateDataStoreRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.CreateDataStoreRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.CreateDataStoreRequest other) {
      if (other == com.google.cloud.discoveryengine.v1.CreateDataStoreRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDataStore()) {
        mergeDataStore(other.getDataStore());
      }
      if (!other.getDataStoreId().isEmpty()) {
        dataStoreId_ = other.dataStoreId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getCreateAdvancedSiteSearch() != false) {
        setCreateAdvancedSiteSearch(other.getCreateAdvancedSiteSearch());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDataStoreFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                dataStoreId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                createAdvancedSiteSearch_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name, such as
     * `projects/{project}/locations/{location}/collections/{collection}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.DataStore dataStore_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.DataStore,
            com.google.cloud.discoveryengine.v1.DataStore.Builder,
            com.google.cloud.discoveryengine.v1.DataStoreOrBuilder>
        dataStoreBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the dataStore field is set.
     */
    public boolean hasDataStore() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dataStore.
     */
    public com.google.cloud.discoveryengine.v1.DataStore getDataStore() {
      if (dataStoreBuilder_ == null) {
        return dataStore_ == null
            ? com.google.cloud.discoveryengine.v1.DataStore.getDefaultInstance()
            : dataStore_;
      } else {
        return dataStoreBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDataStore(com.google.cloud.discoveryengine.v1.DataStore value) {
      if (dataStoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
      } else {
        dataStoreBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDataStore(
        com.google.cloud.discoveryengine.v1.DataStore.Builder builderForValue) {
      if (dataStoreBuilder_ == null) {
        dataStore_ = builderForValue.build();
      } else {
        dataStoreBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDataStore(com.google.cloud.discoveryengine.v1.DataStore value) {
      if (dataStoreBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dataStore_ != null
            && dataStore_ != com.google.cloud.discoveryengine.v1.DataStore.getDefaultInstance()) {
          getDataStoreBuilder().mergeFrom(value);
        } else {
          dataStore_ = value;
        }
      } else {
        dataStoreBuilder_.mergeFrom(value);
      }
      if (dataStore_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDataStore() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dataStore_ = null;
      if (dataStoreBuilder_ != null) {
        dataStoreBuilder_.dispose();
        dataStoreBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.DataStore.Builder getDataStoreBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDataStoreFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.DataStoreOrBuilder getDataStoreOrBuilder() {
      if (dataStoreBuilder_ != null) {
        return dataStoreBuilder_.getMessageOrBuilder();
      } else {
        return dataStore_ == null
            ? com.google.cloud.discoveryengine.v1.DataStore.getDefaultInstance()
            : dataStore_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [DataStore][google.cloud.discoveryengine.v1.DataStore] to
     * create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.DataStore data_store = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.DataStore,
            com.google.cloud.discoveryengine.v1.DataStore.Builder,
            com.google.cloud.discoveryengine.v1.DataStoreOrBuilder>
        getDataStoreFieldBuilder() {
      if (dataStoreBuilder_ == null) {
        dataStoreBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.DataStore,
                com.google.cloud.discoveryengine.v1.DataStore.Builder,
                com.google.cloud.discoveryengine.v1.DataStoreOrBuilder>(
                getDataStore(), getParentForChildren(), isClean());
        dataStore_ = null;
      }
      return dataStoreBuilder_;
    }

    private java.lang.Object dataStoreId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     *
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The dataStoreId.
     */
    public java.lang.String getDataStoreId() {
      java.lang.Object ref = dataStoreId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStoreId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     *
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for dataStoreId.
     */
    public com.google.protobuf.ByteString getDataStoreIdBytes() {
      java.lang.Object ref = dataStoreId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStoreId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     *
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The dataStoreId to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataStoreId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     *
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStoreId() {
      dataStoreId_ = getDefaultInstance().getDataStoreId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID to use for the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore], which will become
     * the final component of the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]'s resource name.
     *
     * This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
     * standard with a length limit of 63 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>string data_store_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for dataStoreId to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataStoreId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean createAdvancedSiteSearch_;
    /**
     *
     *
     * <pre>
     * A boolean flag indicating whether user want to directly create an advanced
     * data store for site search.
     * If the data store is not configured as site
     * search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
     * be ignored.
     * </pre>
     *
     * <code>bool create_advanced_site_search = 4;</code>
     *
     * @return The createAdvancedSiteSearch.
     */
    @java.lang.Override
    public boolean getCreateAdvancedSiteSearch() {
      return createAdvancedSiteSearch_;
    }
    /**
     *
     *
     * <pre>
     * A boolean flag indicating whether user want to directly create an advanced
     * data store for site search.
     * If the data store is not configured as site
     * search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
     * be ignored.
     * </pre>
     *
     * <code>bool create_advanced_site_search = 4;</code>
     *
     * @param value The createAdvancedSiteSearch to set.
     * @return This builder for chaining.
     */
    public Builder setCreateAdvancedSiteSearch(boolean value) {

      createAdvancedSiteSearch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A boolean flag indicating whether user want to directly create an advanced
     * data store for site search.
     * If the data store is not configured as site
     * search (GENERIC vertical and PUBLIC_WEBSITE content_config), this flag will
     * be ignored.
     * </pre>
     *
     * <code>bool create_advanced_site_search = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreateAdvancedSiteSearch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createAdvancedSiteSearch_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.CreateDataStoreRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.CreateDataStoreRequest)
  private static final com.google.cloud.discoveryengine.v1.CreateDataStoreRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.CreateDataStoreRequest();
  }

  public static com.google.cloud.discoveryengine.v1.CreateDataStoreRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateDataStoreRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateDataStoreRequest>() {
        @java.lang.Override
        public CreateDataStoreRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateDataStoreRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateDataStoreRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CreateDataStoreRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
