/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1.SiteSearchEngineService.RecrawlUris]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.RecrawlUrisRequest}
 */
public final class RecrawlUrisRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.RecrawlUrisRequest)
    RecrawlUrisRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecrawlUrisRequest.newBuilder() to construct.
  private RecrawlUrisRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecrawlUrisRequest() {
    siteSearchEngine_ = "";
    uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecrawlUrisRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.RecrawlUrisRequest.class,
            com.google.cloud.discoveryengine.v1.RecrawlUrisRequest.Builder.class);
  }

  public static final int SITE_SEARCH_ENGINE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object siteSearchEngine_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the
   * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
   * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
   * </pre>
   *
   * <code>
   * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The siteSearchEngine.
   */
  @java.lang.Override
  public java.lang.String getSiteSearchEngine() {
    java.lang.Object ref = siteSearchEngine_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      siteSearchEngine_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of the
   * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
   * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
   * </pre>
   *
   * <code>
   * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for siteSearchEngine.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSiteSearchEngineBytes() {
    java.lang.Object ref = siteSearchEngine_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      siteSearchEngine_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URIS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList uris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
   * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
   * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
   * `site_search_engine`.
   * </pre>
   *
   * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the uris.
   */
  public com.google.protobuf.ProtocolStringList getUrisList() {
    return uris_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
   * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
   * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
   * `site_search_engine`.
   * </pre>
   *
   * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of uris.
   */
  public int getUrisCount() {
    return uris_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
   * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
   * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
   * `site_search_engine`.
   * </pre>
   *
   * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The uris at the given index.
   */
  public java.lang.String getUris(int index) {
    return uris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
   * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
   * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
   * `site_search_engine`.
   * </pre>
   *
   * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the uris at the given index.
   */
  public com.google.protobuf.ByteString getUrisBytes(int index) {
    return uris_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(siteSearchEngine_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, siteSearchEngine_);
    }
    for (int i = 0; i < uris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uris_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(siteSearchEngine_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, siteSearchEngine_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < uris_.size(); i++) {
        dataSize += computeStringSizeNoTag(uris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUrisList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.RecrawlUrisRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.RecrawlUrisRequest other =
        (com.google.cloud.discoveryengine.v1.RecrawlUrisRequest) obj;

    if (!getSiteSearchEngine().equals(other.getSiteSearchEngine())) return false;
    if (!getUrisList().equals(other.getUrisList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SITE_SEARCH_ENGINE_FIELD_NUMBER;
    hash = (53 * hash) + getSiteSearchEngine().hashCode();
    if (getUrisCount() > 0) {
      hash = (37 * hash) + URIS_FIELD_NUMBER;
      hash = (53 * hash) + getUrisList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.RecrawlUrisRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1.SiteSearchEngineService.RecrawlUris]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.RecrawlUrisRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.RecrawlUrisRequest)
      com.google.cloud.discoveryengine.v1.RecrawlUrisRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.RecrawlUrisRequest.class,
              com.google.cloud.discoveryengine.v1.RecrawlUrisRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.RecrawlUrisRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      siteSearchEngine_ = "";
      uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.RecrawlUrisRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisRequest build() {
      com.google.cloud.discoveryengine.v1.RecrawlUrisRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.RecrawlUrisRequest result =
          new com.google.cloud.discoveryengine.v1.RecrawlUrisRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.RecrawlUrisRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.siteSearchEngine_ = siteSearchEngine_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        uris_.makeImmutable();
        result.uris_ = uris_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.RecrawlUrisRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.RecrawlUrisRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.RecrawlUrisRequest other) {
      if (other == com.google.cloud.discoveryengine.v1.RecrawlUrisRequest.getDefaultInstance())
        return this;
      if (!other.getSiteSearchEngine().isEmpty()) {
        siteSearchEngine_ = other.siteSearchEngine_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.uris_.isEmpty()) {
        if (uris_.isEmpty()) {
          uris_ = other.uris_;
          bitField0_ |= 0x00000002;
        } else {
          ensureUrisIsMutable();
          uris_.addAll(other.uris_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                siteSearchEngine_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUrisIsMutable();
                uris_.add(s);
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object siteSearchEngine_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The siteSearchEngine.
     */
    public java.lang.String getSiteSearchEngine() {
      java.lang.Object ref = siteSearchEngine_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        siteSearchEngine_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for siteSearchEngine.
     */
    public com.google.protobuf.ByteString getSiteSearchEngineBytes() {
      java.lang.Object ref = siteSearchEngine_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        siteSearchEngine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The siteSearchEngine to set.
     * @return This builder for chaining.
     */
    public Builder setSiteSearchEngine(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      siteSearchEngine_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSiteSearchEngine() {
      siteSearchEngine_ = getDefaultInstance().getSiteSearchEngine();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string site_search_engine = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for siteSearchEngine to set.
     * @return This builder for chaining.
     */
    public Builder setSiteSearchEngineBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      siteSearchEngine_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList uris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUrisIsMutable() {
      if (!uris_.isModifiable()) {
        uris_ = new com.google.protobuf.LazyStringArrayList(uris_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the uris.
     */
    public com.google.protobuf.ProtocolStringList getUrisList() {
      uris_.makeImmutable();
      return uris_;
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of uris.
     */
    public int getUrisCount() {
      return uris_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The uris at the given index.
     */
    public java.lang.String getUris(int index) {
      return uris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the uris at the given index.
     */
    public com.google.protobuf.ByteString getUrisBytes(int index) {
      return uris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The uris to set.
     * @return This builder for chaining.
     */
    public Builder setUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisIsMutable();
      uris_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The uris to add.
     * @return This builder for chaining.
     */
    public Builder addUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUrisIsMutable();
      uris_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The uris to add.
     * @return This builder for chaining.
     */
    public Builder addAllUris(java.lang.Iterable<java.lang.String> values) {
      ensureUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uris_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUris() {
      uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of URIs to crawl. At most 10K URIs are supported, otherwise
     * an INVALID_ARGUMENT error is thrown. Each URI should match at least one
     * [TargetSite][google.cloud.discoveryengine.v1.TargetSite] in
     * `site_search_engine`.
     * </pre>
     *
     * <code>repeated string uris = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the uris to add.
     * @return This builder for chaining.
     */
    public Builder addUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUrisIsMutable();
      uris_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.RecrawlUrisRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.RecrawlUrisRequest)
  private static final com.google.cloud.discoveryengine.v1.RecrawlUrisRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.RecrawlUrisRequest();
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecrawlUrisRequest> PARSER =
      new com.google.protobuf.AbstractParser<RecrawlUrisRequest>() {
        @java.lang.Override
        public RecrawlUrisRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecrawlUrisRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecrawlUrisRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.RecrawlUrisRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
