/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/search_service.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse}
 */
public final class SearchResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse)
    SearchResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchResponse.newBuilder() to construct.
  private SearchResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchResponse() {
    results_ = java.util.Collections.emptyList();
    facets_ = java.util.Collections.emptyList();
    attributionToken_ = "";
    redirectUri_ = "";
    nextPageToken_ = "";
    correctedQuery_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.SearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1_SearchResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.SearchServiceProto
        .internal_static_google_cloud_discoveryengine_v1_SearchResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.SearchResponse.class,
            com.google.cloud.discoveryengine.v1.SearchResponse.Builder.class);
  }

  public interface SearchResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.SearchResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    java.lang.String getId();
    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString getIdBytes();

    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as retrievable are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return Whether the document field is set.
     */
    boolean hasDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as retrievable are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return The document.
     */
    com.google.cloud.discoveryengine.v1.Document getDocument();
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as retrievable are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     */
    com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Represents the search results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.SearchResult}
   */
  public static final class SearchResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.SearchResult)
      SearchResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SearchResult.newBuilder() to construct.
    private SearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SearchResult() {
      id_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SearchResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_SearchResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_SearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.class,
              com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
     * searched [Document][google.cloud.discoveryengine.v1.Document].
     * </pre>
     *
     * <code>string id = 1;</code>
     *
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DOCUMENT_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1.Document document_;
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as retrievable are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as retrievable are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Document getDocument() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
          : document_;
    }
    /**
     *
     *
     * <pre>
     * The document data snippet in the search response. Only fields that are
     * marked as retrievable are populated.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder() {
      return document_ == null
          ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
          : document_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getDocument());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocument());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult other =
          (com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult) obj;

      if (!getId().equals(other.getId())) return false;
      if (hasDocument() != other.hasDocument()) return false;
      if (hasDocument()) {
        if (!getDocument().equals(other.getDocument())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasDocument()) {
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents the search results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.SearchResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.SearchResult)
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_SearchResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_SearchResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDocumentFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        id_ = "";
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_SearchResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult build() {
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult buildPartial() {
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult result =
            new com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.id_ = id_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult other) {
        if (other
            == com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.getDefaultInstance())
          return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasDocument()) {
          mergeDocument(other.getDocument());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  id_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        id_ = getDefaultInstance().getId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Document.id][google.cloud.discoveryengine.v1.Document.id] of the
       * searched [Document][google.cloud.discoveryengine.v1.Document].
       * </pre>
       *
       * <code>string id = 1;</code>
       *
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        id_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1.Document document_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Document,
              com.google.cloud.discoveryengine.v1.Document.Builder,
              com.google.cloud.discoveryengine.v1.DocumentOrBuilder>
          documentBuilder_;
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       *
       * @return Whether the document field is set.
       */
      public boolean hasDocument() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       *
       * @return The document.
       */
      public com.google.cloud.discoveryengine.v1.Document getDocument() {
        if (documentBuilder_ == null) {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
              : document_;
        } else {
          return documentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder setDocument(com.google.cloud.discoveryengine.v1.Document value) {
        if (documentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
        } else {
          documentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder setDocument(
          com.google.cloud.discoveryengine.v1.Document.Builder builderForValue) {
        if (documentBuilder_ == null) {
          document_ = builderForValue.build();
        } else {
          documentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder mergeDocument(com.google.cloud.discoveryengine.v1.Document value) {
        if (documentBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && document_ != null
              && document_ != com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()) {
            getDocumentBuilder().mergeFrom(value);
          } else {
            document_ = value;
          }
        } else {
          documentBuilder_.mergeFrom(value);
        }
        if (document_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public Builder clearDocument() {
        bitField0_ = (bitField0_ & ~0x00000002);
        document_ = null;
        if (documentBuilder_ != null) {
          documentBuilder_.dispose();
          documentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.Document.Builder getDocumentBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDocumentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder() {
        if (documentBuilder_ != null) {
          return documentBuilder_.getMessageOrBuilder();
        } else {
          return document_ == null
              ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
              : document_;
        }
      }
      /**
       *
       *
       * <pre>
       * The document data snippet in the search response. Only fields that are
       * marked as retrievable are populated.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Document document = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Document,
              com.google.cloud.discoveryengine.v1.Document.Builder,
              com.google.cloud.discoveryengine.v1.DocumentOrBuilder>
          getDocumentFieldBuilder() {
        if (documentBuilder_ == null) {
          documentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Document,
                  com.google.cloud.discoveryengine.v1.Document.Builder,
                  com.google.cloud.discoveryengine.v1.DocumentOrBuilder>(
                  getDocument(), getParentForChildren(), isClean());
          document_ = null;
        }
        return documentBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.SearchResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.SearchResult)
    private static final com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult();
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SearchResult> PARSER =
        new com.google.protobuf.AbstractParser<SearchResult>() {
          @java.lang.Override
          public SearchResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SearchResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SearchResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FacetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Facet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colors" or "price". It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colors" or "price". It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue>
        getValuesList();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue getValues(int index);
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    int getValuesCount();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder>
        getValuesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder getValuesOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Whether the facet is dynamically generated.
     * </pre>
     *
     * <code>bool dynamic_facet = 3;</code>
     *
     * @return The dynamicFacet.
     */
    boolean getDynamicFacet();
  }
  /**
   *
   *
   * <pre>
   * A facet result.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Facet}
   */
  public static final class Facet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Facet)
      FacetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Facet.newBuilder() to construct.
    private Facet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Facet() {
      key_ = "";
      values_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Facet();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.class,
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder.class);
    }

    public interface FacetValueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      java.lang.String getValue();
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      com.google.protobuf.ByteString getValueBytes();

      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
       *
       * @return Whether the interval field is set.
       */
      boolean hasInterval();
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
       *
       * @return The interval.
       */
      com.google.cloud.discoveryengine.v1.Interval getInterval();
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
       */
      com.google.cloud.discoveryengine.v1.IntervalOrBuilder getIntervalOrBuilder();

      /**
       *
       *
       * <pre>
       * Number of items that have this facet value.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      long getCount();

      com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.FacetValueCase
          getFacetValueCase();
    }
    /**
     *
     *
     * <pre>
     * A facet value which contains value names and their count.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue}
     */
    public static final class FacetValue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue)
        FacetValueOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FacetValue.newBuilder() to construct.
      private FacetValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FacetValue() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FacetValue();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_FacetValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_FacetValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder.class);
      }

      private int facetValueCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object facetValue_;

      public enum FacetValueCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        VALUE(1),
        INTERVAL(2),
        FACETVALUE_NOT_SET(0);
        private final int value;

        private FacetValueCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static FacetValueCase valueOf(int value) {
          return forNumber(value);
        }

        public static FacetValueCase forNumber(int value) {
          switch (value) {
            case 1:
              return VALUE;
            case 2:
              return INTERVAL;
            case 0:
              return FACETVALUE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public FacetValueCase getFacetValueCase() {
        return FacetValueCase.forNumber(facetValueCase_);
      }

      public static final int VALUE_FIELD_NUMBER = 1;
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return facetValueCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = "";
        if (facetValueCase_ == 1) {
          ref = facetValue_;
        }
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (facetValueCase_ == 1) {
            facetValue_ = s;
          }
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Text value of a facet, such as "Black" for facet "colors".
       * </pre>
       *
       * <code>string value = 1;</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = "";
        if (facetValueCase_ == 1) {
          ref = facetValue_;
        }
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (facetValueCase_ == 1) {
            facetValue_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int INTERVAL_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
       *
       * @return Whether the interval field is set.
       */
      @java.lang.Override
      public boolean hasInterval() {
        return facetValueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
       *
       * @return The interval.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Interval getInterval() {
        if (facetValueCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.Interval) facetValue_;
        }
        return com.google.cloud.discoveryengine.v1.Interval.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * Interval value for a facet, such as [10, 20) for facet "price". It
       * matches
       * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.IntervalOrBuilder getIntervalOrBuilder() {
        if (facetValueCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.Interval) facetValue_;
        }
        return com.google.cloud.discoveryengine.v1.Interval.getDefaultInstance();
      }

      public static final int COUNT_FIELD_NUMBER = 3;
      private long count_ = 0L;
      /**
       *
       *
       * <pre>
       * Number of items that have this facet value.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (facetValueCase_ == 1) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, facetValue_);
        }
        if (facetValueCase_ == 2) {
          output.writeMessage(2, (com.google.cloud.discoveryengine.v1.Interval) facetValue_);
        }
        if (count_ != 0L) {
          output.writeInt64(3, count_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (facetValueCase_ == 1) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, facetValue_);
        }
        if (facetValueCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.cloud.discoveryengine.v1.Interval) facetValue_);
        }
        if (count_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, count_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue other =
            (com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue) obj;

        if (getCount() != other.getCount()) return false;
        if (!getFacetValueCase().equals(other.getFacetValueCase())) return false;
        switch (facetValueCase_) {
          case 1:
            if (!getValue().equals(other.getValue())) return false;
            break;
          case 2:
            if (!getInterval().equals(other.getInterval())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
        switch (facetValueCase_) {
          case 1:
            hash = (37 * hash) + VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getValue().hashCode();
            break;
          case 2:
            hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
            hash = (53 * hash) + getInterval().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A facet value which contains value names and their count.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue)
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_FacetValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_FacetValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (intervalBuilder_ != null) {
            intervalBuilder_.clear();
          }
          count_ = 0L;
          facetValueCase_ = 0;
          facetValue_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_FacetValue_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue build() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue buildPartial() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue result =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.count_ = count_;
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue result) {
          result.facetValueCase_ = facetValueCase_;
          result.facetValue_ = this.facetValue_;
          if (facetValueCase_ == 2 && intervalBuilder_ != null) {
            result.facetValue_ = intervalBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue other) {
          if (other
              == com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
                  .getDefaultInstance()) return this;
          if (other.getCount() != 0L) {
            setCount(other.getCount());
          }
          switch (other.getFacetValueCase()) {
            case VALUE:
              {
                facetValueCase_ = 1;
                facetValue_ = other.facetValue_;
                onChanged();
                break;
              }
            case INTERVAL:
              {
                mergeInterval(other.getInterval());
                break;
              }
            case FACETVALUE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    facetValueCase_ = 1;
                    facetValue_ = s;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                    facetValueCase_ = 2;
                    break;
                  } // case 18
                case 24:
                  {
                    count_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int facetValueCase_ = 0;
        private java.lang.Object facetValue_;

        public FacetValueCase getFacetValueCase() {
          return FacetValueCase.forNumber(facetValueCase_);
        }

        public Builder clearFacetValue() {
          facetValueCase_ = 0;
          facetValue_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return facetValueCase_ == 1;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return The value.
         */
        @java.lang.Override
        public java.lang.String getValue() {
          java.lang.Object ref = "";
          if (facetValueCase_ == 1) {
            ref = facetValue_;
          }
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (facetValueCase_ == 1) {
              facetValue_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return The bytes for value.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getValueBytes() {
          java.lang.Object ref = "";
          if (facetValueCase_ == 1) {
            ref = facetValue_;
          }
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            if (facetValueCase_ == 1) {
              facetValue_ = b;
            }
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          facetValueCase_ = 1;
          facetValue_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          if (facetValueCase_ == 1) {
            facetValueCase_ = 0;
            facetValue_ = null;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text value of a facet, such as "Black" for facet "colors".
         * </pre>
         *
         * <code>string value = 1;</code>
         *
         * @param value The bytes for value to set.
         * @return This builder for chaining.
         */
        public Builder setValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          facetValueCase_ = 1;
          facetValue_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Interval,
                com.google.cloud.discoveryengine.v1.Interval.Builder,
                com.google.cloud.discoveryengine.v1.IntervalOrBuilder>
            intervalBuilder_;
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         *
         * @return Whether the interval field is set.
         */
        @java.lang.Override
        public boolean hasInterval() {
          return facetValueCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         *
         * @return The interval.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Interval getInterval() {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1.Interval) facetValue_;
            }
            return com.google.cloud.discoveryengine.v1.Interval.getDefaultInstance();
          } else {
            if (facetValueCase_ == 2) {
              return intervalBuilder_.getMessage();
            }
            return com.google.cloud.discoveryengine.v1.Interval.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         */
        public Builder setInterval(com.google.cloud.discoveryengine.v1.Interval value) {
          if (intervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            facetValue_ = value;
            onChanged();
          } else {
            intervalBuilder_.setMessage(value);
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         */
        public Builder setInterval(
            com.google.cloud.discoveryengine.v1.Interval.Builder builderForValue) {
          if (intervalBuilder_ == null) {
            facetValue_ = builderForValue.build();
            onChanged();
          } else {
            intervalBuilder_.setMessage(builderForValue.build());
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         */
        public Builder mergeInterval(com.google.cloud.discoveryengine.v1.Interval value) {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2
                && facetValue_
                    != com.google.cloud.discoveryengine.v1.Interval.getDefaultInstance()) {
              facetValue_ =
                  com.google.cloud.discoveryengine.v1.Interval.newBuilder(
                          (com.google.cloud.discoveryengine.v1.Interval) facetValue_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              facetValue_ = value;
            }
            onChanged();
          } else {
            if (facetValueCase_ == 2) {
              intervalBuilder_.mergeFrom(value);
            } else {
              intervalBuilder_.setMessage(value);
            }
          }
          facetValueCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         */
        public Builder clearInterval() {
          if (intervalBuilder_ == null) {
            if (facetValueCase_ == 2) {
              facetValueCase_ = 0;
              facetValue_ = null;
              onChanged();
            }
          } else {
            if (facetValueCase_ == 2) {
              facetValueCase_ = 0;
              facetValue_ = null;
            }
            intervalBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         */
        public com.google.cloud.discoveryengine.v1.Interval.Builder getIntervalBuilder() {
          return getIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.IntervalOrBuilder getIntervalOrBuilder() {
          if ((facetValueCase_ == 2) && (intervalBuilder_ != null)) {
            return intervalBuilder_.getMessageOrBuilder();
          } else {
            if (facetValueCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1.Interval) facetValue_;
            }
            return com.google.cloud.discoveryengine.v1.Interval.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * Interval value for a facet, such as [10, 20) for facet "price". It
         * matches
         * [SearchRequest.FacetSpec.FacetKey.intervals][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.intervals].
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Interval interval = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Interval,
                com.google.cloud.discoveryengine.v1.Interval.Builder,
                com.google.cloud.discoveryengine.v1.IntervalOrBuilder>
            getIntervalFieldBuilder() {
          if (intervalBuilder_ == null) {
            if (!(facetValueCase_ == 2)) {
              facetValue_ = com.google.cloud.discoveryengine.v1.Interval.getDefaultInstance();
            }
            intervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Interval,
                    com.google.cloud.discoveryengine.v1.Interval.Builder,
                    com.google.cloud.discoveryengine.v1.IntervalOrBuilder>(
                    (com.google.cloud.discoveryengine.v1.Interval) facetValue_,
                    getParentForChildren(),
                    isClean());
            facetValue_ = null;
          }
          facetValueCase_ = 2;
          onChanged();
          return intervalBuilder_;
        }

        private long count_;
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return The count.
         */
        @java.lang.Override
        public long getCount() {
          return count_;
        }
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(long value) {

          count_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of items that have this facet value.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          count_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue)
      private static final com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue();
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FacetValue> PARSER =
          new com.google.protobuf.AbstractParser<FacetValue>() {
            @java.lang.Override
            public FacetValue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FacetValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FacetValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colors" or "price". It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The key for this facet. E.g., "colors" or "price". It matches
     * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue>
        values_;
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue>
        getValuesList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder>
        getValuesOrBuilderList() {
      return values_;
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public int getValuesCount() {
      return values_.size();
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue getValues(
        int index) {
      return values_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The facet values for this field.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder
        getValuesOrBuilder(int index) {
      return values_.get(index);
    }

    public static final int DYNAMIC_FACET_FIELD_NUMBER = 3;
    private boolean dynamicFacet_ = false;
    /**
     *
     *
     * <pre>
     * Whether the facet is dynamically generated.
     * </pre>
     *
     * <code>bool dynamic_facet = 3;</code>
     *
     * @return The dynamicFacet.
     */
    @java.lang.Override
    public boolean getDynamicFacet() {
      return dynamicFacet_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      for (int i = 0; i < values_.size(); i++) {
        output.writeMessage(2, values_.get(i));
      }
      if (dynamicFacet_ != false) {
        output.writeBool(3, dynamicFacet_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      for (int i = 0; i < values_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, values_.get(i));
      }
      if (dynamicFacet_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, dynamicFacet_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Facet)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.SearchResponse.Facet other =
          (com.google.cloud.discoveryengine.v1.SearchResponse.Facet) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (!getValuesList().equals(other.getValuesList())) return false;
      if (getDynamicFacet() != other.getDynamicFacet()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      if (getValuesCount() > 0) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + getValuesList().hashCode();
      }
      hash = (37 * hash) + DYNAMIC_FACET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDynamicFacet());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.SearchResponse.Facet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A facet result.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Facet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Facet)
        com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.SearchResponse.Facet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
        } else {
          values_ = null;
          valuesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        dynamicFacet_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Facet_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.SearchResponse.Facet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet build() {
        com.google.cloud.discoveryengine.v1.SearchResponse.Facet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet buildPartial() {
        com.google.cloud.discoveryengine.v1.SearchResponse.Facet result =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Facet(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet result) {
        if (valuesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            values_ = java.util.Collections.unmodifiableList(values_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.values_ = values_;
        } else {
          result.values_ = valuesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.SearchResponse.Facet result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.key_ = key_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.dynamicFacet_ = dynamicFacet_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Facet) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.SearchResponse.Facet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.SearchResponse.Facet other) {
        if (other == com.google.cloud.discoveryengine.v1.SearchResponse.Facet.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (valuesBuilder_ == null) {
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
        } else {
          if (!other.values_.isEmpty()) {
            if (valuesBuilder_.isEmpty()) {
              valuesBuilder_.dispose();
              valuesBuilder_ = null;
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000002);
              valuesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getValuesFieldBuilder()
                      : null;
            } else {
              valuesBuilder_.addAllMessages(other.values_);
            }
          }
        }
        if (other.getDynamicFacet() != false) {
          setDynamicFacet(other.getDynamicFacet());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
                              .parser(),
                          extensionRegistry);
                  if (valuesBuilder_ == null) {
                    ensureValuesIsMutable();
                    values_.add(m);
                  } else {
                    valuesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  dynamicFacet_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colors" or "price". It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colors" or "price". It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colors" or "price". It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colors" or "price". It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key for this facet. E.g., "colors" or "price". It matches
       * [SearchRequest.FacetSpec.FacetKey.key][google.cloud.discoveryengine.v1.SearchRequest.FacetSpec.FacetKey.key].
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue>
          values_ = java.util.Collections.emptyList();

      private void ensureValuesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          values_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue>(values_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue,
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder,
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder>
          valuesBuilder_;

      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue>
          getValuesList() {
        if (valuesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(values_);
        } else {
          return valuesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public int getValuesCount() {
        if (valuesBuilder_ == null) {
          return values_.size();
        } else {
          return valuesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue getValues(
          int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder setValues(
          int index, com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder setValues(
          int index,
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder
              builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.set(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          int index, com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue value) {
        if (valuesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(index, value);
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder
              builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addValues(
          int index,
          com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder
              builderForValue) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.add(index, builderForValue.build());
          onChanged();
        } else {
          valuesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder addAllValues(
          java.lang.Iterable<
                  ? extends com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue>
              values) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
        } else {
          valuesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder clearValues() {
        if (valuesBuilder_ == null) {
          values_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          valuesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public Builder removeValues(int index) {
        if (valuesBuilder_ == null) {
          ensureValuesIsMutable();
          values_.remove(index);
          onChanged();
        } else {
          valuesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder
          getValuesBuilder(int index) {
        return getValuesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder
          getValuesOrBuilder(int index) {
        if (valuesBuilder_ == null) {
          return values_.get(index);
        } else {
          return valuesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder>
          getValuesOrBuilderList() {
        if (valuesBuilder_ != null) {
          return valuesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(values_);
        }
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder
          addValuesBuilder() {
        return getValuesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder
          addValuesBuilder(int index) {
        return getValuesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The facet values for this field.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue values = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder>
          getValuesBuilderList() {
        return getValuesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue,
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder,
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder>
          getValuesFieldBuilder() {
        if (valuesBuilder_ == null) {
          valuesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValue.Builder,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Facet.FacetValueOrBuilder>(
                  values_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          values_ = null;
        }
        return valuesBuilder_;
      }

      private boolean dynamicFacet_;
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @return The dynamicFacet.
       */
      @java.lang.Override
      public boolean getDynamicFacet() {
        return dynamicFacet_;
      }
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @param value The dynamicFacet to set.
       * @return This builder for chaining.
       */
      public Builder setDynamicFacet(boolean value) {

        dynamicFacet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether the facet is dynamically generated.
       * </pre>
       *
       * <code>bool dynamic_facet = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDynamicFacet() {
        bitField0_ = (bitField0_ & ~0x00000004);
        dynamicFacet_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Facet)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Facet)
    private static final com.google.cloud.discoveryengine.v1.SearchResponse.Facet DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.SearchResponse.Facet();
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Facet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Facet> PARSER =
        new com.google.protobuf.AbstractParser<Facet>() {
          @java.lang.Override
          public Facet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Facet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Facet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Facet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SummaryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The summaryText.
     */
    java.lang.String getSummaryText();
    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The bytes for summaryText.
     */
    com.google.protobuf.ByteString getSummaryTextBytes();

    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the summarySkippedReasons.
     */
    java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason>
        getSummarySkippedReasonsList();
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return The count of summarySkippedReasons.
     */
    int getSummarySkippedReasonsCount();
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The summarySkippedReasons at the given index.
     */
    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason
        getSummarySkippedReasons(int index);
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for summarySkippedReasons.
     */
    java.util.List<java.lang.Integer> getSummarySkippedReasonsValueList();
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of summarySkippedReasons at the given index.
     */
    int getSummarySkippedReasonsValue(int index);

    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return Whether the safetyAttributes field is set.
     */
    boolean hasSafetyAttributes();
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return The safetyAttributes.
     */
    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
        getSafetyAttributes();
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributesOrBuilder
        getSafetyAttributesOrBuilder();

    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return Whether the summaryWithMetadata field is set.
     */
    boolean hasSummaryWithMetadata();
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return The summaryWithMetadata.
     */
    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
        getSummaryWithMetadata();
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadataOrBuilder
        getSummaryWithMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Summary of the top N search result specified by the summary spec.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary}
   */
  public static final class Summary extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary)
      SummaryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Summary.newBuilder() to construct.
    private Summary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Summary() {
      summaryText_ = "";
      summarySkippedReasons_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Summary();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.class,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * An Enum for summary-skipped reasons.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason}
     */
    public enum SummarySkippedReason implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. The summary skipped reason is not specified.
       * </pre>
       *
       * <code>SUMMARY_SKIPPED_REASON_UNSPECIFIED = 0;</code>
       */
      SUMMARY_SKIPPED_REASON_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The adversarial query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_adversarial_query][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.SummarySpec.ignore_adversarial_query]
       * is set to `true`.
       * </pre>
       *
       * <code>ADVERSARIAL_QUERY_IGNORED = 1;</code>
       */
      ADVERSARIAL_QUERY_IGNORED(1),
      /**
       *
       *
       * <pre>
       * The non-summary seeking query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_non_summary_seeking_query][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.SummarySpec.ignore_non_summary_seeking_query]
       * is set to `true`.
       * </pre>
       *
       * <code>NON_SUMMARY_SEEKING_QUERY_IGNORED = 2;</code>
       */
      NON_SUMMARY_SEEKING_QUERY_IGNORED(2),
      /**
       *
       *
       * <pre>
       * The out-of-domain query ignored case.
       *
       * Google skips the summary if there are no high-relevance search results.
       * For example, the data store contains facts about company A but the
       * user query is asking questions about company B.
       * </pre>
       *
       * <code>OUT_OF_DOMAIN_QUERY_IGNORED = 3;</code>
       */
      OUT_OF_DOMAIN_QUERY_IGNORED(3),
      /**
       *
       *
       * <pre>
       * The potential policy violation case.
       *
       * Google skips the summary if there is a potential policy violation
       * detected. This includes content that may be violent or toxic.
       * </pre>
       *
       * <code>POTENTIAL_POLICY_VIOLATION = 4;</code>
       */
      POTENTIAL_POLICY_VIOLATION(4),
      /**
       *
       *
       * <pre>
       * The LLM addon not enabled case.
       *
       * Google skips the summary if the LLM addon is not enabled.
       * </pre>
       *
       * <code>LLM_ADDON_NOT_ENABLED = 5;</code>
       */
      LLM_ADDON_NOT_ENABLED(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. The summary skipped reason is not specified.
       * </pre>
       *
       * <code>SUMMARY_SKIPPED_REASON_UNSPECIFIED = 0;</code>
       */
      public static final int SUMMARY_SKIPPED_REASON_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The adversarial query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_adversarial_query][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.SummarySpec.ignore_adversarial_query]
       * is set to `true`.
       * </pre>
       *
       * <code>ADVERSARIAL_QUERY_IGNORED = 1;</code>
       */
      public static final int ADVERSARIAL_QUERY_IGNORED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The non-summary seeking query ignored case.
       *
       * Only populated when
       * [SummarySpec.ignore_non_summary_seeking_query][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.SummarySpec.ignore_non_summary_seeking_query]
       * is set to `true`.
       * </pre>
       *
       * <code>NON_SUMMARY_SEEKING_QUERY_IGNORED = 2;</code>
       */
      public static final int NON_SUMMARY_SEEKING_QUERY_IGNORED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The out-of-domain query ignored case.
       *
       * Google skips the summary if there are no high-relevance search results.
       * For example, the data store contains facts about company A but the
       * user query is asking questions about company B.
       * </pre>
       *
       * <code>OUT_OF_DOMAIN_QUERY_IGNORED = 3;</code>
       */
      public static final int OUT_OF_DOMAIN_QUERY_IGNORED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The potential policy violation case.
       *
       * Google skips the summary if there is a potential policy violation
       * detected. This includes content that may be violent or toxic.
       * </pre>
       *
       * <code>POTENTIAL_POLICY_VIOLATION = 4;</code>
       */
      public static final int POTENTIAL_POLICY_VIOLATION_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The LLM addon not enabled case.
       *
       * Google skips the summary if the LLM addon is not enabled.
       * </pre>
       *
       * <code>LLM_ADDON_NOT_ENABLED = 5;</code>
       */
      public static final int LLM_ADDON_NOT_ENABLED_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SummarySkippedReason valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static SummarySkippedReason forNumber(int value) {
        switch (value) {
          case 0:
            return SUMMARY_SKIPPED_REASON_UNSPECIFIED;
          case 1:
            return ADVERSARIAL_QUERY_IGNORED;
          case 2:
            return NON_SUMMARY_SEEKING_QUERY_IGNORED;
          case 3:
            return OUT_OF_DOMAIN_QUERY_IGNORED;
          case 4:
            return POTENTIAL_POLICY_VIOLATION;
          case 5:
            return LLM_ADDON_NOT_ENABLED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SummarySkippedReason>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<SummarySkippedReason>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<SummarySkippedReason>() {
                public SummarySkippedReason findValueByNumber(int number) {
                  return SummarySkippedReason.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final SummarySkippedReason[] VALUES = values();

      public static SummarySkippedReason valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private SummarySkippedReason(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason)
    }

    public interface SafetyAttributesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return A list containing the categories.
       */
      java.util.List<java.lang.String> getCategoriesList();
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return The count of categories.
       */
      int getCategoriesCount();
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The categories at the given index.
       */
      java.lang.String getCategories(int index);
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the categories at the given index.
       */
      com.google.protobuf.ByteString getCategoriesBytes(int index);

      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return A list containing the scores.
       */
      java.util.List<java.lang.Float> getScoresList();
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return The count of scores.
       */
      int getScoresCount();
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The scores at the given index.
       */
      float getScores(int index);
    }
    /**
     *
     *
     * <pre>
     * Safety Attribute categories and their associated confidence scores.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes}
     */
    public static final class SafetyAttributes extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes)
        SafetyAttributesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SafetyAttributes.newBuilder() to construct.
      private SafetyAttributes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SafetyAttributes() {
        categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
        scores_ = emptyFloatList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SafetyAttributes();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SafetyAttributes_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SafetyAttributes_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.Builder
                    .class);
      }

      public static final int CATEGORIES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList categories_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return A list containing the categories.
       */
      public com.google.protobuf.ProtocolStringList getCategoriesList() {
        return categories_;
      }
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @return The count of categories.
       */
      public int getCategoriesCount() {
        return categories_.size();
      }
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The categories at the given index.
       */
      public java.lang.String getCategories(int index) {
        return categories_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The display names of Safety Attribute categories associated with the
       * generated content. Order matches the Scores.
       * </pre>
       *
       * <code>repeated string categories = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the categories at the given index.
       */
      public com.google.protobuf.ByteString getCategoriesBytes(int index) {
        return categories_.getByteString(index);
      }

      public static final int SCORES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private com.google.protobuf.Internal.FloatList scores_ = emptyFloatList();
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return A list containing the scores.
       */
      @java.lang.Override
      public java.util.List<java.lang.Float> getScoresList() {
        return scores_;
      }
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @return The count of scores.
       */
      public int getScoresCount() {
        return scores_.size();
      }
      /**
       *
       *
       * <pre>
       * The confidence scores of the each category, higher
       * value means higher confidence. Order matches the Categories.
       * </pre>
       *
       * <code>repeated float scores = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The scores at the given index.
       */
      public float getScores(int index) {
        return scores_.getFloat(index);
      }

      private int scoresMemoizedSerializedSize = -1;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        for (int i = 0; i < categories_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, categories_.getRaw(i));
        }
        if (getScoresList().size() > 0) {
          output.writeUInt32NoTag(18);
          output.writeUInt32NoTag(scoresMemoizedSerializedSize);
        }
        for (int i = 0; i < scores_.size(); i++) {
          output.writeFloatNoTag(scores_.getFloat(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < categories_.size(); i++) {
            dataSize += computeStringSizeNoTag(categories_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getCategoriesList().size();
        }
        {
          int dataSize = 0;
          dataSize = 4 * getScoresList().size();
          size += dataSize;
          if (!getScoresList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          scoresMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes other =
            (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes) obj;

        if (!getCategoriesList().equals(other.getCategoriesList())) return false;
        if (!getScoresList().equals(other.getScoresList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCategoriesCount() > 0) {
          hash = (37 * hash) + CATEGORIES_FIELD_NUMBER;
          hash = (53 * hash) + getCategoriesList().hashCode();
        }
        if (getScoresCount() > 0) {
          hash = (37 * hash) + SCORES_FIELD_NUMBER;
          hash = (53 * hash) + getScoresList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Safety Attribute categories and their associated confidence scores.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes)
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SafetyAttributes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SafetyAttributes_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
          scores_ = emptyFloatList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SafetyAttributes_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes build() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
            buildPartial() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes result =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            categories_.makeImmutable();
            result.categories_ = categories_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            scores_.makeImmutable();
            result.scores_ = scores_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes other) {
          if (other
              == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
                  .getDefaultInstance()) return this;
          if (!other.categories_.isEmpty()) {
            if (categories_.isEmpty()) {
              categories_ = other.categories_;
              bitField0_ |= 0x00000001;
            } else {
              ensureCategoriesIsMutable();
              categories_.addAll(other.categories_);
            }
            onChanged();
          }
          if (!other.scores_.isEmpty()) {
            if (scores_.isEmpty()) {
              scores_ = other.scores_;
              scores_.makeImmutable();
              bitField0_ |= 0x00000002;
            } else {
              ensureScoresIsMutable();
              scores_.addAll(other.scores_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureCategoriesIsMutable();
                    categories_.add(s);
                    break;
                  } // case 10
                case 21:
                  {
                    float v = input.readFloat();
                    ensureScoresIsMutable();
                    scores_.addFloat(v);
                    break;
                  } // case 21
                case 18:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    int alloc = length > 4096 ? 4096 : length;
                    ensureScoresIsMutable(alloc / 4);
                    while (input.getBytesUntilLimit() > 0) {
                      scores_.addFloat(input.readFloat());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList categories_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureCategoriesIsMutable() {
          if (!categories_.isModifiable()) {
            categories_ = new com.google.protobuf.LazyStringArrayList(categories_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @return A list containing the categories.
         */
        public com.google.protobuf.ProtocolStringList getCategoriesList() {
          categories_.makeImmutable();
          return categories_;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @return The count of categories.
         */
        public int getCategoriesCount() {
          return categories_.size();
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param index The index of the element to return.
         * @return The categories at the given index.
         */
        public java.lang.String getCategories(int index) {
          return categories_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the categories at the given index.
         */
        public com.google.protobuf.ByteString getCategoriesBytes(int index) {
          return categories_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param index The index to set the value at.
         * @param value The categories to set.
         * @return This builder for chaining.
         */
        public Builder setCategories(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCategoriesIsMutable();
          categories_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param value The categories to add.
         * @return This builder for chaining.
         */
        public Builder addCategories(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCategoriesIsMutable();
          categories_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param values The categories to add.
         * @return This builder for chaining.
         */
        public Builder addAllCategories(java.lang.Iterable<java.lang.String> values) {
          ensureCategoriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, categories_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCategories() {
          categories_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The display names of Safety Attribute categories associated with the
         * generated content. Order matches the Scores.
         * </pre>
         *
         * <code>repeated string categories = 1;</code>
         *
         * @param value The bytes of the categories to add.
         * @return This builder for chaining.
         */
        public Builder addCategoriesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureCategoriesIsMutable();
          categories_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Internal.FloatList scores_ = emptyFloatList();

        private void ensureScoresIsMutable() {
          if (!scores_.isModifiable()) {
            scores_ = makeMutableCopy(scores_);
          }
          bitField0_ |= 0x00000002;
        }

        private void ensureScoresIsMutable(int capacity) {
          if (!scores_.isModifiable()) {
            scores_ = makeMutableCopy(scores_, capacity);
          }
          bitField0_ |= 0x00000002;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @return A list containing the scores.
         */
        public java.util.List<java.lang.Float> getScoresList() {
          scores_.makeImmutable();
          return scores_;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @return The count of scores.
         */
        public int getScoresCount() {
          return scores_.size();
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param index The index of the element to return.
         * @return The scores at the given index.
         */
        public float getScores(int index) {
          return scores_.getFloat(index);
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param index The index to set the value at.
         * @param value The scores to set.
         * @return This builder for chaining.
         */
        public Builder setScores(int index, float value) {

          ensureScoresIsMutable();
          scores_.setFloat(index, value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param value The scores to add.
         * @return This builder for chaining.
         */
        public Builder addScores(float value) {

          ensureScoresIsMutable();
          scores_.addFloat(value);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @param values The scores to add.
         * @return This builder for chaining.
         */
        public Builder addAllScores(java.lang.Iterable<? extends java.lang.Float> values) {
          ensureScoresIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scores_);
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The confidence scores of the each category, higher
         * value means higher confidence. Order matches the Categories.
         * </pre>
         *
         * <code>repeated float scores = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearScores() {
          scores_ = emptyFloatList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes)
      private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary
              .SafetyAttributes
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes();
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SafetyAttributes> PARSER =
          new com.google.protobuf.AbstractParser<SafetyAttributes>() {
            @java.lang.Override
            public SafetyAttributes parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SafetyAttributes> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SafetyAttributes> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CitationMetadataOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation>
          getCitationsList();
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation getCitations(int index);
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      int getCitationsCount();
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder>
          getCitationsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder
          getCitationsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Citation metadata.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata}
     */
    public static final class CitationMetadata extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata)
        CitationMetadataOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CitationMetadata.newBuilder() to construct.
      private CitationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CitationMetadata() {
        citations_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CitationMetadata();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.Builder
                    .class);
      }

      public static final int CITATIONS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation>
          citations_;
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation>
          getCitationsList() {
        return citations_;
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder>
          getCitationsOrBuilderList() {
        return citations_;
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public int getCitationsCount() {
        return citations_.size();
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation getCitations(
          int index) {
        return citations_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Citations for segments.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder
          getCitationsOrBuilder(int index) {
        return citations_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < citations_.size(); i++) {
          output.writeMessage(1, citations_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < citations_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, citations_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata other =
            (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata) obj;

        if (!getCitationsList().equals(other.getCitationsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCitationsCount() > 0) {
          hash = (37 * hash) + CITATIONS_FIELD_NUMBER;
          hash = (53 * hash) + getCitationsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Citation metadata.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata)
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadataOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (citationsBuilder_ == null) {
            citations_ = java.util.Collections.emptyList();
          } else {
            citations_ = null;
            citationsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationMetadata_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata build() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
            buildPartial() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata result =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata result) {
          if (citationsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              citations_ = java.util.Collections.unmodifiableList(citations_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.citations_ = citations_;
          } else {
            result.citations_ = citationsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata other) {
          if (other
              == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                  .getDefaultInstance()) return this;
          if (citationsBuilder_ == null) {
            if (!other.citations_.isEmpty()) {
              if (citations_.isEmpty()) {
                citations_ = other.citations_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCitationsIsMutable();
                citations_.addAll(other.citations_);
              }
              onChanged();
            }
          } else {
            if (!other.citations_.isEmpty()) {
              if (citationsBuilder_.isEmpty()) {
                citationsBuilder_.dispose();
                citationsBuilder_ = null;
                citations_ = other.citations_;
                bitField0_ = (bitField0_ & ~0x00000001);
                citationsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getCitationsFieldBuilder()
                        : null;
              } else {
                citationsBuilder_.addAllMessages(other.citations_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
                                .parser(),
                            extensionRegistry);
                    if (citationsBuilder_ == null) {
                      ensureCitationsIsMutable();
                      citations_.add(m);
                    } else {
                      citationsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation>
            citations_ = java.util.Collections.emptyList();

        private void ensureCitationsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            citations_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation>(
                    citations_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder>
            citationsBuilder_;

        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation>
            getCitationsList() {
          if (citationsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(citations_);
          } else {
            return citationsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public int getCitationsCount() {
          if (citationsBuilder_ == null) {
            return citations_.size();
          } else {
            return citationsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation getCitations(
            int index) {
          if (citationsBuilder_ == null) {
            return citations_.get(index);
          } else {
            return citationsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder setCitations(
            int index, com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation value) {
          if (citationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCitationsIsMutable();
            citations_.set(index, value);
            onChanged();
          } else {
            citationsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder setCitations(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder
                builderForValue) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.set(index, builderForValue.build());
            onChanged();
          } else {
            citationsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation value) {
          if (citationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCitationsIsMutable();
            citations_.add(value);
            onChanged();
          } else {
            citationsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            int index, com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation value) {
          if (citationsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCitationsIsMutable();
            citations_.add(index, value);
            onChanged();
          } else {
            citationsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder
                builderForValue) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.add(builderForValue.build());
            onChanged();
          } else {
            citationsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addCitations(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder
                builderForValue) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.add(index, builderForValue.build());
            onChanged();
          } else {
            citationsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder addAllCitations(
            java.lang.Iterable<
                    ? extends com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation>
                values) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, citations_);
            onChanged();
          } else {
            citationsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder clearCitations() {
          if (citationsBuilder_ == null) {
            citations_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            citationsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public Builder removeCitations(int index) {
          if (citationsBuilder_ == null) {
            ensureCitationsIsMutable();
            citations_.remove(index);
            onChanged();
          } else {
            citationsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder
            getCitationsBuilder(int index) {
          return getCitationsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder
            getCitationsOrBuilder(int index) {
          if (citationsBuilder_ == null) {
            return citations_.get(index);
          } else {
            return citationsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder>
            getCitationsOrBuilderList() {
          if (citationsBuilder_ != null) {
            return citationsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(citations_);
          }
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder
            addCitationsBuilder() {
          return getCitationsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder
            addCitationsBuilder(int index) {
          return getCitationsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citations for segments.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation citations = 1;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder>
            getCitationsBuilderList() {
          return getCitationsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder>
            getCitationsFieldBuilder() {
          if (citationsBuilder_ == null) {
            citationsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder>(
                    citations_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            citations_ = null;
          }
          return citationsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata)
      private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary
              .CitationMetadata
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata();
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CitationMetadata> PARSER =
          new com.google.protobuf.AbstractParser<CitationMetadata>() {
            @java.lang.Override
            public CitationMetadata parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CitationMetadata> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CitationMetadata> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CitationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Index indicates the start of the segment, measured in bytes/unicode.
       * </pre>
       *
       * <code>int64 start_index = 1;</code>
       *
       * @return The startIndex.
       */
      long getStartIndex();

      /**
       *
       *
       * <pre>
       * End of the attributed segment, exclusive.
       * </pre>
       *
       * <code>int64 end_index = 2;</code>
       *
       * @return The endIndex.
       */
      long getEndIndex();

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource>
          getSourcesList();
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource getSources(
          int index);
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      int getSourcesCount();
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                      .CitationSourceOrBuilder>
          getSourcesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSourceOrBuilder
          getSourcesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Citation info for a segment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation}
     */
    public static final class Citation extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation)
        CitationOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Citation.newBuilder() to construct.
      private Citation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Citation() {
        sources_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Citation();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Citation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Citation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder.class);
      }

      public static final int START_INDEX_FIELD_NUMBER = 1;
      private long startIndex_ = 0L;
      /**
       *
       *
       * <pre>
       * Index indicates the start of the segment, measured in bytes/unicode.
       * </pre>
       *
       * <code>int64 start_index = 1;</code>
       *
       * @return The startIndex.
       */
      @java.lang.Override
      public long getStartIndex() {
        return startIndex_;
      }

      public static final int END_INDEX_FIELD_NUMBER = 2;
      private long endIndex_ = 0L;
      /**
       *
       *
       * <pre>
       * End of the attributed segment, exclusive.
       * </pre>
       *
       * <code>int64 end_index = 2;</code>
       *
       * @return The endIndex.
       */
      @java.lang.Override
      public long getEndIndex() {
        return endIndex_;
      }

      public static final int SOURCES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource>
          sources_;
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource>
          getSourcesList() {
        return sources_;
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                      .CitationSourceOrBuilder>
          getSourcesOrBuilderList() {
        return sources_;
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public int getSourcesCount() {
        return sources_.size();
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource getSources(
          int index) {
        return sources_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSourceOrBuilder
          getSourcesOrBuilder(int index) {
        return sources_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (startIndex_ != 0L) {
          output.writeInt64(1, startIndex_);
        }
        if (endIndex_ != 0L) {
          output.writeInt64(2, endIndex_);
        }
        for (int i = 0; i < sources_.size(); i++) {
          output.writeMessage(3, sources_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (startIndex_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, startIndex_);
        }
        if (endIndex_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, endIndex_);
        }
        for (int i = 0; i < sources_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, sources_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation other =
            (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation) obj;

        if (getStartIndex() != other.getStartIndex()) return false;
        if (getEndIndex() != other.getEndIndex()) return false;
        if (!getSourcesList().equals(other.getSourcesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + START_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStartIndex());
        hash = (37 * hash) + END_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEndIndex());
        if (getSourcesCount() > 0) {
          hash = (37 * hash) + SOURCES_FIELD_NUMBER;
          hash = (53 * hash) + getSourcesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Citation info for a segment.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation)
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Citation_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Citation_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          startIndex_ = 0L;
          endIndex_ = 0L;
          if (sourcesBuilder_ == null) {
            sources_ = java.util.Collections.emptyList();
          } else {
            sources_ = null;
            sourcesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Citation_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation build() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation buildPartial() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation result =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation result) {
          if (sourcesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              sources_ = java.util.Collections.unmodifiableList(sources_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.sources_ = sources_;
          } else {
            result.sources_ = sourcesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.startIndex_ = startIndex_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.endIndex_ = endIndex_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation other) {
          if (other
              == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
                  .getDefaultInstance()) return this;
          if (other.getStartIndex() != 0L) {
            setStartIndex(other.getStartIndex());
          }
          if (other.getEndIndex() != 0L) {
            setEndIndex(other.getEndIndex());
          }
          if (sourcesBuilder_ == null) {
            if (!other.sources_.isEmpty()) {
              if (sources_.isEmpty()) {
                sources_ = other.sources_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureSourcesIsMutable();
                sources_.addAll(other.sources_);
              }
              onChanged();
            }
          } else {
            if (!other.sources_.isEmpty()) {
              if (sourcesBuilder_.isEmpty()) {
                sourcesBuilder_.dispose();
                sourcesBuilder_ = null;
                sources_ = other.sources_;
                bitField0_ = (bitField0_ & ~0x00000004);
                sourcesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getSourcesFieldBuilder()
                        : null;
              } else {
                sourcesBuilder_.addAllMessages(other.sources_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    startIndex_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    endIndex_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 26:
                  {
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                                .CitationSource.parser(),
                            extensionRegistry);
                    if (sourcesBuilder_ == null) {
                      ensureSourcesIsMutable();
                      sources_.add(m);
                    } else {
                      sourcesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long startIndex_;
        /**
         *
         *
         * <pre>
         * Index indicates the start of the segment, measured in bytes/unicode.
         * </pre>
         *
         * <code>int64 start_index = 1;</code>
         *
         * @return The startIndex.
         */
        @java.lang.Override
        public long getStartIndex() {
          return startIndex_;
        }
        /**
         *
         *
         * <pre>
         * Index indicates the start of the segment, measured in bytes/unicode.
         * </pre>
         *
         * <code>int64 start_index = 1;</code>
         *
         * @param value The startIndex to set.
         * @return This builder for chaining.
         */
        public Builder setStartIndex(long value) {

          startIndex_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Index indicates the start of the segment, measured in bytes/unicode.
         * </pre>
         *
         * <code>int64 start_index = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearStartIndex() {
          bitField0_ = (bitField0_ & ~0x00000001);
          startIndex_ = 0L;
          onChanged();
          return this;
        }

        private long endIndex_;
        /**
         *
         *
         * <pre>
         * End of the attributed segment, exclusive.
         * </pre>
         *
         * <code>int64 end_index = 2;</code>
         *
         * @return The endIndex.
         */
        @java.lang.Override
        public long getEndIndex() {
          return endIndex_;
        }
        /**
         *
         *
         * <pre>
         * End of the attributed segment, exclusive.
         * </pre>
         *
         * <code>int64 end_index = 2;</code>
         *
         * @param value The endIndex to set.
         * @return This builder for chaining.
         */
        public Builder setEndIndex(long value) {

          endIndex_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * End of the attributed segment, exclusive.
         * </pre>
         *
         * <code>int64 end_index = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEndIndex() {
          bitField0_ = (bitField0_ & ~0x00000002);
          endIndex_ = 0L;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource>
            sources_ = java.util.Collections.emptyList();

        private void ensureSourcesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            sources_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource>(
                    sources_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSourceOrBuilder>
            sourcesBuilder_;

        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource>
            getSourcesList() {
          if (sourcesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(sources_);
          } else {
            return sourcesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public int getSourcesCount() {
          if (sourcesBuilder_ == null) {
            return sources_.size();
          } else {
            return sourcesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource getSources(
            int index) {
          if (sourcesBuilder_ == null) {
            return sources_.get(index);
          } else {
            return sourcesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder setSources(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource value) {
          if (sourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSourcesIsMutable();
            sources_.set(index, value);
            onChanged();
          } else {
            sourcesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder setSources(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
                builderForValue) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.set(index, builderForValue.build());
            onChanged();
          } else {
            sourcesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource value) {
          if (sourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSourcesIsMutable();
            sources_.add(value);
            onChanged();
          } else {
            sourcesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource value) {
          if (sourcesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSourcesIsMutable();
            sources_.add(index, value);
            onChanged();
          } else {
            sourcesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
                builderForValue) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.add(builderForValue.build());
            onChanged();
          } else {
            sourcesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addSources(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
                builderForValue) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.add(index, builderForValue.build());
            onChanged();
          } else {
            sourcesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder addAllSources(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource>
                values) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sources_);
            onChanged();
          } else {
            sourcesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder clearSources() {
          if (sourcesBuilder_ == null) {
            sources_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            sourcesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public Builder removeSources(int index) {
          if (sourcesBuilder_ == null) {
            ensureSourcesIsMutable();
            sources_.remove(index);
            onChanged();
          } else {
            sourcesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
            getSourcesBuilder(int index) {
          return getSourcesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSourceOrBuilder
            getSourcesOrBuilder(int index) {
          if (sourcesBuilder_ == null) {
            return sources_.get(index);
          } else {
            return sourcesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                        .CitationSourceOrBuilder>
            getSourcesOrBuilderList() {
          if (sourcesBuilder_ != null) {
            return sourcesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(sources_);
          }
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
            addSourcesBuilder() {
          return getSourcesFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
            addSourcesBuilder(int index) {
          return getSourcesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Citation sources for the attributed segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource sources = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder>
            getSourcesBuilderList() {
          return getSourcesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSourceOrBuilder>
            getSourcesFieldBuilder() {
          if (sourcesBuilder_ == null) {
            sourcesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
                        .Builder,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                        .CitationSourceOrBuilder>(
                    sources_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
            sources_ = null;
          }
          return sourcesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation)
      private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation();
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Citation> PARSER =
          new com.google.protobuf.AbstractParser<Citation>() {
            @java.lang.Override
            public Citation parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Citation> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Citation> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Citation
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CitationSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Document reference index from SummaryWithMetadata.references.
       * It is 0-indexed and the value will be zero if the reference_index is
       * not set explicitly.
       * </pre>
       *
       * <code>int64 reference_index = 4;</code>
       *
       * @return The referenceIndex.
       */
      long getReferenceIndex();
    }
    /**
     *
     *
     * <pre>
     * Citation source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource}
     */
    public static final class CitationSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource)
        CitationSourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CitationSource.newBuilder() to construct.
      private CitationSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CitationSource() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CitationSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
                    .class);
      }

      public static final int REFERENCE_INDEX_FIELD_NUMBER = 4;
      private long referenceIndex_ = 0L;
      /**
       *
       *
       * <pre>
       * Document reference index from SummaryWithMetadata.references.
       * It is 0-indexed and the value will be zero if the reference_index is
       * not set explicitly.
       * </pre>
       *
       * <code>int64 reference_index = 4;</code>
       *
       * @return The referenceIndex.
       */
      @java.lang.Override
      public long getReferenceIndex() {
        return referenceIndex_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (referenceIndex_ != 0L) {
          output.writeInt64(4, referenceIndex_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (referenceIndex_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, referenceIndex_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource other =
            (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource) obj;

        if (getReferenceIndex() != other.getReferenceIndex()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + REFERENCE_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getReferenceIndex());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Citation source.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource)
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          referenceIndex_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_CitationSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource build() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
            buildPartial() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource result =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.referenceIndex_ = referenceIndex_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource other) {
          if (other
              == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
                  .getDefaultInstance()) return this;
          if (other.getReferenceIndex() != 0L) {
            setReferenceIndex(other.getReferenceIndex());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 32:
                  {
                    referenceIndex_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long referenceIndex_;
        /**
         *
         *
         * <pre>
         * Document reference index from SummaryWithMetadata.references.
         * It is 0-indexed and the value will be zero if the reference_index is
         * not set explicitly.
         * </pre>
         *
         * <code>int64 reference_index = 4;</code>
         *
         * @return The referenceIndex.
         */
        @java.lang.Override
        public long getReferenceIndex() {
          return referenceIndex_;
        }
        /**
         *
         *
         * <pre>
         * Document reference index from SummaryWithMetadata.references.
         * It is 0-indexed and the value will be zero if the reference_index is
         * not set explicitly.
         * </pre>
         *
         * <code>int64 reference_index = 4;</code>
         *
         * @param value The referenceIndex to set.
         * @return This builder for chaining.
         */
        public Builder setReferenceIndex(long value) {

          referenceIndex_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document reference index from SummaryWithMetadata.references.
         * It is 0-indexed and the value will be zero if the reference_index is
         * not set explicitly.
         * </pre>
         *
         * <code>int64 reference_index = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearReferenceIndex() {
          bitField0_ = (bitField0_ & ~0x00000001);
          referenceIndex_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource)
      private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource();
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CitationSource> PARSER =
          new com.google.protobuf.AbstractParser<CitationSource>() {
            @java.lang.Override
            public CitationSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CitationSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CitationSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ReferenceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
       * document. Full resource name of the referenced document, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The document.
       */
      java.lang.String getDocument();
      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
       * document. Full resource name of the referenced document, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for document.
       */
      com.google.protobuf.ByteString getDocumentBytes();

      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();
      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent>
          getChunkContentsList();
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
          getChunkContents(int index);
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      int getChunkContentsCount();
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                      .ChunkContentOrBuilder>
          getChunkContentsOrBuilderList();
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContentOrBuilder
          getChunkContentsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Document reference.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference}
     */
    public static final class Reference extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference)
        ReferenceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Reference.newBuilder() to construct.
      private Reference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Reference() {
        title_ = "";
        document_ = "";
        uri_ = "";
        chunkContents_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Reference();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder.class);
      }

      public interface ChunkContentOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The content.
         */
        java.lang.String getContent();
        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The bytes for content.
         */
        com.google.protobuf.ByteString getContentBytes();

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The pageIdentifier.
         */
        java.lang.String getPageIdentifier();
        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        com.google.protobuf.ByteString getPageIdentifierBytes();
      }
      /**
       *
       *
       * <pre>
       * Chunk content.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent}
       */
      public static final class ChunkContent extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent)
          ChunkContentOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ChunkContent.newBuilder() to construct.
        private ChunkContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ChunkContent() {
          content_ = "";
          pageIdentifier_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ChunkContent();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_ChunkContent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_ChunkContent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                      .class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                      .Builder.class);
        }

        public static final int CONTENT_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object content_ = "";
        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The content.
         */
        @java.lang.Override
        public java.lang.String getContent() {
          java.lang.Object ref = content_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            content_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The bytes for content.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getContentBytes() {
          java.lang.Object ref = content_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            content_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int PAGE_IDENTIFIER_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object pageIdentifier_ = "";
        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The pageIdentifier.
         */
        @java.lang.Override
        public java.lang.String getPageIdentifier() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            pageIdentifier_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getPageIdentifierBytes() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            pageIdentifier_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, content_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pageIdentifier_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, content_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, pageIdentifier_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent other =
              (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent)
                  obj;

          if (!getContent().equals(other.getContent())) return false;
          if (!getPageIdentifier().equals(other.getPageIdentifier())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + CONTENT_FIELD_NUMBER;
          hash = (53 * hash) + getContent().hashCode();
          hash = (37 * hash) + PAGE_IDENTIFIER_FIELD_NUMBER;
          hash = (53 * hash) + getPageIdentifier().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Chunk content.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent)
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContentOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_ChunkContent_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_ChunkContent_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContent.class,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContent.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            content_ = "";
            pageIdentifier_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1.SearchServiceProto
                .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_ChunkContent_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
              build() {
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
              buildPartial() {
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                result =
                    new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContent(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.content_ = content_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.pageIdentifier_ = pageIdentifier_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                          .ChunkContent)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                    .getDefaultInstance()) return this;
            if (!other.getContent().isEmpty()) {
              content_ = other.content_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getPageIdentifier().isEmpty()) {
              pageIdentifier_ = other.pageIdentifier_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      content_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      pageIdentifier_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object content_ = "";
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return The content.
           */
          public java.lang.String getContent() {
            java.lang.Object ref = content_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              content_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return The bytes for content.
           */
          public com.google.protobuf.ByteString getContentBytes() {
            java.lang.Object ref = content_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              content_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @param value The content to set.
           * @return This builder for chaining.
           */
          public Builder setContent(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            content_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearContent() {
            content_ = getDefaultInstance().getContent();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @param value The bytes for content to set.
           * @return This builder for chaining.
           */
          public Builder setContentBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            content_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object pageIdentifier_ = "";
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return The pageIdentifier.
           */
          public java.lang.String getPageIdentifier() {
            java.lang.Object ref = pageIdentifier_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              pageIdentifier_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return The bytes for pageIdentifier.
           */
          public com.google.protobuf.ByteString getPageIdentifierBytes() {
            java.lang.Object ref = pageIdentifier_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              pageIdentifier_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @param value The pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifier(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            pageIdentifier_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPageIdentifier() {
            pageIdentifier_ = getDefaultInstance().getPageIdentifier();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @param value The bytes for pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifierBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            pageIdentifier_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent)
        private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                  .ChunkContent();
        }

        public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContent
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ChunkContent> PARSER =
            new com.google.protobuf.AbstractParser<ChunkContent>() {
              @java.lang.Override
              public ChunkContent parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ChunkContent> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ChunkContent> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int TITLE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DOCUMENT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object document_ = "";
      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
       * document. Full resource name of the referenced document, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The document.
       */
      @java.lang.Override
      public java.lang.String getDocument() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          document_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required.
       * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
       * document. Full resource name of the referenced document, in the format
       * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
       * </pre>
       *
       * <code>
       * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for document.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDocumentBytes() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          document_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int URI_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage or HTTP uri for the document.
       * </pre>
       *
       * <code>string uri = 3;</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CHUNK_CONTENTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent>
          chunkContents_;
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent>
          getChunkContentsList() {
        return chunkContents_;
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                      .ChunkContentOrBuilder>
          getChunkContentsOrBuilderList() {
        return chunkContents_;
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public int getChunkContentsCount() {
        return chunkContents_.size();
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
          getChunkContents(int index) {
        return chunkContents_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
              .ChunkContentOrBuilder
          getChunkContentsOrBuilder(int index) {
        return chunkContents_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, document_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uri_);
        }
        for (int i = 0; i < chunkContents_.size(); i++) {
          output.writeMessage(4, chunkContents_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, document_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uri_);
        }
        for (int i = 0; i < chunkContents_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, chunkContents_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference other =
            (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference) obj;

        if (!getTitle().equals(other.getTitle())) return false;
        if (!getDocument().equals(other.getDocument())) return false;
        if (!getUri().equals(other.getUri())) return false;
        if (!getChunkContentsList().equals(other.getChunkContentsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        if (getChunkContentsCount() > 0) {
          hash = (37 * hash) + CHUNK_CONTENTS_FIELD_NUMBER;
          hash = (53 * hash) + getChunkContentsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Document reference.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference)
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          title_ = "";
          document_ = "";
          uri_ = "";
          if (chunkContentsBuilder_ == null) {
            chunkContents_ = java.util.Collections.emptyList();
          } else {
            chunkContents_ = null;
            chunkContentsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_Reference_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference build() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference buildPartial() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference result =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference result) {
          if (chunkContentsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              chunkContents_ = java.util.Collections.unmodifiableList(chunkContents_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.chunkContents_ = chunkContents_;
          } else {
            result.chunkContents_ = chunkContentsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.title_ = title_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.document_ = document_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.uri_ = uri_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference other) {
          if (other
              == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                  .getDefaultInstance()) return this;
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getDocument().isEmpty()) {
            document_ = other.document_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getUri().isEmpty()) {
            uri_ = other.uri_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (chunkContentsBuilder_ == null) {
            if (!other.chunkContents_.isEmpty()) {
              if (chunkContents_.isEmpty()) {
                chunkContents_ = other.chunkContents_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureChunkContentsIsMutable();
                chunkContents_.addAll(other.chunkContents_);
              }
              onChanged();
            }
          } else {
            if (!other.chunkContents_.isEmpty()) {
              if (chunkContentsBuilder_.isEmpty()) {
                chunkContentsBuilder_.dispose();
                chunkContentsBuilder_ = null;
                chunkContents_ = other.chunkContents_;
                bitField0_ = (bitField0_ & ~0x00000008);
                chunkContentsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getChunkContentsFieldBuilder()
                        : null;
              } else {
                chunkContentsBuilder_.addAllMessages(other.chunkContents_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    document_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    uri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                            .ChunkContent
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                                    .ChunkContent.parser(),
                                extensionRegistry);
                    if (chunkContentsBuilder_ == null) {
                      ensureChunkContentsIsMutable();
                      chunkContents_.add(m);
                    } else {
                      chunkContentsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object title_ = "";
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Title of the document.
         * </pre>
         *
         * <code>string title = 1;</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object document_ = "";
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
         * document. Full resource name of the referenced document, in the format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The document.
         */
        public java.lang.String getDocument() {
          java.lang.Object ref = document_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            document_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
         * document. Full resource name of the referenced document, in the format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for document.
         */
        public com.google.protobuf.ByteString getDocumentBytes() {
          java.lang.Object ref = document_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            document_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
         * document. Full resource name of the referenced document, in the format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The document to set.
         * @return This builder for chaining.
         */
        public Builder setDocument(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
         * document. Full resource name of the referenced document, in the format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDocument() {
          document_ = getDefaultInstance().getDocument();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required.
         * [Document.name][google.cloud.discoveryengine.v1.Document.name] of the
         * document. Full resource name of the referenced document, in the format
         * `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;branches/&#42;&#47;documents/&#42;`.
         * </pre>
         *
         * <code>
         * string document = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for document to set.
         * @return This builder for chaining.
         */
        public Builder setDocumentBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          document_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object uri_ = "";
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @return The uri.
         */
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @return The bytes for uri.
         */
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          uri_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {
          uri_ = getDefaultInstance().getUri();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Cloud Storage or HTTP uri for the document.
         * </pre>
         *
         * <code>string uri = 3;</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          uri_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent>
            chunkContents_ = java.util.Collections.emptyList();

        private void ensureChunkContentsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            chunkContents_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContent>(chunkContents_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                    .Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                    .ChunkContentOrBuilder>
            chunkContentsBuilder_;

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent>
            getChunkContentsList() {
          if (chunkContentsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(chunkContents_);
          } else {
            return chunkContentsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public int getChunkContentsCount() {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.size();
          } else {
            return chunkContentsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
            getChunkContents(int index) {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.get(index);
          } else {
            return chunkContentsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder setChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.set(index, value);
            onChanged();
          } else {
            chunkContentsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder setChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                    .Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.set(index, builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.add(value);
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.add(index, value);
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                    .Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.add(builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                    .Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.add(index, builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addAllChunkContents(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                            .ChunkContent>
                values) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, chunkContents_);
            onChanged();
          } else {
            chunkContentsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder clearChunkContents() {
          if (chunkContentsBuilder_ == null) {
            chunkContents_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            chunkContentsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder removeChunkContents(int index) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.remove(index);
            onChanged();
          } else {
            chunkContentsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                .Builder
            getChunkContentsBuilder(int index) {
          return getChunkContentsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                .ChunkContentOrBuilder
            getChunkContentsOrBuilder(int index) {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.get(index);
          } else {
            return chunkContentsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContentOrBuilder>
            getChunkContentsOrBuilderList() {
          if (chunkContentsBuilder_ != null) {
            return chunkContentsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(chunkContents_);
          }
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                .Builder
            addChunkContentsBuilder() {
          return getChunkContentsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                .Builder
            addChunkContentsBuilder(int index) {
          return getChunkContentsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                    .Builder>
            getChunkContentsBuilderList() {
          return getChunkContentsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.ChunkContent
                    .Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                    .ChunkContentOrBuilder>
            getChunkContentsFieldBuilder() {
          if (chunkContentsBuilder_ == null) {
            chunkContentsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContent,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContent.Builder,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                        .ChunkContentOrBuilder>(
                    chunkContents_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            chunkContents_ = null;
          }
          return chunkContentsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference)
      private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference();
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Reference> PARSER =
          new com.google.protobuf.AbstractParser<Reference>() {
            @java.lang.Override
            public Reference parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Reference> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Reference> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SummaryWithMetadataOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The summary.
       */
      java.lang.String getSummary();
      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The bytes for summary.
       */
      com.google.protobuf.ByteString getSummaryBytes();

      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return Whether the citationMetadata field is set.
       */
      boolean hasCitationMetadata();
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return The citationMetadata.
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          getCitationMetadata();
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadataOrBuilder
          getCitationMetadataOrBuilder();

      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference>
          getReferencesList();
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference getReferences(int index);
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      int getReferencesCount();
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder>
          getReferencesOrBuilderList();
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder
          getReferencesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata}
     */
    public static final class SummaryWithMetadata extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata)
        SummaryWithMetadataOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SummaryWithMetadata.newBuilder() to construct.
      private SummaryWithMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SummaryWithMetadata() {
        summary_ = "";
        references_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SummaryWithMetadata();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SummaryWithMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SummaryWithMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                    .class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                    .Builder.class);
      }

      private int bitField0_;
      public static final int SUMMARY_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object summary_ = "";
      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The summary.
       */
      @java.lang.Override
      public java.lang.String getSummary() {
        java.lang.Object ref = summary_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          summary_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Summary text with no citation information.
       * </pre>
       *
       * <code>string summary = 1;</code>
       *
       * @return The bytes for summary.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSummaryBytes() {
        java.lang.Object ref = summary_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          summary_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CITATION_METADATA_FIELD_NUMBER = 2;
      private com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          citationMetadata_;
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return Whether the citationMetadata field is set.
       */
      @java.lang.Override
      public boolean hasCitationMetadata() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       *
       * @return The citationMetadata.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
          getCitationMetadata() {
        return citationMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                .getDefaultInstance()
            : citationMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Citation metadata for given summary.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadataOrBuilder
          getCitationMetadataOrBuilder() {
        return citationMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                .getDefaultInstance()
            : citationMetadata_;
      }

      public static final int REFERENCES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference>
          references_;
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference>
          getReferencesList() {
        return references_;
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder>
          getReferencesOrBuilderList() {
        return references_;
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public int getReferencesCount() {
        return references_.size();
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference getReferences(
          int index) {
        return references_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Document References.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder
          getReferencesOrBuilder(int index) {
        return references_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, summary_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getCitationMetadata());
        }
        for (int i = 0; i < references_.size(); i++) {
          output.writeMessage(3, references_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summary_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, summary_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCitationMetadata());
        }
        for (int i = 0; i < references_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, references_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata other =
            (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata) obj;

        if (!getSummary().equals(other.getSummary())) return false;
        if (hasCitationMetadata() != other.hasCitationMetadata()) return false;
        if (hasCitationMetadata()) {
          if (!getCitationMetadata().equals(other.getCitationMetadata())) return false;
        }
        if (!getReferencesList().equals(other.getReferencesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
        hash = (53 * hash) + getSummary().hashCode();
        if (hasCitationMetadata()) {
          hash = (37 * hash) + CITATION_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getCitationMetadata().hashCode();
        }
        if (getReferencesCount() > 0) {
          hash = (37 * hash) + REFERENCES_FIELD_NUMBER;
          hash = (53 * hash) + getReferencesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata)
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadataOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SummaryWithMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SummaryWithMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                      .class,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getCitationMetadataFieldBuilder();
            getReferencesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          summary_ = "";
          citationMetadata_ = null;
          if (citationMetadataBuilder_ != null) {
            citationMetadataBuilder_.dispose();
            citationMetadataBuilder_ = null;
          }
          if (referencesBuilder_ == null) {
            references_ = java.util.Collections.emptyList();
          } else {
            references_ = null;
            referencesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.SearchServiceProto
              .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_SummaryWithMetadata_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
            build() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
            buildPartial() {
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata result =
              new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata result) {
          if (referencesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              references_ = java.util.Collections.unmodifiableList(references_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.references_ = references_;
          } else {
            result.references_ = referencesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.summary_ = summary_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.citationMetadata_ =
                citationMetadataBuilder_ == null
                    ? citationMetadata_
                    : citationMetadataBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata other) {
          if (other
              == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                  .getDefaultInstance()) return this;
          if (!other.getSummary().isEmpty()) {
            summary_ = other.summary_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasCitationMetadata()) {
            mergeCitationMetadata(other.getCitationMetadata());
          }
          if (referencesBuilder_ == null) {
            if (!other.references_.isEmpty()) {
              if (references_.isEmpty()) {
                references_ = other.references_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureReferencesIsMutable();
                references_.addAll(other.references_);
              }
              onChanged();
            }
          } else {
            if (!other.references_.isEmpty()) {
              if (referencesBuilder_.isEmpty()) {
                referencesBuilder_.dispose();
                referencesBuilder_ = null;
                references_ = other.references_;
                bitField0_ = (bitField0_ & ~0x00000004);
                referencesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getReferencesFieldBuilder()
                        : null;
              } else {
                referencesBuilder_.addAllMessages(other.references_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    summary_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getCitationMetadataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                                .parser(),
                            extensionRegistry);
                    if (referencesBuilder_ == null) {
                      ensureReferencesIsMutable();
                      references_.add(m);
                    } else {
                      referencesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object summary_ = "";
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @return The summary.
         */
        public java.lang.String getSummary() {
          java.lang.Object ref = summary_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            summary_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @return The bytes for summary.
         */
        public com.google.protobuf.ByteString getSummaryBytes() {
          java.lang.Object ref = summary_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            summary_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @param value The summary to set.
         * @return This builder for chaining.
         */
        public Builder setSummary(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          summary_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSummary() {
          summary_ = getDefaultInstance().getSummary();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Summary text with no citation information.
         * </pre>
         *
         * <code>string summary = 1;</code>
         *
         * @param value The bytes for summary to set.
         * @return This builder for chaining.
         */
        public Builder setSummaryBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          summary_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
            citationMetadata_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                    .CitationMetadataOrBuilder>
            citationMetadataBuilder_;
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         *
         * @return Whether the citationMetadata field is set.
         */
        public boolean hasCitationMetadata() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         *
         * @return The citationMetadata.
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
            getCitationMetadata() {
          if (citationMetadataBuilder_ == null) {
            return citationMetadata_ == null
                ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                    .getDefaultInstance()
                : citationMetadata_;
          } else {
            return citationMetadataBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder setCitationMetadata(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata value) {
          if (citationMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            citationMetadata_ = value;
          } else {
            citationMetadataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder setCitationMetadata(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.Builder
                builderForValue) {
          if (citationMetadataBuilder_ == null) {
            citationMetadata_ = builderForValue.build();
          } else {
            citationMetadataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder mergeCitationMetadata(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata value) {
          if (citationMetadataBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && citationMetadata_ != null
                && citationMetadata_
                    != com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                        .getDefaultInstance()) {
              getCitationMetadataBuilder().mergeFrom(value);
            } else {
              citationMetadata_ = value;
            }
          } else {
            citationMetadataBuilder_.mergeFrom(value);
          }
          if (citationMetadata_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public Builder clearCitationMetadata() {
          bitField0_ = (bitField0_ & ~0x00000002);
          citationMetadata_ = null;
          if (citationMetadataBuilder_ != null) {
            citationMetadataBuilder_.dispose();
            citationMetadataBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.Builder
            getCitationMetadataBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getCitationMetadataFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadataOrBuilder
            getCitationMetadataOrBuilder() {
          if (citationMetadataBuilder_ != null) {
            return citationMetadataBuilder_.getMessageOrBuilder();
          } else {
            return citationMetadata_ == null
                ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                    .getDefaultInstance()
                : citationMetadata_;
          }
        }
        /**
         *
         *
         * <pre>
         * Citation metadata for given summary.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata citation_metadata = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                    .CitationMetadataOrBuilder>
            getCitationMetadataFieldBuilder() {
          if (citationMetadataBuilder_ == null) {
            citationMetadataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.CitationMetadata
                        .Builder,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                        .CitationMetadataOrBuilder>(
                    getCitationMetadata(), getParentForChildren(), isClean());
            citationMetadata_ = null;
          }
          return citationMetadataBuilder_;
        }

        private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference>
            references_ = java.util.Collections.emptyList();

        private void ensureReferencesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            references_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference>(
                    references_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder>
            referencesBuilder_;

        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference>
            getReferencesList() {
          if (referencesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(references_);
          } else {
            return referencesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public int getReferencesCount() {
          if (referencesBuilder_ == null) {
            return references_.size();
          } else {
            return referencesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference getReferences(
            int index) {
          if (referencesBuilder_ == null) {
            return references_.get(index);
          } else {
            return referencesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder setReferences(
            int index, com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.set(index, value);
            onChanged();
          } else {
            referencesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder setReferences(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.set(index, builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.add(value);
            onChanged();
          } else {
            referencesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            int index, com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference value) {
          if (referencesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureReferencesIsMutable();
            references_.add(index, value);
            onChanged();
          } else {
            referencesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.add(builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addReferences(
            int index,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder
                builderForValue) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.add(index, builderForValue.build());
            onChanged();
          } else {
            referencesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder addAllReferences(
            java.lang.Iterable<
                    ? extends com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference>
                values) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, references_);
            onChanged();
          } else {
            referencesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder clearReferences() {
          if (referencesBuilder_ == null) {
            references_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            referencesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public Builder removeReferences(int index) {
          if (referencesBuilder_ == null) {
            ensureReferencesIsMutable();
            references_.remove(index);
            onChanged();
          } else {
            referencesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder
            getReferencesBuilder(int index) {
          return getReferencesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder
            getReferencesOrBuilder(int index) {
          if (referencesBuilder_ == null) {
            return references_.get(index);
          } else {
            return referencesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder>
            getReferencesOrBuilderList() {
          if (referencesBuilder_ != null) {
            return referencesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(references_);
          }
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder
            addReferencesBuilder() {
          return getReferencesFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder
            addReferencesBuilder(int index) {
          return getReferencesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Document References.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference references = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder>
            getReferencesBuilderList() {
          return getReferencesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder>
            getReferencesFieldBuilder() {
          if (referencesBuilder_ == null) {
            referencesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Reference.Builder,
                    com.google.cloud.discoveryengine.v1.SearchResponse.Summary.ReferenceOrBuilder>(
                    references_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            references_ = null;
          }
          return referencesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata)
      private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary
              .SummaryWithMetadata
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata();
      }

      public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SummaryWithMetadata> PARSER =
          new com.google.protobuf.AbstractParser<SummaryWithMetadata>() {
            @java.lang.Override
            public SummaryWithMetadata parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SummaryWithMetadata> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SummaryWithMetadata> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int SUMMARY_TEXT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object summaryText_ = "";
    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The summaryText.
     */
    @java.lang.Override
    public java.lang.String getSummaryText() {
      java.lang.Object ref = summaryText_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summaryText_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The summary content.
     * </pre>
     *
     * <code>string summary_text = 1;</code>
     *
     * @return The bytes for summaryText.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSummaryTextBytes() {
      java.lang.Object ref = summaryText_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        summaryText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUMMARY_SKIPPED_REASONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> summarySkippedReasons_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason>
        summarySkippedReasons_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason>() {
              public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason
                  convert(java.lang.Integer from) {
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason
                    result =
                        com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                            .SummarySkippedReason.forNumber(from);
                return result == null
                    ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                        .SummarySkippedReason.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the summarySkippedReasons.
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason>
        getSummarySkippedReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason>(
          summarySkippedReasons_, summarySkippedReasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return The count of summarySkippedReasons.
     */
    @java.lang.Override
    public int getSummarySkippedReasonsCount() {
      return summarySkippedReasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The summarySkippedReasons at the given index.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason
        getSummarySkippedReasons(int index) {
      return summarySkippedReasons_converter_.convert(summarySkippedReasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for summarySkippedReasons.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getSummarySkippedReasonsValueList() {
      return summarySkippedReasons_;
    }
    /**
     *
     *
     * <pre>
     * Additional summary-skipped reasons. This provides the reason for ignored
     * cases. If nothing is skipped, this field is not set.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of summarySkippedReasons at the given index.
     */
    @java.lang.Override
    public int getSummarySkippedReasonsValue(int index) {
      return summarySkippedReasons_.get(index);
    }

    private int summarySkippedReasonsMemoizedSerializedSize;

    public static final int SAFETY_ATTRIBUTES_FIELD_NUMBER = 3;
    private com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
        safetyAttributes_;
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return Whether the safetyAttributes field is set.
     */
    @java.lang.Override
    public boolean hasSafetyAttributes() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     *
     * @return The safetyAttributes.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
        getSafetyAttributes() {
      return safetyAttributes_ == null
          ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
              .getDefaultInstance()
          : safetyAttributes_;
    }
    /**
     *
     *
     * <pre>
     * A collection of Safety Attribute categories and their associated
     * confidence scores.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributesOrBuilder
        getSafetyAttributesOrBuilder() {
      return safetyAttributes_ == null
          ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
              .getDefaultInstance()
          : safetyAttributes_;
    }

    public static final int SUMMARY_WITH_METADATA_FIELD_NUMBER = 4;
    private com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
        summaryWithMetadata_;
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return Whether the summaryWithMetadata field is set.
     */
    @java.lang.Override
    public boolean hasSummaryWithMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     *
     * @return The summaryWithMetadata.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
        getSummaryWithMetadata() {
      return summaryWithMetadata_ == null
          ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
              .getDefaultInstance()
          : summaryWithMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Summary with metadata information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadataOrBuilder
        getSummaryWithMetadataOrBuilder() {
      return summaryWithMetadata_ == null
          ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
              .getDefaultInstance()
          : summaryWithMetadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summaryText_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, summaryText_);
      }
      if (getSummarySkippedReasonsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(summarySkippedReasonsMemoizedSerializedSize);
      }
      for (int i = 0; i < summarySkippedReasons_.size(); i++) {
        output.writeEnumNoTag(summarySkippedReasons_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getSafetyAttributes());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getSummaryWithMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(summaryText_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, summaryText_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < summarySkippedReasons_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  summarySkippedReasons_.get(i));
        }
        size += dataSize;
        if (!getSummarySkippedReasonsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        summarySkippedReasonsMemoizedSerializedSize = dataSize;
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSafetyAttributes());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSummaryWithMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Summary)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.SearchResponse.Summary other =
          (com.google.cloud.discoveryengine.v1.SearchResponse.Summary) obj;

      if (!getSummaryText().equals(other.getSummaryText())) return false;
      if (!summarySkippedReasons_.equals(other.summarySkippedReasons_)) return false;
      if (hasSafetyAttributes() != other.hasSafetyAttributes()) return false;
      if (hasSafetyAttributes()) {
        if (!getSafetyAttributes().equals(other.getSafetyAttributes())) return false;
      }
      if (hasSummaryWithMetadata() != other.hasSummaryWithMetadata()) return false;
      if (hasSummaryWithMetadata()) {
        if (!getSummaryWithMetadata().equals(other.getSummaryWithMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUMMARY_TEXT_FIELD_NUMBER;
      hash = (53 * hash) + getSummaryText().hashCode();
      if (getSummarySkippedReasonsCount() > 0) {
        hash = (37 * hash) + SUMMARY_SKIPPED_REASONS_FIELD_NUMBER;
        hash = (53 * hash) + summarySkippedReasons_.hashCode();
      }
      if (hasSafetyAttributes()) {
        hash = (37 * hash) + SAFETY_ATTRIBUTES_FIELD_NUMBER;
        hash = (53 * hash) + getSafetyAttributes().hashCode();
      }
      if (hasSummaryWithMetadata()) {
        hash = (37 * hash) + SUMMARY_WITH_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getSummaryWithMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Summary of the top N search result specified by the summary spec.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.Summary}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.Summary)
        com.google.cloud.discoveryengine.v1.SearchResponse.SummaryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.SearchResponse.Summary.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSafetyAttributesFieldBuilder();
          getSummaryWithMetadataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        summaryText_ = "";
        summarySkippedReasons_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        safetyAttributes_ = null;
        if (safetyAttributesBuilder_ != null) {
          safetyAttributesBuilder_.dispose();
          safetyAttributesBuilder_ = null;
        }
        summaryWithMetadata_ = null;
        if (summaryWithMetadataBuilder_ != null) {
          summaryWithMetadataBuilder_.dispose();
          summaryWithMetadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_Summary_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.SearchResponse.Summary.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary build() {
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary buildPartial() {
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary result =
            new com.google.cloud.discoveryengine.v1.SearchResponse.Summary(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          summarySkippedReasons_ = java.util.Collections.unmodifiableList(summarySkippedReasons_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.summarySkippedReasons_ = summarySkippedReasons_;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.summaryText_ = summaryText_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.safetyAttributes_ =
              safetyAttributesBuilder_ == null
                  ? safetyAttributes_
                  : safetyAttributesBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.summaryWithMetadata_ =
              summaryWithMetadataBuilder_ == null
                  ? summaryWithMetadata_
                  : summaryWithMetadataBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.SearchResponse.Summary) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.SearchResponse.Summary) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.SearchResponse.Summary other) {
        if (other
            == com.google.cloud.discoveryengine.v1.SearchResponse.Summary.getDefaultInstance())
          return this;
        if (!other.getSummaryText().isEmpty()) {
          summaryText_ = other.summaryText_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.summarySkippedReasons_.isEmpty()) {
          if (summarySkippedReasons_.isEmpty()) {
            summarySkippedReasons_ = other.summarySkippedReasons_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSummarySkippedReasonsIsMutable();
            summarySkippedReasons_.addAll(other.summarySkippedReasons_);
          }
          onChanged();
        }
        if (other.hasSafetyAttributes()) {
          mergeSafetyAttributes(other.getSafetyAttributes());
        }
        if (other.hasSummaryWithMetadata()) {
          mergeSummaryWithMetadata(other.getSummaryWithMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  summaryText_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  int tmpRaw = input.readEnum();
                  ensureSummarySkippedReasonsIsMutable();
                  summarySkippedReasons_.add(tmpRaw);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureSummarySkippedReasonsIsMutable();
                    summarySkippedReasons_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getSafetyAttributesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getSummaryWithMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object summaryText_ = "";
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @return The summaryText.
       */
      public java.lang.String getSummaryText() {
        java.lang.Object ref = summaryText_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          summaryText_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @return The bytes for summaryText.
       */
      public com.google.protobuf.ByteString getSummaryTextBytes() {
        java.lang.Object ref = summaryText_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          summaryText_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @param value The summaryText to set.
       * @return This builder for chaining.
       */
      public Builder setSummaryText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        summaryText_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSummaryText() {
        summaryText_ = getDefaultInstance().getSummaryText();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The summary content.
       * </pre>
       *
       * <code>string summary_text = 1;</code>
       *
       * @param value The bytes for summaryText to set.
       * @return This builder for chaining.
       */
      public Builder setSummaryTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        summaryText_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> summarySkippedReasons_ =
          java.util.Collections.emptyList();

      private void ensureSummarySkippedReasonsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          summarySkippedReasons_ =
              new java.util.ArrayList<java.lang.Integer>(summarySkippedReasons_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return A list containing the summarySkippedReasons.
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason>
          getSummarySkippedReasonsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason>(
            summarySkippedReasons_, summarySkippedReasons_converter_);
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return The count of summarySkippedReasons.
       */
      public int getSummarySkippedReasonsCount() {
        return summarySkippedReasons_.size();
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The summarySkippedReasons at the given index.
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason
          getSummarySkippedReasons(int index) {
        return summarySkippedReasons_converter_.convert(summarySkippedReasons_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The summarySkippedReasons to set.
       * @return This builder for chaining.
       */
      public Builder setSummarySkippedReasons(
          int index,
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param value The summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addSummarySkippedReasons(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param values The summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addAllSummarySkippedReasons(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                          .SummarySkippedReason>
              values) {
        ensureSummarySkippedReasonsIsMutable();
        for (com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason value :
            values) {
          summarySkippedReasons_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSummarySkippedReasons() {
        summarySkippedReasons_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for summarySkippedReasons.
       */
      public java.util.List<java.lang.Integer> getSummarySkippedReasonsValueList() {
        return java.util.Collections.unmodifiableList(summarySkippedReasons_);
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of summarySkippedReasons at the given index.
       */
      public int getSummarySkippedReasonsValue(int index) {
        return summarySkippedReasons_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for summarySkippedReasons to set.
       * @return This builder for chaining.
       */
      public Builder setSummarySkippedReasonsValue(int index, int value) {
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addSummarySkippedReasonsValue(int value) {
        ensureSummarySkippedReasonsIsMutable();
        summarySkippedReasons_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Additional summary-skipped reasons. This provides the reason for ignored
       * cases. If nothing is skipped, this field is not set.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummarySkippedReason summary_skipped_reasons = 2;
       * </code>
       *
       * @param values The enum numeric values on the wire for summarySkippedReasons to add.
       * @return This builder for chaining.
       */
      public Builder addAllSummarySkippedReasonsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureSummarySkippedReasonsIsMutable();
        for (int value : values) {
          summarySkippedReasons_.add(value);
        }
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          safetyAttributes_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.Builder,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributesOrBuilder>
          safetyAttributesBuilder_;
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       *
       * @return Whether the safetyAttributes field is set.
       */
      public boolean hasSafetyAttributes() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       *
       * @return The safetyAttributes.
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
          getSafetyAttributes() {
        if (safetyAttributesBuilder_ == null) {
          return safetyAttributes_ == null
              ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
                  .getDefaultInstance()
              : safetyAttributes_;
        } else {
          return safetyAttributesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder setSafetyAttributes(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes value) {
        if (safetyAttributesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          safetyAttributes_ = value;
        } else {
          safetyAttributesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder setSafetyAttributes(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.Builder
              builderForValue) {
        if (safetyAttributesBuilder_ == null) {
          safetyAttributes_ = builderForValue.build();
        } else {
          safetyAttributesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder mergeSafetyAttributes(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes value) {
        if (safetyAttributesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && safetyAttributes_ != null
              && safetyAttributes_
                  != com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
                      .getDefaultInstance()) {
            getSafetyAttributesBuilder().mergeFrom(value);
          } else {
            safetyAttributes_ = value;
          }
        } else {
          safetyAttributesBuilder_.mergeFrom(value);
        }
        if (safetyAttributes_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public Builder clearSafetyAttributes() {
        bitField0_ = (bitField0_ & ~0x00000004);
        safetyAttributes_ = null;
        if (safetyAttributesBuilder_ != null) {
          safetyAttributesBuilder_.dispose();
          safetyAttributesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.Builder
          getSafetyAttributesBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSafetyAttributesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributesOrBuilder
          getSafetyAttributesOrBuilder() {
        if (safetyAttributesBuilder_ != null) {
          return safetyAttributesBuilder_.getMessageOrBuilder();
        } else {
          return safetyAttributes_ == null
              ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
                  .getDefaultInstance()
              : safetyAttributes_;
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of Safety Attribute categories and their associated
       * confidence scores.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes safety_attributes = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes.Builder,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributesOrBuilder>
          getSafetyAttributesFieldBuilder() {
        if (safetyAttributesBuilder_ == null) {
          safetyAttributesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SafetyAttributes
                      .Builder,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                      .SafetyAttributesOrBuilder>(
                  getSafetyAttributes(), getParentForChildren(), isClean());
          safetyAttributes_ = null;
        }
        return safetyAttributesBuilder_;
      }

      private com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          summaryWithMetadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                  .Builder,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                  .SummaryWithMetadataOrBuilder>
          summaryWithMetadataBuilder_;
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       *
       * @return Whether the summaryWithMetadata field is set.
       */
      public boolean hasSummaryWithMetadata() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       *
       * @return The summaryWithMetadata.
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
          getSummaryWithMetadata() {
        if (summaryWithMetadataBuilder_ == null) {
          return summaryWithMetadata_ == null
              ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                  .getDefaultInstance()
              : summaryWithMetadata_;
        } else {
          return summaryWithMetadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder setSummaryWithMetadata(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata value) {
        if (summaryWithMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          summaryWithMetadata_ = value;
        } else {
          summaryWithMetadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder setSummaryWithMetadata(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata.Builder
              builderForValue) {
        if (summaryWithMetadataBuilder_ == null) {
          summaryWithMetadata_ = builderForValue.build();
        } else {
          summaryWithMetadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder mergeSummaryWithMetadata(
          com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata value) {
        if (summaryWithMetadataBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && summaryWithMetadata_ != null
              && summaryWithMetadata_
                  != com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                      .getDefaultInstance()) {
            getSummaryWithMetadataBuilder().mergeFrom(value);
          } else {
            summaryWithMetadata_ = value;
          }
        } else {
          summaryWithMetadataBuilder_.mergeFrom(value);
        }
        if (summaryWithMetadata_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public Builder clearSummaryWithMetadata() {
        bitField0_ = (bitField0_ & ~0x00000008);
        summaryWithMetadata_ = null;
        if (summaryWithMetadataBuilder_ != null) {
          summaryWithMetadataBuilder_.dispose();
          summaryWithMetadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata.Builder
          getSummaryWithMetadataBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getSummaryWithMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadataOrBuilder
          getSummaryWithMetadataOrBuilder() {
        if (summaryWithMetadataBuilder_ != null) {
          return summaryWithMetadataBuilder_.getMessageOrBuilder();
        } else {
          return summaryWithMetadata_ == null
              ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                  .getDefaultInstance()
              : summaryWithMetadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Summary with metadata information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata summary_with_metadata = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                  .Builder,
              com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                  .SummaryWithMetadataOrBuilder>
          getSummaryWithMetadataFieldBuilder() {
        if (summaryWithMetadataBuilder_ == null) {
          summaryWithMetadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary.SummaryWithMetadata
                      .Builder,
                  com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                      .SummaryWithMetadataOrBuilder>(
                  getSummaryWithMetadata(), getParentForChildren(), isClean());
          summaryWithMetadata_ = null;
        }
        return summaryWithMetadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.Summary)
    private static final com.google.cloud.discoveryengine.v1.SearchResponse.Summary
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.SearchResponse.Summary();
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.Summary getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Summary> PARSER =
        new com.google.protobuf.AbstractParser<Summary>() {
          @java.lang.Override
          public Summary parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Summary> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Summary> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryExpansionInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Bool describing whether query expansion has occurred.
     * </pre>
     *
     * <code>bool expanded_query = 1;</code>
     *
     * @return The expandedQuery.
     */
    boolean getExpandedQuery();

    /**
     *
     *
     * <pre>
     * Number of pinned results. This field will only be set when expansion
     * happens and
     * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
     * is set to true.
     * </pre>
     *
     * <code>int64 pinned_result_count = 2;</code>
     *
     * @return The pinnedResultCount.
     */
    long getPinnedResultCount();
  }
  /**
   *
   *
   * <pre>
   * Information describing query expansion including whether expansion has
   * occurred.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo}
   */
  public static final class QueryExpansionInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo)
      QueryExpansionInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryExpansionInfo.newBuilder() to construct.
    private QueryExpansionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryExpansionInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryExpansionInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_QueryExpansionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_QueryExpansionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.class,
              com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.Builder.class);
    }

    public static final int EXPANDED_QUERY_FIELD_NUMBER = 1;
    private boolean expandedQuery_ = false;
    /**
     *
     *
     * <pre>
     * Bool describing whether query expansion has occurred.
     * </pre>
     *
     * <code>bool expanded_query = 1;</code>
     *
     * @return The expandedQuery.
     */
    @java.lang.Override
    public boolean getExpandedQuery() {
      return expandedQuery_;
    }

    public static final int PINNED_RESULT_COUNT_FIELD_NUMBER = 2;
    private long pinnedResultCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of pinned results. This field will only be set when expansion
     * happens and
     * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
     * is set to true.
     * </pre>
     *
     * <code>int64 pinned_result_count = 2;</code>
     *
     * @return The pinnedResultCount.
     */
    @java.lang.Override
    public long getPinnedResultCount() {
      return pinnedResultCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (expandedQuery_ != false) {
        output.writeBool(1, expandedQuery_);
      }
      if (pinnedResultCount_ != 0L) {
        output.writeInt64(2, pinnedResultCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (expandedQuery_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, expandedQuery_);
      }
      if (pinnedResultCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, pinnedResultCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo other =
          (com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo) obj;

      if (getExpandedQuery() != other.getExpandedQuery()) return false;
      if (getPinnedResultCount() != other.getPinnedResultCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + EXPANDED_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExpandedQuery());
      hash = (37 * hash) + PINNED_RESULT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPinnedResultCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information describing query expansion including whether expansion has
     * occurred.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo)
        com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_QueryExpansionInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_QueryExpansionInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.class,
                com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        expandedQuery_ = false;
        pinnedResultCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.SearchServiceProto
            .internal_static_google_cloud_discoveryengine_v1_SearchResponse_QueryExpansionInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo build() {
        com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo buildPartial() {
        com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo result =
            new com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.expandedQuery_ = expandedQuery_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pinnedResultCount_ = pinnedResultCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo other) {
        if (other
            == com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
                .getDefaultInstance()) return this;
        if (other.getExpandedQuery() != false) {
          setExpandedQuery(other.getExpandedQuery());
        }
        if (other.getPinnedResultCount() != 0L) {
          setPinnedResultCount(other.getPinnedResultCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  expandedQuery_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  pinnedResultCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean expandedQuery_;
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @return The expandedQuery.
       */
      @java.lang.Override
      public boolean getExpandedQuery() {
        return expandedQuery_;
      }
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @param value The expandedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setExpandedQuery(boolean value) {

        expandedQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Bool describing whether query expansion has occurred.
       * </pre>
       *
       * <code>bool expanded_query = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExpandedQuery() {
        bitField0_ = (bitField0_ & ~0x00000001);
        expandedQuery_ = false;
        onChanged();
        return this;
      }

      private long pinnedResultCount_;
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @return The pinnedResultCount.
       */
      @java.lang.Override
      public long getPinnedResultCount() {
        return pinnedResultCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @param value The pinnedResultCount to set.
       * @return This builder for chaining.
       */
      public Builder setPinnedResultCount(long value) {

        pinnedResultCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of pinned results. This field will only be set when expansion
       * happens and
       * [SearchRequest.QueryExpansionSpec.pin_unexpanded_results][google.cloud.discoveryengine.v1.SearchRequest.QueryExpansionSpec.pin_unexpanded_results]
       * is set to true.
       * </pre>
       *
       * <code>int64 pinned_result_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPinnedResultCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pinnedResultCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo)
    private static final com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo();
    }

    public static com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryExpansionInfo> PARSER =
        new com.google.protobuf.AbstractParser<QueryExpansionInfo>() {
          @java.lang.Override
          public QueryExpansionInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryExpansionInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryExpansionInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RESULTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult> results_;
  /**
   *
   *
   * <pre>
   * A list of matched documents. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult>
      getResultsList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * A list of matched documents. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * A list of matched documents. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of matched documents. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult getResults(int index) {
    return results_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of matched documents. The order represents the ranking.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder
      getResultsOrBuilder(int index) {
    return results_.get(index);
  }

  public static final int FACETS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet> facets_;
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet> getFacetsList() {
    return facets_;
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder>
      getFacetsOrBuilderList() {
    return facets_;
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public int getFacetsCount() {
    return facets_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.Facet getFacets(int index) {
    return facets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of facets requested by user.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder getFacetsOrBuilder(
      int index) {
    return facets_.get(index);
  }

  public static final int TOTAL_SIZE_FIELD_NUMBER = 3;
  private int totalSize_ = 0;
  /**
   *
   *
   * <pre>
   * The estimated total count of matched items irrespective of pagination. The
   * count of [results][google.cloud.discoveryengine.v1.SearchResponse.results]
   * returned by pagination may be less than the
   * [total_size][google.cloud.discoveryengine.v1.SearchResponse.total_size]
   * that matches.
   * </pre>
   *
   * <code>int32 total_size = 3;</code>
   *
   * @return The totalSize.
   */
  @java.lang.Override
  public int getTotalSize() {
    return totalSize_;
  }

  public static final int ATTRIBUTION_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object attributionToken_ = "";
  /**
   *
   *
   * <pre>
   * A unique search token. This should be included in the
   * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
   * this search, which enables accurate attribution of search model
   * performance.
   * </pre>
   *
   * <code>string attribution_token = 4;</code>
   *
   * @return The attributionToken.
   */
  @java.lang.Override
  public java.lang.String getAttributionToken() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attributionToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique search token. This should be included in the
   * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
   * this search, which enables accurate attribution of search model
   * performance.
   * </pre>
   *
   * <code>string attribution_token = 4;</code>
   *
   * @return The bytes for attributionToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttributionTokenBytes() {
    java.lang.Object ref = attributionToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attributionToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REDIRECT_URI_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object redirectUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI of a customer-defined redirect page. If redirect action is
   * triggered, no search is performed, and only
   * [redirect_uri][google.cloud.discoveryengine.v1.SearchResponse.redirect_uri]
   * and
   * [attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token]
   * are set in the response.
   * </pre>
   *
   * <code>string redirect_uri = 12;</code>
   *
   * @return The redirectUri.
   */
  @java.lang.Override
  public java.lang.String getRedirectUri() {
    java.lang.Object ref = redirectUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      redirectUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI of a customer-defined redirect page. If redirect action is
   * triggered, no search is performed, and only
   * [redirect_uri][google.cloud.discoveryengine.v1.SearchResponse.redirect_uri]
   * and
   * [attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token]
   * are set in the response.
   * </pre>
   *
   * <code>string redirect_uri = 12;</code>
   *
   * @return The bytes for redirectUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRedirectUriBytes() {
    java.lang.Object ref = redirectUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      redirectUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token that can be sent as
   * [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
   * to retrieve the next page. If this field is omitted, there are no
   * subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 5;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token that can be sent as
   * [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
   * to retrieve the next page. If this field is omitted, there are no
   * subsequent pages.
   * </pre>
   *
   * <code>string next_page_token = 5;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CORRECTED_QUERY_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object correctedQuery_ = "";
  /**
   *
   *
   * <pre>
   * Contains the spell corrected query, if found. If the spell correction type
   * is AUTOMATIC, then the search results are based on corrected_query.
   * Otherwise the original query is used for search.
   * </pre>
   *
   * <code>string corrected_query = 7;</code>
   *
   * @return The correctedQuery.
   */
  @java.lang.Override
  public java.lang.String getCorrectedQuery() {
    java.lang.Object ref = correctedQuery_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      correctedQuery_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Contains the spell corrected query, if found. If the spell correction type
   * is AUTOMATIC, then the search results are based on corrected_query.
   * Otherwise the original query is used for search.
   * </pre>
   *
   * <code>string corrected_query = 7;</code>
   *
   * @return The bytes for correctedQuery.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCorrectedQueryBytes() {
    java.lang.Object ref = correctedQuery_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      correctedQuery_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUMMARY_FIELD_NUMBER = 9;
  private com.google.cloud.discoveryengine.v1.SearchResponse.Summary summary_;
  /**
   *
   *
   * <pre>
   * A summary as part of the search results.
   * This field is only returned if
   * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
   * is set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
   *
   * @return Whether the summary field is set.
   */
  @java.lang.Override
  public boolean hasSummary() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A summary as part of the search results.
   * This field is only returned if
   * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
   * is set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
   *
   * @return The summary.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.Summary getSummary() {
    return summary_ == null
        ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.getDefaultInstance()
        : summary_;
  }
  /**
   *
   *
   * <pre>
   * A summary as part of the search results.
   * This field is only returned if
   * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
   * is set.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.SummaryOrBuilder getSummaryOrBuilder() {
    return summary_ == null
        ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.getDefaultInstance()
        : summary_;
  }

  public static final int QUERY_EXPANSION_INFO_FIELD_NUMBER = 14;
  private com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo queryExpansionInfo_;
  /**
   *
   *
   * <pre>
   * Query expansion information for the returned results.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
   * </code>
   *
   * @return Whether the queryExpansionInfo field is set.
   */
  @java.lang.Override
  public boolean hasQueryExpansionInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Query expansion information for the returned results.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
   * </code>
   *
   * @return The queryExpansionInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
      getQueryExpansionInfo() {
    return queryExpansionInfo_ == null
        ? com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.getDefaultInstance()
        : queryExpansionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Query expansion information for the returned results.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfoOrBuilder
      getQueryExpansionInfoOrBuilder() {
    return queryExpansionInfo_ == null
        ? com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.getDefaultInstance()
        : queryExpansionInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(1, results_.get(i));
    }
    for (int i = 0; i < facets_.size(); i++) {
      output.writeMessage(2, facets_.get(i));
    }
    if (totalSize_ != 0) {
      output.writeInt32(3, totalSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, nextPageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(correctedQuery_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, correctedQuery_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getSummary());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, redirectUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(14, getQueryExpansionInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, results_.get(i));
    }
    for (int i = 0; i < facets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, facets_.get(i));
    }
    if (totalSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, totalSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributionToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, attributionToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, nextPageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(correctedQuery_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, correctedQuery_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSummary());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, redirectUri_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getQueryExpansionInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.SearchResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.SearchResponse other =
        (com.google.cloud.discoveryengine.v1.SearchResponse) obj;

    if (!getResultsList().equals(other.getResultsList())) return false;
    if (!getFacetsList().equals(other.getFacetsList())) return false;
    if (getTotalSize() != other.getTotalSize()) return false;
    if (!getAttributionToken().equals(other.getAttributionToken())) return false;
    if (!getRedirectUri().equals(other.getRedirectUri())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getCorrectedQuery().equals(other.getCorrectedQuery())) return false;
    if (hasSummary() != other.hasSummary()) return false;
    if (hasSummary()) {
      if (!getSummary().equals(other.getSummary())) return false;
    }
    if (hasQueryExpansionInfo() != other.hasQueryExpansionInfo()) return false;
    if (hasQueryExpansionInfo()) {
      if (!getQueryExpansionInfo().equals(other.getQueryExpansionInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    if (getFacetsCount() > 0) {
      hash = (37 * hash) + FACETS_FIELD_NUMBER;
      hash = (53 * hash) + getFacetsList().hashCode();
    }
    hash = (37 * hash) + TOTAL_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getTotalSize();
    hash = (37 * hash) + ATTRIBUTION_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getAttributionToken().hashCode();
    hash = (37 * hash) + REDIRECT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRedirectUri().hashCode();
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (37 * hash) + CORRECTED_QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getCorrectedQuery().hashCode();
    if (hasSummary()) {
      hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getSummary().hashCode();
    }
    if (hasQueryExpansionInfo()) {
      hash = (37 * hash) + QUERY_EXPANSION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getQueryExpansionInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.SearchResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for
   * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.SearchResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.SearchResponse)
      com.google.cloud.discoveryengine.v1.SearchResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.SearchResponse.class,
              com.google.cloud.discoveryengine.v1.SearchResponse.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.SearchResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultsFieldBuilder();
        getFacetsFieldBuilder();
        getSummaryFieldBuilder();
        getQueryExpansionInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
      } else {
        results_ = null;
        resultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (facetsBuilder_ == null) {
        facets_ = java.util.Collections.emptyList();
      } else {
        facets_ = null;
        facetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      totalSize_ = 0;
      attributionToken_ = "";
      redirectUri_ = "";
      nextPageToken_ = "";
      correctedQuery_ = "";
      summary_ = null;
      if (summaryBuilder_ != null) {
        summaryBuilder_.dispose();
        summaryBuilder_ = null;
      }
      queryExpansionInfo_ = null;
      if (queryExpansionInfoBuilder_ != null) {
        queryExpansionInfoBuilder_.dispose();
        queryExpansionInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.SearchServiceProto
          .internal_static_google_cloud_discoveryengine_v1_SearchResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.SearchResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse build() {
      com.google.cloud.discoveryengine.v1.SearchResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchResponse buildPartial() {
      com.google.cloud.discoveryengine.v1.SearchResponse result =
          new com.google.cloud.discoveryengine.v1.SearchResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1.SearchResponse result) {
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
      if (facetsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          facets_ = java.util.Collections.unmodifiableList(facets_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.facets_ = facets_;
      } else {
        result.facets_ = facetsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.SearchResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.totalSize_ = totalSize_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.attributionToken_ = attributionToken_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.redirectUri_ = redirectUri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.correctedQuery_ = correctedQuery_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.summary_ = summaryBuilder_ == null ? summary_ : summaryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.queryExpansionInfo_ =
            queryExpansionInfoBuilder_ == null
                ? queryExpansionInfo_
                : queryExpansionInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.SearchResponse) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.SearchResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.SearchResponse other) {
      if (other == com.google.cloud.discoveryengine.v1.SearchResponse.getDefaultInstance())
        return this;
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (facetsBuilder_ == null) {
        if (!other.facets_.isEmpty()) {
          if (facets_.isEmpty()) {
            facets_ = other.facets_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFacetsIsMutable();
            facets_.addAll(other.facets_);
          }
          onChanged();
        }
      } else {
        if (!other.facets_.isEmpty()) {
          if (facetsBuilder_.isEmpty()) {
            facetsBuilder_.dispose();
            facetsBuilder_ = null;
            facets_ = other.facets_;
            bitField0_ = (bitField0_ & ~0x00000002);
            facetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFacetsFieldBuilder()
                    : null;
          } else {
            facetsBuilder_.addAllMessages(other.facets_);
          }
        }
      }
      if (other.getTotalSize() != 0) {
        setTotalSize(other.getTotalSize());
      }
      if (!other.getAttributionToken().isEmpty()) {
        attributionToken_ = other.attributionToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getRedirectUri().isEmpty()) {
        redirectUri_ = other.redirectUri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getCorrectedQuery().isEmpty()) {
        correctedQuery_ = other.correctedQuery_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasSummary()) {
        mergeSummary(other.getSummary());
      }
      if (other.hasQueryExpansionInfo()) {
        mergeQueryExpansionInfo(other.getQueryExpansionInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.parser(),
                        extensionRegistry);
                if (resultsBuilder_ == null) {
                  ensureResultsIsMutable();
                  results_.add(m);
                } else {
                  resultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.SearchResponse.Facet.parser(),
                        extensionRegistry);
                if (facetsBuilder_ == null) {
                  ensureFacetsIsMutable();
                  facets_.add(m);
                } else {
                  facetsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                totalSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                attributionToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 58:
              {
                correctedQuery_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getSummaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 98:
              {
                redirectUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 98
            case 114:
              {
                input.readMessage(
                    getQueryExpansionInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult>
        results_ = java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        results_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult>(results_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult,
            com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult>
        getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder setResults(
        int index, com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder setResults(
        int index,
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder addResults(
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder addResults(
        int index, com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder addResults(
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder addResults(
        int index,
        com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder addAllResults(
        java.lang.Iterable<
                ? extends com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder
        getResultsBuilder(int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder
        getResultsOrBuilder(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder
        addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder
        addResultsBuilder(int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of matched documents. The order represents the ranking.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.SearchResult results = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult,
            com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult,
                com.google.cloud.discoveryengine.v1.SearchResponse.SearchResult.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.SearchResultOrBuilder>(
                results_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet> facets_ =
        java.util.Collections.emptyList();

    private void ensureFacetsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        facets_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.SearchResponse.Facet>(
                facets_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.Facet,
            com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder>
        facetsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet>
        getFacetsList() {
      if (facetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(facets_);
      } else {
        return facetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public int getFacetsCount() {
      if (facetsBuilder_ == null) {
        return facets_.size();
      } else {
        return facetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.Facet getFacets(int index) {
      if (facetsBuilder_ == null) {
        return facets_.get(index);
      } else {
        return facetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder setFacets(
        int index, com.google.cloud.discoveryengine.v1.SearchResponse.Facet value) {
      if (facetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetsIsMutable();
        facets_.set(index, value);
        onChanged();
      } else {
        facetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder setFacets(
        int index,
        com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder builderForValue) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.set(index, builderForValue.build());
        onChanged();
      } else {
        facetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(com.google.cloud.discoveryengine.v1.SearchResponse.Facet value) {
      if (facetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetsIsMutable();
        facets_.add(value);
        onChanged();
      } else {
        facetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(
        int index, com.google.cloud.discoveryengine.v1.SearchResponse.Facet value) {
      if (facetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFacetsIsMutable();
        facets_.add(index, value);
        onChanged();
      } else {
        facetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(
        com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder builderForValue) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.add(builderForValue.build());
        onChanged();
      } else {
        facetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addFacets(
        int index,
        com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder builderForValue) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.add(index, builderForValue.build());
        onChanged();
      } else {
        facetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder addAllFacets(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.SearchResponse.Facet>
            values) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, facets_);
        onChanged();
      } else {
        facetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder clearFacets() {
      if (facetsBuilder_ == null) {
        facets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        facetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public Builder removeFacets(int index) {
      if (facetsBuilder_ == null) {
        ensureFacetsIsMutable();
        facets_.remove(index);
        onChanged();
      } else {
        facetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder getFacetsBuilder(
        int index) {
      return getFacetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder getFacetsOrBuilder(
        int index) {
      if (facetsBuilder_ == null) {
        return facets_.get(index);
      } else {
        return facetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder>
        getFacetsOrBuilderList() {
      if (facetsBuilder_ != null) {
        return facetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(facets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder addFacetsBuilder() {
      return getFacetsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1.SearchResponse.Facet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder addFacetsBuilder(
        int index) {
      return getFacetsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1.SearchResponse.Facet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of facets requested by user.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchResponse.Facet facets = 2;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder>
        getFacetsBuilderList() {
      return getFacetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.Facet,
            com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder>
        getFacetsFieldBuilder() {
      if (facetsBuilder_ == null) {
        facetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet,
                com.google.cloud.discoveryengine.v1.SearchResponse.Facet.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.FacetOrBuilder>(
                facets_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        facets_ = null;
      }
      return facetsBuilder_;
    }

    private int totalSize_;
    /**
     *
     *
     * <pre>
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.discoveryengine.v1.SearchResponse.results]
     * returned by pagination may be less than the
     * [total_size][google.cloud.discoveryengine.v1.SearchResponse.total_size]
     * that matches.
     * </pre>
     *
     * <code>int32 total_size = 3;</code>
     *
     * @return The totalSize.
     */
    @java.lang.Override
    public int getTotalSize() {
      return totalSize_;
    }
    /**
     *
     *
     * <pre>
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.discoveryengine.v1.SearchResponse.results]
     * returned by pagination may be less than the
     * [total_size][google.cloud.discoveryengine.v1.SearchResponse.total_size]
     * that matches.
     * </pre>
     *
     * <code>int32 total_size = 3;</code>
     *
     * @param value The totalSize to set.
     * @return This builder for chaining.
     */
    public Builder setTotalSize(int value) {

      totalSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The estimated total count of matched items irrespective of pagination. The
     * count of [results][google.cloud.discoveryengine.v1.SearchResponse.results]
     * returned by pagination may be less than the
     * [total_size][google.cloud.discoveryengine.v1.SearchResponse.total_size]
     * that matches.
     * </pre>
     *
     * <code>int32 total_size = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      totalSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object attributionToken_ = "";
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this search, which enables accurate attribution of search model
     * performance.
     * </pre>
     *
     * <code>string attribution_token = 4;</code>
     *
     * @return The attributionToken.
     */
    public java.lang.String getAttributionToken() {
      java.lang.Object ref = attributionToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attributionToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this search, which enables accurate attribution of search model
     * performance.
     * </pre>
     *
     * <code>string attribution_token = 4;</code>
     *
     * @return The bytes for attributionToken.
     */
    public com.google.protobuf.ByteString getAttributionTokenBytes() {
      java.lang.Object ref = attributionToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attributionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this search, which enables accurate attribution of search model
     * performance.
     * </pre>
     *
     * <code>string attribution_token = 4;</code>
     *
     * @param value The attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      attributionToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this search, which enables accurate attribution of search model
     * performance.
     * </pre>
     *
     * <code>string attribution_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttributionToken() {
      attributionToken_ = getDefaultInstance().getAttributionToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique search token. This should be included in the
     * [UserEvent][google.cloud.discoveryengine.v1.UserEvent] logs resulting from
     * this search, which enables accurate attribution of search model
     * performance.
     * </pre>
     *
     * <code>string attribution_token = 4;</code>
     *
     * @param value The bytes for attributionToken to set.
     * @return This builder for chaining.
     */
    public Builder setAttributionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      attributionToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object redirectUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.discoveryengine.v1.SearchResponse.redirect_uri]
     * and
     * [attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 12;</code>
     *
     * @return The redirectUri.
     */
    public java.lang.String getRedirectUri() {
      java.lang.Object ref = redirectUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redirectUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.discoveryengine.v1.SearchResponse.redirect_uri]
     * and
     * [attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 12;</code>
     *
     * @return The bytes for redirectUri.
     */
    public com.google.protobuf.ByteString getRedirectUriBytes() {
      java.lang.Object ref = redirectUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redirectUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.discoveryengine.v1.SearchResponse.redirect_uri]
     * and
     * [attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 12;</code>
     *
     * @param value The redirectUri to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      redirectUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.discoveryengine.v1.SearchResponse.redirect_uri]
     * and
     * [attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRedirectUri() {
      redirectUri_ = getDefaultInstance().getRedirectUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI of a customer-defined redirect page. If redirect action is
     * triggered, no search is performed, and only
     * [redirect_uri][google.cloud.discoveryengine.v1.SearchResponse.redirect_uri]
     * and
     * [attribution_token][google.cloud.discoveryengine.v1.SearchResponse.attribution_token]
     * are set in the response.
     * </pre>
     *
     * <code>string redirect_uri = 12;</code>
     *
     * @param value The bytes for redirectUri to set.
     * @return This builder for chaining.
     */
    public Builder setRedirectUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      redirectUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 5;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 5;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 5;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token that can be sent as
     * [SearchRequest.page_token][google.cloud.discoveryengine.v1.SearchRequest.page_token]
     * to retrieve the next page. If this field is omitted, there are no
     * subsequent pages.
     * </pre>
     *
     * <code>string next_page_token = 5;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object correctedQuery_ = "";
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 7;</code>
     *
     * @return The correctedQuery.
     */
    public java.lang.String getCorrectedQuery() {
      java.lang.Object ref = correctedQuery_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        correctedQuery_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 7;</code>
     *
     * @return The bytes for correctedQuery.
     */
    public com.google.protobuf.ByteString getCorrectedQueryBytes() {
      java.lang.Object ref = correctedQuery_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        correctedQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 7;</code>
     *
     * @param value The correctedQuery to set.
     * @return This builder for chaining.
     */
    public Builder setCorrectedQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      correctedQuery_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCorrectedQuery() {
      correctedQuery_ = getDefaultInstance().getCorrectedQuery();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains the spell corrected query, if found. If the spell correction type
     * is AUTOMATIC, then the search results are based on corrected_query.
     * Otherwise the original query is used for search.
     * </pre>
     *
     * <code>string corrected_query = 7;</code>
     *
     * @param value The bytes for correctedQuery to set.
     * @return This builder for chaining.
     */
    public Builder setCorrectedQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      correctedQuery_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.SearchResponse.Summary summary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.SummaryOrBuilder>
        summaryBuilder_;
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     *
     * @return Whether the summary field is set.
     */
    public boolean hasSummary() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     *
     * @return The summary.
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary getSummary() {
      if (summaryBuilder_ == null) {
        return summary_ == null
            ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.getDefaultInstance()
            : summary_;
      } else {
        return summaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     */
    public Builder setSummary(com.google.cloud.discoveryengine.v1.SearchResponse.Summary value) {
      if (summaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        summary_ = value;
      } else {
        summaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     */
    public Builder setSummary(
        com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Builder builderForValue) {
      if (summaryBuilder_ == null) {
        summary_ = builderForValue.build();
      } else {
        summaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     */
    public Builder mergeSummary(com.google.cloud.discoveryengine.v1.SearchResponse.Summary value) {
      if (summaryBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && summary_ != null
            && summary_
                != com.google.cloud.discoveryengine.v1.SearchResponse.Summary
                    .getDefaultInstance()) {
          getSummaryBuilder().mergeFrom(value);
        } else {
          summary_ = value;
        }
      } else {
        summaryBuilder_.mergeFrom(value);
      }
      if (summary_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     */
    public Builder clearSummary() {
      bitField0_ = (bitField0_ & ~0x00000080);
      summary_ = null;
      if (summaryBuilder_ != null) {
        summaryBuilder_.dispose();
        summaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Builder getSummaryBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getSummaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.SummaryOrBuilder
        getSummaryOrBuilder() {
      if (summaryBuilder_ != null) {
        return summaryBuilder_.getMessageOrBuilder();
      } else {
        return summary_ == null
            ? com.google.cloud.discoveryengine.v1.SearchResponse.Summary.getDefaultInstance()
            : summary_;
      }
    }
    /**
     *
     *
     * <pre>
     * A summary as part of the search results.
     * This field is only returned if
     * [SearchRequest.ContentSearchSpec.summary_spec][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.summary_spec]
     * is set.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchResponse.Summary summary = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary,
            com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.SummaryOrBuilder>
        getSummaryFieldBuilder() {
      if (summaryBuilder_ == null) {
        summaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary,
                com.google.cloud.discoveryengine.v1.SearchResponse.Summary.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.SummaryOrBuilder>(
                getSummary(), getParentForChildren(), isClean());
        summary_ = null;
      }
      return summaryBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
        queryExpansionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo,
            com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfoOrBuilder>
        queryExpansionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     *
     * @return Whether the queryExpansionInfo field is set.
     */
    public boolean hasQueryExpansionInfo() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     *
     * @return The queryExpansionInfo.
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
        getQueryExpansionInfo() {
      if (queryExpansionInfoBuilder_ == null) {
        return queryExpansionInfo_ == null
            ? com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
                .getDefaultInstance()
            : queryExpansionInfo_;
      } else {
        return queryExpansionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     */
    public Builder setQueryExpansionInfo(
        com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo value) {
      if (queryExpansionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryExpansionInfo_ = value;
      } else {
        queryExpansionInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     */
    public Builder setQueryExpansionInfo(
        com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.Builder
            builderForValue) {
      if (queryExpansionInfoBuilder_ == null) {
        queryExpansionInfo_ = builderForValue.build();
      } else {
        queryExpansionInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     */
    public Builder mergeQueryExpansionInfo(
        com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo value) {
      if (queryExpansionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && queryExpansionInfo_ != null
            && queryExpansionInfo_
                != com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
                    .getDefaultInstance()) {
          getQueryExpansionInfoBuilder().mergeFrom(value);
        } else {
          queryExpansionInfo_ = value;
        }
      } else {
        queryExpansionInfoBuilder_.mergeFrom(value);
      }
      if (queryExpansionInfo_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     */
    public Builder clearQueryExpansionInfo() {
      bitField0_ = (bitField0_ & ~0x00000100);
      queryExpansionInfo_ = null;
      if (queryExpansionInfoBuilder_ != null) {
        queryExpansionInfoBuilder_.dispose();
        queryExpansionInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.Builder
        getQueryExpansionInfoBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getQueryExpansionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfoOrBuilder
        getQueryExpansionInfoOrBuilder() {
      if (queryExpansionInfoBuilder_ != null) {
        return queryExpansionInfoBuilder_.getMessageOrBuilder();
      } else {
        return queryExpansionInfo_ == null
            ? com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo
                .getDefaultInstance()
            : queryExpansionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Query expansion information for the returned results.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo query_expansion_info = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo,
            com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.Builder,
            com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfoOrBuilder>
        getQueryExpansionInfoFieldBuilder() {
      if (queryExpansionInfoBuilder_ == null) {
        queryExpansionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo,
                com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfo.Builder,
                com.google.cloud.discoveryengine.v1.SearchResponse.QueryExpansionInfoOrBuilder>(
                getQueryExpansionInfo(), getParentForChildren(), isClean());
        queryExpansionInfo_ = null;
      }
      return queryExpansionInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.SearchResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.SearchResponse)
  private static final com.google.cloud.discoveryengine.v1.SearchResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.SearchResponse();
  }

  public static com.google.cloud.discoveryengine.v1.SearchResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchResponse> PARSER =
      new com.google.protobuf.AbstractParser<SearchResponse>() {
        @java.lang.Override
        public SearchResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
