/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/chunk.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Chunk captures all raw metadata information of items to be recommended or
 * searched in the chunk mode.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk}
 */
public final class Chunk extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Chunk)
    ChunkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Chunk.newBuilder() to construct.
  private Chunk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Chunk() {
    name_ = "";
    id_ = "";
    content_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Chunk();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.ChunkProto
        .internal_static_google_cloud_discoveryengine_v1_Chunk_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.ChunkProto
        .internal_static_google_cloud_discoveryengine_v1_Chunk_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.Chunk.class,
            com.google.cloud.discoveryengine.v1.Chunk.Builder.class);
  }

  public interface DocumentMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Chunk.DocumentMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Uri of the document.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Uri of the document.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * Title of the document.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();
    /**
     *
     *
     * <pre>
     * Title of the document.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * Data representation.
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 3;</code>
     *
     * @return Whether the structData field is set.
     */
    boolean hasStructData();
    /**
     *
     *
     * <pre>
     * Data representation.
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 3;</code>
     *
     * @return The structData.
     */
    com.google.protobuf.Struct getStructData();
    /**
     *
     *
     * <pre>
     * Data representation.
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 3;</code>
     */
    com.google.protobuf.StructOrBuilder getStructDataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Document metadata contains the information of the document of the current
   * chunk.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk.DocumentMetadata}
   */
  public static final class DocumentMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Chunk.DocumentMetadata)
      DocumentMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DocumentMetadata.newBuilder() to construct.
    private DocumentMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DocumentMetadata() {
      uri_ = "";
      title_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DocumentMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_DocumentMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_DocumentMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.class,
              com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.Builder.class);
    }

    private int bitField0_;
    public static final int URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Uri of the document.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Uri of the document.
     * </pre>
     *
     * <code>string uri = 1;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TITLE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Title of the document.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Title of the document.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STRUCT_DATA_FIELD_NUMBER = 3;
    private com.google.protobuf.Struct structData_;
    /**
     *
     *
     * <pre>
     * Data representation.
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 3;</code>
     *
     * @return Whether the structData field is set.
     */
    @java.lang.Override
    public boolean hasStructData() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Data representation.
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 3;</code>
     *
     * @return The structData.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getStructData() {
      return structData_ == null ? com.google.protobuf.Struct.getDefaultInstance() : structData_;
    }
    /**
     *
     *
     * <pre>
     * Data representation.
     * The structured JSON data for the document. It should conform to the
     * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
     * `INVALID_ARGUMENT` error is thrown.
     * </pre>
     *
     * <code>.google.protobuf.Struct struct_data = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
      return structData_ == null ? com.google.protobuf.Struct.getDefaultInstance() : structData_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getStructData());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStructData());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata other =
          (com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getTitle().equals(other.getTitle())) return false;
      if (hasStructData() != other.hasStructData()) return false;
      if (hasStructData()) {
        if (!getStructData().equals(other.getStructData())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      if (hasStructData()) {
        hash = (37 * hash) + STRUCT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getStructData().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Document metadata contains the information of the document of the current
     * chunk.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk.DocumentMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Chunk.DocumentMetadata)
        com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_DocumentMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_DocumentMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.class,
                com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStructDataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uri_ = "";
        title_ = "";
        structData_ = null;
        if (structDataBuilder_ != null) {
          structDataBuilder_.dispose();
          structDataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_DocumentMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata build() {
        com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata buildPartial() {
        com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata result =
            new com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.title_ = title_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.structData_ =
              structDataBuilder_ == null ? structData_ : structDataBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.getDefaultInstance())
          return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasStructData()) {
          mergeStructData(other.getStructData());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getStructDataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Uri of the document.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Uri of the document.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Uri of the document.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Uri of the document.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Uri of the document.
       * </pre>
       *
       * <code>string uri = 1;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 2;</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 2;</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 2;</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Title of the document.
       * </pre>
       *
       * <code>string title = 2;</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.Struct structData_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          structDataBuilder_;
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       *
       * @return Whether the structData field is set.
       */
      public boolean hasStructData() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       *
       * @return The structData.
       */
      public com.google.protobuf.Struct getStructData() {
        if (structDataBuilder_ == null) {
          return structData_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : structData_;
        } else {
          return structDataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       */
      public Builder setStructData(com.google.protobuf.Struct value) {
        if (structDataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          structData_ = value;
        } else {
          structDataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       */
      public Builder setStructData(com.google.protobuf.Struct.Builder builderForValue) {
        if (structDataBuilder_ == null) {
          structData_ = builderForValue.build();
        } else {
          structDataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       */
      public Builder mergeStructData(com.google.protobuf.Struct value) {
        if (structDataBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && structData_ != null
              && structData_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getStructDataBuilder().mergeFrom(value);
          } else {
            structData_ = value;
          }
        } else {
          structDataBuilder_.mergeFrom(value);
        }
        if (structData_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       */
      public Builder clearStructData() {
        bitField0_ = (bitField0_ & ~0x00000004);
        structData_ = null;
        if (structDataBuilder_ != null) {
          structDataBuilder_.dispose();
          structDataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       */
      public com.google.protobuf.Struct.Builder getStructDataBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStructDataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       */
      public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
        if (structDataBuilder_ != null) {
          return structDataBuilder_.getMessageOrBuilder();
        } else {
          return structData_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : structData_;
        }
      }
      /**
       *
       *
       * <pre>
       * Data representation.
       * The structured JSON data for the document. It should conform to the
       * registered [Schema][google.cloud.discoveryengine.v1.Schema] or an
       * `INVALID_ARGUMENT` error is thrown.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getStructDataFieldBuilder() {
        if (structDataBuilder_ == null) {
          structDataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getStructData(), getParentForChildren(), isClean());
          structData_ = null;
        }
        return structDataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Chunk.DocumentMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Chunk.DocumentMetadata)
    private static final com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata();
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DocumentMetadata> PARSER =
        new com.google.protobuf.AbstractParser<DocumentMetadata>() {
          @java.lang.Override
          public DocumentMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DocumentMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DocumentMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PageSpanOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Chunk.PageSpan)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The start page of the chunk.
     * </pre>
     *
     * <code>int32 page_start = 1;</code>
     *
     * @return The pageStart.
     */
    int getPageStart();

    /**
     *
     *
     * <pre>
     * The end page of the chunk.
     * </pre>
     *
     * <code>int32 page_end = 2;</code>
     *
     * @return The pageEnd.
     */
    int getPageEnd();
  }
  /**
   *
   *
   * <pre>
   * Page span of the chunk.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk.PageSpan}
   */
  public static final class PageSpan extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Chunk.PageSpan)
      PageSpanOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PageSpan.newBuilder() to construct.
    private PageSpan(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PageSpan() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PageSpan();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_PageSpan_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_PageSpan_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Chunk.PageSpan.class,
              com.google.cloud.discoveryengine.v1.Chunk.PageSpan.Builder.class);
    }

    public static final int PAGE_START_FIELD_NUMBER = 1;
    private int pageStart_ = 0;
    /**
     *
     *
     * <pre>
     * The start page of the chunk.
     * </pre>
     *
     * <code>int32 page_start = 1;</code>
     *
     * @return The pageStart.
     */
    @java.lang.Override
    public int getPageStart() {
      return pageStart_;
    }

    public static final int PAGE_END_FIELD_NUMBER = 2;
    private int pageEnd_ = 0;
    /**
     *
     *
     * <pre>
     * The end page of the chunk.
     * </pre>
     *
     * <code>int32 page_end = 2;</code>
     *
     * @return The pageEnd.
     */
    @java.lang.Override
    public int getPageEnd() {
      return pageEnd_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (pageStart_ != 0) {
        output.writeInt32(1, pageStart_);
      }
      if (pageEnd_ != 0) {
        output.writeInt32(2, pageEnd_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (pageStart_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, pageStart_);
      }
      if (pageEnd_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageEnd_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Chunk.PageSpan)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Chunk.PageSpan other =
          (com.google.cloud.discoveryengine.v1.Chunk.PageSpan) obj;

      if (getPageStart() != other.getPageStart()) return false;
      if (getPageEnd() != other.getPageEnd()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PAGE_START_FIELD_NUMBER;
      hash = (53 * hash) + getPageStart();
      hash = (37 * hash) + PAGE_END_FIELD_NUMBER;
      hash = (53 * hash) + getPageEnd();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.discoveryengine.v1.Chunk.PageSpan prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk.PageSpan}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Chunk.PageSpan)
        com.google.cloud.discoveryengine.v1.Chunk.PageSpanOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_PageSpan_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_PageSpan_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Chunk.PageSpan.class,
                com.google.cloud.discoveryengine.v1.Chunk.PageSpan.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Chunk.PageSpan.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pageStart_ = 0;
        pageEnd_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_PageSpan_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.PageSpan getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Chunk.PageSpan.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.PageSpan build() {
        com.google.cloud.discoveryengine.v1.Chunk.PageSpan result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.PageSpan buildPartial() {
        com.google.cloud.discoveryengine.v1.Chunk.PageSpan result =
            new com.google.cloud.discoveryengine.v1.Chunk.PageSpan(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Chunk.PageSpan result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pageStart_ = pageStart_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pageEnd_ = pageEnd_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Chunk.PageSpan) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Chunk.PageSpan) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Chunk.PageSpan other) {
        if (other == com.google.cloud.discoveryengine.v1.Chunk.PageSpan.getDefaultInstance())
          return this;
        if (other.getPageStart() != 0) {
          setPageStart(other.getPageStart());
        }
        if (other.getPageEnd() != 0) {
          setPageEnd(other.getPageEnd());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  pageStart_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  pageEnd_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int pageStart_;
      /**
       *
       *
       * <pre>
       * The start page of the chunk.
       * </pre>
       *
       * <code>int32 page_start = 1;</code>
       *
       * @return The pageStart.
       */
      @java.lang.Override
      public int getPageStart() {
        return pageStart_;
      }
      /**
       *
       *
       * <pre>
       * The start page of the chunk.
       * </pre>
       *
       * <code>int32 page_start = 1;</code>
       *
       * @param value The pageStart to set.
       * @return This builder for chaining.
       */
      public Builder setPageStart(int value) {

        pageStart_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The start page of the chunk.
       * </pre>
       *
       * <code>int32 page_start = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageStart() {
        bitField0_ = (bitField0_ & ~0x00000001);
        pageStart_ = 0;
        onChanged();
        return this;
      }

      private int pageEnd_;
      /**
       *
       *
       * <pre>
       * The end page of the chunk.
       * </pre>
       *
       * <code>int32 page_end = 2;</code>
       *
       * @return The pageEnd.
       */
      @java.lang.Override
      public int getPageEnd() {
        return pageEnd_;
      }
      /**
       *
       *
       * <pre>
       * The end page of the chunk.
       * </pre>
       *
       * <code>int32 page_end = 2;</code>
       *
       * @param value The pageEnd to set.
       * @return This builder for chaining.
       */
      public Builder setPageEnd(int value) {

        pageEnd_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The end page of the chunk.
       * </pre>
       *
       * <code>int32 page_end = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageEnd() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pageEnd_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Chunk.PageSpan)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Chunk.PageSpan)
    private static final com.google.cloud.discoveryengine.v1.Chunk.PageSpan DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Chunk.PageSpan();
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.PageSpan getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PageSpan> PARSER =
        new com.google.protobuf.AbstractParser<PageSpan>() {
          @java.lang.Override
          public PageSpan parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PageSpan> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PageSpan> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk.PageSpan getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ChunkMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Chunk.ChunkMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.Chunk> getPreviousChunksList();
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    com.google.cloud.discoveryengine.v1.Chunk getPreviousChunks(int index);
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    int getPreviousChunksCount();
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
        getPreviousChunksOrBuilderList();
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    com.google.cloud.discoveryengine.v1.ChunkOrBuilder getPreviousChunksOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.Chunk> getNextChunksList();
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    com.google.cloud.discoveryengine.v1.Chunk getNextChunks(int index);
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    int getNextChunksCount();
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
        getNextChunksOrBuilderList();
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    com.google.cloud.discoveryengine.v1.ChunkOrBuilder getNextChunksOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Metadata of the current chunk. This field is only populated on
   * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
   * API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk.ChunkMetadata}
   */
  public static final class ChunkMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Chunk.ChunkMetadata)
      ChunkMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ChunkMetadata.newBuilder() to construct.
    private ChunkMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChunkMetadata() {
      previousChunks_ = java.util.Collections.emptyList();
      nextChunks_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChunkMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_ChunkMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_ChunkMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.class,
              com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.Builder.class);
    }

    public static final int PREVIOUS_CHUNKS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.Chunk> previousChunks_;
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.Chunk> getPreviousChunksList() {
      return previousChunks_;
    }
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
        getPreviousChunksOrBuilderList() {
      return previousChunks_;
    }
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    @java.lang.Override
    public int getPreviousChunksCount() {
      return previousChunks_.size();
    }
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk getPreviousChunks(int index) {
      return previousChunks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The previous chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ChunkOrBuilder getPreviousChunksOrBuilder(
        int index) {
      return previousChunks_.get(index);
    }

    public static final int NEXT_CHUNKS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.Chunk> nextChunks_;
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.Chunk> getNextChunksList() {
      return nextChunks_;
    }
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
        getNextChunksOrBuilderList() {
      return nextChunks_;
    }
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    @java.lang.Override
    public int getNextChunksCount() {
      return nextChunks_.size();
    }
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk getNextChunks(int index) {
      return nextChunks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The next chunks of the current chunk. The number is controlled by
     * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
     * This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ChunkOrBuilder getNextChunksOrBuilder(int index) {
      return nextChunks_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < previousChunks_.size(); i++) {
        output.writeMessage(1, previousChunks_.get(i));
      }
      for (int i = 0; i < nextChunks_.size(); i++) {
        output.writeMessage(2, nextChunks_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < previousChunks_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, previousChunks_.get(i));
      }
      for (int i = 0; i < nextChunks_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, nextChunks_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata other =
          (com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata) obj;

      if (!getPreviousChunksList().equals(other.getPreviousChunksList())) return false;
      if (!getNextChunksList().equals(other.getNextChunksList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPreviousChunksCount() > 0) {
        hash = (37 * hash) + PREVIOUS_CHUNKS_FIELD_NUMBER;
        hash = (53 * hash) + getPreviousChunksList().hashCode();
      }
      if (getNextChunksCount() > 0) {
        hash = (37 * hash) + NEXT_CHUNKS_FIELD_NUMBER;
        hash = (53 * hash) + getNextChunksList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the current chunk. This field is only populated on
     * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
     * API.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk.ChunkMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Chunk.ChunkMetadata)
        com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_ChunkMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_ChunkMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.class,
                com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (previousChunksBuilder_ == null) {
          previousChunks_ = java.util.Collections.emptyList();
        } else {
          previousChunks_ = null;
          previousChunksBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (nextChunksBuilder_ == null) {
          nextChunks_ = java.util.Collections.emptyList();
        } else {
          nextChunks_ = null;
          nextChunksBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ChunkProto
            .internal_static_google_cloud_discoveryengine_v1_Chunk_ChunkMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata build() {
        com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata buildPartial() {
        com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata result =
            new com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata result) {
        if (previousChunksBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            previousChunks_ = java.util.Collections.unmodifiableList(previousChunks_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.previousChunks_ = previousChunks_;
        } else {
          result.previousChunks_ = previousChunksBuilder_.build();
        }
        if (nextChunksBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            nextChunks_ = java.util.Collections.unmodifiableList(nextChunks_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.nextChunks_ = nextChunks_;
        } else {
          result.nextChunks_ = nextChunksBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata other) {
        if (other == com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.getDefaultInstance())
          return this;
        if (previousChunksBuilder_ == null) {
          if (!other.previousChunks_.isEmpty()) {
            if (previousChunks_.isEmpty()) {
              previousChunks_ = other.previousChunks_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePreviousChunksIsMutable();
              previousChunks_.addAll(other.previousChunks_);
            }
            onChanged();
          }
        } else {
          if (!other.previousChunks_.isEmpty()) {
            if (previousChunksBuilder_.isEmpty()) {
              previousChunksBuilder_.dispose();
              previousChunksBuilder_ = null;
              previousChunks_ = other.previousChunks_;
              bitField0_ = (bitField0_ & ~0x00000001);
              previousChunksBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPreviousChunksFieldBuilder()
                      : null;
            } else {
              previousChunksBuilder_.addAllMessages(other.previousChunks_);
            }
          }
        }
        if (nextChunksBuilder_ == null) {
          if (!other.nextChunks_.isEmpty()) {
            if (nextChunks_.isEmpty()) {
              nextChunks_ = other.nextChunks_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureNextChunksIsMutable();
              nextChunks_.addAll(other.nextChunks_);
            }
            onChanged();
          }
        } else {
          if (!other.nextChunks_.isEmpty()) {
            if (nextChunksBuilder_.isEmpty()) {
              nextChunksBuilder_.dispose();
              nextChunksBuilder_ = null;
              nextChunks_ = other.nextChunks_;
              bitField0_ = (bitField0_ & ~0x00000002);
              nextChunksBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNextChunksFieldBuilder()
                      : null;
            } else {
              nextChunksBuilder_.addAllMessages(other.nextChunks_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1.Chunk m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.Chunk.parser(), extensionRegistry);
                  if (previousChunksBuilder_ == null) {
                    ensurePreviousChunksIsMutable();
                    previousChunks_.add(m);
                  } else {
                    previousChunksBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.discoveryengine.v1.Chunk m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.Chunk.parser(), extensionRegistry);
                  if (nextChunksBuilder_ == null) {
                    ensureNextChunksIsMutable();
                    nextChunks_.add(m);
                  } else {
                    nextChunksBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.discoveryengine.v1.Chunk> previousChunks_ =
          java.util.Collections.emptyList();

      private void ensurePreviousChunksIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          previousChunks_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Chunk>(previousChunks_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Chunk,
              com.google.cloud.discoveryengine.v1.Chunk.Builder,
              com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
          previousChunksBuilder_;

      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Chunk> getPreviousChunksList() {
        if (previousChunksBuilder_ == null) {
          return java.util.Collections.unmodifiableList(previousChunks_);
        } else {
          return previousChunksBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public int getPreviousChunksCount() {
        if (previousChunksBuilder_ == null) {
          return previousChunks_.size();
        } else {
          return previousChunksBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk getPreviousChunks(int index) {
        if (previousChunksBuilder_ == null) {
          return previousChunks_.get(index);
        } else {
          return previousChunksBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder setPreviousChunks(int index, com.google.cloud.discoveryengine.v1.Chunk value) {
        if (previousChunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePreviousChunksIsMutable();
          previousChunks_.set(index, value);
          onChanged();
        } else {
          previousChunksBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder setPreviousChunks(
          int index, com.google.cloud.discoveryengine.v1.Chunk.Builder builderForValue) {
        if (previousChunksBuilder_ == null) {
          ensurePreviousChunksIsMutable();
          previousChunks_.set(index, builderForValue.build());
          onChanged();
        } else {
          previousChunksBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder addPreviousChunks(com.google.cloud.discoveryengine.v1.Chunk value) {
        if (previousChunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePreviousChunksIsMutable();
          previousChunks_.add(value);
          onChanged();
        } else {
          previousChunksBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder addPreviousChunks(int index, com.google.cloud.discoveryengine.v1.Chunk value) {
        if (previousChunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePreviousChunksIsMutable();
          previousChunks_.add(index, value);
          onChanged();
        } else {
          previousChunksBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder addPreviousChunks(
          com.google.cloud.discoveryengine.v1.Chunk.Builder builderForValue) {
        if (previousChunksBuilder_ == null) {
          ensurePreviousChunksIsMutable();
          previousChunks_.add(builderForValue.build());
          onChanged();
        } else {
          previousChunksBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder addPreviousChunks(
          int index, com.google.cloud.discoveryengine.v1.Chunk.Builder builderForValue) {
        if (previousChunksBuilder_ == null) {
          ensurePreviousChunksIsMutable();
          previousChunks_.add(index, builderForValue.build());
          onChanged();
        } else {
          previousChunksBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder addAllPreviousChunks(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Chunk> values) {
        if (previousChunksBuilder_ == null) {
          ensurePreviousChunksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, previousChunks_);
          onChanged();
        } else {
          previousChunksBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder clearPreviousChunks() {
        if (previousChunksBuilder_ == null) {
          previousChunks_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          previousChunksBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public Builder removePreviousChunks(int index) {
        if (previousChunksBuilder_ == null) {
          ensurePreviousChunksIsMutable();
          previousChunks_.remove(index);
          onChanged();
        } else {
          previousChunksBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk.Builder getPreviousChunksBuilder(int index) {
        return getPreviousChunksFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1.ChunkOrBuilder getPreviousChunksOrBuilder(
          int index) {
        if (previousChunksBuilder_ == null) {
          return previousChunks_.get(index);
        } else {
          return previousChunksBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
          getPreviousChunksOrBuilderList() {
        if (previousChunksBuilder_ != null) {
          return previousChunksBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(previousChunks_);
        }
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk.Builder addPreviousChunksBuilder() {
        return getPreviousChunksFieldBuilder()
            .addBuilder(com.google.cloud.discoveryengine.v1.Chunk.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk.Builder addPreviousChunksBuilder(int index) {
        return getPreviousChunksFieldBuilder()
            .addBuilder(index, com.google.cloud.discoveryengine.v1.Chunk.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The previous chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_previous_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk previous_chunks = 1;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Chunk.Builder>
          getPreviousChunksBuilderList() {
        return getPreviousChunksFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Chunk,
              com.google.cloud.discoveryengine.v1.Chunk.Builder,
              com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
          getPreviousChunksFieldBuilder() {
        if (previousChunksBuilder_ == null) {
          previousChunksBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Chunk,
                  com.google.cloud.discoveryengine.v1.Chunk.Builder,
                  com.google.cloud.discoveryengine.v1.ChunkOrBuilder>(
                  previousChunks_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          previousChunks_ = null;
        }
        return previousChunksBuilder_;
      }

      private java.util.List<com.google.cloud.discoveryengine.v1.Chunk> nextChunks_ =
          java.util.Collections.emptyList();

      private void ensureNextChunksIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          nextChunks_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Chunk>(nextChunks_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Chunk,
              com.google.cloud.discoveryengine.v1.Chunk.Builder,
              com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
          nextChunksBuilder_;

      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Chunk> getNextChunksList() {
        if (nextChunksBuilder_ == null) {
          return java.util.Collections.unmodifiableList(nextChunks_);
        } else {
          return nextChunksBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public int getNextChunksCount() {
        if (nextChunksBuilder_ == null) {
          return nextChunks_.size();
        } else {
          return nextChunksBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk getNextChunks(int index) {
        if (nextChunksBuilder_ == null) {
          return nextChunks_.get(index);
        } else {
          return nextChunksBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder setNextChunks(int index, com.google.cloud.discoveryengine.v1.Chunk value) {
        if (nextChunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNextChunksIsMutable();
          nextChunks_.set(index, value);
          onChanged();
        } else {
          nextChunksBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder setNextChunks(
          int index, com.google.cloud.discoveryengine.v1.Chunk.Builder builderForValue) {
        if (nextChunksBuilder_ == null) {
          ensureNextChunksIsMutable();
          nextChunks_.set(index, builderForValue.build());
          onChanged();
        } else {
          nextChunksBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder addNextChunks(com.google.cloud.discoveryengine.v1.Chunk value) {
        if (nextChunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNextChunksIsMutable();
          nextChunks_.add(value);
          onChanged();
        } else {
          nextChunksBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder addNextChunks(int index, com.google.cloud.discoveryengine.v1.Chunk value) {
        if (nextChunksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNextChunksIsMutable();
          nextChunks_.add(index, value);
          onChanged();
        } else {
          nextChunksBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder addNextChunks(
          com.google.cloud.discoveryengine.v1.Chunk.Builder builderForValue) {
        if (nextChunksBuilder_ == null) {
          ensureNextChunksIsMutable();
          nextChunks_.add(builderForValue.build());
          onChanged();
        } else {
          nextChunksBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder addNextChunks(
          int index, com.google.cloud.discoveryengine.v1.Chunk.Builder builderForValue) {
        if (nextChunksBuilder_ == null) {
          ensureNextChunksIsMutable();
          nextChunks_.add(index, builderForValue.build());
          onChanged();
        } else {
          nextChunksBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder addAllNextChunks(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Chunk> values) {
        if (nextChunksBuilder_ == null) {
          ensureNextChunksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nextChunks_);
          onChanged();
        } else {
          nextChunksBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder clearNextChunks() {
        if (nextChunksBuilder_ == null) {
          nextChunks_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          nextChunksBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public Builder removeNextChunks(int index) {
        if (nextChunksBuilder_ == null) {
          ensureNextChunksIsMutable();
          nextChunks_.remove(index);
          onChanged();
        } else {
          nextChunksBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk.Builder getNextChunksBuilder(int index) {
        return getNextChunksFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.ChunkOrBuilder getNextChunksOrBuilder(int index) {
        if (nextChunksBuilder_ == null) {
          return nextChunks_.get(index);
        } else {
          return nextChunksBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public java.util.List<? extends com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
          getNextChunksOrBuilderList() {
        if (nextChunksBuilder_ != null) {
          return nextChunksBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(nextChunks_);
        }
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk.Builder addNextChunksBuilder() {
        return getNextChunksFieldBuilder()
            .addBuilder(com.google.cloud.discoveryengine.v1.Chunk.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.Chunk.Builder addNextChunksBuilder(int index) {
        return getNextChunksFieldBuilder()
            .addBuilder(index, com.google.cloud.discoveryengine.v1.Chunk.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The next chunks of the current chunk. The number is controlled by
       * [SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks][google.cloud.discoveryengine.v1.SearchRequest.ContentSearchSpec.ChunkSpec.num_next_chunks].
       * This field is only populated on
       * [SearchService.Search][google.cloud.discoveryengine.v1.SearchService.Search]
       * API.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Chunk next_chunks = 2;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Chunk.Builder>
          getNextChunksBuilderList() {
        return getNextChunksFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Chunk,
              com.google.cloud.discoveryengine.v1.Chunk.Builder,
              com.google.cloud.discoveryengine.v1.ChunkOrBuilder>
          getNextChunksFieldBuilder() {
        if (nextChunksBuilder_ == null) {
          nextChunksBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Chunk,
                  com.google.cloud.discoveryengine.v1.Chunk.Builder,
                  com.google.cloud.discoveryengine.v1.ChunkOrBuilder>(
                  nextChunks_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          nextChunks_ = null;
        }
        return nextChunksBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Chunk.ChunkMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Chunk.ChunkMetadata)
    private static final com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata();
    }

    public static com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChunkMetadata> PARSER =
        new com.google.protobuf.AbstractParser<ChunkMetadata>() {
          @java.lang.Override
          public ChunkMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChunkMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChunkMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The full resource name of the chunk.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full resource name of the chunk.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Unique chunk ID of the current chunk.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Unique chunk ID of the current chunk.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object content_ = "";
  /**
   *
   *
   * <pre>
   * Content is a string from a document (parsed content).
   * </pre>
   *
   * <code>string content = 3;</code>
   *
   * @return The content.
   */
  @java.lang.Override
  public java.lang.String getContent() {
    java.lang.Object ref = content_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      content_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Content is a string from a document (parsed content).
   * </pre>
   *
   * <code>string content = 3;</code>
   *
   * @return The bytes for content.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentBytes() {
    java.lang.Object ref = content_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      content_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELEVANCE_SCORE_FIELD_NUMBER = 8;
  private double relevanceScore_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. Represents the relevance score based on similarity.
   * Higher score indicates higher chunk relevance.
   * The score is in range [-1.0, 1.0].
   * Only populated on [SearchService.SearchResponse][].
   * </pre>
   *
   * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the relevanceScore field is set.
   */
  @java.lang.Override
  public boolean hasRelevanceScore() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents the relevance score based on similarity.
   * Higher score indicates higher chunk relevance.
   * The score is in range [-1.0, 1.0].
   * Only populated on [SearchService.SearchResponse][].
   * </pre>
   *
   * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The relevanceScore.
   */
  @java.lang.Override
  public double getRelevanceScore() {
    return relevanceScore_;
  }

  public static final int DOCUMENT_METADATA_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata documentMetadata_;
  /**
   *
   *
   * <pre>
   * Metadata of the document from the current chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
   *
   * @return Whether the documentMetadata field is set.
   */
  @java.lang.Override
  public boolean hasDocumentMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metadata of the document from the current chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
   *
   * @return The documentMetadata.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata getDocumentMetadata() {
    return documentMetadata_ == null
        ? com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.getDefaultInstance()
        : documentMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata of the document from the current chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadataOrBuilder
      getDocumentMetadataOrBuilder() {
    return documentMetadata_ == null
        ? com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.getDefaultInstance()
        : documentMetadata_;
  }

  public static final int DERIVED_STRUCT_DATA_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct derivedStructData_;
  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the derivedStructData field is set.
   */
  @java.lang.Override
  public boolean hasDerivedStructData() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The derivedStructData.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getDerivedStructData() {
    return derivedStructData_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : derivedStructData_;
  }
  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getDerivedStructDataOrBuilder() {
    return derivedStructData_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : derivedStructData_;
  }

  public static final int PAGE_SPAN_FIELD_NUMBER = 6;
  private com.google.cloud.discoveryengine.v1.Chunk.PageSpan pageSpan_;
  /**
   *
   *
   * <pre>
   * Page span of the chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
   *
   * @return Whether the pageSpan field is set.
   */
  @java.lang.Override
  public boolean hasPageSpan() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Page span of the chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
   *
   * @return The pageSpan.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Chunk.PageSpan getPageSpan() {
    return pageSpan_ == null
        ? com.google.cloud.discoveryengine.v1.Chunk.PageSpan.getDefaultInstance()
        : pageSpan_;
  }
  /**
   *
   *
   * <pre>
   * Page span of the chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Chunk.PageSpanOrBuilder getPageSpanOrBuilder() {
    return pageSpan_ == null
        ? com.google.cloud.discoveryengine.v1.Chunk.PageSpan.getDefaultInstance()
        : pageSpan_;
  }

  public static final int CHUNK_METADATA_FIELD_NUMBER = 7;
  private com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunkMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Metadata of the current chunk.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the chunkMetadata field is set.
   */
  @java.lang.Override
  public boolean hasChunkMetadata() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata of the current chunk.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The chunkMetadata.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata getChunkMetadata() {
    return chunkMetadata_ == null
        ? com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.getDefaultInstance()
        : chunkMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata of the current chunk.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadataOrBuilder
      getChunkMetadataOrBuilder() {
    return chunkMetadata_ == null
        ? com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.getDefaultInstance()
        : chunkMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, content_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getDerivedStructData());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getDocumentMetadata());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getPageSpan());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(7, getChunkMetadata());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(8, relevanceScore_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, content_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDerivedStructData());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDocumentMetadata());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPageSpan());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getChunkMetadata());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(8, relevanceScore_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.Chunk)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.Chunk other =
        (com.google.cloud.discoveryengine.v1.Chunk) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getId().equals(other.getId())) return false;
    if (!getContent().equals(other.getContent())) return false;
    if (hasRelevanceScore() != other.hasRelevanceScore()) return false;
    if (hasRelevanceScore()) {
      if (java.lang.Double.doubleToLongBits(getRelevanceScore())
          != java.lang.Double.doubleToLongBits(other.getRelevanceScore())) return false;
    }
    if (hasDocumentMetadata() != other.hasDocumentMetadata()) return false;
    if (hasDocumentMetadata()) {
      if (!getDocumentMetadata().equals(other.getDocumentMetadata())) return false;
    }
    if (hasDerivedStructData() != other.hasDerivedStructData()) return false;
    if (hasDerivedStructData()) {
      if (!getDerivedStructData().equals(other.getDerivedStructData())) return false;
    }
    if (hasPageSpan() != other.hasPageSpan()) return false;
    if (hasPageSpan()) {
      if (!getPageSpan().equals(other.getPageSpan())) return false;
    }
    if (hasChunkMetadata() != other.hasChunkMetadata()) return false;
    if (hasChunkMetadata()) {
      if (!getChunkMetadata().equals(other.getChunkMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getContent().hashCode();
    if (hasRelevanceScore()) {
      hash = (37 * hash) + RELEVANCE_SCORE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getRelevanceScore()));
    }
    if (hasDocumentMetadata()) {
      hash = (37 * hash) + DOCUMENT_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentMetadata().hashCode();
    }
    if (hasDerivedStructData()) {
      hash = (37 * hash) + DERIVED_STRUCT_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getDerivedStructData().hashCode();
    }
    if (hasPageSpan()) {
      hash = (37 * hash) + PAGE_SPAN_FIELD_NUMBER;
      hash = (53 * hash) + getPageSpan().hashCode();
    }
    if (hasChunkMetadata()) {
      hash = (37 * hash) + CHUNK_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getChunkMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Chunk parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.Chunk prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Chunk captures all raw metadata information of items to be recommended or
   * searched in the chunk mode.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Chunk}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Chunk)
      com.google.cloud.discoveryengine.v1.ChunkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Chunk.class,
              com.google.cloud.discoveryengine.v1.Chunk.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.Chunk.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentMetadataFieldBuilder();
        getDerivedStructDataFieldBuilder();
        getPageSpanFieldBuilder();
        getChunkMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      id_ = "";
      content_ = "";
      relevanceScore_ = 0D;
      documentMetadata_ = null;
      if (documentMetadataBuilder_ != null) {
        documentMetadataBuilder_.dispose();
        documentMetadataBuilder_ = null;
      }
      derivedStructData_ = null;
      if (derivedStructDataBuilder_ != null) {
        derivedStructDataBuilder_.dispose();
        derivedStructDataBuilder_ = null;
      }
      pageSpan_ = null;
      if (pageSpanBuilder_ != null) {
        pageSpanBuilder_.dispose();
        pageSpanBuilder_ = null;
      }
      chunkMetadata_ = null;
      if (chunkMetadataBuilder_ != null) {
        chunkMetadataBuilder_.dispose();
        chunkMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.ChunkProto
          .internal_static_google_cloud_discoveryengine_v1_Chunk_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.Chunk.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk build() {
      com.google.cloud.discoveryengine.v1.Chunk result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Chunk buildPartial() {
      com.google.cloud.discoveryengine.v1.Chunk result =
          new com.google.cloud.discoveryengine.v1.Chunk(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.Chunk result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.content_ = content_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.relevanceScore_ = relevanceScore_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.documentMetadata_ =
            documentMetadataBuilder_ == null ? documentMetadata_ : documentMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.derivedStructData_ =
            derivedStructDataBuilder_ == null
                ? derivedStructData_
                : derivedStructDataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.pageSpan_ = pageSpanBuilder_ == null ? pageSpan_ : pageSpanBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.chunkMetadata_ =
            chunkMetadataBuilder_ == null ? chunkMetadata_ : chunkMetadataBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.Chunk) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.Chunk) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Chunk other) {
      if (other == com.google.cloud.discoveryengine.v1.Chunk.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getContent().isEmpty()) {
        content_ = other.content_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRelevanceScore()) {
        setRelevanceScore(other.getRelevanceScore());
      }
      if (other.hasDocumentMetadata()) {
        mergeDocumentMetadata(other.getDocumentMetadata());
      }
      if (other.hasDerivedStructData()) {
        mergeDerivedStructData(other.getDerivedStructData());
      }
      if (other.hasPageSpan()) {
        mergePageSpan(other.getPageSpan());
      }
      if (other.hasChunkMetadata()) {
        mergeChunkMetadata(other.getChunkMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                content_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getDerivedStructDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getDocumentMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getPageSpanFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getChunkMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 65:
              {
                relevanceScore_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 65
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The full resource name of the chunk.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the chunk.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the chunk.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the chunk.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full resource name of the chunk.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Unique chunk ID of the current chunk.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique chunk ID of the current chunk.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique chunk ID of the current chunk.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique chunk ID of the current chunk.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique chunk ID of the current chunk.
     * </pre>
     *
     * <code>string id = 2;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object content_ = "";
    /**
     *
     *
     * <pre>
     * Content is a string from a document (parsed content).
     * </pre>
     *
     * <code>string content = 3;</code>
     *
     * @return The content.
     */
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Content is a string from a document (parsed content).
     * </pre>
     *
     * <code>string content = 3;</code>
     *
     * @return The bytes for content.
     */
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Content is a string from a document (parsed content).
     * </pre>
     *
     * <code>string content = 3;</code>
     *
     * @param value The content to set.
     * @return This builder for chaining.
     */
    public Builder setContent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      content_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content is a string from a document (parsed content).
     * </pre>
     *
     * <code>string content = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContent() {
      content_ = getDefaultInstance().getContent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Content is a string from a document (parsed content).
     * </pre>
     *
     * <code>string content = 3;</code>
     *
     * @param value The bytes for content to set.
     * @return This builder for chaining.
     */
    public Builder setContentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      content_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private double relevanceScore_;
    /**
     *
     *
     * <pre>
     * Output only. Represents the relevance score based on similarity.
     * Higher score indicates higher chunk relevance.
     * The score is in range [-1.0, 1.0].
     * Only populated on [SearchService.SearchResponse][].
     * </pre>
     *
     * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the relevanceScore field is set.
     */
    @java.lang.Override
    public boolean hasRelevanceScore() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents the relevance score based on similarity.
     * Higher score indicates higher chunk relevance.
     * The score is in range [-1.0, 1.0].
     * Only populated on [SearchService.SearchResponse][].
     * </pre>
     *
     * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The relevanceScore.
     */
    @java.lang.Override
    public double getRelevanceScore() {
      return relevanceScore_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents the relevance score based on similarity.
     * Higher score indicates higher chunk relevance.
     * The score is in range [-1.0, 1.0].
     * Only populated on [SearchService.SearchResponse][].
     * </pre>
     *
     * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The relevanceScore to set.
     * @return This builder for chaining.
     */
    public Builder setRelevanceScore(double value) {

      relevanceScore_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Represents the relevance score based on similarity.
     * Higher score indicates higher chunk relevance.
     * The score is in range [-1.0, 1.0].
     * Only populated on [SearchService.SearchResponse][].
     * </pre>
     *
     * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelevanceScore() {
      bitField0_ = (bitField0_ & ~0x00000008);
      relevanceScore_ = 0D;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata documentMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata,
            com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.Builder,
            com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadataOrBuilder>
        documentMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     *
     * @return Whether the documentMetadata field is set.
     */
    public boolean hasDocumentMetadata() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     *
     * @return The documentMetadata.
     */
    public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata getDocumentMetadata() {
      if (documentMetadataBuilder_ == null) {
        return documentMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.getDefaultInstance()
            : documentMetadata_;
      } else {
        return documentMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     */
    public Builder setDocumentMetadata(
        com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata value) {
      if (documentMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentMetadata_ = value;
      } else {
        documentMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     */
    public Builder setDocumentMetadata(
        com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.Builder builderForValue) {
      if (documentMetadataBuilder_ == null) {
        documentMetadata_ = builderForValue.build();
      } else {
        documentMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     */
    public Builder mergeDocumentMetadata(
        com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata value) {
      if (documentMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && documentMetadata_ != null
            && documentMetadata_
                != com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata
                    .getDefaultInstance()) {
          getDocumentMetadataBuilder().mergeFrom(value);
        } else {
          documentMetadata_ = value;
        }
      } else {
        documentMetadataBuilder_.mergeFrom(value);
      }
      if (documentMetadata_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     */
    public Builder clearDocumentMetadata() {
      bitField0_ = (bitField0_ & ~0x00000010);
      documentMetadata_ = null;
      if (documentMetadataBuilder_ != null) {
        documentMetadataBuilder_.dispose();
        documentMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.Builder
        getDocumentMetadataBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDocumentMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadataOrBuilder
        getDocumentMetadataOrBuilder() {
      if (documentMetadataBuilder_ != null) {
        return documentMetadataBuilder_.getMessageOrBuilder();
      } else {
        return documentMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.getDefaultInstance()
            : documentMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata of the document from the current chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata,
            com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.Builder,
            com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadataOrBuilder>
        getDocumentMetadataFieldBuilder() {
      if (documentMetadataBuilder_ == null) {
        documentMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata,
                com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata.Builder,
                com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadataOrBuilder>(
                getDocumentMetadata(), getParentForChildren(), isClean());
        documentMetadata_ = null;
      }
      return documentMetadataBuilder_;
    }

    private com.google.protobuf.Struct derivedStructData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        derivedStructDataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the derivedStructData field is set.
     */
    public boolean hasDerivedStructData() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The derivedStructData.
     */
    public com.google.protobuf.Struct getDerivedStructData() {
      if (derivedStructDataBuilder_ == null) {
        return derivedStructData_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : derivedStructData_;
      } else {
        return derivedStructDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedStructData(com.google.protobuf.Struct value) {
      if (derivedStructDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        derivedStructData_ = value;
      } else {
        derivedStructDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedStructData(com.google.protobuf.Struct.Builder builderForValue) {
      if (derivedStructDataBuilder_ == null) {
        derivedStructData_ = builderForValue.build();
      } else {
        derivedStructDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDerivedStructData(com.google.protobuf.Struct value) {
      if (derivedStructDataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && derivedStructData_ != null
            && derivedStructData_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getDerivedStructDataBuilder().mergeFrom(value);
        } else {
          derivedStructData_ = value;
        }
      } else {
        derivedStructDataBuilder_.mergeFrom(value);
      }
      if (derivedStructData_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDerivedStructData() {
      bitField0_ = (bitField0_ & ~0x00000020);
      derivedStructData_ = null;
      if (derivedStructDataBuilder_ != null) {
        derivedStructDataBuilder_.dispose();
        derivedStructDataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getDerivedStructDataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDerivedStructDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getDerivedStructDataOrBuilder() {
      if (derivedStructDataBuilder_ != null) {
        return derivedStructDataBuilder_.getMessageOrBuilder();
      } else {
        return derivedStructData_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : derivedStructData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This field is OUTPUT_ONLY.
     * It contains derived data that are not in the original input document.
     * </pre>
     *
     * <code>
     * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getDerivedStructDataFieldBuilder() {
      if (derivedStructDataBuilder_ == null) {
        derivedStructDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getDerivedStructData(), getParentForChildren(), isClean());
        derivedStructData_ = null;
      }
      return derivedStructDataBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.Chunk.PageSpan pageSpan_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Chunk.PageSpan,
            com.google.cloud.discoveryengine.v1.Chunk.PageSpan.Builder,
            com.google.cloud.discoveryengine.v1.Chunk.PageSpanOrBuilder>
        pageSpanBuilder_;
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     *
     * @return Whether the pageSpan field is set.
     */
    public boolean hasPageSpan() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     *
     * @return The pageSpan.
     */
    public com.google.cloud.discoveryengine.v1.Chunk.PageSpan getPageSpan() {
      if (pageSpanBuilder_ == null) {
        return pageSpan_ == null
            ? com.google.cloud.discoveryengine.v1.Chunk.PageSpan.getDefaultInstance()
            : pageSpan_;
      } else {
        return pageSpanBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     */
    public Builder setPageSpan(com.google.cloud.discoveryengine.v1.Chunk.PageSpan value) {
      if (pageSpanBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageSpan_ = value;
      } else {
        pageSpanBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     */
    public Builder setPageSpan(
        com.google.cloud.discoveryengine.v1.Chunk.PageSpan.Builder builderForValue) {
      if (pageSpanBuilder_ == null) {
        pageSpan_ = builderForValue.build();
      } else {
        pageSpanBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     */
    public Builder mergePageSpan(com.google.cloud.discoveryengine.v1.Chunk.PageSpan value) {
      if (pageSpanBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && pageSpan_ != null
            && pageSpan_
                != com.google.cloud.discoveryengine.v1.Chunk.PageSpan.getDefaultInstance()) {
          getPageSpanBuilder().mergeFrom(value);
        } else {
          pageSpan_ = value;
        }
      } else {
        pageSpanBuilder_.mergeFrom(value);
      }
      if (pageSpan_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     */
    public Builder clearPageSpan() {
      bitField0_ = (bitField0_ & ~0x00000040);
      pageSpan_ = null;
      if (pageSpanBuilder_ != null) {
        pageSpanBuilder_.dispose();
        pageSpanBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     */
    public com.google.cloud.discoveryengine.v1.Chunk.PageSpan.Builder getPageSpanBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPageSpanFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     */
    public com.google.cloud.discoveryengine.v1.Chunk.PageSpanOrBuilder getPageSpanOrBuilder() {
      if (pageSpanBuilder_ != null) {
        return pageSpanBuilder_.getMessageOrBuilder();
      } else {
        return pageSpan_ == null
            ? com.google.cloud.discoveryengine.v1.Chunk.PageSpan.getDefaultInstance()
            : pageSpan_;
      }
    }
    /**
     *
     *
     * <pre>
     * Page span of the chunk.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Chunk.PageSpan,
            com.google.cloud.discoveryengine.v1.Chunk.PageSpan.Builder,
            com.google.cloud.discoveryengine.v1.Chunk.PageSpanOrBuilder>
        getPageSpanFieldBuilder() {
      if (pageSpanBuilder_ == null) {
        pageSpanBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Chunk.PageSpan,
                com.google.cloud.discoveryengine.v1.Chunk.PageSpan.Builder,
                com.google.cloud.discoveryengine.v1.Chunk.PageSpanOrBuilder>(
                getPageSpan(), getParentForChildren(), isClean());
        pageSpan_ = null;
      }
      return pageSpanBuilder_;
    }

    private com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunkMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata,
            com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.Builder,
            com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadataOrBuilder>
        chunkMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the chunkMetadata field is set.
     */
    public boolean hasChunkMetadata() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The chunkMetadata.
     */
    public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata getChunkMetadata() {
      if (chunkMetadataBuilder_ == null) {
        return chunkMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.getDefaultInstance()
            : chunkMetadata_;
      } else {
        return chunkMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChunkMetadata(com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata value) {
      if (chunkMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        chunkMetadata_ = value;
      } else {
        chunkMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChunkMetadata(
        com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.Builder builderForValue) {
      if (chunkMetadataBuilder_ == null) {
        chunkMetadata_ = builderForValue.build();
      } else {
        chunkMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeChunkMetadata(
        com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata value) {
      if (chunkMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && chunkMetadata_ != null
            && chunkMetadata_
                != com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.getDefaultInstance()) {
          getChunkMetadataBuilder().mergeFrom(value);
        } else {
          chunkMetadata_ = value;
        }
      } else {
        chunkMetadataBuilder_.mergeFrom(value);
      }
      if (chunkMetadata_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChunkMetadata() {
      bitField0_ = (bitField0_ & ~0x00000080);
      chunkMetadata_ = null;
      if (chunkMetadataBuilder_ != null) {
        chunkMetadataBuilder_.dispose();
        chunkMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.Builder
        getChunkMetadataBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getChunkMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadataOrBuilder
        getChunkMetadataOrBuilder() {
      if (chunkMetadataBuilder_ != null) {
        return chunkMetadataBuilder_.getMessageOrBuilder();
      } else {
        return chunkMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.getDefaultInstance()
            : chunkMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata of the current chunk.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata,
            com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.Builder,
            com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadataOrBuilder>
        getChunkMetadataFieldBuilder() {
      if (chunkMetadataBuilder_ == null) {
        chunkMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata,
                com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata.Builder,
                com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadataOrBuilder>(
                getChunkMetadata(), getParentForChildren(), isClean());
        chunkMetadata_ = null;
      }
      return chunkMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Chunk)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Chunk)
  private static final com.google.cloud.discoveryengine.v1.Chunk DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Chunk();
  }

  public static com.google.cloud.discoveryengine.v1.Chunk getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Chunk> PARSER =
      new com.google.protobuf.AbstractParser<Chunk>() {
        @java.lang.Override
        public Chunk parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Chunk> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Chunk> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Chunk getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
