/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Metadata related to the progress of the
 * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1.SiteSearchEngineService.RecrawlUris]
 * operation. This will be returned by the google.longrunning.Operation.metadata
 * field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.RecrawlUrisMetadata}
 */
public final class RecrawlUrisMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
    RecrawlUrisMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RecrawlUrisMetadata.newBuilder() to construct.
  private RecrawlUrisMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RecrawlUrisMetadata() {
    invalidUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RecrawlUrisMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.class,
            com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Operation create time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Operation last update time. If the operation is done, this is also the
   * finish time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int INVALID_URIS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList invalidUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @return A list containing the invalidUris.
   */
  public com.google.protobuf.ProtocolStringList getInvalidUrisList() {
    return invalidUris_;
  }
  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @return The count of invalidUris.
   */
  public int getInvalidUrisCount() {
    return invalidUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The invalidUris at the given index.
   */
  public java.lang.String getInvalidUris(int index) {
    return invalidUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Unique URIs in the request that don't match any TargetSite in the
   * DataStore, only match TargetSites that haven't been fully indexed, or match
   * a TargetSite with type EXCLUDE.
   * </pre>
   *
   * <code>repeated string invalid_uris = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the invalidUris at the given index.
   */
  public com.google.protobuf.ByteString getInvalidUrisBytes(int index) {
    return invalidUris_.getByteString(index);
  }

  public static final int VALID_URIS_COUNT_FIELD_NUMBER = 4;
  private int validUrisCount_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of unique URIs in the request that are not in invalid_uris.
   * </pre>
   *
   * <code>int32 valid_uris_count = 4;</code>
   *
   * @return The validUrisCount.
   */
  @java.lang.Override
  public int getValidUrisCount() {
    return validUrisCount_;
  }

  public static final int SUCCESS_COUNT_FIELD_NUMBER = 5;
  private int successCount_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of URIs that have been crawled so far.
   * </pre>
   *
   * <code>int32 success_count = 5;</code>
   *
   * @return The successCount.
   */
  @java.lang.Override
  public int getSuccessCount() {
    return successCount_;
  }

  public static final int PENDING_COUNT_FIELD_NUMBER = 6;
  private int pendingCount_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of URIs that have yet to be crawled.
   * </pre>
   *
   * <code>int32 pending_count = 6;</code>
   *
   * @return The pendingCount.
   */
  @java.lang.Override
  public int getPendingCount() {
    return pendingCount_;
  }

  public static final int QUOTA_EXCEEDED_COUNT_FIELD_NUMBER = 7;
  private int quotaExceededCount_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of URIs that were rejected due to insufficient indexing
   * resources.
   * </pre>
   *
   * <code>int32 quota_exceeded_count = 7;</code>
   *
   * @return The quotaExceededCount.
   */
  @java.lang.Override
  public int getQuotaExceededCount() {
    return quotaExceededCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUpdateTime());
    }
    for (int i = 0; i < invalidUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, invalidUris_.getRaw(i));
    }
    if (validUrisCount_ != 0) {
      output.writeInt32(4, validUrisCount_);
    }
    if (successCount_ != 0) {
      output.writeInt32(5, successCount_);
    }
    if (pendingCount_ != 0) {
      output.writeInt32(6, pendingCount_);
    }
    if (quotaExceededCount_ != 0) {
      output.writeInt32(7, quotaExceededCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < invalidUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(invalidUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInvalidUrisList().size();
    }
    if (validUrisCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, validUrisCount_);
    }
    if (successCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, successCount_);
    }
    if (pendingCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, pendingCount_);
    }
    if (quotaExceededCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, quotaExceededCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata other =
        (com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getInvalidUrisList().equals(other.getInvalidUrisList())) return false;
    if (getValidUrisCount() != other.getValidUrisCount()) return false;
    if (getSuccessCount() != other.getSuccessCount()) return false;
    if (getPendingCount() != other.getPendingCount()) return false;
    if (getQuotaExceededCount() != other.getQuotaExceededCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getInvalidUrisCount() > 0) {
      hash = (37 * hash) + INVALID_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getInvalidUrisList().hashCode();
    }
    hash = (37 * hash) + VALID_URIS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getValidUrisCount();
    hash = (37 * hash) + SUCCESS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSuccessCount();
    hash = (37 * hash) + PENDING_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPendingCount();
    hash = (37 * hash) + QUOTA_EXCEEDED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getQuotaExceededCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata related to the progress of the
   * [SiteSearchEngineService.RecrawlUris][google.cloud.discoveryengine.v1.SiteSearchEngineService.RecrawlUris]
   * operation. This will be returned by the google.longrunning.Operation.metadata
   * field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.RecrawlUrisMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.class,
              com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      invalidUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      validUrisCount_ = 0;
      successCount_ = 0;
      pendingCount_ = 0;
      quotaExceededCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_RecrawlUrisMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata build() {
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata buildPartial() {
      com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata result =
          new com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        invalidUris_.makeImmutable();
        result.invalidUris_ = invalidUris_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.validUrisCount_ = validUrisCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.successCount_ = successCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pendingCount_ = pendingCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.quotaExceededCount_ = quotaExceededCount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata other) {
      if (other == com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata.getDefaultInstance())
        return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.invalidUris_.isEmpty()) {
        if (invalidUris_.isEmpty()) {
          invalidUris_ = other.invalidUris_;
          bitField0_ |= 0x00000004;
        } else {
          ensureInvalidUrisIsMutable();
          invalidUris_.addAll(other.invalidUris_);
        }
        onChanged();
      }
      if (other.getValidUrisCount() != 0) {
        setValidUrisCount(other.getValidUrisCount());
      }
      if (other.getSuccessCount() != 0) {
        setSuccessCount(other.getSuccessCount());
      }
      if (other.getPendingCount() != 0) {
        setPendingCount(other.getPendingCount());
      }
      if (other.getQuotaExceededCount() != 0) {
        setQuotaExceededCount(other.getQuotaExceededCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInvalidUrisIsMutable();
                invalidUris_.add(s);
                break;
              } // case 26
            case 32:
              {
                validUrisCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                successCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                pendingCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                quotaExceededCount_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Operation create time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Operation last update time. If the operation is done, this is also the
     * finish time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList invalidUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInvalidUrisIsMutable() {
      if (!invalidUris_.isModifiable()) {
        invalidUris_ = new com.google.protobuf.LazyStringArrayList(invalidUris_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @return A list containing the invalidUris.
     */
    public com.google.protobuf.ProtocolStringList getInvalidUrisList() {
      invalidUris_.makeImmutable();
      return invalidUris_;
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @return The count of invalidUris.
     */
    public int getInvalidUrisCount() {
      return invalidUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The invalidUris at the given index.
     */
    public java.lang.String getInvalidUris(int index) {
      return invalidUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the invalidUris at the given index.
     */
    public com.google.protobuf.ByteString getInvalidUrisBytes(int index) {
      return invalidUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The invalidUris to set.
     * @return This builder for chaining.
     */
    public Builder setInvalidUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInvalidUrisIsMutable();
      invalidUris_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param value The invalidUris to add.
     * @return This builder for chaining.
     */
    public Builder addInvalidUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInvalidUrisIsMutable();
      invalidUris_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param values The invalidUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllInvalidUris(java.lang.Iterable<java.lang.String> values) {
      ensureInvalidUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, invalidUris_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInvalidUris() {
      invalidUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Unique URIs in the request that don't match any TargetSite in the
     * DataStore, only match TargetSites that haven't been fully indexed, or match
     * a TargetSite with type EXCLUDE.
     * </pre>
     *
     * <code>repeated string invalid_uris = 3;</code>
     *
     * @param value The bytes of the invalidUris to add.
     * @return This builder for chaining.
     */
    public Builder addInvalidUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInvalidUrisIsMutable();
      invalidUris_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int validUrisCount_;
    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that are not in invalid_uris.
     * </pre>
     *
     * <code>int32 valid_uris_count = 4;</code>
     *
     * @return The validUrisCount.
     */
    @java.lang.Override
    public int getValidUrisCount() {
      return validUrisCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that are not in invalid_uris.
     * </pre>
     *
     * <code>int32 valid_uris_count = 4;</code>
     *
     * @param value The validUrisCount to set.
     * @return This builder for chaining.
     */
    public Builder setValidUrisCount(int value) {

      validUrisCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of unique URIs in the request that are not in invalid_uris.
     * </pre>
     *
     * <code>int32 valid_uris_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidUrisCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      validUrisCount_ = 0;
      onChanged();
      return this;
    }

    private int successCount_;
    /**
     *
     *
     * <pre>
     * Total number of URIs that have been crawled so far.
     * </pre>
     *
     * <code>int32 success_count = 5;</code>
     *
     * @return The successCount.
     */
    @java.lang.Override
    public int getSuccessCount() {
      return successCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of URIs that have been crawled so far.
     * </pre>
     *
     * <code>int32 success_count = 5;</code>
     *
     * @param value The successCount to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessCount(int value) {

      successCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of URIs that have been crawled so far.
     * </pre>
     *
     * <code>int32 success_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      successCount_ = 0;
      onChanged();
      return this;
    }

    private int pendingCount_;
    /**
     *
     *
     * <pre>
     * Total number of URIs that have yet to be crawled.
     * </pre>
     *
     * <code>int32 pending_count = 6;</code>
     *
     * @return The pendingCount.
     */
    @java.lang.Override
    public int getPendingCount() {
      return pendingCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of URIs that have yet to be crawled.
     * </pre>
     *
     * <code>int32 pending_count = 6;</code>
     *
     * @param value The pendingCount to set.
     * @return This builder for chaining.
     */
    public Builder setPendingCount(int value) {

      pendingCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of URIs that have yet to be crawled.
     * </pre>
     *
     * <code>int32 pending_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPendingCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      pendingCount_ = 0;
      onChanged();
      return this;
    }

    private int quotaExceededCount_;
    /**
     *
     *
     * <pre>
     * Total number of URIs that were rejected due to insufficient indexing
     * resources.
     * </pre>
     *
     * <code>int32 quota_exceeded_count = 7;</code>
     *
     * @return The quotaExceededCount.
     */
    @java.lang.Override
    public int getQuotaExceededCount() {
      return quotaExceededCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of URIs that were rejected due to insufficient indexing
     * resources.
     * </pre>
     *
     * <code>int32 quota_exceeded_count = 7;</code>
     *
     * @param value The quotaExceededCount to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaExceededCount(int value) {

      quotaExceededCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of URIs that were rejected due to insufficient indexing
     * resources.
     * </pre>
     *
     * <code>int32 quota_exceeded_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuotaExceededCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      quotaExceededCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.RecrawlUrisMetadata)
  private static final com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata();
  }

  public static com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RecrawlUrisMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RecrawlUrisMetadata>() {
        @java.lang.Override
        public RecrawlUrisMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RecrawlUrisMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RecrawlUrisMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.RecrawlUrisMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
