/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DocumentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String branch;
    private final String document;
    private final String collection;

    @Deprecated
    protected DocumentName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.branch = null;
        this.document = null;
        this.collection = null;
    }

    private DocumentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.collection = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT;
    }

    private DocumentName(ProjectLocationCollectionDataStoreBranchDocumentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.branch = (String)Preconditions.checkNotNull((Object)builder.getBranch());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getDocument() {
        return this.document;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreBranchDocumentBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreBranchDocumentBuilder newProjectLocationCollectionDataStoreBranchDocumentBuilder() {
        return new ProjectLocationCollectionDataStoreBranchDocumentBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DocumentName of(String project, String location, String dataStore, String branch, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).build();
    }

    public static DocumentName ofProjectLocationDataStoreBranchDocumentName(String project, String location, String dataStore, String branch, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).build();
    }

    public static DocumentName ofProjectLocationCollectionDataStoreBranchDocumentName(String project, String location, String collection, String dataStore, String branch, String document) {
        return DocumentName.newProjectLocationCollectionDataStoreBranchDocumentBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setBranch(branch).setDocument(document).build();
    }

    public static String format(String project, String location, String dataStore, String branch, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).build().toString();
    }

    public static String formatProjectLocationDataStoreBranchDocumentName(String project, String location, String dataStore, String branch, String document) {
        return DocumentName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setBranch(branch).setDocument(document).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreBranchDocumentName(String project, String location, String collection, String dataStore, String branch, String document) {
        return DocumentName.newProjectLocationCollectionDataStoreBranchDocumentBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setBranch(branch).setDocument(document).build().toString();
    }

    public static DocumentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT.match(formattedString);
            return DocumentName.ofProjectLocationDataStoreBranchDocumentName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("branch"), (String)matchMap.get("document"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT.match(formattedString);
            return DocumentName.ofProjectLocationCollectionDataStoreBranchDocumentName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("branch"), (String)matchMap.get("document"));
        }
        throw new ValidationException("DocumentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<DocumentName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentName> list = new ArrayList<DocumentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_BRANCH_DOCUMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentName documentName = this;
            synchronized (documentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.branch != null) {
                        fieldMapBuilder.put((Object)"branch", (Object)this.branch);
                    }
                    if (this.document != null) {
                        fieldMapBuilder.put((Object)"document", (Object)this.document);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DocumentName that = (DocumentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.branch, that.branch) && Objects.equals(this.document, that.document) && Objects.equals(this.collection, that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.branch);
        h *= 1000003;
        h ^= Objects.hashCode(this.document);
        h *= 1000003;
        return h ^= Objects.hashCode(this.collection);
    }

    public static class ProjectLocationCollectionDataStoreBranchDocumentBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String branch;
        private String document;

        protected ProjectLocationCollectionDataStoreBranchDocumentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getDocument() {
            return this.document;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentBuilder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public ProjectLocationCollectionDataStoreBranchDocumentBuilder setDocument(String document) {
            this.document = document;
            return this;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String branch;
        private String document;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getDocument() {
            return this.document;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        private Builder(DocumentName documentName) {
            Preconditions.checkArgument((boolean)Objects.equals(documentName.pathTemplate, PROJECT_LOCATION_DATA_STORE_BRANCH_DOCUMENT), (Object)"toBuilder is only supported when DocumentName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/branches/{branch}/documents/{document}");
            this.project = documentName.project;
            this.location = documentName.location;
            this.dataStore = documentName.dataStore;
            this.branch = documentName.branch;
            this.document = documentName.document;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }
}

