/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/custom_tuning_model.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Metadata that describes a custom tuned model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.CustomTuningModel}
 */
public final class CustomTuningModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.CustomTuningModel)
    CustomTuningModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomTuningModel.newBuilder() to construct.
  private CustomTuningModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomTuningModel() {
    name_ = "";
    displayName_ = "";
    modelState_ = 0;
    errorMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomTuningModel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.CustomTuningModelProto
        .internal_static_google_cloud_discoveryengine_v1_CustomTuningModel_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 7:
        return internalGetMetrics();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.CustomTuningModelProto
        .internal_static_google_cloud_discoveryengine_v1_CustomTuningModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.CustomTuningModel.class,
            com.google.cloud.discoveryengine.v1.CustomTuningModel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The state of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.CustomTuningModel.ModelState}
   */
  public enum ModelState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>MODEL_STATE_UNSPECIFIED = 0;</code>
     */
    MODEL_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The model is in a paused training state.
     * </pre>
     *
     * <code>TRAINING_PAUSED = 1;</code>
     */
    TRAINING_PAUSED(1),
    /**
     *
     *
     * <pre>
     * The model is currently training.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    TRAINING(2),
    /**
     *
     *
     * <pre>
     * The model has successfully completed training.
     * </pre>
     *
     * <code>TRAINING_COMPLETE = 3;</code>
     */
    TRAINING_COMPLETE(3),
    /**
     *
     *
     * <pre>
     * The model is ready for serving.
     * </pre>
     *
     * <code>READY_FOR_SERVING = 4;</code>
     */
    READY_FOR_SERVING(4),
    /**
     *
     *
     * <pre>
     * The model training failed.
     * </pre>
     *
     * <code>TRAINING_FAILED = 5;</code>
     */
    TRAINING_FAILED(5),
    /**
     *
     *
     * <pre>
     * The model training finished successfully but metrics did not improve.
     * </pre>
     *
     * <code>NO_IMPROVEMENT = 6;</code>
     */
    NO_IMPROVEMENT(6),
    /**
     *
     *
     * <pre>
     * Input data validation failed. Model training didn't start.
     * </pre>
     *
     * <code>INPUT_VALIDATION_FAILED = 7;</code>
     */
    INPUT_VALIDATION_FAILED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>MODEL_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int MODEL_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The model is in a paused training state.
     * </pre>
     *
     * <code>TRAINING_PAUSED = 1;</code>
     */
    public static final int TRAINING_PAUSED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The model is currently training.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    public static final int TRAINING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The model has successfully completed training.
     * </pre>
     *
     * <code>TRAINING_COMPLETE = 3;</code>
     */
    public static final int TRAINING_COMPLETE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The model is ready for serving.
     * </pre>
     *
     * <code>READY_FOR_SERVING = 4;</code>
     */
    public static final int READY_FOR_SERVING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The model training failed.
     * </pre>
     *
     * <code>TRAINING_FAILED = 5;</code>
     */
    public static final int TRAINING_FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The model training finished successfully but metrics did not improve.
     * </pre>
     *
     * <code>NO_IMPROVEMENT = 6;</code>
     */
    public static final int NO_IMPROVEMENT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Input data validation failed. Model training didn't start.
     * </pre>
     *
     * <code>INPUT_VALIDATION_FAILED = 7;</code>
     */
    public static final int INPUT_VALIDATION_FAILED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModelState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ModelState forNumber(int value) {
      switch (value) {
        case 0:
          return MODEL_STATE_UNSPECIFIED;
        case 1:
          return TRAINING_PAUSED;
        case 2:
          return TRAINING;
        case 3:
          return TRAINING_COMPLETE;
        case 4:
          return READY_FOR_SERVING;
        case 5:
          return TRAINING_FAILED;
        case 6:
          return NO_IMPROVEMENT;
        case 7:
          return INPUT_VALIDATION_FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ModelState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ModelState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ModelState>() {
          public ModelState findValueByNumber(int number) {
            return ModelState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CustomTuningModel.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ModelState[] VALUES = values();

    public static ModelState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ModelState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.CustomTuningModel.ModelState)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The fully qualified resource name of the model.
   *
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
   *
   * Model must be an alpha-numerical string with limit of 40 characters.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The fully qualified resource name of the model.
   *
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
   *
   * Model must be an alpha-numerical string with limit of 40 characters.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the model.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the model.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VERSION_FIELD_NUMBER = 3;
  private long modelVersion_ = 0L;
  /**
   *
   *
   * <pre>
   * The version of the model.
   * </pre>
   *
   * <code>int64 model_version = 3;</code>
   *
   * @return The modelVersion.
   */
  @java.lang.Override
  public long getModelVersion() {
    return modelVersion_;
  }

  public static final int MODEL_STATE_FIELD_NUMBER = 4;
  private int modelState_ = 0;
  /**
   *
   *
   * <pre>
   * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState model_state = 4;</code>
   *
   * @return The enum numeric value on the wire for modelState.
   */
  @java.lang.Override
  public int getModelStateValue() {
    return modelState_;
  }
  /**
   *
   *
   * <pre>
   * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState model_state = 4;</code>
   *
   * @return The modelState.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState getModelState() {
    com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState result =
        com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState.forNumber(modelState_);
    return result == null
        ? com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Deprecated: Timestamp the Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.discoveryengine.v1.CustomTuningModel.create_time is deprecated. See
   *     google/cloud/discoveryengine/v1/custom_tuning_model.proto;l=89
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Timestamp the Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.discoveryengine.v1.CustomTuningModel.create_time is deprecated. See
   *     google/cloud/discoveryengine/v1/custom_tuning_model.proto;l=89
   * @return The createTime.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: Timestamp the Model was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int TRAINING_START_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp trainingStartTime_;
  /**
   *
   *
   * <pre>
   * Timestamp the model training was initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
   *
   * @return Whether the trainingStartTime field is set.
   */
  @java.lang.Override
  public boolean hasTrainingStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Timestamp the model training was initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
   *
   * @return The trainingStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTrainingStartTime() {
    return trainingStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : trainingStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Timestamp the model training was initiated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTrainingStartTimeOrBuilder() {
    return trainingStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : trainingStartTime_;
  }

  public static final int METRICS_FIELD_NUMBER = 7;

  private static final class MetricsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Double>newDefaultInstance(
            com.google.cloud.discoveryengine.v1.CustomTuningModelProto
                .internal_static_google_cloud_discoveryengine_v1_CustomTuningModel_MetricsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.DOUBLE,
            0D);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> metrics_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetMetrics() {
    if (metrics_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetricsDefaultEntryHolder.defaultEntry);
    }
    return metrics_;
  }

  public int getMetricsCount() {
    return internalGetMetrics().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 7;</code>
   */
  @java.lang.Override
  public boolean containsMetrics(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetrics().getMap().containsKey(key);
  }
  /** Use {@link #getMetricsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Double> getMetrics() {
    return getMetricsMap();
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Double> getMetricsMap() {
    return internalGetMetrics().getMap();
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 7;</code>
   */
  @java.lang.Override
  public double getMetricsOrDefault(java.lang.String key, double defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The metrics of the trained model.
   * </pre>
   *
   * <code>map&lt;string, double&gt; metrics = 7;</code>
   */
  @java.lang.Override
  public double getMetricsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ERROR_MESSAGE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorMessage_ = "";
  /**
   *
   *
   * <pre>
   * Currently this is only populated if the model state is
   * `INPUT_VALIDATION_FAILED`.
   * </pre>
   *
   * <code>string error_message = 8;</code>
   *
   * @return The errorMessage.
   */
  @java.lang.Override
  public java.lang.String getErrorMessage() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Currently this is only populated if the model state is
   * `INPUT_VALIDATION_FAILED`.
   * </pre>
   *
   * <code>string error_message = 8;</code>
   *
   * @return The bytes for errorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorMessageBytes() {
    java.lang.Object ref = errorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (modelVersion_ != 0L) {
      output.writeInt64(3, modelVersion_);
    }
    if (modelState_
        != com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState.MODEL_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, modelState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getTrainingStartTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetrics(), MetricsDefaultEntryHolder.defaultEntry, 7);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, errorMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (modelVersion_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, modelVersion_);
    }
    if (modelState_
        != com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState.MODEL_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, modelState_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTrainingStartTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Double> entry :
        internalGetMetrics().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> metrics__ =
          MetricsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, metrics__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, errorMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.CustomTuningModel)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.CustomTuningModel other =
        (com.google.cloud.discoveryengine.v1.CustomTuningModel) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getModelVersion() != other.getModelVersion()) return false;
    if (modelState_ != other.modelState_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasTrainingStartTime() != other.hasTrainingStartTime()) return false;
    if (hasTrainingStartTime()) {
      if (!getTrainingStartTime().equals(other.getTrainingStartTime())) return false;
    }
    if (!internalGetMetrics().equals(other.internalGetMetrics())) return false;
    if (!getErrorMessage().equals(other.getErrorMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getModelVersion());
    hash = (37 * hash) + MODEL_STATE_FIELD_NUMBER;
    hash = (53 * hash) + modelState_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasTrainingStartTime()) {
      hash = (37 * hash) + TRAINING_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingStartTime().hashCode();
    }
    if (!internalGetMetrics().getMap().isEmpty()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetrics().hashCode();
    }
    hash = (37 * hash) + ERROR_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getErrorMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.CustomTuningModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata that describes a custom tuned model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.CustomTuningModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.CustomTuningModel)
      com.google.cloud.discoveryengine.v1.CustomTuningModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CustomTuningModelProto
          .internal_static_google_cloud_discoveryengine_v1_CustomTuningModel_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMetrics();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableMetrics();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.CustomTuningModelProto
          .internal_static_google_cloud_discoveryengine_v1_CustomTuningModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.CustomTuningModel.class,
              com.google.cloud.discoveryengine.v1.CustomTuningModel.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.CustomTuningModel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getTrainingStartTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      modelVersion_ = 0L;
      modelState_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      trainingStartTime_ = null;
      if (trainingStartTimeBuilder_ != null) {
        trainingStartTimeBuilder_.dispose();
        trainingStartTimeBuilder_ = null;
      }
      internalGetMutableMetrics().clear();
      errorMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.CustomTuningModelProto
          .internal_static_google_cloud_discoveryengine_v1_CustomTuningModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CustomTuningModel getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.CustomTuningModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CustomTuningModel build() {
      com.google.cloud.discoveryengine.v1.CustomTuningModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CustomTuningModel buildPartial() {
      com.google.cloud.discoveryengine.v1.CustomTuningModel result =
          new com.google.cloud.discoveryengine.v1.CustomTuningModel(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.CustomTuningModel result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.modelVersion_ = modelVersion_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modelState_ = modelState_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.trainingStartTime_ =
            trainingStartTimeBuilder_ == null
                ? trainingStartTime_
                : trainingStartTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.metrics_ = internalGetMetrics();
        result.metrics_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.errorMessage_ = errorMessage_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.CustomTuningModel) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.CustomTuningModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.CustomTuningModel other) {
      if (other == com.google.cloud.discoveryengine.v1.CustomTuningModel.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getModelVersion() != 0L) {
        setModelVersion(other.getModelVersion());
      }
      if (other.modelState_ != 0) {
        setModelStateValue(other.getModelStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasTrainingStartTime()) {
        mergeTrainingStartTime(other.getTrainingStartTime());
      }
      internalGetMutableMetrics().mergeFrom(other.internalGetMetrics());
      bitField0_ |= 0x00000040;
      if (!other.getErrorMessage().isEmpty()) {
        errorMessage_ = other.errorMessage_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                modelVersion_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                modelState_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getTrainingStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Double> metrics__ =
                    input.readMessage(
                        MetricsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetrics()
                    .getMutableMap()
                    .put(metrics__.getKey(), metrics__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                errorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
     *
     * Model must be an alpha-numerical string with limit of 40 characters.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
     *
     * Model must be an alpha-numerical string with limit of 40 characters.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
     *
     * Model must be an alpha-numerical string with limit of 40 characters.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
     *
     * Model must be an alpha-numerical string with limit of 40 characters.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified resource name of the model.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/customTuningModels/{custom_tuning_model}`.
     *
     * Model must be an alpha-numerical string with limit of 40 characters.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long modelVersion_;
    /**
     *
     *
     * <pre>
     * The version of the model.
     * </pre>
     *
     * <code>int64 model_version = 3;</code>
     *
     * @return The modelVersion.
     */
    @java.lang.Override
    public long getModelVersion() {
      return modelVersion_;
    }
    /**
     *
     *
     * <pre>
     * The version of the model.
     * </pre>
     *
     * <code>int64 model_version = 3;</code>
     *
     * @param value The modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersion(long value) {

      modelVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the model.
     * </pre>
     *
     * <code>int64 model_version = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersion() {
      bitField0_ = (bitField0_ & ~0x00000004);
      modelVersion_ = 0L;
      onChanged();
      return this;
    }

    private int modelState_ = 0;
    /**
     *
     *
     * <pre>
     * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState model_state = 4;</code>
     *
     * @return The enum numeric value on the wire for modelState.
     */
    @java.lang.Override
    public int getModelStateValue() {
      return modelState_;
    }
    /**
     *
     *
     * <pre>
     * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState model_state = 4;</code>
     *
     * @param value The enum numeric value on the wire for modelState to set.
     * @return This builder for chaining.
     */
    public Builder setModelStateValue(int value) {
      modelState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState model_state = 4;</code>
     *
     * @return The modelState.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState getModelState() {
      com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState result =
          com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState.forNumber(modelState_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState model_state = 4;</code>
     *
     * @param value The modelState to set.
     * @return This builder for chaining.
     */
    public Builder setModelState(
        com.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      modelState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state that the model is in (e.g.`TRAINING` or `TRAINING_FAILED`).
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.CustomTuningModel.ModelState model_state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      modelState_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.discoveryengine.v1.CustomTuningModel.create_time is deprecated. See
     *     google/cloud/discoveryengine/v1/custom_tuning_model.proto;l=89
     * @return Whether the createTime field is set.
     */
    @java.lang.Deprecated
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.discoveryengine.v1.CustomTuningModel.create_time is deprecated. See
     *     google/cloud/discoveryengine/v1/custom_tuning_model.proto;l=89
     * @return The createTime.
     */
    @java.lang.Deprecated
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: Timestamp the Model was created at.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp trainingStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        trainingStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     *
     * @return Whether the trainingStartTime field is set.
     */
    public boolean hasTrainingStartTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     *
     * @return The trainingStartTime.
     */
    public com.google.protobuf.Timestamp getTrainingStartTime() {
      if (trainingStartTimeBuilder_ == null) {
        return trainingStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : trainingStartTime_;
      } else {
        return trainingStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     */
    public Builder setTrainingStartTime(com.google.protobuf.Timestamp value) {
      if (trainingStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingStartTime_ = value;
      } else {
        trainingStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     */
    public Builder setTrainingStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (trainingStartTimeBuilder_ == null) {
        trainingStartTime_ = builderForValue.build();
      } else {
        trainingStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     */
    public Builder mergeTrainingStartTime(com.google.protobuf.Timestamp value) {
      if (trainingStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && trainingStartTime_ != null
            && trainingStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getTrainingStartTimeBuilder().mergeFrom(value);
        } else {
          trainingStartTime_ = value;
        }
      } else {
        trainingStartTimeBuilder_.mergeFrom(value);
      }
      if (trainingStartTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     */
    public Builder clearTrainingStartTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      trainingStartTime_ = null;
      if (trainingStartTimeBuilder_ != null) {
        trainingStartTimeBuilder_.dispose();
        trainingStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getTrainingStartTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTrainingStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getTrainingStartTimeOrBuilder() {
      if (trainingStartTimeBuilder_ != null) {
        return trainingStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return trainingStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : trainingStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp the model training was initiated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp training_start_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTrainingStartTimeFieldBuilder() {
      if (trainingStartTimeBuilder_ == null) {
        trainingStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getTrainingStartTime(), getParentForChildren(), isClean());
        trainingStartTime_ = null;
      }
      return trainingStartTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> metrics_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double> internalGetMetrics() {
      if (metrics_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetricsDefaultEntryHolder.defaultEntry);
      }
      return metrics_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Double>
        internalGetMutableMetrics() {
      if (metrics_ == null) {
        metrics_ = com.google.protobuf.MapField.newMapField(MetricsDefaultEntryHolder.defaultEntry);
      }
      if (!metrics_.isMutable()) {
        metrics_ = metrics_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return metrics_;
    }

    public int getMetricsCount() {
      return internalGetMetrics().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 7;</code>
     */
    @java.lang.Override
    public boolean containsMetrics(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetrics().getMap().containsKey(key);
    }
    /** Use {@link #getMetricsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getMetrics() {
      return getMetricsMap();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Double> getMetricsMap() {
      return internalGetMetrics().getMap();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 7;</code>
     */
    @java.lang.Override
    public double getMetricsOrDefault(java.lang.String key, double defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 7;</code>
     */
    @java.lang.Override
    public double getMetricsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Double> map = internalGetMetrics().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetrics() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableMetrics().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 7;</code>
     */
    public Builder removeMetrics(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetrics().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Double> getMutableMetrics() {
      bitField0_ |= 0x00000040;
      return internalGetMutableMetrics().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 7;</code>
     */
    public Builder putMetrics(java.lang.String key, double value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableMetrics().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics of the trained model.
     * </pre>
     *
     * <code>map&lt;string, double&gt; metrics = 7;</code>
     */
    public Builder putAllMetrics(java.util.Map<java.lang.String, java.lang.Double> values) {
      internalGetMutableMetrics().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.lang.Object errorMessage_ = "";
    /**
     *
     *
     * <pre>
     * Currently this is only populated if the model state is
     * `INPUT_VALIDATION_FAILED`.
     * </pre>
     *
     * <code>string error_message = 8;</code>
     *
     * @return The errorMessage.
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Currently this is only populated if the model state is
     * `INPUT_VALIDATION_FAILED`.
     * </pre>
     *
     * <code>string error_message = 8;</code>
     *
     * @return The bytes for errorMessage.
     */
    public com.google.protobuf.ByteString getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Currently this is only populated if the model state is
     * `INPUT_VALIDATION_FAILED`.
     * </pre>
     *
     * <code>string error_message = 8;</code>
     *
     * @param value The errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorMessage_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Currently this is only populated if the model state is
     * `INPUT_VALIDATION_FAILED`.
     * </pre>
     *
     * <code>string error_message = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorMessage() {
      errorMessage_ = getDefaultInstance().getErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Currently this is only populated if the model state is
     * `INPUT_VALIDATION_FAILED`.
     * </pre>
     *
     * <code>string error_message = 8;</code>
     *
     * @param value The bytes for errorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorMessage_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.CustomTuningModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.CustomTuningModel)
  private static final com.google.cloud.discoveryengine.v1.CustomTuningModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.CustomTuningModel();
  }

  public static com.google.cloud.discoveryengine.v1.CustomTuningModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomTuningModel> PARSER =
      new com.google.protobuf.AbstractParser<CustomTuningModel>() {
        @java.lang.Override
        public CustomTuningModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomTuningModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomTuningModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CustomTuningModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
