/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/document_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [DocumentService.UpdateDocument][google.cloud.discoveryengine.v1.DocumentService.UpdateDocument]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.UpdateDocumentRequest}
 */
public final class UpdateDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.UpdateDocumentRequest)
    UpdateDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateDocumentRequest.newBuilder() to construct.
  private UpdateDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateDocumentRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateDocumentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.DocumentServiceProto
        .internal_static_google_cloud_discoveryengine_v1_UpdateDocumentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.DocumentServiceProto
        .internal_static_google_cloud_discoveryengine_v1_UpdateDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.UpdateDocumentRequest.class,
            com.google.cloud.discoveryengine.v1.UpdateDocumentRequest.Builder.class);
  }

  private int bitField0_;
  public static final int DOCUMENT_FIELD_NUMBER = 1;
  private com.google.cloud.discoveryengine.v1.Document document_;
  /**
   *
   *
   * <pre>
   * Required. The document to update/create.
   *
   * If the caller does not have permission to update the
   * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
   * or not it exists, a `PERMISSION_DENIED` error is returned.
   *
   * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
   * not exist and
   * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
   * is not set, a `NOT_FOUND` error is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the document field is set.
   */
  @java.lang.Override
  public boolean hasDocument() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The document to update/create.
   *
   * If the caller does not have permission to update the
   * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
   * or not it exists, a `PERMISSION_DENIED` error is returned.
   *
   * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
   * not exist and
   * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
   * is not set, a `NOT_FOUND` error is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The document.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Document getDocument() {
    return document_ == null
        ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
        : document_;
  }
  /**
   *
   *
   * <pre>
   * Required. The document to update/create.
   *
   * If the caller does not have permission to update the
   * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
   * or not it exists, a `PERMISSION_DENIED` error is returned.
   *
   * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
   * not exist and
   * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
   * is not set, a `NOT_FOUND` error is returned.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder() {
    return document_ == null
        ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
        : document_;
  }

  public static final int ALLOW_MISSING_FIELD_NUMBER = 2;
  private boolean allowMissing_ = false;
  /**
   *
   *
   * <pre>
   * If set to `true` and the
   * [Document][google.cloud.discoveryengine.v1.Document] is not found, a new
   * [Document][google.cloud.discoveryengine.v1.Document] is be created.
   * </pre>
   *
   * <code>bool allow_missing = 2;</code>
   *
   * @return The allowMissing.
   */
  @java.lang.Override
  public boolean getAllowMissing() {
    return allowMissing_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 3;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported 'document' to update. If
   * not set, by default updates all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3;</code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported 'document' to update. If
   * not set, by default updates all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3;</code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Indicates which fields in the provided imported 'document' to update. If
   * not set, by default updates all fields.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDocument());
    }
    if (allowMissing_ != false) {
      output.writeBool(2, allowMissing_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocument());
    }
    if (allowMissing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowMissing_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.UpdateDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.UpdateDocumentRequest other =
        (com.google.cloud.discoveryengine.v1.UpdateDocumentRequest) obj;

    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (getAllowMissing() != other.getAllowMissing()) return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    hash = (37 * hash) + ALLOW_MISSING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowMissing());
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.UpdateDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [DocumentService.UpdateDocument][google.cloud.discoveryengine.v1.DocumentService.UpdateDocument]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.UpdateDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.UpdateDocumentRequest)
      com.google.cloud.discoveryengine.v1.UpdateDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1_UpdateDocumentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1_UpdateDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.UpdateDocumentRequest.class,
              com.google.cloud.discoveryengine.v1.UpdateDocumentRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.UpdateDocumentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentFieldBuilder();
        getUpdateMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      allowMissing_ = false;
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1_UpdateDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UpdateDocumentRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.UpdateDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UpdateDocumentRequest build() {
      com.google.cloud.discoveryengine.v1.UpdateDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.UpdateDocumentRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.UpdateDocumentRequest result =
          new com.google.cloud.discoveryengine.v1.UpdateDocumentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.UpdateDocumentRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.allowMissing_ = allowMissing_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.UpdateDocumentRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.UpdateDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.UpdateDocumentRequest other) {
      if (other == com.google.cloud.discoveryengine.v1.UpdateDocumentRequest.getDefaultInstance())
        return this;
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (other.getAllowMissing() != false) {
        setAllowMissing(other.getAllowMissing());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                allowMissing_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.discoveryengine.v1.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Document,
            com.google.cloud.discoveryengine.v1.Document.Builder,
            com.google.cloud.discoveryengine.v1.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the document field is set.
     */
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The document.
     */
    public com.google.cloud.discoveryengine.v1.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocument(com.google.cloud.discoveryengine.v1.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
      } else {
        documentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocument(
        com.google.cloud.discoveryengine.v1.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDocument(com.google.cloud.discoveryengine.v1.Document value) {
      if (documentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && document_ != null
            && document_ != com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()) {
          getDocumentBuilder().mergeFrom(value);
        } else {
          document_ = value;
        }
      } else {
        documentBuilder_.mergeFrom(value);
      }
      if (document_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDocument() {
      bitField0_ = (bitField0_ & ~0x00000001);
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Document.Builder getDocumentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.cloud.discoveryengine.v1.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The document to update/create.
     *
     * If the caller does not have permission to update the
     * [Document][google.cloud.discoveryengine.v1.Document], regardless of whether
     * or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the [Document][google.cloud.discoveryengine.v1.Document] to update does
     * not exist and
     * [allow_missing][google.cloud.discoveryengine.v1.UpdateDocumentRequest.allow_missing]
     * is not set, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Document,
            com.google.cloud.discoveryengine.v1.Document.Builder,
            com.google.cloud.discoveryengine.v1.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Document,
                com.google.cloud.discoveryengine.v1.Document.Builder,
                com.google.cloud.discoveryengine.v1.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private boolean allowMissing_;
    /**
     *
     *
     * <pre>
     * If set to `true` and the
     * [Document][google.cloud.discoveryengine.v1.Document] is not found, a new
     * [Document][google.cloud.discoveryengine.v1.Document] is be created.
     * </pre>
     *
     * <code>bool allow_missing = 2;</code>
     *
     * @return The allowMissing.
     */
    @java.lang.Override
    public boolean getAllowMissing() {
      return allowMissing_;
    }
    /**
     *
     *
     * <pre>
     * If set to `true` and the
     * [Document][google.cloud.discoveryengine.v1.Document] is not found, a new
     * [Document][google.cloud.discoveryengine.v1.Document] is be created.
     * </pre>
     *
     * <code>bool allow_missing = 2;</code>
     *
     * @param value The allowMissing to set.
     * @return This builder for chaining.
     */
    public Builder setAllowMissing(boolean value) {

      allowMissing_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to `true` and the
     * [Document][google.cloud.discoveryengine.v1.Document] is not found, a new
     * [Document][google.cloud.discoveryengine.v1.Document] is be created.
     * </pre>
     *
     * <code>bool allow_missing = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowMissing() {
      bitField0_ = (bitField0_ & ~0x00000002);
      allowMissing_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which fields in the provided imported 'document' to update. If
     * not set, by default updates all fields.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.UpdateDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.UpdateDocumentRequest)
  private static final com.google.cloud.discoveryengine.v1.UpdateDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.UpdateDocumentRequest();
  }

  public static com.google.cloud.discoveryengine.v1.UpdateDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateDocumentRequest>() {
        @java.lang.Override
        public UpdateDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.UpdateDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
