/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/answer.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Defines an answer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.Answer}
 */
public final class Answer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer)
    AnswerOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Answer.newBuilder() to construct.
  private Answer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Answer() {
    name_ = "";
    state_ = 0;
    answerText_ = "";
    citations_ = java.util.Collections.emptyList();
    groundingSupports_ = java.util.Collections.emptyList();
    references_ = java.util.Collections.emptyList();
    relatedQuestions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    steps_ = java.util.Collections.emptyList();
    answerSkippedReasons_ = java.util.Collections.emptyList();
    safetyRatings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Answer();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.AnswerProto
        .internal_static_google_cloud_discoveryengine_v1_Answer_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.AnswerProto
        .internal_static_google_cloud_discoveryengine_v1_Answer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.Answer.class,
            com.google.cloud.discoveryengine.v1.Answer.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enumeration of the state of the answer generation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.Answer.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Answer generation is currently in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    IN_PROGRESS(1),
    /**
     *
     *
     * <pre>
     * Answer generation currently failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     *
     *
     * <pre>
     * Answer generation has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * Answer generation is currently in progress.
     * </pre>
     *
     * <code>STREAMING = 4;</code>
     */
    STREAMING(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Answer generation is currently in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 1;</code>
     */
    public static final int IN_PROGRESS_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Answer generation currently failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Answer generation has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Answer generation is currently in progress.
     * </pre>
     *
     * <code>STREAMING = 4;</code>
     */
    public static final int STREAMING_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return IN_PROGRESS;
        case 2:
          return FAILED;
        case 3:
          return SUCCEEDED;
        case 4:
          return STREAMING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.Answer.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.Answer.State)
  }

  /**
   *
   *
   * <pre>
   * An enum for answer skipped reasons.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason}
   */
  public enum AnswerSkippedReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. The answer skipped reason is not specified.
     * </pre>
     *
     * <code>ANSWER_SKIPPED_REASON_UNSPECIFIED = 0;</code>
     */
    ANSWER_SKIPPED_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The adversarial query ignored case.
     * </pre>
     *
     * <code>ADVERSARIAL_QUERY_IGNORED = 1;</code>
     */
    ADVERSARIAL_QUERY_IGNORED(1),
    /**
     *
     *
     * <pre>
     * The non-answer seeking query ignored case
     *
     * Google skips the answer if the query is chit chat.
     * </pre>
     *
     * <code>NON_ANSWER_SEEKING_QUERY_IGNORED = 2;</code>
     */
    NON_ANSWER_SEEKING_QUERY_IGNORED(2),
    /**
     *
     *
     * <pre>
     * The out-of-domain query ignored case.
     *
     * Google skips the answer if there are no high-relevance search results.
     * </pre>
     *
     * <code>OUT_OF_DOMAIN_QUERY_IGNORED = 3;</code>
     */
    OUT_OF_DOMAIN_QUERY_IGNORED(3),
    /**
     *
     *
     * <pre>
     * The potential policy violation case.
     *
     * Google skips the answer if there is a potential policy violation
     * detected. This includes content that may be violent or toxic.
     * </pre>
     *
     * <code>POTENTIAL_POLICY_VIOLATION = 4;</code>
     */
    POTENTIAL_POLICY_VIOLATION(4),
    /**
     *
     *
     * <pre>
     * The no relevant content case.
     *
     * Google skips the answer if there is no relevant content in the
     * retrieved search results.
     * </pre>
     *
     * <code>NO_RELEVANT_CONTENT = 5;</code>
     */
    NO_RELEVANT_CONTENT(5),
    /**
     *
     *
     * <pre>
     * The jail-breaking query ignored case.
     *
     * For example, "Reply in the tone of a competing company's CEO".
     * Google skips the answer if the query is classified as a jail-breaking
     * query.
     * </pre>
     *
     * <code>JAIL_BREAKING_QUERY_IGNORED = 6;</code>
     */
    JAIL_BREAKING_QUERY_IGNORED(6),
    /**
     *
     *
     * <pre>
     * The customer policy violation case.
     *
     * Google skips the summary if there is a customer policy violation
     * detected. The policy is defined by the customer.
     * </pre>
     *
     * <code>CUSTOMER_POLICY_VIOLATION = 7;</code>
     */
    CUSTOMER_POLICY_VIOLATION(7),
    /**
     *
     *
     * <pre>
     * The non-answer seeking query ignored case.
     *
     * Google skips the answer if the query doesn't have clear intent.
     * </pre>
     *
     * <code>NON_ANSWER_SEEKING_QUERY_IGNORED_V2 = 8;</code>
     */
    NON_ANSWER_SEEKING_QUERY_IGNORED_V2(8),
    /**
     *
     *
     * <pre>
     * The low-grounded answer case.
     *
     * Google skips the answer if a well grounded answer was unable to be
     * generated.
     * </pre>
     *
     * <code>LOW_GROUNDED_ANSWER = 9;</code>
     */
    LOW_GROUNDED_ANSWER(9),
    /**
     *
     *
     * <pre>
     * The user defined query classification ignored case.
     *
     * Google skips the answer if the query is classified as a user defined
     * query classification.
     * </pre>
     *
     * <code>USER_DEFINED_CLASSIFICATION_QUERY_IGNORED = 10;</code>
     */
    USER_DEFINED_CLASSIFICATION_QUERY_IGNORED(10),
    /**
     *
     *
     * <pre>
     * The unhelpful answer case.
     *
     * Google skips the answer if the answer is not helpful. This can be due to
     * a variety of factors, including but not limited to: the query is not
     * answerable, the answer is not relevant to the query, or the answer is
     * not well-formatted.
     * </pre>
     *
     * <code>UNHELPFUL_ANSWER = 11;</code>
     */
    UNHELPFUL_ANSWER(11),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. The answer skipped reason is not specified.
     * </pre>
     *
     * <code>ANSWER_SKIPPED_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int ANSWER_SKIPPED_REASON_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The adversarial query ignored case.
     * </pre>
     *
     * <code>ADVERSARIAL_QUERY_IGNORED = 1;</code>
     */
    public static final int ADVERSARIAL_QUERY_IGNORED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The non-answer seeking query ignored case
     *
     * Google skips the answer if the query is chit chat.
     * </pre>
     *
     * <code>NON_ANSWER_SEEKING_QUERY_IGNORED = 2;</code>
     */
    public static final int NON_ANSWER_SEEKING_QUERY_IGNORED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The out-of-domain query ignored case.
     *
     * Google skips the answer if there are no high-relevance search results.
     * </pre>
     *
     * <code>OUT_OF_DOMAIN_QUERY_IGNORED = 3;</code>
     */
    public static final int OUT_OF_DOMAIN_QUERY_IGNORED_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The potential policy violation case.
     *
     * Google skips the answer if there is a potential policy violation
     * detected. This includes content that may be violent or toxic.
     * </pre>
     *
     * <code>POTENTIAL_POLICY_VIOLATION = 4;</code>
     */
    public static final int POTENTIAL_POLICY_VIOLATION_VALUE = 4;

    /**
     *
     *
     * <pre>
     * The no relevant content case.
     *
     * Google skips the answer if there is no relevant content in the
     * retrieved search results.
     * </pre>
     *
     * <code>NO_RELEVANT_CONTENT = 5;</code>
     */
    public static final int NO_RELEVANT_CONTENT_VALUE = 5;

    /**
     *
     *
     * <pre>
     * The jail-breaking query ignored case.
     *
     * For example, "Reply in the tone of a competing company's CEO".
     * Google skips the answer if the query is classified as a jail-breaking
     * query.
     * </pre>
     *
     * <code>JAIL_BREAKING_QUERY_IGNORED = 6;</code>
     */
    public static final int JAIL_BREAKING_QUERY_IGNORED_VALUE = 6;

    /**
     *
     *
     * <pre>
     * The customer policy violation case.
     *
     * Google skips the summary if there is a customer policy violation
     * detected. The policy is defined by the customer.
     * </pre>
     *
     * <code>CUSTOMER_POLICY_VIOLATION = 7;</code>
     */
    public static final int CUSTOMER_POLICY_VIOLATION_VALUE = 7;

    /**
     *
     *
     * <pre>
     * The non-answer seeking query ignored case.
     *
     * Google skips the answer if the query doesn't have clear intent.
     * </pre>
     *
     * <code>NON_ANSWER_SEEKING_QUERY_IGNORED_V2 = 8;</code>
     */
    public static final int NON_ANSWER_SEEKING_QUERY_IGNORED_V2_VALUE = 8;

    /**
     *
     *
     * <pre>
     * The low-grounded answer case.
     *
     * Google skips the answer if a well grounded answer was unable to be
     * generated.
     * </pre>
     *
     * <code>LOW_GROUNDED_ANSWER = 9;</code>
     */
    public static final int LOW_GROUNDED_ANSWER_VALUE = 9;

    /**
     *
     *
     * <pre>
     * The user defined query classification ignored case.
     *
     * Google skips the answer if the query is classified as a user defined
     * query classification.
     * </pre>
     *
     * <code>USER_DEFINED_CLASSIFICATION_QUERY_IGNORED = 10;</code>
     */
    public static final int USER_DEFINED_CLASSIFICATION_QUERY_IGNORED_VALUE = 10;

    /**
     *
     *
     * <pre>
     * The unhelpful answer case.
     *
     * Google skips the answer if the answer is not helpful. This can be due to
     * a variety of factors, including but not limited to: the query is not
     * answerable, the answer is not relevant to the query, or the answer is
     * not well-formatted.
     * </pre>
     *
     * <code>UNHELPFUL_ANSWER = 11;</code>
     */
    public static final int UNHELPFUL_ANSWER_VALUE = 11;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AnswerSkippedReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AnswerSkippedReason forNumber(int value) {
      switch (value) {
        case 0:
          return ANSWER_SKIPPED_REASON_UNSPECIFIED;
        case 1:
          return ADVERSARIAL_QUERY_IGNORED;
        case 2:
          return NON_ANSWER_SEEKING_QUERY_IGNORED;
        case 3:
          return OUT_OF_DOMAIN_QUERY_IGNORED;
        case 4:
          return POTENTIAL_POLICY_VIOLATION;
        case 5:
          return NO_RELEVANT_CONTENT;
        case 6:
          return JAIL_BREAKING_QUERY_IGNORED;
        case 7:
          return CUSTOMER_POLICY_VIOLATION;
        case 8:
          return NON_ANSWER_SEEKING_QUERY_IGNORED_V2;
        case 9:
          return LOW_GROUNDED_ANSWER;
        case 10:
          return USER_DEFINED_CLASSIFICATION_QUERY_IGNORED;
        case 11:
          return UNHELPFUL_ANSWER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AnswerSkippedReason>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AnswerSkippedReason>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AnswerSkippedReason>() {
              public AnswerSkippedReason findValueByNumber(int number) {
                return AnswerSkippedReason.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.Answer.getDescriptor().getEnumTypes().get(1);
    }

    private static final AnswerSkippedReason[] VALUES = values();

    public static AnswerSkippedReason valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AnswerSkippedReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason)
  }

  public interface CitationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Citation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Index indicates the start of the segment, measured in bytes (UTF-8
     * unicode). If there are multi-byte characters,such as non-ASCII
     * characters, the index measurement is longer than the string length.
     * </pre>
     *
     * <code>int64 start_index = 1;</code>
     *
     * @return The startIndex.
     */
    long getStartIndex();

    /**
     *
     *
     * <pre>
     * End of the attributed segment, exclusive. Measured in bytes (UTF-8
     * unicode). If there are multi-byte characters,such as non-ASCII
     * characters, the index measurement is longer than the string length.
     * </pre>
     *
     * <code>int64 end_index = 2;</code>
     *
     * @return The endIndex.
     */
    long getEndIndex();

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource> getSourcesList();

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    com.google.cloud.discoveryengine.v1.Answer.CitationSource getSources(int index);

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    int getSourcesCount();

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
        getSourcesOrBuilderList();

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder getSourcesOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * Citation info for a segment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Citation}
   */
  public static final class Citation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Citation)
      CitationOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Citation.newBuilder() to construct.
    private Citation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Citation() {
      sources_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Citation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_Citation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_Citation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Answer.Citation.class,
              com.google.cloud.discoveryengine.v1.Answer.Citation.Builder.class);
    }

    public static final int START_INDEX_FIELD_NUMBER = 1;
    private long startIndex_ = 0L;

    /**
     *
     *
     * <pre>
     * Index indicates the start of the segment, measured in bytes (UTF-8
     * unicode). If there are multi-byte characters,such as non-ASCII
     * characters, the index measurement is longer than the string length.
     * </pre>
     *
     * <code>int64 start_index = 1;</code>
     *
     * @return The startIndex.
     */
    @java.lang.Override
    public long getStartIndex() {
      return startIndex_;
    }

    public static final int END_INDEX_FIELD_NUMBER = 2;
    private long endIndex_ = 0L;

    /**
     *
     *
     * <pre>
     * End of the attributed segment, exclusive. Measured in bytes (UTF-8
     * unicode). If there are multi-byte characters,such as non-ASCII
     * characters, the index measurement is longer than the string length.
     * </pre>
     *
     * <code>int64 end_index = 2;</code>
     *
     * @return The endIndex.
     */
    @java.lang.Override
    public long getEndIndex() {
      return endIndex_;
    }

    public static final int SOURCES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource> sources_;

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource>
        getSourcesList() {
      return sources_;
    }

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
        getSourcesOrBuilderList() {
      return sources_;
    }

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    @java.lang.Override
    public int getSourcesCount() {
      return sources_.size();
    }

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.CitationSource getSources(int index) {
      return sources_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Citation sources for the attributed segment.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder getSourcesOrBuilder(
        int index) {
      return sources_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (startIndex_ != 0L) {
        output.writeInt64(1, startIndex_);
      }
      if (endIndex_ != 0L) {
        output.writeInt64(2, endIndex_);
      }
      for (int i = 0; i < sources_.size(); i++) {
        output.writeMessage(3, sources_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (startIndex_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, startIndex_);
      }
      if (endIndex_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, endIndex_);
      }
      for (int i = 0; i < sources_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, sources_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.Citation)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Answer.Citation other =
          (com.google.cloud.discoveryengine.v1.Answer.Citation) obj;

      if (getStartIndex() != other.getStartIndex()) return false;
      if (getEndIndex() != other.getEndIndex()) return false;
      if (!getSourcesList().equals(other.getSourcesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + START_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStartIndex());
      hash = (37 * hash) + END_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEndIndex());
      if (getSourcesCount() > 0) {
        hash = (37 * hash) + SOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getSourcesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Answer.Citation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Citation info for a segment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Citation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Citation)
        com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Citation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Citation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.Citation.class,
                com.google.cloud.discoveryengine.v1.Answer.Citation.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Answer.Citation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startIndex_ = 0L;
        endIndex_ = 0L;
        if (sourcesBuilder_ == null) {
          sources_ = java.util.Collections.emptyList();
        } else {
          sources_ = null;
          sourcesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Citation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Citation getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Answer.Citation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Citation build() {
        com.google.cloud.discoveryengine.v1.Answer.Citation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Citation buildPartial() {
        com.google.cloud.discoveryengine.v1.Answer.Citation result =
            new com.google.cloud.discoveryengine.v1.Answer.Citation(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.Answer.Citation result) {
        if (sourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            sources_ = java.util.Collections.unmodifiableList(sources_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.sources_ = sources_;
        } else {
          result.sources_ = sourcesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Answer.Citation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startIndex_ = startIndex_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.endIndex_ = endIndex_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Answer.Citation) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Answer.Citation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Answer.Citation other) {
        if (other == com.google.cloud.discoveryengine.v1.Answer.Citation.getDefaultInstance())
          return this;
        if (other.getStartIndex() != 0L) {
          setStartIndex(other.getStartIndex());
        }
        if (other.getEndIndex() != 0L) {
          setEndIndex(other.getEndIndex());
        }
        if (sourcesBuilder_ == null) {
          if (!other.sources_.isEmpty()) {
            if (sources_.isEmpty()) {
              sources_ = other.sources_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureSourcesIsMutable();
              sources_.addAll(other.sources_);
            }
            onChanged();
          }
        } else {
          if (!other.sources_.isEmpty()) {
            if (sourcesBuilder_.isEmpty()) {
              sourcesBuilder_.dispose();
              sourcesBuilder_ = null;
              sources_ = other.sources_;
              bitField0_ = (bitField0_ & ~0x00000004);
              sourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSourcesFieldBuilder()
                      : null;
            } else {
              sourcesBuilder_.addAllMessages(other.sources_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  startIndex_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  endIndex_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  com.google.cloud.discoveryengine.v1.Answer.CitationSource m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.Answer.CitationSource.parser(),
                          extensionRegistry);
                  if (sourcesBuilder_ == null) {
                    ensureSourcesIsMutable();
                    sources_.add(m);
                  } else {
                    sourcesBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long startIndex_;

      /**
       *
       *
       * <pre>
       * Index indicates the start of the segment, measured in bytes (UTF-8
       * unicode). If there are multi-byte characters,such as non-ASCII
       * characters, the index measurement is longer than the string length.
       * </pre>
       *
       * <code>int64 start_index = 1;</code>
       *
       * @return The startIndex.
       */
      @java.lang.Override
      public long getStartIndex() {
        return startIndex_;
      }

      /**
       *
       *
       * <pre>
       * Index indicates the start of the segment, measured in bytes (UTF-8
       * unicode). If there are multi-byte characters,such as non-ASCII
       * characters, the index measurement is longer than the string length.
       * </pre>
       *
       * <code>int64 start_index = 1;</code>
       *
       * @param value The startIndex to set.
       * @return This builder for chaining.
       */
      public Builder setStartIndex(long value) {

        startIndex_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Index indicates the start of the segment, measured in bytes (UTF-8
       * unicode). If there are multi-byte characters,such as non-ASCII
       * characters, the index measurement is longer than the string length.
       * </pre>
       *
       * <code>int64 start_index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStartIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startIndex_ = 0L;
        onChanged();
        return this;
      }

      private long endIndex_;

      /**
       *
       *
       * <pre>
       * End of the attributed segment, exclusive. Measured in bytes (UTF-8
       * unicode). If there are multi-byte characters,such as non-ASCII
       * characters, the index measurement is longer than the string length.
       * </pre>
       *
       * <code>int64 end_index = 2;</code>
       *
       * @return The endIndex.
       */
      @java.lang.Override
      public long getEndIndex() {
        return endIndex_;
      }

      /**
       *
       *
       * <pre>
       * End of the attributed segment, exclusive. Measured in bytes (UTF-8
       * unicode). If there are multi-byte characters,such as non-ASCII
       * characters, the index measurement is longer than the string length.
       * </pre>
       *
       * <code>int64 end_index = 2;</code>
       *
       * @param value The endIndex to set.
       * @return This builder for chaining.
       */
      public Builder setEndIndex(long value) {

        endIndex_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * End of the attributed segment, exclusive. Measured in bytes (UTF-8
       * unicode). If there are multi-byte characters,such as non-ASCII
       * characters, the index measurement is longer than the string length.
       * </pre>
       *
       * <code>int64 end_index = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        endIndex_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource> sources_ =
          java.util.Collections.emptyList();

      private void ensureSourcesIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          sources_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Answer.CitationSource>(
                  sources_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.CitationSource,
              com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder,
              com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
          sourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource>
          getSourcesList() {
        if (sourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(sources_);
        } else {
          return sourcesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public int getSourcesCount() {
        if (sourcesBuilder_ == null) {
          return sources_.size();
        } else {
          return sourcesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource getSources(int index) {
        if (sourcesBuilder_ == null) {
          return sources_.get(index);
        } else {
          return sourcesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder setSources(
          int index, com.google.cloud.discoveryengine.v1.Answer.CitationSource value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.set(index, value);
          onChanged();
        } else {
          sourcesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder setSources(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.set(index, builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder addSources(com.google.cloud.discoveryengine.v1.Answer.CitationSource value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.add(value);
          onChanged();
        } else {
          sourcesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder addSources(
          int index, com.google.cloud.discoveryengine.v1.Answer.CitationSource value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.add(index, value);
          onChanged();
        } else {
          sourcesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder addSources(
          com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.add(builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder addSources(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.add(index, builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder addAllSources(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Answer.CitationSource>
              values) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sources_);
          onChanged();
        } else {
          sourcesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder clearSources() {
        if (sourcesBuilder_ == null) {
          sources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          sourcesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public Builder removeSources(int index) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.remove(index);
          onChanged();
        } else {
          sourcesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder getSourcesBuilder(
          int index) {
        return getSourcesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder getSourcesOrBuilder(
          int index) {
        if (sourcesBuilder_ == null) {
          return sources_.get(index);
        } else {
          return sourcesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
          getSourcesOrBuilderList() {
        if (sourcesBuilder_ != null) {
          return sourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(sources_);
        }
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder addSourcesBuilder() {
        return getSourcesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.Answer.CitationSource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder addSourcesBuilder(
          int index) {
        return getSourcesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.Answer.CitationSource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Citation sources for the attributed segment.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 3;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder>
          getSourcesBuilderList() {
        return getSourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.CitationSource,
              com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder,
              com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
          getSourcesFieldBuilder() {
        if (sourcesBuilder_ == null) {
          sourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.CitationSource,
                  com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder,
                  com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>(
                  sources_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          sources_ = null;
        }
        return sourcesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Citation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Citation)
    private static final com.google.cloud.discoveryengine.v1.Answer.Citation DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.Citation();
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Citation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Citation> PARSER =
        new com.google.protobuf.AbstractParser<Citation>() {
          @java.lang.Override
          public Citation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Citation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Citation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Citation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CitationSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.CitationSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * ID of the citation source.
     * </pre>
     *
     * <code>string reference_id = 1;</code>
     *
     * @return The referenceId.
     */
    java.lang.String getReferenceId();

    /**
     *
     *
     * <pre>
     * ID of the citation source.
     * </pre>
     *
     * <code>string reference_id = 1;</code>
     *
     * @return The bytes for referenceId.
     */
    com.google.protobuf.ByteString getReferenceIdBytes();
  }

  /**
   *
   *
   * <pre>
   * Citation source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.CitationSource}
   */
  public static final class CitationSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.CitationSource)
      CitationSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CitationSource.newBuilder() to construct.
    private CitationSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CitationSource() {
      referenceId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CitationSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_CitationSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_CitationSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Answer.CitationSource.class,
              com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder.class);
    }

    public static final int REFERENCE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object referenceId_ = "";

    /**
     *
     *
     * <pre>
     * ID of the citation source.
     * </pre>
     *
     * <code>string reference_id = 1;</code>
     *
     * @return The referenceId.
     */
    @java.lang.Override
    public java.lang.String getReferenceId() {
      java.lang.Object ref = referenceId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referenceId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * ID of the citation source.
     * </pre>
     *
     * <code>string reference_id = 1;</code>
     *
     * @return The bytes for referenceId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getReferenceIdBytes() {
      java.lang.Object ref = referenceId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        referenceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(referenceId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, referenceId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(referenceId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, referenceId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.CitationSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Answer.CitationSource other =
          (com.google.cloud.discoveryengine.v1.Answer.CitationSource) obj;

      if (!getReferenceId().equals(other.getReferenceId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REFERENCE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getReferenceId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Answer.CitationSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Citation source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.CitationSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.CitationSource)
        com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_CitationSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_CitationSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.CitationSource.class,
                com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Answer.CitationSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        referenceId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_CitationSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Answer.CitationSource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource build() {
        com.google.cloud.discoveryengine.v1.Answer.CitationSource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource buildPartial() {
        com.google.cloud.discoveryengine.v1.Answer.CitationSource result =
            new com.google.cloud.discoveryengine.v1.Answer.CitationSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Answer.CitationSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.referenceId_ = referenceId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Answer.CitationSource) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Answer.CitationSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Answer.CitationSource other) {
        if (other == com.google.cloud.discoveryengine.v1.Answer.CitationSource.getDefaultInstance())
          return this;
        if (!other.getReferenceId().isEmpty()) {
          referenceId_ = other.referenceId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  referenceId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object referenceId_ = "";

      /**
       *
       *
       * <pre>
       * ID of the citation source.
       * </pre>
       *
       * <code>string reference_id = 1;</code>
       *
       * @return The referenceId.
       */
      public java.lang.String getReferenceId() {
        java.lang.Object ref = referenceId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          referenceId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * ID of the citation source.
       * </pre>
       *
       * <code>string reference_id = 1;</code>
       *
       * @return The bytes for referenceId.
       */
      public com.google.protobuf.ByteString getReferenceIdBytes() {
        java.lang.Object ref = referenceId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          referenceId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * ID of the citation source.
       * </pre>
       *
       * <code>string reference_id = 1;</code>
       *
       * @param value The referenceId to set.
       * @return This builder for chaining.
       */
      public Builder setReferenceId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * ID of the citation source.
       * </pre>
       *
       * <code>string reference_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReferenceId() {
        referenceId_ = getDefaultInstance().getReferenceId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * ID of the citation source.
       * </pre>
       *
       * <code>string reference_id = 1;</code>
       *
       * @param value The bytes for referenceId to set.
       * @return This builder for chaining.
       */
      public Builder setReferenceIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        referenceId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.CitationSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.CitationSource)
    private static final com.google.cloud.discoveryengine.v1.Answer.CitationSource DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.CitationSource();
    }

    public static com.google.cloud.discoveryengine.v1.Answer.CitationSource getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CitationSource> PARSER =
        new com.google.protobuf.AbstractParser<CitationSource>() {
          @java.lang.Override
          public CitationSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CitationSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CitationSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.CitationSource getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GroundingSupportOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.GroundingSupport)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Index indicates the start of the claim, measured in bytes
     * (UTF-8 unicode).
     * </pre>
     *
     * <code>int64 start_index = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The startIndex.
     */
    long getStartIndex();

    /**
     *
     *
     * <pre>
     * Required. End of the claim, exclusive.
     * </pre>
     *
     * <code>int64 end_index = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endIndex.
     */
    long getEndIndex();

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded is a specific
     * claim by the references.
     * Higher value means that the claim is better supported by the reference
     * chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 3;</code>
     *
     * @return Whether the groundingScore field is set.
     */
    boolean hasGroundingScore();

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded is a specific
     * claim by the references.
     * Higher value means that the claim is better supported by the reference
     * chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 3;</code>
     *
     * @return The groundingScore.
     */
    double getGroundingScore();

    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the
     * system decided this claim didn't require attribution/grounding check,
     * this field is set to false. In that case, no grounding check was
     * done for the claim and therefore `grounding_score`, `sources` is not
     * returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 4;</code>
     *
     * @return Whether the groundingCheckRequired field is set.
     */
    boolean hasGroundingCheckRequired();

    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the
     * system decided this claim didn't require attribution/grounding check,
     * this field is set to false. In that case, no grounding check was
     * done for the claim and therefore `grounding_score`, `sources` is not
     * returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 4;</code>
     *
     * @return The groundingCheckRequired.
     */
    boolean getGroundingCheckRequired();

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource> getSourcesList();

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Answer.CitationSource getSources(int index);

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getSourcesCount();

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
        getSourcesOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder getSourcesOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * Grounding support for a claim in `answer_text`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.GroundingSupport}
   */
  public static final class GroundingSupport extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.GroundingSupport)
      GroundingSupportOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use GroundingSupport.newBuilder() to construct.
    private GroundingSupport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GroundingSupport() {
      sources_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GroundingSupport();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_GroundingSupport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_GroundingSupport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.class,
              com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder.class);
    }

    private int bitField0_;
    public static final int START_INDEX_FIELD_NUMBER = 1;
    private long startIndex_ = 0L;

    /**
     *
     *
     * <pre>
     * Required. Index indicates the start of the claim, measured in bytes
     * (UTF-8 unicode).
     * </pre>
     *
     * <code>int64 start_index = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The startIndex.
     */
    @java.lang.Override
    public long getStartIndex() {
      return startIndex_;
    }

    public static final int END_INDEX_FIELD_NUMBER = 2;
    private long endIndex_ = 0L;

    /**
     *
     *
     * <pre>
     * Required. End of the claim, exclusive.
     * </pre>
     *
     * <code>int64 end_index = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endIndex.
     */
    @java.lang.Override
    public long getEndIndex() {
      return endIndex_;
    }

    public static final int GROUNDING_SCORE_FIELD_NUMBER = 3;
    private double groundingScore_ = 0D;

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded is a specific
     * claim by the references.
     * Higher value means that the claim is better supported by the reference
     * chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 3;</code>
     *
     * @return Whether the groundingScore field is set.
     */
    @java.lang.Override
    public boolean hasGroundingScore() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded is a specific
     * claim by the references.
     * Higher value means that the claim is better supported by the reference
     * chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 3;</code>
     *
     * @return The groundingScore.
     */
    @java.lang.Override
    public double getGroundingScore() {
      return groundingScore_;
    }

    public static final int GROUNDING_CHECK_REQUIRED_FIELD_NUMBER = 4;
    private boolean groundingCheckRequired_ = false;

    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the
     * system decided this claim didn't require attribution/grounding check,
     * this field is set to false. In that case, no grounding check was
     * done for the claim and therefore `grounding_score`, `sources` is not
     * returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 4;</code>
     *
     * @return Whether the groundingCheckRequired field is set.
     */
    @java.lang.Override
    public boolean hasGroundingCheckRequired() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates that this claim required grounding check. When the
     * system decided this claim didn't require attribution/grounding check,
     * this field is set to false. In that case, no grounding check was
     * done for the claim and therefore `grounding_score`, `sources` is not
     * returned.
     * </pre>
     *
     * <code>optional bool grounding_check_required = 4;</code>
     *
     * @return The groundingCheckRequired.
     */
    @java.lang.Override
    public boolean getGroundingCheckRequired() {
      return groundingCheckRequired_;
    }

    public static final int SOURCES_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource> sources_;

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource>
        getSourcesList() {
      return sources_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
        getSourcesOrBuilderList() {
      return sources_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getSourcesCount() {
      return sources_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.CitationSource getSources(int index) {
      return sources_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Citation sources for the claim.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder getSourcesOrBuilder(
        int index) {
      return sources_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (startIndex_ != 0L) {
        output.writeInt64(1, startIndex_);
      }
      if (endIndex_ != 0L) {
        output.writeInt64(2, endIndex_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(3, groundingScore_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBool(4, groundingCheckRequired_);
      }
      for (int i = 0; i < sources_.size(); i++) {
        output.writeMessage(5, sources_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (startIndex_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, startIndex_);
      }
      if (endIndex_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, endIndex_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, groundingScore_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, groundingCheckRequired_);
      }
      for (int i = 0; i < sources_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, sources_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.GroundingSupport)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Answer.GroundingSupport other =
          (com.google.cloud.discoveryengine.v1.Answer.GroundingSupport) obj;

      if (getStartIndex() != other.getStartIndex()) return false;
      if (getEndIndex() != other.getEndIndex()) return false;
      if (hasGroundingScore() != other.hasGroundingScore()) return false;
      if (hasGroundingScore()) {
        if (java.lang.Double.doubleToLongBits(getGroundingScore())
            != java.lang.Double.doubleToLongBits(other.getGroundingScore())) return false;
      }
      if (hasGroundingCheckRequired() != other.hasGroundingCheckRequired()) return false;
      if (hasGroundingCheckRequired()) {
        if (getGroundingCheckRequired() != other.getGroundingCheckRequired()) return false;
      }
      if (!getSourcesList().equals(other.getSourcesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + START_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStartIndex());
      hash = (37 * hash) + END_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEndIndex());
      if (hasGroundingScore()) {
        hash = (37 * hash) + GROUNDING_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getGroundingScore()));
      }
      if (hasGroundingCheckRequired()) {
        hash = (37 * hash) + GROUNDING_CHECK_REQUIRED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGroundingCheckRequired());
      }
      if (getSourcesCount() > 0) {
        hash = (37 * hash) + SOURCES_FIELD_NUMBER;
        hash = (53 * hash) + getSourcesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Grounding support for a claim in `answer_text`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.GroundingSupport}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.GroundingSupport)
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_GroundingSupport_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_GroundingSupport_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.class,
                com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startIndex_ = 0L;
        endIndex_ = 0L;
        groundingScore_ = 0D;
        groundingCheckRequired_ = false;
        if (sourcesBuilder_ == null) {
          sources_ = java.util.Collections.emptyList();
        } else {
          sources_ = null;
          sourcesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_GroundingSupport_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport build() {
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport buildPartial() {
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport result =
            new com.google.cloud.discoveryengine.v1.Answer.GroundingSupport(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.Answer.GroundingSupport result) {
        if (sourcesBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            sources_ = java.util.Collections.unmodifiableList(sources_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.sources_ = sources_;
        } else {
          result.sources_ = sourcesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Answer.GroundingSupport result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startIndex_ = startIndex_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.endIndex_ = endIndex_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.groundingScore_ = groundingScore_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.groundingCheckRequired_ = groundingCheckRequired_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Answer.GroundingSupport) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Answer.GroundingSupport) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Answer.GroundingSupport other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.getDefaultInstance())
          return this;
        if (other.getStartIndex() != 0L) {
          setStartIndex(other.getStartIndex());
        }
        if (other.getEndIndex() != 0L) {
          setEndIndex(other.getEndIndex());
        }
        if (other.hasGroundingScore()) {
          setGroundingScore(other.getGroundingScore());
        }
        if (other.hasGroundingCheckRequired()) {
          setGroundingCheckRequired(other.getGroundingCheckRequired());
        }
        if (sourcesBuilder_ == null) {
          if (!other.sources_.isEmpty()) {
            if (sources_.isEmpty()) {
              sources_ = other.sources_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureSourcesIsMutable();
              sources_.addAll(other.sources_);
            }
            onChanged();
          }
        } else {
          if (!other.sources_.isEmpty()) {
            if (sourcesBuilder_.isEmpty()) {
              sourcesBuilder_.dispose();
              sourcesBuilder_ = null;
              sources_ = other.sources_;
              bitField0_ = (bitField0_ & ~0x00000010);
              sourcesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSourcesFieldBuilder()
                      : null;
            } else {
              sourcesBuilder_.addAllMessages(other.sources_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  startIndex_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  endIndex_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 25:
                {
                  groundingScore_ = input.readDouble();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 25
              case 32:
                {
                  groundingCheckRequired_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  com.google.cloud.discoveryengine.v1.Answer.CitationSource m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.Answer.CitationSource.parser(),
                          extensionRegistry);
                  if (sourcesBuilder_ == null) {
                    ensureSourcesIsMutable();
                    sources_.add(m);
                  } else {
                    sourcesBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long startIndex_;

      /**
       *
       *
       * <pre>
       * Required. Index indicates the start of the claim, measured in bytes
       * (UTF-8 unicode).
       * </pre>
       *
       * <code>int64 start_index = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The startIndex.
       */
      @java.lang.Override
      public long getStartIndex() {
        return startIndex_;
      }

      /**
       *
       *
       * <pre>
       * Required. Index indicates the start of the claim, measured in bytes
       * (UTF-8 unicode).
       * </pre>
       *
       * <code>int64 start_index = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The startIndex to set.
       * @return This builder for chaining.
       */
      public Builder setStartIndex(long value) {

        startIndex_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Index indicates the start of the claim, measured in bytes
       * (UTF-8 unicode).
       * </pre>
       *
       * <code>int64 start_index = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStartIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startIndex_ = 0L;
        onChanged();
        return this;
      }

      private long endIndex_;

      /**
       *
       *
       * <pre>
       * Required. End of the claim, exclusive.
       * </pre>
       *
       * <code>int64 end_index = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The endIndex.
       */
      @java.lang.Override
      public long getEndIndex() {
        return endIndex_;
      }

      /**
       *
       *
       * <pre>
       * Required. End of the claim, exclusive.
       * </pre>
       *
       * <code>int64 end_index = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The endIndex to set.
       * @return This builder for chaining.
       */
      public Builder setEndIndex(long value) {

        endIndex_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. End of the claim, exclusive.
       * </pre>
       *
       * <code>int64 end_index = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndIndex() {
        bitField0_ = (bitField0_ & ~0x00000002);
        endIndex_ = 0L;
        onChanged();
        return this;
      }

      private double groundingScore_;

      /**
       *
       *
       * <pre>
       * A score in the range of [0, 1] describing how grounded is a specific
       * claim by the references.
       * Higher value means that the claim is better supported by the reference
       * chunks.
       * </pre>
       *
       * <code>optional double grounding_score = 3;</code>
       *
       * @return Whether the groundingScore field is set.
       */
      @java.lang.Override
      public boolean hasGroundingScore() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * A score in the range of [0, 1] describing how grounded is a specific
       * claim by the references.
       * Higher value means that the claim is better supported by the reference
       * chunks.
       * </pre>
       *
       * <code>optional double grounding_score = 3;</code>
       *
       * @return The groundingScore.
       */
      @java.lang.Override
      public double getGroundingScore() {
        return groundingScore_;
      }

      /**
       *
       *
       * <pre>
       * A score in the range of [0, 1] describing how grounded is a specific
       * claim by the references.
       * Higher value means that the claim is better supported by the reference
       * chunks.
       * </pre>
       *
       * <code>optional double grounding_score = 3;</code>
       *
       * @param value The groundingScore to set.
       * @return This builder for chaining.
       */
      public Builder setGroundingScore(double value) {

        groundingScore_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A score in the range of [0, 1] describing how grounded is a specific
       * claim by the references.
       * Higher value means that the claim is better supported by the reference
       * chunks.
       * </pre>
       *
       * <code>optional double grounding_score = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroundingScore() {
        bitField0_ = (bitField0_ & ~0x00000004);
        groundingScore_ = 0D;
        onChanged();
        return this;
      }

      private boolean groundingCheckRequired_;

      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the
       * system decided this claim didn't require attribution/grounding check,
       * this field is set to false. In that case, no grounding check was
       * done for the claim and therefore `grounding_score`, `sources` is not
       * returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 4;</code>
       *
       * @return Whether the groundingCheckRequired field is set.
       */
      @java.lang.Override
      public boolean hasGroundingCheckRequired() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the
       * system decided this claim didn't require attribution/grounding check,
       * this field is set to false. In that case, no grounding check was
       * done for the claim and therefore `grounding_score`, `sources` is not
       * returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 4;</code>
       *
       * @return The groundingCheckRequired.
       */
      @java.lang.Override
      public boolean getGroundingCheckRequired() {
        return groundingCheckRequired_;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the
       * system decided this claim didn't require attribution/grounding check,
       * this field is set to false. In that case, no grounding check was
       * done for the claim and therefore `grounding_score`, `sources` is not
       * returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 4;</code>
       *
       * @param value The groundingCheckRequired to set.
       * @return This builder for chaining.
       */
      public Builder setGroundingCheckRequired(boolean value) {

        groundingCheckRequired_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that this claim required grounding check. When the
       * system decided this claim didn't require attribution/grounding check,
       * this field is set to false. In that case, no grounding check was
       * done for the claim and therefore `grounding_score`, `sources` is not
       * returned.
       * </pre>
       *
       * <code>optional bool grounding_check_required = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroundingCheckRequired() {
        bitField0_ = (bitField0_ & ~0x00000008);
        groundingCheckRequired_ = false;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource> sources_ =
          java.util.Collections.emptyList();

      private void ensureSourcesIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          sources_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Answer.CitationSource>(
                  sources_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.CitationSource,
              com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder,
              com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
          sourcesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource>
          getSourcesList() {
        if (sourcesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(sources_);
        } else {
          return sourcesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getSourcesCount() {
        if (sourcesBuilder_ == null) {
          return sources_.size();
        } else {
          return sourcesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource getSources(int index) {
        if (sourcesBuilder_ == null) {
          return sources_.get(index);
        } else {
          return sourcesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSources(
          int index, com.google.cloud.discoveryengine.v1.Answer.CitationSource value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.set(index, value);
          onChanged();
        } else {
          sourcesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSources(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.set(index, builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(com.google.cloud.discoveryengine.v1.Answer.CitationSource value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.add(value);
          onChanged();
        } else {
          sourcesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(
          int index, com.google.cloud.discoveryengine.v1.Answer.CitationSource value) {
        if (sourcesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSourcesIsMutable();
          sources_.add(index, value);
          onChanged();
        } else {
          sourcesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(
          com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.add(builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSources(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder builderForValue) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.add(index, builderForValue.build());
          onChanged();
        } else {
          sourcesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllSources(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Answer.CitationSource>
              values) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sources_);
          onChanged();
        } else {
          sourcesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSources() {
        if (sourcesBuilder_ == null) {
          sources_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          sourcesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeSources(int index) {
        if (sourcesBuilder_ == null) {
          ensureSourcesIsMutable();
          sources_.remove(index);
          onChanged();
        } else {
          sourcesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder getSourcesBuilder(
          int index) {
        return getSourcesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder getSourcesOrBuilder(
          int index) {
        if (sourcesBuilder_ == null) {
          return sources_.get(index);
        } else {
          return sourcesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
          getSourcesOrBuilderList() {
        if (sourcesBuilder_ != null) {
          return sourcesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(sources_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder addSourcesBuilder() {
        return getSourcesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.Answer.CitationSource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder addSourcesBuilder(
          int index) {
        return getSourcesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.Answer.CitationSource.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Citation sources for the claim.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.CitationSource sources = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder>
          getSourcesBuilderList() {
        return getSourcesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.CitationSource,
              com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder,
              com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>
          getSourcesFieldBuilder() {
        if (sourcesBuilder_ == null) {
          sourcesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.CitationSource,
                  com.google.cloud.discoveryengine.v1.Answer.CitationSource.Builder,
                  com.google.cloud.discoveryengine.v1.Answer.CitationSourceOrBuilder>(
                  sources_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
          sources_ = null;
        }
        return sourcesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.GroundingSupport)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.GroundingSupport)
    private static final com.google.cloud.discoveryengine.v1.Answer.GroundingSupport
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.GroundingSupport();
    }

    public static com.google.cloud.discoveryengine.v1.Answer.GroundingSupport getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroundingSupport> PARSER =
        new com.google.protobuf.AbstractParser<GroundingSupport>() {
          @java.lang.Override
          public GroundingSupport parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GroundingSupport> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroundingSupport> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Reference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Unstructured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
     * </code>
     *
     * @return Whether the unstructuredDocumentInfo field is set.
     */
    boolean hasUnstructuredDocumentInfo();

    /**
     *
     *
     * <pre>
     * Unstructured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
     * </code>
     *
     * @return The unstructuredDocumentInfo.
     */
    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
        getUnstructuredDocumentInfo();

    /**
     *
     *
     * <pre>
     * Unstructured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfoOrBuilder
        getUnstructuredDocumentInfoOrBuilder();

    /**
     *
     *
     * <pre>
     * Chunk information.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
     *
     * @return Whether the chunkInfo field is set.
     */
    boolean hasChunkInfo();

    /**
     *
     *
     * <pre>
     * Chunk information.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
     *
     * @return The chunkInfo.
     */
    com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo getChunkInfo();

    /**
     *
     *
     * <pre>
     * Chunk information.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
     */
    com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfoOrBuilder getChunkInfoOrBuilder();

    /**
     *
     *
     * <pre>
     * Structured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
     * </code>
     *
     * @return Whether the structuredDocumentInfo field is set.
     */
    boolean hasStructuredDocumentInfo();

    /**
     *
     *
     * <pre>
     * Structured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
     * </code>
     *
     * @return The structuredDocumentInfo.
     */
    com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
        getStructuredDocumentInfo();

    /**
     *
     *
     * <pre>
     * Structured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfoOrBuilder
        getStructuredDocumentInfoOrBuilder();

    com.google.cloud.discoveryengine.v1.Answer.Reference.ContentCase getContentCase();
  }

  /**
   *
   *
   * <pre>
   * Reference.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Reference}
   */
  public static final class Reference extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Reference)
      ReferenceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Reference.newBuilder() to construct.
    private Reference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Reference() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Reference();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Answer.Reference.class,
              com.google.cloud.discoveryengine.v1.Answer.Reference.Builder.class);
    }

    public interface UnstructuredDocumentInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The document.
       */
      java.lang.String getDocument();

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for document.
       */
      com.google.protobuf.ByteString getDocumentBytes();

      /**
       *
       *
       * <pre>
       * URI for the document.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();

      /**
       *
       *
       * <pre>
       * URI for the document.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();

      /**
       *
       *
       * <pre>
       * Title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();

      /**
       *
       *
       * <pre>
       * Title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent>
          getChunkContentsList();

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent
          getChunkContents(int index);

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      int getChunkContentsCount();

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContentOrBuilder>
          getChunkContentsOrBuilderList();

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
              .ChunkContentOrBuilder
          getChunkContentsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The structured JSON metadata for the document.
       * It is populated from the struct data from the Chunk in search result.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 5;</code>
       *
       * @return Whether the structData field is set.
       */
      boolean hasStructData();

      /**
       *
       *
       * <pre>
       * The structured JSON metadata for the document.
       * It is populated from the struct data from the Chunk in search result.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 5;</code>
       *
       * @return The structData.
       */
      com.google.protobuf.Struct getStructData();

      /**
       *
       *
       * <pre>
       * The structured JSON metadata for the document.
       * It is populated from the struct data from the Chunk in search result.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 5;</code>
       */
      com.google.protobuf.StructOrBuilder getStructDataOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Unstructured document information.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo}
     */
    public static final class UnstructuredDocumentInfo
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
        UnstructuredDocumentInfoOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use UnstructuredDocumentInfo.newBuilder() to construct.
      private UnstructuredDocumentInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private UnstructuredDocumentInfo() {
        document_ = "";
        uri_ = "";
        title_ = "";
        chunkContents_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new UnstructuredDocumentInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.class,
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .Builder.class);
      }

      public interface ChunkContentOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The content.
         */
        java.lang.String getContent();

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The bytes for content.
         */
        com.google.protobuf.ByteString getContentBytes();

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The pageIdentifier.
         */
        java.lang.String getPageIdentifier();

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        com.google.protobuf.ByteString getPageIdentifierBytes();

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @return Whether the relevanceScore field is set.
         */
        boolean hasRelevanceScore();

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @return The relevanceScore.
         */
        float getRelevanceScore();
      }

      /**
       *
       *
       * <pre>
       * Chunk content.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent}
       */
      public static final class ChunkContent extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent)
          ChunkContentOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use ChunkContent.newBuilder() to construct.
        private ChunkContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ChunkContent() {
          content_ = "";
          pageIdentifier_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ChunkContent();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_ChunkContent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_ChunkContent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContent.class,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContent.Builder.class);
        }

        private int bitField0_;
        public static final int CONTENT_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object content_ = "";

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The content.
         */
        @java.lang.Override
        public java.lang.String getContent() {
          java.lang.Object ref = content_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            content_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 1;</code>
         *
         * @return The bytes for content.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getContentBytes() {
          java.lang.Object ref = content_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            content_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int PAGE_IDENTIFIER_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object pageIdentifier_ = "";

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The pageIdentifier.
         */
        @java.lang.Override
        public java.lang.String getPageIdentifier() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            pageIdentifier_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 2;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getPageIdentifierBytes() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            pageIdentifier_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int RELEVANCE_SCORE_FIELD_NUMBER = 3;
        private float relevanceScore_ = 0F;

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @return Whether the relevanceScore field is set.
         */
        @java.lang.Override
        public boolean hasRelevanceScore() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @return The relevanceScore.
         */
        @java.lang.Override
        public float getRelevanceScore() {
          return relevanceScore_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, content_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pageIdentifier_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeFloat(3, relevanceScore_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, content_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, pageIdentifier_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, relevanceScore_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent
              other =
                  (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                          .ChunkContent)
                      obj;

          if (!getContent().equals(other.getContent())) return false;
          if (!getPageIdentifier().equals(other.getPageIdentifier())) return false;
          if (hasRelevanceScore() != other.hasRelevanceScore()) return false;
          if (hasRelevanceScore()) {
            if (java.lang.Float.floatToIntBits(getRelevanceScore())
                != java.lang.Float.floatToIntBits(other.getRelevanceScore())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + CONTENT_FIELD_NUMBER;
          hash = (53 * hash) + getContent().hashCode();
          hash = (37 * hash) + PAGE_IDENTIFIER_FIELD_NUMBER;
          hash = (53 * hash) + getPageIdentifier().hashCode();
          if (hasRelevanceScore()) {
            hash = (37 * hash) + RELEVANCE_SCORE_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getRelevanceScore());
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Chunk content.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent)
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContentOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_ChunkContent_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_ChunkContent_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                        .ChunkContent.class,
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                        .ChunkContent.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            content_ = "";
            pageIdentifier_ = "";
            relevanceScore_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_ChunkContent_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent
              build() {
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent
              buildPartial() {
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent
                result =
                    new com.google.cloud.discoveryengine.v1.Answer.Reference
                        .UnstructuredDocumentInfo.ChunkContent(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContent
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.content_ = content_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.pageIdentifier_ = pageIdentifier_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.relevanceScore_ = relevanceScore_;
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                          .ChunkContent)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContent
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent.getDefaultInstance()) return this;
            if (!other.getContent().isEmpty()) {
              content_ = other.content_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getPageIdentifier().isEmpty()) {
              pageIdentifier_ = other.pageIdentifier_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (other.hasRelevanceScore()) {
              setRelevanceScore(other.getRelevanceScore());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      content_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      pageIdentifier_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 29:
                    {
                      relevanceScore_ = input.readFloat();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 29
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object content_ = "";

          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return The content.
           */
          public java.lang.String getContent() {
            java.lang.Object ref = content_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              content_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return The bytes for content.
           */
          public com.google.protobuf.ByteString getContentBytes() {
            java.lang.Object ref = content_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              content_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @param value The content to set.
           * @return This builder for chaining.
           */
          public Builder setContent(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            content_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearContent() {
            content_ = getDefaultInstance().getContent();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Chunk textual content.
           * </pre>
           *
           * <code>string content = 1;</code>
           *
           * @param value The bytes for content to set.
           * @return This builder for chaining.
           */
          public Builder setContentBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            content_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object pageIdentifier_ = "";

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return The pageIdentifier.
           */
          public java.lang.String getPageIdentifier() {
            java.lang.Object ref = pageIdentifier_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              pageIdentifier_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return The bytes for pageIdentifier.
           */
          public com.google.protobuf.ByteString getPageIdentifierBytes() {
            java.lang.Object ref = pageIdentifier_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              pageIdentifier_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @param value The pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifier(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            pageIdentifier_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPageIdentifier() {
            pageIdentifier_ = getDefaultInstance().getPageIdentifier();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 2;</code>
           *
           * @param value The bytes for pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifierBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            pageIdentifier_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private float relevanceScore_;

          /**
           *
           *
           * <pre>
           * The relevance of the chunk for a given query. Values range from 0.0
           * (completely irrelevant) to 1.0 (completely relevant).
           * This value is for informational purpose only. It may change for
           * the same query and chunk at any time due to a model retraining or
           * change in implementation.
           * </pre>
           *
           * <code>optional float relevance_score = 3;</code>
           *
           * @return Whether the relevanceScore field is set.
           */
          @java.lang.Override
          public boolean hasRelevanceScore() {
            return ((bitField0_ & 0x00000004) != 0);
          }

          /**
           *
           *
           * <pre>
           * The relevance of the chunk for a given query. Values range from 0.0
           * (completely irrelevant) to 1.0 (completely relevant).
           * This value is for informational purpose only. It may change for
           * the same query and chunk at any time due to a model retraining or
           * change in implementation.
           * </pre>
           *
           * <code>optional float relevance_score = 3;</code>
           *
           * @return The relevanceScore.
           */
          @java.lang.Override
          public float getRelevanceScore() {
            return relevanceScore_;
          }

          /**
           *
           *
           * <pre>
           * The relevance of the chunk for a given query. Values range from 0.0
           * (completely irrelevant) to 1.0 (completely relevant).
           * This value is for informational purpose only. It may change for
           * the same query and chunk at any time due to a model retraining or
           * change in implementation.
           * </pre>
           *
           * <code>optional float relevance_score = 3;</code>
           *
           * @param value The relevanceScore to set.
           * @return This builder for chaining.
           */
          public Builder setRelevanceScore(float value) {

            relevanceScore_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * The relevance of the chunk for a given query. Values range from 0.0
           * (completely irrelevant) to 1.0 (completely relevant).
           * This value is for informational purpose only. It may change for
           * the same query and chunk at any time due to a model retraining or
           * change in implementation.
           * </pre>
           *
           * <code>optional float relevance_score = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearRelevanceScore() {
            bitField0_ = (bitField0_ & ~0x00000004);
            relevanceScore_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent)
        private static final com.google.cloud.discoveryengine.v1.Answer.Reference
                .UnstructuredDocumentInfo.ChunkContent
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent();
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ChunkContent> PARSER =
            new com.google.protobuf.AbstractParser<ChunkContent>() {
              @java.lang.Override
              public ChunkContent parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ChunkContent> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ChunkContent> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int DOCUMENT_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object document_ = "";

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The document.
       */
      @java.lang.Override
      public java.lang.String getDocument() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          document_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for document.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDocumentBytes() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          document_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int URI_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object uri_ = "";

      /**
       *
       *
       * <pre>
       * URI for the document.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * URI for the document.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TITLE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";

      /**
       *
       *
       * <pre>
       * Title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Title.
       * </pre>
       *
       * <code>string title = 3;</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CHUNK_CONTENTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent>
          chunkContents_;

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .ChunkContent>
          getChunkContentsList() {
        return chunkContents_;
      }

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContentOrBuilder>
          getChunkContentsOrBuilderList() {
        return chunkContents_;
      }

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public int getChunkContentsCount() {
        return chunkContents_.size();
      }

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
              .ChunkContent
          getChunkContents(int index) {
        return chunkContents_.get(index);
      }

      /**
       *
       *
       * <pre>
       * List of cited chunk contents derived from document content.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
              .ChunkContentOrBuilder
          getChunkContentsOrBuilder(int index) {
        return chunkContents_.get(index);
      }

      public static final int STRUCT_DATA_FIELD_NUMBER = 5;
      private com.google.protobuf.Struct structData_;

      /**
       *
       *
       * <pre>
       * The structured JSON metadata for the document.
       * It is populated from the struct data from the Chunk in search result.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 5;</code>
       *
       * @return Whether the structData field is set.
       */
      @java.lang.Override
      public boolean hasStructData() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The structured JSON metadata for the document.
       * It is populated from the struct data from the Chunk in search result.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 5;</code>
       *
       * @return The structData.
       */
      @java.lang.Override
      public com.google.protobuf.Struct getStructData() {
        return structData_ == null ? com.google.protobuf.Struct.getDefaultInstance() : structData_;
      }

      /**
       *
       *
       * <pre>
       * The structured JSON metadata for the document.
       * It is populated from the struct data from the Chunk in search result.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 5;</code>
       */
      @java.lang.Override
      public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
        return structData_ == null ? com.google.protobuf.Struct.getDefaultInstance() : structData_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, document_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, title_);
        }
        for (int i = 0; i < chunkContents_.size(); i++) {
          output.writeMessage(4, chunkContents_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(5, getStructData());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, document_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, title_);
        }
        for (int i = 0; i < chunkContents_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, chunkContents_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStructData());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo other =
            (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo) obj;

        if (!getDocument().equals(other.getDocument())) return false;
        if (!getUri().equals(other.getUri())) return false;
        if (!getTitle().equals(other.getTitle())) return false;
        if (!getChunkContentsList().equals(other.getChunkContentsList())) return false;
        if (hasStructData() != other.hasStructData()) return false;
        if (hasStructData()) {
          if (!getStructData().equals(other.getStructData())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        if (getChunkContentsCount() > 0) {
          hash = (37 * hash) + CHUNK_CONTENTS_FIELD_NUMBER;
          hash = (53 * hash) + getChunkContentsList().hashCode();
        }
        if (hasStructData()) {
          hash = (37 * hash) + STRUCT_DATA_FIELD_NUMBER;
          hash = (53 * hash) + getStructData().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .class,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getChunkContentsFieldBuilder();
            getStructDataFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          document_ = "";
          uri_ = "";
          title_ = "";
          if (chunkContentsBuilder_ == null) {
            chunkContents_ = java.util.Collections.emptyList();
          } else {
            chunkContents_ = null;
            chunkContentsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          structData_ = null;
          if (structDataBuilder_ != null) {
            structDataBuilder_.dispose();
            structDataBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_UnstructuredDocumentInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
            build() {
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo result =
              new com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo result) {
          if (chunkContentsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              chunkContents_ = java.util.Collections.unmodifiableList(chunkContents_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.chunkContents_ = chunkContents_;
          } else {
            result.chunkContents_ = chunkContentsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.document_ = document_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.uri_ = uri_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.title_ = title_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.structData_ =
                structDataBuilder_ == null ? structData_ : structDataBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                  .getDefaultInstance()) return this;
          if (!other.getDocument().isEmpty()) {
            document_ = other.document_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getUri().isEmpty()) {
            uri_ = other.uri_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (chunkContentsBuilder_ == null) {
            if (!other.chunkContents_.isEmpty()) {
              if (chunkContents_.isEmpty()) {
                chunkContents_ = other.chunkContents_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureChunkContentsIsMutable();
                chunkContents_.addAll(other.chunkContents_);
              }
              onChanged();
            }
          } else {
            if (!other.chunkContents_.isEmpty()) {
              if (chunkContentsBuilder_.isEmpty()) {
                chunkContentsBuilder_.dispose();
                chunkContentsBuilder_ = null;
                chunkContents_ = other.chunkContents_;
                bitField0_ = (bitField0_ & ~0x00000008);
                chunkContentsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getChunkContentsFieldBuilder()
                        : null;
              } else {
                chunkContentsBuilder_.addAllMessages(other.chunkContents_);
              }
            }
          }
          if (other.hasStructData()) {
            mergeStructData(other.getStructData());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    document_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    uri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                            .ChunkContent
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1.Answer.Reference
                                    .UnstructuredDocumentInfo.ChunkContent.parser(),
                                extensionRegistry);
                    if (chunkContentsBuilder_ == null) {
                      ensureChunkContentsIsMutable();
                      chunkContents_.add(m);
                    } else {
                      chunkContentsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(getStructDataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object document_ = "";

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The document.
         */
        public java.lang.String getDocument() {
          java.lang.Object ref = document_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            document_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for document.
         */
        public com.google.protobuf.ByteString getDocumentBytes() {
          java.lang.Object ref = document_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            document_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The document to set.
         * @return This builder for chaining.
         */
        public Builder setDocument(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDocument() {
          document_ = getDefaultInstance().getDocument();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for document to set.
         * @return This builder for chaining.
         */
        public Builder setDocumentBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          document_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object uri_ = "";

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The uri.
         */
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The bytes for uri.
         */
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          uri_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {
          uri_ = getDefaultInstance().getUri();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          uri_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object title_ = "";

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent>
            chunkContents_ = java.util.Collections.emptyList();

        private void ensureChunkContentsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            chunkContents_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                        .ChunkContent>(chunkContents_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent,
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent.Builder,
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContentOrBuilder>
            chunkContentsBuilder_;

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent>
            getChunkContentsList() {
          if (chunkContentsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(chunkContents_);
          } else {
            return chunkContentsBuilder_.getMessageList();
          }
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public int getChunkContentsCount() {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.size();
          } else {
            return chunkContentsBuilder_.getCount();
          }
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent
            getChunkContents(int index) {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.get(index);
          } else {
            return chunkContentsBuilder_.getMessage(index);
          }
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder setChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.set(index, value);
            onChanged();
          } else {
            chunkContentsBuilder_.setMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder setChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent.Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.set(index, builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.add(value);
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent
                value) {
          if (chunkContentsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureChunkContentsIsMutable();
            chunkContents_.add(index, value);
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent.Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.add(builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addChunkContents(
            int index,
            com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent.Builder
                builderForValue) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.add(index, builderForValue.build());
            onChanged();
          } else {
            chunkContentsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder addAllChunkContents(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1.Answer.Reference
                            .UnstructuredDocumentInfo.ChunkContent>
                values) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, chunkContents_);
            onChanged();
          } else {
            chunkContentsBuilder_.addAllMessages(values);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder clearChunkContents() {
          if (chunkContentsBuilder_ == null) {
            chunkContents_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            chunkContentsBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public Builder removeChunkContents(int index) {
          if (chunkContentsBuilder_ == null) {
            ensureChunkContentsIsMutable();
            chunkContents_.remove(index);
            onChanged();
          } else {
            chunkContentsBuilder_.remove(index);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent.Builder
            getChunkContentsBuilder(int index) {
          return getChunkContentsFieldBuilder().getBuilder(index);
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContentOrBuilder
            getChunkContentsOrBuilder(int index) {
          if (chunkContentsBuilder_ == null) {
            return chunkContents_.get(index);
          } else {
            return chunkContentsBuilder_.getMessageOrBuilder(index);
          }
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                        .ChunkContentOrBuilder>
            getChunkContentsOrBuilderList() {
          if (chunkContentsBuilder_ != null) {
            return chunkContentsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(chunkContents_);
          }
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent.Builder
            addChunkContentsBuilder() {
          return getChunkContentsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContent.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                .ChunkContent.Builder
            addChunkContentsBuilder(int index) {
          return getChunkContentsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .ChunkContent.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * List of cited chunk contents derived from document content.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.ChunkContent chunk_contents = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent.Builder>
            getChunkContentsBuilderList() {
          return getChunkContentsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent,
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContent.Builder,
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .ChunkContentOrBuilder>
            getChunkContentsFieldBuilder() {
          if (chunkContentsBuilder_ == null) {
            chunkContentsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                        .ChunkContent,
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                        .ChunkContent.Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                        .ChunkContentOrBuilder>(
                    chunkContents_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            chunkContents_ = null;
          }
          return chunkContentsBuilder_;
        }

        private com.google.protobuf.Struct structData_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>
            structDataBuilder_;

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         *
         * @return Whether the structData field is set.
         */
        public boolean hasStructData() {
          return ((bitField0_ & 0x00000010) != 0);
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         *
         * @return The structData.
         */
        public com.google.protobuf.Struct getStructData() {
          if (structDataBuilder_ == null) {
            return structData_ == null
                ? com.google.protobuf.Struct.getDefaultInstance()
                : structData_;
          } else {
            return structDataBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        public Builder setStructData(com.google.protobuf.Struct value) {
          if (structDataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            structData_ = value;
          } else {
            structDataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        public Builder setStructData(com.google.protobuf.Struct.Builder builderForValue) {
          if (structDataBuilder_ == null) {
            structData_ = builderForValue.build();
          } else {
            structDataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        public Builder mergeStructData(com.google.protobuf.Struct value) {
          if (structDataBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && structData_ != null
                && structData_ != com.google.protobuf.Struct.getDefaultInstance()) {
              getStructDataBuilder().mergeFrom(value);
            } else {
              structData_ = value;
            }
          } else {
            structDataBuilder_.mergeFrom(value);
          }
          if (structData_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        public Builder clearStructData() {
          bitField0_ = (bitField0_ & ~0x00000010);
          structData_ = null;
          if (structDataBuilder_ != null) {
            structDataBuilder_.dispose();
            structDataBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        public com.google.protobuf.Struct.Builder getStructDataBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getStructDataFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
          if (structDataBuilder_ != null) {
            return structDataBuilder_.getMessageOrBuilder();
          } else {
            return structData_ == null
                ? com.google.protobuf.Struct.getDefaultInstance()
                : structData_;
          }
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>
            getStructDataFieldBuilder() {
          if (structDataBuilder_ == null) {
            structDataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Struct,
                    com.google.protobuf.Struct.Builder,
                    com.google.protobuf.StructOrBuilder>(
                    getStructData(), getParentForChildren(), isClean());
            structData_ = null;
          }
          return structDataBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
      private static final com.google.cloud.discoveryengine.v1.Answer.Reference
              .UnstructuredDocumentInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo();
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<UnstructuredDocumentInfo> PARSER =
          new com.google.protobuf.AbstractParser<UnstructuredDocumentInfo>() {
            @java.lang.Override
            public UnstructuredDocumentInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<UnstructuredDocumentInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<UnstructuredDocumentInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ChunkInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Chunk resource name.
       * </pre>
       *
       * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The chunk.
       */
      java.lang.String getChunk();

      /**
       *
       *
       * <pre>
       * Chunk resource name.
       * </pre>
       *
       * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for chunk.
       */
      com.google.protobuf.ByteString getChunkBytes();

      /**
       *
       *
       * <pre>
       * Chunk textual content.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The content.
       */
      java.lang.String getContent();

      /**
       *
       *
       * <pre>
       * Chunk textual content.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The bytes for content.
       */
      com.google.protobuf.ByteString getContentBytes();

      /**
       *
       *
       * <pre>
       * The relevance of the chunk for a given query. Values range from 0.0
       * (completely irrelevant) to 1.0 (completely relevant).
       * This value is for informational purpose only. It may change for
       * the same query and chunk at any time due to a model retraining or
       * change in implementation.
       * </pre>
       *
       * <code>optional float relevance_score = 3;</code>
       *
       * @return Whether the relevanceScore field is set.
       */
      boolean hasRelevanceScore();

      /**
       *
       *
       * <pre>
       * The relevance of the chunk for a given query. Values range from 0.0
       * (completely irrelevant) to 1.0 (completely relevant).
       * This value is for informational purpose only. It may change for
       * the same query and chunk at any time due to a model retraining or
       * change in implementation.
       * </pre>
       *
       * <code>optional float relevance_score = 3;</code>
       *
       * @return The relevanceScore.
       */
      float getRelevanceScore();

      /**
       *
       *
       * <pre>
       * Document metadata.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
       * </code>
       *
       * @return Whether the documentMetadata field is set.
       */
      boolean hasDocumentMetadata();

      /**
       *
       *
       * <pre>
       * Document metadata.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
       * </code>
       *
       * @return The documentMetadata.
       */
      com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
          getDocumentMetadata();

      /**
       *
       *
       * <pre>
       * Document metadata.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadataOrBuilder
          getDocumentMetadataOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Chunk information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo}
     */
    public static final class ChunkInfo extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo)
        ChunkInfoOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ChunkInfo.newBuilder() to construct.
      private ChunkInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ChunkInfo() {
        chunk_ = "";
        content_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ChunkInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.class,
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.Builder.class);
      }

      public interface DocumentMetadataOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The document.
         */
        java.lang.String getDocument();

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for document.
         */
        com.google.protobuf.ByteString getDocumentBytes();

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The uri.
         */
        java.lang.String getUri();

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The bytes for uri.
         */
        com.google.protobuf.ByteString getUriBytes();

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @return The title.
         */
        java.lang.String getTitle();

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @return The bytes for title.
         */
        com.google.protobuf.ByteString getTitleBytes();

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 4;</code>
         *
         * @return The pageIdentifier.
         */
        java.lang.String getPageIdentifier();

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 4;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        com.google.protobuf.ByteString getPageIdentifierBytes();

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         *
         * @return Whether the structData field is set.
         */
        boolean hasStructData();

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         *
         * @return The structData.
         */
        com.google.protobuf.Struct getStructData();

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        com.google.protobuf.StructOrBuilder getStructDataOrBuilder();
      }

      /**
       *
       *
       * <pre>
       * Document metadata.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata}
       */
      public static final class DocumentMetadata extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata)
          DocumentMetadataOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use DocumentMetadata.newBuilder() to construct.
        private DocumentMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DocumentMetadata() {
          document_ = "";
          uri_ = "";
          title_ = "";
          pageIdentifier_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DocumentMetadata();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_DocumentMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_DocumentMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                      .class,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                      .Builder.class);
        }

        private int bitField0_;
        public static final int DOCUMENT_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object document_ = "";

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The document.
         */
        @java.lang.Override
        public java.lang.String getDocument() {
          java.lang.Object ref = document_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            document_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for document.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getDocumentBytes() {
          java.lang.Object ref = document_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            document_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int URI_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private volatile java.lang.Object uri_ = "";

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The uri.
         */
        @java.lang.Override
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * URI for the document.
         * </pre>
         *
         * <code>string uri = 2;</code>
         *
         * @return The bytes for uri.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int TITLE_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private volatile java.lang.Object title_ = "";

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @return The title.
         */
        @java.lang.Override
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Title.
         * </pre>
         *
         * <code>string title = 3;</code>
         *
         * @return The bytes for title.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int PAGE_IDENTIFIER_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private volatile java.lang.Object pageIdentifier_ = "";

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 4;</code>
         *
         * @return The pageIdentifier.
         */
        @java.lang.Override
        public java.lang.String getPageIdentifier() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            pageIdentifier_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Page identifier.
         * </pre>
         *
         * <code>string page_identifier = 4;</code>
         *
         * @return The bytes for pageIdentifier.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getPageIdentifierBytes() {
          java.lang.Object ref = pageIdentifier_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            pageIdentifier_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int STRUCT_DATA_FIELD_NUMBER = 5;
        private com.google.protobuf.Struct structData_;

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         *
         * @return Whether the structData field is set.
         */
        @java.lang.Override
        public boolean hasStructData() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         *
         * @return The structData.
         */
        @java.lang.Override
        public com.google.protobuf.Struct getStructData() {
          return structData_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : structData_;
        }

        /**
         *
         *
         * <pre>
         * The structured JSON metadata for the document.
         * It is populated from the struct data from the Chunk in search result.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 5;</code>
         */
        @java.lang.Override
        public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
          return structData_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : structData_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, document_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, title_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageIdentifier_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(5, getStructData());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, document_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, title_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageIdentifier_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageIdentifier_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStructData());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata other =
              (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata) obj;

          if (!getDocument().equals(other.getDocument())) return false;
          if (!getUri().equals(other.getUri())) return false;
          if (!getTitle().equals(other.getTitle())) return false;
          if (!getPageIdentifier().equals(other.getPageIdentifier())) return false;
          if (hasStructData() != other.hasStructData()) return false;
          if (hasStructData()) {
            if (!getStructData().equals(other.getStructData())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
          hash = (53 * hash) + getDocument().hashCode();
          hash = (37 * hash) + URI_FIELD_NUMBER;
          hash = (53 * hash) + getUri().hashCode();
          hash = (37 * hash) + TITLE_FIELD_NUMBER;
          hash = (53 * hash) + getTitle().hashCode();
          hash = (37 * hash) + PAGE_IDENTIFIER_FIELD_NUMBER;
          hash = (53 * hash) + getPageIdentifier().hashCode();
          if (hasStructData()) {
            hash = (37 * hash) + STRUCT_DATA_FIELD_NUMBER;
            hash = (53 * hash) + getStructData().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata)
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadataOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_DocumentMetadata_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_DocumentMetadata_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                        .class,
                    com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                        .Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getStructDataFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            document_ = "";
            uri_ = "";
            title_ = "";
            pageIdentifier_ = "";
            structData_ = null;
            if (structDataBuilder_ != null) {
              structDataBuilder_.dispose();
              structDataBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_DocumentMetadata_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
              build() {
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
              buildPartial() {
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata result =
                new com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata(
                    this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.document_ = document_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.uri_ = uri_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.title_ = title_;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.pageIdentifier_ = pageIdentifier_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000010) != 0)) {
              result.structData_ =
                  structDataBuilder_ == null ? structData_ : structDataBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                    .getDefaultInstance()) return this;
            if (!other.getDocument().isEmpty()) {
              document_ = other.document_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.getUri().isEmpty()) {
              uri_ = other.uri_;
              bitField0_ |= 0x00000002;
              onChanged();
            }
            if (!other.getTitle().isEmpty()) {
              title_ = other.title_;
              bitField0_ |= 0x00000004;
              onChanged();
            }
            if (!other.getPageIdentifier().isEmpty()) {
              pageIdentifier_ = other.pageIdentifier_;
              bitField0_ |= 0x00000008;
              onChanged();
            }
            if (other.hasStructData()) {
              mergeStructData(other.getStructData());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      document_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      uri_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 26:
                    {
                      title_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 26
                  case 34:
                    {
                      pageIdentifier_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 34
                  case 42:
                    {
                      input.readMessage(
                          getStructDataFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000010;
                      break;
                    } // case 42
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object document_ = "";

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The document.
           */
          public java.lang.String getDocument() {
            java.lang.Object ref = document_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              document_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return The bytes for document.
           */
          public com.google.protobuf.ByteString getDocumentBytes() {
            java.lang.Object ref = document_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              document_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @param value The document to set.
           * @return This builder for chaining.
           */
          public Builder setDocument(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            document_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearDocument() {
            document_ = getDefaultInstance().getDocument();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
           *
           * @param value The bytes for document to set.
           * @return This builder for chaining.
           */
          public Builder setDocumentBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            document_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private java.lang.Object uri_ = "";

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The uri.
           */
          public java.lang.String getUri() {
            java.lang.Object ref = uri_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              uri_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The bytes for uri.
           */
          public com.google.protobuf.ByteString getUriBytes() {
            java.lang.Object ref = uri_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              uri_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @param value The uri to set.
           * @return This builder for chaining.
           */
          public Builder setUri(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            uri_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearUri() {
            uri_ = getDefaultInstance().getUri();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @param value The bytes for uri to set.
           * @return This builder for chaining.
           */
          public Builder setUriBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            uri_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          private java.lang.Object title_ = "";

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The title.
           */
          public java.lang.String getTitle() {
            java.lang.Object ref = title_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              title_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The bytes for title.
           */
          public com.google.protobuf.ByteString getTitleBytes() {
            java.lang.Object ref = title_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              title_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @param value The title to set.
           * @return This builder for chaining.
           */
          public Builder setTitle(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            title_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearTitle() {
            title_ = getDefaultInstance().getTitle();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @param value The bytes for title to set.
           * @return This builder for chaining.
           */
          public Builder setTitleBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            title_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          private java.lang.Object pageIdentifier_ = "";

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 4;</code>
           *
           * @return The pageIdentifier.
           */
          public java.lang.String getPageIdentifier() {
            java.lang.Object ref = pageIdentifier_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              pageIdentifier_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 4;</code>
           *
           * @return The bytes for pageIdentifier.
           */
          public com.google.protobuf.ByteString getPageIdentifierBytes() {
            java.lang.Object ref = pageIdentifier_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              pageIdentifier_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 4;</code>
           *
           * @param value The pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifier(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            pageIdentifier_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPageIdentifier() {
            pageIdentifier_ = getDefaultInstance().getPageIdentifier();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Page identifier.
           * </pre>
           *
           * <code>string page_identifier = 4;</code>
           *
           * @param value The bytes for pageIdentifier to set.
           * @return This builder for chaining.
           */
          public Builder setPageIdentifierBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            pageIdentifier_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          private com.google.protobuf.Struct structData_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>
              structDataBuilder_;

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           *
           * @return Whether the structData field is set.
           */
          public boolean hasStructData() {
            return ((bitField0_ & 0x00000010) != 0);
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           *
           * @return The structData.
           */
          public com.google.protobuf.Struct getStructData() {
            if (structDataBuilder_ == null) {
              return structData_ == null
                  ? com.google.protobuf.Struct.getDefaultInstance()
                  : structData_;
            } else {
              return structDataBuilder_.getMessage();
            }
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           */
          public Builder setStructData(com.google.protobuf.Struct value) {
            if (structDataBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              structData_ = value;
            } else {
              structDataBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           */
          public Builder setStructData(com.google.protobuf.Struct.Builder builderForValue) {
            if (structDataBuilder_ == null) {
              structData_ = builderForValue.build();
            } else {
              structDataBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           */
          public Builder mergeStructData(com.google.protobuf.Struct value) {
            if (structDataBuilder_ == null) {
              if (((bitField0_ & 0x00000010) != 0)
                  && structData_ != null
                  && structData_ != com.google.protobuf.Struct.getDefaultInstance()) {
                getStructDataBuilder().mergeFrom(value);
              } else {
                structData_ = value;
              }
            } else {
              structDataBuilder_.mergeFrom(value);
            }
            if (structData_ != null) {
              bitField0_ |= 0x00000010;
              onChanged();
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           */
          public Builder clearStructData() {
            bitField0_ = (bitField0_ & ~0x00000010);
            structData_ = null;
            if (structDataBuilder_ != null) {
              structDataBuilder_.dispose();
              structDataBuilder_ = null;
            }
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           */
          public com.google.protobuf.Struct.Builder getStructDataBuilder() {
            bitField0_ |= 0x00000010;
            onChanged();
            return getStructDataFieldBuilder().getBuilder();
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           */
          public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
            if (structDataBuilder_ != null) {
              return structDataBuilder_.getMessageOrBuilder();
            } else {
              return structData_ == null
                  ? com.google.protobuf.Struct.getDefaultInstance()
                  : structData_;
            }
          }

          /**
           *
           *
           * <pre>
           * The structured JSON metadata for the document.
           * It is populated from the struct data from the Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 5;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>
              getStructDataFieldBuilder() {
            if (structDataBuilder_ == null) {
              structDataBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.protobuf.Struct,
                      com.google.protobuf.Struct.Builder,
                      com.google.protobuf.StructOrBuilder>(
                      getStructData(), getParentForChildren(), isClean());
              structData_ = null;
            }
            return structDataBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata)
        private static final com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata();
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadata
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DocumentMetadata> PARSER =
            new com.google.protobuf.AbstractParser<DocumentMetadata>() {
              @java.lang.Override
              public DocumentMetadata parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DocumentMetadata> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DocumentMetadata> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int CHUNK_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object chunk_ = "";

      /**
       *
       *
       * <pre>
       * Chunk resource name.
       * </pre>
       *
       * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The chunk.
       */
      @java.lang.Override
      public java.lang.String getChunk() {
        java.lang.Object ref = chunk_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          chunk_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Chunk resource name.
       * </pre>
       *
       * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for chunk.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getChunkBytes() {
        java.lang.Object ref = chunk_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          chunk_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CONTENT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object content_ = "";

      /**
       *
       *
       * <pre>
       * Chunk textual content.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The content.
       */
      @java.lang.Override
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Chunk textual content.
       * </pre>
       *
       * <code>string content = 2;</code>
       *
       * @return The bytes for content.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int RELEVANCE_SCORE_FIELD_NUMBER = 3;
      private float relevanceScore_ = 0F;

      /**
       *
       *
       * <pre>
       * The relevance of the chunk for a given query. Values range from 0.0
       * (completely irrelevant) to 1.0 (completely relevant).
       * This value is for informational purpose only. It may change for
       * the same query and chunk at any time due to a model retraining or
       * change in implementation.
       * </pre>
       *
       * <code>optional float relevance_score = 3;</code>
       *
       * @return Whether the relevanceScore field is set.
       */
      @java.lang.Override
      public boolean hasRelevanceScore() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The relevance of the chunk for a given query. Values range from 0.0
       * (completely irrelevant) to 1.0 (completely relevant).
       * This value is for informational purpose only. It may change for
       * the same query and chunk at any time due to a model retraining or
       * change in implementation.
       * </pre>
       *
       * <code>optional float relevance_score = 3;</code>
       *
       * @return The relevanceScore.
       */
      @java.lang.Override
      public float getRelevanceScore() {
        return relevanceScore_;
      }

      public static final int DOCUMENT_METADATA_FIELD_NUMBER = 4;
      private com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
          documentMetadata_;

      /**
       *
       *
       * <pre>
       * Document metadata.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
       * </code>
       *
       * @return Whether the documentMetadata field is set.
       */
      @java.lang.Override
      public boolean hasDocumentMetadata() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Document metadata.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
       * </code>
       *
       * @return The documentMetadata.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
          getDocumentMetadata() {
        return documentMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                .getDefaultInstance()
            : documentMetadata_;
      }

      /**
       *
       *
       * <pre>
       * Document metadata.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
              .DocumentMetadataOrBuilder
          getDocumentMetadataOrBuilder() {
        return documentMetadata_ == null
            ? com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                .getDefaultInstance()
            : documentMetadata_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunk_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, chunk_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeFloat(3, relevanceScore_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(4, getDocumentMetadata());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunk_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, chunk_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, relevanceScore_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDocumentMetadata());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo other =
            (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) obj;

        if (!getChunk().equals(other.getChunk())) return false;
        if (!getContent().equals(other.getContent())) return false;
        if (hasRelevanceScore() != other.hasRelevanceScore()) return false;
        if (hasRelevanceScore()) {
          if (java.lang.Float.floatToIntBits(getRelevanceScore())
              != java.lang.Float.floatToIntBits(other.getRelevanceScore())) return false;
        }
        if (hasDocumentMetadata() != other.hasDocumentMetadata()) return false;
        if (hasDocumentMetadata()) {
          if (!getDocumentMetadata().equals(other.getDocumentMetadata())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CHUNK_FIELD_NUMBER;
        hash = (53 * hash) + getChunk().hashCode();
        hash = (37 * hash) + CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getContent().hashCode();
        if (hasRelevanceScore()) {
          hash = (37 * hash) + RELEVANCE_SCORE_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getRelevanceScore());
        }
        if (hasDocumentMetadata()) {
          hash = (37 * hash) + DOCUMENT_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getDocumentMetadata().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo)
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.class,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getDocumentMetadataFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          chunk_ = "";
          content_ = "";
          relevanceScore_ = 0F;
          documentMetadata_ = null;
          if (documentMetadataBuilder_ != null) {
            documentMetadataBuilder_.dispose();
            documentMetadataBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_ChunkInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo build() {
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo buildPartial() {
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo result =
              new com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.chunk_ = chunk_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.content_ = content_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.relevanceScore_ = relevanceScore_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.documentMetadata_ =
                documentMetadataBuilder_ == null
                    ? documentMetadata_
                    : documentMetadataBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                  .getDefaultInstance()) return this;
          if (!other.getChunk().isEmpty()) {
            chunk_ = other.chunk_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getContent().isEmpty()) {
            content_ = other.content_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (other.hasRelevanceScore()) {
            setRelevanceScore(other.getRelevanceScore());
          }
          if (other.hasDocumentMetadata()) {
            mergeDocumentMetadata(other.getDocumentMetadata());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    chunk_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    content_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 29:
                  {
                    relevanceScore_ = input.readFloat();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 29
                case 34:
                  {
                    input.readMessage(
                        getDocumentMetadataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object chunk_ = "";

        /**
         *
         *
         * <pre>
         * Chunk resource name.
         * </pre>
         *
         * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The chunk.
         */
        public java.lang.String getChunk() {
          java.lang.Object ref = chunk_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            chunk_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Chunk resource name.
         * </pre>
         *
         * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for chunk.
         */
        public com.google.protobuf.ByteString getChunkBytes() {
          java.lang.Object ref = chunk_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            chunk_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Chunk resource name.
         * </pre>
         *
         * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The chunk to set.
         * @return This builder for chaining.
         */
        public Builder setChunk(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          chunk_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Chunk resource name.
         * </pre>
         *
         * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearChunk() {
          chunk_ = getDefaultInstance().getChunk();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Chunk resource name.
         * </pre>
         *
         * <code>string chunk = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for chunk to set.
         * @return This builder for chaining.
         */
        public Builder setChunkBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          chunk_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object content_ = "";

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @return The content.
         */
        public java.lang.String getContent() {
          java.lang.Object ref = content_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            content_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @return The bytes for content.
         */
        public com.google.protobuf.ByteString getContentBytes() {
          java.lang.Object ref = content_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            content_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @param value The content to set.
         * @return This builder for chaining.
         */
        public Builder setContent(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContent() {
          content_ = getDefaultInstance().getContent();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Chunk textual content.
         * </pre>
         *
         * <code>string content = 2;</code>
         *
         * @param value The bytes for content to set.
         * @return This builder for chaining.
         */
        public Builder setContentBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          content_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private float relevanceScore_;

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @return Whether the relevanceScore field is set.
         */
        @java.lang.Override
        public boolean hasRelevanceScore() {
          return ((bitField0_ & 0x00000004) != 0);
        }

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @return The relevanceScore.
         */
        @java.lang.Override
        public float getRelevanceScore() {
          return relevanceScore_;
        }

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @param value The relevanceScore to set.
         * @return This builder for chaining.
         */
        public Builder setRelevanceScore(float value) {

          relevanceScore_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The relevance of the chunk for a given query. Values range from 0.0
         * (completely irrelevant) to 1.0 (completely relevant).
         * This value is for informational purpose only. It may change for
         * the same query and chunk at any time due to a model retraining or
         * change in implementation.
         * </pre>
         *
         * <code>optional float relevance_score = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRelevanceScore() {
          bitField0_ = (bitField0_ & ~0x00000004);
          relevanceScore_ = 0F;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
            documentMetadata_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata,
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                    .Builder,
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                    .DocumentMetadataOrBuilder>
            documentMetadataBuilder_;

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         *
         * @return Whether the documentMetadata field is set.
         */
        public boolean hasDocumentMetadata() {
          return ((bitField0_ & 0x00000008) != 0);
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         *
         * @return The documentMetadata.
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
            getDocumentMetadata() {
          if (documentMetadataBuilder_ == null) {
            return documentMetadata_ == null
                ? com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                    .getDefaultInstance()
                : documentMetadata_;
          } else {
            return documentMetadataBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         */
        public Builder setDocumentMetadata(
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata value) {
          if (documentMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            documentMetadata_ = value;
          } else {
            documentMetadataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         */
        public Builder setDocumentMetadata(
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata.Builder
                builderForValue) {
          if (documentMetadataBuilder_ == null) {
            documentMetadata_ = builderForValue.build();
          } else {
            documentMetadataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         */
        public Builder mergeDocumentMetadata(
            com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata value) {
          if (documentMetadataBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)
                && documentMetadata_ != null
                && documentMetadata_
                    != com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                        .DocumentMetadata.getDefaultInstance()) {
              getDocumentMetadataBuilder().mergeFrom(value);
            } else {
              documentMetadata_ = value;
            }
          } else {
            documentMetadataBuilder_.mergeFrom(value);
          }
          if (documentMetadata_ != null) {
            bitField0_ |= 0x00000008;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         */
        public Builder clearDocumentMetadata() {
          bitField0_ = (bitField0_ & ~0x00000008);
          documentMetadata_ = null;
          if (documentMetadataBuilder_ != null) {
            documentMetadataBuilder_.dispose();
            documentMetadataBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                .Builder
            getDocumentMetadataBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getDocumentMetadataFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                .DocumentMetadataOrBuilder
            getDocumentMetadataOrBuilder() {
          if (documentMetadataBuilder_ != null) {
            return documentMetadataBuilder_.getMessageOrBuilder();
          } else {
            return documentMetadata_ == null
                ? com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                    .getDefaultInstance()
                : documentMetadata_;
          }
        }

        /**
         *
         *
         * <pre>
         * Document metadata.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata document_metadata = 4;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata,
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                    .Builder,
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                    .DocumentMetadataOrBuilder>
            getDocumentMetadataFieldBuilder() {
          if (documentMetadataBuilder_ == null) {
            documentMetadataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata,
                    com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.DocumentMetadata
                        .Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                        .DocumentMetadataOrBuilder>(
                    getDocumentMetadata(), getParentForChildren(), isClean());
            documentMetadata_ = null;
          }
          return documentMetadataBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo)
      private static final com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo();
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ChunkInfo> PARSER =
          new com.google.protobuf.AbstractParser<ChunkInfo>() {
            @java.lang.Override
            public ChunkInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ChunkInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ChunkInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface StructuredDocumentInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The document.
       */
      java.lang.String getDocument();

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for document.
       */
      com.google.protobuf.ByteString getDocumentBytes();

      /**
       *
       *
       * <pre>
       * Structured search data.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 2;</code>
       *
       * @return Whether the structData field is set.
       */
      boolean hasStructData();

      /**
       *
       *
       * <pre>
       * Structured search data.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 2;</code>
       *
       * @return The structData.
       */
      com.google.protobuf.Struct getStructData();

      /**
       *
       *
       * <pre>
       * Structured search data.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 2;</code>
       */
      com.google.protobuf.StructOrBuilder getStructDataOrBuilder();

      /**
       *
       *
       * <pre>
       * Output only. The title of the document.
       * </pre>
       *
       * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The title.
       */
      java.lang.String getTitle();

      /**
       *
       *
       * <pre>
       * Output only. The title of the document.
       * </pre>
       *
       * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for title.
       */
      com.google.protobuf.ByteString getTitleBytes();

      /**
       *
       *
       * <pre>
       * Output only. The URI of the document.
       * </pre>
       *
       * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The uri.
       */
      java.lang.String getUri();

      /**
       *
       *
       * <pre>
       * Output only. The URI of the document.
       * </pre>
       *
       * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for uri.
       */
      com.google.protobuf.ByteString getUriBytes();
    }

    /**
     *
     *
     * <pre>
     * Structured search information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo}
     */
    public static final class StructuredDocumentInfo extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
        StructuredDocumentInfoOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use StructuredDocumentInfo.newBuilder() to construct.
      private StructuredDocumentInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private StructuredDocumentInfo() {
        document_ = "";
        title_ = "";
        uri_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new StructuredDocumentInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_StructuredDocumentInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_StructuredDocumentInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.class,
                com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.Builder
                    .class);
      }

      private int bitField0_;
      public static final int DOCUMENT_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object document_ = "";

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The document.
       */
      @java.lang.Override
      public java.lang.String getDocument() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          document_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Document resource name.
       * </pre>
       *
       * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for document.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDocumentBytes() {
        java.lang.Object ref = document_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          document_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int STRUCT_DATA_FIELD_NUMBER = 2;
      private com.google.protobuf.Struct structData_;

      /**
       *
       *
       * <pre>
       * Structured search data.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 2;</code>
       *
       * @return Whether the structData field is set.
       */
      @java.lang.Override
      public boolean hasStructData() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Structured search data.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 2;</code>
       *
       * @return The structData.
       */
      @java.lang.Override
      public com.google.protobuf.Struct getStructData() {
        return structData_ == null ? com.google.protobuf.Struct.getDefaultInstance() : structData_;
      }

      /**
       *
       *
       * <pre>
       * Structured search data.
       * </pre>
       *
       * <code>.google.protobuf.Struct struct_data = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
        return structData_ == null ? com.google.protobuf.Struct.getDefaultInstance() : structData_;
      }

      public static final int TITLE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object title_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The title of the document.
       * </pre>
       *
       * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The title.
       */
      @java.lang.Override
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The title of the document.
       * </pre>
       *
       * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for title.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int URI_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object uri_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The URI of the document.
       * </pre>
       *
       * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The uri.
       */
      @java.lang.Override
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The URI of the document.
       * </pre>
       *
       * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for uri.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, document_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getStructData());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, uri_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, document_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStructData());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, title_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, uri_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo other =
            (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo) obj;

        if (!getDocument().equals(other.getDocument())) return false;
        if (hasStructData() != other.hasStructData()) return false;
        if (hasStructData()) {
          if (!getStructData().equals(other.getStructData())) return false;
        }
        if (!getTitle().equals(other.getTitle())) return false;
        if (!getUri().equals(other.getUri())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
        if (hasStructData()) {
          hash = (37 * hash) + STRUCT_DATA_FIELD_NUMBER;
          hash = (53 * hash) + getStructData().hashCode();
        }
        hash = (37 * hash) + TITLE_FIELD_NUMBER;
        hash = (53 * hash) + getTitle().hashCode();
        hash = (37 * hash) + URI_FIELD_NUMBER;
        hash = (53 * hash) + getUri().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Structured search information.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
          com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_StructuredDocumentInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_StructuredDocumentInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.class,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getStructDataFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          document_ = "";
          structData_ = null;
          if (structDataBuilder_ != null) {
            structDataBuilder_.dispose();
            structDataBuilder_ = null;
          }
          title_ = "";
          uri_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_StructuredDocumentInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo build() {
          com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo result =
              new com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.document_ = document_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.structData_ =
                structDataBuilder_ == null ? structData_ : structDataBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.title_ = title_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.uri_ = uri_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
                  .getDefaultInstance()) return this;
          if (!other.getDocument().isEmpty()) {
            document_ = other.document_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasStructData()) {
            mergeStructData(other.getStructData());
          }
          if (!other.getTitle().isEmpty()) {
            title_ = other.title_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getUri().isEmpty()) {
            uri_ = other.uri_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    document_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getStructDataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    title_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    uri_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object document_ = "";

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The document.
         */
        public java.lang.String getDocument() {
          java.lang.Object ref = document_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            document_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for document.
         */
        public com.google.protobuf.ByteString getDocumentBytes() {
          java.lang.Object ref = document_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            document_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The document to set.
         * @return This builder for chaining.
         */
        public Builder setDocument(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          document_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDocument() {
          document_ = getDefaultInstance().getDocument();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Document resource name.
         * </pre>
         *
         * <code>string document = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for document to set.
         * @return This builder for chaining.
         */
        public Builder setDocumentBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          document_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.protobuf.Struct structData_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>
            structDataBuilder_;

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         *
         * @return Whether the structData field is set.
         */
        public boolean hasStructData() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         *
         * @return The structData.
         */
        public com.google.protobuf.Struct getStructData() {
          if (structDataBuilder_ == null) {
            return structData_ == null
                ? com.google.protobuf.Struct.getDefaultInstance()
                : structData_;
          } else {
            return structDataBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         */
        public Builder setStructData(com.google.protobuf.Struct value) {
          if (structDataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            structData_ = value;
          } else {
            structDataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         */
        public Builder setStructData(com.google.protobuf.Struct.Builder builderForValue) {
          if (structDataBuilder_ == null) {
            structData_ = builderForValue.build();
          } else {
            structDataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         */
        public Builder mergeStructData(com.google.protobuf.Struct value) {
          if (structDataBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && structData_ != null
                && structData_ != com.google.protobuf.Struct.getDefaultInstance()) {
              getStructDataBuilder().mergeFrom(value);
            } else {
              structData_ = value;
            }
          } else {
            structDataBuilder_.mergeFrom(value);
          }
          if (structData_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         */
        public Builder clearStructData() {
          bitField0_ = (bitField0_ & ~0x00000002);
          structData_ = null;
          if (structDataBuilder_ != null) {
            structDataBuilder_.dispose();
            structDataBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         */
        public com.google.protobuf.Struct.Builder getStructDataBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getStructDataFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         */
        public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
          if (structDataBuilder_ != null) {
            return structDataBuilder_.getMessageOrBuilder();
          } else {
            return structData_ == null
                ? com.google.protobuf.Struct.getDefaultInstance()
                : structData_;
          }
        }

        /**
         *
         *
         * <pre>
         * Structured search data.
         * </pre>
         *
         * <code>.google.protobuf.Struct struct_data = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>
            getStructDataFieldBuilder() {
          if (structDataBuilder_ == null) {
            structDataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Struct,
                    com.google.protobuf.Struct.Builder,
                    com.google.protobuf.StructOrBuilder>(
                    getStructData(), getParentForChildren(), isClean());
            structData_ = null;
          }
          return structDataBuilder_;
        }

        private java.lang.Object title_ = "";

        /**
         *
         *
         * <pre>
         * Output only. The title of the document.
         * </pre>
         *
         * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The title.
         */
        public java.lang.String getTitle() {
          java.lang.Object ref = title_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            title_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Output only. The title of the document.
         * </pre>
         *
         * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The bytes for title.
         */
        public com.google.protobuf.ByteString getTitleBytes() {
          java.lang.Object ref = title_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            title_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Output only. The title of the document.
         * </pre>
         *
         * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The title to set.
         * @return This builder for chaining.
         */
        public Builder setTitle(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          title_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. The title of the document.
         * </pre>
         *
         * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTitle() {
          title_ = getDefaultInstance().getTitle();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. The title of the document.
         * </pre>
         *
         * <code>string title = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The bytes for title to set.
         * @return This builder for chaining.
         */
        public Builder setTitleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          title_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object uri_ = "";

        /**
         *
         *
         * <pre>
         * Output only. The URI of the document.
         * </pre>
         *
         * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The uri.
         */
        public java.lang.String getUri() {
          java.lang.Object ref = uri_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            uri_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Output only. The URI of the document.
         * </pre>
         *
         * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return The bytes for uri.
         */
        public com.google.protobuf.ByteString getUriBytes() {
          java.lang.Object ref = uri_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            uri_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Output only. The URI of the document.
         * </pre>
         *
         * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The uri to set.
         * @return This builder for chaining.
         */
        public Builder setUri(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          uri_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. The URI of the document.
         * </pre>
         *
         * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUri() {
          uri_ = getDefaultInstance().getUri();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Output only. The URI of the document.
         * </pre>
         *
         * <code>string uri = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
         *
         * @param value The bytes for uri to set.
         * @return This builder for chaining.
         */
        public Builder setUriBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          uri_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
      private static final com.google.cloud.discoveryengine.v1.Answer.Reference
              .StructuredDocumentInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo();
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<StructuredDocumentInfo> PARSER =
          new com.google.protobuf.AbstractParser<StructuredDocumentInfo>() {
            @java.lang.Override
            public StructuredDocumentInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<StructuredDocumentInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<StructuredDocumentInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int contentCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object content_;

    public enum ContentCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      UNSTRUCTURED_DOCUMENT_INFO(1),
      CHUNK_INFO(2),
      STRUCTURED_DOCUMENT_INFO(3),
      CONTENT_NOT_SET(0);
      private final int value;

      private ContentCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentCase valueOf(int value) {
        return forNumber(value);
      }

      public static ContentCase forNumber(int value) {
        switch (value) {
          case 1:
            return UNSTRUCTURED_DOCUMENT_INFO;
          case 2:
            return CHUNK_INFO;
          case 3:
            return STRUCTURED_DOCUMENT_INFO;
          case 0:
            return CONTENT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ContentCase getContentCase() {
      return ContentCase.forNumber(contentCase_);
    }

    public static final int UNSTRUCTURED_DOCUMENT_INFO_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Unstructured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
     * </code>
     *
     * @return Whether the unstructuredDocumentInfo field is set.
     */
    @java.lang.Override
    public boolean hasUnstructuredDocumentInfo() {
      return contentCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Unstructured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
     * </code>
     *
     * @return The unstructuredDocumentInfo.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
        getUnstructuredDocumentInfo() {
      if (contentCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
            content_;
      }
      return com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Unstructured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfoOrBuilder
        getUnstructuredDocumentInfoOrBuilder() {
      if (contentCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
            content_;
      }
      return com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          .getDefaultInstance();
    }

    public static final int CHUNK_INFO_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Chunk information.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
     *
     * @return Whether the chunkInfo field is set.
     */
    @java.lang.Override
    public boolean hasChunkInfo() {
      return contentCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Chunk information.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
     *
     * @return The chunkInfo.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo getChunkInfo() {
      if (contentCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_;
      }
      return com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Chunk information.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfoOrBuilder
        getChunkInfoOrBuilder() {
      if (contentCase_ == 2) {
        return (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_;
      }
      return com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.getDefaultInstance();
    }

    public static final int STRUCTURED_DOCUMENT_INFO_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Structured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
     * </code>
     *
     * @return Whether the structuredDocumentInfo field is set.
     */
    @java.lang.Override
    public boolean hasStructuredDocumentInfo() {
      return contentCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Structured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
     * </code>
     *
     * @return The structuredDocumentInfo.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
        getStructuredDocumentInfo() {
      if (contentCase_ == 3) {
        return (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
            content_;
      }
      return com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Structured document information.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfoOrBuilder
        getStructuredDocumentInfoOrBuilder() {
      if (contentCase_ == 3) {
        return (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
            content_;
      }
      return com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (contentCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
                content_);
      }
      if (contentCase_ == 2) {
        output.writeMessage(
            2, (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_);
      }
      if (contentCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo) content_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (contentCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
                    content_);
      }
      if (contentCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_);
      }
      if (contentCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
                    content_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.Reference)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Answer.Reference other =
          (com.google.cloud.discoveryengine.v1.Answer.Reference) obj;

      if (!getContentCase().equals(other.getContentCase())) return false;
      switch (contentCase_) {
        case 1:
          if (!getUnstructuredDocumentInfo().equals(other.getUnstructuredDocumentInfo()))
            return false;
          break;
        case 2:
          if (!getChunkInfo().equals(other.getChunkInfo())) return false;
          break;
        case 3:
          if (!getStructuredDocumentInfo().equals(other.getStructuredDocumentInfo())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (contentCase_) {
        case 1:
          hash = (37 * hash) + UNSTRUCTURED_DOCUMENT_INFO_FIELD_NUMBER;
          hash = (53 * hash) + getUnstructuredDocumentInfo().hashCode();
          break;
        case 2:
          hash = (37 * hash) + CHUNK_INFO_FIELD_NUMBER;
          hash = (53 * hash) + getChunkInfo().hashCode();
          break;
        case 3:
          hash = (37 * hash) + STRUCTURED_DOCUMENT_INFO_FIELD_NUMBER;
          hash = (53 * hash) + getStructuredDocumentInfo().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Answer.Reference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Reference.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Reference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Reference)
        com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.Reference.class,
                com.google.cloud.discoveryengine.v1.Answer.Reference.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Answer.Reference.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (unstructuredDocumentInfoBuilder_ != null) {
          unstructuredDocumentInfoBuilder_.clear();
        }
        if (chunkInfoBuilder_ != null) {
          chunkInfoBuilder_.clear();
        }
        if (structuredDocumentInfoBuilder_ != null) {
          structuredDocumentInfoBuilder_.clear();
        }
        contentCase_ = 0;
        content_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Reference_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Answer.Reference.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference build() {
        com.google.cloud.discoveryengine.v1.Answer.Reference result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference buildPartial() {
        com.google.cloud.discoveryengine.v1.Answer.Reference result =
            new com.google.cloud.discoveryengine.v1.Answer.Reference(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Answer.Reference result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.cloud.discoveryengine.v1.Answer.Reference result) {
        result.contentCase_ = contentCase_;
        result.content_ = this.content_;
        if (contentCase_ == 1 && unstructuredDocumentInfoBuilder_ != null) {
          result.content_ = unstructuredDocumentInfoBuilder_.build();
        }
        if (contentCase_ == 2 && chunkInfoBuilder_ != null) {
          result.content_ = chunkInfoBuilder_.build();
        }
        if (contentCase_ == 3 && structuredDocumentInfoBuilder_ != null) {
          result.content_ = structuredDocumentInfoBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Answer.Reference) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Answer.Reference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Answer.Reference other) {
        if (other == com.google.cloud.discoveryengine.v1.Answer.Reference.getDefaultInstance())
          return this;
        switch (other.getContentCase()) {
          case UNSTRUCTURED_DOCUMENT_INFO:
            {
              mergeUnstructuredDocumentInfo(other.getUnstructuredDocumentInfo());
              break;
            }
          case CHUNK_INFO:
            {
              mergeChunkInfo(other.getChunkInfo());
              break;
            }
          case STRUCTURED_DOCUMENT_INFO:
            {
              mergeStructuredDocumentInfo(other.getStructuredDocumentInfo());
              break;
            }
          case CONTENT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getUnstructuredDocumentInfoFieldBuilder().getBuilder(), extensionRegistry);
                  contentCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getChunkInfoFieldBuilder().getBuilder(), extensionRegistry);
                  contentCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getStructuredDocumentInfoFieldBuilder().getBuilder(), extensionRegistry);
                  contentCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int contentCase_ = 0;
      private java.lang.Object content_;

      public ContentCase getContentCase() {
        return ContentCase.forNumber(contentCase_);
      }

      public Builder clearContent() {
        contentCase_ = 0;
        content_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo,
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Reference
                  .UnstructuredDocumentInfoOrBuilder>
          unstructuredDocumentInfoBuilder_;

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       *
       * @return Whether the unstructuredDocumentInfo field is set.
       */
      @java.lang.Override
      public boolean hasUnstructuredDocumentInfo() {
        return contentCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       *
       * @return The unstructuredDocumentInfo.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
          getUnstructuredDocumentInfo() {
        if (unstructuredDocumentInfoBuilder_ == null) {
          if (contentCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
              .getDefaultInstance();
        } else {
          if (contentCase_ == 1) {
            return unstructuredDocumentInfoBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       */
      public Builder setUnstructuredDocumentInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo value) {
        if (unstructuredDocumentInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          onChanged();
        } else {
          unstructuredDocumentInfoBuilder_.setMessage(value);
        }
        contentCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       */
      public Builder setUnstructuredDocumentInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.Builder
              builderForValue) {
        if (unstructuredDocumentInfoBuilder_ == null) {
          content_ = builderForValue.build();
          onChanged();
        } else {
          unstructuredDocumentInfoBuilder_.setMessage(builderForValue.build());
        }
        contentCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       */
      public Builder mergeUnstructuredDocumentInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo value) {
        if (unstructuredDocumentInfoBuilder_ == null) {
          if (contentCase_ == 1
              && content_
                  != com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .getDefaultInstance()) {
            content_ =
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .newBuilder(
                        (com.google.cloud.discoveryengine.v1.Answer.Reference
                                .UnstructuredDocumentInfo)
                            content_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            content_ = value;
          }
          onChanged();
        } else {
          if (contentCase_ == 1) {
            unstructuredDocumentInfoBuilder_.mergeFrom(value);
          } else {
            unstructuredDocumentInfoBuilder_.setMessage(value);
          }
        }
        contentCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       */
      public Builder clearUnstructuredDocumentInfo() {
        if (unstructuredDocumentInfoBuilder_ == null) {
          if (contentCase_ == 1) {
            contentCase_ = 0;
            content_ = null;
            onChanged();
          }
        } else {
          if (contentCase_ == 1) {
            contentCase_ = 0;
            content_ = null;
          }
          unstructuredDocumentInfoBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.Builder
          getUnstructuredDocumentInfoBuilder() {
        return getUnstructuredDocumentInfoFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfoOrBuilder
          getUnstructuredDocumentInfoOrBuilder() {
        if ((contentCase_ == 1) && (unstructuredDocumentInfoBuilder_ != null)) {
          return unstructuredDocumentInfoBuilder_.getMessageOrBuilder();
        } else {
          if (contentCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Unstructured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo unstructured_document_info = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo,
              com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Reference
                  .UnstructuredDocumentInfoOrBuilder>
          getUnstructuredDocumentInfoFieldBuilder() {
        if (unstructuredDocumentInfoBuilder_ == null) {
          if (!(contentCase_ == 1)) {
            content_ =
                com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                    .getDefaultInstance();
          }
          unstructuredDocumentInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo
                      .Builder,
                  com.google.cloud.discoveryengine.v1.Answer.Reference
                      .UnstructuredDocumentInfoOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.Answer.Reference.UnstructuredDocumentInfo)
                      content_,
                  getParentForChildren(),
                  isClean());
          content_ = null;
        }
        contentCase_ = 1;
        onChanged();
        return unstructuredDocumentInfoBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo,
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfoOrBuilder>
          chunkInfoBuilder_;

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       *
       * @return Whether the chunkInfo field is set.
       */
      @java.lang.Override
      public boolean hasChunkInfo() {
        return contentCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       *
       * @return The chunkInfo.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo getChunkInfo() {
        if (chunkInfoBuilder_ == null) {
          if (contentCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_;
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
              .getDefaultInstance();
        } else {
          if (contentCase_ == 2) {
            return chunkInfoBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       */
      public Builder setChunkInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo value) {
        if (chunkInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          onChanged();
        } else {
          chunkInfoBuilder_.setMessage(value);
        }
        contentCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       */
      public Builder setChunkInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.Builder builderForValue) {
        if (chunkInfoBuilder_ == null) {
          content_ = builderForValue.build();
          onChanged();
        } else {
          chunkInfoBuilder_.setMessage(builderForValue.build());
        }
        contentCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       */
      public Builder mergeChunkInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo value) {
        if (chunkInfoBuilder_ == null) {
          if (contentCase_ == 2
              && content_
                  != com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
                      .getDefaultInstance()) {
            content_ =
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.newBuilder(
                        (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            content_ = value;
          }
          onChanged();
        } else {
          if (contentCase_ == 2) {
            chunkInfoBuilder_.mergeFrom(value);
          } else {
            chunkInfoBuilder_.setMessage(value);
          }
        }
        contentCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       */
      public Builder clearChunkInfo() {
        if (chunkInfoBuilder_ == null) {
          if (contentCase_ == 2) {
            contentCase_ = 0;
            content_ = null;
            onChanged();
          }
        } else {
          if (contentCase_ == 2) {
            contentCase_ = 0;
            content_ = null;
          }
          chunkInfoBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.Builder
          getChunkInfoBuilder() {
        return getChunkInfoFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfoOrBuilder
          getChunkInfoOrBuilder() {
        if ((contentCase_ == 2) && (chunkInfoBuilder_ != null)) {
          return chunkInfoBuilder_.getMessageOrBuilder();
        } else {
          if (contentCase_ == 2) {
            return (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_;
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Chunk information.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo chunk_info = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo,
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfoOrBuilder>
          getChunkInfoFieldBuilder() {
        if (chunkInfoBuilder_ == null) {
          if (!(contentCase_ == 2)) {
            content_ =
                com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.getDefaultInstance();
          }
          chunkInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo.Builder,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfoOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.Answer.Reference.ChunkInfo) content_,
                  getParentForChildren(),
                  isClean());
          content_ = null;
        }
        contentCase_ = 2;
        onChanged();
        return chunkInfoBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo,
              com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfoOrBuilder>
          structuredDocumentInfoBuilder_;

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       *
       * @return Whether the structuredDocumentInfo field is set.
       */
      @java.lang.Override
      public boolean hasStructuredDocumentInfo() {
        return contentCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       *
       * @return The structuredDocumentInfo.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
          getStructuredDocumentInfo() {
        if (structuredDocumentInfoBuilder_ == null) {
          if (contentCase_ == 3) {
            return (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
              .getDefaultInstance();
        } else {
          if (contentCase_ == 3) {
            return structuredDocumentInfoBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       */
      public Builder setStructuredDocumentInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo value) {
        if (structuredDocumentInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          onChanged();
        } else {
          structuredDocumentInfoBuilder_.setMessage(value);
        }
        contentCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       */
      public Builder setStructuredDocumentInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.Builder
              builderForValue) {
        if (structuredDocumentInfoBuilder_ == null) {
          content_ = builderForValue.build();
          onChanged();
        } else {
          structuredDocumentInfoBuilder_.setMessage(builderForValue.build());
        }
        contentCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       */
      public Builder mergeStructuredDocumentInfo(
          com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo value) {
        if (structuredDocumentInfoBuilder_ == null) {
          if (contentCase_ == 3
              && content_
                  != com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
                      .getDefaultInstance()) {
            content_ =
                com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
                    .newBuilder(
                        (com.google.cloud.discoveryengine.v1.Answer.Reference
                                .StructuredDocumentInfo)
                            content_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            content_ = value;
          }
          onChanged();
        } else {
          if (contentCase_ == 3) {
            structuredDocumentInfoBuilder_.mergeFrom(value);
          } else {
            structuredDocumentInfoBuilder_.setMessage(value);
          }
        }
        contentCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       */
      public Builder clearStructuredDocumentInfo() {
        if (structuredDocumentInfoBuilder_ == null) {
          if (contentCase_ == 3) {
            contentCase_ = 0;
            content_ = null;
            onChanged();
          }
        } else {
          if (contentCase_ == 3) {
            contentCase_ = 0;
            content_ = null;
          }
          structuredDocumentInfoBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.Builder
          getStructuredDocumentInfoBuilder() {
        return getStructuredDocumentInfoFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfoOrBuilder
          getStructuredDocumentInfoOrBuilder() {
        if ((contentCase_ == 3) && (structuredDocumentInfoBuilder_ != null)) {
          return structuredDocumentInfoBuilder_.getMessageOrBuilder();
        } else {
          if (contentCase_ == 3) {
            return (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
                content_;
          }
          return com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Structured document information.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo structured_document_info = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo,
              com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfoOrBuilder>
          getStructuredDocumentInfoFieldBuilder() {
        if (structuredDocumentInfoBuilder_ == null) {
          if (!(contentCase_ == 3)) {
            content_ =
                com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
                    .getDefaultInstance();
          }
          structuredDocumentInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo,
                  com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo
                      .Builder,
                  com.google.cloud.discoveryengine.v1.Answer.Reference
                      .StructuredDocumentInfoOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.Answer.Reference.StructuredDocumentInfo)
                      content_,
                  getParentForChildren(),
                  isClean());
          content_ = null;
        }
        contentCase_ = 3;
        onChanged();
        return structuredDocumentInfoBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Reference)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Reference)
    private static final com.google.cloud.discoveryengine.v1.Answer.Reference DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.Reference();
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Reference getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Reference> PARSER =
        new com.google.protobuf.AbstractParser<Reference>() {
          @java.lang.Override
          public Reference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Reference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Reference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Reference getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StepOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Step)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The state of the step.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();

    /**
     *
     *
     * <pre>
     * The state of the step.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
     *
     * @return The state.
     */
    com.google.cloud.discoveryengine.v1.Answer.Step.State getState();

    /**
     *
     *
     * <pre>
     * The description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    java.lang.String getDescription();

    /**
     *
     *
     * <pre>
     * The description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    com.google.protobuf.ByteString getDescriptionBytes();

    /**
     *
     *
     * <pre>
     * The thought of the step.
     * </pre>
     *
     * <code>string thought = 3;</code>
     *
     * @return The thought.
     */
    java.lang.String getThought();

    /**
     *
     *
     * <pre>
     * The thought of the step.
     * </pre>
     *
     * <code>string thought = 3;</code>
     *
     * @return The bytes for thought.
     */
    com.google.protobuf.ByteString getThoughtBytes();

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step.Action> getActionsList();

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    com.google.cloud.discoveryengine.v1.Answer.Step.Action getActions(int index);

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    int getActionsCount();

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder>
        getActionsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder getActionsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * Step information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step}
   */
  public static final class Step extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Step)
      StepOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Step.newBuilder() to construct.
    private Step(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Step() {
      state_ = 0;
      description_ = "";
      thought_ = "";
      actions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Step();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_Step_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_Step_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Answer.Step.class,
              com.google.cloud.discoveryengine.v1.Answer.Step.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Enumeration of the state of the step.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.discoveryengine.v1.Answer.Step.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unknown.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Step is currently in progress.
       * </pre>
       *
       * <code>IN_PROGRESS = 1;</code>
       */
      IN_PROGRESS(1),
      /**
       *
       *
       * <pre>
       * Step currently failed.
       * </pre>
       *
       * <code>FAILED = 2;</code>
       */
      FAILED(2),
      /**
       *
       *
       * <pre>
       * Step has succeeded.
       * </pre>
       *
       * <code>SUCCEEDED = 3;</code>
       */
      SUCCEEDED(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unknown.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Step is currently in progress.
       * </pre>
       *
       * <code>IN_PROGRESS = 1;</code>
       */
      public static final int IN_PROGRESS_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Step currently failed.
       * </pre>
       *
       * <code>FAILED = 2;</code>
       */
      public static final int FAILED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Step has succeeded.
       * </pre>
       *
       * <code>SUCCEEDED = 3;</code>
       */
      public static final int SUCCEEDED_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return IN_PROGRESS;
          case 2:
            return FAILED;
          case 3:
            return SUCCEEDED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.Answer.Step.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.Answer.Step.State)
    }

    public interface ActionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Step.Action)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Search action.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
       * </code>
       *
       * @return Whether the searchAction field is set.
       */
      boolean hasSearchAction();

      /**
       *
       *
       * <pre>
       * Search action.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
       * </code>
       *
       * @return The searchAction.
       */
      com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction getSearchAction();

      /**
       *
       *
       * <pre>
       * Search action.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchActionOrBuilder
          getSearchActionOrBuilder();

      /**
       *
       *
       * <pre>
       * Observation.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
       * </code>
       *
       * @return Whether the observation field is set.
       */
      boolean hasObservation();

      /**
       *
       *
       * <pre>
       * Observation.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
       * </code>
       *
       * @return The observation.
       */
      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation getObservation();

      /**
       *
       *
       * <pre>
       * Observation.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Answer.Step.Action.ObservationOrBuilder
          getObservationOrBuilder();

      com.google.cloud.discoveryengine.v1.Answer.Step.Action.ActionCase getActionCase();
    }

    /**
     *
     *
     * <pre>
     * Action.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step.Action}
     */
    public static final class Action extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Step.Action)
        ActionOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use Action.newBuilder() to construct.
      private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Action() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Action();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.class,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder.class);
      }

      public interface SearchActionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The query to search.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The query.
         */
        java.lang.String getQuery();

        /**
         *
         *
         * <pre>
         * The query to search.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The bytes for query.
         */
        com.google.protobuf.ByteString getQueryBytes();
      }

      /**
       *
       *
       * <pre>
       * Search action.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction}
       */
      public static final class SearchAction extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction)
          SearchActionOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use SearchAction.newBuilder() to construct.
        private SearchAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private SearchAction() {
          query_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new SearchAction();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_SearchAction_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_SearchAction_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.class,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.Builder
                      .class);
        }

        public static final int QUERY_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object query_ = "";

        /**
         *
         *
         * <pre>
         * The query to search.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The query.
         */
        @java.lang.Override
        public java.lang.String getQuery() {
          java.lang.Object ref = query_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            query_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * The query to search.
         * </pre>
         *
         * <code>string query = 1;</code>
         *
         * @return The bytes for query.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getQueryBytes() {
          java.lang.Object ref = query_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            query_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction other =
              (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) obj;

          if (!getQuery().equals(other.getQuery())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + QUERY_FIELD_NUMBER;
          hash = (53 * hash) + getQuery().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction)
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchActionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_SearchAction_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_SearchAction_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.class,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            query_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_SearchAction_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction build() {
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
              buildPartial() {
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction result =
                new com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.query_ = query_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction other) {
            if (other
                == com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
                    .getDefaultInstance()) return this;
            if (!other.getQuery().isEmpty()) {
              query_ = other.query_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      query_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object query_ = "";

          /**
           *
           *
           * <pre>
           * The query to search.
           * </pre>
           *
           * <code>string query = 1;</code>
           *
           * @return The query.
           */
          public java.lang.String getQuery() {
            java.lang.Object ref = query_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              query_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * The query to search.
           * </pre>
           *
           * <code>string query = 1;</code>
           *
           * @return The bytes for query.
           */
          public com.google.protobuf.ByteString getQueryBytes() {
            java.lang.Object ref = query_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              query_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * The query to search.
           * </pre>
           *
           * <code>string query = 1;</code>
           *
           * @param value The query to set.
           * @return This builder for chaining.
           */
          public Builder setQuery(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            query_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * The query to search.
           * </pre>
           *
           * <code>string query = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearQuery() {
            query_ = getDefaultInstance().getQuery();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * The query to search.
           * </pre>
           *
           * <code>string query = 1;</code>
           *
           * @param value The bytes for query to set.
           * @return This builder for chaining.
           */
          public Builder setQueryBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            query_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction)
        private static final com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction();
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<SearchAction> PARSER =
            new com.google.protobuf.AbstractParser<SearchAction>() {
              @java.lang.Override
              public SearchAction parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<SearchAction> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<SearchAction> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface ObservationOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        java.util.List<
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult>
            getSearchResultsList();

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
            getSearchResults(int index);

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        int getSearchResultsCount();

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                        .SearchResultOrBuilder>
            getSearchResultsOrBuilderList();

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResultOrBuilder
            getSearchResultsOrBuilder(int index);
      }

      /**
       *
       *
       * <pre>
       * Observation.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step.Action.Observation}
       */
      public static final class Observation extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation)
          ObservationOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use Observation.newBuilder() to construct.
        private Observation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private Observation() {
          searchResults_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new Observation();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.class,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.Builder.class);
        }

        public interface SearchResultOrBuilder
            extends
            // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult)
            com.google.protobuf.MessageOrBuilder {

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1;</code>
           *
           * @return The document.
           */
          java.lang.String getDocument();

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1;</code>
           *
           * @return The bytes for document.
           */
          com.google.protobuf.ByteString getDocumentBytes();

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The uri.
           */
          java.lang.String getUri();

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The bytes for uri.
           */
          com.google.protobuf.ByteString getUriBytes();

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The title.
           */
          java.lang.String getTitle();

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The bytes for title.
           */
          com.google.protobuf.ByteString getTitleBytes();

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo>
              getSnippetInfoList();

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .SnippetInfo
              getSnippetInfo(int index);

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          int getSnippetInfoCount();

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.SnippetInfoOrBuilder>
              getSnippetInfoOrBuilderList();

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .SnippetInfoOrBuilder
              getSnippetInfoOrBuilder(int index);

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo>
              getChunkInfoList();

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo
              getChunkInfo(int index);

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          int getChunkInfoCount();

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.ChunkInfoOrBuilder>
              getChunkInfoOrBuilderList();

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .ChunkInfoOrBuilder
              getChunkInfoOrBuilder(int index);

          /**
           *
           *
           * <pre>
           * Data representation.
           * The structured JSON data for the document.
           * It's populated from the struct data from the Document, or the
           * Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 6;</code>
           *
           * @return Whether the structData field is set.
           */
          boolean hasStructData();

          /**
           *
           *
           * <pre>
           * Data representation.
           * The structured JSON data for the document.
           * It's populated from the struct data from the Document, or the
           * Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 6;</code>
           *
           * @return The structData.
           */
          com.google.protobuf.Struct getStructData();

          /**
           *
           *
           * <pre>
           * Data representation.
           * The structured JSON data for the document.
           * It's populated from the struct data from the Document, or the
           * Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 6;</code>
           */
          com.google.protobuf.StructOrBuilder getStructDataOrBuilder();
        }

        /**
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult}
         */
        public static final class SearchResult extends com.google.protobuf.GeneratedMessageV3
            implements
            // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult)
            SearchResultOrBuilder {
          private static final long serialVersionUID = 0L;

          // Use SearchResult.newBuilder() to construct.
          private SearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }

          private SearchResult() {
            document_ = "";
            uri_ = "";
            title_ = "";
            snippetInfo_ = java.util.Collections.emptyList();
            chunkInfo_ = java.util.Collections.emptyList();
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
            return new SearchResult();
          }

          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .class,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .Builder.class);
          }

          public interface SnippetInfoOrBuilder
              extends
              // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo)
              com.google.protobuf.MessageOrBuilder {

            /**
             *
             *
             * <pre>
             * Snippet content.
             * </pre>
             *
             * <code>string snippet = 1;</code>
             *
             * @return The snippet.
             */
            java.lang.String getSnippet();

            /**
             *
             *
             * <pre>
             * Snippet content.
             * </pre>
             *
             * <code>string snippet = 1;</code>
             *
             * @return The bytes for snippet.
             */
            com.google.protobuf.ByteString getSnippetBytes();

            /**
             *
             *
             * <pre>
             * Status of the snippet defined by the search team.
             * </pre>
             *
             * <code>string snippet_status = 2;</code>
             *
             * @return The snippetStatus.
             */
            java.lang.String getSnippetStatus();

            /**
             *
             *
             * <pre>
             * Status of the snippet defined by the search team.
             * </pre>
             *
             * <code>string snippet_status = 2;</code>
             *
             * @return The bytes for snippetStatus.
             */
            com.google.protobuf.ByteString getSnippetStatusBytes();
          }

          /**
           *
           *
           * <pre>
           * Snippet information.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo}
           */
          public static final class SnippetInfo extends com.google.protobuf.GeneratedMessageV3
              implements
              // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo)
              SnippetInfoOrBuilder {
            private static final long serialVersionUID = 0L;

            // Use SnippetInfo.newBuilder() to construct.
            private SnippetInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
              super(builder);
            }

            private SnippetInfo() {
              snippet_ = "";
              snippetStatus_ = "";
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
              return new SnippetInfo();
            }

            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1.AnswerProto
                  .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_SnippetInfo_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1.AnswerProto
                  .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_SnippetInfo_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.SnippetInfo.class,
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.SnippetInfo.Builder.class);
            }

            public static final int SNIPPET_FIELD_NUMBER = 1;

            @SuppressWarnings("serial")
            private volatile java.lang.Object snippet_ = "";

            /**
             *
             *
             * <pre>
             * Snippet content.
             * </pre>
             *
             * <code>string snippet = 1;</code>
             *
             * @return The snippet.
             */
            @java.lang.Override
            public java.lang.String getSnippet() {
              java.lang.Object ref = snippet_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                snippet_ = s;
                return s;
              }
            }

            /**
             *
             *
             * <pre>
             * Snippet content.
             * </pre>
             *
             * <code>string snippet = 1;</code>
             *
             * @return The bytes for snippet.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getSnippetBytes() {
              java.lang.Object ref = snippet_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                snippet_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            public static final int SNIPPET_STATUS_FIELD_NUMBER = 2;

            @SuppressWarnings("serial")
            private volatile java.lang.Object snippetStatus_ = "";

            /**
             *
             *
             * <pre>
             * Status of the snippet defined by the search team.
             * </pre>
             *
             * <code>string snippet_status = 2;</code>
             *
             * @return The snippetStatus.
             */
            @java.lang.Override
            public java.lang.String getSnippetStatus() {
              java.lang.Object ref = snippetStatus_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                snippetStatus_ = s;
                return s;
              }
            }

            /**
             *
             *
             * <pre>
             * Status of the snippet defined by the search team.
             * </pre>
             *
             * <code>string snippet_status = 2;</code>
             *
             * @return The bytes for snippetStatus.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getSnippetStatusBytes() {
              java.lang.Object ref = snippetStatus_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                snippetStatus_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            private byte memoizedIsInitialized = -1;

            @java.lang.Override
            public final boolean isInitialized() {
              byte isInitialized = memoizedIsInitialized;
              if (isInitialized == 1) return true;
              if (isInitialized == 0) return false;

              memoizedIsInitialized = 1;
              return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snippet_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, snippet_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snippetStatus_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, snippetStatus_);
              }
              getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
              int size = memoizedSize;
              if (size != -1) return size;

              size = 0;
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snippet_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, snippet_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snippetStatus_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, snippetStatus_);
              }
              size += getUnknownFields().getSerializedSize();
              memoizedSize = size;
              return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
              if (obj == this) {
                return true;
              }
              if (!(obj
                  instanceof
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo)) {
                return super.equals(obj);
              }
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo
                  other =
                      (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                              .SearchResult.SnippetInfo)
                          obj;

              if (!getSnippet().equals(other.getSnippet())) return false;
              if (!getSnippetStatus().equals(other.getSnippetStatus())) return false;
              if (!getUnknownFields().equals(other.getUnknownFields())) return false;
              return true;
            }

            @java.lang.Override
            public int hashCode() {
              if (memoizedHashCode != 0) {
                return memoizedHashCode;
              }
              int hash = 41;
              hash = (19 * hash) + getDescriptor().hashCode();
              hash = (37 * hash) + SNIPPET_FIELD_NUMBER;
              hash = (53 * hash) + getSnippet().hashCode();
              hash = (37 * hash) + SNIPPET_STATUS_FIELD_NUMBER;
              hash = (53 * hash) + getSnippetStatus().hashCode();
              hash = (29 * hash) + getUnknownFields().hashCode();
              memoizedHashCode = hash;
              return hash;
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() {
              return newBuilder();
            }

            public static Builder newBuilder() {
              return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo
                    prototype) {
              return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @java.lang.Override
            public Builder toBuilder() {
              return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              Builder builder = new Builder(parent);
              return builder;
            }

            /**
             *
             *
             * <pre>
             * Snippet information.
             * </pre>
             *
             * Protobuf type {@code
             * google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo}
             */
            public static final class Builder
                extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
                implements
                // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo)
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .SnippetInfoOrBuilder {
              public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
                return com.google.cloud.discoveryengine.v1.AnswerProto
                    .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_SnippetInfo_descriptor;
              }

              @java.lang.Override
              protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                  internalGetFieldAccessorTable() {
                return com.google.cloud.discoveryengine.v1.AnswerProto
                    .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_SnippetInfo_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfo.class,
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfo.Builder.class);
              }

              // Construct using
              // com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo.newBuilder()
              private Builder() {}

              private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
              }

              @java.lang.Override
              public Builder clear() {
                super.clear();
                bitField0_ = 0;
                snippet_ = "";
                snippetStatus_ = "";
                return this;
              }

              @java.lang.Override
              public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
                return com.google.cloud.discoveryengine.v1.AnswerProto
                    .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_SnippetInfo_descriptor;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo
                  getDefaultInstanceForType() {
                return com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo.getDefaultInstance();
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo
                  build() {
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo
                    result = buildPartial();
                if (!result.isInitialized()) {
                  throw newUninitializedMessageException(result);
                }
                return result;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo
                  buildPartial() {
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo
                    result =
                        new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfo(this);
                if (bitField0_ != 0) {
                  buildPartial0(result);
                }
                onBuilt();
                return result;
              }

              private void buildPartial0(
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                          .SnippetInfo
                      result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                  result.snippet_ = snippet_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                  result.snippetStatus_ = snippetStatus_;
                }
              }

              @java.lang.Override
              public Builder clone() {
                return super.clone();
              }

              @java.lang.Override
              public Builder setField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.setField(field, value);
              }

              @java.lang.Override
              public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
              }

              @java.lang.Override
              public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
              }

              @java.lang.Override
              public Builder setRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field,
                  int index,
                  java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
              }

              @java.lang.Override
              public Builder addRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.addRepeatedField(field, value);
              }

              @java.lang.Override
              public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other
                    instanceof
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo) {
                  return mergeFrom(
                      (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                              .SearchResult.SnippetInfo)
                          other);
                } else {
                  super.mergeFrom(other);
                  return this;
                }
              }

              public Builder mergeFrom(
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                          .SnippetInfo
                      other) {
                if (other
                    == com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                        .SearchResult.SnippetInfo.getDefaultInstance()) return this;
                if (!other.getSnippet().isEmpty()) {
                  snippet_ = other.snippet_;
                  bitField0_ |= 0x00000001;
                  onChanged();
                }
                if (!other.getSnippetStatus().isEmpty()) {
                  snippetStatus_ = other.snippetStatus_;
                  bitField0_ |= 0x00000002;
                  onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
              }

              @java.lang.Override
              public final boolean isInitialized() {
                return true;
              }

              @java.lang.Override
              public Builder mergeFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
                if (extensionRegistry == null) {
                  throw new java.lang.NullPointerException();
                }
                try {
                  boolean done = false;
                  while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                      case 0:
                        done = true;
                        break;
                      case 10:
                        {
                          snippet_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000001;
                          break;
                        } // case 10
                      case 18:
                        {
                          snippetStatus_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000002;
                          break;
                        } // case 18
                      default:
                        {
                          if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                            done = true; // was an endgroup tag
                          }
                          break;
                        } // default:
                    } // switch (tag)
                  } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.unwrapIOException();
                } finally {
                  onChanged();
                } // finally
                return this;
              }

              private int bitField0_;

              private java.lang.Object snippet_ = "";

              /**
               *
               *
               * <pre>
               * Snippet content.
               * </pre>
               *
               * <code>string snippet = 1;</code>
               *
               * @return The snippet.
               */
              public java.lang.String getSnippet() {
                java.lang.Object ref = snippet_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  snippet_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Snippet content.
               * </pre>
               *
               * <code>string snippet = 1;</code>
               *
               * @return The bytes for snippet.
               */
              public com.google.protobuf.ByteString getSnippetBytes() {
                java.lang.Object ref = snippet_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  snippet_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Snippet content.
               * </pre>
               *
               * <code>string snippet = 1;</code>
               *
               * @param value The snippet to set.
               * @return This builder for chaining.
               */
              public Builder setSnippet(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                snippet_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Snippet content.
               * </pre>
               *
               * <code>string snippet = 1;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearSnippet() {
                snippet_ = getDefaultInstance().getSnippet();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Snippet content.
               * </pre>
               *
               * <code>string snippet = 1;</code>
               *
               * @param value The bytes for snippet to set.
               * @return This builder for chaining.
               */
              public Builder setSnippetBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                snippet_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              private java.lang.Object snippetStatus_ = "";

              /**
               *
               *
               * <pre>
               * Status of the snippet defined by the search team.
               * </pre>
               *
               * <code>string snippet_status = 2;</code>
               *
               * @return The snippetStatus.
               */
              public java.lang.String getSnippetStatus() {
                java.lang.Object ref = snippetStatus_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  snippetStatus_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Status of the snippet defined by the search team.
               * </pre>
               *
               * <code>string snippet_status = 2;</code>
               *
               * @return The bytes for snippetStatus.
               */
              public com.google.protobuf.ByteString getSnippetStatusBytes() {
                java.lang.Object ref = snippetStatus_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  snippetStatus_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Status of the snippet defined by the search team.
               * </pre>
               *
               * <code>string snippet_status = 2;</code>
               *
               * @param value The snippetStatus to set.
               * @return This builder for chaining.
               */
              public Builder setSnippetStatus(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                snippetStatus_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Status of the snippet defined by the search team.
               * </pre>
               *
               * <code>string snippet_status = 2;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearSnippetStatus() {
                snippetStatus_ = getDefaultInstance().getSnippetStatus();
                bitField0_ = (bitField0_ & ~0x00000002);
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Status of the snippet defined by the search team.
               * </pre>
               *
               * <code>string snippet_status = 2;</code>
               *
               * @param value The bytes for snippetStatus to set.
               * @return This builder for chaining.
               */
              public Builder setSnippetStatusBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                snippetStatus_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              @java.lang.Override
              public final Builder setUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
              }

              @java.lang.Override
              public final Builder mergeUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
              }

              // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo)
            }

            // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo)
            private static final com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                DEFAULT_INSTANCE;

            static {
              DEFAULT_INSTANCE =
                  new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                      .SearchResult.SnippetInfo();
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.SnippetInfo
                getDefaultInstance() {
              return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<SnippetInfo> PARSER =
                new com.google.protobuf.AbstractParser<SnippetInfo>() {
                  @java.lang.Override
                  public SnippetInfo parsePartialFrom(
                      com.google.protobuf.CodedInputStream input,
                      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                      throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                      builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                      throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                      throw e.asInvalidProtocolBufferException()
                          .setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                      throw new com.google.protobuf.InvalidProtocolBufferException(e)
                          .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                  }
                };

            public static com.google.protobuf.Parser<SnippetInfo> parser() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<SnippetInfo> getParserForType() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .SnippetInfo
                getDefaultInstanceForType() {
              return DEFAULT_INSTANCE;
            }
          }

          public interface ChunkInfoOrBuilder
              extends
              // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo)
              com.google.protobuf.MessageOrBuilder {

            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1;</code>
             *
             * @return The chunk.
             */
            java.lang.String getChunk();

            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1;</code>
             *
             * @return The bytes for chunk.
             */
            com.google.protobuf.ByteString getChunkBytes();

            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            java.lang.String getContent();

            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            com.google.protobuf.ByteString getContentBytes();

            /**
             *
             *
             * <pre>
             * The relevance of the chunk for a given query. Values range from
             * 0.0 (completely irrelevant) to 1.0 (completely relevant).
             * This value is for informational purpose only. It may change for
             * the same query and chunk at any time due to a model retraining or
             * change in implementation.
             * </pre>
             *
             * <code>optional float relevance_score = 3;</code>
             *
             * @return Whether the relevanceScore field is set.
             */
            boolean hasRelevanceScore();

            /**
             *
             *
             * <pre>
             * The relevance of the chunk for a given query. Values range from
             * 0.0 (completely irrelevant) to 1.0 (completely relevant).
             * This value is for informational purpose only. It may change for
             * the same query and chunk at any time due to a model retraining or
             * change in implementation.
             * </pre>
             *
             * <code>optional float relevance_score = 3;</code>
             *
             * @return The relevanceScore.
             */
            float getRelevanceScore();
          }

          /**
           *
           *
           * <pre>
           * Chunk information.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo}
           */
          public static final class ChunkInfo extends com.google.protobuf.GeneratedMessageV3
              implements
              // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo)
              ChunkInfoOrBuilder {
            private static final long serialVersionUID = 0L;

            // Use ChunkInfo.newBuilder() to construct.
            private ChunkInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
              super(builder);
            }

            private ChunkInfo() {
              chunk_ = "";
              content_ = "";
            }

            @java.lang.Override
            @SuppressWarnings({"unused"})
            protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
              return new ChunkInfo();
            }

            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1.AnswerProto
                  .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_ChunkInfo_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1.AnswerProto
                  .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_ChunkInfo_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.ChunkInfo.class,
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.ChunkInfo.Builder.class);
            }

            private int bitField0_;
            public static final int CHUNK_FIELD_NUMBER = 1;

            @SuppressWarnings("serial")
            private volatile java.lang.Object chunk_ = "";

            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1;</code>
             *
             * @return The chunk.
             */
            @java.lang.Override
            public java.lang.String getChunk() {
              java.lang.Object ref = chunk_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                chunk_ = s;
                return s;
              }
            }

            /**
             *
             *
             * <pre>
             * Chunk resource name.
             * </pre>
             *
             * <code>string chunk = 1;</code>
             *
             * @return The bytes for chunk.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getChunkBytes() {
              java.lang.Object ref = chunk_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                chunk_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            public static final int CONTENT_FIELD_NUMBER = 2;

            @SuppressWarnings("serial")
            private volatile java.lang.Object content_ = "";

            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The content.
             */
            @java.lang.Override
            public java.lang.String getContent() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                return (java.lang.String) ref;
              } else {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                content_ = s;
                return s;
              }
            }

            /**
             *
             *
             * <pre>
             * Chunk textual content.
             * </pre>
             *
             * <code>string content = 2;</code>
             *
             * @return The bytes for content.
             */
            @java.lang.Override
            public com.google.protobuf.ByteString getContentBytes() {
              java.lang.Object ref = content_;
              if (ref instanceof java.lang.String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                content_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            public static final int RELEVANCE_SCORE_FIELD_NUMBER = 3;
            private float relevanceScore_ = 0F;

            /**
             *
             *
             * <pre>
             * The relevance of the chunk for a given query. Values range from
             * 0.0 (completely irrelevant) to 1.0 (completely relevant).
             * This value is for informational purpose only. It may change for
             * the same query and chunk at any time due to a model retraining or
             * change in implementation.
             * </pre>
             *
             * <code>optional float relevance_score = 3;</code>
             *
             * @return Whether the relevanceScore field is set.
             */
            @java.lang.Override
            public boolean hasRelevanceScore() {
              return ((bitField0_ & 0x00000001) != 0);
            }

            /**
             *
             *
             * <pre>
             * The relevance of the chunk for a given query. Values range from
             * 0.0 (completely irrelevant) to 1.0 (completely relevant).
             * This value is for informational purpose only. It may change for
             * the same query and chunk at any time due to a model retraining or
             * change in implementation.
             * </pre>
             *
             * <code>optional float relevance_score = 3;</code>
             *
             * @return The relevanceScore.
             */
            @java.lang.Override
            public float getRelevanceScore() {
              return relevanceScore_;
            }

            private byte memoizedIsInitialized = -1;

            @java.lang.Override
            public final boolean isInitialized() {
              byte isInitialized = memoizedIsInitialized;
              if (isInitialized == 1) return true;
              if (isInitialized == 0) return false;

              memoizedIsInitialized = 1;
              return true;
            }

            @java.lang.Override
            public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunk_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, chunk_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
              }
              if (((bitField0_ & 0x00000001) != 0)) {
                output.writeFloat(3, relevanceScore_);
              }
              getUnknownFields().writeTo(output);
            }

            @java.lang.Override
            public int getSerializedSize() {
              int size = memoizedSize;
              if (size != -1) return size;

              size = 0;
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunk_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, chunk_);
              }
              if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
              }
              if (((bitField0_ & 0x00000001) != 0)) {
                size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, relevanceScore_);
              }
              size += getUnknownFields().getSerializedSize();
              memoizedSize = size;
              return size;
            }

            @java.lang.Override
            public boolean equals(final java.lang.Object obj) {
              if (obj == this) {
                return true;
              }
              if (!(obj
                  instanceof
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo)) {
                return super.equals(obj);
              }
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo
                  other =
                      (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                              .SearchResult.ChunkInfo)
                          obj;

              if (!getChunk().equals(other.getChunk())) return false;
              if (!getContent().equals(other.getContent())) return false;
              if (hasRelevanceScore() != other.hasRelevanceScore()) return false;
              if (hasRelevanceScore()) {
                if (java.lang.Float.floatToIntBits(getRelevanceScore())
                    != java.lang.Float.floatToIntBits(other.getRelevanceScore())) return false;
              }
              if (!getUnknownFields().equals(other.getUnknownFields())) return false;
              return true;
            }

            @java.lang.Override
            public int hashCode() {
              if (memoizedHashCode != 0) {
                return memoizedHashCode;
              }
              int hash = 41;
              hash = (19 * hash) + getDescriptor().hashCode();
              hash = (37 * hash) + CHUNK_FIELD_NUMBER;
              hash = (53 * hash) + getChunk().hashCode();
              hash = (37 * hash) + CONTENT_FIELD_NUMBER;
              hash = (53 * hash) + getContent().hashCode();
              if (hasRelevanceScore()) {
                hash = (37 * hash) + RELEVANCE_SCORE_FIELD_NUMBER;
                hash = (53 * hash) + java.lang.Float.floatToIntBits(getRelevanceScore());
              }
              hash = (29 * hash) + getUnknownFields().hashCode();
              memoizedHashCode = hash;
              return hash;
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(java.nio.ByteBuffer data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(
                    java.nio.ByteBuffer data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(com.google.protobuf.ByteString data)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(
                    com.google.protobuf.ByteString data,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
              return PARSER.parseFrom(data, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseDelimitedFrom(
                    java.io.InputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                  PARSER, input, extensionRegistry);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                parseFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
              return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                  PARSER, input, extensionRegistry);
            }

            @java.lang.Override
            public Builder newBuilderForType() {
              return newBuilder();
            }

            public static Builder newBuilder() {
              return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo
                    prototype) {
              return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            @java.lang.Override
            public Builder toBuilder() {
              return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            @java.lang.Override
            protected Builder newBuilderForType(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              Builder builder = new Builder(parent);
              return builder;
            }

            /**
             *
             *
             * <pre>
             * Chunk information.
             * </pre>
             *
             * Protobuf type {@code
             * google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo}
             */
            public static final class Builder
                extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
                implements
                // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo)
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .ChunkInfoOrBuilder {
              public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
                return com.google.cloud.discoveryengine.v1.AnswerProto
                    .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_ChunkInfo_descriptor;
              }

              @java.lang.Override
              protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                  internalGetFieldAccessorTable() {
                return com.google.cloud.discoveryengine.v1.AnswerProto
                    .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_ChunkInfo_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfo.class,
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfo.Builder.class);
              }

              // Construct using
              // com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo.newBuilder()
              private Builder() {}

              private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
              }

              @java.lang.Override
              public Builder clear() {
                super.clear();
                bitField0_ = 0;
                chunk_ = "";
                content_ = "";
                relevanceScore_ = 0F;
                return this;
              }

              @java.lang.Override
              public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
                return com.google.cloud.discoveryengine.v1.AnswerProto
                    .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_ChunkInfo_descriptor;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo
                  getDefaultInstanceForType() {
                return com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo.getDefaultInstance();
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo
                  build() {
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo
                    result = buildPartial();
                if (!result.isInitialized()) {
                  throw newUninitializedMessageException(result);
                }
                return result;
              }

              @java.lang.Override
              public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo
                  buildPartial() {
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo
                    result =
                        new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfo(this);
                if (bitField0_ != 0) {
                  buildPartial0(result);
                }
                onBuilt();
                return result;
              }

              private void buildPartial0(
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                          .ChunkInfo
                      result) {
                int from_bitField0_ = bitField0_;
                if (((from_bitField0_ & 0x00000001) != 0)) {
                  result.chunk_ = chunk_;
                }
                if (((from_bitField0_ & 0x00000002) != 0)) {
                  result.content_ = content_;
                }
                int to_bitField0_ = 0;
                if (((from_bitField0_ & 0x00000004) != 0)) {
                  result.relevanceScore_ = relevanceScore_;
                  to_bitField0_ |= 0x00000001;
                }
                result.bitField0_ |= to_bitField0_;
              }

              @java.lang.Override
              public Builder clone() {
                return super.clone();
              }

              @java.lang.Override
              public Builder setField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.setField(field, value);
              }

              @java.lang.Override
              public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
              }

              @java.lang.Override
              public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
              }

              @java.lang.Override
              public Builder setRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field,
                  int index,
                  java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
              }

              @java.lang.Override
              public Builder addRepeatedField(
                  com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
                return super.addRepeatedField(field, value);
              }

              @java.lang.Override
              public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other
                    instanceof
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo) {
                  return mergeFrom(
                      (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                              .SearchResult.ChunkInfo)
                          other);
                } else {
                  super.mergeFrom(other);
                  return this;
                }
              }

              public Builder mergeFrom(
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                          .ChunkInfo
                      other) {
                if (other
                    == com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                        .SearchResult.ChunkInfo.getDefaultInstance()) return this;
                if (!other.getChunk().isEmpty()) {
                  chunk_ = other.chunk_;
                  bitField0_ |= 0x00000001;
                  onChanged();
                }
                if (!other.getContent().isEmpty()) {
                  content_ = other.content_;
                  bitField0_ |= 0x00000002;
                  onChanged();
                }
                if (other.hasRelevanceScore()) {
                  setRelevanceScore(other.getRelevanceScore());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                onChanged();
                return this;
              }

              @java.lang.Override
              public final boolean isInitialized() {
                return true;
              }

              @java.lang.Override
              public Builder mergeFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
                if (extensionRegistry == null) {
                  throw new java.lang.NullPointerException();
                }
                try {
                  boolean done = false;
                  while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                      case 0:
                        done = true;
                        break;
                      case 10:
                        {
                          chunk_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000001;
                          break;
                        } // case 10
                      case 18:
                        {
                          content_ = input.readStringRequireUtf8();
                          bitField0_ |= 0x00000002;
                          break;
                        } // case 18
                      case 29:
                        {
                          relevanceScore_ = input.readFloat();
                          bitField0_ |= 0x00000004;
                          break;
                        } // case 29
                      default:
                        {
                          if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                            done = true; // was an endgroup tag
                          }
                          break;
                        } // default:
                    } // switch (tag)
                  } // while (!done)
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.unwrapIOException();
                } finally {
                  onChanged();
                } // finally
                return this;
              }

              private int bitField0_;

              private java.lang.Object chunk_ = "";

              /**
               *
               *
               * <pre>
               * Chunk resource name.
               * </pre>
               *
               * <code>string chunk = 1;</code>
               *
               * @return The chunk.
               */
              public java.lang.String getChunk() {
                java.lang.Object ref = chunk_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  chunk_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Chunk resource name.
               * </pre>
               *
               * <code>string chunk = 1;</code>
               *
               * @return The bytes for chunk.
               */
              public com.google.protobuf.ByteString getChunkBytes() {
                java.lang.Object ref = chunk_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  chunk_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Chunk resource name.
               * </pre>
               *
               * <code>string chunk = 1;</code>
               *
               * @param value The chunk to set.
               * @return This builder for chaining.
               */
              public Builder setChunk(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                chunk_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Chunk resource name.
               * </pre>
               *
               * <code>string chunk = 1;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearChunk() {
                chunk_ = getDefaultInstance().getChunk();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Chunk resource name.
               * </pre>
               *
               * <code>string chunk = 1;</code>
               *
               * @param value The bytes for chunk to set.
               * @return This builder for chaining.
               */
              public Builder setChunkBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                chunk_ = value;
                bitField0_ |= 0x00000001;
                onChanged();
                return this;
              }

              private java.lang.Object content_ = "";

              /**
               *
               *
               * <pre>
               * Chunk textual content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The content.
               */
              public java.lang.String getContent() {
                java.lang.Object ref = content_;
                if (!(ref instanceof java.lang.String)) {
                  com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                  java.lang.String s = bs.toStringUtf8();
                  content_ = s;
                  return s;
                } else {
                  return (java.lang.String) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Chunk textual content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return The bytes for content.
               */
              public com.google.protobuf.ByteString getContentBytes() {
                java.lang.Object ref = content_;
                if (ref instanceof String) {
                  com.google.protobuf.ByteString b =
                      com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                  content_ = b;
                  return b;
                } else {
                  return (com.google.protobuf.ByteString) ref;
                }
              }

              /**
               *
               *
               * <pre>
               * Chunk textual content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The content to set.
               * @return This builder for chaining.
               */
              public Builder setContent(java.lang.String value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Chunk textual content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearContent() {
                content_ = getDefaultInstance().getContent();
                bitField0_ = (bitField0_ & ~0x00000002);
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * Chunk textual content.
               * </pre>
               *
               * <code>string content = 2;</code>
               *
               * @param value The bytes for content to set.
               * @return This builder for chaining.
               */
              public Builder setContentBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                  throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                content_ = value;
                bitField0_ |= 0x00000002;
                onChanged();
                return this;
              }

              private float relevanceScore_;

              /**
               *
               *
               * <pre>
               * The relevance of the chunk for a given query. Values range from
               * 0.0 (completely irrelevant) to 1.0 (completely relevant).
               * This value is for informational purpose only. It may change for
               * the same query and chunk at any time due to a model retraining or
               * change in implementation.
               * </pre>
               *
               * <code>optional float relevance_score = 3;</code>
               *
               * @return Whether the relevanceScore field is set.
               */
              @java.lang.Override
              public boolean hasRelevanceScore() {
                return ((bitField0_ & 0x00000004) != 0);
              }

              /**
               *
               *
               * <pre>
               * The relevance of the chunk for a given query. Values range from
               * 0.0 (completely irrelevant) to 1.0 (completely relevant).
               * This value is for informational purpose only. It may change for
               * the same query and chunk at any time due to a model retraining or
               * change in implementation.
               * </pre>
               *
               * <code>optional float relevance_score = 3;</code>
               *
               * @return The relevanceScore.
               */
              @java.lang.Override
              public float getRelevanceScore() {
                return relevanceScore_;
              }

              /**
               *
               *
               * <pre>
               * The relevance of the chunk for a given query. Values range from
               * 0.0 (completely irrelevant) to 1.0 (completely relevant).
               * This value is for informational purpose only. It may change for
               * the same query and chunk at any time due to a model retraining or
               * change in implementation.
               * </pre>
               *
               * <code>optional float relevance_score = 3;</code>
               *
               * @param value The relevanceScore to set.
               * @return This builder for chaining.
               */
              public Builder setRelevanceScore(float value) {

                relevanceScore_ = value;
                bitField0_ |= 0x00000004;
                onChanged();
                return this;
              }

              /**
               *
               *
               * <pre>
               * The relevance of the chunk for a given query. Values range from
               * 0.0 (completely irrelevant) to 1.0 (completely relevant).
               * This value is for informational purpose only. It may change for
               * the same query and chunk at any time due to a model retraining or
               * change in implementation.
               * </pre>
               *
               * <code>optional float relevance_score = 3;</code>
               *
               * @return This builder for chaining.
               */
              public Builder clearRelevanceScore() {
                bitField0_ = (bitField0_ & ~0x00000004);
                relevanceScore_ = 0F;
                onChanged();
                return this;
              }

              @java.lang.Override
              public final Builder setUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
              }

              @java.lang.Override
              public final Builder mergeUnknownFields(
                  final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
              }

              // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo)
            }

            // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo)
            private static final com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                DEFAULT_INSTANCE;

            static {
              DEFAULT_INSTANCE =
                  new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                      .SearchResult.ChunkInfo();
            }

            public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult.ChunkInfo
                getDefaultInstance() {
              return DEFAULT_INSTANCE;
            }

            private static final com.google.protobuf.Parser<ChunkInfo> PARSER =
                new com.google.protobuf.AbstractParser<ChunkInfo>() {
                  @java.lang.Override
                  public ChunkInfo parsePartialFrom(
                      com.google.protobuf.CodedInputStream input,
                      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                      throws com.google.protobuf.InvalidProtocolBufferException {
                    Builder builder = newBuilder();
                    try {
                      builder.mergeFrom(input, extensionRegistry);
                    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                      throw e.setUnfinishedMessage(builder.buildPartial());
                    } catch (com.google.protobuf.UninitializedMessageException e) {
                      throw e.asInvalidProtocolBufferException()
                          .setUnfinishedMessage(builder.buildPartial());
                    } catch (java.io.IOException e) {
                      throw new com.google.protobuf.InvalidProtocolBufferException(e)
                          .setUnfinishedMessage(builder.buildPartial());
                    }
                    return builder.buildPartial();
                  }
                };

            public static com.google.protobuf.Parser<ChunkInfo> parser() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.protobuf.Parser<ChunkInfo> getParserForType() {
              return PARSER;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .ChunkInfo
                getDefaultInstanceForType() {
              return DEFAULT_INSTANCE;
            }
          }

          private int bitField0_;
          public static final int DOCUMENT_FIELD_NUMBER = 1;

          @SuppressWarnings("serial")
          private volatile java.lang.Object document_ = "";

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1;</code>
           *
           * @return The document.
           */
          @java.lang.Override
          public java.lang.String getDocument() {
            java.lang.Object ref = document_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              document_ = s;
              return s;
            }
          }

          /**
           *
           *
           * <pre>
           * Document resource name.
           * </pre>
           *
           * <code>string document = 1;</code>
           *
           * @return The bytes for document.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getDocumentBytes() {
            java.lang.Object ref = document_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              document_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int URI_FIELD_NUMBER = 2;

          @SuppressWarnings("serial")
          private volatile java.lang.Object uri_ = "";

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The uri.
           */
          @java.lang.Override
          public java.lang.String getUri() {
            java.lang.Object ref = uri_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              uri_ = s;
              return s;
            }
          }

          /**
           *
           *
           * <pre>
           * URI for the document.
           * </pre>
           *
           * <code>string uri = 2;</code>
           *
           * @return The bytes for uri.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getUriBytes() {
            java.lang.Object ref = uri_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              uri_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int TITLE_FIELD_NUMBER = 3;

          @SuppressWarnings("serial")
          private volatile java.lang.Object title_ = "";

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The title.
           */
          @java.lang.Override
          public java.lang.String getTitle() {
            java.lang.Object ref = title_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              title_ = s;
              return s;
            }
          }

          /**
           *
           *
           * <pre>
           * Title.
           * </pre>
           *
           * <code>string title = 3;</code>
           *
           * @return The bytes for title.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getTitleBytes() {
            java.lang.Object ref = title_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              title_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int SNIPPET_INFO_FIELD_NUMBER = 4;

          @SuppressWarnings("serial")
          private java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo>
              snippetInfo_;

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .SnippetInfo>
              getSnippetInfoList() {
            return snippetInfo_;
          }

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.SnippetInfoOrBuilder>
              getSnippetInfoOrBuilderList() {
            return snippetInfo_;
          }

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          @java.lang.Override
          public int getSnippetInfoCount() {
            return snippetInfo_.size();
          }

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .SnippetInfo
              getSnippetInfo(int index) {
            return snippetInfo_.get(index);
          }

          /**
           *
           *
           * <pre>
           * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
           * level snippets.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .SnippetInfoOrBuilder
              getSnippetInfoOrBuilder(int index) {
            return snippetInfo_.get(index);
          }

          public static final int CHUNK_INFO_FIELD_NUMBER = 5;

          @SuppressWarnings("serial")
          private java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo>
              chunkInfo_;

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .ChunkInfo>
              getChunkInfoList() {
            return chunkInfo_;
          }

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          @java.lang.Override
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.ChunkInfoOrBuilder>
              getChunkInfoOrBuilderList() {
            return chunkInfo_;
          }

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          @java.lang.Override
          public int getChunkInfoCount() {
            return chunkInfo_.size();
          }

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .ChunkInfo
              getChunkInfo(int index) {
            return chunkInfo_.get(index);
          }

          /**
           *
           *
           * <pre>
           * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
           * populate chunk info.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
           * </code>
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .ChunkInfoOrBuilder
              getChunkInfoOrBuilder(int index) {
            return chunkInfo_.get(index);
          }

          public static final int STRUCT_DATA_FIELD_NUMBER = 6;
          private com.google.protobuf.Struct structData_;

          /**
           *
           *
           * <pre>
           * Data representation.
           * The structured JSON data for the document.
           * It's populated from the struct data from the Document, or the
           * Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 6;</code>
           *
           * @return Whether the structData field is set.
           */
          @java.lang.Override
          public boolean hasStructData() {
            return ((bitField0_ & 0x00000001) != 0);
          }

          /**
           *
           *
           * <pre>
           * Data representation.
           * The structured JSON data for the document.
           * It's populated from the struct data from the Document, or the
           * Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 6;</code>
           *
           * @return The structData.
           */
          @java.lang.Override
          public com.google.protobuf.Struct getStructData() {
            return structData_ == null
                ? com.google.protobuf.Struct.getDefaultInstance()
                : structData_;
          }

          /**
           *
           *
           * <pre>
           * Data representation.
           * The structured JSON data for the document.
           * It's populated from the struct data from the Document, or the
           * Chunk in search result.
           * </pre>
           *
           * <code>.google.protobuf.Struct struct_data = 6;</code>
           */
          @java.lang.Override
          public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
            return structData_ == null
                ? com.google.protobuf.Struct.getDefaultInstance()
                : structData_;
          }

          private byte memoizedIsInitialized = -1;

          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
              throws java.io.IOException {
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 1, document_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 3, title_);
            }
            for (int i = 0; i < snippetInfo_.size(); i++) {
              output.writeMessage(4, snippetInfo_.get(i));
            }
            for (int i = 0; i < chunkInfo_.size(); i++) {
              output.writeMessage(5, chunkInfo_.get(i));
            }
            if (((bitField0_ & 0x00000001) != 0)) {
              output.writeMessage(6, getStructData());
            }
            getUnknownFields().writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(document_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, document_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
            }
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, title_);
            }
            for (int i = 0; i < snippetInfo_.size(); i++) {
              size +=
                  com.google.protobuf.CodedOutputStream.computeMessageSize(4, snippetInfo_.get(i));
            }
            for (int i = 0; i < chunkInfo_.size(); i++) {
              size +=
                  com.google.protobuf.CodedOutputStream.computeMessageSize(5, chunkInfo_.get(i));
            }
            if (((bitField0_ & 0x00000001) != 0)) {
              size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getStructData());
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
              return true;
            }
            if (!(obj
                instanceof
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult)) {
              return super.equals(obj);
            }
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult other =
                (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult)
                    obj;

            if (!getDocument().equals(other.getDocument())) return false;
            if (!getUri().equals(other.getUri())) return false;
            if (!getTitle().equals(other.getTitle())) return false;
            if (!getSnippetInfoList().equals(other.getSnippetInfoList())) return false;
            if (!getChunkInfoList().equals(other.getChunkInfoList())) return false;
            if (hasStructData() != other.hasStructData()) return false;
            if (hasStructData()) {
              if (!getStructData().equals(other.getStructData())) return false;
            }
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
            hash = (53 * hash) + getDocument().hashCode();
            hash = (37 * hash) + URI_FIELD_NUMBER;
            hash = (53 * hash) + getUri().hashCode();
            hash = (37 * hash) + TITLE_FIELD_NUMBER;
            hash = (53 * hash) + getTitle().hashCode();
            if (getSnippetInfoCount() > 0) {
              hash = (37 * hash) + SNIPPET_INFO_FIELD_NUMBER;
              hash = (53 * hash) + getSnippetInfoList().hashCode();
            }
            if (getChunkInfoCount() > 0) {
              hash = (37 * hash) + CHUNK_INFO_FIELD_NUMBER;
              hash = (53 * hash) + getChunkInfoList().hashCode();
            }
            if (hasStructData()) {
              hash = (37 * hash) + STRUCT_DATA_FIELD_NUMBER;
              hash = (53 * hash) + getStructData().hashCode();
            }
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(java.nio.ByteBuffer data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(
                  java.nio.ByteBuffer data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(com.google.protobuf.ByteString data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(
                  com.google.protobuf.ByteString data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseDelimitedFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              parseFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() {
            return newBuilder();
          }

          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }

          public static Builder newBuilder(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }

          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }

          /**
           * Protobuf type {@code
           * google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult}
           */
          public static final class Builder
              extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
              implements
              // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult)
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResultOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.discoveryengine.v1.AnswerProto
                  .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.discoveryengine.v1.AnswerProto
                  .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.class,
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.Builder.class);
            }

            // Construct using
            // com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.newBuilder()
            private Builder() {
              maybeForceBuilderInitialization();
            }

            private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
              maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
              if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
                getSnippetInfoFieldBuilder();
                getChunkInfoFieldBuilder();
                getStructDataFieldBuilder();
              }
            }

            @java.lang.Override
            public Builder clear() {
              super.clear();
              bitField0_ = 0;
              document_ = "";
              uri_ = "";
              title_ = "";
              if (snippetInfoBuilder_ == null) {
                snippetInfo_ = java.util.Collections.emptyList();
              } else {
                snippetInfo_ = null;
                snippetInfoBuilder_.clear();
              }
              bitField0_ = (bitField0_ & ~0x00000008);
              if (chunkInfoBuilder_ == null) {
                chunkInfo_ = java.util.Collections.emptyList();
              } else {
                chunkInfo_ = null;
                chunkInfoBuilder_.clear();
              }
              bitField0_ = (bitField0_ & ~0x00000010);
              structData_ = null;
              if (structDataBuilder_ != null) {
                structDataBuilder_.dispose();
                structDataBuilder_ = null;
              }
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
              return com.google.cloud.discoveryengine.v1.AnswerProto
                  .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_SearchResult_descriptor;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                getDefaultInstanceForType() {
              return com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .getDefaultInstance();
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                build() {
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                buildPartial() {
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  result =
                      new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult(this);
              buildPartialRepeatedFields(result);
              if (bitField0_ != 0) {
                buildPartial0(result);
              }
              onBuilt();
              return result;
            }

            private void buildPartialRepeatedFields(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    result) {
              if (snippetInfoBuilder_ == null) {
                if (((bitField0_ & 0x00000008) != 0)) {
                  snippetInfo_ = java.util.Collections.unmodifiableList(snippetInfo_);
                  bitField0_ = (bitField0_ & ~0x00000008);
                }
                result.snippetInfo_ = snippetInfo_;
              } else {
                result.snippetInfo_ = snippetInfoBuilder_.build();
              }
              if (chunkInfoBuilder_ == null) {
                if (((bitField0_ & 0x00000010) != 0)) {
                  chunkInfo_ = java.util.Collections.unmodifiableList(chunkInfo_);
                  bitField0_ = (bitField0_ & ~0x00000010);
                }
                result.chunkInfo_ = chunkInfo_;
              } else {
                result.chunkInfo_ = chunkInfoBuilder_.build();
              }
            }

            private void buildPartial0(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    result) {
              int from_bitField0_ = bitField0_;
              if (((from_bitField0_ & 0x00000001) != 0)) {
                result.document_ = document_;
              }
              if (((from_bitField0_ & 0x00000002) != 0)) {
                result.uri_ = uri_;
              }
              if (((from_bitField0_ & 0x00000004) != 0)) {
                result.title_ = title_;
              }
              int to_bitField0_ = 0;
              if (((from_bitField0_ & 0x00000020) != 0)) {
                result.structData_ =
                    structDataBuilder_ == null ? structData_ : structDataBuilder_.build();
                to_bitField0_ |= 0x00000001;
              }
              result.bitField0_ |= to_bitField0_;
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index,
                java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other
                  instanceof
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult) {
                return mergeFrom(
                    (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult)
                        other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    other) {
              if (other
                  == com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .getDefaultInstance()) return this;
              if (!other.getDocument().isEmpty()) {
                document_ = other.document_;
                bitField0_ |= 0x00000001;
                onChanged();
              }
              if (!other.getUri().isEmpty()) {
                uri_ = other.uri_;
                bitField0_ |= 0x00000002;
                onChanged();
              }
              if (!other.getTitle().isEmpty()) {
                title_ = other.title_;
                bitField0_ |= 0x00000004;
                onChanged();
              }
              if (snippetInfoBuilder_ == null) {
                if (!other.snippetInfo_.isEmpty()) {
                  if (snippetInfo_.isEmpty()) {
                    snippetInfo_ = other.snippetInfo_;
                    bitField0_ = (bitField0_ & ~0x00000008);
                  } else {
                    ensureSnippetInfoIsMutable();
                    snippetInfo_.addAll(other.snippetInfo_);
                  }
                  onChanged();
                }
              } else {
                if (!other.snippetInfo_.isEmpty()) {
                  if (snippetInfoBuilder_.isEmpty()) {
                    snippetInfoBuilder_.dispose();
                    snippetInfoBuilder_ = null;
                    snippetInfo_ = other.snippetInfo_;
                    bitField0_ = (bitField0_ & ~0x00000008);
                    snippetInfoBuilder_ =
                        com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                            ? getSnippetInfoFieldBuilder()
                            : null;
                  } else {
                    snippetInfoBuilder_.addAllMessages(other.snippetInfo_);
                  }
                }
              }
              if (chunkInfoBuilder_ == null) {
                if (!other.chunkInfo_.isEmpty()) {
                  if (chunkInfo_.isEmpty()) {
                    chunkInfo_ = other.chunkInfo_;
                    bitField0_ = (bitField0_ & ~0x00000010);
                  } else {
                    ensureChunkInfoIsMutable();
                    chunkInfo_.addAll(other.chunkInfo_);
                  }
                  onChanged();
                }
              } else {
                if (!other.chunkInfo_.isEmpty()) {
                  if (chunkInfoBuilder_.isEmpty()) {
                    chunkInfoBuilder_.dispose();
                    chunkInfoBuilder_ = null;
                    chunkInfo_ = other.chunkInfo_;
                    bitField0_ = (bitField0_ & ~0x00000010);
                    chunkInfoBuilder_ =
                        com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                            ? getChunkInfoFieldBuilder()
                            : null;
                  } else {
                    chunkInfoBuilder_.addAllMessages(other.chunkInfo_);
                  }
                }
              }
              if (other.hasStructData()) {
                mergeStructData(other.getStructData());
              }
              this.mergeUnknownFields(other.getUnknownFields());
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
              }
              try {
                boolean done = false;
                while (!done) {
                  int tag = input.readTag();
                  switch (tag) {
                    case 0:
                      done = true;
                      break;
                    case 10:
                      {
                        document_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000001;
                        break;
                      } // case 10
                    case 18:
                      {
                        uri_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000002;
                        break;
                      } // case 18
                    case 26:
                      {
                        title_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000004;
                        break;
                      } // case 26
                    case 34:
                      {
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                                .SearchResult.SnippetInfo
                            m =
                                input.readMessage(
                                    com.google.cloud.discoveryengine.v1.Answer.Step.Action
                                        .Observation.SearchResult.SnippetInfo.parser(),
                                    extensionRegistry);
                        if (snippetInfoBuilder_ == null) {
                          ensureSnippetInfoIsMutable();
                          snippetInfo_.add(m);
                        } else {
                          snippetInfoBuilder_.addMessage(m);
                        }
                        break;
                      } // case 34
                    case 42:
                      {
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                                .SearchResult.ChunkInfo
                            m =
                                input.readMessage(
                                    com.google.cloud.discoveryengine.v1.Answer.Step.Action
                                        .Observation.SearchResult.ChunkInfo.parser(),
                                    extensionRegistry);
                        if (chunkInfoBuilder_ == null) {
                          ensureChunkInfoIsMutable();
                          chunkInfo_.add(m);
                        } else {
                          chunkInfoBuilder_.addMessage(m);
                        }
                        break;
                      } // case 42
                    case 50:
                      {
                        input.readMessage(
                            getStructDataFieldBuilder().getBuilder(), extensionRegistry);
                        bitField0_ |= 0x00000020;
                        break;
                      } // case 50
                    default:
                      {
                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                          done = true; // was an endgroup tag
                        }
                        break;
                      } // default:
                  } // switch (tag)
                } // while (!done)
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
              } finally {
                onChanged();
              } // finally
              return this;
            }

            private int bitField0_;

            private java.lang.Object document_ = "";

            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1;</code>
             *
             * @return The document.
             */
            public java.lang.String getDocument() {
              java.lang.Object ref = document_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                document_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }

            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1;</code>
             *
             * @return The bytes for document.
             */
            public com.google.protobuf.ByteString getDocumentBytes() {
              java.lang.Object ref = document_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                document_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1;</code>
             *
             * @param value The document to set.
             * @return This builder for chaining.
             */
            public Builder setDocument(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              document_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearDocument() {
              document_ = getDefaultInstance().getDocument();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Document resource name.
             * </pre>
             *
             * <code>string document = 1;</code>
             *
             * @param value The bytes for document to set.
             * @return This builder for chaining.
             */
            public Builder setDocumentBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              document_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }

            private java.lang.Object uri_ = "";

            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @return The uri.
             */
            public java.lang.String getUri() {
              java.lang.Object ref = uri_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                uri_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }

            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @return The bytes for uri.
             */
            public com.google.protobuf.ByteString getUriBytes() {
              java.lang.Object ref = uri_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                uri_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @param value The uri to set.
             * @return This builder for chaining.
             */
            public Builder setUri(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              uri_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearUri() {
              uri_ = getDefaultInstance().getUri();
              bitField0_ = (bitField0_ & ~0x00000002);
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * URI for the document.
             * </pre>
             *
             * <code>string uri = 2;</code>
             *
             * @param value The bytes for uri to set.
             * @return This builder for chaining.
             */
            public Builder setUriBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              uri_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }

            private java.lang.Object title_ = "";

            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @return The title.
             */
            public java.lang.String getTitle() {
              java.lang.Object ref = title_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                title_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }

            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @return The bytes for title.
             */
            public com.google.protobuf.ByteString getTitleBytes() {
              java.lang.Object ref = title_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                title_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }

            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @param value The title to set.
             * @return This builder for chaining.
             */
            public Builder setTitle(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              title_ = value;
              bitField0_ |= 0x00000004;
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearTitle() {
              title_ = getDefaultInstance().getTitle();
              bitField0_ = (bitField0_ & ~0x00000004);
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Title.
             * </pre>
             *
             * <code>string title = 3;</code>
             *
             * @param value The bytes for title to set.
             * @return This builder for chaining.
             */
            public Builder setTitleBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              title_ = value;
              bitField0_ |= 0x00000004;
              onChanged();
              return this;
            }

            private java.util.List<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo>
                snippetInfo_ = java.util.Collections.emptyList();

            private void ensureSnippetInfoIsMutable() {
              if (!((bitField0_ & 0x00000008) != 0)) {
                snippetInfo_ =
                    new java.util.ArrayList<
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfo>(snippetInfo_);
                bitField0_ |= 0x00000008;
              }
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo.Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfoOrBuilder>
                snippetInfoBuilder_;

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo>
                getSnippetInfoList() {
              if (snippetInfoBuilder_ == null) {
                return java.util.Collections.unmodifiableList(snippetInfo_);
              } else {
                return snippetInfoBuilder_.getMessageList();
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public int getSnippetInfoCount() {
              if (snippetInfoBuilder_ == null) {
                return snippetInfo_.size();
              } else {
                return snippetInfoBuilder_.getCount();
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .SnippetInfo
                getSnippetInfo(int index) {
              if (snippetInfoBuilder_ == null) {
                return snippetInfo_.get(index);
              } else {
                return snippetInfoBuilder_.getMessage(index);
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder setSnippetInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo
                    value) {
              if (snippetInfoBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureSnippetInfoIsMutable();
                snippetInfo_.set(index, value);
                onChanged();
              } else {
                snippetInfoBuilder_.setMessage(index, value);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder setSnippetInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo.Builder
                    builderForValue) {
              if (snippetInfoBuilder_ == null) {
                ensureSnippetInfoIsMutable();
                snippetInfo_.set(index, builderForValue.build());
                onChanged();
              } else {
                snippetInfoBuilder_.setMessage(index, builderForValue.build());
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder addSnippetInfo(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo
                    value) {
              if (snippetInfoBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureSnippetInfoIsMutable();
                snippetInfo_.add(value);
                onChanged();
              } else {
                snippetInfoBuilder_.addMessage(value);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder addSnippetInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo
                    value) {
              if (snippetInfoBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureSnippetInfoIsMutable();
                snippetInfo_.add(index, value);
                onChanged();
              } else {
                snippetInfoBuilder_.addMessage(index, value);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder addSnippetInfo(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo.Builder
                    builderForValue) {
              if (snippetInfoBuilder_ == null) {
                ensureSnippetInfoIsMutable();
                snippetInfo_.add(builderForValue.build());
                onChanged();
              } else {
                snippetInfoBuilder_.addMessage(builderForValue.build());
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder addSnippetInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo.Builder
                    builderForValue) {
              if (snippetInfoBuilder_ == null) {
                ensureSnippetInfoIsMutable();
                snippetInfo_.add(index, builderForValue.build());
                onChanged();
              } else {
                snippetInfoBuilder_.addMessage(index, builderForValue.build());
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder addAllSnippetInfo(
                java.lang.Iterable<
                        ? extends
                            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                                .SearchResult.SnippetInfo>
                    values) {
              if (snippetInfoBuilder_ == null) {
                ensureSnippetInfoIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(values, snippetInfo_);
                onChanged();
              } else {
                snippetInfoBuilder_.addAllMessages(values);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder clearSnippetInfo() {
              if (snippetInfoBuilder_ == null) {
                snippetInfo_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000008);
                onChanged();
              } else {
                snippetInfoBuilder_.clear();
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public Builder removeSnippetInfo(int index) {
              if (snippetInfoBuilder_ == null) {
                ensureSnippetInfoIsMutable();
                snippetInfo_.remove(index);
                onChanged();
              } else {
                snippetInfoBuilder_.remove(index);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .SnippetInfo.Builder
                getSnippetInfoBuilder(int index) {
              return getSnippetInfoFieldBuilder().getBuilder(index);
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .SnippetInfoOrBuilder
                getSnippetInfoOrBuilder(int index) {
              if (snippetInfoBuilder_ == null) {
                return snippetInfo_.get(index);
              } else {
                return snippetInfoBuilder_.getMessageOrBuilder(index);
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public java.util.List<
                    ? extends
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfoOrBuilder>
                getSnippetInfoOrBuilderList() {
              if (snippetInfoBuilder_ != null) {
                return snippetInfoBuilder_.getMessageOrBuilderList();
              } else {
                return java.util.Collections.unmodifiableList(snippetInfo_);
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .SnippetInfo.Builder
                addSnippetInfoBuilder() {
              return getSnippetInfoFieldBuilder()
                  .addBuilder(
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.SnippetInfo.getDefaultInstance());
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .SnippetInfo.Builder
                addSnippetInfoBuilder(int index) {
              return getSnippetInfoFieldBuilder()
                  .addBuilder(
                      index,
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.SnippetInfo.getDefaultInstance());
            }

            /**
             *
             *
             * <pre>
             * If citation_type is DOCUMENT_LEVEL_CITATION, populate document
             * level snippets.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.SnippetInfo snippet_info = 4;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo.Builder>
                getSnippetInfoBuilderList() {
              return getSnippetInfoFieldBuilder().getBuilderList();
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfo.Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .SnippetInfoOrBuilder>
                getSnippetInfoFieldBuilder() {
              if (snippetInfoBuilder_ == null) {
                snippetInfoBuilder_ =
                    new com.google.protobuf.RepeatedFieldBuilderV3<
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfo,
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfo.Builder,
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.SnippetInfoOrBuilder>(
                        snippetInfo_,
                        ((bitField0_ & 0x00000008) != 0),
                        getParentForChildren(),
                        isClean());
                snippetInfo_ = null;
              }
              return snippetInfoBuilder_;
            }

            private java.util.List<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo>
                chunkInfo_ = java.util.Collections.emptyList();

            private void ensureChunkInfoIsMutable() {
              if (!((bitField0_ & 0x00000010) != 0)) {
                chunkInfo_ =
                    new java.util.ArrayList<
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfo>(chunkInfo_);
                bitField0_ |= 0x00000010;
              }
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo.Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfoOrBuilder>
                chunkInfoBuilder_;

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo>
                getChunkInfoList() {
              if (chunkInfoBuilder_ == null) {
                return java.util.Collections.unmodifiableList(chunkInfo_);
              } else {
                return chunkInfoBuilder_.getMessageList();
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public int getChunkInfoCount() {
              if (chunkInfoBuilder_ == null) {
                return chunkInfo_.size();
              } else {
                return chunkInfoBuilder_.getCount();
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .ChunkInfo
                getChunkInfo(int index) {
              if (chunkInfoBuilder_ == null) {
                return chunkInfo_.get(index);
              } else {
                return chunkInfoBuilder_.getMessage(index);
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder setChunkInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo
                    value) {
              if (chunkInfoBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureChunkInfoIsMutable();
                chunkInfo_.set(index, value);
                onChanged();
              } else {
                chunkInfoBuilder_.setMessage(index, value);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder setChunkInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo.Builder
                    builderForValue) {
              if (chunkInfoBuilder_ == null) {
                ensureChunkInfoIsMutable();
                chunkInfo_.set(index, builderForValue.build());
                onChanged();
              } else {
                chunkInfoBuilder_.setMessage(index, builderForValue.build());
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder addChunkInfo(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo
                    value) {
              if (chunkInfoBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureChunkInfoIsMutable();
                chunkInfo_.add(value);
                onChanged();
              } else {
                chunkInfoBuilder_.addMessage(value);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder addChunkInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo
                    value) {
              if (chunkInfoBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                ensureChunkInfoIsMutable();
                chunkInfo_.add(index, value);
                onChanged();
              } else {
                chunkInfoBuilder_.addMessage(index, value);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder addChunkInfo(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo.Builder
                    builderForValue) {
              if (chunkInfoBuilder_ == null) {
                ensureChunkInfoIsMutable();
                chunkInfo_.add(builderForValue.build());
                onChanged();
              } else {
                chunkInfoBuilder_.addMessage(builderForValue.build());
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder addChunkInfo(
                int index,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo.Builder
                    builderForValue) {
              if (chunkInfoBuilder_ == null) {
                ensureChunkInfoIsMutable();
                chunkInfo_.add(index, builderForValue.build());
                onChanged();
              } else {
                chunkInfoBuilder_.addMessage(index, builderForValue.build());
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder addAllChunkInfo(
                java.lang.Iterable<
                        ? extends
                            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                                .SearchResult.ChunkInfo>
                    values) {
              if (chunkInfoBuilder_ == null) {
                ensureChunkInfoIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(values, chunkInfo_);
                onChanged();
              } else {
                chunkInfoBuilder_.addAllMessages(values);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder clearChunkInfo() {
              if (chunkInfoBuilder_ == null) {
                chunkInfo_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000010);
                onChanged();
              } else {
                chunkInfoBuilder_.clear();
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public Builder removeChunkInfo(int index) {
              if (chunkInfoBuilder_ == null) {
                ensureChunkInfoIsMutable();
                chunkInfo_.remove(index);
                onChanged();
              } else {
                chunkInfoBuilder_.remove(index);
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .ChunkInfo.Builder
                getChunkInfoBuilder(int index) {
              return getChunkInfoFieldBuilder().getBuilder(index);
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .ChunkInfoOrBuilder
                getChunkInfoOrBuilder(int index) {
              if (chunkInfoBuilder_ == null) {
                return chunkInfo_.get(index);
              } else {
                return chunkInfoBuilder_.getMessageOrBuilder(index);
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public java.util.List<
                    ? extends
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfoOrBuilder>
                getChunkInfoOrBuilderList() {
              if (chunkInfoBuilder_ != null) {
                return chunkInfoBuilder_.getMessageOrBuilderList();
              } else {
                return java.util.Collections.unmodifiableList(chunkInfo_);
              }
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .ChunkInfo.Builder
                addChunkInfoBuilder() {
              return getChunkInfoFieldBuilder()
                  .addBuilder(
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.ChunkInfo.getDefaultInstance());
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                    .ChunkInfo.Builder
                addChunkInfoBuilder(int index) {
              return getChunkInfoFieldBuilder()
                  .addBuilder(
                      index,
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.ChunkInfo.getDefaultInstance());
            }

            /**
             *
             *
             * <pre>
             * If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
             * populate chunk info.
             * </pre>
             *
             * <code>
             * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult.ChunkInfo chunk_info = 5;
             * </code>
             */
            public java.util.List<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo.Builder>
                getChunkInfoBuilderList() {
              return getChunkInfoFieldBuilder().getBuilderList();
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfo.Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .ChunkInfoOrBuilder>
                getChunkInfoFieldBuilder() {
              if (chunkInfoBuilder_ == null) {
                chunkInfoBuilder_ =
                    new com.google.protobuf.RepeatedFieldBuilderV3<
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfo,
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfo.Builder,
                        com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                            .SearchResult.ChunkInfoOrBuilder>(
                        chunkInfo_,
                        ((bitField0_ & 0x00000010) != 0),
                        getParentForChildren(),
                        isClean());
                chunkInfo_ = null;
              }
              return chunkInfoBuilder_;
            }

            private com.google.protobuf.Struct structData_;
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Struct,
                    com.google.protobuf.Struct.Builder,
                    com.google.protobuf.StructOrBuilder>
                structDataBuilder_;

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             *
             * @return Whether the structData field is set.
             */
            public boolean hasStructData() {
              return ((bitField0_ & 0x00000020) != 0);
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             *
             * @return The structData.
             */
            public com.google.protobuf.Struct getStructData() {
              if (structDataBuilder_ == null) {
                return structData_ == null
                    ? com.google.protobuf.Struct.getDefaultInstance()
                    : structData_;
              } else {
                return structDataBuilder_.getMessage();
              }
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             */
            public Builder setStructData(com.google.protobuf.Struct value) {
              if (structDataBuilder_ == null) {
                if (value == null) {
                  throw new NullPointerException();
                }
                structData_ = value;
              } else {
                structDataBuilder_.setMessage(value);
              }
              bitField0_ |= 0x00000020;
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             */
            public Builder setStructData(com.google.protobuf.Struct.Builder builderForValue) {
              if (structDataBuilder_ == null) {
                structData_ = builderForValue.build();
              } else {
                structDataBuilder_.setMessage(builderForValue.build());
              }
              bitField0_ |= 0x00000020;
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             */
            public Builder mergeStructData(com.google.protobuf.Struct value) {
              if (structDataBuilder_ == null) {
                if (((bitField0_ & 0x00000020) != 0)
                    && structData_ != null
                    && structData_ != com.google.protobuf.Struct.getDefaultInstance()) {
                  getStructDataBuilder().mergeFrom(value);
                } else {
                  structData_ = value;
                }
              } else {
                structDataBuilder_.mergeFrom(value);
              }
              if (structData_ != null) {
                bitField0_ |= 0x00000020;
                onChanged();
              }
              return this;
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             */
            public Builder clearStructData() {
              bitField0_ = (bitField0_ & ~0x00000020);
              structData_ = null;
              if (structDataBuilder_ != null) {
                structDataBuilder_.dispose();
                structDataBuilder_ = null;
              }
              onChanged();
              return this;
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             */
            public com.google.protobuf.Struct.Builder getStructDataBuilder() {
              bitField0_ |= 0x00000020;
              onChanged();
              return getStructDataFieldBuilder().getBuilder();
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             */
            public com.google.protobuf.StructOrBuilder getStructDataOrBuilder() {
              if (structDataBuilder_ != null) {
                return structDataBuilder_.getMessageOrBuilder();
              } else {
                return structData_ == null
                    ? com.google.protobuf.Struct.getDefaultInstance()
                    : structData_;
              }
            }

            /**
             *
             *
             * <pre>
             * Data representation.
             * The structured JSON data for the document.
             * It's populated from the struct data from the Document, or the
             * Chunk in search result.
             * </pre>
             *
             * <code>.google.protobuf.Struct struct_data = 6;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Struct,
                    com.google.protobuf.Struct.Builder,
                    com.google.protobuf.StructOrBuilder>
                getStructDataFieldBuilder() {
              if (structDataBuilder_ == null) {
                structDataBuilder_ =
                    new com.google.protobuf.SingleFieldBuilderV3<
                        com.google.protobuf.Struct,
                        com.google.protobuf.Struct.Builder,
                        com.google.protobuf.StructOrBuilder>(
                        getStructData(), getParentForChildren(), isClean());
                structData_ = null;
              }
              return structDataBuilder_;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }

            // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult)
          }

          // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult)
          private static final com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              DEFAULT_INSTANCE;

          static {
            DEFAULT_INSTANCE =
                new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .SearchResult();
          }

          public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResult
              getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<SearchResult> PARSER =
              new com.google.protobuf.AbstractParser<SearchResult>() {
                @java.lang.Override
                public SearchResult parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

          public static com.google.protobuf.Parser<SearchResult> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<SearchResult> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
              getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }
        }

        public static final int SEARCH_RESULTS_FIELD_NUMBER = 2;

        @SuppressWarnings("serial")
        private java.util.List<
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult>
            searchResults_;

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult>
            getSearchResultsList() {
          return searchResults_;
        }

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                        .SearchResultOrBuilder>
            getSearchResultsOrBuilderList() {
          return searchResults_;
        }

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        @java.lang.Override
        public int getSearchResultsCount() {
          return searchResults_.size();
        }

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
            getSearchResults(int index) {
          return searchResults_.get(index);
        }

        /**
         *
         *
         * <pre>
         * Search results observed by the search action, it can be snippets info
         * or chunk info, depending on the citation type set by the user.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                .SearchResultOrBuilder
            getSearchResultsOrBuilder(int index) {
          return searchResults_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < searchResults_.size(); i++) {
            output.writeMessage(2, searchResults_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          for (int i = 0; i < searchResults_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(2, searchResults_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation other =
              (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation) obj;

          if (!getSearchResultsList().equals(other.getSearchResultsList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getSearchResultsCount() > 0) {
            hash = (37 * hash) + SEARCH_RESULTS_FIELD_NUMBER;
            hash = (53 * hash) + getSearchResultsList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step.Action.Observation}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation)
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.ObservationOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.class,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (searchResultsBuilder_ == null) {
              searchResults_ = java.util.Collections.emptyList();
            } else {
              searchResults_ = null;
              searchResultsBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1.AnswerProto
                .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_Observation_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation build() {
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation buildPartial() {
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation result =
                new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation result) {
            if (searchResultsBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)) {
                searchResults_ = java.util.Collections.unmodifiableList(searchResults_);
                bitField0_ = (bitField0_ & ~0x00000001);
              }
              result.searchResults_ = searchResults_;
            } else {
              result.searchResults_ = searchResultsBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation result) {
            int from_bitField0_ = bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation other) {
            if (other
                == com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .getDefaultInstance()) return this;
            if (searchResultsBuilder_ == null) {
              if (!other.searchResults_.isEmpty()) {
                if (searchResults_.isEmpty()) {
                  searchResults_ = other.searchResults_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                  ensureSearchResultsIsMutable();
                  searchResults_.addAll(other.searchResults_);
                }
                onChanged();
              }
            } else {
              if (!other.searchResults_.isEmpty()) {
                if (searchResultsBuilder_.isEmpty()) {
                  searchResultsBuilder_.dispose();
                  searchResultsBuilder_ = null;
                  searchResults_ = other.searchResults_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                  searchResultsBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getSearchResultsFieldBuilder()
                          : null;
                } else {
                  searchResultsBuilder_.addAllMessages(other.searchResults_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 18:
                    {
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                              .SearchResult
                          m =
                              input.readMessage(
                                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                                      .SearchResult.parser(),
                                  extensionRegistry);
                      if (searchResultsBuilder_ == null) {
                        ensureSearchResultsIsMutable();
                        searchResults_.add(m);
                      } else {
                        searchResultsBuilder_.addMessage(m);
                      }
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult>
              searchResults_ = java.util.Collections.emptyList();

          private void ensureSearchResultsIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              searchResults_ =
                  new java.util.ArrayList<
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult>(searchResults_);
              bitField0_ |= 0x00000001;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .Builder,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                      .SearchResultOrBuilder>
              searchResultsBuilder_;

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult>
              getSearchResultsList() {
            if (searchResultsBuilder_ == null) {
              return java.util.Collections.unmodifiableList(searchResults_);
            } else {
              return searchResultsBuilder_.getMessageList();
            }
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public int getSearchResultsCount() {
            if (searchResultsBuilder_ == null) {
              return searchResults_.size();
            } else {
              return searchResultsBuilder_.getCount();
            }
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
              getSearchResults(int index) {
            if (searchResultsBuilder_ == null) {
              return searchResults_.get(index);
            } else {
              return searchResultsBuilder_.getMessage(index);
            }
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder setSearchResults(
              int index,
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  value) {
            if (searchResultsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureSearchResultsIsMutable();
              searchResults_.set(index, value);
              onChanged();
            } else {
              searchResultsBuilder_.setMessage(index, value);
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder setSearchResults(
              int index,
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .Builder
                  builderForValue) {
            if (searchResultsBuilder_ == null) {
              ensureSearchResultsIsMutable();
              searchResults_.set(index, builderForValue.build());
              onChanged();
            } else {
              searchResultsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder addSearchResults(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  value) {
            if (searchResultsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureSearchResultsIsMutable();
              searchResults_.add(value);
              onChanged();
            } else {
              searchResultsBuilder_.addMessage(value);
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder addSearchResults(
              int index,
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  value) {
            if (searchResultsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureSearchResultsIsMutable();
              searchResults_.add(index, value);
              onChanged();
            } else {
              searchResultsBuilder_.addMessage(index, value);
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder addSearchResults(
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .Builder
                  builderForValue) {
            if (searchResultsBuilder_ == null) {
              ensureSearchResultsIsMutable();
              searchResults_.add(builderForValue.build());
              onChanged();
            } else {
              searchResultsBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder addSearchResults(
              int index,
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .Builder
                  builderForValue) {
            if (searchResultsBuilder_ == null) {
              ensureSearchResultsIsMutable();
              searchResults_.add(index, builderForValue.build());
              onChanged();
            } else {
              searchResultsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder addAllSearchResults(
              java.lang.Iterable<
                      ? extends
                          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                              .SearchResult>
                  values) {
            if (searchResultsBuilder_ == null) {
              ensureSearchResultsIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, searchResults_);
              onChanged();
            } else {
              searchResultsBuilder_.addAllMessages(values);
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder clearSearchResults() {
            if (searchResultsBuilder_ == null) {
              searchResults_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
            } else {
              searchResultsBuilder_.clear();
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public Builder removeSearchResults(int index) {
            if (searchResultsBuilder_ == null) {
              ensureSearchResultsIsMutable();
              searchResults_.remove(index);
              onChanged();
            } else {
              searchResultsBuilder_.remove(index);
            }
            return this;
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .Builder
              getSearchResultsBuilder(int index) {
            return getSearchResultsFieldBuilder().getBuilder(index);
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                  .SearchResultOrBuilder
              getSearchResultsOrBuilder(int index) {
            if (searchResultsBuilder_ == null) {
              return searchResults_.get(index);
            } else {
              return searchResultsBuilder_.getMessageOrBuilder(index);
            }
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResultOrBuilder>
              getSearchResultsOrBuilderList() {
            if (searchResultsBuilder_ != null) {
              return searchResultsBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(searchResults_);
            }
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .Builder
              addSearchResultsBuilder() {
            return getSearchResultsFieldBuilder()
                .addBuilder(
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .getDefaultInstance());
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                  .Builder
              addSearchResultsBuilder(int index) {
            return getSearchResultsFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                        .getDefaultInstance());
          }

          /**
           *
           *
           * <pre>
           * Search results observed by the search action, it can be snippets info
           * or chunk info, depending on the citation type set by the user.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult search_results = 2;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .Builder>
              getSearchResultsBuilderList() {
            return getSearchResultsFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.SearchResult
                      .Builder,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                      .SearchResultOrBuilder>
              getSearchResultsFieldBuilder() {
            if (searchResultsBuilder_ == null) {
              searchResultsBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult,
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResult.Builder,
                      com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                          .SearchResultOrBuilder>(
                      searchResults_,
                      ((bitField0_ & 0x00000001) != 0),
                      getParentForChildren(),
                      isClean());
              searchResults_ = null;
            }
            return searchResultsBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Step.Action.Observation)
        private static final com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation();
        }

        public static com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<Observation> PARSER =
            new com.google.protobuf.AbstractParser<Observation>() {
              @java.lang.Override
              public Observation parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<Observation> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<Observation> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      private int actionCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object action_;

      public enum ActionCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        SEARCH_ACTION(2),
        ACTION_NOT_SET(0);
        private final int value;

        private ActionCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ActionCase valueOf(int value) {
          return forNumber(value);
        }

        public static ActionCase forNumber(int value) {
          switch (value) {
            case 2:
              return SEARCH_ACTION;
            case 0:
              return ACTION_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ActionCase getActionCase() {
        return ActionCase.forNumber(actionCase_);
      }

      public static final int SEARCH_ACTION_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Search action.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
       * </code>
       *
       * @return Whether the searchAction field is set.
       */
      @java.lang.Override
      public boolean hasSearchAction() {
        return actionCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Search action.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
       * </code>
       *
       * @return The searchAction.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction getSearchAction() {
        if (actionCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            .getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Search action.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchActionOrBuilder
          getSearchActionOrBuilder() {
        if (actionCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            .getDefaultInstance();
      }

      public static final int OBSERVATION_FIELD_NUMBER = 3;
      private com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation_;

      /**
       *
       *
       * <pre>
       * Observation.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
       * </code>
       *
       * @return Whether the observation field is set.
       */
      @java.lang.Override
      public boolean hasObservation() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Observation.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
       * </code>
       *
       * @return The observation.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation getObservation() {
        return observation_ == null
            ? com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                .getDefaultInstance()
            : observation_;
      }

      /**
       *
       *
       * <pre>
       * Observation.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action.ObservationOrBuilder
          getObservationOrBuilder() {
        return observation_ == null
            ? com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                .getDefaultInstance()
            : observation_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (actionCase_ == 2) {
          output.writeMessage(
              2, (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) action_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(3, getObservation());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (actionCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) action_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getObservation());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.Step.Action)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Answer.Step.Action other =
            (com.google.cloud.discoveryengine.v1.Answer.Step.Action) obj;

        if (hasObservation() != other.hasObservation()) return false;
        if (hasObservation()) {
          if (!getObservation().equals(other.getObservation())) return false;
        }
        if (!getActionCase().equals(other.getActionCase())) return false;
        switch (actionCase_) {
          case 2:
            if (!getSearchAction().equals(other.getSearchAction())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasObservation()) {
          hash = (37 * hash) + OBSERVATION_FIELD_NUMBER;
          hash = (53 * hash) + getObservation().hashCode();
        }
        switch (actionCase_) {
          case 2:
            hash = (37 * hash) + SEARCH_ACTION_FIELD_NUMBER;
            hash = (53 * hash) + getSearchAction().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Answer.Step.Action prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Action.
       * </pre>
       *
       * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step.Action}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Step.Action)
          com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.class,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder.class);
        }

        // Construct using com.google.cloud.discoveryengine.v1.Answer.Step.Action.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getObservationFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (searchActionBuilder_ != null) {
            searchActionBuilder_.clear();
          }
          observation_ = null;
          if (observationBuilder_ != null) {
            observationBuilder_.dispose();
            observationBuilder_ = null;
          }
          actionCase_ = 0;
          action_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_Step_Action_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Answer.Step.Action.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action build() {
          com.google.cloud.discoveryengine.v1.Answer.Step.Action result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action buildPartial() {
          com.google.cloud.discoveryengine.v1.Answer.Step.Action result =
              new com.google.cloud.discoveryengine.v1.Answer.Step.Action(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.cloud.discoveryengine.v1.Answer.Step.Action result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.observation_ =
                observationBuilder_ == null ? observation_ : observationBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action result) {
          result.actionCase_ = actionCase_;
          result.action_ = this.action_;
          if (actionCase_ == 2 && searchActionBuilder_ != null) {
            result.action_ = searchActionBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.discoveryengine.v1.Answer.Step.Action) {
            return mergeFrom((com.google.cloud.discoveryengine.v1.Answer.Step.Action) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Answer.Step.Action other) {
          if (other == com.google.cloud.discoveryengine.v1.Answer.Step.Action.getDefaultInstance())
            return this;
          if (other.hasObservation()) {
            mergeObservation(other.getObservation());
          }
          switch (other.getActionCase()) {
            case SEARCH_ACTION:
              {
                mergeSearchAction(other.getSearchAction());
                break;
              }
            case ACTION_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 18:
                  {
                    input.readMessage(
                        getSearchActionFieldBuilder().getBuilder(), extensionRegistry);
                    actionCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getObservationFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int actionCase_ = 0;
        private java.lang.Object action_;

        public ActionCase getActionCase() {
          return ActionCase.forNumber(actionCase_);
        }

        public Builder clearAction() {
          actionCase_ = 0;
          action_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.Builder,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchActionOrBuilder>
            searchActionBuilder_;

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         *
         * @return Whether the searchAction field is set.
         */
        @java.lang.Override
        public boolean hasSearchAction() {
          return actionCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         *
         * @return The searchAction.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
            getSearchAction() {
          if (searchActionBuilder_ == null) {
            if (actionCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) action_;
            }
            return com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
                .getDefaultInstance();
          } else {
            if (actionCase_ == 2) {
              return searchActionBuilder_.getMessage();
            }
            return com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         */
        public Builder setSearchAction(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction value) {
          if (searchActionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            action_ = value;
            onChanged();
          } else {
            searchActionBuilder_.setMessage(value);
          }
          actionCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         */
        public Builder setSearchAction(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.Builder
                builderForValue) {
          if (searchActionBuilder_ == null) {
            action_ = builderForValue.build();
            onChanged();
          } else {
            searchActionBuilder_.setMessage(builderForValue.build());
          }
          actionCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         */
        public Builder mergeSearchAction(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction value) {
          if (searchActionBuilder_ == null) {
            if (actionCase_ == 2
                && action_
                    != com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
                        .getDefaultInstance()) {
              action_ =
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.newBuilder(
                          (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction)
                              action_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              action_ = value;
            }
            onChanged();
          } else {
            if (actionCase_ == 2) {
              searchActionBuilder_.mergeFrom(value);
            } else {
              searchActionBuilder_.setMessage(value);
            }
          }
          actionCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         */
        public Builder clearSearchAction() {
          if (searchActionBuilder_ == null) {
            if (actionCase_ == 2) {
              actionCase_ = 0;
              action_ = null;
              onChanged();
            }
          } else {
            if (actionCase_ == 2) {
              actionCase_ = 0;
              action_ = null;
            }
            searchActionBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.Builder
            getSearchActionBuilder() {
          return getSearchActionFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchActionOrBuilder
            getSearchActionOrBuilder() {
          if ((actionCase_ == 2) && (searchActionBuilder_ != null)) {
            return searchActionBuilder_.getMessageOrBuilder();
          } else {
            if (actionCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) action_;
            }
            return com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
                .getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Search action.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction search_action = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.Builder,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchActionOrBuilder>
            getSearchActionFieldBuilder() {
          if (searchActionBuilder_ == null) {
            if (!(actionCase_ == 2)) {
              action_ =
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction
                      .getDefaultInstance();
            }
            searchActionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction.Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchActionOrBuilder>(
                    (com.google.cloud.discoveryengine.v1.Answer.Step.Action.SearchAction) action_,
                    getParentForChildren(),
                    isClean());
            action_ = null;
          }
          actionCase_ = 2;
          onChanged();
          return searchActionBuilder_;
        }

        private com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.Builder,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.ObservationOrBuilder>
            observationBuilder_;

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         *
         * @return Whether the observation field is set.
         */
        public boolean hasObservation() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         *
         * @return The observation.
         */
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation getObservation() {
          if (observationBuilder_ == null) {
            return observation_ == null
                ? com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .getDefaultInstance()
                : observation_;
          } else {
            return observationBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         */
        public Builder setObservation(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation value) {
          if (observationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            observation_ = value;
          } else {
            observationBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         */
        public Builder setObservation(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.Builder
                builderForValue) {
          if (observationBuilder_ == null) {
            observation_ = builderForValue.build();
          } else {
            observationBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         */
        public Builder mergeObservation(
            com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation value) {
          if (observationBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && observation_ != null
                && observation_
                    != com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                        .getDefaultInstance()) {
              getObservationBuilder().mergeFrom(value);
            } else {
              observation_ = value;
            }
          } else {
            observationBuilder_.mergeFrom(value);
          }
          if (observation_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         */
        public Builder clearObservation() {
          bitField0_ = (bitField0_ & ~0x00000002);
          observation_ = null;
          if (observationBuilder_ != null) {
            observationBuilder_.dispose();
            observationBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.Builder
            getObservationBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getObservationFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Answer.Step.Action.ObservationOrBuilder
            getObservationOrBuilder() {
          if (observationBuilder_ != null) {
            return observationBuilder_.getMessageOrBuilder();
          } else {
            return observation_ == null
                ? com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation
                    .getDefaultInstance()
                : observation_;
          }
        }

        /**
         *
         *
         * <pre>
         * Observation.
         * </pre>
         *
         * <code>.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation observation = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.Builder,
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.ObservationOrBuilder>
            getObservationFieldBuilder() {
          if (observationBuilder_ == null) {
            observationBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.Observation.Builder,
                    com.google.cloud.discoveryengine.v1.Answer.Step.Action.ObservationOrBuilder>(
                    getObservation(), getParentForChildren(), isClean());
            observation_ = null;
          }
          return observationBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Step.Action)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Step.Action)
      private static final com.google.cloud.discoveryengine.v1.Answer.Step.Action DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.Step.Action();
      }

      public static com.google.cloud.discoveryengine.v1.Answer.Step.Action getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Action> PARSER =
          new com.google.protobuf.AbstractParser<Action>() {
            @java.lang.Override
            public Action parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Action> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Action> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * The state of the step.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * The state of the step.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Step.State getState() {
      com.google.cloud.discoveryengine.v1.Answer.Step.State result =
          com.google.cloud.discoveryengine.v1.Answer.Step.State.forNumber(state_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.Answer.Step.State.UNRECOGNIZED
          : result;
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * The description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    @java.lang.Override
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The description of the step.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int THOUGHT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object thought_ = "";

    /**
     *
     *
     * <pre>
     * The thought of the step.
     * </pre>
     *
     * <code>string thought = 3;</code>
     *
     * @return The thought.
     */
    @java.lang.Override
    public java.lang.String getThought() {
      java.lang.Object ref = thought_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        thought_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The thought of the step.
     * </pre>
     *
     * <code>string thought = 3;</code>
     *
     * @return The bytes for thought.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getThoughtBytes() {
      java.lang.Object ref = thought_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        thought_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ACTIONS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step.Action> actions_;

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step.Action> getActionsList() {
      return actions_;
    }

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder>
        getActionsOrBuilderList() {
      return actions_;
    }

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    @java.lang.Override
    public int getActionsCount() {
      return actions_.size();
    }

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Step.Action getActions(int index) {
      return actions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Actions.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder getActionsOrBuilder(
        int index) {
      return actions_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_
          != com.google.cloud.discoveryengine.v1.Answer.Step.State.STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(thought_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, thought_);
      }
      for (int i = 0; i < actions_.size(); i++) {
        output.writeMessage(4, actions_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_
          != com.google.cloud.discoveryengine.v1.Answer.Step.State.STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(thought_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, thought_);
      }
      for (int i = 0; i < actions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, actions_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.Step)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Answer.Step other =
          (com.google.cloud.discoveryengine.v1.Answer.Step) obj;

      if (state_ != other.state_) return false;
      if (!getDescription().equals(other.getDescription())) return false;
      if (!getThought().equals(other.getThought())) return false;
      if (!getActionsList().equals(other.getActionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + THOUGHT_FIELD_NUMBER;
      hash = (53 * hash) + getThought().hashCode();
      if (getActionsCount() > 0) {
        hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getActionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.discoveryengine.v1.Answer.Step prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Step information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.Step}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.Step)
        com.google.cloud.discoveryengine.v1.Answer.StepOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Step_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Step_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.Step.class,
                com.google.cloud.discoveryengine.v1.Answer.Step.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Answer.Step.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        description_ = "";
        thought_ = "";
        if (actionsBuilder_ == null) {
          actions_ = java.util.Collections.emptyList();
        } else {
          actions_ = null;
          actionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_Step_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Answer.Step.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step build() {
        com.google.cloud.discoveryengine.v1.Answer.Step result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step buildPartial() {
        com.google.cloud.discoveryengine.v1.Answer.Step result =
            new com.google.cloud.discoveryengine.v1.Answer.Step(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.Answer.Step result) {
        if (actionsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            actions_ = java.util.Collections.unmodifiableList(actions_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.actions_ = actions_;
        } else {
          result.actions_ = actionsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Answer.Step result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.description_ = description_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.thought_ = thought_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Answer.Step) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Answer.Step) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Answer.Step other) {
        if (other == com.google.cloud.discoveryengine.v1.Answer.Step.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getThought().isEmpty()) {
          thought_ = other.thought_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (actionsBuilder_ == null) {
          if (!other.actions_.isEmpty()) {
            if (actions_.isEmpty()) {
              actions_ = other.actions_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureActionsIsMutable();
              actions_.addAll(other.actions_);
            }
            onChanged();
          }
        } else {
          if (!other.actions_.isEmpty()) {
            if (actionsBuilder_.isEmpty()) {
              actionsBuilder_.dispose();
              actionsBuilder_ = null;
              actions_ = other.actions_;
              bitField0_ = (bitField0_ & ~0x00000008);
              actionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getActionsFieldBuilder()
                      : null;
            } else {
              actionsBuilder_.addAllMessages(other.actions_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  description_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  thought_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.Answer.Step.Action.parser(),
                          extensionRegistry);
                  if (actionsBuilder_ == null) {
                    ensureActionsIsMutable();
                    actions_.add(m);
                  } else {
                    actionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;

      /**
       *
       *
       * <pre>
       * The state of the step.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }

      /**
       *
       *
       * <pre>
       * The state of the step.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The state of the step.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.Step.State getState() {
        com.google.cloud.discoveryengine.v1.Answer.Step.State result =
            com.google.cloud.discoveryengine.v1.Answer.Step.State.forNumber(state_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.Answer.Step.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The state of the step.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.discoveryengine.v1.Answer.Step.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The state of the step.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.Answer.Step.State state = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";

      /**
       *
       *
       * <pre>
       * The description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The description.
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return The bytes for description.
       */
      public com.google.protobuf.ByteString getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The description to set.
       * @return This builder for chaining.
       */
      public Builder setDescription(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDescription() {
        description_ = getDefaultInstance().getDescription();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The description of the step.
       * </pre>
       *
       * <code>string description = 2;</code>
       *
       * @param value The bytes for description to set.
       * @return This builder for chaining.
       */
      public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        description_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object thought_ = "";

      /**
       *
       *
       * <pre>
       * The thought of the step.
       * </pre>
       *
       * <code>string thought = 3;</code>
       *
       * @return The thought.
       */
      public java.lang.String getThought() {
        java.lang.Object ref = thought_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          thought_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The thought of the step.
       * </pre>
       *
       * <code>string thought = 3;</code>
       *
       * @return The bytes for thought.
       */
      public com.google.protobuf.ByteString getThoughtBytes() {
        java.lang.Object ref = thought_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          thought_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The thought of the step.
       * </pre>
       *
       * <code>string thought = 3;</code>
       *
       * @param value The thought to set.
       * @return This builder for chaining.
       */
      public Builder setThought(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        thought_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The thought of the step.
       * </pre>
       *
       * <code>string thought = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearThought() {
        thought_ = getDefaultInstance().getThought();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The thought of the step.
       * </pre>
       *
       * <code>string thought = 3;</code>
       *
       * @param value The bytes for thought to set.
       * @return This builder for chaining.
       */
      public Builder setThoughtBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        thought_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step.Action> actions_ =
          java.util.Collections.emptyList();

      private void ensureActionsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          actions_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Answer.Step.Action>(
                  actions_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Step.Action,
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder>
          actionsBuilder_;

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step.Action>
          getActionsList() {
        if (actionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(actions_);
        } else {
          return actionsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public int getActionsCount() {
        if (actionsBuilder_ == null) {
          return actions_.size();
        } else {
          return actionsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action getActions(int index) {
        if (actionsBuilder_ == null) {
          return actions_.get(index);
        } else {
          return actionsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder setActions(
          int index, com.google.cloud.discoveryengine.v1.Answer.Step.Action value) {
        if (actionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionsIsMutable();
          actions_.set(index, value);
          onChanged();
        } else {
          actionsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder setActions(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder builderForValue) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.set(index, builderForValue.build());
          onChanged();
        } else {
          actionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder addActions(com.google.cloud.discoveryengine.v1.Answer.Step.Action value) {
        if (actionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionsIsMutable();
          actions_.add(value);
          onChanged();
        } else {
          actionsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder addActions(
          int index, com.google.cloud.discoveryengine.v1.Answer.Step.Action value) {
        if (actionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionsIsMutable();
          actions_.add(index, value);
          onChanged();
        } else {
          actionsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder addActions(
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder builderForValue) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.add(builderForValue.build());
          onChanged();
        } else {
          actionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder addActions(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder builderForValue) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.add(index, builderForValue.build());
          onChanged();
        } else {
          actionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder addAllActions(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Answer.Step.Action>
              values) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
          onChanged();
        } else {
          actionsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder clearActions() {
        if (actionsBuilder_ == null) {
          actions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          actionsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public Builder removeActions(int index) {
        if (actionsBuilder_ == null) {
          ensureActionsIsMutable();
          actions_.remove(index);
          onChanged();
        } else {
          actionsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder getActionsBuilder(
          int index) {
        return getActionsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder getActionsOrBuilder(
          int index) {
        if (actionsBuilder_ == null) {
          return actions_.get(index);
        } else {
          return actionsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder>
          getActionsOrBuilderList() {
        if (actionsBuilder_ != null) {
          return actionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(actions_);
        }
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder addActionsBuilder() {
        return getActionsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.Answer.Step.Action.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder addActionsBuilder(
          int index) {
        return getActionsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.discoveryengine.v1.Answer.Step.Action.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Actions.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step.Action actions = 4;</code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder>
          getActionsBuilderList() {
        return getActionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.Step.Action,
              com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder,
              com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder>
          getActionsFieldBuilder() {
        if (actionsBuilder_ == null) {
          actionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action,
                  com.google.cloud.discoveryengine.v1.Answer.Step.Action.Builder,
                  com.google.cloud.discoveryengine.v1.Answer.Step.ActionOrBuilder>(
                  actions_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
          actions_ = null;
        }
        return actionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.Step)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.Step)
    private static final com.google.cloud.discoveryengine.v1.Answer.Step DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.Step();
    }

    public static com.google.cloud.discoveryengine.v1.Answer.Step getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Step> PARSER =
        new com.google.protobuf.AbstractParser<Step>() {
          @java.lang.Override
          public Step parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Step> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Step> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.Step getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryUnderstandingInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo>
        getQueryClassificationInfoList();

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
        getQueryClassificationInfo(int index);

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    int getQueryClassificationInfoCount();

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfoOrBuilder>
        getQueryClassificationInfoOrBuilderList();

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
            .QueryClassificationInfoOrBuilder
        getQueryClassificationInfoOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * Query understanding information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo}
   */
  public static final class QueryUnderstandingInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo)
      QueryUnderstandingInfoOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use QueryUnderstandingInfo.newBuilder() to construct.
    private QueryUnderstandingInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryUnderstandingInfo() {
      queryClassificationInfo_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryUnderstandingInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.class,
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.Builder.class);
    }

    public interface QueryClassificationInfoOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Query classification type.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      int getTypeValue();

      /**
       *
       *
       * <pre>
       * Query classification type.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
       * </code>
       *
       * @return The type.
       */
      com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type
          getType();

      /**
       *
       *
       * <pre>
       * Classification output.
       * </pre>
       *
       * <code>bool positive = 2;</code>
       *
       * @return The positive.
       */
      boolean getPositive();
    }

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo}
     */
    public static final class QueryClassificationInfo extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo)
        QueryClassificationInfoOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use QueryClassificationInfo.newBuilder() to construct.
      private QueryClassificationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private QueryClassificationInfo() {
        type_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new QueryClassificationInfo();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_QueryClassificationInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_QueryClassificationInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo.class,
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Query classification types.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type}
       */
      public enum Type implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified query classification type.
         * </pre>
         *
         * <code>TYPE_UNSPECIFIED = 0;</code>
         */
        TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Adversarial query classification type.
         * </pre>
         *
         * <code>ADVERSARIAL_QUERY = 1;</code>
         */
        ADVERSARIAL_QUERY(1),
        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for chit chat.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY = 2;</code>
         */
        NON_ANSWER_SEEKING_QUERY(2),
        /**
         *
         *
         * <pre>
         * Jail-breaking query classification type.
         * </pre>
         *
         * <code>JAIL_BREAKING_QUERY = 3;</code>
         */
        JAIL_BREAKING_QUERY(3),
        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for no clear intent.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY_V2 = 4;</code>
         */
        NON_ANSWER_SEEKING_QUERY_V2(4),
        /**
         *
         *
         * <pre>
         * User defined query classification type.
         * </pre>
         *
         * <code>USER_DEFINED_CLASSIFICATION_QUERY = 5;</code>
         */
        USER_DEFINED_CLASSIFICATION_QUERY(5),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified query classification type.
         * </pre>
         *
         * <code>TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int TYPE_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * Adversarial query classification type.
         * </pre>
         *
         * <code>ADVERSARIAL_QUERY = 1;</code>
         */
        public static final int ADVERSARIAL_QUERY_VALUE = 1;

        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for chit chat.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY = 2;</code>
         */
        public static final int NON_ANSWER_SEEKING_QUERY_VALUE = 2;

        /**
         *
         *
         * <pre>
         * Jail-breaking query classification type.
         * </pre>
         *
         * <code>JAIL_BREAKING_QUERY = 3;</code>
         */
        public static final int JAIL_BREAKING_QUERY_VALUE = 3;

        /**
         *
         *
         * <pre>
         * Non-answer-seeking query classification type, for no clear intent.
         * </pre>
         *
         * <code>NON_ANSWER_SEEKING_QUERY_V2 = 4;</code>
         */
        public static final int NON_ANSWER_SEEKING_QUERY_V2_VALUE = 4;

        /**
         *
         *
         * <pre>
         * User defined query classification type.
         * </pre>
         *
         * <code>USER_DEFINED_CLASSIFICATION_QUERY = 5;</code>
         */
        public static final int USER_DEFINED_CLASSIFICATION_QUERY_VALUE = 5;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Type valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Type forNumber(int value) {
          switch (value) {
            case 0:
              return TYPE_UNSPECIFIED;
            case 1:
              return ADVERSARIAL_QUERY;
            case 2:
              return NON_ANSWER_SEEKING_QUERY;
            case 3:
              return JAIL_BREAKING_QUERY;
            case 4:
              return NON_ANSWER_SEEKING_QUERY_V2;
            case 5:
              return USER_DEFINED_CLASSIFICATION_QUERY;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Type[] VALUES = values();

        public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Type(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type)
      }

      public static final int TYPE_FIELD_NUMBER = 1;
      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * Query classification type.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * Query classification type.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo.Type
          getType() {
        com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
                .Type
            result =
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo.Type.UNRECOGNIZED
            : result;
      }

      public static final int POSITIVE_FIELD_NUMBER = 2;
      private boolean positive_ = false;

      /**
       *
       *
       * <pre>
       * Classification output.
       * </pre>
       *
       * <code>bool positive = 2;</code>
       *
       * @return The positive.
       */
      @java.lang.Override
      public boolean getPositive() {
        return positive_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (type_
            != com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo.Type.TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, type_);
        }
        if (positive_ != false) {
          output.writeBool(2, positive_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (type_
            != com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo.Type.TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
        }
        if (positive_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, positive_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
            other =
                (com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                        .QueryClassificationInfo)
                    obj;

        if (type_ != other.type_) return false;
        if (getPositive() != other.getPositive()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
        hash = (37 * hash) + POSITIVE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPositive());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo)
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfoOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_QueryClassificationInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_QueryClassificationInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfo.class,
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfo.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          type_ = 0;
          positive_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.AnswerProto
              .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_QueryClassificationInfo_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo
            build() {
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
              result =
                  new com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfo(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.type_ = type_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.positive_ = positive_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                        .QueryClassificationInfo)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo.getDefaultInstance()) return this;
          if (other.type_ != 0) {
            setTypeValue(other.getTypeValue());
          }
          if (other.getPositive() != false) {
            setPositive(other.getPositive());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    type_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    positive_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int type_ = 0;

        /**
         *
         *
         * <pre>
         * Query classification type.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override
        public int getTypeValue() {
          return type_;
        }

        /**
         *
         *
         * <pre>
         * Query classification type.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for type to set.
         * @return This builder for chaining.
         */
        public Builder setTypeValue(int value) {
          type_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Query classification type.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo.Type
            getType() {
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
                  .Type
              result =
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfo.Type.forNumber(type_);
          return result == null
              ? com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo.Type.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * Query classification type.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
         * </code>
         *
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(
            com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo.Type
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          type_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Query classification type.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type type = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          type_ = 0;
          onChanged();
          return this;
        }

        private boolean positive_;

        /**
         *
         *
         * <pre>
         * Classification output.
         * </pre>
         *
         * <code>bool positive = 2;</code>
         *
         * @return The positive.
         */
        @java.lang.Override
        public boolean getPositive() {
          return positive_;
        }

        /**
         *
         *
         * <pre>
         * Classification output.
         * </pre>
         *
         * <code>bool positive = 2;</code>
         *
         * @param value The positive to set.
         * @return This builder for chaining.
         */
        public Builder setPositive(boolean value) {

          positive_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Classification output.
         * </pre>
         *
         * <code>bool positive = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPositive() {
          bitField0_ = (bitField0_ & ~0x00000002);
          positive_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo)
      private static final com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo();
      }

      public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<QueryClassificationInfo> PARSER =
          new com.google.protobuf.AbstractParser<QueryClassificationInfo>() {
            @java.lang.Override
            public QueryClassificationInfo parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<QueryClassificationInfo> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<QueryClassificationInfo> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int QUERY_CLASSIFICATION_INFO_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo>
        queryClassificationInfo_;

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .QueryClassificationInfo>
        getQueryClassificationInfoList() {
      return queryClassificationInfo_;
    }

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfoOrBuilder>
        getQueryClassificationInfoOrBuilderList() {
      return queryClassificationInfo_;
    }

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    @java.lang.Override
    public int getQueryClassificationInfoCount() {
      return queryClassificationInfo_.size();
    }

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
        getQueryClassificationInfo(int index) {
      return queryClassificationInfo_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Query classification information.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
            .QueryClassificationInfoOrBuilder
        getQueryClassificationInfoOrBuilder(int index) {
      return queryClassificationInfo_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < queryClassificationInfo_.size(); i++) {
        output.writeMessage(1, queryClassificationInfo_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < queryClassificationInfo_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, queryClassificationInfo_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo other =
          (com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo) obj;

      if (!getQueryClassificationInfoList().equals(other.getQueryClassificationInfoList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getQueryClassificationInfoCount() > 0) {
        hash = (37 * hash) + QUERY_CLASSIFICATION_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getQueryClassificationInfoList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Query understanding information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo)
        com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.class,
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (queryClassificationInfoBuilder_ == null) {
          queryClassificationInfo_ = java.util.Collections.emptyList();
        } else {
          queryClassificationInfo_ = null;
          queryClassificationInfoBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.AnswerProto
            .internal_static_google_cloud_discoveryengine_v1_Answer_QueryUnderstandingInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo build() {
        com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo buildPartial() {
        com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo result =
            new com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo result) {
        if (queryClassificationInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            queryClassificationInfo_ =
                java.util.Collections.unmodifiableList(queryClassificationInfo_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.queryClassificationInfo_ = queryClassificationInfo_;
        } else {
          result.queryClassificationInfo_ = queryClassificationInfoBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                .getDefaultInstance()) return this;
        if (queryClassificationInfoBuilder_ == null) {
          if (!other.queryClassificationInfo_.isEmpty()) {
            if (queryClassificationInfo_.isEmpty()) {
              queryClassificationInfo_ = other.queryClassificationInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureQueryClassificationInfoIsMutable();
              queryClassificationInfo_.addAll(other.queryClassificationInfo_);
            }
            onChanged();
          }
        } else {
          if (!other.queryClassificationInfo_.isEmpty()) {
            if (queryClassificationInfoBuilder_.isEmpty()) {
              queryClassificationInfoBuilder_.dispose();
              queryClassificationInfoBuilder_ = null;
              queryClassificationInfo_ = other.queryClassificationInfo_;
              bitField0_ = (bitField0_ & ~0x00000001);
              queryClassificationInfoBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getQueryClassificationInfoFieldBuilder()
                      : null;
            } else {
              queryClassificationInfoBuilder_.addAllMessages(other.queryClassificationInfo_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                          .QueryClassificationInfo
                      m =
                          input.readMessage(
                              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                                  .QueryClassificationInfo.parser(),
                              extensionRegistry);
                  if (queryClassificationInfoBuilder_ == null) {
                    ensureQueryClassificationInfoIsMutable();
                    queryClassificationInfo_.add(m);
                  } else {
                    queryClassificationInfoBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo>
          queryClassificationInfo_ = java.util.Collections.emptyList();

      private void ensureQueryClassificationInfoIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          queryClassificationInfo_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfo>(queryClassificationInfo_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo,
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfoOrBuilder>
          queryClassificationInfoBuilder_;

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo>
          getQueryClassificationInfoList() {
        if (queryClassificationInfoBuilder_ == null) {
          return java.util.Collections.unmodifiableList(queryClassificationInfo_);
        } else {
          return queryClassificationInfoBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public int getQueryClassificationInfoCount() {
        if (queryClassificationInfoBuilder_ == null) {
          return queryClassificationInfo_.size();
        } else {
          return queryClassificationInfoBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo
          getQueryClassificationInfo(int index) {
        if (queryClassificationInfoBuilder_ == null) {
          return queryClassificationInfo_.get(index);
        } else {
          return queryClassificationInfoBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder setQueryClassificationInfo(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
              value) {
        if (queryClassificationInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQueryClassificationInfoIsMutable();
          queryClassificationInfo_.set(index, value);
          onChanged();
        } else {
          queryClassificationInfoBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder setQueryClassificationInfo(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
                  .Builder
              builderForValue) {
        if (queryClassificationInfoBuilder_ == null) {
          ensureQueryClassificationInfoIsMutable();
          queryClassificationInfo_.set(index, builderForValue.build());
          onChanged();
        } else {
          queryClassificationInfoBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder addQueryClassificationInfo(
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
              value) {
        if (queryClassificationInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQueryClassificationInfoIsMutable();
          queryClassificationInfo_.add(value);
          onChanged();
        } else {
          queryClassificationInfoBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder addQueryClassificationInfo(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
              value) {
        if (queryClassificationInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQueryClassificationInfoIsMutable();
          queryClassificationInfo_.add(index, value);
          onChanged();
        } else {
          queryClassificationInfoBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder addQueryClassificationInfo(
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
                  .Builder
              builderForValue) {
        if (queryClassificationInfoBuilder_ == null) {
          ensureQueryClassificationInfoIsMutable();
          queryClassificationInfo_.add(builderForValue.build());
          onChanged();
        } else {
          queryClassificationInfoBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder addQueryClassificationInfo(
          int index,
          com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo
                  .Builder
              builderForValue) {
        if (queryClassificationInfoBuilder_ == null) {
          ensureQueryClassificationInfoIsMutable();
          queryClassificationInfo_.add(index, builderForValue.build());
          onChanged();
        } else {
          queryClassificationInfoBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder addAllQueryClassificationInfo(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                          .QueryClassificationInfo>
              values) {
        if (queryClassificationInfoBuilder_ == null) {
          ensureQueryClassificationInfoIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queryClassificationInfo_);
          onChanged();
        } else {
          queryClassificationInfoBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder clearQueryClassificationInfo() {
        if (queryClassificationInfoBuilder_ == null) {
          queryClassificationInfo_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          queryClassificationInfoBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public Builder removeQueryClassificationInfo(int index) {
        if (queryClassificationInfoBuilder_ == null) {
          ensureQueryClassificationInfoIsMutable();
          queryClassificationInfo_.remove(index);
          onChanged();
        } else {
          queryClassificationInfoBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo.Builder
          getQueryClassificationInfoBuilder(int index) {
        return getQueryClassificationInfoFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfoOrBuilder
          getQueryClassificationInfoOrBuilder(int index) {
        if (queryClassificationInfoBuilder_ == null) {
          return queryClassificationInfo_.get(index);
        } else {
          return queryClassificationInfoBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfoOrBuilder>
          getQueryClassificationInfoOrBuilderList() {
        if (queryClassificationInfoBuilder_ != null) {
          return queryClassificationInfoBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(queryClassificationInfo_);
        }
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo.Builder
          addQueryClassificationInfoBuilder() {
        return getQueryClassificationInfoFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
              .QueryClassificationInfo.Builder
          addQueryClassificationInfoBuilder(int index) {
        return getQueryClassificationInfoFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                    .QueryClassificationInfo.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Query classification information.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.QueryClassificationInfo query_classification_info = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo.Builder>
          getQueryClassificationInfoBuilderList() {
        return getQueryClassificationInfoFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo,
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfo.Builder,
              com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                  .QueryClassificationInfoOrBuilder>
          getQueryClassificationInfoFieldBuilder() {
        if (queryClassificationInfoBuilder_ == null) {
          queryClassificationInfoBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfo,
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfo.Builder,
                  com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
                      .QueryClassificationInfoOrBuilder>(
                  queryClassificationInfo_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          queryClassificationInfo_ = null;
        }
        return queryClassificationInfoBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo)
    private static final com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo();
    }

    public static com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryUnderstandingInfo> PARSER =
        new com.google.protobuf.AbstractParser<QueryUnderstandingInfo>() {
          @java.lang.Override
          public QueryUnderstandingInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QueryUnderstandingInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryUnderstandingInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;&#47;answers/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;&#47;answers/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * The state of the answer generation.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Answer.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * The state of the answer generation.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Answer.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.State getState() {
    com.google.cloud.discoveryengine.v1.Answer.State result =
        com.google.cloud.discoveryengine.v1.Answer.State.forNumber(state_);
    return result == null ? com.google.cloud.discoveryengine.v1.Answer.State.UNRECOGNIZED : result;
  }

  public static final int ANSWER_TEXT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answerText_ = "";

  /**
   *
   *
   * <pre>
   * The textual answer.
   * </pre>
   *
   * <code>string answer_text = 3;</code>
   *
   * @return The answerText.
   */
  @java.lang.Override
  public java.lang.String getAnswerText() {
    java.lang.Object ref = answerText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answerText_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The textual answer.
   * </pre>
   *
   * <code>string answer_text = 3;</code>
   *
   * @return The bytes for answerText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerTextBytes() {
    java.lang.Object ref = answerText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answerText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GROUNDING_SCORE_FIELD_NUMBER = 12;
  private double groundingScore_ = 0D;

  /**
   *
   *
   * <pre>
   * A score in the range of [0, 1] describing how grounded the answer is by the
   * reference chunks.
   * </pre>
   *
   * <code>optional double grounding_score = 12;</code>
   *
   * @return Whether the groundingScore field is set.
   */
  @java.lang.Override
  public boolean hasGroundingScore() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * A score in the range of [0, 1] describing how grounded the answer is by the
   * reference chunks.
   * </pre>
   *
   * <code>optional double grounding_score = 12;</code>
   *
   * @return The groundingScore.
   */
  @java.lang.Override
  public double getGroundingScore() {
    return groundingScore_;
  }

  public static final int CITATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Citation> citations_;

  /**
   *
   *
   * <pre>
   * Citations.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Citation> getCitationsList() {
    return citations_;
  }

  /**
   *
   *
   * <pre>
   * Citations.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder>
      getCitationsOrBuilderList() {
    return citations_;
  }

  /**
   *
   *
   * <pre>
   * Citations.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
   */
  @java.lang.Override
  public int getCitationsCount() {
    return citations_.size();
  }

  /**
   *
   *
   * <pre>
   * Citations.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.Citation getCitations(int index) {
    return citations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Citations.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder getCitationsOrBuilder(
      int index) {
    return citations_.get(index);
  }

  public static final int GROUNDING_SUPPORTS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.Answer.GroundingSupport>
      groundingSupports_;

  /**
   *
   *
   * <pre>
   * Optional. Grounding supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.Answer.GroundingSupport>
      getGroundingSupportsList() {
    return groundingSupports_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Grounding supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder>
      getGroundingSupportsOrBuilderList() {
    return groundingSupports_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Grounding supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getGroundingSupportsCount() {
    return groundingSupports_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Grounding supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport getGroundingSupports(
      int index) {
    return groundingSupports_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Grounding supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder
      getGroundingSupportsOrBuilder(int index) {
    return groundingSupports_.get(index);
  }

  public static final int REFERENCES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Reference> references_;

  /**
   *
   *
   * <pre>
   * References.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Reference> getReferencesList() {
    return references_;
  }

  /**
   *
   *
   * <pre>
   * References.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder>
      getReferencesOrBuilderList() {
    return references_;
  }

  /**
   *
   *
   * <pre>
   * References.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
   */
  @java.lang.Override
  public int getReferencesCount() {
    return references_.size();
  }

  /**
   *
   *
   * <pre>
   * References.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.Reference getReferences(int index) {
    return references_.get(index);
  }

  /**
   *
   *
   * <pre>
   * References.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder getReferencesOrBuilder(
      int index) {
    return references_.get(index);
  }

  public static final int RELATED_QUESTIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList relatedQuestions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Suggested related questions.
   * </pre>
   *
   * <code>repeated string related_questions = 6;</code>
   *
   * @return A list containing the relatedQuestions.
   */
  public com.google.protobuf.ProtocolStringList getRelatedQuestionsList() {
    return relatedQuestions_;
  }

  /**
   *
   *
   * <pre>
   * Suggested related questions.
   * </pre>
   *
   * <code>repeated string related_questions = 6;</code>
   *
   * @return The count of relatedQuestions.
   */
  public int getRelatedQuestionsCount() {
    return relatedQuestions_.size();
  }

  /**
   *
   *
   * <pre>
   * Suggested related questions.
   * </pre>
   *
   * <code>repeated string related_questions = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The relatedQuestions at the given index.
   */
  public java.lang.String getRelatedQuestions(int index) {
    return relatedQuestions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Suggested related questions.
   * </pre>
   *
   * <code>repeated string related_questions = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the relatedQuestions at the given index.
   */
  public com.google.protobuf.ByteString getRelatedQuestionsBytes(int index) {
    return relatedQuestions_.getByteString(index);
  }

  public static final int STEPS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step> steps_;

  /**
   *
   *
   * <pre>
   * Answer generation steps.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step steps = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step> getStepsList() {
    return steps_;
  }

  /**
   *
   *
   * <pre>
   * Answer generation steps.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step steps = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.StepOrBuilder>
      getStepsOrBuilderList() {
    return steps_;
  }

  /**
   *
   *
   * <pre>
   * Answer generation steps.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step steps = 7;</code>
   */
  @java.lang.Override
  public int getStepsCount() {
    return steps_.size();
  }

  /**
   *
   *
   * <pre>
   * Answer generation steps.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step steps = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.Step getSteps(int index) {
    return steps_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Answer generation steps.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Answer.Step steps = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.StepOrBuilder getStepsOrBuilder(int index) {
    return steps_.get(index);
  }

  public static final int QUERY_UNDERSTANDING_INFO_FIELD_NUMBER = 10;
  private com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo queryUnderstandingInfo_;

  /**
   *
   *
   * <pre>
   * Query understanding information.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo query_understanding_info = 10;
   * </code>
   *
   * @return Whether the queryUnderstandingInfo field is set.
   */
  @java.lang.Override
  public boolean hasQueryUnderstandingInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Query understanding information.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo query_understanding_info = 10;
   * </code>
   *
   * @return The queryUnderstandingInfo.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo
      getQueryUnderstandingInfo() {
    return queryUnderstandingInfo_ == null
        ? com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.getDefaultInstance()
        : queryUnderstandingInfo_;
  }

  /**
   *
   *
   * <pre>
   * Query understanding information.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo query_understanding_info = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfoOrBuilder
      getQueryUnderstandingInfoOrBuilder() {
    return queryUnderstandingInfo_ == null
        ? com.google.cloud.discoveryengine.v1.Answer.QueryUnderstandingInfo.getDefaultInstance()
        : queryUnderstandingInfo_;
  }

  public static final int ANSWER_SKIPPED_REASONS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> answerSkippedReasons_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason>
      answerSkippedReasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason>() {
            public com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason convert(
                java.lang.Integer from) {
              com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason result =
                  com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason.forNumber(from);
              return result == null
                  ? com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Additional answer-skipped reasons. This provides the reason for ignored
   * cases. If nothing is skipped, this field is not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason answer_skipped_reasons = 11;
   * </code>
   *
   * @return A list containing the answerSkippedReasons.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason>
      getAnswerSkippedReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason>(
        answerSkippedReasons_, answerSkippedReasons_converter_);
  }

  /**
   *
   *
   * <pre>
   * Additional answer-skipped reasons. This provides the reason for ignored
   * cases. If nothing is skipped, this field is not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason answer_skipped_reasons = 11;
   * </code>
   *
   * @return The count of answerSkippedReasons.
   */
  @java.lang.Override
  public int getAnswerSkippedReasonsCount() {
    return answerSkippedReasons_.size();
  }

  /**
   *
   *
   * <pre>
   * Additional answer-skipped reasons. This provides the reason for ignored
   * cases. If nothing is skipped, this field is not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason answer_skipped_reasons = 11;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The answerSkippedReasons at the given index.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason getAnswerSkippedReasons(
      int index) {
    return answerSkippedReasons_converter_.convert(answerSkippedReasons_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Additional answer-skipped reasons. This provides the reason for ignored
   * cases. If nothing is skipped, this field is not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason answer_skipped_reasons = 11;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for answerSkippedReasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAnswerSkippedReasonsValueList() {
    return answerSkippedReasons_;
  }

  /**
   *
   *
   * <pre>
   * Additional answer-skipped reasons. This provides the reason for ignored
   * cases. If nothing is skipped, this field is not set.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Answer.AnswerSkippedReason answer_skipped_reasons = 11;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of answerSkippedReasons at the given index.
   */
  @java.lang.Override
  public int getAnswerSkippedReasonsValue(int index) {
    return answerSkippedReasons_.get(index);
  }

  private int answerSkippedReasonsMemoizedSerializedSize;

  public static final int CREATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Answer creation timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Answer creation timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Answer creation timestamp.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int COMPLETE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp completeTime_;

  /**
   *
   *
   * <pre>
   * Output only. Answer completed timestamp.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the completeTime field is set.
   */
  @java.lang.Override
  public boolean hasCompleteTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Answer completed timestamp.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The completeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCompleteTime() {
    return completeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completeTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Answer completed timestamp.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp complete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCompleteTimeOrBuilder() {
    return completeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : completeTime_;
  }

  public static final int SAFETY_RATINGS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.SafetyRating> safetyRatings_;

  /**
   *
   *
   * <pre>
   * Optional. Safety ratings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SafetyRating safety_ratings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.SafetyRating> getSafetyRatingsList() {
    return safetyRatings_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Safety ratings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SafetyRating safety_ratings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.SafetyRatingOrBuilder>
      getSafetyRatingsOrBuilderList() {
    return safetyRatings_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Safety ratings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SafetyRating safety_ratings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSafetyRatingsCount() {
    return safetyRatings_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Safety ratings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SafetyRating safety_ratings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SafetyRating getSafetyRatings(int index) {
    return safetyRatings_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Safety ratings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SafetyRating safety_ratings = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SafetyRatingOrBuilder getSafetyRatingsOrBuilder(
      int index) {
    return safetyRatings_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_ != com.google.cloud.discoveryengine.v1.Answer.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, answerText_);
    }
    for (int i = 0; i < citations_.size(); i++) {
      output.writeMessage(4, citations_.get(i));
    }
    for (int i = 0; i < references_.size(); i++) {
      output.writeMessage(5, references_.get(i));
    }
    for (int i = 0; i < relatedQuestions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, relatedQuestions_.getRaw(i));
    }
    for (int i = 0; i < steps_.size(); i++) {
      output.writeMessage(7, steps_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getCompleteTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getQueryUnderstandingInfo());
    }
    if (getAnswerSkippedReasonsList().size() > 0) {
      output.writeUInt32NoTag(90);
      output.writeUInt32NoTag(answerSkippedReasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < answerSkippedReasons_.size(); i++) {
      output.writeEnumNoTag(answerSkippedReasons_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeDouble(12, groundingScore_);
    }
    for (int i = 0; i < groundingSupports_.size(); i++) {
      output.writeMessage(13, groundingSupports_.get(i));
    }
    for (int i = 0; i < safetyRatings_.size(); i++) {
      output.writeMessage(14, safetyRatings_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_ != com.google.cloud.discoveryengine.v1.Answer.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, answerText_);
    }
    for (int i = 0; i < citations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, citations_.get(i));
    }
    for (int i = 0; i < references_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, references_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < relatedQuestions_.size(); i++) {
        dataSize += computeStringSizeNoTag(relatedQuestions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRelatedQuestionsList().size();
    }
    for (int i = 0; i < steps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, steps_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCreateTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCompleteTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, getQueryUnderstandingInfo());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < answerSkippedReasons_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                answerSkippedReasons_.get(i));
      }
      size += dataSize;
      if (!getAnswerSkippedReasonsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      answerSkippedReasonsMemoizedSerializedSize = dataSize;
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(12, groundingScore_);
    }
    for (int i = 0; i < groundingSupports_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, groundingSupports_.get(i));
    }
    for (int i = 0; i < safetyRatings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, safetyRatings_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.Answer)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.Answer other =
        (com.google.cloud.discoveryengine.v1.Answer) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (!getAnswerText().equals(other.getAnswerText())) return false;
    if (hasGroundingScore() != other.hasGroundingScore()) return false;
    if (hasGroundingScore()) {
      if (java.lang.Double.doubleToLongBits(getGroundingScore())
          != java.lang.Double.doubleToLongBits(other.getGroundingScore())) return false;
    }
    if (!getCitationsList().equals(other.getCitationsList())) return false;
    if (!getGroundingSupportsList().equals(other.getGroundingSupportsList())) return false;
    if (!getReferencesList().equals(other.getReferencesList())) return false;
    if (!getRelatedQuestionsList().equals(other.getRelatedQuestionsList())) return false;
    if (!getStepsList().equals(other.getStepsList())) return false;
    if (hasQueryUnderstandingInfo() != other.hasQueryUnderstandingInfo()) return false;
    if (hasQueryUnderstandingInfo()) {
      if (!getQueryUnderstandingInfo().equals(other.getQueryUnderstandingInfo())) return false;
    }
    if (!answerSkippedReasons_.equals(other.answerSkippedReasons_)) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasCompleteTime() != other.hasCompleteTime()) return false;
    if (hasCompleteTime()) {
      if (!getCompleteTime().equals(other.getCompleteTime())) return false;
    }
    if (!getSafetyRatingsList().equals(other.getSafetyRatingsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + ANSWER_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getAnswerText().hashCode();
    if (hasGroundingScore()) {
      hash = (37 * hash) + GROUNDING_SCORE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getGroundingScore()));
    }
    if (getCitationsCount() > 0) {
      hash = (37 * hash) + CITATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getCitationsList().hashCode();
    }
    if (getGroundingSupportsCount() > 0) {
      hash = (37 * hash) + GROUNDING_SUPPORTS_FIELD_NUMBER;
      hash = (53 * hash) + getGroundingSupportsList().hashCode();
    }
    if (getReferencesCount() > 0) {
      hash = (37 * hash) + REFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getReferencesList().hashCode();
    }
    if (getRelatedQuestionsCount() > 0) {
      hash = (37 * hash) + RELATED_QUESTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRelatedQuestionsList().hashCode();
    }
    if (getStepsCount() > 0) {
      hash = (37 * hash) + STEPS_FIELD_NUMBER;
      hash = (53 * hash) + getStepsList().hashCode();
    }
    if (hasQueryUnderstandingInfo()) {
      hash = (37 * hash) + QUERY_UNDERSTANDING_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getQueryUnderstandingInfo().hashCode();
    }
    if (getAnswerSkippedReasonsCount() > 0) {
      hash = (37 * hash) + ANSWER_SKIPPED_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + answerSkippedReasons_.hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasCompleteTime()) {
      hash = (37 * hash) + COMPLETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCompleteTime().hashCode();
    }
    if (getSafetyRatingsCount() > 0) {
      hash = (37 * hash) + SAFETY_RATINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSafetyRatingsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Answer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.Answer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Defines an answer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Answer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Answer)
      com.google.cloud.discoveryengine.v1.AnswerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Answer.class,
              com.google.cloud.discoveryengine.v1.Answer.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.Answer.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCitationsFieldBuilder();
        getGroundingSupportsFieldBuilder();
        getReferencesFieldBuilder();
        getStepsFieldBuilder();
        getQueryUnderstandingInfoFieldBuilder();
        getCreateTimeFieldBuilder();
        getCompleteTimeFieldBuilder();
        getSafetyRatingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      state_ = 0;
      answerText_ = "";
      groundingScore_ = 0D;
      if (citationsBuilder_ == null) {
        citations_ = java.util.Collections.emptyList();
      } else {
        citations_ = null;
        citationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (groundingSupportsBuilder_ == null) {
        groundingSupports_ = java.util.Collections.emptyList();
      } else {
        groundingSupports_ = null;
        groundingSupportsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (referencesBuilder_ == null) {
        references_ = java.util.Collections.emptyList();
      } else {
        references_ = null;
        referencesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      relatedQuestions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (stepsBuilder_ == null) {
        steps_ = java.util.Collections.emptyList();
      } else {
        steps_ = null;
        stepsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      queryUnderstandingInfo_ = null;
      if (queryUnderstandingInfoBuilder_ != null) {
        queryUnderstandingInfoBuilder_.dispose();
        queryUnderstandingInfoBuilder_ = null;
      }
      answerSkippedReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      completeTime_ = null;
      if (completeTimeBuilder_ != null) {
        completeTimeBuilder_.dispose();
        completeTimeBuilder_ = null;
      }
      if (safetyRatingsBuilder_ == null) {
        safetyRatings_ = java.util.Collections.emptyList();
      } else {
        safetyRatings_ = null;
        safetyRatingsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.AnswerProto
          .internal_static_google_cloud_discoveryengine_v1_Answer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.Answer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer build() {
      com.google.cloud.discoveryengine.v1.Answer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer buildPartial() {
      com.google.cloud.discoveryengine.v1.Answer result =
          new com.google.cloud.discoveryengine.v1.Answer(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.discoveryengine.v1.Answer result) {
      if (citationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          citations_ = java.util.Collections.unmodifiableList(citations_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.citations_ = citations_;
      } else {
        result.citations_ = citationsBuilder_.build();
      }
      if (groundingSupportsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          groundingSupports_ = java.util.Collections.unmodifiableList(groundingSupports_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.groundingSupports_ = groundingSupports_;
      } else {
        result.groundingSupports_ = groundingSupportsBuilder_.build();
      }
      if (referencesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          references_ = java.util.Collections.unmodifiableList(references_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.references_ = references_;
      } else {
        result.references_ = referencesBuilder_.build();
      }
      if (stepsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          steps_ = java.util.Collections.unmodifiableList(steps_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.steps_ = steps_;
      } else {
        result.steps_ = stepsBuilder_.build();
      }
      if (((bitField0_ & 0x00000400) != 0)) {
        answerSkippedReasons_ = java.util.Collections.unmodifiableList(answerSkippedReasons_);
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.answerSkippedReasons_ = answerSkippedReasons_;
      if (safetyRatingsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          safetyRatings_ = java.util.Collections.unmodifiableList(safetyRatings_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.safetyRatings_ = safetyRatings_;
      } else {
        result.safetyRatings_ = safetyRatingsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.Answer result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.answerText_ = answerText_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.groundingScore_ = groundingScore_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        relatedQuestions_.makeImmutable();
        result.relatedQuestions_ = relatedQuestions_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.queryUnderstandingInfo_ =
            queryUnderstandingInfoBuilder_ == null
                ? queryUnderstandingInfo_
                : queryUnderstandingInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.completeTime_ =
            completeTimeBuilder_ == null ? completeTime_ : completeTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.Answer) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.Answer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Answer other) {
      if (other == com.google.cloud.discoveryengine.v1.Answer.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getAnswerText().isEmpty()) {
        answerText_ = other.answerText_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasGroundingScore()) {
        setGroundingScore(other.getGroundingScore());
      }
      if (citationsBuilder_ == null) {
        if (!other.citations_.isEmpty()) {
          if (citations_.isEmpty()) {
            citations_ = other.citations_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureCitationsIsMutable();
            citations_.addAll(other.citations_);
          }
          onChanged();
        }
      } else {
        if (!other.citations_.isEmpty()) {
          if (citationsBuilder_.isEmpty()) {
            citationsBuilder_.dispose();
            citationsBuilder_ = null;
            citations_ = other.citations_;
            bitField0_ = (bitField0_ & ~0x00000010);
            citationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCitationsFieldBuilder()
                    : null;
          } else {
            citationsBuilder_.addAllMessages(other.citations_);
          }
        }
      }
      if (groundingSupportsBuilder_ == null) {
        if (!other.groundingSupports_.isEmpty()) {
          if (groundingSupports_.isEmpty()) {
            groundingSupports_ = other.groundingSupports_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureGroundingSupportsIsMutable();
            groundingSupports_.addAll(other.groundingSupports_);
          }
          onChanged();
        }
      } else {
        if (!other.groundingSupports_.isEmpty()) {
          if (groundingSupportsBuilder_.isEmpty()) {
            groundingSupportsBuilder_.dispose();
            groundingSupportsBuilder_ = null;
            groundingSupports_ = other.groundingSupports_;
            bitField0_ = (bitField0_ & ~0x00000020);
            groundingSupportsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGroundingSupportsFieldBuilder()
                    : null;
          } else {
            groundingSupportsBuilder_.addAllMessages(other.groundingSupports_);
          }
        }
      }
      if (referencesBuilder_ == null) {
        if (!other.references_.isEmpty()) {
          if (references_.isEmpty()) {
            references_ = other.references_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureReferencesIsMutable();
            references_.addAll(other.references_);
          }
          onChanged();
        }
      } else {
        if (!other.references_.isEmpty()) {
          if (referencesBuilder_.isEmpty()) {
            referencesBuilder_.dispose();
            referencesBuilder_ = null;
            references_ = other.references_;
            bitField0_ = (bitField0_ & ~0x00000040);
            referencesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReferencesFieldBuilder()
                    : null;
          } else {
            referencesBuilder_.addAllMessages(other.references_);
          }
        }
      }
      if (!other.relatedQuestions_.isEmpty()) {
        if (relatedQuestions_.isEmpty()) {
          relatedQuestions_ = other.relatedQuestions_;
          bitField0_ |= 0x00000080;
        } else {
          ensureRelatedQuestionsIsMutable();
          relatedQuestions_.addAll(other.relatedQuestions_);
        }
        onChanged();
      }
      if (stepsBuilder_ == null) {
        if (!other.steps_.isEmpty()) {
          if (steps_.isEmpty()) {
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureStepsIsMutable();
            steps_.addAll(other.steps_);
          }
          onChanged();
        }
      } else {
        if (!other.steps_.isEmpty()) {
          if (stepsBuilder_.isEmpty()) {
            stepsBuilder_.dispose();
            stepsBuilder_ = null;
            steps_ = other.steps_;
            bitField0_ = (bitField0_ & ~0x00000100);
            stepsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStepsFieldBuilder()
                    : null;
          } else {
            stepsBuilder_.addAllMessages(other.steps_);
          }
        }
      }
      if (other.hasQueryUnderstandingInfo()) {
        mergeQueryUnderstandingInfo(other.getQueryUnderstandingInfo());
      }
      if (!other.answerSkippedReasons_.isEmpty()) {
        if (answerSkippedReasons_.isEmpty()) {
          answerSkippedReasons_ = other.answerSkippedReasons_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureAnswerSkippedReasonsIsMutable();
          answerSkippedReasons_.addAll(other.answerSkippedReasons_);
        }
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasCompleteTime()) {
        mergeCompleteTime(other.getCompleteTime());
      }
      if (safetyRatingsBuilder_ == null) {
        if (!other.safetyRatings_.isEmpty()) {
          if (safetyRatings_.isEmpty()) {
            safetyRatings_ = other.safetyRatings_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureSafetyRatingsIsMutable();
            safetyRatings_.addAll(other.safetyRatings_);
          }
          onChanged();
        }
      } else {
        if (!other.safetyRatings_.isEmpty()) {
          if (safetyRatingsBuilder_.isEmpty()) {
            safetyRatingsBuilder_.dispose();
            safetyRatingsBuilder_ = null;
            safetyRatings_ = other.safetyRatings_;
            bitField0_ = (bitField0_ & ~0x00002000);
            safetyRatingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSafetyRatingsFieldBuilder()
                    : null;
          } else {
            safetyRatingsBuilder_.addAllMessages(other.safetyRatings_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                answerText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.discoveryengine.v1.Answer.Citation m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.Answer.Citation.parser(),
                        extensionRegistry);
                if (citationsBuilder_ == null) {
                  ensureCitationsIsMutable();
                  citations_.add(m);
                } else {
                  citationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.discoveryengine.v1.Answer.Reference m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.Answer.Reference.parser(),
                        extensionRegistry);
                if (referencesBuilder_ == null) {
                  ensureReferencesIsMutable();
                  references_.add(m);
                } else {
                  referencesBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRelatedQuestionsIsMutable();
                relatedQuestions_.add(s);
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.discoveryengine.v1.Answer.Step m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.Answer.Step.parser(),
                        extensionRegistry);
                if (stepsBuilder_ == null) {
                  ensureStepsIsMutable();
                  steps_.add(m);
                } else {
                  stepsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getCompleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getQueryUnderstandingInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                int tmpRaw = input.readEnum();
                ensureAnswerSkippedReasonsIsMutable();
                answerSkippedReasons_.add(tmpRaw);
                break;
              } // case 88
            case 90:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAnswerSkippedReasonsIsMutable();
                  answerSkippedReasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 90
            case 97:
              {
                groundingScore_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 97
            case 106:
              {
                com.google.cloud.discoveryengine.v1.Answer.GroundingSupport m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.parser(),
                        extensionRegistry);
                if (groundingSupportsBuilder_ == null) {
                  ensureGroundingSupportsIsMutable();
                  groundingSupports_.add(m);
                } else {
                  groundingSupportsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.discoveryengine.v1.SafetyRating m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.SafetyRating.parser(),
                        extensionRegistry);
                if (safetyRatingsBuilder_ == null) {
                  ensureSafetyRatingsIsMutable();
                  safetyRatings_.add(m);
                } else {
                  safetyRatingsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;&#47;answers/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;&#47;answers/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;&#47;answers/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;&#47;answers/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/&#42;&#47;answers/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * The state of the answer generation.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * The state of the answer generation.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The state of the answer generation.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Answer.State getState() {
      com.google.cloud.discoveryengine.v1.Answer.State result =
          com.google.cloud.discoveryengine.v1.Answer.State.forNumber(state_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.Answer.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The state of the answer generation.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.discoveryengine.v1.Answer.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The state of the answer generation.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Answer.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object answerText_ = "";

    /**
     *
     *
     * <pre>
     * The textual answer.
     * </pre>
     *
     * <code>string answer_text = 3;</code>
     *
     * @return The answerText.
     */
    public java.lang.String getAnswerText() {
      java.lang.Object ref = answerText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The textual answer.
     * </pre>
     *
     * <code>string answer_text = 3;</code>
     *
     * @return The bytes for answerText.
     */
    public com.google.protobuf.ByteString getAnswerTextBytes() {
      java.lang.Object ref = answerText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The textual answer.
     * </pre>
     *
     * <code>string answer_text = 3;</code>
     *
     * @param value The answerText to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answerText_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The textual answer.
     * </pre>
     *
     * <code>string answer_text = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerText() {
      answerText_ = getDefaultInstance().getAnswerText();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The textual answer.
     * </pre>
     *
     * <code>string answer_text = 3;</code>
     *
     * @param value The bytes for answerText to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answerText_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private double groundingScore_;

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded the answer is by the
     * reference chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 12;</code>
     *
     * @return Whether the groundingScore field is set.
     */
    @java.lang.Override
    public boolean hasGroundingScore() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded the answer is by the
     * reference chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 12;</code>
     *
     * @return The groundingScore.
     */
    @java.lang.Override
    public double getGroundingScore() {
      return groundingScore_;
    }

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded the answer is by the
     * reference chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 12;</code>
     *
     * @param value The groundingScore to set.
     * @return This builder for chaining.
     */
    public Builder setGroundingScore(double value) {

      groundingScore_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A score in the range of [0, 1] describing how grounded the answer is by the
     * reference chunks.
     * </pre>
     *
     * <code>optional double grounding_score = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroundingScore() {
      bitField0_ = (bitField0_ & ~0x00000008);
      groundingScore_ = 0D;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Citation> citations_ =
        java.util.Collections.emptyList();

    private void ensureCitationsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        citations_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Answer.Citation>(
                citations_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Answer.Citation,
            com.google.cloud.discoveryengine.v1.Answer.Citation.Builder,
            com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder>
        citationsBuilder_;

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Citation> getCitationsList() {
      if (citationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(citations_);
      } else {
        return citationsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public int getCitationsCount() {
      if (citationsBuilder_ == null) {
        return citations_.size();
      } else {
        return citationsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Citation getCitations(int index) {
      if (citationsBuilder_ == null) {
        return citations_.get(index);
      } else {
        return citationsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder setCitations(
        int index, com.google.cloud.discoveryengine.v1.Answer.Citation value) {
      if (citationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitationsIsMutable();
        citations_.set(index, value);
        onChanged();
      } else {
        citationsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder setCitations(
        int index, com.google.cloud.discoveryengine.v1.Answer.Citation.Builder builderForValue) {
      if (citationsBuilder_ == null) {
        ensureCitationsIsMutable();
        citations_.set(index, builderForValue.build());
        onChanged();
      } else {
        citationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder addCitations(com.google.cloud.discoveryengine.v1.Answer.Citation value) {
      if (citationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitationsIsMutable();
        citations_.add(value);
        onChanged();
      } else {
        citationsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder addCitations(
        int index, com.google.cloud.discoveryengine.v1.Answer.Citation value) {
      if (citationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCitationsIsMutable();
        citations_.add(index, value);
        onChanged();
      } else {
        citationsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder addCitations(
        com.google.cloud.discoveryengine.v1.Answer.Citation.Builder builderForValue) {
      if (citationsBuilder_ == null) {
        ensureCitationsIsMutable();
        citations_.add(builderForValue.build());
        onChanged();
      } else {
        citationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder addCitations(
        int index, com.google.cloud.discoveryengine.v1.Answer.Citation.Builder builderForValue) {
      if (citationsBuilder_ == null) {
        ensureCitationsIsMutable();
        citations_.add(index, builderForValue.build());
        onChanged();
      } else {
        citationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder addAllCitations(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Answer.Citation> values) {
      if (citationsBuilder_ == null) {
        ensureCitationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, citations_);
        onChanged();
      } else {
        citationsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder clearCitations() {
      if (citationsBuilder_ == null) {
        citations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        citationsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public Builder removeCitations(int index) {
      if (citationsBuilder_ == null) {
        ensureCitationsIsMutable();
        citations_.remove(index);
        onChanged();
      } else {
        citationsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Citation.Builder getCitationsBuilder(
        int index) {
      return getCitationsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder getCitationsOrBuilder(
        int index) {
      if (citationsBuilder_ == null) {
        return citations_.get(index);
      } else {
        return citationsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder>
        getCitationsOrBuilderList() {
      if (citationsBuilder_ != null) {
        return citationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(citations_);
      }
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Citation.Builder addCitationsBuilder() {
      return getCitationsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1.Answer.Citation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Citation.Builder addCitationsBuilder(
        int index) {
      return getCitationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1.Answer.Citation.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Citations.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Citation citations = 4;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Citation.Builder>
        getCitationsBuilderList() {
      return getCitationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Answer.Citation,
            com.google.cloud.discoveryengine.v1.Answer.Citation.Builder,
            com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder>
        getCitationsFieldBuilder() {
      if (citationsBuilder_ == null) {
        citationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Citation,
                com.google.cloud.discoveryengine.v1.Answer.Citation.Builder,
                com.google.cloud.discoveryengine.v1.Answer.CitationOrBuilder>(
                citations_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        citations_ = null;
      }
      return citationsBuilder_;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.Answer.GroundingSupport>
        groundingSupports_ = java.util.Collections.emptyList();

    private void ensureGroundingSupportsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        groundingSupports_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Answer.GroundingSupport>(
                groundingSupports_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Answer.GroundingSupport,
            com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder,
            com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder>
        groundingSupportsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.GroundingSupport>
        getGroundingSupportsList() {
      if (groundingSupportsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(groundingSupports_);
      } else {
        return groundingSupportsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getGroundingSupportsCount() {
      if (groundingSupportsBuilder_ == null) {
        return groundingSupports_.size();
      } else {
        return groundingSupportsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport getGroundingSupports(
        int index) {
      if (groundingSupportsBuilder_ == null) {
        return groundingSupports_.get(index);
      } else {
        return groundingSupportsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingSupports(
        int index, com.google.cloud.discoveryengine.v1.Answer.GroundingSupport value) {
      if (groundingSupportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingSupportsIsMutable();
        groundingSupports_.set(index, value);
        onChanged();
      } else {
        groundingSupportsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGroundingSupports(
        int index,
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder builderForValue) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.set(index, builderForValue.build());
        onChanged();
      } else {
        groundingSupportsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport value) {
      if (groundingSupportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(value);
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        int index, com.google.cloud.discoveryengine.v1.Answer.GroundingSupport value) {
      if (groundingSupportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(index, value);
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder builderForValue) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(builderForValue.build());
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addGroundingSupports(
        int index,
        com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder builderForValue) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.add(index, builderForValue.build());
        onChanged();
      } else {
        groundingSupportsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllGroundingSupports(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Answer.GroundingSupport>
            values) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundingSupports_);
        onChanged();
      } else {
        groundingSupportsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGroundingSupports() {
      if (groundingSupportsBuilder_ == null) {
        groundingSupports_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        groundingSupportsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeGroundingSupports(int index) {
      if (groundingSupportsBuilder_ == null) {
        ensureGroundingSupportsIsMutable();
        groundingSupports_.remove(index);
        onChanged();
      } else {
        groundingSupportsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder
        getGroundingSupportsBuilder(int index) {
      return getGroundingSupportsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder
        getGroundingSupportsOrBuilder(int index) {
      if (groundingSupportsBuilder_ == null) {
        return groundingSupports_.get(index);
      } else {
        return groundingSupportsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder>
        getGroundingSupportsOrBuilderList() {
      if (groundingSupportsBuilder_ != null) {
        return groundingSupportsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(groundingSupports_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder
        addGroundingSupportsBuilder() {
      return getGroundingSupportsFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder
        addGroundingSupportsBuilder(int index) {
      return getGroundingSupportsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Grounding supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.Answer.GroundingSupport grounding_supports = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder>
        getGroundingSupportsBuilderList() {
      return getGroundingSupportsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Answer.GroundingSupport,
            com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder,
            com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder>
        getGroundingSupportsFieldBuilder() {
      if (groundingSupportsBuilder_ == null) {
        groundingSupportsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.GroundingSupport,
                com.google.cloud.discoveryengine.v1.Answer.GroundingSupport.Builder,
                com.google.cloud.discoveryengine.v1.Answer.GroundingSupportOrBuilder>(
                groundingSupports_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        groundingSupports_ = null;
      }
      return groundingSupportsBuilder_;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Reference> references_ =
        java.util.Collections.emptyList();

    private void ensureReferencesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        references_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Answer.Reference>(
                references_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Answer.Reference,
            com.google.cloud.discoveryengine.v1.Answer.Reference.Builder,
            com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder>
        referencesBuilder_;

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Reference>
        getReferencesList() {
      if (referencesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(references_);
      } else {
        return referencesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public int getReferencesCount() {
      if (referencesBuilder_ == null) {
        return references_.size();
      } else {
        return referencesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Reference getReferences(int index) {
      if (referencesBuilder_ == null) {
        return references_.get(index);
      } else {
        return referencesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder setReferences(
        int index, com.google.cloud.discoveryengine.v1.Answer.Reference value) {
      if (referencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferencesIsMutable();
        references_.set(index, value);
        onChanged();
      } else {
        referencesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder setReferences(
        int index, com.google.cloud.discoveryengine.v1.Answer.Reference.Builder builderForValue) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.set(index, builderForValue.build());
        onChanged();
      } else {
        referencesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder addReferences(com.google.cloud.discoveryengine.v1.Answer.Reference value) {
      if (referencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferencesIsMutable();
        references_.add(value);
        onChanged();
      } else {
        referencesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder addReferences(
        int index, com.google.cloud.discoveryengine.v1.Answer.Reference value) {
      if (referencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferencesIsMutable();
        references_.add(index, value);
        onChanged();
      } else {
        referencesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder addReferences(
        com.google.cloud.discoveryengine.v1.Answer.Reference.Builder builderForValue) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.add(builderForValue.build());
        onChanged();
      } else {
        referencesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder addReferences(
        int index, com.google.cloud.discoveryengine.v1.Answer.Reference.Builder builderForValue) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.add(index, builderForValue.build());
        onChanged();
      } else {
        referencesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder addAllReferences(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Answer.Reference> values) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, references_);
        onChanged();
      } else {
        referencesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder clearReferences() {
      if (referencesBuilder_ == null) {
        references_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        referencesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public Builder removeReferences(int index) {
      if (referencesBuilder_ == null) {
        ensureReferencesIsMutable();
        references_.remove(index);
        onChanged();
      } else {
        referencesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Reference.Builder getReferencesBuilder(
        int index) {
      return getReferencesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder getReferencesOrBuilder(
        int index) {
      if (referencesBuilder_ == null) {
        return references_.get(index);
      } else {
        return referencesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder>
        getReferencesOrBuilderList() {
      if (referencesBuilder_ != null) {
        return referencesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(references_);
      }
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Reference.Builder addReferencesBuilder() {
      return getReferencesFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1.Answer.Reference.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Answer.Reference.Builder addReferencesBuilder(
        int index) {
      return getReferencesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1.Answer.Reference.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * References.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Answer.Reference references = 5;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Answer.Reference.Builder>
        getReferencesBuilderList() {
      return getReferencesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Answer.Reference,
            com.google.cloud.discoveryengine.v1.Answer.Reference.Builder,
            com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder>
        getReferencesFieldBuilder() {
      if (referencesBuilder_ == null) {
        referencesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Answer.Reference,
                com.google.cloud.discoveryengine.v1.Answer.Reference.Builder,
                com.google.cloud.discoveryengine.v1.Answer.ReferenceOrBuilder>(
                references_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        references_ = null;
      }
      return referencesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList relatedQuestions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRelatedQuestionsIsMutable() {
      if (!relatedQuestions_.isModifiable()) {
        relatedQuestions_ = new com.google.protobuf.LazyStringArrayList(relatedQuestions_);
      }
      bitField0_ |= 0x00000080;
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @return A list containing the relatedQuestions.
     */
    public com.google.protobuf.ProtocolStringList getRelatedQuestionsList() {
      relatedQuestions_.makeImmutable();
      return relatedQuestions_;
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @return The count of relatedQuestions.
     */
    public int getRelatedQuestionsCount() {
      return relatedQuestions_.size();
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The relatedQuestions at the given index.
     */
    public java.lang.String getRelatedQuestions(int index) {
      return relatedQuestions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the relatedQuestions at the given index.
     */
    public com.google.protobuf.ByteString getRelatedQuestionsBytes(int index) {
      return relatedQuestions_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The relatedQuestions to set.
     * @return This builder for chaining.
     */
    public Builder setRelatedQuestions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRelatedQuestionsIsMutable();
      relatedQuestions_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @param value The relatedQuestions to add.
     * @return This builder for chaining.
     */
    public Builder addRelatedQuestions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRelatedQuestionsIsMutable();
      relatedQuestions_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @param values The relatedQuestions to add.
     * @return This builder for chaining.
     */
    public Builder addAllRelatedQuestions(java.lang.Iterable<java.lang.String> values) {
      ensureRelatedQuestionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, relatedQuestions_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelatedQuestions() {
      relatedQuestions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Suggested related questions.
     * </pre>
     *
     * <code>repeated string related_questions = 6;</code>
     *
     * @param value The bytes of the relatedQuestions to add.
     * @return This builder for chaining.
     */
    public Builder addRelatedQuestionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRelatedQuestionsIsMutable();
      relatedQuestions_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.Answer.Step> steps_ =
        java.util.Collections.emptyList();

    private void ensureStepsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        steps_ = new java.util.ArrayList<com.g