/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/import_config.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * The Bigtable Options object that contains information to support
 * the import.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.BigtableOptions}
 */
public final class BigtableOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.BigtableOptions)
    BigtableOptionsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BigtableOptions.newBuilder() to construct.
  private BigtableOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigtableOptions() {
    keyFieldName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigtableOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetFamilies();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.BigtableOptions.class,
            com.google.cloud.discoveryengine.v1.BigtableOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of values in a Bigtable column or column family.
   * The values are expected to be encoded using
   * [HBase
   * Bytes.toBytes](https://hbase.apache.org/1.4/apidocs/org/apache/hadoop/hbase/util/Bytes.html)
   * function when the encoding value is set to `BINARY`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.BigtableOptions.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The type is unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * String type.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    STRING(1),
    /**
     *
     *
     * <pre>
     * Numerical type.
     * </pre>
     *
     * <code>NUMBER = 2;</code>
     */
    NUMBER(2),
    /**
     *
     *
     * <pre>
     * Integer type.
     * </pre>
     *
     * <code>INTEGER = 3;</code>
     */
    INTEGER(3),
    /**
     *
     *
     * <pre>
     * Variable length integer type.
     * </pre>
     *
     * <code>VAR_INTEGER = 4;</code>
     */
    VAR_INTEGER(4),
    /**
     *
     *
     * <pre>
     * BigDecimal type.
     * </pre>
     *
     * <code>BIG_NUMERIC = 5;</code>
     */
    BIG_NUMERIC(5),
    /**
     *
     *
     * <pre>
     * Boolean type.
     * </pre>
     *
     * <code>BOOLEAN = 6;</code>
     */
    BOOLEAN(6),
    /**
     *
     *
     * <pre>
     * JSON type.
     * </pre>
     *
     * <code>JSON = 7;</code>
     */
    JSON(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The type is unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * String type.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    public static final int STRING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Numerical type.
     * </pre>
     *
     * <code>NUMBER = 2;</code>
     */
    public static final int NUMBER_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Integer type.
     * </pre>
     *
     * <code>INTEGER = 3;</code>
     */
    public static final int INTEGER_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Variable length integer type.
     * </pre>
     *
     * <code>VAR_INTEGER = 4;</code>
     */
    public static final int VAR_INTEGER_VALUE = 4;

    /**
     *
     *
     * <pre>
     * BigDecimal type.
     * </pre>
     *
     * <code>BIG_NUMERIC = 5;</code>
     */
    public static final int BIG_NUMERIC_VALUE = 5;

    /**
     *
     *
     * <pre>
     * Boolean type.
     * </pre>
     *
     * <code>BOOLEAN = 6;</code>
     */
    public static final int BOOLEAN_VALUE = 6;

    /**
     *
     *
     * <pre>
     * JSON type.
     * </pre>
     *
     * <code>JSON = 7;</code>
     */
    public static final int JSON_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return STRING;
        case 2:
          return NUMBER;
        case 3:
          return INTEGER;
        case 4:
          return VAR_INTEGER;
        case 5:
          return BIG_NUMERIC;
        case 6:
          return BOOLEAN;
        case 7:
          return JSON;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.BigtableOptions.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.BigtableOptions.Type)
  }

  /**
   *
   *
   * <pre>
   * The encoding mode of a Bigtable column or column family.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.BigtableOptions.Encoding}
   */
  public enum Encoding implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The encoding is unspecified.
     * </pre>
     *
     * <code>ENCODING_UNSPECIFIED = 0;</code>
     */
    ENCODING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Text encoding.
     * </pre>
     *
     * <code>TEXT = 1;</code>
     */
    TEXT(1),
    /**
     *
     *
     * <pre>
     * Binary encoding.
     * </pre>
     *
     * <code>BINARY = 2;</code>
     */
    BINARY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The encoding is unspecified.
     * </pre>
     *
     * <code>ENCODING_UNSPECIFIED = 0;</code>
     */
    public static final int ENCODING_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Text encoding.
     * </pre>
     *
     * <code>TEXT = 1;</code>
     */
    public static final int TEXT_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Binary encoding.
     * </pre>
     *
     * <code>BINARY = 2;</code>
     */
    public static final int BINARY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Encoding valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Encoding forNumber(int value) {
      switch (value) {
        case 0:
          return ENCODING_UNSPECIFIED;
        case 1:
          return TEXT;
        case 2:
          return BINARY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Encoding> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Encoding> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Encoding>() {
          public Encoding findValueByNumber(int number) {
            return Encoding.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.BigtableOptions.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Encoding[] VALUES = values();

    public static Encoding valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Encoding(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.BigtableOptions.Encoding)
  }

  public interface BigtableColumnFamilyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The field name to use for this column family in the document. The
     * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
     * it is parsed from the family name with best effort. However, due to
     * different naming patterns, field name collisions could happen, where
     * parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The fieldName.
     */
    java.lang.String getFieldName();

    /**
     *
     *
     * <pre>
     * The field name to use for this column family in the document. The
     * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
     * it is parsed from the family name with best effort. However, due to
     * different naming patterns, field name collisions could happen, where
     * parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The bytes for fieldName.
     */
    com.google.protobuf.ByteString getFieldNameBytes();

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not STRING.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    int getEncodingValue();

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not STRING.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
     *
     * @return The encoding.
     */
    com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
     *
     * @return The type.
     */
    com.google.cloud.discoveryengine.v1.BigtableOptions.Type getType();

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn>
        getColumnsList();

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn getColumns(int index);

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    int getColumnsCount();

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder>
        getColumnsOrBuilderList();

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder getColumnsOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * The column family of the Bigtable.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily}
   */
  public static final class BigtableColumnFamily extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily)
      BigtableColumnFamilyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BigtableColumnFamily.newBuilder() to construct.
    private BigtableColumnFamily(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigtableColumnFamily() {
      fieldName_ = "";
      encoding_ = 0;
      type_ = 0;
      columns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigtableColumnFamily();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumnFamily_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumnFamily_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.class,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder
                  .class);
    }

    public static final int FIELD_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fieldName_ = "";

    /**
     *
     *
     * <pre>
     * The field name to use for this column family in the document. The
     * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
     * it is parsed from the family name with best effort. However, due to
     * different naming patterns, field name collisions could happen, where
     * parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The fieldName.
     */
    @java.lang.Override
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The field name to use for this column family in the document. The
     * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
     * it is parsed from the family name with best effort. However, due to
     * different naming patterns, field name collisions could happen, where
     * parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 1;</code>
     *
     * @return The bytes for fieldName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENCODING_FIELD_NUMBER = 2;
    private int encoding_ = 0;

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not STRING.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    @java.lang.Override
    public int getEncodingValue() {
      return encoding_;
    }

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not STRING.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding getEncoding() {
      com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding result =
          com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.forNumber(encoding_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.UNRECOGNIZED
          : result;
    }

    public static final int TYPE_FIELD_NUMBER = 3;
    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.Type getType() {
      com.google.cloud.discoveryengine.v1.BigtableOptions.Type result =
          com.google.cloud.discoveryengine.v1.BigtableOptions.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.BigtableOptions.Type.UNRECOGNIZED
          : result;
    }

    public static final int COLUMNS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn>
        columns_;

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn>
        getColumnsList() {
      return columns_;
    }

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder>
        getColumnsOrBuilderList() {
      return columns_;
    }

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    @java.lang.Override
    public int getColumnsCount() {
      return columns_.size();
    }

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn getColumns(
        int index) {
      return columns_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The list of objects that contains column level information for each
     * column. If a column is not present in this list it will be ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder
        getColumnsOrBuilder(int index) {
      return columns_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
      }
      if (encoding_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.ENCODING_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, encoding_);
      }
      if (type_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, type_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        output.writeMessage(4, columns_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
      }
      if (encoding_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.ENCODING_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, encoding_);
      }
      if (type_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, type_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, columns_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily other =
          (com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily) obj;

      if (!getFieldName().equals(other.getFieldName())) return false;
      if (encoding_ != other.encoding_) return false;
      if (type_ != other.type_) return false;
      if (!getColumnsList().equals(other.getColumnsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFieldName().hashCode();
      hash = (37 * hash) + ENCODING_FIELD_NUMBER;
      hash = (53 * hash) + encoding_;
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (getColumnsCount() > 0) {
        hash = (37 * hash) + COLUMNS_FIELD_NUMBER;
        hash = (53 * hash) + getColumnsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The column family of the Bigtable.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily)
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumnFamily_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumnFamily_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.class,
                com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        fieldName_ = "";
        encoding_ = 0;
        type_ = 0;
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
        } else {
          columns_ = null;
          columnsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumnFamily_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily build() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
          buildPartial() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily result =
            new com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily result) {
        if (columnsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            columns_ = java.util.Collections.unmodifiableList(columns_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.columns_ = columns_;
        } else {
          result.columns_ = columnsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.fieldName_ = fieldName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.encoding_ = encoding_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily other) {
        if (other
            == com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
                .getDefaultInstance()) return this;
        if (!other.getFieldName().isEmpty()) {
          fieldName_ = other.fieldName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.encoding_ != 0) {
          setEncodingValue(other.getEncodingValue());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (columnsBuilder_ == null) {
          if (!other.columns_.isEmpty()) {
            if (columns_.isEmpty()) {
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureColumnsIsMutable();
              columns_.addAll(other.columns_);
            }
            onChanged();
          }
        } else {
          if (!other.columns_.isEmpty()) {
            if (columnsBuilder_.isEmpty()) {
              columnsBuilder_.dispose();
              columnsBuilder_ = null;
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000008);
              columnsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getColumnsFieldBuilder()
                      : null;
            } else {
              columnsBuilder_.addAllMessages(other.columns_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  fieldName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  encoding_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
                              .parser(),
                          extensionRegistry);
                  if (columnsBuilder_ == null) {
                    ensureColumnsIsMutable();
                    columns_.add(m);
                  } else {
                    columnsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object fieldName_ = "";

      /**
       *
       *
       * <pre>
       * The field name to use for this column family in the document. The
       * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
       * it is parsed from the family name with best effort. However, due to
       * different naming patterns, field name collisions could happen, where
       * parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @return The fieldName.
       */
      public java.lang.String getFieldName() {
        java.lang.Object ref = fieldName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column family in the document. The
       * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
       * it is parsed from the family name with best effort. However, due to
       * different naming patterns, field name collisions could happen, where
       * parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @return The bytes for fieldName.
       */
      public com.google.protobuf.ByteString getFieldNameBytes() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column family in the document. The
       * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
       * it is parsed from the family name with best effort. However, due to
       * different naming patterns, field name collisions could happen, where
       * parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @param value The fieldName to set.
       * @return This builder for chaining.
       */
      public Builder setFieldName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fieldName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column family in the document. The
       * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
       * it is parsed from the family name with best effort. However, due to
       * different naming patterns, field name collisions could happen, where
       * parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFieldName() {
        fieldName_ = getDefaultInstance().getFieldName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column family in the document. The
       * name has to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`. If not set,
       * it is parsed from the family name with best effort. However, due to
       * different naming patterns, field name collisions could happen, where
       * parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 1;</code>
       *
       * @param value The bytes for fieldName to set.
       * @return This builder for chaining.
       */
      public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fieldName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int encoding_ = 0;

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not STRING.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
       *
       * @return The enum numeric value on the wire for encoding.
       */
      @java.lang.Override
      public int getEncodingValue() {
        return encoding_;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not STRING.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
       *
       * @param value The enum numeric value on the wire for encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncodingValue(int value) {
        encoding_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not STRING.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
       *
       * @return The encoding.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding getEncoding() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding result =
            com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.forNumber(encoding_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not STRING.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
       *
       * @param value The encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncoding(
          com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        encoding_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not STRING.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000002);
        encoding_ = 0;
        onChanged();
        return this;
      }

      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.Type getType() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.Type result =
            com.google.cloud.discoveryengine.v1.BigtableOptions.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.BigtableOptions.Type.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.discoveryengine.v1.BigtableOptions.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        type_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000004);
        type_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn>
          columns_ = java.util.Collections.emptyList();

      private void ensureColumnsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          columns_ =
              new java.util.ArrayList<
                  com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn>(columns_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder>
          columnsBuilder_;

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn>
          getColumnsList() {
        if (columnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columns_);
        } else {
          return columnsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public int getColumnsCount() {
        if (columnsBuilder_ == null) {
          return columns_.size();
        } else {
          return columnsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn getColumns(
          int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder setColumns(
          int index, com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.set(index, value);
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder setColumns(
          int index,
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder
              builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder addColumns(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder addColumns(
          int index, com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(index, value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder addColumns(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder
              builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder addColumns(
          int index,
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder
              builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder addAllColumns(
          java.lang.Iterable<
                  ? extends com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn>
              values) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, columns_);
          onChanged();
        } else {
          columnsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder clearColumns() {
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          columnsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public Builder removeColumns(int index) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.remove(index);
          onChanged();
        } else {
          columnsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder
          getColumnsBuilder(int index) {
        return getColumnsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder
          getColumnsOrBuilder(int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder>
          getColumnsOrBuilderList() {
        if (columnsBuilder_ != null) {
          return columnsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(columns_);
        }
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder
          addColumnsBuilder() {
        return getColumnsFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder
          addColumnsBuilder(int index) {
        return getColumnsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The list of objects that contains column level information for each
       * column. If a column is not present in this list it will be ignored.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn columns = 4;
       * </code>
       */
      public java.util.List<
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder>
          getColumnsBuilderList() {
        return getColumnsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder>
          getColumnsFieldBuilder() {
        if (columnsBuilder_ == null) {
          columnsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn,
                  com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder,
                  com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder>(
                  columns_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
          columns_ = null;
        }
        return columnsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily)
    private static final com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily();
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigtableColumnFamily> PARSER =
        new com.google.protobuf.AbstractParser<BigtableColumnFamily>() {
          @java.lang.Override
          public BigtableColumnFamily parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigtableColumnFamily> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigtableColumnFamily> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BigtableColumnOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Qualifier of the column. If it cannot be decoded with utf-8,
     * use a base-64 encoded string instead.
     * </pre>
     *
     * <code>bytes qualifier = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The qualifier.
     */
    com.google.protobuf.ByteString getQualifier();

    /**
     *
     *
     * <pre>
     * The field name to use for this column in the document. The name has to
     * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * If not set, it is parsed from the qualifier bytes with best effort.
     * However, due to different naming patterns, field name collisions could
     * happen, where parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @return The fieldName.
     */
    java.lang.String getFieldName();

    /**
     *
     *
     * <pre>
     * The field name to use for this column in the document. The name has to
     * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * If not set, it is parsed from the qualifier bytes with best effort.
     * However, due to different naming patterns, field name collisions could
     * happen, where parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @return The bytes for fieldName.
     */
    com.google.protobuf.ByteString getFieldNameBytes();

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not `STRING`.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    int getEncodingValue();

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not `STRING`.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
     *
     * @return The encoding.
     */
    com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding getEncoding();

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
     *
     * @return The type.
     */
    com.google.cloud.discoveryengine.v1.BigtableOptions.Type getType();
  }

  /**
   *
   *
   * <pre>
   * The column of the Bigtable.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn}
   */
  public static final class BigtableColumn extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn)
      BigtableColumnOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BigtableColumn.newBuilder() to construct.
    private BigtableColumn(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigtableColumn() {
      qualifier_ = com.google.protobuf.ByteString.EMPTY;
      fieldName_ = "";
      encoding_ = 0;
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigtableColumn();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumn_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumn_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.class,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder.class);
    }

    public static final int QUALIFIER_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString qualifier_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * Required. Qualifier of the column. If it cannot be decoded with utf-8,
     * use a base-64 encoded string instead.
     * </pre>
     *
     * <code>bytes qualifier = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The qualifier.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQualifier() {
      return qualifier_;
    }

    public static final int FIELD_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fieldName_ = "";

    /**
     *
     *
     * <pre>
     * The field name to use for this column in the document. The name has to
     * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * If not set, it is parsed from the qualifier bytes with best effort.
     * However, due to different naming patterns, field name collisions could
     * happen, where parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @return The fieldName.
     */
    @java.lang.Override
    public java.lang.String getFieldName() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fieldName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The field name to use for this column in the document. The name has to
     * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * If not set, it is parsed from the qualifier bytes with best effort.
     * However, due to different naming patterns, field name collisions could
     * happen, where parsing behavior is undefined.
     * </pre>
     *
     * <code>string field_name = 2;</code>
     *
     * @return The bytes for fieldName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFieldNameBytes() {
      java.lang.Object ref = fieldName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENCODING_FIELD_NUMBER = 3;
    private int encoding_ = 0;

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not `STRING`.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
     *
     * @return The enum numeric value on the wire for encoding.
     */
    @java.lang.Override
    public int getEncodingValue() {
      return encoding_;
    }

    /**
     *
     *
     * <pre>
     * The encoding mode of the values when the type is not `STRING`.
     * Acceptable encoding values are:
     *
     * * `TEXT`: indicates values are alphanumeric text strings.
     * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
     * family of functions. This can be overridden for a specific column
     * by listing that column in `columns` and specifying an encoding for it.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
     *
     * @return The encoding.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding getEncoding() {
      com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding result =
          com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.forNumber(encoding_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.UNRECOGNIZED
          : result;
    }

    public static final int TYPE_FIELD_NUMBER = 4;
    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The type of values in this column family.
     * The values are expected to be encoded using `HBase Bytes.toBytes`
     * function when the encoding value is set to `BINARY`.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.Type getType() {
      com.google.cloud.discoveryengine.v1.BigtableOptions.Type result =
          com.google.cloud.discoveryengine.v1.BigtableOptions.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.BigtableOptions.Type.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!qualifier_.isEmpty()) {
        output.writeBytes(1, qualifier_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fieldName_);
      }
      if (encoding_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.ENCODING_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, encoding_);
      }
      if (type_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!qualifier_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, qualifier_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fieldName_);
      }
      if (encoding_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.ENCODING_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, encoding_);
      }
      if (type_
          != com.google.cloud.discoveryengine.v1.BigtableOptions.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn other =
          (com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn) obj;

      if (!getQualifier().equals(other.getQualifier())) return false;
      if (!getFieldName().equals(other.getFieldName())) return false;
      if (encoding_ != other.encoding_) return false;
      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + QUALIFIER_FIELD_NUMBER;
      hash = (53 * hash) + getQualifier().hashCode();
      hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFieldName().hashCode();
      hash = (37 * hash) + ENCODING_FIELD_NUMBER;
      hash = (53 * hash) + encoding_;
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The column of the Bigtable.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn)
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumn_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumn_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.class,
                com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        qualifier_ = com.google.protobuf.ByteString.EMPTY;
        fieldName_ = "";
        encoding_ = 0;
        type_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_BigtableColumn_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn build() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn buildPartial() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn result =
            new com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.qualifier_ = qualifier_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fieldName_ = fieldName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.encoding_ = encoding_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn other) {
        if (other
            == com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
                .getDefaultInstance()) return this;
        if (other.getQualifier() != com.google.protobuf.ByteString.EMPTY) {
          setQualifier(other.getQualifier());
        }
        if (!other.getFieldName().isEmpty()) {
          fieldName_ = other.fieldName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.encoding_ != 0) {
          setEncodingValue(other.getEncodingValue());
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  qualifier_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  fieldName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  encoding_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString qualifier_ = com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * Required. Qualifier of the column. If it cannot be decoded with utf-8,
       * use a base-64 encoded string instead.
       * </pre>
       *
       * <code>bytes qualifier = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The qualifier.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getQualifier() {
        return qualifier_;
      }

      /**
       *
       *
       * <pre>
       * Required. Qualifier of the column. If it cannot be decoded with utf-8,
       * use a base-64 encoded string instead.
       * </pre>
       *
       * <code>bytes qualifier = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The qualifier to set.
       * @return This builder for chaining.
       */
      public Builder setQualifier(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        qualifier_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Qualifier of the column. If it cannot be decoded with utf-8,
       * use a base-64 encoded string instead.
       * </pre>
       *
       * <code>bytes qualifier = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQualifier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        qualifier_ = getDefaultInstance().getQualifier();
        onChanged();
        return this;
      }

      private java.lang.Object fieldName_ = "";

      /**
       *
       *
       * <pre>
       * The field name to use for this column in the document. The name has to
       * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
       * If not set, it is parsed from the qualifier bytes with best effort.
       * However, due to different naming patterns, field name collisions could
       * happen, where parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 2;</code>
       *
       * @return The fieldName.
       */
      public java.lang.String getFieldName() {
        java.lang.Object ref = fieldName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column in the document. The name has to
       * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
       * If not set, it is parsed from the qualifier bytes with best effort.
       * However, due to different naming patterns, field name collisions could
       * happen, where parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 2;</code>
       *
       * @return The bytes for fieldName.
       */
      public com.google.protobuf.ByteString getFieldNameBytes() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column in the document. The name has to
       * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
       * If not set, it is parsed from the qualifier bytes with best effort.
       * However, due to different naming patterns, field name collisions could
       * happen, where parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 2;</code>
       *
       * @param value The fieldName to set.
       * @return This builder for chaining.
       */
      public Builder setFieldName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fieldName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column in the document. The name has to
       * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
       * If not set, it is parsed from the qualifier bytes with best effort.
       * However, due to different naming patterns, field name collisions could
       * happen, where parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFieldName() {
        fieldName_ = getDefaultInstance().getFieldName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The field name to use for this column in the document. The name has to
       * match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
       * If not set, it is parsed from the qualifier bytes with best effort.
       * However, due to different naming patterns, field name collisions could
       * happen, where parsing behavior is undefined.
       * </pre>
       *
       * <code>string field_name = 2;</code>
       *
       * @param value The bytes for fieldName to set.
       * @return This builder for chaining.
       */
      public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fieldName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int encoding_ = 0;

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not `STRING`.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
       *
       * @return The enum numeric value on the wire for encoding.
       */
      @java.lang.Override
      public int getEncodingValue() {
        return encoding_;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not `STRING`.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
       *
       * @param value The enum numeric value on the wire for encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncodingValue(int value) {
        encoding_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not `STRING`.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
       *
       * @return The encoding.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding getEncoding() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding result =
            com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.forNumber(encoding_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not `STRING`.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
       *
       * @param value The encoding to set.
       * @return This builder for chaining.
       */
      public Builder setEncoding(
          com.google.cloud.discoveryengine.v1.BigtableOptions.Encoding value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        encoding_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The encoding mode of the values when the type is not `STRING`.
       * Acceptable encoding values are:
       *
       * * `TEXT`: indicates values are alphanumeric text strings.
       * * `BINARY`: indicates values are encoded using `HBase Bytes.toBytes`
       * family of functions. This can be overridden for a specific column
       * by listing that column in `columns` and specifying an encoding for it.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Encoding encoding = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEncoding() {
        bitField0_ = (bitField0_ & ~0x00000004);
        encoding_ = 0;
        onChanged();
        return this;
      }

      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.Type getType() {
        com.google.cloud.discoveryengine.v1.BigtableOptions.Type result =
            com.google.cloud.discoveryengine.v1.BigtableOptions.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.BigtableOptions.Type.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.discoveryengine.v1.BigtableOptions.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        type_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of values in this column family.
       * The values are expected to be encoded using `HBase Bytes.toBytes`
       * function when the encoding value is set to `BINARY`.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.BigtableOptions.Type type = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000008);
        type_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn)
    private static final com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn();
    }

    public static com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigtableColumn> PARSER =
        new com.google.protobuf.AbstractParser<BigtableColumn>() {
          @java.lang.Override
          public BigtableColumn parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigtableColumn> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigtableColumn> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumn
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int KEY_FIELD_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyFieldName_ = "";

  /**
   *
   *
   * <pre>
   * The field name used for saving row key value in the document. The name has
   * to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
   * </pre>
   *
   * <code>string key_field_name = 1;</code>
   *
   * @return The keyFieldName.
   */
  @java.lang.Override
  public java.lang.String getKeyFieldName() {
    java.lang.Object ref = keyFieldName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyFieldName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The field name used for saving row key value in the document. The name has
   * to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
   * </pre>
   *
   * <code>string key_field_name = 1;</code>
   *
   * @return The bytes for keyFieldName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyFieldNameBytes() {
    java.lang.Object ref = keyFieldName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyFieldName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAMILIES_FIELD_NUMBER = 2;

  private static final class FamiliesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
                    newDefaultInstance(
                        com.google.cloud.discoveryengine.v1.ImportConfigProto
                            .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_FamiliesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
      families_;

  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
      internalGetFamilies() {
    if (families_ == null) {
      return com.google.protobuf.MapField.emptyMapField(FamiliesDefaultEntryHolder.defaultEntry);
    }
    return families_;
  }

  public int getFamiliesCount() {
    return internalGetFamilies().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * The mapping from family names to an object that contains column families
   * level information for the given column family. If a family is not present
   * in this map it will be ignored.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
   * </code>
   */
  @java.lang.Override
  public boolean containsFamilies(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetFamilies().getMap().containsKey(key);
  }

  /** Use {@link #getFamiliesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
      getFamilies() {
    return getFamiliesMap();
  }

  /**
   *
   *
   * <pre>
   * The mapping from family names to an object that contains column families
   * level information for the given column family. If a family is not present
   * in this map it will be ignored.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
      getFamiliesMap() {
    return internalGetFamilies().getMap();
  }

  /**
   *
   *
   * <pre>
   * The mapping from family names to an object that contains column families
   * level information for the given column family. If a family is not present
   * in this map it will be ignored.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
      getFamiliesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
        map = internalGetFamilies().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * The mapping from family names to an object that contains column families
   * level information for the given column family. If a family is not present
   * in this map it will be ignored.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
      getFamiliesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
        map = internalGetFamilies().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyFieldName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, keyFieldName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetFamilies(), FamiliesDefaultEntryHolder.defaultEntry, 2);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyFieldName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, keyFieldName_);
    }
    for (java.util.Map.Entry<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
        entry : internalGetFamilies().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
          families__ =
              FamiliesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, families__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.BigtableOptions)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.BigtableOptions other =
        (com.google.cloud.discoveryengine.v1.BigtableOptions) obj;

    if (!getKeyFieldName().equals(other.getKeyFieldName())) return false;
    if (!internalGetFamilies().equals(other.internalGetFamilies())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KEY_FIELD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKeyFieldName().hashCode();
    if (!internalGetFamilies().getMap().isEmpty()) {
      hash = (37 * hash) + FAMILIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFamilies().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.BigtableOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The Bigtable Options object that contains information to support
   * the import.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.BigtableOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.BigtableOptions)
      com.google.cloud.discoveryengine.v1.BigtableOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetFamilies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableFamilies();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.BigtableOptions.class,
              com.google.cloud.discoveryengine.v1.BigtableOptions.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.BigtableOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      keyFieldName_ = "";
      internalGetMutableFamilies().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_BigtableOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.BigtableOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions build() {
      com.google.cloud.discoveryengine.v1.BigtableOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions buildPartial() {
      com.google.cloud.discoveryengine.v1.BigtableOptions result =
          new com.google.cloud.discoveryengine.v1.BigtableOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.BigtableOptions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.keyFieldName_ = keyFieldName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.families_ = internalGetFamilies().build(FamiliesDefaultEntryHolder.defaultEntry);
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.BigtableOptions) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.BigtableOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.BigtableOptions other) {
      if (other == com.google.cloud.discoveryengine.v1.BigtableOptions.getDefaultInstance())
        return this;
      if (!other.getKeyFieldName().isEmpty()) {
        keyFieldName_ = other.keyFieldName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableFamilies().mergeFrom(other.internalGetFamilies());
      bitField0_ |= 0x00000002;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                keyFieldName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
                    families__ =
                        input.readMessage(
                            FamiliesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableFamilies()
                    .ensureBuilderMap()
                    .put(families__.getKey(), families__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object keyFieldName_ = "";

    /**
     *
     *
     * <pre>
     * The field name used for saving row key value in the document. The name has
     * to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * </pre>
     *
     * <code>string key_field_name = 1;</code>
     *
     * @return The keyFieldName.
     */
    public java.lang.String getKeyFieldName() {
      java.lang.Object ref = keyFieldName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyFieldName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The field name used for saving row key value in the document. The name has
     * to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * </pre>
     *
     * <code>string key_field_name = 1;</code>
     *
     * @return The bytes for keyFieldName.
     */
    public com.google.protobuf.ByteString getKeyFieldNameBytes() {
      java.lang.Object ref = keyFieldName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyFieldName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The field name used for saving row key value in the document. The name has
     * to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * </pre>
     *
     * <code>string key_field_name = 1;</code>
     *
     * @param value The keyFieldName to set.
     * @return This builder for chaining.
     */
    public Builder setKeyFieldName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyFieldName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The field name used for saving row key value in the document. The name has
     * to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * </pre>
     *
     * <code>string key_field_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyFieldName() {
      keyFieldName_ = getDefaultInstance().getKeyFieldName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The field name used for saving row key value in the document. The name has
     * to match the pattern `[a-zA-Z0-9][a-zA-Z0-9-_]*`.
     * </pre>
     *
     * <code>string key_field_name = 1;</code>
     *
     * @param value The bytes for keyFieldName to set.
     * @return This builder for chaining.
     */
    public Builder setKeyFieldNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyFieldName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private static final class FamiliesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily> {
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily build(
          com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder val) {
        if (val
            instanceof com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily) {
          return (com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily) val;
        }
        return ((com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder)
                val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
          defaultEntry() {
        return FamiliesDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final FamiliesConverter familiesConverter = new FamiliesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder>
        families_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder>
        internalGetFamilies() {
      if (families_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(familiesConverter);
      }
      return families_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder>
        internalGetMutableFamilies() {
      if (families_ == null) {
        families_ = new com.google.protobuf.MapFieldBuilder<>(familiesConverter);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return families_;
    }

    public int getFamiliesCount() {
      return internalGetFamilies().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    @java.lang.Override
    public boolean containsFamilies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFamilies().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getFamiliesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
        getFamilies() {
      return getFamiliesMap();
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
        getFamiliesMap() {
      return internalGetFamilies().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        getFamiliesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder>
          map = internalGetMutableFamilies().ensureBuilderMap();
      return map.containsKey(key) ? familiesConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily
        getFamiliesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder>
          map = internalGetMutableFamilies().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return familiesConverter.build(map.get(key));
    }

    public Builder clearFamilies() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableFamilies().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    public Builder removeFamilies(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableFamilies().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
        getMutableFamilies() {
      bitField0_ |= 0x00000002;
      return internalGetMutableFamilies().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    public Builder putFamilies(
        java.lang.String key,
        com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableFamilies().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    public Builder putAllFamilies(
        java.util.Map<
                java.lang.String,
                com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
            values) {
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableFamilies().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The mapping from family names to an object that contains column families
     * level information for the given column family. If a family is not present
     * in this map it will be ignored.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily&gt; families = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder
        putFamiliesBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder>
          builderMap = internalGetMutableFamilies().ensureBuilderMap();
      com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamilyOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry =
            com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry
          instanceof com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily) {
        entry =
            ((com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.discoveryengine.v1.BigtableOptions.BigtableColumnFamily.Builder)
          entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.BigtableOptions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.BigtableOptions)
  private static final com.google.cloud.discoveryengine.v1.BigtableOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.BigtableOptions();
  }

  public static com.google.cloud.discoveryengine.v1.BigtableOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigtableOptions> PARSER =
      new com.google.protobuf.AbstractParser<BigtableOptions>() {
        @java.lang.Override
        public BigtableOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigtableOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigtableOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.BigtableOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
