/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/chunk.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

public interface ChunkOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Chunk)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The full resource name of the chunk.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * The full resource name of the chunk.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document_id}/chunks/{chunk_id}`.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Unique chunk ID of the current chunk.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The id.
   */
  java.lang.String getId();

  /**
   *
   *
   * <pre>
   * Unique chunk ID of the current chunk.
   * </pre>
   *
   * <code>string id = 2;</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * Content is a string from a document (parsed content).
   * </pre>
   *
   * <code>string content = 3;</code>
   *
   * @return The content.
   */
  java.lang.String getContent();

  /**
   *
   *
   * <pre>
   * Content is a string from a document (parsed content).
   * </pre>
   *
   * <code>string content = 3;</code>
   *
   * @return The bytes for content.
   */
  com.google.protobuf.ByteString getContentBytes();

  /**
   *
   *
   * <pre>
   * Output only. Represents the relevance score based on similarity.
   * Higher score indicates higher chunk relevance.
   * The score is in range [-1.0, 1.0].
   * Only populated on
   * [SearchResponse][google.cloud.discoveryengine.v1.SearchResponse].
   * </pre>
   *
   * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the relevanceScore field is set.
   */
  boolean hasRelevanceScore();

  /**
   *
   *
   * <pre>
   * Output only. Represents the relevance score based on similarity.
   * Higher score indicates higher chunk relevance.
   * The score is in range [-1.0, 1.0].
   * Only populated on
   * [SearchResponse][google.cloud.discoveryengine.v1.SearchResponse].
   * </pre>
   *
   * <code>optional double relevance_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The relevanceScore.
   */
  double getRelevanceScore();

  /**
   *
   *
   * <pre>
   * Metadata of the document from the current chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
   *
   * @return Whether the documentMetadata field is set.
   */
  boolean hasDocumentMetadata();

  /**
   *
   *
   * <pre>
   * Metadata of the document from the current chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
   *
   * @return The documentMetadata.
   */
  com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata getDocumentMetadata();

  /**
   *
   *
   * <pre>
   * Metadata of the document from the current chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.DocumentMetadata document_metadata = 5;</code>
   */
  com.google.cloud.discoveryengine.v1.Chunk.DocumentMetadataOrBuilder
      getDocumentMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the derivedStructData field is set.
   */
  boolean hasDerivedStructData();

  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The derivedStructData.
   */
  com.google.protobuf.Struct getDerivedStructData();

  /**
   *
   *
   * <pre>
   * Output only. This field is OUTPUT_ONLY.
   * It contains derived data that are not in the original input document.
   * </pre>
   *
   * <code>
   * .google.protobuf.Struct derived_struct_data = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.StructOrBuilder getDerivedStructDataOrBuilder();

  /**
   *
   *
   * <pre>
   * Page span of the chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
   *
   * @return Whether the pageSpan field is set.
   */
  boolean hasPageSpan();

  /**
   *
   *
   * <pre>
   * Page span of the chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
   *
   * @return The pageSpan.
   */
  com.google.cloud.discoveryengine.v1.Chunk.PageSpan getPageSpan();

  /**
   *
   *
   * <pre>
   * Page span of the chunk.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Chunk.PageSpan page_span = 6;</code>
   */
  com.google.cloud.discoveryengine.v1.Chunk.PageSpanOrBuilder getPageSpanOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Metadata of the current chunk.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the chunkMetadata field is set.
   */
  boolean hasChunkMetadata();

  /**
   *
   *
   * <pre>
   * Output only. Metadata of the current chunk.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The chunkMetadata.
   */
  com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadata getChunkMetadata();

  /**
   *
   *
   * <pre>
   * Output only. Metadata of the current chunk.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Chunk.ChunkMetadata chunk_metadata = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.discoveryengine.v1.Chunk.ChunkMetadataOrBuilder getChunkMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Image Data URLs if the current chunk contains images.
   * Data URLs are composed of four parts: a prefix (data:), a MIME type
   * indicating the type of data, an optional base64 token if non-textual,
   * and the data itself:
   * data:[&lt;mediatype&gt;][;base64],&lt;data&gt;
   * </pre>
   *
   * <code>repeated string data_urls = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the dataUrls.
   */
  java.util.List<java.lang.String> getDataUrlsList();

  /**
   *
   *
   * <pre>
   * Output only. Image Data URLs if the current chunk contains images.
   * Data URLs are composed of four parts: a prefix (data:), a MIME type
   * indicating the type of data, an optional base64 token if non-textual,
   * and the data itself:
   * data:[&lt;mediatype&gt;][;base64],&lt;data&gt;
   * </pre>
   *
   * <code>repeated string data_urls = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of dataUrls.
   */
  int getDataUrlsCount();

  /**
   *
   *
   * <pre>
   * Output only. Image Data URLs if the current chunk contains images.
   * Data URLs are composed of four parts: a prefix (data:), a MIME type
   * indicating the type of data, an optional base64 token if non-textual,
   * and the data itself:
   * data:[&lt;mediatype&gt;][;base64],&lt;data&gt;
   * </pre>
   *
   * <code>repeated string data_urls = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The dataUrls at the given index.
   */
  java.lang.String getDataUrls(int index);

  /**
   *
   *
   * <pre>
   * Output only. Image Data URLs if the current chunk contains images.
   * Data URLs are composed of four parts: a prefix (data:), a MIME type
   * indicating the type of data, an optional base64 token if non-textual,
   * and the data itself:
   * data:[&lt;mediatype&gt;][;base64],&lt;data&gt;
   * </pre>
   *
   * <code>repeated string data_urls = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dataUrls at the given index.
   */
  com.google.protobuf.ByteString getDataUrlsBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. Annotation contents if the current chunk contains annotations.
   * </pre>
   *
   * <code>repeated string annotation_contents = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the annotationContents.
   */
  java.util.List<java.lang.String> getAnnotationContentsList();

  /**
   *
   *
   * <pre>
   * Output only. Annotation contents if the current chunk contains annotations.
   * </pre>
   *
   * <code>repeated string annotation_contents = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of annotationContents.
   */
  int getAnnotationContentsCount();

  /**
   *
   *
   * <pre>
   * Output only. Annotation contents if the current chunk contains annotations.
   * </pre>
   *
   * <code>repeated string annotation_contents = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The annotationContents at the given index.
   */
  java.lang.String getAnnotationContents(int index);

  /**
   *
   *
   * <pre>
   * Output only. Annotation contents if the current chunk contains annotations.
   * </pre>
   *
   * <code>repeated string annotation_contents = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the annotationContents at the given index.
   */
  com.google.protobuf.ByteString getAnnotationContentsBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The annotation metadata includes structured content in the
   * current chunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Chunk.AnnotationMetadata annotation_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.discoveryengine.v1.Chunk.AnnotationMetadata>
      getAnnotationMetadataList();

  /**
   *
   *
   * <pre>
   * Output only. The annotation metadata includes structured content in the
   * current chunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Chunk.AnnotationMetadata annotation_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.discoveryengine.v1.Chunk.AnnotationMetadata getAnnotationMetadata(int index);

  /**
   *
   *
   * <pre>
   * Output only. The annotation metadata includes structured content in the
   * current chunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Chunk.AnnotationMetadata annotation_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getAnnotationMetadataCount();

  /**
   *
   *
   * <pre>
   * Output only. The annotation metadata includes structured content in the
   * current chunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Chunk.AnnotationMetadata annotation_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.discoveryengine.v1.Chunk.AnnotationMetadataOrBuilder>
      getAnnotationMetadataOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. The annotation metadata includes structured content in the
   * current chunk.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.Chunk.AnnotationMetadata annotation_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.discoveryengine.v1.Chunk.AnnotationMetadataOrBuilder
      getAnnotationMetadataOrBuilder(int index);
}
