/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/cmek_config_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Configurations used to enable CMEK data encryption with Cloud KMS keys.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.CmekConfig}
 */
public final class CmekConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.CmekConfig)
    CmekConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CmekConfig.newBuilder() to construct.
  private CmekConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CmekConfig() {
    name_ = "";
    kmsKey_ = "";
    kmsKeyVersion_ = "";
    state_ = 0;
    singleRegionKeys_ = java.util.Collections.emptyList();
    notebooklmState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CmekConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.CmekConfigServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CmekConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.CmekConfigServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CmekConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.CmekConfig.class,
            com.google.cloud.discoveryengine.v1.CmekConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * States of the CmekConfig.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.CmekConfig.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The CmekConfig state is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The CmekConfig is creating.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The CmekConfig can be used with DataStores.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The CmekConfig is unavailable, most likely due to the KMS Key being
     * revoked.
     * </pre>
     *
     * <code>KEY_ISSUE = 3;</code>
     */
    KEY_ISSUE(3),
    /**
     *
     *
     * <pre>
     * The CmekConfig is deleting.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * The CmekConfig deletion process failed.
     * </pre>
     *
     * <code>DELETE_FAILED = 7;</code>
     */
    DELETE_FAILED(7),
    /**
     *
     *
     * <pre>
     * The CmekConfig is not usable, most likely due to some internal issue.
     * </pre>
     *
     * <code>UNUSABLE = 5;</code>
     */
    UNUSABLE(5),
    /**
     *
     *
     * <pre>
     * The KMS key version is being rotated.
     * </pre>
     *
     * <code>ACTIVE_ROTATING = 6;</code>
     */
    ACTIVE_ROTATING(6),
    /**
     *
     *
     * <pre>
     * The KMS key is soft deleted. Some cleanup policy will eventually be
     * applied.
     * </pre>
     *
     * <code>DELETED = 8;</code>
     */
    DELETED(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The CmekConfig state is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The CmekConfig is creating.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The CmekConfig can be used with DataStores.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The CmekConfig is unavailable, most likely due to the KMS Key being
     * revoked.
     * </pre>
     *
     * <code>KEY_ISSUE = 3;</code>
     */
    public static final int KEY_ISSUE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The CmekConfig is deleting.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;

    /**
     *
     *
     * <pre>
     * The CmekConfig deletion process failed.
     * </pre>
     *
     * <code>DELETE_FAILED = 7;</code>
     */
    public static final int DELETE_FAILED_VALUE = 7;

    /**
     *
     *
     * <pre>
     * The CmekConfig is not usable, most likely due to some internal issue.
     * </pre>
     *
     * <code>UNUSABLE = 5;</code>
     */
    public static final int UNUSABLE_VALUE = 5;

    /**
     *
     *
     * <pre>
     * The KMS key version is being rotated.
     * </pre>
     *
     * <code>ACTIVE_ROTATING = 6;</code>
     */
    public static final int ACTIVE_ROTATING_VALUE = 6;

    /**
     *
     *
     * <pre>
     * The KMS key is soft deleted. Some cleanup policy will eventually be
     * applied.
     * </pre>
     *
     * <code>DELETED = 8;</code>
     */
    public static final int DELETED_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return KEY_ISSUE;
        case 4:
          return DELETING;
        case 7:
          return DELETE_FAILED;
        case 5:
          return UNUSABLE;
        case 6:
          return ACTIVE_ROTATING;
        case 8:
          return DELETED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CmekConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.CmekConfig.State)
  }

  /**
   *
   *
   * <pre>
   * States of NotebookLM.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState}
   */
  public enum NotebookLMState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The NotebookLM state is unknown.
     * </pre>
     *
     * <code>NOTEBOOK_LM_STATE_UNSPECIFIED = 0;</code>
     */
    NOTEBOOK_LM_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The NotebookLM is not ready.
     * </pre>
     *
     * <code>NOTEBOOK_LM_NOT_READY = 1;</code>
     */
    NOTEBOOK_LM_NOT_READY(1),
    /**
     *
     *
     * <pre>
     * The NotebookLM is ready to be used.
     * </pre>
     *
     * <code>NOTEBOOK_LM_READY = 2;</code>
     */
    NOTEBOOK_LM_READY(2),
    /**
     *
     *
     * <pre>
     * The NotebookLM is not enabled.
     * </pre>
     *
     * <code>NOTEBOOK_LM_NOT_ENABLED = 3;</code>
     */
    NOTEBOOK_LM_NOT_ENABLED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The NotebookLM state is unknown.
     * </pre>
     *
     * <code>NOTEBOOK_LM_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int NOTEBOOK_LM_STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The NotebookLM is not ready.
     * </pre>
     *
     * <code>NOTEBOOK_LM_NOT_READY = 1;</code>
     */
    public static final int NOTEBOOK_LM_NOT_READY_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The NotebookLM is ready to be used.
     * </pre>
     *
     * <code>NOTEBOOK_LM_READY = 2;</code>
     */
    public static final int NOTEBOOK_LM_READY_VALUE = 2;

    /**
     *
     *
     * <pre>
     * The NotebookLM is not enabled.
     * </pre>
     *
     * <code>NOTEBOOK_LM_NOT_ENABLED = 3;</code>
     */
    public static final int NOTEBOOK_LM_NOT_ENABLED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NotebookLMState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NotebookLMState forNumber(int value) {
      switch (value) {
        case 0:
          return NOTEBOOK_LM_STATE_UNSPECIFIED;
        case 1:
          return NOTEBOOK_LM_NOT_READY;
        case 2:
          return NOTEBOOK_LM_READY;
        case 3:
          return NOTEBOOK_LM_NOT_ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NotebookLMState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NotebookLMState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<NotebookLMState>() {
              public NotebookLMState findValueByNumber(int number) {
                return NotebookLMState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CmekConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final NotebookLMState[] VALUES = values();

    public static NotebookLMState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NotebookLMState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the CmekConfig of the form
   * `projects/{project}/locations/{location}/cmekConfig` or
   * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the CmekConfig of the form
   * `projects/{project}/locations/{location}/cmekConfig` or
   * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";

  /**
   *
   *
   * <pre>
   * KMS key resource name which will be used to encrypt resources
   * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
   * </pre>
   *
   * <code>string kms_key = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * KMS key resource name which will be used to encrypt resources
   * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
   * </pre>
   *
   * <code>string kms_key = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_VERSION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyVersion_ = "";

  /**
   *
   *
   * <pre>
   * KMS key version resource name which will be used to encrypt resources
   * `&lt;kms_key&gt;/cryptoKeyVersions/{keyVersion}`.
   * </pre>
   *
   * <code>string kms_key_version = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyVersion.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyVersion() {
    java.lang.Object ref = kmsKeyVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyVersion_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * KMS key version resource name which will be used to encrypt resources
   * `&lt;kms_key&gt;/cryptoKeyVersions/{keyVersion}`.
   * </pre>
   *
   * <code>string kms_key_version = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyVersionBytes() {
    java.lang.Object ref = kmsKeyVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The states of the CmekConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The states of the CmekConfig.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CmekConfig.State getState() {
    com.google.cloud.discoveryengine.v1.CmekConfig.State result =
        com.google.cloud.discoveryengine.v1.CmekConfig.State.forNumber(state_);
    return result == null
        ? com.google.cloud.discoveryengine.v1.CmekConfig.State.UNRECOGNIZED
        : result;
  }

  public static final int IS_DEFAULT_FIELD_NUMBER = 4;
  private boolean isDefault_ = false;

  /**
   *
   *
   * <pre>
   * Output only. The default CmekConfig for the Customer.
   * </pre>
   *
   * <code>bool is_default = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The isDefault.
   */
  @java.lang.Override
  public boolean getIsDefault() {
    return isDefault_;
  }

  public static final int LAST_ROTATION_TIMESTAMP_MICROS_FIELD_NUMBER = 5;
  private long lastRotationTimestampMicros_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. The timestamp of the last key rotation.
   * </pre>
   *
   * <code>int64 last_rotation_timestamp_micros = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastRotationTimestampMicros.
   */
  @java.lang.Override
  public long getLastRotationTimestampMicros() {
    return lastRotationTimestampMicros_;
  }

  public static final int SINGLE_REGION_KEYS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.SingleRegionKey> singleRegionKeys_;

  /**
   *
   *
   * <pre>
   * Optional. Single-regional CMEKs that are required for some VAIS features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.SingleRegionKey>
      getSingleRegionKeysList() {
    return singleRegionKeys_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Single-regional CMEKs that are required for some VAIS features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.SingleRegionKeyOrBuilder>
      getSingleRegionKeysOrBuilderList() {
    return singleRegionKeys_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Single-regional CMEKs that are required for some VAIS features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSingleRegionKeysCount() {
    return singleRegionKeys_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Single-regional CMEKs that are required for some VAIS features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SingleRegionKey getSingleRegionKeys(int index) {
    return singleRegionKeys_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Single-regional CMEKs that are required for some VAIS features.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SingleRegionKeyOrBuilder getSingleRegionKeysOrBuilder(
      int index) {
    return singleRegionKeys_.get(index);
  }

  public static final int NOTEBOOKLM_STATE_FIELD_NUMBER = 8;
  private int notebooklmState_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Whether the NotebookLM Corpus is ready to be used.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for notebooklmState.
   */
  @java.lang.Override
  public int getNotebooklmStateValue() {
    return notebooklmState_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Whether the NotebookLM Corpus is ready to be used.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The notebooklmState.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState getNotebooklmState() {
    com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState result =
        com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState.forNumber(notebooklmState_);
    return result == null
        ? com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kmsKey_);
    }
    if (state_
        != com.google.cloud.discoveryengine.v1.CmekConfig.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (isDefault_ != false) {
      output.writeBool(4, isDefault_);
    }
    if (lastRotationTimestampMicros_ != 0L) {
      output.writeInt64(5, lastRotationTimestampMicros_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, kmsKeyVersion_);
    }
    for (int i = 0; i < singleRegionKeys_.size(); i++) {
      output.writeMessage(7, singleRegionKeys_.get(i));
    }
    if (notebooklmState_
        != com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState
            .NOTEBOOK_LM_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, notebooklmState_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kmsKey_);
    }
    if (state_
        != com.google.cloud.discoveryengine.v1.CmekConfig.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (isDefault_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, isDefault_);
    }
    if (lastRotationTimestampMicros_ != 0L) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(5, lastRotationTimestampMicros_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, kmsKeyVersion_);
    }
    for (int i = 0; i < singleRegionKeys_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, singleRegionKeys_.get(i));
    }
    if (notebooklmState_
        != com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState
            .NOTEBOOK_LM_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, notebooklmState_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.CmekConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.CmekConfig other =
        (com.google.cloud.discoveryengine.v1.CmekConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (!getKmsKeyVersion().equals(other.getKmsKeyVersion())) return false;
    if (state_ != other.state_) return false;
    if (getIsDefault() != other.getIsDefault()) return false;
    if (getLastRotationTimestampMicros() != other.getLastRotationTimestampMicros()) return false;
    if (!getSingleRegionKeysList().equals(other.getSingleRegionKeysList())) return false;
    if (notebooklmState_ != other.notebooklmState_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    hash = (37 * hash) + KMS_KEY_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyVersion().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + IS_DEFAULT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDefault());
    hash = (37 * hash) + LAST_ROTATION_TIMESTAMP_MICROS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLastRotationTimestampMicros());
    if (getSingleRegionKeysCount() > 0) {
      hash = (37 * hash) + SINGLE_REGION_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getSingleRegionKeysList().hashCode();
    }
    hash = (37 * hash) + NOTEBOOKLM_STATE_FIELD_NUMBER;
    hash = (53 * hash) + notebooklmState_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.CmekConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configurations used to enable CMEK data encryption with Cloud KMS keys.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.CmekConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.CmekConfig)
      com.google.cloud.discoveryengine.v1.CmekConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CmekConfigServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CmekConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.CmekConfigServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CmekConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.CmekConfig.class,
              com.google.cloud.discoveryengine.v1.CmekConfig.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.CmekConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      kmsKey_ = "";
      kmsKeyVersion_ = "";
      state_ = 0;
      isDefault_ = false;
      lastRotationTimestampMicros_ = 0L;
      if (singleRegionKeysBuilder_ == null) {
        singleRegionKeys_ = java.util.Collections.emptyList();
      } else {
        singleRegionKeys_ = null;
        singleRegionKeysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      notebooklmState_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.CmekConfigServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CmekConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CmekConfig getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.CmekConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CmekConfig build() {
      com.google.cloud.discoveryengine.v1.CmekConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CmekConfig buildPartial() {
      com.google.cloud.discoveryengine.v1.CmekConfig result =
          new com.google.cloud.discoveryengine.v1.CmekConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.discoveryengine.v1.CmekConfig result) {
      if (singleRegionKeysBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          singleRegionKeys_ = java.util.Collections.unmodifiableList(singleRegionKeys_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.singleRegionKeys_ = singleRegionKeys_;
      } else {
        result.singleRegionKeys_ = singleRegionKeysBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.CmekConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kmsKeyVersion_ = kmsKeyVersion_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.isDefault_ = isDefault_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.lastRotationTimestampMicros_ = lastRotationTimestampMicros_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.notebooklmState_ = notebooklmState_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.CmekConfig) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.CmekConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.CmekConfig other) {
      if (other == com.google.cloud.discoveryengine.v1.CmekConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getKmsKeyVersion().isEmpty()) {
        kmsKeyVersion_ = other.kmsKeyVersion_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getIsDefault() != false) {
        setIsDefault(other.getIsDefault());
      }
      if (other.getLastRotationTimestampMicros() != 0L) {
        setLastRotationTimestampMicros(other.getLastRotationTimestampMicros());
      }
      if (singleRegionKeysBuilder_ == null) {
        if (!other.singleRegionKeys_.isEmpty()) {
          if (singleRegionKeys_.isEmpty()) {
            singleRegionKeys_ = other.singleRegionKeys_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureSingleRegionKeysIsMutable();
            singleRegionKeys_.addAll(other.singleRegionKeys_);
          }
          onChanged();
        }
      } else {
        if (!other.singleRegionKeys_.isEmpty()) {
          if (singleRegionKeysBuilder_.isEmpty()) {
            singleRegionKeysBuilder_.dispose();
            singleRegionKeysBuilder_ = null;
            singleRegionKeys_ = other.singleRegionKeys_;
            bitField0_ = (bitField0_ & ~0x00000040);
            singleRegionKeysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSingleRegionKeysFieldBuilder()
                    : null;
          } else {
            singleRegionKeysBuilder_.addAllMessages(other.singleRegionKeys_);
          }
        }
      }
      if (other.notebooklmState_ != 0) {
        setNotebooklmStateValue(other.getNotebooklmStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 32:
              {
                isDefault_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 40:
              {
                lastRotationTimestampMicros_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                kmsKeyVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.discoveryengine.v1.SingleRegionKey m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.SingleRegionKey.parser(),
                        extensionRegistry);
                if (singleRegionKeysBuilder_ == null) {
                  ensureSingleRegionKeysIsMutable();
                  singleRegionKeys_.add(m);
                } else {
                  singleRegionKeysBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 64:
              {
                notebooklmState_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the CmekConfig of the form
     * `projects/{project}/locations/{location}/cmekConfig` or
     * `projects/{project}/locations/{location}/cmekConfigs/{cmek_config}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";

    /**
     *
     *
     * <pre>
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     * </pre>
     *
     * <code>string kms_key = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     * </pre>
     *
     * <code>string kms_key = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     * </pre>
     *
     * <code>string kms_key = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     * </pre>
     *
     * <code>string kms_key = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * KMS key resource name which will be used to encrypt resources
     * `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{keyId}`.
     * </pre>
     *
     * <code>string kms_key = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyVersion_ = "";

    /**
     *
     *
     * <pre>
     * KMS key version resource name which will be used to encrypt resources
     * `&lt;kms_key&gt;/cryptoKeyVersions/{keyVersion}`.
     * </pre>
     *
     * <code>string kms_key_version = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyVersion.
     */
    public java.lang.String getKmsKeyVersion() {
      java.lang.Object ref = kmsKeyVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * KMS key version resource name which will be used to encrypt resources
     * `&lt;kms_key&gt;/cryptoKeyVersions/{keyVersion}`.
     * </pre>
     *
     * <code>string kms_key_version = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyVersion.
     */
    public com.google.protobuf.ByteString getKmsKeyVersionBytes() {
      java.lang.Object ref = kmsKeyVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * KMS key version resource name which will be used to encrypt resources
     * `&lt;kms_key&gt;/cryptoKeyVersions/{keyVersion}`.
     * </pre>
     *
     * <code>string kms_key_version = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * KMS key version resource name which will be used to encrypt resources
     * `&lt;kms_key&gt;/cryptoKeyVersions/{keyVersion}`.
     * </pre>
     *
     * <code>string kms_key_version = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyVersion() {
      kmsKeyVersion_ = getDefaultInstance().getKmsKeyVersion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * KMS key version resource name which will be used to encrypt resources
     * `&lt;kms_key&gt;/cryptoKeyVersions/{keyVersion}`.
     * </pre>
     *
     * <code>string kms_key_version = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKeyVersion to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyVersion_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The states of the CmekConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The states of the CmekConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The states of the CmekConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CmekConfig.State getState() {
      com.google.cloud.discoveryengine.v1.CmekConfig.State result =
          com.google.cloud.discoveryengine.v1.CmekConfig.State.forNumber(state_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.CmekConfig.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The states of the CmekConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.discoveryengine.v1.CmekConfig.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The states of the CmekConfig.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private boolean isDefault_;

    /**
     *
     *
     * <pre>
     * Output only. The default CmekConfig for the Customer.
     * </pre>
     *
     * <code>bool is_default = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isDefault.
     */
    @java.lang.Override
    public boolean getIsDefault() {
      return isDefault_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The default CmekConfig for the Customer.
     * </pre>
     *
     * <code>bool is_default = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The isDefault to set.
     * @return This builder for chaining.
     */
    public Builder setIsDefault(boolean value) {

      isDefault_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The default CmekConfig for the Customer.
     * </pre>
     *
     * <code>bool is_default = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsDefault() {
      bitField0_ = (bitField0_ & ~0x00000010);
      isDefault_ = false;
      onChanged();
      return this;
    }

    private long lastRotationTimestampMicros_;

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last key rotation.
     * </pre>
     *
     * <code>int64 last_rotation_timestamp_micros = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastRotationTimestampMicros.
     */
    @java.lang.Override
    public long getLastRotationTimestampMicros() {
      return lastRotationTimestampMicros_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last key rotation.
     * </pre>
     *
     * <code>int64 last_rotation_timestamp_micros = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lastRotationTimestampMicros to set.
     * @return This builder for chaining.
     */
    public Builder setLastRotationTimestampMicros(long value) {

      lastRotationTimestampMicros_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The timestamp of the last key rotation.
     * </pre>
     *
     * <code>int64 last_rotation_timestamp_micros = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastRotationTimestampMicros() {
      bitField0_ = (bitField0_ & ~0x00000020);
      lastRotationTimestampMicros_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.SingleRegionKey> singleRegionKeys_ =
        java.util.Collections.emptyList();

    private void ensureSingleRegionKeysIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        singleRegionKeys_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.SingleRegionKey>(
                singleRegionKeys_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SingleRegionKey,
            com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder,
            com.google.cloud.discoveryengine.v1.SingleRegionKeyOrBuilder>
        singleRegionKeysBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.SingleRegionKey>
        getSingleRegionKeysList() {
      if (singleRegionKeysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(singleRegionKeys_);
      } else {
        return singleRegionKeysBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSingleRegionKeysCount() {
      if (singleRegionKeysBuilder_ == null) {
        return singleRegionKeys_.size();
      } else {
        return singleRegionKeysBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SingleRegionKey getSingleRegionKeys(int index) {
      if (singleRegionKeysBuilder_ == null) {
        return singleRegionKeys_.get(index);
      } else {
        return singleRegionKeysBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSingleRegionKeys(
        int index, com.google.cloud.discoveryengine.v1.SingleRegionKey value) {
      if (singleRegionKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSingleRegionKeysIsMutable();
        singleRegionKeys_.set(index, value);
        onChanged();
      } else {
        singleRegionKeysBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSingleRegionKeys(
        int index, com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder builderForValue) {
      if (singleRegionKeysBuilder_ == null) {
        ensureSingleRegionKeysIsMutable();
        singleRegionKeys_.set(index, builderForValue.build());
        onChanged();
      } else {
        singleRegionKeysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSingleRegionKeys(com.google.cloud.discoveryengine.v1.SingleRegionKey value) {
      if (singleRegionKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSingleRegionKeysIsMutable();
        singleRegionKeys_.add(value);
        onChanged();
      } else {
        singleRegionKeysBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSingleRegionKeys(
        int index, com.google.cloud.discoveryengine.v1.SingleRegionKey value) {
      if (singleRegionKeysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSingleRegionKeysIsMutable();
        singleRegionKeys_.add(index, value);
        onChanged();
      } else {
        singleRegionKeysBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSingleRegionKeys(
        com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder builderForValue) {
      if (singleRegionKeysBuilder_ == null) {
        ensureSingleRegionKeysIsMutable();
        singleRegionKeys_.add(builderForValue.build());
        onChanged();
      } else {
        singleRegionKeysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSingleRegionKeys(
        int index, com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder builderForValue) {
      if (singleRegionKeysBuilder_ == null) {
        ensureSingleRegionKeysIsMutable();
        singleRegionKeys_.add(index, builderForValue.build());
        onChanged();
      } else {
        singleRegionKeysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSingleRegionKeys(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.SingleRegionKey> values) {
      if (singleRegionKeysBuilder_ == null) {
        ensureSingleRegionKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, singleRegionKeys_);
        onChanged();
      } else {
        singleRegionKeysBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSingleRegionKeys() {
      if (singleRegionKeysBuilder_ == null) {
        singleRegionKeys_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        singleRegionKeysBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSingleRegionKeys(int index) {
      if (singleRegionKeysBuilder_ == null) {
        ensureSingleRegionKeysIsMutable();
        singleRegionKeys_.remove(index);
        onChanged();
      } else {
        singleRegionKeysBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder getSingleRegionKeysBuilder(
        int index) {
      return getSingleRegionKeysFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SingleRegionKeyOrBuilder
        getSingleRegionKeysOrBuilder(int index) {
      if (singleRegionKeysBuilder_ == null) {
        return singleRegionKeys_.get(index);
      } else {
        return singleRegionKeysBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.SingleRegionKeyOrBuilder>
        getSingleRegionKeysOrBuilderList() {
      if (singleRegionKeysBuilder_ != null) {
        return singleRegionKeysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(singleRegionKeys_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder
        addSingleRegionKeysBuilder() {
      return getSingleRegionKeysFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1.SingleRegionKey.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder addSingleRegionKeysBuilder(
        int index) {
      return getSingleRegionKeysFieldBuilder()
          .addBuilder(
              index, com.google.cloud.discoveryengine.v1.SingleRegionKey.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Single-regional CMEKs that are required for some VAIS features.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SingleRegionKey single_region_keys = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder>
        getSingleRegionKeysBuilderList() {
      return getSingleRegionKeysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.SingleRegionKey,
            com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder,
            com.google.cloud.discoveryengine.v1.SingleRegionKeyOrBuilder>
        getSingleRegionKeysFieldBuilder() {
      if (singleRegionKeysBuilder_ == null) {
        singleRegionKeysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.SingleRegionKey,
                com.google.cloud.discoveryengine.v1.SingleRegionKey.Builder,
                com.google.cloud.discoveryengine.v1.SingleRegionKeyOrBuilder>(
                singleRegionKeys_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        singleRegionKeys_ = null;
      }
      return singleRegionKeysBuilder_;
    }

    private int notebooklmState_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for notebooklmState.
     */
    @java.lang.Override
    public int getNotebooklmStateValue() {
      return notebooklmState_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for notebooklmState to set.
     * @return This builder for chaining.
     */
    public Builder setNotebooklmStateValue(int value) {
      notebooklmState_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The notebooklmState.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState getNotebooklmState() {
      com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState result =
          com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState.forNumber(
              notebooklmState_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The notebooklmState to set.
     * @return This builder for chaining.
     */
    public Builder setNotebooklmState(
        com.google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      notebooklmState_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Whether the NotebookLM Corpus is ready to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig.NotebookLMState notebooklm_state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNotebooklmState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      notebooklmState_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.CmekConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.CmekConfig)
  private static final com.google.cloud.discoveryengine.v1.CmekConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.CmekConfig();
  }

  public static com.google.cloud.discoveryengine.v1.CmekConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CmekConfig> PARSER =
      new com.google.protobuf.AbstractParser<CmekConfig>() {
        @java.lang.Override
        public CmekConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CmekConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CmekConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CmekConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
