/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/user_event_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

public interface CollectUserEventRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.CollectUserEventRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The parent resource name.
   * If the collect user event action is applied in
   * [DataStore][google.cloud.discoveryengine.v1.DataStore] level, the format
   * is:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.
   * If the collect user event action is applied in
   * [Location][google.cloud.location.Location] level, for example, the event
   * with [Document][google.cloud.discoveryengine.v1.Document] across multiple
   * [DataStore][google.cloud.discoveryengine.v1.DataStore], the format is:
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The parent resource name.
   * If the collect user event action is applied in
   * [DataStore][google.cloud.discoveryengine.v1.DataStore] level, the format
   * is:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.
   * If the collect user event action is applied in
   * [Location][google.cloud.location.Location] level, for example, the event
   * with [Document][google.cloud.discoveryengine.v1.Document] across multiple
   * [DataStore][google.cloud.discoveryengine.v1.DataStore], the format is:
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. URL encoded UserEvent proto with a length limit of 2,000,000
   * characters.
   * </pre>
   *
   * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The userEvent.
   */
  java.lang.String getUserEvent();

  /**
   *
   *
   * <pre>
   * Required. URL encoded UserEvent proto with a length limit of 2,000,000
   * characters.
   * </pre>
   *
   * <code>string user_event = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for userEvent.
   */
  com.google.protobuf.ByteString getUserEventBytes();

  /**
   *
   *
   * <pre>
   * The URL including cgi-parameters but excluding the hash fragment with a
   * length limit of 5,000 characters. This is often more useful than the
   * referer URL, because many browsers only send the domain for third-party
   * requests.
   * </pre>
   *
   * <code>optional string uri = 3;</code>
   *
   * @return Whether the uri field is set.
   */
  boolean hasUri();

  /**
   *
   *
   * <pre>
   * The URL including cgi-parameters but excluding the hash fragment with a
   * length limit of 5,000 characters. This is often more useful than the
   * referer URL, because many browsers only send the domain for third-party
   * requests.
   * </pre>
   *
   * <code>optional string uri = 3;</code>
   *
   * @return The uri.
   */
  java.lang.String getUri();

  /**
   *
   *
   * <pre>
   * The URL including cgi-parameters but excluding the hash fragment with a
   * length limit of 5,000 characters. This is often more useful than the
   * referer URL, because many browsers only send the domain for third-party
   * requests.
   * </pre>
   *
   * <code>optional string uri = 3;</code>
   *
   * @return The bytes for uri.
   */
  com.google.protobuf.ByteString getUriBytes();

  /**
   *
   *
   * <pre>
   * The event timestamp in milliseconds. This prevents browser caching of
   * otherwise identical get requests. The name is abbreviated to reduce the
   * payload bytes.
   * </pre>
   *
   * <code>optional int64 ets = 4;</code>
   *
   * @return Whether the ets field is set.
   */
  boolean hasEts();

  /**
   *
   *
   * <pre>
   * The event timestamp in milliseconds. This prevents browser caching of
   * otherwise identical get requests. The name is abbreviated to reduce the
   * payload bytes.
   * </pre>
   *
   * <code>optional int64 ets = 4;</code>
   *
   * @return The ets.
   */
  long getEts();
}
