/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/control.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Defines a conditioned behavior to employ during serving.
 * Must be attached to a
 * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] to be
 * considered at serving time. Permitted actions dependent on `SolutionType`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.Control}
 */
public final class Control extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control)
    ControlOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Control.newBuilder() to construct.
  private Control(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Control() {
    name_ = "";
    displayName_ = "";
    associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    solutionType_ = 0;
    useCases_ = java.util.Collections.emptyList();
    conditions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Control();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.ControlProto
        .internal_static_google_cloud_discoveryengine_v1_Control_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.ControlProto
        .internal_static_google_cloud_discoveryengine_v1_Control_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.Control.class,
            com.google.cloud.discoveryengine.v1.Control.Builder.class);
  }

  public interface BoostActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Control.BoostAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the fixedBoost field is set.
     */
    boolean hasFixedBoost();

    /**
     *
     *
     * <pre>
     * Optional. Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The fixedBoost.
     */
    float getFixedBoost();

    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the interpolationBoostSpec field is set.
     */
    boolean hasInterpolationBoostSpec();

    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The interpolationBoostSpec.
     */
    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
        getInterpolationBoostSpec();

    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpecOrBuilder
        getInterpolationBoostSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float boost = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.discoveryengine.v1.Control.BoostAction.boost is deprecated. See
     *     google/cloud/discoveryengine/v1/control.proto;l=187
     * @return The boost.
     */
    @java.lang.Deprecated
    float getBoost();

    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();

    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();

    com.google.cloud.discoveryengine.v1.Control.BoostAction.BoostSpecCase getBoostSpecCase();
  }

  /**
   *
   *
   * <pre>
   * Adjusts order of products in returned list.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Control.BoostAction}
   */
  public static final class BoostAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control.BoostAction)
      BoostActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use BoostAction.newBuilder() to construct.
    private BoostAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BoostAction() {
      filter_ = "";
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BoostAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Control.BoostAction.class,
              com.google.cloud.discoveryengine.v1.Control.BoostAction.Builder.class);
    }

    public interface InterpolationBoostSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fieldName.
       */
      java.lang.String getFieldName();

      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for fieldName.
       */
      com.google.protobuf.ByteString getFieldNameBytes();

      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for attributeType.
       */
      int getAttributeTypeValue();

      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The attributeType.
       */
      com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType
          getAttributeType();

      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for interpolationType.
       */
      int getInterpolationTypeValue();

      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The interpolationType.
       */
      com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .InterpolationType
          getInterpolationType();

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint>
          getControlPointsList();

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint
          getControlPoints(int index);

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      int getControlPointsCount();

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPointOrBuilder>
          getControlPointsOrBuilderList();

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .ControlPointOrBuilder
          getControlPointsOrBuilder(int index);
    }

    /**
     *
     *
     * <pre>
     * Specification for custom ranking based on customer specified attribute
     * value. It provides more controls for customized ranking than the simple
     * (condition, boost) combination above.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec}
     */
    public static final class InterpolationBoostSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
        InterpolationBoostSpecOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use InterpolationBoostSpec.newBuilder() to construct.
      private InterpolationBoostSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private InterpolationBoostSpec() {
        fieldName_ = "";
        attributeType_ = 0;
        interpolationType_ = 0;
        controlPoints_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new InterpolationBoostSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .class,
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .Builder.class);
      }

      /**
       *
       *
       * <pre>
       * The attribute(or function) for which the custom ranking is to be
       * applied.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType}
       */
      public enum AttributeType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified AttributeType.
         * </pre>
         *
         * <code>ATTRIBUTE_TYPE_UNSPECIFIED = 0;</code>
         */
        ATTRIBUTE_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * The value of the numerical field will be used to dynamically update
         * the boost amount. In this case, the attribute_value (the x value)
         * of the control point will be the actual value of the numerical
         * field for which the boost_amount is specified.
         * </pre>
         *
         * <code>NUMERICAL = 1;</code>
         */
        NUMERICAL(1),
        /**
         *
         *
         * <pre>
         * For the freshness use case the attribute value will be the duration
         * between the current time and the date in the datetime field
         * specified. The value must be formatted as an XSD `dayTimeDuration`
         * value (a restricted subset of an ISO 8601 duration value). The
         * pattern for this is: `[nD][T[nH][nM][nS]]`.
         * For example, `5D`, `3DT12H30M`, `T24H`.
         * </pre>
         *
         * <code>FRESHNESS = 2;</code>
         */
        FRESHNESS(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified AttributeType.
         * </pre>
         *
         * <code>ATTRIBUTE_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int ATTRIBUTE_TYPE_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * The value of the numerical field will be used to dynamically update
         * the boost amount. In this case, the attribute_value (the x value)
         * of the control point will be the actual value of the numerical
         * field for which the boost_amount is specified.
         * </pre>
         *
         * <code>NUMERICAL = 1;</code>
         */
        public static final int NUMERICAL_VALUE = 1;

        /**
         *
         *
         * <pre>
         * For the freshness use case the attribute value will be the duration
         * between the current time and the date in the datetime field
         * specified. The value must be formatted as an XSD `dayTimeDuration`
         * value (a restricted subset of an ISO 8601 duration value). The
         * pattern for this is: `[nD][T[nH][nM][nS]]`.
         * For example, `5D`, `3DT12H30M`, `T24H`.
         * </pre>
         *
         * <code>FRESHNESS = 2;</code>
         */
        public static final int FRESHNESS_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static AttributeType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static AttributeType forNumber(int value) {
          switch (value) {
            case 0:
              return ATTRIBUTE_TYPE_UNSPECIFIED;
            case 1:
              return NUMERICAL;
            case 2:
              return FRESHNESS;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<AttributeType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<AttributeType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<AttributeType>() {
                  public AttributeType findValueByNumber(int number) {
                    return AttributeType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final AttributeType[] VALUES = values();

        public static AttributeType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private AttributeType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType)
      }

      /**
       *
       *
       * <pre>
       * The interpolation type to be applied. Default will be linear
       * (Piecewise Linear).
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType}
       */
      public enum InterpolationType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Interpolation type is unspecified. In this case, it defaults to
         * Linear.
         * </pre>
         *
         * <code>INTERPOLATION_TYPE_UNSPECIFIED = 0;</code>
         */
        INTERPOLATION_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Piecewise linear interpolation will be applied.
         * </pre>
         *
         * <code>LINEAR = 1;</code>
         */
        LINEAR(1),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Interpolation type is unspecified. In this case, it defaults to
         * Linear.
         * </pre>
         *
         * <code>INTERPOLATION_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int INTERPOLATION_TYPE_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * Piecewise linear interpolation will be applied.
         * </pre>
         *
         * <code>LINEAR = 1;</code>
         */
        public static final int LINEAR_VALUE = 1;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static InterpolationType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static InterpolationType forNumber(int value) {
          switch (value) {
            case 0:
              return INTERPOLATION_TYPE_UNSPECIFIED;
            case 1:
              return LINEAR;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<InterpolationType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<InterpolationType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<InterpolationType>() {
                  public InterpolationType findValueByNumber(int number) {
                    return InterpolationType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .getDescriptor()
              .getEnumTypes()
              .get(1);
        }

        private static final InterpolationType[] VALUES = values();

        public static InterpolationType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private InterpolationType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType)
      }

      public interface ControlPointOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The attributeValue.
         */
        java.lang.String getAttributeValue();

        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for attributeValue.
         */
        com.google.protobuf.ByteString getAttributeValueBytes();

        /**
         *
         *
         * <pre>
         * Optional. The value between -1 to 1 by which to boost the score if
         * the attribute_value evaluates to the value specified above.
         * </pre>
         *
         * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The boostAmount.
         */
        float getBoostAmount();
      }

      /**
       *
       *
       * <pre>
       * The control points used to define the curve. The curve defined
       * through these control points can only be monotonically increasing
       * or decreasing(constant values are acceptable).
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint}
       */
      public static final class ControlPoint extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint)
          ControlPointOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use ControlPoint.newBuilder() to construct.
        private ControlPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ControlPoint() {
          attributeValue_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ControlPoint();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.ControlProto
              .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_ControlPoint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.ControlProto
              .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_ControlPoint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPoint.class,
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPoint.Builder.class);
        }

        public static final int ATTRIBUTE_VALUE_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object attributeValue_ = "";

        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The attributeValue.
         */
        @java.lang.Override
        public java.lang.String getAttributeValue() {
          java.lang.Object ref = attributeValue_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            attributeValue_ = s;
            return s;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. Can be one of:
         * 1. The numerical field value.
         * 2. The duration spec for freshness:
         * The value must be formatted as an XSD `dayTimeDuration` value (a
         * restricted subset of an ISO 8601 duration value). The pattern for
         * this is: `[nD][T[nH][nM][nS]]`.
         * </pre>
         *
         * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for attributeValue.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getAttributeValueBytes() {
          java.lang.Object ref = attributeValue_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            attributeValue_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int BOOST_AMOUNT_FIELD_NUMBER = 2;
        private float boostAmount_ = 0F;

        /**
         *
         *
         * <pre>
         * Optional. The value between -1 to 1 by which to boost the score if
         * the attribute_value evaluates to the value specified above.
         * </pre>
         *
         * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The boostAmount.
         */
        @java.lang.Override
        public float getBoostAmount() {
          return boostAmount_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, attributeValue_);
          }
          if (java.lang.Float.floatToRawIntBits(boostAmount_) != 0) {
            output.writeFloat(2, boostAmount_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(attributeValue_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, attributeValue_);
          }
          if (java.lang.Float.floatToRawIntBits(boostAmount_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, boostAmount_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint
              other =
                  (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                          .ControlPoint)
                      obj;

          if (!getAttributeValue().equals(other.getAttributeValue())) return false;
          if (java.lang.Float.floatToIntBits(getBoostAmount())
              != java.lang.Float.floatToIntBits(other.getBoostAmount())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + ATTRIBUTE_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getAttributeValue().hashCode();
          hash = (37 * hash) + BOOST_AMOUNT_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoostAmount());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }

        /**
         *
         *
         * <pre>
         * The control points used to define the curve. The curve defined
         * through these control points can only be monotonically increasing
         * or decreasing(constant values are acceptable).
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint)
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPointOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1.ControlProto
                .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_ControlPoint_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1.ControlProto
                .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_ControlPoint_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                        .ControlPoint.class,
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                        .ControlPoint.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            attributeValue_ = "";
            boostAmount_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1.ControlProto
                .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_ControlPoint_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint
              build() {
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint
              buildPartial() {
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint
                result =
                    new com.google.cloud.discoveryengine.v1.Control.BoostAction
                        .InterpolationBoostSpec.ControlPoint(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPoint
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.attributeValue_ = attributeValue_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.boostAmount_ = boostAmount_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                          .ControlPoint)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPoint
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint.getDefaultInstance()) return this;
            if (!other.getAttributeValue().isEmpty()) {
              attributeValue_ = other.attributeValue_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (other.getBoostAmount() != 0F) {
              setBoostAmount(other.getBoostAmount());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      attributeValue_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 21:
                    {
                      boostAmount_ = input.readFloat();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 21
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object attributeValue_ = "";

          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The attributeValue.
           */
          public java.lang.String getAttributeValue() {
            java.lang.Object ref = attributeValue_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              attributeValue_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The bytes for attributeValue.
           */
          public com.google.protobuf.ByteString getAttributeValueBytes() {
            java.lang.Object ref = attributeValue_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              attributeValue_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The attributeValue to set.
           * @return This builder for chaining.
           */
          public Builder setAttributeValue(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            attributeValue_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAttributeValue() {
            attributeValue_ = getDefaultInstance().getAttributeValue();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. Can be one of:
           * 1. The numerical field value.
           * 2. The duration spec for freshness:
           * The value must be formatted as an XSD `dayTimeDuration` value (a
           * restricted subset of an ISO 8601 duration value). The pattern for
           * this is: `[nD][T[nH][nM][nS]]`.
           * </pre>
           *
           * <code>string attribute_value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The bytes for attributeValue to set.
           * @return This builder for chaining.
           */
          public Builder setAttributeValueBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            attributeValue_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private float boostAmount_;

          /**
           *
           *
           * <pre>
           * Optional. The value between -1 to 1 by which to boost the score if
           * the attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return The boostAmount.
           */
          @java.lang.Override
          public float getBoostAmount() {
            return boostAmount_;
          }

          /**
           *
           *
           * <pre>
           * Optional. The value between -1 to 1 by which to boost the score if
           * the attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @param value The boostAmount to set.
           * @return This builder for chaining.
           */
          public Builder setBoostAmount(float value) {

            boostAmount_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }

          /**
           *
           *
           * <pre>
           * Optional. The value between -1 to 1 by which to boost the score if
           * the attribute_value evaluates to the value specified above.
           * </pre>
           *
           * <code>float boost_amount = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearBoostAmount() {
            bitField0_ = (bitField0_ & ~0x00000002);
            boostAmount_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint)
        private static final com.google.cloud.discoveryengine.v1.Control.BoostAction
                .InterpolationBoostSpec.ControlPoint
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint();
        }

        public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ControlPoint> PARSER =
            new com.google.protobuf.AbstractParser<ControlPoint>() {
              @java.lang.Override
              public ControlPoint parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ControlPoint> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ControlPoint> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int FIELD_NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object fieldName_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fieldName.
       */
      @java.lang.Override
      public java.lang.String getFieldName() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fieldName_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the field whose value will be used to determine
       * the boost amount.
       * </pre>
       *
       * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for fieldName.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getFieldNameBytes() {
        java.lang.Object ref = fieldName_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fieldName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ATTRIBUTE_TYPE_FIELD_NUMBER = 2;
      private int attributeType_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for attributeType.
       */
      @java.lang.Override
      public int getAttributeTypeValue() {
        return attributeType_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The attribute type to be used to determine the boost amount.
       * The attribute value can be derived from the field value of the
       * specified field_name. In the case of numerical it is straightforward
       * i.e. attribute_value = numerical_field_value. In the case of freshness
       * however, attribute_value = (time.now() - datetime_field_value).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The attributeType.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .AttributeType
          getAttributeType() {
        com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType
            result =
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .AttributeType.forNumber(attributeType_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .AttributeType.UNRECOGNIZED
            : result;
      }

      public static final int INTERPOLATION_TYPE_FIELD_NUMBER = 3;
      private int interpolationType_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for interpolationType.
       */
      @java.lang.Override
      public int getInterpolationTypeValue() {
        return interpolationType_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The interpolation type to be applied to connect the control
       * points listed below.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The interpolationType.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .InterpolationType
          getInterpolationType() {
        com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .InterpolationType
            result =
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .InterpolationType.forNumber(interpolationType_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .InterpolationType.UNRECOGNIZED
            : result;
      }

      public static final int CONTROL_POINTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint>
          controlPoints_;

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .ControlPoint>
          getControlPointsList() {
        return controlPoints_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPointOrBuilder>
          getControlPointsOrBuilderList() {
        return controlPoints_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public int getControlPointsCount() {
        return controlPoints_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .ControlPoint
          getControlPoints(int index) {
        return controlPoints_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The control points used to define the curve. The monotonic
       * function (defined through the interpolation_type above) passes through
       * the control points listed here.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .ControlPointOrBuilder
          getControlPointsOrBuilder(int index) {
        return controlPoints_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fieldName_);
        }
        if (attributeType_
            != com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .AttributeType.ATTRIBUTE_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, attributeType_);
        }
        if (interpolationType_
            != com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .InterpolationType.INTERPOLATION_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(3, interpolationType_);
        }
        for (int i = 0; i < controlPoints_.size(); i++) {
          output.writeMessage(4, controlPoints_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fieldName_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fieldName_);
        }
        if (attributeType_
            != com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .AttributeType.ATTRIBUTE_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, attributeType_);
        }
        if (interpolationType_
            != com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .InterpolationType.INTERPOLATION_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, interpolationType_);
        }
        for (int i = 0; i < controlPoints_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, controlPoints_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec other =
            (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec) obj;

        if (!getFieldName().equals(other.getFieldName())) return false;
        if (attributeType_ != other.attributeType_) return false;
        if (interpolationType_ != other.interpolationType_) return false;
        if (!getControlPointsList().equals(other.getControlPointsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + FIELD_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getFieldName().hashCode();
        hash = (37 * hash) + ATTRIBUTE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + attributeType_;
        hash = (37 * hash) + INTERPOLATION_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + interpolationType_;
        if (getControlPointsCount() > 0) {
          hash = (37 * hash) + CONTROL_POINTS_FIELD_NUMBER;
          hash = (53 * hash) + getControlPointsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Specification for custom ranking based on customer specified attribute
       * value. It provides more controls for customized ranking than the simple
       * (condition, boost) combination above.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.ControlProto
              .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.ControlProto
              .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .class,
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          fieldName_ = "";
          attributeType_ = 0;
          interpolationType_ = 0;
          if (controlPointsBuilder_ == null) {
            controlPoints_ = java.util.Collections.emptyList();
          } else {
            controlPoints_ = null;
            controlPointsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.ControlProto
              .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_InterpolationBoostSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
            build() {
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec result =
              new com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec result) {
          if (controlPointsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              controlPoints_ = java.util.Collections.unmodifiableList(controlPoints_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.controlPoints_ = controlPoints_;
          } else {
            result.controlPoints_ = controlPointsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.fieldName_ = fieldName_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.attributeType_ = attributeType_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.interpolationType_ = interpolationType_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .getDefaultInstance()) return this;
          if (!other.getFieldName().isEmpty()) {
            fieldName_ = other.fieldName_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.attributeType_ != 0) {
            setAttributeTypeValue(other.getAttributeTypeValue());
          }
          if (other.interpolationType_ != 0) {
            setInterpolationTypeValue(other.getInterpolationTypeValue());
          }
          if (controlPointsBuilder_ == null) {
            if (!other.controlPoints_.isEmpty()) {
              if (controlPoints_.isEmpty()) {
                controlPoints_ = other.controlPoints_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureControlPointsIsMutable();
                controlPoints_.addAll(other.controlPoints_);
              }
              onChanged();
            }
          } else {
            if (!other.controlPoints_.isEmpty()) {
              if (controlPointsBuilder_.isEmpty()) {
                controlPointsBuilder_.dispose();
                controlPointsBuilder_ = null;
                controlPoints_ = other.controlPoints_;
                bitField0_ = (bitField0_ & ~0x00000008);
                controlPointsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getControlPointsFieldBuilder()
                        : null;
              } else {
                controlPointsBuilder_.addAllMessages(other.controlPoints_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    fieldName_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    attributeType_ = input.readEnum();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    interpolationType_ = input.readEnum();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 34:
                  {
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                            .ControlPoint
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1.Control.BoostAction
                                    .InterpolationBoostSpec.ControlPoint.parser(),
                                extensionRegistry);
                    if (controlPointsBuilder_ == null) {
                      ensureControlPointsIsMutable();
                      controlPoints_.add(m);
                    } else {
                      controlPointsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object fieldName_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The fieldName.
         */
        public java.lang.String getFieldName() {
          java.lang.Object ref = fieldName_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fieldName_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for fieldName.
         */
        public com.google.protobuf.ByteString getFieldNameBytes() {
          java.lang.Object ref = fieldName_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fieldName_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The fieldName to set.
         * @return This builder for chaining.
         */
        public Builder setFieldName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          fieldName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearFieldName() {
          fieldName_ = getDefaultInstance().getFieldName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the field whose value will be used to determine
         * the boost amount.
         * </pre>
         *
         * <code>string field_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for fieldName to set.
         * @return This builder for chaining.
         */
        public Builder setFieldNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          fieldName_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private int attributeType_ = 0;

        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enum numeric value on the wire for attributeType.
         */
        @java.lang.Override
        public int getAttributeTypeValue() {
          return attributeType_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The enum numeric value on the wire for attributeType to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeTypeValue(int value) {
          attributeType_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The attributeType.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .AttributeType
            getAttributeType() {
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .AttributeType
              result =
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .AttributeType.forNumber(attributeType_);
          return result == null
              ? com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .AttributeType.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The attributeType to set.
         * @return This builder for chaining.
         */
        public Builder setAttributeType(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .AttributeType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          attributeType_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The attribute type to be used to determine the boost amount.
         * The attribute value can be derived from the field value of the
         * specified field_name. In the case of numerical it is straightforward
         * i.e. attribute_value = numerical_field_value. In the case of freshness
         * however, attribute_value = (time.now() - datetime_field_value).
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.AttributeType attribute_type = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAttributeType() {
          bitField0_ = (bitField0_ & ~0x00000002);
          attributeType_ = 0;
          onChanged();
          return this;
        }

        private int interpolationType_ = 0;

        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The enum numeric value on the wire for interpolationType.
         */
        @java.lang.Override
        public int getInterpolationTypeValue() {
          return interpolationType_;
        }

        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The enum numeric value on the wire for interpolationType to set.
         * @return This builder for chaining.
         */
        public Builder setInterpolationTypeValue(int value) {
          interpolationType_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The interpolationType.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .InterpolationType
            getInterpolationType() {
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .InterpolationType
              result =
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .InterpolationType.forNumber(interpolationType_);
          return result == null
              ? com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .InterpolationType.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The interpolationType to set.
         * @return This builder for chaining.
         */
        public Builder setInterpolationType(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .InterpolationType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          interpolationType_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The interpolation type to be applied to connect the control
         * points listed below.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.InterpolationType interpolation_type = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearInterpolationType() {
          bitField0_ = (bitField0_ & ~0x00000004);
          interpolationType_ = 0;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint>
            controlPoints_ = java.util.Collections.emptyList();

        private void ensureControlPointsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            controlPoints_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                        .ControlPoint>(controlPoints_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint,
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint.Builder,
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPointOrBuilder>
            controlPointsBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint>
            getControlPointsList() {
          if (controlPointsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(controlPoints_);
          } else {
            return controlPointsBuilder_.getMessageList();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public int getControlPointsCount() {
          if (controlPointsBuilder_ == null) {
            return controlPoints_.size();
          } else {
            return controlPointsBuilder_.getCount();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint
            getControlPoints(int index) {
          if (controlPointsBuilder_ == null) {
            return controlPoints_.get(index);
          } else {
            return controlPointsBuilder_.getMessage(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setControlPoints(
            int index,
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint
                value) {
          if (controlPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureControlPointsIsMutable();
            controlPoints_.set(index, value);
            onChanged();
          } else {
            controlPointsBuilder_.setMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setControlPoints(
            int index,
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint.Builder
                builderForValue) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.set(index, builderForValue.build());
            onChanged();
          } else {
            controlPointsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint
                value) {
          if (controlPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureControlPointsIsMutable();
            controlPoints_.add(value);
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            int index,
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint
                value) {
          if (controlPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureControlPointsIsMutable();
            controlPoints_.add(index, value);
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint.Builder
                builderForValue) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.add(builderForValue.build());
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addControlPoints(
            int index,
            com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint.Builder
                builderForValue) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.add(index, builderForValue.build());
            onChanged();
          } else {
            controlPointsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder addAllControlPoints(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1.Control.BoostAction
                            .InterpolationBoostSpec.ControlPoint>
                values) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, controlPoints_);
            onChanged();
          } else {
            controlPointsBuilder_.addAllMessages(values);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearControlPoints() {
          if (controlPointsBuilder_ == null) {
            controlPoints_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            controlPointsBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder removeControlPoints(int index) {
          if (controlPointsBuilder_ == null) {
            ensureControlPointsIsMutable();
            controlPoints_.remove(index);
            onChanged();
          } else {
            controlPointsBuilder_.remove(index);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint.Builder
            getControlPointsBuilder(int index) {
          return getControlPointsFieldBuilder().getBuilder(index);
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPointOrBuilder
            getControlPointsOrBuilder(int index) {
          if (controlPointsBuilder_ == null) {
            return controlPoints_.get(index);
          } else {
            return controlPointsBuilder_.getMessageOrBuilder(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                        .ControlPointOrBuilder>
            getControlPointsOrBuilderList() {
          if (controlPointsBuilder_ != null) {
            return controlPointsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(controlPoints_);
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint.Builder
            addControlPointsBuilder() {
          return getControlPointsFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPoint.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                .ControlPoint.Builder
            addControlPointsBuilder(int index) {
          return getControlPointsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .ControlPoint.getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Optional. The control points used to define the curve. The monotonic
         * function (defined through the interpolation_type above) passes through
         * the control points listed here.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.ControlPoint control_points = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint.Builder>
            getControlPointsBuilderList() {
          return getControlPointsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint,
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPoint.Builder,
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .ControlPointOrBuilder>
            getControlPointsFieldBuilder() {
          if (controlPointsBuilder_ == null) {
            controlPointsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                        .ControlPoint,
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                        .ControlPoint.Builder,
                    com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                        .ControlPointOrBuilder>(
                    controlPoints_,
                    ((bitField0_ & 0x00000008) != 0),
                    getParentForChildren(),
                    isClean());
            controlPoints_ = null;
          }
          return controlPointsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
      private static final com.google.cloud.discoveryengine.v1.Control.BoostAction
              .InterpolationBoostSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec();
      }

      public static com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<InterpolationBoostSpec> PARSER =
          new com.google.protobuf.AbstractParser<InterpolationBoostSpec>() {
            @java.lang.Override
            public InterpolationBoostSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<InterpolationBoostSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<InterpolationBoostSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int boostSpecCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object boostSpec_;

    public enum BoostSpecCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      FIXED_BOOST(4),
      INTERPOLATION_BOOST_SPEC(5),
      BOOSTSPEC_NOT_SET(0);
      private final int value;

      private BoostSpecCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static BoostSpecCase valueOf(int value) {
        return forNumber(value);
      }

      public static BoostSpecCase forNumber(int value) {
        switch (value) {
          case 4:
            return FIXED_BOOST;
          case 5:
            return INTERPOLATION_BOOST_SPEC;
          case 0:
            return BOOSTSPEC_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public BoostSpecCase getBoostSpecCase() {
      return BoostSpecCase.forNumber(boostSpecCase_);
    }

    public static final int FIXED_BOOST_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Optional. Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the fixedBoost field is set.
     */
    @java.lang.Override
    public boolean hasFixedBoost() {
      return boostSpecCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Optional. Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The fixedBoost.
     */
    @java.lang.Override
    public float getFixedBoost() {
      if (boostSpecCase_ == 4) {
        return (java.lang.Float) boostSpec_;
      }
      return 0F;
    }

    public static final int INTERPOLATION_BOOST_SPEC_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the interpolationBoostSpec field is set.
     */
    @java.lang.Override
    public boolean hasInterpolationBoostSpec() {
      return boostSpecCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The interpolationBoostSpec.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
        getInterpolationBoostSpec() {
      if (boostSpecCase_ == 5) {
        return (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
            boostSpec_;
      }
      return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Optional. Complex specification for custom ranking based on customer
     * defined attribute value.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpecOrBuilder
        getInterpolationBoostSpecOrBuilder() {
      if (boostSpecCase_ == 5) {
        return (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
            boostSpec_;
      }
      return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          .getDefaultInstance();
    }

    public static final int BOOST_FIELD_NUMBER = 1;
    private float boost_ = 0F;

    /**
     *
     *
     * <pre>
     * Strength of the boost, which should be in [-1, 1]. Negative
     * boost means demotion. Default is 0.0 (No-op).
     * </pre>
     *
     * <code>float boost = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.discoveryengine.v1.Control.BoostAction.boost is deprecated. See
     *     google/cloud/discoveryengine/v1/control.proto;l=187
     * @return The boost.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public float getBoost() {
      return boost_;
    }

    public static final int FILTER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Specifies which products to apply the boost to.
     *
     * If no filter is provided all products will be boosted (No-op).
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_STORE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be boosted by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
        output.writeFloat(1, boost_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, dataStore_);
      }
      if (boostSpecCase_ == 4) {
        output.writeFloat(4, (float) ((java.lang.Float) boostSpec_));
      }
      if (boostSpecCase_ == 5) {
        output.writeMessage(
            5,
            (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
                boostSpec_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(boost_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, boost_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, dataStore_);
      }
      if (boostSpecCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(
                4, (float) ((java.lang.Float) boostSpec_));
      }
      if (boostSpecCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5,
                (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
                    boostSpec_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Control.BoostAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Control.BoostAction other =
          (com.google.cloud.discoveryengine.v1.Control.BoostAction) obj;

      if (java.lang.Float.floatToIntBits(getBoost())
          != java.lang.Float.floatToIntBits(other.getBoost())) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getBoostSpecCase().equals(other.getBoostSpecCase())) return false;
      switch (boostSpecCase_) {
        case 4:
          if (java.lang.Float.floatToIntBits(getFixedBoost())
              != java.lang.Float.floatToIntBits(other.getFixedBoost())) return false;
          break;
        case 5:
          if (!getInterpolationBoostSpec().equals(other.getInterpolationBoostSpec())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BOOST_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getBoost());
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      switch (boostSpecCase_) {
        case 4:
          hash = (37 * hash) + FIXED_BOOST_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getFixedBoost());
          break;
        case 5:
          hash = (37 * hash) + INTERPOLATION_BOOST_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getInterpolationBoostSpec().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Control.BoostAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Adjusts order of products in returned list.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Control.BoostAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control.BoostAction)
        com.google.cloud.discoveryengine.v1.Control.BoostActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Control.BoostAction.class,
                com.google.cloud.discoveryengine.v1.Control.BoostAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Control.BoostAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (interpolationBoostSpecBuilder_ != null) {
          interpolationBoostSpecBuilder_.clear();
        }
        boost_ = 0F;
        filter_ = "";
        dataStore_ = "";
        boostSpecCase_ = 0;
        boostSpec_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_BoostAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction build() {
        com.google.cloud.discoveryengine.v1.Control.BoostAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction buildPartial() {
        com.google.cloud.discoveryengine.v1.Control.BoostAction result =
            new com.google.cloud.discoveryengine.v1.Control.BoostAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Control.BoostAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.boost_ = boost_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.filter_ = filter_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.dataStore_ = dataStore_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1.Control.BoostAction result) {
        result.boostSpecCase_ = boostSpecCase_;
        result.boostSpec_ = this.boostSpec_;
        if (boostSpecCase_ == 5 && interpolationBoostSpecBuilder_ != null) {
          result.boostSpec_ = interpolationBoostSpecBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Control.BoostAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Control.BoostAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Control.BoostAction other) {
        if (other == com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance())
          return this;
        if (other.getBoost() != 0F) {
          setBoost(other.getBoost());
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        switch (other.getBoostSpecCase()) {
          case FIXED_BOOST:
            {
              setFixedBoost(other.getFixedBoost());
              break;
            }
          case INTERPOLATION_BOOST_SPEC:
            {
              mergeInterpolationBoostSpec(other.getInterpolationBoostSpec());
              break;
            }
          case BOOSTSPEC_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  boost_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 13
              case 18:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 18
              case 26:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 26
              case 37:
                {
                  boostSpec_ = input.readFloat();
                  boostSpecCase_ = 4;
                  break;
                } // case 37
              case 42:
                {
                  input.readMessage(
                      getInterpolationBoostSpecFieldBuilder().getBuilder(), extensionRegistry);
                  boostSpecCase_ = 5;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int boostSpecCase_ = 0;
      private java.lang.Object boostSpec_;

      public BoostSpecCase getBoostSpecCase() {
        return BoostSpecCase.forNumber(boostSpecCase_);
      }

      public Builder clearBoostSpec() {
        boostSpecCase_ = 0;
        boostSpec_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Optional. Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the fixedBoost field is set.
       */
      public boolean hasFixedBoost() {
        return boostSpecCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Optional. Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The fixedBoost.
       */
      public float getFixedBoost() {
        if (boostSpecCase_ == 4) {
          return (java.lang.Float) boostSpec_;
        }
        return 0F;
      }

      /**
       *
       *
       * <pre>
       * Optional. Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The fixedBoost to set.
       * @return This builder for chaining.
       */
      public Builder setFixedBoost(float value) {

        boostSpecCase_ = 4;
        boostSpec_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float fixed_boost = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFixedBoost() {
        if (boostSpecCase_ == 4) {
          boostSpecCase_ = 0;
          boostSpec_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec,
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1.Control.BoostAction
                  .InterpolationBoostSpecOrBuilder>
          interpolationBoostSpecBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the interpolationBoostSpec field is set.
       */
      @java.lang.Override
      public boolean hasInterpolationBoostSpec() {
        return boostSpecCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The interpolationBoostSpec.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
          getInterpolationBoostSpec() {
        if (interpolationBoostSpecBuilder_ == null) {
          if (boostSpecCase_ == 5) {
            return (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
                boostSpec_;
          }
          return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .getDefaultInstance();
        } else {
          if (boostSpecCase_ == 5) {
            return interpolationBoostSpecBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setInterpolationBoostSpec(
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec value) {
        if (interpolationBoostSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          boostSpec_ = value;
          onChanged();
        } else {
          interpolationBoostSpecBuilder_.setMessage(value);
        }
        boostSpecCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setInterpolationBoostSpec(
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.Builder
              builderForValue) {
        if (interpolationBoostSpecBuilder_ == null) {
          boostSpec_ = builderForValue.build();
          onChanged();
        } else {
          interpolationBoostSpecBuilder_.setMessage(builderForValue.build());
        }
        boostSpecCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeInterpolationBoostSpec(
          com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec value) {
        if (interpolationBoostSpecBuilder_ == null) {
          if (boostSpecCase_ == 5
              && boostSpec_
                  != com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .getDefaultInstance()) {
            boostSpec_ =
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .newBuilder(
                        (com.google.cloud.discoveryengine.v1.Control.BoostAction
                                .InterpolationBoostSpec)
                            boostSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            boostSpec_ = value;
          }
          onChanged();
        } else {
          if (boostSpecCase_ == 5) {
            interpolationBoostSpecBuilder_.mergeFrom(value);
          } else {
            interpolationBoostSpecBuilder_.setMessage(value);
          }
        }
        boostSpecCase_ = 5;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearInterpolationBoostSpec() {
        if (interpolationBoostSpecBuilder_ == null) {
          if (boostSpecCase_ == 5) {
            boostSpecCase_ = 0;
            boostSpec_ = null;
            onChanged();
          }
        } else {
          if (boostSpecCase_ == 5) {
            boostSpecCase_ = 0;
            boostSpec_ = null;
          }
          interpolationBoostSpecBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec.Builder
          getInterpolationBoostSpecBuilder() {
        return getInterpolationBoostSpecFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpecOrBuilder
          getInterpolationBoostSpecOrBuilder() {
        if ((boostSpecCase_ == 5) && (interpolationBoostSpecBuilder_ != null)) {
          return interpolationBoostSpecBuilder_.getMessageOrBuilder();
        } else {
          if (boostSpecCase_ == 5) {
            return (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
                boostSpec_;
          }
          return com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Complex specification for custom ranking based on customer
       * defined attribute value.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec interpolation_boost_spec = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec,
              com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                  .Builder,
              com.google.cloud.discoveryengine.v1.Control.BoostAction
                  .InterpolationBoostSpecOrBuilder>
          getInterpolationBoostSpecFieldBuilder() {
        if (interpolationBoostSpecBuilder_ == null) {
          if (!(boostSpecCase_ == 5)) {
            boostSpec_ =
                com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                    .getDefaultInstance();
          }
          interpolationBoostSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec,
                  com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec
                      .Builder,
                  com.google.cloud.discoveryengine.v1.Control.BoostAction
                      .InterpolationBoostSpecOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.Control.BoostAction.InterpolationBoostSpec)
                      boostSpec_,
                  getParentForChildren(),
                  isClean());
          boostSpec_ = null;
        }
        boostSpecCase_ = 5;
        onChanged();
        return interpolationBoostSpecBuilder_;
      }

      private float boost_;

      /**
       *
       *
       * <pre>
       * Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float boost = 1 [deprecated = true];</code>
       *
       * @deprecated google.cloud.discoveryengine.v1.Control.BoostAction.boost is deprecated. See
       *     google/cloud/discoveryengine/v1/control.proto;l=187
       * @return The boost.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public float getBoost() {
        return boost_;
      }

      /**
       *
       *
       * <pre>
       * Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float boost = 1 [deprecated = true];</code>
       *
       * @deprecated google.cloud.discoveryengine.v1.Control.BoostAction.boost is deprecated. See
       *     google/cloud/discoveryengine/v1/control.proto;l=187
       * @param value The boost to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setBoost(float value) {

        boost_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Strength of the boost, which should be in [-1, 1]. Negative
       * boost means demotion. Default is 0.0 (No-op).
       * </pre>
       *
       * <code>float boost = 1 [deprecated = true];</code>
       *
       * @deprecated google.cloud.discoveryengine.v1.Control.BoostAction.boost is deprecated. See
       *     google/cloud/discoveryengine/v1/control.proto;l=187
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearBoost() {
        bitField0_ = (bitField0_ & ~0x00000004);
        boost_ = 0F;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";

      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which products to apply the boost to.
       *
       * If no filter is provided all products will be boosted (No-op).
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object dataStore_ = "";

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be boosted by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control.BoostAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control.BoostAction)
    private static final com.google.cloud.discoveryengine.v1.Control.BoostAction DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Control.BoostAction();
    }

    public static com.google.cloud.discoveryengine.v1.Control.BoostAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BoostAction> PARSER =
        new com.google.protobuf.AbstractParser<BoostAction>() {
          @java.lang.Override
          public BoostAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BoostAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BoostAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.BoostAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FilterActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Control.FilterAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();

    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();
  }

  /**
   *
   *
   * <pre>
   * Specified which products may be included in results.
   * Uses same filter as boost.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Control.FilterAction}
   */
  public static final class FilterAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control.FilterAction)
      FilterActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use FilterAction.newBuilder() to construct.
    private FilterAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FilterAction() {
      filter_ = "";
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FilterAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_FilterAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_FilterAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Control.FilterAction.class,
              com.google.cloud.discoveryengine.v1.Control.FilterAction.Builder.class);
    }

    public static final int FILTER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. A filter to apply on the matching condition results.
     *
     * Required
     * Syntax documentation:
     * https://cloud.google.com/retail/docs/filter-and-order
     * Maximum length is 5000 characters. Otherwise an INVALID
     * ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATA_STORE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Specifies which data store's documents can be filtered by this
     * control. Full data store name e.g.
     * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
     * </pre>
     *
     * <code>
     * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataStore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataStore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Control.FilterAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Control.FilterAction other =
          (com.google.cloud.discoveryengine.v1.Control.FilterAction) obj;

      if (!getFilter().equals(other.getFilter())) return false;
      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Control.FilterAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Specified which products may be included in results.
     * Uses same filter as boost.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Control.FilterAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control.FilterAction)
        com.google.cloud.discoveryengine.v1.Control.FilterActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_FilterAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_FilterAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Control.FilterAction.class,
                com.google.cloud.discoveryengine.v1.Control.FilterAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Control.FilterAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        filter_ = "";
        dataStore_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_FilterAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.FilterAction getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.FilterAction build() {
        com.google.cloud.discoveryengine.v1.Control.FilterAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.FilterAction buildPartial() {
        com.google.cloud.discoveryengine.v1.Control.FilterAction result =
            new com.google.cloud.discoveryengine.v1.Control.FilterAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Control.FilterAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.filter_ = filter_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dataStore_ = dataStore_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Control.FilterAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Control.FilterAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Control.FilterAction other) {
        if (other == com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance())
          return this;
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object filter_ = "";

      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A filter to apply on the matching condition results.
       *
       * Required
       * Syntax documentation:
       * https://cloud.google.com/retail/docs/filter-and-order
       * Maximum length is 5000 characters. Otherwise an INVALID
       * ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object dataStore_ = "";

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Specifies which data store's documents can be filtered by this
       * control. Full data store name e.g.
       * projects/123/locations/global/collections/default_collection/dataStores/default_data_store
       * </pre>
       *
       * <code>
       * string data_store = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control.FilterAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control.FilterAction)
    private static final com.google.cloud.discoveryengine.v1.Control.FilterAction DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Control.FilterAction();
    }

    public static com.google.cloud.discoveryengine.v1.Control.FilterAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FilterAction> PARSER =
        new com.google.protobuf.AbstractParser<FilterAction>() {
          @java.lang.Override
          public FilterAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FilterAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FilterAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.FilterAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RedirectActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Control.RedirectAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The redirectUri.
     */
    java.lang.String getRedirectUri();

    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for redirectUri.
     */
    com.google.protobuf.ByteString getRedirectUriBytes();
  }

  /**
   *
   *
   * <pre>
   * Redirects a shopper to the provided URI.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Control.RedirectAction}
   */
  public static final class RedirectAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control.RedirectAction)
      RedirectActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RedirectAction.newBuilder() to construct.
    private RedirectAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RedirectAction() {
      redirectUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RedirectAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_RedirectAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_RedirectAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Control.RedirectAction.class,
              com.google.cloud.discoveryengine.v1.Control.RedirectAction.Builder.class);
    }

    public static final int REDIRECT_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object redirectUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The redirectUri.
     */
    @java.lang.Override
    public java.lang.String getRedirectUri() {
      java.lang.Object ref = redirectUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        redirectUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The URI to which the shopper will be redirected.
     *
     * Required.
     * URI must have length equal or less than 2000 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for redirectUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRedirectUriBytes() {
      java.lang.Object ref = redirectUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        redirectUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, redirectUri_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(redirectUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, redirectUri_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Control.RedirectAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Control.RedirectAction other =
          (com.google.cloud.discoveryengine.v1.Control.RedirectAction) obj;

      if (!getRedirectUri().equals(other.getRedirectUri())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REDIRECT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getRedirectUri().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Control.RedirectAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Redirects a shopper to the provided URI.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Control.RedirectAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control.RedirectAction)
        com.google.cloud.discoveryengine.v1.Control.RedirectActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_RedirectAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_RedirectAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Control.RedirectAction.class,
                com.google.cloud.discoveryengine.v1.Control.RedirectAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Control.RedirectAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        redirectUri_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_RedirectAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.RedirectAction
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.RedirectAction build() {
        com.google.cloud.discoveryengine.v1.Control.RedirectAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.RedirectAction buildPartial() {
        com.google.cloud.discoveryengine.v1.Control.RedirectAction result =
            new com.google.cloud.discoveryengine.v1.Control.RedirectAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Control.RedirectAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.redirectUri_ = redirectUri_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Control.RedirectAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Control.RedirectAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Control.RedirectAction other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance())
          return this;
        if (!other.getRedirectUri().isEmpty()) {
          redirectUri_ = other.redirectUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  redirectUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object redirectUri_ = "";

      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The redirectUri.
       */
      public java.lang.String getRedirectUri() {
        java.lang.Object ref = redirectUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          redirectUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for redirectUri.
       */
      public com.google.protobuf.ByteString getRedirectUriBytes() {
        java.lang.Object ref = redirectUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          redirectUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The redirectUri to set.
       * @return This builder for chaining.
       */
      public Builder setRedirectUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        redirectUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRedirectUri() {
        redirectUri_ = getDefaultInstance().getRedirectUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to which the shopper will be redirected.
       *
       * Required.
       * URI must have length equal or less than 2000 characters.
       * Otherwise an INVALID ARGUMENT error is thrown.
       * </pre>
       *
       * <code>string redirect_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for redirectUri to set.
       * @return This builder for chaining.
       */
      public Builder setRedirectUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        redirectUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control.RedirectAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control.RedirectAction)
    private static final com.google.cloud.discoveryengine.v1.Control.RedirectAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Control.RedirectAction();
    }

    public static com.google.cloud.discoveryengine.v1.Control.RedirectAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RedirectAction> PARSER =
        new com.google.protobuf.AbstractParser<RedirectAction>() {
          @java.lang.Override
          public RedirectAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RedirectAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RedirectAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.RedirectAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SynonymsActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Control.SynonymsAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return A list containing the synonyms.
     */
    java.util.List<java.lang.String> getSynonymsList();

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return The count of synonyms.
     */
    int getSynonymsCount();

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The synonyms at the given index.
     */
    java.lang.String getSynonyms(int index);

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the synonyms at the given index.
     */
    com.google.protobuf.ByteString getSynonymsBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Creates a set of terms that will act as synonyms of one another.
   *
   * Example: "happy" will also be considered as "glad", "glad" will also be
   * considered as "happy".
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Control.SynonymsAction}
   */
  public static final class SynonymsAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control.SynonymsAction)
      SynonymsActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SynonymsAction.newBuilder() to construct.
    private SynonymsAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SynonymsAction() {
      synonyms_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SynonymsAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_SynonymsAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_SynonymsAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Control.SynonymsAction.class,
              com.google.cloud.discoveryengine.v1.Control.SynonymsAction.Builder.class);
    }

    public static final int SYNONYMS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList synonyms_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return A list containing the synonyms.
     */
    public com.google.protobuf.ProtocolStringList getSynonymsList() {
      return synonyms_;
    }

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @return The count of synonyms.
     */
    public int getSynonymsCount() {
      return synonyms_.size();
    }

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The synonyms at the given index.
     */
    public java.lang.String getSynonyms(int index) {
      return synonyms_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Defines a set of synonyms.
     * Can specify up to 100 synonyms.
     * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
     * thrown.
     * </pre>
     *
     * <code>repeated string synonyms = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the synonyms at the given index.
     */
    public com.google.protobuf.ByteString getSynonymsBytes(int index) {
      return synonyms_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < synonyms_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, synonyms_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < synonyms_.size(); i++) {
          dataSize += computeStringSizeNoTag(synonyms_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSynonymsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Control.SynonymsAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Control.SynonymsAction other =
          (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) obj;

      if (!getSynonymsList().equals(other.getSynonymsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSynonymsCount() > 0) {
        hash = (37 * hash) + SYNONYMS_FIELD_NUMBER;
        hash = (53 * hash) + getSynonymsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Control.SynonymsAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Creates a set of terms that will act as synonyms of one another.
     *
     * Example: "happy" will also be considered as "glad", "glad" will also be
     * considered as "happy".
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Control.SynonymsAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control.SynonymsAction)
        com.google.cloud.discoveryengine.v1.Control.SynonymsActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_SynonymsAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_SynonymsAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Control.SynonymsAction.class,
                com.google.cloud.discoveryengine.v1.Control.SynonymsAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Control.SynonymsAction.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        synonyms_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_SynonymsAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.SynonymsAction
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.SynonymsAction build() {
        com.google.cloud.discoveryengine.v1.Control.SynonymsAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.SynonymsAction buildPartial() {
        com.google.cloud.discoveryengine.v1.Control.SynonymsAction result =
            new com.google.cloud.discoveryengine.v1.Control.SynonymsAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Control.SynonymsAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          synonyms_.makeImmutable();
          result.synonyms_ = synonyms_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Control.SynonymsAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Control.SynonymsAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Control.SynonymsAction other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance())
          return this;
        if (!other.synonyms_.isEmpty()) {
          if (synonyms_.isEmpty()) {
            synonyms_ = other.synonyms_;
            bitField0_ |= 0x00000001;
          } else {
            ensureSynonymsIsMutable();
            synonyms_.addAll(other.synonyms_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureSynonymsIsMutable();
                  synonyms_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList synonyms_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureSynonymsIsMutable() {
        if (!synonyms_.isModifiable()) {
          synonyms_ = new com.google.protobuf.LazyStringArrayList(synonyms_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @return A list containing the synonyms.
       */
      public com.google.protobuf.ProtocolStringList getSynonymsList() {
        synonyms_.makeImmutable();
        return synonyms_;
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @return The count of synonyms.
       */
      public int getSynonymsCount() {
        return synonyms_.size();
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The synonyms at the given index.
       */
      public java.lang.String getSynonyms(int index) {
        return synonyms_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the synonyms at the given index.
       */
      public com.google.protobuf.ByteString getSynonymsBytes(int index) {
        return synonyms_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The synonyms to set.
       * @return This builder for chaining.
       */
      public Builder setSynonyms(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSynonymsIsMutable();
        synonyms_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param value The synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addSynonyms(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSynonymsIsMutable();
        synonyms_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param values The synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addAllSynonyms(java.lang.Iterable<java.lang.String> values) {
        ensureSynonymsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, synonyms_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSynonyms() {
        synonyms_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Defines a set of synonyms.
       * Can specify up to 100 synonyms.
       * Must specify at least 2 synonyms. Otherwise an INVALID ARGUMENT error is
       * thrown.
       * </pre>
       *
       * <code>repeated string synonyms = 1;</code>
       *
       * @param value The bytes of the synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addSynonymsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSynonymsIsMutable();
        synonyms_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control.SynonymsAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control.SynonymsAction)
    private static final com.google.cloud.discoveryengine.v1.Control.SynonymsAction
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Control.SynonymsAction();
    }

    public static com.google.cloud.discoveryengine.v1.Control.SynonymsAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SynonymsAction> PARSER =
        new com.google.protobuf.AbstractParser<SynonymsAction>() {
          @java.lang.Override
          public SynonymsAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SynonymsAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SynonymsAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.SynonymsAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PromoteActionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Control.PromoteAction)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Data store with which this promotion is attached to.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();

    /**
     *
     *
     * <pre>
     * Required. Data store with which this promotion is attached to.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();

    /**
     *
     *
     * <pre>
     * Required. Promotion attached to this action.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the searchLinkPromotion field is set.
     */
    boolean hasSearchLinkPromotion();

    /**
     *
     *
     * <pre>
     * Required. Promotion attached to this action.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The searchLinkPromotion.
     */
    com.google.cloud.discoveryengine.v1.SearchLinkPromotion getSearchLinkPromotion();

    /**
     *
     *
     * <pre>
     * Required. Promotion attached to this action.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1.SearchLinkPromotionOrBuilder
        getSearchLinkPromotionOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Promote certain links based on some trigger queries.
   *
   * Example: Promote shoe store link when searching for `shoe` keyword.
   * The link can be outside of associated data store.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Control.PromoteAction}
   */
  public static final class PromoteAction extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Control.PromoteAction)
      PromoteActionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PromoteAction.newBuilder() to construct.
    private PromoteAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PromoteAction() {
      dataStore_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PromoteAction();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_PromoteAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_PromoteAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Control.PromoteAction.class,
              com.google.cloud.discoveryengine.v1.Control.PromoteAction.Builder.class);
    }

    private int bitField0_;
    public static final int DATA_STORE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";

    /**
     *
     *
     * <pre>
     * Required. Data store with which this promotion is attached to.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Data store with which this promotion is attached to.
     * </pre>
     *
     * <code>
     * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SEARCH_LINK_PROMOTION_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1.SearchLinkPromotion searchLinkPromotion_;

    /**
     *
     *
     * <pre>
     * Required. Promotion attached to this action.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the searchLinkPromotion field is set.
     */
    @java.lang.Override
    public boolean hasSearchLinkPromotion() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Promotion attached to this action.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The searchLinkPromotion.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchLinkPromotion getSearchLinkPromotion() {
      return searchLinkPromotion_ == null
          ? com.google.cloud.discoveryengine.v1.SearchLinkPromotion.getDefaultInstance()
          : searchLinkPromotion_;
    }

    /**
     *
     *
     * <pre>
     * Required. Promotion attached to this action.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchLinkPromotionOrBuilder
        getSearchLinkPromotionOrBuilder() {
      return searchLinkPromotion_ == null
          ? com.google.cloud.discoveryengine.v1.SearchLinkPromotion.getDefaultInstance()
          : searchLinkPromotion_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataStore_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getSearchLinkPromotion());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataStore_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSearchLinkPromotion());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Control.PromoteAction)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Control.PromoteAction other =
          (com.google.cloud.discoveryengine.v1.Control.PromoteAction) obj;

      if (!getDataStore().equals(other.getDataStore())) return false;
      if (hasSearchLinkPromotion() != other.hasSearchLinkPromotion()) return false;
      if (hasSearchLinkPromotion()) {
        if (!getSearchLinkPromotion().equals(other.getSearchLinkPromotion())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      if (hasSearchLinkPromotion()) {
        hash = (37 * hash) + SEARCH_LINK_PROMOTION_FIELD_NUMBER;
        hash = (53 * hash) + getSearchLinkPromotion().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Control.PromoteAction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on some trigger queries.
     *
     * Example: Promote shoe store link when searching for `shoe` keyword.
     * The link can be outside of associated data store.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Control.PromoteAction}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control.PromoteAction)
        com.google.cloud.discoveryengine.v1.Control.PromoteActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_PromoteAction_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_PromoteAction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Control.PromoteAction.class,
                com.google.cloud.discoveryengine.v1.Control.PromoteAction.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Control.PromoteAction.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSearchLinkPromotionFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataStore_ = "";
        searchLinkPromotion_ = null;
        if (searchLinkPromotionBuilder_ != null) {
          searchLinkPromotionBuilder_.dispose();
          searchLinkPromotionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ControlProto
            .internal_static_google_cloud_discoveryengine_v1_Control_PromoteAction_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.PromoteAction getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.PromoteAction build() {
        com.google.cloud.discoveryengine.v1.Control.PromoteAction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Control.PromoteAction buildPartial() {
        com.google.cloud.discoveryengine.v1.Control.PromoteAction result =
            new com.google.cloud.discoveryengine.v1.Control.PromoteAction(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Control.PromoteAction result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataStore_ = dataStore_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.searchLinkPromotion_ =
              searchLinkPromotionBuilder_ == null
                  ? searchLinkPromotion_
                  : searchLinkPromotionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Control.PromoteAction) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Control.PromoteAction) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Control.PromoteAction other) {
        if (other == com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance())
          return this;
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasSearchLinkPromotion()) {
          mergeSearchLinkPromotion(other.getSearchLinkPromotion());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getSearchLinkPromotionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataStore_ = "";

      /**
       *
       *
       * <pre>
       * Required. Data store with which this promotion is attached to.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Data store with which this promotion is attached to.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Data store with which this promotion is attached to.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Data store with which this promotion is attached to.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Data store with which this promotion is attached to.
       * </pre>
       *
       * <code>
       * string data_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1.SearchLinkPromotion searchLinkPromotion_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchLinkPromotion,
              com.google.cloud.discoveryengine.v1.SearchLinkPromotion.Builder,
              com.google.cloud.discoveryengine.v1.SearchLinkPromotionOrBuilder>
          searchLinkPromotionBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the searchLinkPromotion field is set.
       */
      public boolean hasSearchLinkPromotion() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The searchLinkPromotion.
       */
      public com.google.cloud.discoveryengine.v1.SearchLinkPromotion getSearchLinkPromotion() {
        if (searchLinkPromotionBuilder_ == null) {
          return searchLinkPromotion_ == null
              ? com.google.cloud.discoveryengine.v1.SearchLinkPromotion.getDefaultInstance()
              : searchLinkPromotion_;
        } else {
          return searchLinkPromotionBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSearchLinkPromotion(
          com.google.cloud.discoveryengine.v1.SearchLinkPromotion value) {
        if (searchLinkPromotionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          searchLinkPromotion_ = value;
        } else {
          searchLinkPromotionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSearchLinkPromotion(
          com.google.cloud.discoveryengine.v1.SearchLinkPromotion.Builder builderForValue) {
        if (searchLinkPromotionBuilder_ == null) {
          searchLinkPromotion_ = builderForValue.build();
        } else {
          searchLinkPromotionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeSearchLinkPromotion(
          com.google.cloud.discoveryengine.v1.SearchLinkPromotion value) {
        if (searchLinkPromotionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && searchLinkPromotion_ != null
              && searchLinkPromotion_
                  != com.google.cloud.discoveryengine.v1.SearchLinkPromotion.getDefaultInstance()) {
            getSearchLinkPromotionBuilder().mergeFrom(value);
          } else {
            searchLinkPromotion_ = value;
          }
        } else {
          searchLinkPromotionBuilder_.mergeFrom(value);
        }
        if (searchLinkPromotion_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearSearchLinkPromotion() {
        bitField0_ = (bitField0_ & ~0x00000002);
        searchLinkPromotion_ = null;
        if (searchLinkPromotionBuilder_ != null) {
          searchLinkPromotionBuilder_.dispose();
          searchLinkPromotionBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchLinkPromotion.Builder
          getSearchLinkPromotionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSearchLinkPromotionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SearchLinkPromotionOrBuilder
          getSearchLinkPromotionOrBuilder() {
        if (searchLinkPromotionBuilder_ != null) {
          return searchLinkPromotionBuilder_.getMessageOrBuilder();
        } else {
          return searchLinkPromotion_ == null
              ? com.google.cloud.discoveryengine.v1.SearchLinkPromotion.getDefaultInstance()
              : searchLinkPromotion_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Promotion attached to this action.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.SearchLinkPromotion search_link_promotion = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SearchLinkPromotion,
              com.google.cloud.discoveryengine.v1.SearchLinkPromotion.Builder,
              com.google.cloud.discoveryengine.v1.SearchLinkPromotionOrBuilder>
          getSearchLinkPromotionFieldBuilder() {
        if (searchLinkPromotionBuilder_ == null) {
          searchLinkPromotionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.SearchLinkPromotion,
                  com.google.cloud.discoveryengine.v1.SearchLinkPromotion.Builder,
                  com.google.cloud.discoveryengine.v1.SearchLinkPromotionOrBuilder>(
                  getSearchLinkPromotion(), getParentForChildren(), isClean());
          searchLinkPromotion_ = null;
        }
        return searchLinkPromotionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control.PromoteAction)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control.PromoteAction)
    private static final com.google.cloud.discoveryengine.v1.Control.PromoteAction DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Control.PromoteAction();
    }

    public static com.google.cloud.discoveryengine.v1.Control.PromoteAction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PromoteAction> PARSER =
        new com.google.protobuf.AbstractParser<PromoteAction>() {
          @java.lang.Override
          public PromoteAction parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PromoteAction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PromoteAction> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.PromoteAction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BOOST_ACTION(6),
    FILTER_ACTION(7),
    REDIRECT_ACTION(9),
    SYNONYMS_ACTION(10),
    PROMOTE_ACTION(15),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 6:
          return BOOST_ACTION;
        case 7:
          return FILTER_ACTION;
        case 9:
          return REDIRECT_ACTION;
        case 10:
          return SYNONYMS_ACTION;
        case 15:
          return PROMOTE_ACTION;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int BOOST_ACTION_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Defines a boost-type control
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
   *
   * @return Whether the boostAction field is set.
   */
  @java.lang.Override
  public boolean hasBoostAction() {
    return actionCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Defines a boost-type control
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
   *
   * @return The boostAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.BoostAction getBoostAction() {
    if (actionCase_ == 6) {
      return (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Defines a boost-type control
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.BoostActionOrBuilder
      getBoostActionOrBuilder() {
    if (actionCase_ == 6) {
      return (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance();
  }

  public static final int FILTER_ACTION_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Defines a filter-type control
   * Currently not supported by Recommendation
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
   *
   * @return Whether the filterAction field is set.
   */
  @java.lang.Override
  public boolean hasFilterAction() {
    return actionCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Defines a filter-type control
   * Currently not supported by Recommendation
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
   *
   * @return The filterAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.FilterAction getFilterAction() {
    if (actionCase_ == 7) {
      return (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Defines a filter-type control
   * Currently not supported by Recommendation
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.FilterActionOrBuilder
      getFilterActionOrBuilder() {
    if (actionCase_ == 7) {
      return (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance();
  }

  public static final int REDIRECT_ACTION_FIELD_NUMBER = 9;

  /**
   *
   *
   * <pre>
   * Defines a redirect-type control.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
   *
   * @return Whether the redirectAction field is set.
   */
  @java.lang.Override
  public boolean hasRedirectAction() {
    return actionCase_ == 9;
  }

  /**
   *
   *
   * <pre>
   * Defines a redirect-type control.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
   *
   * @return The redirectAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.RedirectAction getRedirectAction() {
    if (actionCase_ == 9) {
      return (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Defines a redirect-type control.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.RedirectActionOrBuilder
      getRedirectActionOrBuilder() {
    if (actionCase_ == 9) {
      return (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance();
  }

  public static final int SYNONYMS_ACTION_FIELD_NUMBER = 10;

  /**
   *
   *
   * <pre>
   * Treats a group of terms as synonyms of one another.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
   *
   * @return Whether the synonymsAction field is set.
   */
  @java.lang.Override
  public boolean hasSynonymsAction() {
    return actionCase_ == 10;
  }

  /**
   *
   *
   * <pre>
   * Treats a group of terms as synonyms of one another.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
   *
   * @return The synonymsAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.SynonymsAction getSynonymsAction() {
    if (actionCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Treats a group of terms as synonyms of one another.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.SynonymsActionOrBuilder
      getSynonymsActionOrBuilder() {
    if (actionCase_ == 10) {
      return (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance();
  }

  public static final int PROMOTE_ACTION_FIELD_NUMBER = 15;

  /**
   *
   *
   * <pre>
   * Promote certain links based on predefined trigger queries.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
   *
   * @return Whether the promoteAction field is set.
   */
  @java.lang.Override
  public boolean hasPromoteAction() {
    return actionCase_ == 15;
  }

  /**
   *
   *
   * <pre>
   * Promote certain links based on predefined trigger queries.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
   *
   * @return The promoteAction.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.PromoteAction getPromoteAction() {
    if (actionCase_ == 15) {
      return (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Promote certain links based on predefined trigger queries.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control.PromoteActionOrBuilder
      getPromoteActionOrBuilder() {
    if (actionCase_ == 15) {
      return (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_;
    }
    return com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Fully qualified name
   * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. Human readable name. The identifier used in UI views.
   *
   * Must be UTF-8 encoded string. Length limit is 128 characters.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Human readable name. The identifier used in UI views.
   *
   * Must be UTF-8 encoded string. Length limit is 128 characters.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSOCIATED_SERVING_CONFIG_IDS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList associatedServingConfigIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the associatedServingConfigIds.
   */
  public com.google.protobuf.ProtocolStringList getAssociatedServingConfigIdsList() {
    return associatedServingConfigIds_;
  }

  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of associatedServingConfigIds.
   */
  public int getAssociatedServingConfigIdsCount() {
    return associatedServingConfigIds_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The associatedServingConfigIds at the given index.
   */
  public java.lang.String getAssociatedServingConfigIds(int index) {
    return associatedServingConfigIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. List of all
   * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
   * control is attached to. May take up to 10 minutes to update after changes.
   * </pre>
   *
   * <code>
   * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the associatedServingConfigIds at the given index.
   */
  public com.google.protobuf.ByteString getAssociatedServingConfigIdsBytes(int index) {
    return associatedServingConfigIds_.getByteString(index);
  }

  public static final int SOLUTION_TYPE_FIELD_NUMBER = 4;
  private int solutionType_ = 0;

  /**
   *
   *
   * <pre>
   * Required. Immutable. What solution the control belongs to.
   *
   * Must be compatible with vertical of resource.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for solutionType.
   */
  @java.lang.Override
  public int getSolutionTypeValue() {
    return solutionType_;
  }

  /**
   *
   *
   * <pre>
   * Required. Immutable. What solution the control belongs to.
   *
   * Must be compatible with vertical of resource.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The solutionType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SolutionType getSolutionType() {
    com.google.cloud.discoveryengine.v1.SolutionType result =
        com.google.cloud.discoveryengine.v1.SolutionType.forNumber(solutionType_);
    return result == null ? com.google.cloud.discoveryengine.v1.SolutionType.UNRECOGNIZED : result;
  }

  public static final int USE_CASES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> useCases_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchUseCase>
      useCases_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchUseCase>() {
            public com.google.cloud.discoveryengine.v1.SearchUseCase convert(
                java.lang.Integer from) {
              com.google.cloud.discoveryengine.v1.SearchUseCase result =
                  com.google.cloud.discoveryengine.v1.SearchUseCase.forNumber(from);
              return result == null
                  ? com.google.cloud.discoveryengine.v1.SearchUseCase.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
   *
   * @return A list containing the useCases.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.SearchUseCase> getUseCasesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchUseCase>(
        useCases_, useCases_converter_);
  }

  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
   *
   * @return The count of useCases.
   */
  @java.lang.Override
  public int getUseCasesCount() {
    return useCases_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The useCases at the given index.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SearchUseCase getUseCases(int index) {
    return useCases_converter_.convert(useCases_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
   *
   * @return A list containing the enum numeric values on the wire for useCases.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getUseCasesValueList() {
    return useCases_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the use case for the control.
   * Affects what condition fields can be set.
   * Only applies to
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * Currently only allow one use case per control.
   * Must be set when solution_type is
   * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of useCases at the given index.
   */
  @java.lang.Override
  public int getUseCasesValue(int index) {
    return useCases_.get(index);
  }

  private int useCasesMemoizedSerializedSize;

  public static final int CONDITIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.discoveryengine.v1.Condition> conditions_;

  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.discoveryengine.v1.Condition> getConditionsList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.discoveryengine.v1.ConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }

  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Condition getConditions(int index) {
    return conditions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Determines when the associated action will trigger.
   *
   * Omit to always apply the action.
   * Currently only a single condition may be specified.
   * Otherwise an INVALID ARGUMENT error is thrown.
   * </pre>
   *
   * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.ConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < associatedServingConfigIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 3, associatedServingConfigIds_.getRaw(i));
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, solutionType_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(5, conditions_.get(i));
    }
    if (actionCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_);
    }
    if (actionCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_);
    }
    if (getUseCasesList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(useCasesMemoizedSerializedSize);
    }
    for (int i = 0; i < useCases_.size(); i++) {
      output.writeEnumNoTag(useCases_.get(i));
    }
    if (actionCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_);
    }
    if (actionCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_);
    }
    if (actionCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < associatedServingConfigIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(associatedServingConfigIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAssociatedServingConfigIdsList().size();
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, solutionType_);
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, conditions_.get(i));
    }
    if (actionCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_);
    }
    if (actionCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < useCases_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(useCases_.get(i));
      }
      size += dataSize;
      if (!getUseCasesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      useCasesMemoizedSerializedSize = dataSize;
    }
    if (actionCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_);
    }
    if (actionCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_);
    }
    if (actionCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.Control)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.Control other =
        (com.google.cloud.discoveryengine.v1.Control) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getAssociatedServingConfigIdsList().equals(other.getAssociatedServingConfigIdsList()))
      return false;
    if (solutionType_ != other.solutionType_) return false;
    if (!useCases_.equals(other.useCases_)) return false;
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 6:
        if (!getBoostAction().equals(other.getBoostAction())) return false;
        break;
      case 7:
        if (!getFilterAction().equals(other.getFilterAction())) return false;
        break;
      case 9:
        if (!getRedirectAction().equals(other.getRedirectAction())) return false;
        break;
      case 10:
        if (!getSynonymsAction().equals(other.getSynonymsAction())) return false;
        break;
      case 15:
        if (!getPromoteAction().equals(other.getPromoteAction())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getAssociatedServingConfigIdsCount() > 0) {
      hash = (37 * hash) + ASSOCIATED_SERVING_CONFIG_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getAssociatedServingConfigIdsList().hashCode();
    }
    hash = (37 * hash) + SOLUTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + solutionType_;
    if (getUseCasesCount() > 0) {
      hash = (37 * hash) + USE_CASES_FIELD_NUMBER;
      hash = (53 * hash) + useCases_.hashCode();
    }
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    switch (actionCase_) {
      case 6:
        hash = (37 * hash) + BOOST_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getBoostAction().hashCode();
        break;
      case 7:
        hash = (37 * hash) + FILTER_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getFilterAction().hashCode();
        break;
      case 9:
        hash = (37 * hash) + REDIRECT_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getRedirectAction().hashCode();
        break;
      case 10:
        hash = (37 * hash) + SYNONYMS_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getSynonymsAction().hashCode();
        break;
      case 15:
        hash = (37 * hash) + PROMOTE_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getPromoteAction().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Control parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.Control prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Defines a conditioned behavior to employ during serving.
   * Must be attached to a
   * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] to be
   * considered at serving time. Permitted actions dependent on `SolutionType`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Control}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Control)
      com.google.cloud.discoveryengine.v1.ControlOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Control.class,
              com.google.cloud.discoveryengine.v1.Control.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.Control.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (boostActionBuilder_ != null) {
        boostActionBuilder_.clear();
      }
      if (filterActionBuilder_ != null) {
        filterActionBuilder_.clear();
      }
      if (redirectActionBuilder_ != null) {
        redirectActionBuilder_.clear();
      }
      if (synonymsActionBuilder_ != null) {
        synonymsActionBuilder_.clear();
      }
      if (promoteActionBuilder_ != null) {
        promoteActionBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      solutionType_ = 0;
      useCases_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.ControlProto
          .internal_static_google_cloud_discoveryengine_v1_Control_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.Control.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control build() {
      com.google.cloud.discoveryengine.v1.Control result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control buildPartial() {
      com.google.cloud.discoveryengine.v1.Control result =
          new com.google.cloud.discoveryengine.v1.Control(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.discoveryengine.v1.Control result) {
      if (((bitField0_ & 0x00000200) != 0)) {
        useCases_ = java.util.Collections.unmodifiableList(useCases_);
        bitField0_ = (bitField0_ & ~0x00000200);
      }
      result.useCases_ = useCases_;
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.Control result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        associatedServingConfigIds_.makeImmutable();
        result.associatedServingConfigIds_ = associatedServingConfigIds_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.solutionType_ = solutionType_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1.Control result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 6 && boostActionBuilder_ != null) {
        result.action_ = boostActionBuilder_.build();
      }
      if (actionCase_ == 7 && filterActionBuilder_ != null) {
        result.action_ = filterActionBuilder_.build();
      }
      if (actionCase_ == 9 && redirectActionBuilder_ != null) {
        result.action_ = redirectActionBuilder_.build();
      }
      if (actionCase_ == 10 && synonymsActionBuilder_ != null) {
        result.action_ = synonymsActionBuilder_.build();
      }
      if (actionCase_ == 15 && promoteActionBuilder_ != null) {
        result.action_ = promoteActionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.Control) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.Control) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Control other) {
      if (other == com.google.cloud.discoveryengine.v1.Control.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.associatedServingConfigIds_.isEmpty()) {
        if (associatedServingConfigIds_.isEmpty()) {
          associatedServingConfigIds_ = other.associatedServingConfigIds_;
          bitField0_ |= 0x00000080;
        } else {
          ensureAssociatedServingConfigIdsIsMutable();
          associatedServingConfigIds_.addAll(other.associatedServingConfigIds_);
        }
        onChanged();
      }
      if (other.solutionType_ != 0) {
        setSolutionTypeValue(other.getSolutionTypeValue());
      }
      if (!other.useCases_.isEmpty()) {
        if (useCases_.isEmpty()) {
          useCases_ = other.useCases_;
          bitField0_ = (bitField0_ & ~0x00000200);
        } else {
          ensureUseCasesIsMutable();
          useCases_.addAll(other.useCases_);
        }
        onChanged();
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00000400);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      switch (other.getActionCase()) {
        case BOOST_ACTION:
          {
            mergeBoostAction(other.getBoostAction());
            break;
          }
        case FILTER_ACTION:
          {
            mergeFilterAction(other.getFilterAction());
            break;
          }
        case REDIRECT_ACTION:
          {
            mergeRedirectAction(other.getRedirectAction());
            break;
          }
        case SYNONYMS_ACTION:
          {
            mergeSynonymsAction(other.getSynonymsAction());
            break;
          }
        case PROMOTE_ACTION:
          {
            mergePromoteAction(other.getPromoteAction());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAssociatedServingConfigIdsIsMutable();
                associatedServingConfigIds_.add(s);
                break;
              } // case 26
            case 32:
              {
                solutionType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 32
            case 42:
              {
                com.google.cloud.discoveryengine.v1.Condition m =
                    input.readMessage(
                        com.google.cloud.discoveryengine.v1.Condition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getBoostActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getFilterActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 7;
                break;
              } // case 58
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensureUseCasesIsMutable();
                useCases_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureUseCasesIsMutable();
                  useCases_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getRedirectActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getSynonymsActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 10;
                break;
              } // case 82
            case 122:
              {
                input.readMessage(getPromoteActionFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 15;
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.BoostAction,
            com.google.cloud.discoveryengine.v1.Control.BoostAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.BoostActionOrBuilder>
        boostActionBuilder_;

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     *
     * @return Whether the boostAction field is set.
     */
    @java.lang.Override
    public boolean hasBoostAction() {
      return actionCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     *
     * @return The boostAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.BoostAction getBoostAction() {
      if (boostActionBuilder_ == null) {
        if (actionCase_ == 6) {
          return (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance();
      } else {
        if (actionCase_ == 6) {
          return boostActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     */
    public Builder setBoostAction(com.google.cloud.discoveryengine.v1.Control.BoostAction value) {
      if (boostActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        boostActionBuilder_.setMessage(value);
      }
      actionCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     */
    public Builder setBoostAction(
        com.google.cloud.discoveryengine.v1.Control.BoostAction.Builder builderForValue) {
      if (boostActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        boostActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     */
    public Builder mergeBoostAction(com.google.cloud.discoveryengine.v1.Control.BoostAction value) {
      if (boostActionBuilder_ == null) {
        if (actionCase_ == 6
            && action_
                != com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1.Control.BoostAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 6) {
          boostActionBuilder_.mergeFrom(value);
        } else {
          boostActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     */
    public Builder clearBoostAction() {
      if (boostActionBuilder_ == null) {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 6) {
          actionCase_ = 0;
          action_ = null;
        }
        boostActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     */
    public com.google.cloud.discoveryengine.v1.Control.BoostAction.Builder getBoostActionBuilder() {
      return getBoostActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.BoostActionOrBuilder
        getBoostActionOrBuilder() {
      if ((actionCase_ == 6) && (boostActionBuilder_ != null)) {
        return boostActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 6) {
          return (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a boost-type control
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.BoostAction boost_action = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.BoostAction,
            com.google.cloud.discoveryengine.v1.Control.BoostAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.BoostActionOrBuilder>
        getBoostActionFieldBuilder() {
      if (boostActionBuilder_ == null) {
        if (!(actionCase_ == 6)) {
          action_ = com.google.cloud.discoveryengine.v1.Control.BoostAction.getDefaultInstance();
        }
        boostActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Control.BoostAction,
                com.google.cloud.discoveryengine.v1.Control.BoostAction.Builder,
                com.google.cloud.discoveryengine.v1.Control.BoostActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Control.BoostAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 6;
      onChanged();
      return boostActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.FilterAction,
            com.google.cloud.discoveryengine.v1.Control.FilterAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.FilterActionOrBuilder>
        filterActionBuilder_;

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     *
     * @return Whether the filterAction field is set.
     */
    @java.lang.Override
    public boolean hasFilterAction() {
      return actionCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     *
     * @return The filterAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.FilterAction getFilterAction() {
      if (filterActionBuilder_ == null) {
        if (actionCase_ == 7) {
          return (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance();
      } else {
        if (actionCase_ == 7) {
          return filterActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     */
    public Builder setFilterAction(com.google.cloud.discoveryengine.v1.Control.FilterAction value) {
      if (filterActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        filterActionBuilder_.setMessage(value);
      }
      actionCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     */
    public Builder setFilterAction(
        com.google.cloud.discoveryengine.v1.Control.FilterAction.Builder builderForValue) {
      if (filterActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        filterActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     */
    public Builder mergeFilterAction(
        com.google.cloud.discoveryengine.v1.Control.FilterAction value) {
      if (filterActionBuilder_ == null) {
        if (actionCase_ == 7
            && action_
                != com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1.Control.FilterAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 7) {
          filterActionBuilder_.mergeFrom(value);
        } else {
          filterActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     */
    public Builder clearFilterAction() {
      if (filterActionBuilder_ == null) {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 7) {
          actionCase_ = 0;
          action_ = null;
        }
        filterActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     */
    public com.google.cloud.discoveryengine.v1.Control.FilterAction.Builder
        getFilterActionBuilder() {
      return getFilterActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.FilterActionOrBuilder
        getFilterActionOrBuilder() {
      if ((actionCase_ == 7) && (filterActionBuilder_ != null)) {
        return filterActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 7) {
          return (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a filter-type control
     * Currently not supported by Recommendation
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.FilterAction filter_action = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.FilterAction,
            com.google.cloud.discoveryengine.v1.Control.FilterAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.FilterActionOrBuilder>
        getFilterActionFieldBuilder() {
      if (filterActionBuilder_ == null) {
        if (!(actionCase_ == 7)) {
          action_ = com.google.cloud.discoveryengine.v1.Control.FilterAction.getDefaultInstance();
        }
        filterActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Control.FilterAction,
                com.google.cloud.discoveryengine.v1.Control.FilterAction.Builder,
                com.google.cloud.discoveryengine.v1.Control.FilterActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Control.FilterAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 7;
      onChanged();
      return filterActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.RedirectAction,
            com.google.cloud.discoveryengine.v1.Control.RedirectAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.RedirectActionOrBuilder>
        redirectActionBuilder_;

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     *
     * @return Whether the redirectAction field is set.
     */
    @java.lang.Override
    public boolean hasRedirectAction() {
      return actionCase_ == 9;
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     *
     * @return The redirectAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.RedirectAction getRedirectAction() {
      if (redirectActionBuilder_ == null) {
        if (actionCase_ == 9) {
          return (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance();
      } else {
        if (actionCase_ == 9) {
          return redirectActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder setRedirectAction(
        com.google.cloud.discoveryengine.v1.Control.RedirectAction value) {
      if (redirectActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        redirectActionBuilder_.setMessage(value);
      }
      actionCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder setRedirectAction(
        com.google.cloud.discoveryengine.v1.Control.RedirectAction.Builder builderForValue) {
      if (redirectActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        redirectActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder mergeRedirectAction(
        com.google.cloud.discoveryengine.v1.Control.RedirectAction value) {
      if (redirectActionBuilder_ == null) {
        if (actionCase_ == 9
            && action_
                != com.google.cloud.discoveryengine.v1.Control.RedirectAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1.Control.RedirectAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 9) {
          redirectActionBuilder_.mergeFrom(value);
        } else {
          redirectActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     */
    public Builder clearRedirectAction() {
      if (redirectActionBuilder_ == null) {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 9) {
          actionCase_ = 0;
          action_ = null;
        }
        redirectActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     */
    public com.google.cloud.discoveryengine.v1.Control.RedirectAction.Builder
        getRedirectActionBuilder() {
      return getRedirectActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.RedirectActionOrBuilder
        getRedirectActionOrBuilder() {
      if ((actionCase_ == 9) && (redirectActionBuilder_ != null)) {
        return redirectActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 9) {
          return (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines a redirect-type control.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.RedirectAction redirect_action = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.RedirectAction,
            com.google.cloud.discoveryengine.v1.Control.RedirectAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.RedirectActionOrBuilder>
        getRedirectActionFieldBuilder() {
      if (redirectActionBuilder_ == null) {
        if (!(actionCase_ == 9)) {
          action_ = com.google.cloud.discoveryengine.v1.Control.RedirectAction.getDefaultInstance();
        }
        redirectActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Control.RedirectAction,
                com.google.cloud.discoveryengine.v1.Control.RedirectAction.Builder,
                com.google.cloud.discoveryengine.v1.Control.RedirectActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Control.RedirectAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 9;
      onChanged();
      return redirectActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.SynonymsAction,
            com.google.cloud.discoveryengine.v1.Control.SynonymsAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.SynonymsActionOrBuilder>
        synonymsActionBuilder_;

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     *
     * @return Whether the synonymsAction field is set.
     */
    @java.lang.Override
    public boolean hasSynonymsAction() {
      return actionCase_ == 10;
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     *
     * @return The synonymsAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.SynonymsAction getSynonymsAction() {
      if (synonymsActionBuilder_ == null) {
        if (actionCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance();
      } else {
        if (actionCase_ == 10) {
          return synonymsActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     */
    public Builder setSynonymsAction(
        com.google.cloud.discoveryengine.v1.Control.SynonymsAction value) {
      if (synonymsActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        synonymsActionBuilder_.setMessage(value);
      }
      actionCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     */
    public Builder setSynonymsAction(
        com.google.cloud.discoveryengine.v1.Control.SynonymsAction.Builder builderForValue) {
      if (synonymsActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        synonymsActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     */
    public Builder mergeSynonymsAction(
        com.google.cloud.discoveryengine.v1.Control.SynonymsAction value) {
      if (synonymsActionBuilder_ == null) {
        if (actionCase_ == 10
            && action_
                != com.google.cloud.discoveryengine.v1.Control.SynonymsAction
                    .getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1.Control.SynonymsAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 10) {
          synonymsActionBuilder_.mergeFrom(value);
        } else {
          synonymsActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     */
    public Builder clearSynonymsAction() {
      if (synonymsActionBuilder_ == null) {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 10) {
          actionCase_ = 0;
          action_ = null;
        }
        synonymsActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     */
    public com.google.cloud.discoveryengine.v1.Control.SynonymsAction.Builder
        getSynonymsActionBuilder() {
      return getSynonymsActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.SynonymsActionOrBuilder
        getSynonymsActionOrBuilder() {
      if ((actionCase_ == 10) && (synonymsActionBuilder_ != null)) {
        return synonymsActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 10) {
          return (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Treats a group of terms as synonyms of one another.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.SynonymsAction synonyms_action = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.SynonymsAction,
            com.google.cloud.discoveryengine.v1.Control.SynonymsAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.SynonymsActionOrBuilder>
        getSynonymsActionFieldBuilder() {
      if (synonymsActionBuilder_ == null) {
        if (!(actionCase_ == 10)) {
          action_ = com.google.cloud.discoveryengine.v1.Control.SynonymsAction.getDefaultInstance();
        }
        synonymsActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Control.SynonymsAction,
                com.google.cloud.discoveryengine.v1.Control.SynonymsAction.Builder,
                com.google.cloud.discoveryengine.v1.Control.SynonymsActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Control.SynonymsAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 10;
      onChanged();
      return synonymsActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.PromoteAction,
            com.google.cloud.discoveryengine.v1.Control.PromoteAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.PromoteActionOrBuilder>
        promoteActionBuilder_;

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     *
     * @return Whether the promoteAction field is set.
     */
    @java.lang.Override
    public boolean hasPromoteAction() {
      return actionCase_ == 15;
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     *
     * @return The promoteAction.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.PromoteAction getPromoteAction() {
      if (promoteActionBuilder_ == null) {
        if (actionCase_ == 15) {
          return (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance();
      } else {
        if (actionCase_ == 15) {
          return promoteActionBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     */
    public Builder setPromoteAction(
        com.google.cloud.discoveryengine.v1.Control.PromoteAction value) {
      if (promoteActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        promoteActionBuilder_.setMessage(value);
      }
      actionCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     */
    public Builder setPromoteAction(
        com.google.cloud.discoveryengine.v1.Control.PromoteAction.Builder builderForValue) {
      if (promoteActionBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        promoteActionBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     */
    public Builder mergePromoteAction(
        com.google.cloud.discoveryengine.v1.Control.PromoteAction value) {
      if (promoteActionBuilder_ == null) {
        if (actionCase_ == 15
            && action_
                != com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance()) {
          action_ =
              com.google.cloud.discoveryengine.v1.Control.PromoteAction.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 15) {
          promoteActionBuilder_.mergeFrom(value);
        } else {
          promoteActionBuilder_.setMessage(value);
        }
      }
      actionCase_ = 15;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     */
    public Builder clearPromoteAction() {
      if (promoteActionBuilder_ == null) {
        if (actionCase_ == 15) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 15) {
          actionCase_ = 0;
          action_ = null;
        }
        promoteActionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     */
    public com.google.cloud.discoveryengine.v1.Control.PromoteAction.Builder
        getPromoteActionBuilder() {
      return getPromoteActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Control.PromoteActionOrBuilder
        getPromoteActionOrBuilder() {
      if ((actionCase_ == 15) && (promoteActionBuilder_ != null)) {
        return promoteActionBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 15) {
          return (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_;
        }
        return com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Promote certain links based on predefined trigger queries.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Control.PromoteAction promote_action = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Control.PromoteAction,
            com.google.cloud.discoveryengine.v1.Control.PromoteAction.Builder,
            com.google.cloud.discoveryengine.v1.Control.PromoteActionOrBuilder>
        getPromoteActionFieldBuilder() {
      if (promoteActionBuilder_ == null) {
        if (!(actionCase_ == 15)) {
          action_ = com.google.cloud.discoveryengine.v1.Control.PromoteAction.getDefaultInstance();
        }
        promoteActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Control.PromoteAction,
                com.google.cloud.discoveryengine.v1.Control.PromoteAction.Builder,
                com.google.cloud.discoveryengine.v1.Control.PromoteActionOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Control.PromoteAction) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 15;
      onChanged();
      return promoteActionBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Fully qualified name
     * `projects/&#42;&#47;locations/global/dataStore/&#42;&#47;controls/&#42;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Human readable name. The identifier used in UI views.
     *
     * Must be UTF-8 encoded string. Length limit is 128 characters.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList associatedServingConfigIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAssociatedServingConfigIdsIsMutable() {
      if (!associatedServingConfigIds_.isModifiable()) {
        associatedServingConfigIds_ =
            new com.google.protobuf.LazyStringArrayList(associatedServingConfigIds_);
      }
      bitField0_ |= 0x00000080;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the associatedServingConfigIds.
     */
    public com.google.protobuf.ProtocolStringList getAssociatedServingConfigIdsList() {
      associatedServingConfigIds_.makeImmutable();
      return associatedServingConfigIds_;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of associatedServingConfigIds.
     */
    public int getAssociatedServingConfigIdsCount() {
      return associatedServingConfigIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The associatedServingConfigIds at the given index.
     */
    public java.lang.String getAssociatedServingConfigIds(int index) {
      return associatedServingConfigIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the associatedServingConfigIds at the given index.
     */
    public com.google.protobuf.ByteString getAssociatedServingConfigIdsBytes(int index) {
      return associatedServingConfigIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The associatedServingConfigIds to set.
     * @return This builder for chaining.
     */
    public Builder setAssociatedServingConfigIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAssociatedServingConfigIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllAssociatedServingConfigIds(java.lang.Iterable<java.lang.String> values) {
      ensureAssociatedServingConfigIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, associatedServingConfigIds_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssociatedServingConfigIds() {
      associatedServingConfigIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. List of all
     * [ServingConfig][google.cloud.discoveryengine.v1.ServingConfig] IDs this
     * control is attached to. May take up to 10 minutes to update after changes.
     * </pre>
     *
     * <code>
     * repeated string associated_serving_config_ids = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the associatedServingConfigIds to add.
     * @return This builder for chaining.
     */
    public Builder addAssociatedServingConfigIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAssociatedServingConfigIdsIsMutable();
      associatedServingConfigIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int solutionType_ = 0;

    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for solutionType.
     */
    @java.lang.Override
    public int getSolutionTypeValue() {
      return solutionType_;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypeValue(int value) {
      solutionType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The solutionType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SolutionType getSolutionType() {
      com.google.cloud.discoveryengine.v1.SolutionType result =
          com.google.cloud.discoveryengine.v1.SolutionType.forNumber(solutionType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.SolutionType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionType(com.google.cloud.discoveryengine.v1.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      solutionType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Immutable. What solution the control belongs to.
     *
     * Must be compatible with vertical of resource.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      solutionType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> useCases_ = java.util.Collections.emptyList();

    private void ensureUseCasesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        useCases_ = new java.util.ArrayList<java.lang.Integer>(useCases_);
        bitField0_ |= 0x00000200;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @return A list containing the useCases.
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.SearchUseCase> getUseCasesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchUseCase>(
          useCases_, useCases_converter_);
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @return The count of useCases.
     */
    public int getUseCasesCount() {
      return useCases_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The useCases at the given index.
     */
    public com.google.cloud.discoveryengine.v1.SearchUseCase getUseCases(int index) {
      return useCases_converter_.convert(useCases_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The useCases to set.
     * @return This builder for chaining.
     */
    public Builder setUseCases(int index, com.google.cloud.discoveryengine.v1.SearchUseCase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUseCasesIsMutable();
      useCases_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param value The useCases to add.
     * @return This builder for chaining.
     */
    public Builder addUseCases(com.google.cloud.discoveryengine.v1.SearchUseCase value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUseCasesIsMutable();
      useCases_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param values The useCases to add.
     * @return This builder for chaining.
     */
    public Builder addAllUseCases(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.SearchUseCase> values) {
      ensureUseCasesIsMutable();
      for (com.google.cloud.discoveryengine.v1.SearchUseCase value : values) {
        useCases_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUseCases() {
      useCases_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @return A list containing the enum numeric values on the wire for useCases.
     */
    public java.util.List<java.lang.Integer> getUseCasesValueList() {
      return java.util.Collections.unmodifiableList(useCases_);
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of useCases at the given index.
     */
    public int getUseCasesValue(int index) {
      return useCases_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for useCases to set.
     * @return This builder for chaining.
     */
    public Builder setUseCasesValue(int index, int value) {
      ensureUseCasesIsMutable();
      useCases_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param value The enum numeric value on the wire for useCases to add.
     * @return This builder for chaining.
     */
    public Builder addUseCasesValue(int value) {
      ensureUseCasesIsMutable();
      useCases_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the use case for the control.
     * Affects what condition fields can be set.
     * Only applies to
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * Currently only allow one use case per control.
     * Must be set when solution_type is
     * [SolutionType.SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchUseCase use_cases = 8;</code>
     *
     * @param values The enum numeric values on the wire for useCases to add.
     * @return This builder for chaining.
     */
    public Builder addAllUseCasesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureUseCasesIsMutable();
      for (int value : values) {
        useCases_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.discoveryengine.v1.Condition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        conditions_ =
            new java.util.ArrayList<com.google.cloud.discoveryengine.v1.Condition>(conditions_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Condition,
            com.google.cloud.discoveryengine.v1.Condition.Builder,
            com.google.cloud.discoveryengine.v1.ConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Condition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Condition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder setConditions(int index, com.google.cloud.discoveryengine.v1.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder setConditions(
        int index, com.google.cloud.discoveryengine.v1.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder addConditions(com.google.cloud.discoveryengine.v1.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder addConditions(int index, com.google.cloud.discoveryengine.v1.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder addConditions(
        com.google.cloud.discoveryengine.v1.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder addConditions(
        int index, com.google.cloud.discoveryengine.v1.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.Condition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Condition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.ConditionOrBuilder getConditionsOrBuilder(
        int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.discoveryengine.v1.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Condition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.cloud.discoveryengine.v1.Condition.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1.Condition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.cloud.discoveryengine.v1.Condition.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Determines when the associated action will trigger.
     *
     * Omit to always apply the action.
     * Currently only a single condition may be specified.
     * Otherwise an INVALID ARGUMENT error is thrown.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.Condition conditions = 5;</code>
     */
    public java.util.List<com.google.cloud.discoveryengine.v1.Condition.Builder>
        getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Condition,
            com.google.cloud.discoveryengine.v1.Condition.Builder,
            com.google.cloud.discoveryengine.v1.ConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Condition,
                com.google.cloud.discoveryengine.v1.Condition.Builder,
                com.google.cloud.discoveryengine.v1.ConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Control)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Control)
  private static final com.google.cloud.discoveryengine.v1.Control DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Control();
  }

  public static com.google.cloud.discoveryengine.v1.Control getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Control> PARSER =
      new com.google.protobuf.AbstractParser<Control>() {
        @java.lang.Override
        public Control parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Control> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Control> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Control getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
