/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/identity_mapping_store_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [IdentityMappingStoreService.CreateIdentityMappingStore][google.cloud.discoveryengine.v1.IdentityMappingStoreService.CreateIdentityMappingStore]
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest}
 */
public final class CreateIdentityMappingStoreRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest)
    CreateIdentityMappingStoreRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CreateIdentityMappingStoreRequest.newBuilder() to construct.
  private CreateIdentityMappingStoreRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateIdentityMappingStoreRequest() {
    parent_ = "";
    identityMappingStoreId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateIdentityMappingStoreRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CreateIdentityMappingStoreRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
        .internal_static_google_cloud_discoveryengine_v1_CreateIdentityMappingStoreRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest.class,
            com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest.Builder.class);
  }

  private int bitField0_;
  private int cmekOptionsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object cmekOptions_;

  public enum CmekOptionsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CMEK_CONFIG_NAME(5),
    DISABLE_CMEK(6),
    CMEKOPTIONS_NOT_SET(0);
    private final int value;

    private CmekOptionsCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CmekOptionsCase valueOf(int value) {
      return forNumber(value);
    }

    public static CmekOptionsCase forNumber(int value) {
      switch (value) {
        case 5:
          return CMEK_CONFIG_NAME;
        case 6:
          return DISABLE_CMEK;
        case 0:
          return CMEKOPTIONS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CmekOptionsCase getCmekOptionsCase() {
    return CmekOptionsCase.forNumber(cmekOptionsCase_);
  }

  public static final int CMEK_CONFIG_NAME_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Resource name of the CmekConfig to use for protecting this Identity
   * Mapping Store.
   * </pre>
   *
   * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the cmekConfigName field is set.
   */
  public boolean hasCmekConfigName() {
    return cmekOptionsCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Resource name of the CmekConfig to use for protecting this Identity
   * Mapping Store.
   * </pre>
   *
   * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The cmekConfigName.
   */
  public java.lang.String getCmekConfigName() {
    java.lang.Object ref = "";
    if (cmekOptionsCase_ == 5) {
      ref = cmekOptions_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (cmekOptionsCase_ == 5) {
        cmekOptions_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Resource name of the CmekConfig to use for protecting this Identity
   * Mapping Store.
   * </pre>
   *
   * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for cmekConfigName.
   */
  public com.google.protobuf.ByteString getCmekConfigNameBytes() {
    java.lang.Object ref = "";
    if (cmekOptionsCase_ == 5) {
      ref = cmekOptions_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (cmekOptionsCase_ == 5) {
        cmekOptions_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_CMEK_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Identity Mapping Store without CMEK protections. If a default CmekConfig
   * is set for the project, setting this field will override the default
   * CmekConfig as well.
   * </pre>
   *
   * <code>bool disable_cmek = 6;</code>
   *
   * @return Whether the disableCmek field is set.
   */
  @java.lang.Override
  public boolean hasDisableCmek() {
    return cmekOptionsCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Identity Mapping Store without CMEK protections. If a default CmekConfig
   * is set for the project, setting this field will override the default
   * CmekConfig as well.
   * </pre>
   *
   * <code>bool disable_cmek = 6;</code>
   *
   * @return The disableCmek.
   */
  @java.lang.Override
  public boolean getDisableCmek() {
    if (cmekOptionsCase_ == 6) {
      return (java.lang.Boolean) cmekOptions_;
    }
    return false;
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The parent collection resource name, such as
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The parent collection resource name, such as
   * `projects/{project}/locations/{location}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IDENTITY_MAPPING_STORE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object identityMappingStoreId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The ID of the Identity Mapping Store to create.
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
   * (_), and hyphens (-). The maximum length is 63 characters.
   * </pre>
   *
   * <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The identityMappingStoreId.
   */
  @java.lang.Override
  public java.lang.String getIdentityMappingStoreId() {
    java.lang.Object ref = identityMappingStoreId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      identityMappingStoreId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The ID of the Identity Mapping Store to create.
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
   * (_), and hyphens (-). The maximum length is 63 characters.
   * </pre>
   *
   * <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for identityMappingStoreId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdentityMappingStoreIdBytes() {
    java.lang.Object ref = identityMappingStoreId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      identityMappingStoreId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IDENTITY_MAPPING_STORE_FIELD_NUMBER = 3;
  private com.google.cloud.discoveryengine.v1.IdentityMappingStore identityMappingStore_;

  /**
   *
   *
   * <pre>
   * Required. The Identity Mapping Store to create.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the identityMappingStore field is set.
   */
  @java.lang.Override
  public boolean hasIdentityMappingStore() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The Identity Mapping Store to create.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The identityMappingStore.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.IdentityMappingStore getIdentityMappingStore() {
    return identityMappingStore_ == null
        ? com.google.cloud.discoveryengine.v1.IdentityMappingStore.getDefaultInstance()
        : identityMappingStore_;
  }

  /**
   *
   *
   * <pre>
   * Required. The Identity Mapping Store to create.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.IdentityMappingStoreOrBuilder
      getIdentityMappingStoreOrBuilder() {
    return identityMappingStore_ == null
        ? com.google.cloud.discoveryengine.v1.IdentityMappingStore.getDefaultInstance()
        : identityMappingStore_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityMappingStoreId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, identityMappingStoreId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getIdentityMappingStore());
    }
    if (cmekOptionsCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, cmekOptions_);
    }
    if (cmekOptionsCase_ == 6) {
      output.writeBool(6, (boolean) ((java.lang.Boolean) cmekOptions_));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityMappingStoreId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, identityMappingStoreId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getIdentityMappingStore());
    }
    if (cmekOptionsCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, cmekOptions_);
    }
    if (cmekOptionsCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              6, (boolean) ((java.lang.Boolean) cmekOptions_));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest other =
        (com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getIdentityMappingStoreId().equals(other.getIdentityMappingStoreId())) return false;
    if (hasIdentityMappingStore() != other.hasIdentityMappingStore()) return false;
    if (hasIdentityMappingStore()) {
      if (!getIdentityMappingStore().equals(other.getIdentityMappingStore())) return false;
    }
    if (!getCmekOptionsCase().equals(other.getCmekOptionsCase())) return false;
    switch (cmekOptionsCase_) {
      case 5:
        if (!getCmekConfigName().equals(other.getCmekConfigName())) return false;
        break;
      case 6:
        if (getDisableCmek() != other.getDisableCmek()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + IDENTITY_MAPPING_STORE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getIdentityMappingStoreId().hashCode();
    if (hasIdentityMappingStore()) {
      hash = (37 * hash) + IDENTITY_MAPPING_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getIdentityMappingStore().hashCode();
    }
    switch (cmekOptionsCase_) {
      case 5:
        hash = (37 * hash) + CMEK_CONFIG_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getCmekConfigName().hashCode();
        break;
      case 6:
        hash = (37 * hash) + DISABLE_CMEK_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableCmek());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [IdentityMappingStoreService.CreateIdentityMappingStore][google.cloud.discoveryengine.v1.IdentityMappingStoreService.CreateIdentityMappingStore]
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest)
      com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CreateIdentityMappingStoreRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CreateIdentityMappingStoreRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest.class,
              com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getIdentityMappingStoreFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      identityMappingStoreId_ = "";
      identityMappingStore_ = null;
      if (identityMappingStoreBuilder_ != null) {
        identityMappingStoreBuilder_.dispose();
        identityMappingStoreBuilder_ = null;
      }
      cmekOptionsCase_ = 0;
      cmekOptions_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_CreateIdentityMappingStoreRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest build() {
      com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest result =
          new com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.identityMappingStoreId_ = identityMappingStoreId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.identityMappingStore_ =
            identityMappingStoreBuilder_ == null
                ? identityMappingStore_
                : identityMappingStoreBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest result) {
      result.cmekOptionsCase_ = cmekOptionsCase_;
      result.cmekOptions_ = this.cmekOptions_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getIdentityMappingStoreId().isEmpty()) {
        identityMappingStoreId_ = other.identityMappingStoreId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasIdentityMappingStore()) {
        mergeIdentityMappingStore(other.getIdentityMappingStore());
      }
      switch (other.getCmekOptionsCase()) {
        case CMEK_CONFIG_NAME:
          {
            cmekOptionsCase_ = 5;
            cmekOptions_ = other.cmekOptions_;
            onChanged();
            break;
          }
        case DISABLE_CMEK:
          {
            setDisableCmek(other.getDisableCmek());
            break;
          }
        case CMEKOPTIONS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                identityMappingStoreId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getIdentityMappingStoreFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                cmekOptionsCase_ = 5;
                cmekOptions_ = s;
                break;
              } // case 42
            case 48:
              {
                cmekOptions_ = input.readBool();
                cmekOptionsCase_ = 6;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int cmekOptionsCase_ = 0;
    private java.lang.Object cmekOptions_;

    public CmekOptionsCase getCmekOptionsCase() {
      return CmekOptionsCase.forNumber(cmekOptionsCase_);
    }

    public Builder clearCmekOptions() {
      cmekOptionsCase_ = 0;
      cmekOptions_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     * </pre>
     *
     * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the cmekConfigName field is set.
     */
    @java.lang.Override
    public boolean hasCmekConfigName() {
      return cmekOptionsCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     * </pre>
     *
     * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The cmekConfigName.
     */
    @java.lang.Override
    public java.lang.String getCmekConfigName() {
      java.lang.Object ref = "";
      if (cmekOptionsCase_ == 5) {
        ref = cmekOptions_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (cmekOptionsCase_ == 5) {
          cmekOptions_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     * </pre>
     *
     * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for cmekConfigName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCmekConfigNameBytes() {
      java.lang.Object ref = "";
      if (cmekOptionsCase_ == 5) {
        ref = cmekOptions_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (cmekOptionsCase_ == 5) {
          cmekOptions_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     * </pre>
     *
     * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The cmekConfigName to set.
     * @return This builder for chaining.
     */
    public Builder setCmekConfigName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cmekOptionsCase_ = 5;
      cmekOptions_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     * </pre>
     *
     * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCmekConfigName() {
      if (cmekOptionsCase_ == 5) {
        cmekOptionsCase_ = 0;
        cmekOptions_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name of the CmekConfig to use for protecting this Identity
     * Mapping Store.
     * </pre>
     *
     * <code>string cmek_config_name = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for cmekConfigName to set.
     * @return This builder for chaining.
     */
    public Builder setCmekConfigNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cmekOptionsCase_ = 5;
      cmekOptions_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identity Mapping Store without CMEK protections. If a default CmekConfig
     * is set for the project, setting this field will override the default
     * CmekConfig as well.
     * </pre>
     *
     * <code>bool disable_cmek = 6;</code>
     *
     * @return Whether the disableCmek field is set.
     */
    public boolean hasDisableCmek() {
      return cmekOptionsCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Identity Mapping Store without CMEK protections. If a default CmekConfig
     * is set for the project, setting this field will override the default
     * CmekConfig as well.
     * </pre>
     *
     * <code>bool disable_cmek = 6;</code>
     *
     * @return The disableCmek.
     */
    public boolean getDisableCmek() {
      if (cmekOptionsCase_ == 6) {
        return (java.lang.Boolean) cmekOptions_;
      }
      return false;
    }

    /**
     *
     *
     * <pre>
     * Identity Mapping Store without CMEK protections. If a default CmekConfig
     * is set for the project, setting this field will override the default
     * CmekConfig as well.
     * </pre>
     *
     * <code>bool disable_cmek = 6;</code>
     *
     * @param value The disableCmek to set.
     * @return This builder for chaining.
     */
    public Builder setDisableCmek(boolean value) {

      cmekOptionsCase_ = 6;
      cmekOptions_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identity Mapping Store without CMEK protections. If a default CmekConfig
     * is set for the project, setting this field will override the default
     * CmekConfig as well.
     * </pre>
     *
     * <code>bool disable_cmek = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableCmek() {
      if (cmekOptionsCase_ == 6) {
        cmekOptionsCase_ = 0;
        cmekOptions_ = null;
        onChanged();
      }
      return this;
    }

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent collection resource name, such as
     * `projects/{project}/locations/{location}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object identityMappingStoreId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The ID of the Identity Mapping Store to create.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     * </pre>
     *
     * <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The identityMappingStoreId.
     */
    public java.lang.String getIdentityMappingStoreId() {
      java.lang.Object ref = identityMappingStoreId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        identityMappingStoreId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the Identity Mapping Store to create.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     * </pre>
     *
     * <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for identityMappingStoreId.
     */
    public com.google.protobuf.ByteString getIdentityMappingStoreIdBytes() {
      java.lang.Object ref = identityMappingStoreId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        identityMappingStoreId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the Identity Mapping Store to create.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     * </pre>
     *
     * <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The identityMappingStoreId to set.
     * @return This builder for chaining.
     */
    public Builder setIdentityMappingStoreId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      identityMappingStoreId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the Identity Mapping Store to create.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     * </pre>
     *
     * <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdentityMappingStoreId() {
      identityMappingStoreId_ = getDefaultInstance().getIdentityMappingStoreId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The ID of the Identity Mapping Store to create.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores
     * (_), and hyphens (-). The maximum length is 63 characters.
     * </pre>
     *
     * <code>string identity_mapping_store_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for identityMappingStoreId to set.
     * @return This builder for chaining.
     */
    public Builder setIdentityMappingStoreIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      identityMappingStoreId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.IdentityMappingStore identityMappingStore_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.IdentityMappingStore,
            com.google.cloud.discoveryengine.v1.IdentityMappingStore.Builder,
            com.google.cloud.discoveryengine.v1.IdentityMappingStoreOrBuilder>
        identityMappingStoreBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the identityMappingStore field is set.
     */
    public boolean hasIdentityMappingStore() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The identityMappingStore.
     */
    public com.google.cloud.discoveryengine.v1.IdentityMappingStore getIdentityMappingStore() {
      if (identityMappingStoreBuilder_ == null) {
        return identityMappingStore_ == null
            ? com.google.cloud.discoveryengine.v1.IdentityMappingStore.getDefaultInstance()
            : identityMappingStore_;
      } else {
        return identityMappingStoreBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setIdentityMappingStore(
        com.google.cloud.discoveryengine.v1.IdentityMappingStore value) {
      if (identityMappingStoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identityMappingStore_ = value;
      } else {
        identityMappingStoreBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setIdentityMappingStore(
        com.google.cloud.discoveryengine.v1.IdentityMappingStore.Builder builderForValue) {
      if (identityMappingStoreBuilder_ == null) {
        identityMappingStore_ = builderForValue.build();
      } else {
        identityMappingStoreBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeIdentityMappingStore(
        com.google.cloud.discoveryengine.v1.IdentityMappingStore value) {
      if (identityMappingStoreBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && identityMappingStore_ != null
            && identityMappingStore_
                != com.google.cloud.discoveryengine.v1.IdentityMappingStore.getDefaultInstance()) {
          getIdentityMappingStoreBuilder().mergeFrom(value);
        } else {
          identityMappingStore_ = value;
        }
      } else {
        identityMappingStoreBuilder_.mergeFrom(value);
      }
      if (identityMappingStore_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearIdentityMappingStore() {
      bitField0_ = (bitField0_ & ~0x00000010);
      identityMappingStore_ = null;
      if (identityMappingStoreBuilder_ != null) {
        identityMappingStoreBuilder_.dispose();
        identityMappingStoreBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.IdentityMappingStore.Builder
        getIdentityMappingStoreBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getIdentityMappingStoreFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.IdentityMappingStoreOrBuilder
        getIdentityMappingStoreOrBuilder() {
      if (identityMappingStoreBuilder_ != null) {
        return identityMappingStoreBuilder_.getMessageOrBuilder();
      } else {
        return identityMappingStore_ == null
            ? com.google.cloud.discoveryengine.v1.IdentityMappingStore.getDefaultInstance()
            : identityMappingStore_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Identity Mapping Store to create.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IdentityMappingStore identity_mapping_store = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.IdentityMappingStore,
            com.google.cloud.discoveryengine.v1.IdentityMappingStore.Builder,
            com.google.cloud.discoveryengine.v1.IdentityMappingStoreOrBuilder>
        getIdentityMappingStoreFieldBuilder() {
      if (identityMappingStoreBuilder_ == null) {
        identityMappingStoreBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.IdentityMappingStore,
                com.google.cloud.discoveryengine.v1.IdentityMappingStore.Builder,
                com.google.cloud.discoveryengine.v1.IdentityMappingStoreOrBuilder>(
                getIdentityMappingStore(), getParentForChildren(), isClean());
        identityMappingStore_ = null;
      }
      return identityMappingStoreBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest)
  private static final com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest();
  }

  public static com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateIdentityMappingStoreRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateIdentityMappingStoreRequest>() {
        @java.lang.Override
        public CreateIdentityMappingStoreRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateIdentityMappingStoreRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateIdentityMappingStoreRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CreateIdentityMappingStoreRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
