/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/user_event.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

public interface DocumentInfoOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.DocumentInfo)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] resource ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] resource ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The id.
   */
  java.lang.String getId();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] resource ID.
   * </pre>
   *
   * <code>string id = 1;</code>
   *
   * @return The bytes for id.
   */
  com.google.protobuf.ByteString getIdBytes();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] resource full
   * name, of the form:
   * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] resource full
   * name, of the form:
   * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] resource full
   * name, of the form:
   * `projects/{project}/locations/{location}/collections/{collection_id}/dataStores/{data_store_id}/branches/{branch_id}/documents/{document_id}`
   * </pre>
   *
   * <code>string name = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] URI - only
   * allowed for website data stores.
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return Whether the uri field is set.
   */
  boolean hasUri();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] URI - only
   * allowed for website data stores.
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return The uri.
   */
  java.lang.String getUri();

  /**
   *
   *
   * <pre>
   * The [Document][google.cloud.discoveryengine.v1.Document] URI - only
   * allowed for website data stores.
   * </pre>
   *
   * <code>string uri = 6;</code>
   *
   * @return The bytes for uri.
   */
  com.google.protobuf.ByteString getUriBytes();

  /**
   *
   *
   * <pre>
   * Quantity of the Document associated with the user event. Defaults to 1.
   *
   * For example, this field is 2 if two quantities of the same Document
   * are involved in a `add-to-cart` event.
   *
   * Required for events of the following event types:
   *
   * * `add-to-cart`
   * * `purchase`
   * </pre>
   *
   * <code>optional int32 quantity = 3;</code>
   *
   * @return Whether the quantity field is set.
   */
  boolean hasQuantity();

  /**
   *
   *
   * <pre>
   * Quantity of the Document associated with the user event. Defaults to 1.
   *
   * For example, this field is 2 if two quantities of the same Document
   * are involved in a `add-to-cart` event.
   *
   * Required for events of the following event types:
   *
   * * `add-to-cart`
   * * `purchase`
   * </pre>
   *
   * <code>optional int32 quantity = 3;</code>
   *
   * @return The quantity.
   */
  int getQuantity();

  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @return A list containing the promotionIds.
   */
  java.util.List<java.lang.String> getPromotionIdsList();

  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @return The count of promotionIds.
   */
  int getPromotionIdsCount();

  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The promotionIds at the given index.
   */
  java.lang.String getPromotionIds(int index);

  /**
   *
   *
   * <pre>
   * The promotion IDs associated with this Document.
   * Currently, this field is restricted to at most one ID.
   * </pre>
   *
   * <code>repeated string promotion_ids = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the promotionIds at the given index.
   */
  com.google.protobuf.ByteString getPromotionIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. Whether the referenced Document can be found in the data
   * store.
   * </pre>
   *
   * <code>bool joined = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The joined.
   */
  boolean getJoined();

  /**
   *
   *
   * <pre>
   * Optional. The conversion value associated with this Document.
   * Must be set if
   * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
   * is "conversion".
   *
   * For example, a value of 1000 signifies that 1000 seconds were spent viewing
   * a Document for the `watch` conversion type.
   * </pre>
   *
   * <code>optional float conversion_value = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the conversionValue field is set.
   */
  boolean hasConversionValue();

  /**
   *
   *
   * <pre>
   * Optional. The conversion value associated with this Document.
   * Must be set if
   * [UserEvent.event_type][google.cloud.discoveryengine.v1.UserEvent.event_type]
   * is "conversion".
   *
   * For example, a value of 1000 signifies that 1000 seconds were spent viewing
   * a Document for the `watch` conversion type.
   * </pre>
   *
   * <code>optional float conversion_value = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The conversionValue.
   */
  float getConversionValue();

  com.google.cloud.discoveryengine.v1.DocumentInfo.DocumentDescriptorCase
      getDocumentDescriptorCase();
}
