/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/engine.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Metadata that describes the training and serving parameters of an
 * [Engine][google.cloud.discoveryengine.v1.Engine].
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.Engine}
 */
public final class Engine extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine)
    EngineOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Engine.newBuilder() to construct.
  private Engine(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Engine() {
    name_ = "";
    displayName_ = "";
    dataStoreIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    solutionType_ = 0;
    industryVertical_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Engine();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.EngineProto
        .internal_static_google_cloud_discoveryengine_v1_Engine_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.EngineProto
        .internal_static_google_cloud_discoveryengine_v1_Engine_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.Engine.class,
            com.google.cloud.discoveryengine.v1.Engine.Builder.class);
  }

  public interface SearchEngineConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.SearchEngineConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
     *
     * @return The enum numeric value on the wire for searchTier.
     */
    int getSearchTierValue();

    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
     *
     * @return The searchTier.
     */
    com.google.cloud.discoveryengine.v1.SearchTier getSearchTier();

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the searchAddOns.
     */
    java.util.List<com.google.cloud.discoveryengine.v1.SearchAddOn> getSearchAddOnsList();

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @return The count of searchAddOns.
     */
    int getSearchAddOnsCount();

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The searchAddOns at the given index.
     */
    com.google.cloud.discoveryengine.v1.SearchAddOn getSearchAddOns(int index);

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the enum numeric values on the wire for searchAddOns.
     */
    java.util.List<java.lang.Integer> getSearchAddOnsValueList();

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of searchAddOns at the given index.
     */
    int getSearchAddOnsValue(int index);
  }

  /**
   *
   *
   * <pre>
   * Configurations for a Search Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.SearchEngineConfig}
   */
  public static final class SearchEngineConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.SearchEngineConfig)
      SearchEngineConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SearchEngineConfig.newBuilder() to construct.
    private SearchEngineConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SearchEngineConfig() {
      searchTier_ = 0;
      searchAddOns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SearchEngineConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_SearchEngineConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_SearchEngineConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.class,
              com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.Builder.class);
    }

    public static final int SEARCH_TIER_FIELD_NUMBER = 1;
    private int searchTier_ = 0;

    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
     *
     * @return The enum numeric value on the wire for searchTier.
     */
    @java.lang.Override
    public int getSearchTierValue() {
      return searchTier_;
    }

    /**
     *
     *
     * <pre>
     * The search feature tier of this engine.
     *
     * Different tiers might have different
     * pricing. To learn more, check the pricing documentation.
     *
     * Defaults to
     * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
     *
     * @return The searchTier.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchTier getSearchTier() {
      com.google.cloud.discoveryengine.v1.SearchTier result =
          com.google.cloud.discoveryengine.v1.SearchTier.forNumber(searchTier_);
      return result == null ? com.google.cloud.discoveryengine.v1.SearchTier.UNRECOGNIZED : result;
    }

    public static final int SEARCH_ADD_ONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> searchAddOns_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchAddOn>
        searchAddOns_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchAddOn>() {
              public com.google.cloud.discoveryengine.v1.SearchAddOn convert(
                  java.lang.Integer from) {
                com.google.cloud.discoveryengine.v1.SearchAddOn result =
                    com.google.cloud.discoveryengine.v1.SearchAddOn.forNumber(from);
                return result == null
                    ? com.google.cloud.discoveryengine.v1.SearchAddOn.UNRECOGNIZED
                    : result;
              }
            };

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the searchAddOns.
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.SearchAddOn> getSearchAddOnsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchAddOn>(
          searchAddOns_, searchAddOns_converter_);
    }

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @return The count of searchAddOns.
     */
    @java.lang.Override
    public int getSearchAddOnsCount() {
      return searchAddOns_.size();
    }

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The searchAddOns at the given index.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SearchAddOn getSearchAddOns(int index) {
      return searchAddOns_converter_.convert(searchAddOns_.get(index));
    }

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @return A list containing the enum numeric values on the wire for searchAddOns.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getSearchAddOnsValueList() {
      return searchAddOns_;
    }

    /**
     *
     *
     * <pre>
     * The add-on that this search engine enables.
     * </pre>
     *
     * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of searchAddOns at the given index.
     */
    @java.lang.Override
    public int getSearchAddOnsValue(int index) {
      return searchAddOns_.get(index);
    }

    private int searchAddOnsMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (searchTier_
          != com.google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, searchTier_);
      }
      if (getSearchAddOnsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(searchAddOnsMemoizedSerializedSize);
      }
      for (int i = 0; i < searchAddOns_.size(); i++) {
        output.writeEnumNoTag(searchAddOns_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (searchTier_
          != com.google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, searchTier_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < searchAddOns_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(searchAddOns_.get(i));
        }
        size += dataSize;
        if (!getSearchAddOnsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        searchAddOnsMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig other =
          (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) obj;

      if (searchTier_ != other.searchTier_) return false;
      if (!searchAddOns_.equals(other.searchAddOns_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SEARCH_TIER_FIELD_NUMBER;
      hash = (53 * hash) + searchTier_;
      if (getSearchAddOnsCount() > 0) {
        hash = (37 * hash) + SEARCH_ADD_ONS_FIELD_NUMBER;
        hash = (53 * hash) + searchAddOns_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configurations for a Search Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.SearchEngineConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.SearchEngineConfig)
        com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_SearchEngineConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_SearchEngineConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        searchTier_ = 0;
        searchAddOns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_SearchEngineConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig build() {
        com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig buildPartial() {
        com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig result =
            new com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          searchAddOns_ = java.util.Collections.unmodifiableList(searchAddOns_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.searchAddOns_ = searchAddOns_;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.searchTier_ = searchTier_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance())
          return this;
        if (other.searchTier_ != 0) {
          setSearchTierValue(other.getSearchTierValue());
        }
        if (!other.searchAddOns_.isEmpty()) {
          if (searchAddOns_.isEmpty()) {
            searchAddOns_ = other.searchAddOns_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSearchAddOnsIsMutable();
            searchAddOns_.addAll(other.searchAddOns_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  searchTier_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  int tmpRaw = input.readEnum();
                  ensureSearchAddOnsIsMutable();
                  searchAddOns_.add(tmpRaw);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureSearchAddOnsIsMutable();
                    searchAddOns_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int searchTier_ = 0;

      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
       *
       * @return The enum numeric value on the wire for searchTier.
       */
      @java.lang.Override
      public int getSearchTierValue() {
        return searchTier_;
      }

      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
       *
       * @param value The enum numeric value on the wire for searchTier to set.
       * @return This builder for chaining.
       */
      public Builder setSearchTierValue(int value) {
        searchTier_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
       *
       * @return The searchTier.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.SearchTier getSearchTier() {
        com.google.cloud.discoveryengine.v1.SearchTier result =
            com.google.cloud.discoveryengine.v1.SearchTier.forNumber(searchTier_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.SearchTier.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
       *
       * @param value The searchTier to set.
       * @return This builder for chaining.
       */
      public Builder setSearchTier(com.google.cloud.discoveryengine.v1.SearchTier value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        searchTier_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The search feature tier of this engine.
       *
       * Different tiers might have different
       * pricing. To learn more, check the pricing documentation.
       *
       * Defaults to
       * [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1.SearchTier.SEARCH_TIER_STANDARD]
       * if not specified.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.SearchTier search_tier = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSearchTier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        searchTier_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> searchAddOns_ = java.util.Collections.emptyList();

      private void ensureSearchAddOnsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          searchAddOns_ = new java.util.ArrayList<java.lang.Integer>(searchAddOns_);
          bitField0_ |= 0x00000002;
        }
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @return A list containing the searchAddOns.
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.SearchAddOn> getSearchAddOnsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.cloud.discoveryengine.v1.SearchAddOn>(
            searchAddOns_, searchAddOns_converter_);
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @return The count of searchAddOns.
       */
      public int getSearchAddOnsCount() {
        return searchAddOns_.size();
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The searchAddOns at the given index.
       */
      public com.google.cloud.discoveryengine.v1.SearchAddOn getSearchAddOns(int index) {
        return searchAddOns_converter_.convert(searchAddOns_.get(index));
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The searchAddOns to set.
       * @return This builder for chaining.
       */
      public Builder setSearchAddOns(
          int index, com.google.cloud.discoveryengine.v1.SearchAddOn value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSearchAddOnsIsMutable();
        searchAddOns_.set(index, value.getNumber());
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param value The searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addSearchAddOns(com.google.cloud.discoveryengine.v1.SearchAddOn value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSearchAddOnsIsMutable();
        searchAddOns_.add(value.getNumber());
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param values The searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addAllSearchAddOns(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.SearchAddOn> values) {
        ensureSearchAddOnsIsMutable();
        for (com.google.cloud.discoveryengine.v1.SearchAddOn value : values) {
          searchAddOns_.add(value.getNumber());
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSearchAddOns() {
        searchAddOns_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @return A list containing the enum numeric values on the wire for searchAddOns.
       */
      public java.util.List<java.lang.Integer> getSearchAddOnsValueList() {
        return java.util.Collections.unmodifiableList(searchAddOns_);
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of searchAddOns at the given index.
       */
      public int getSearchAddOnsValue(int index) {
        return searchAddOns_.get(index);
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for searchAddOns to set.
       * @return This builder for chaining.
       */
      public Builder setSearchAddOnsValue(int index, int value) {
        ensureSearchAddOnsIsMutable();
        searchAddOns_.set(index, value);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param value The enum numeric value on the wire for searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addSearchAddOnsValue(int value) {
        ensureSearchAddOnsIsMutable();
        searchAddOns_.add(value);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The add-on that this search engine enables.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1.SearchAddOn search_add_ons = 2;</code>
       *
       * @param values The enum numeric values on the wire for searchAddOns to add.
       * @return This builder for chaining.
       */
      public Builder addAllSearchAddOnsValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureSearchAddOnsIsMutable();
        for (int value : values) {
          searchAddOns_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.SearchEngineConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.SearchEngineConfig)
    private static final com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig();
    }

    public static com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SearchEngineConfig> PARSER =
        new com.google.protobuf.AbstractParser<SearchEngineConfig>() {
          @java.lang.Override
          public SearchEngineConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SearchEngineConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SearchEngineConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MediaRecommendationEngineConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The type of engine. e.g., `recommended-for-you`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `more-like-this`, `most-popular-items`.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    java.lang.String getType();

    /**
     *
     *
     * <pre>
     * Required. The type of engine. e.g., `recommended-for-you`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `more-like-this`, `most-popular-items`.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * The optimization objective. e.g., `cvr`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported
     * values: `ctr`, `cvr`.
     *
     *  If not specified, we choose default based on engine type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     * </pre>
     *
     * <code>string optimization_objective = 2;</code>
     *
     * @return The optimizationObjective.
     */
    java.lang.String getOptimizationObjective();

    /**
     *
     *
     * <pre>
     * The optimization objective. e.g., `cvr`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported
     * values: `ctr`, `cvr`.
     *
     *  If not specified, we choose default based on engine type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     * </pre>
     *
     * <code>string optimization_objective = 2;</code>
     *
     * @return The bytes for optimizationObjective.
     */
    com.google.protobuf.ByteString getOptimizationObjectiveBytes();

    /**
     *
     *
     * <pre>
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
     * </code>
     *
     * @return Whether the optimizationObjectiveConfig field is set.
     */
    boolean hasOptimizationObjectiveConfig();

    /**
     *
     *
     * <pre>
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
     * </code>
     *
     * @return The optimizationObjectiveConfig.
     */
    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .OptimizationObjectiveConfig
        getOptimizationObjectiveConfig();

    /**
     *
     *
     * <pre>
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .OptimizationObjectiveConfigOrBuilder
        getOptimizationObjectiveConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * The training state that the engine is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * engine in order to control cost. If not specified: the default value for
     * `CreateEngine` method is `TRAINING`. The default value for
     * `UpdateEngine` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for trainingState.
     */
    int getTrainingStateValue();

    /**
     *
     *
     * <pre>
     * The training state that the engine is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * engine in order to control cost. If not specified: the default value for
     * `CreateEngine` method is `TRAINING`. The default value for
     * `UpdateEngine` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
     * </code>
     *
     * @return The trainingState.
     */
    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState
        getTrainingState();

    /**
     *
     *
     * <pre>
     * Optional. Additional engine features config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the engineFeaturesConfig field is set.
     */
    boolean hasEngineFeaturesConfig();

    /**
     *
     *
     * <pre>
     * Optional. Additional engine features config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The engineFeaturesConfig.
     */
    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig
        getEngineFeaturesConfig();

    /**
     *
     *
     * <pre>
     * Optional. Additional engine features config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .EngineFeaturesConfigOrBuilder
        getEngineFeaturesConfigOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Additional config specs for a Media Recommendation engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig}
   */
  public static final class MediaRecommendationEngineConfig
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
      MediaRecommendationEngineConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MediaRecommendationEngineConfig.newBuilder() to construct.
    private MediaRecommendationEngineConfig(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MediaRecommendationEngineConfig() {
      type_ = "";
      optimizationObjective_ = "";
      trainingState_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MediaRecommendationEngineConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.class,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * The training state of the engine.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState}
     */
    public enum TrainingState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified training state.
       * </pre>
       *
       * <code>TRAINING_STATE_UNSPECIFIED = 0;</code>
       */
      TRAINING_STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The engine training is paused.
       * </pre>
       *
       * <code>PAUSED = 1;</code>
       */
      PAUSED(1),
      /**
       *
       *
       * <pre>
       * The engine is training.
       * </pre>
       *
       * <code>TRAINING = 2;</code>
       */
      TRAINING(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified training state.
       * </pre>
       *
       * <code>TRAINING_STATE_UNSPECIFIED = 0;</code>
       */
      public static final int TRAINING_STATE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The engine training is paused.
       * </pre>
       *
       * <code>PAUSED = 1;</code>
       */
      public static final int PAUSED_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The engine is training.
       * </pre>
       *
       * <code>TRAINING = 2;</code>
       */
      public static final int TRAINING_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TrainingState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TrainingState forNumber(int value) {
        switch (value) {
          case 0:
            return TRAINING_STATE_UNSPECIFIED;
          case 1:
            return PAUSED;
          case 2:
            return TRAINING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TrainingState> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<TrainingState>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<TrainingState>() {
                public TrainingState findValueByNumber(int number) {
                  return TrainingState.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final TrainingState[] VALUES = values();

      public static TrainingState valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TrainingState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState)
    }

    public interface OptimizationObjectiveConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The name of the field to target. Currently supported
       * values: `watch-percentage`, `watch-time`.
       * </pre>
       *
       * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The targetField.
       */
      java.lang.String getTargetField();

      /**
       *
       *
       * <pre>
       * Required. The name of the field to target. Currently supported
       * values: `watch-percentage`, `watch-time`.
       * </pre>
       *
       * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for targetField.
       */
      com.google.protobuf.ByteString getTargetFieldBytes();

      /**
       *
       *
       * <pre>
       * Required. The threshold to be applied to the target (e.g., 0.5).
       * </pre>
       *
       * <code>float target_field_value_float = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The targetFieldValueFloat.
       */
      float getTargetFieldValueFloat();
    }

    /**
     *
     *
     * <pre>
     * Custom threshold for `cvr` optimization_objective.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig}
     */
    public static final class OptimizationObjectiveConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig)
        OptimizationObjectiveConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use OptimizationObjectiveConfig.newBuilder() to construct.
      private OptimizationObjectiveConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private OptimizationObjectiveConfig() {
        targetField_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new OptimizationObjectiveConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .OptimizationObjectiveConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .OptimizationObjectiveConfig.Builder.class);
      }

      public static final int TARGET_FIELD_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object targetField_ = "";

      /**
       *
       *
       * <pre>
       * Required. The name of the field to target. Currently supported
       * values: `watch-percentage`, `watch-time`.
       * </pre>
       *
       * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The targetField.
       */
      @java.lang.Override
      public java.lang.String getTargetField() {
        java.lang.Object ref = targetField_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          targetField_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The name of the field to target. Currently supported
       * values: `watch-percentage`, `watch-time`.
       * </pre>
       *
       * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for targetField.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTargetFieldBytes() {
        java.lang.Object ref = targetField_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetField_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TARGET_FIELD_VALUE_FLOAT_FIELD_NUMBER = 2;
      private float targetFieldValueFloat_ = 0F;

      /**
       *
       *
       * <pre>
       * Required. The threshold to be applied to the target (e.g., 0.5).
       * </pre>
       *
       * <code>float target_field_value_float = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The targetFieldValueFloat.
       */
      @java.lang.Override
      public float getTargetFieldValueFloat() {
        return targetFieldValueFloat_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetField_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, targetField_);
        }
        if (java.lang.Float.floatToRawIntBits(targetFieldValueFloat_) != 0) {
          output.writeFloat(2, targetFieldValueFloat_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetField_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, targetField_);
        }
        if (java.lang.Float.floatToRawIntBits(targetFieldValueFloat_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, targetFieldValueFloat_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .OptimizationObjectiveConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .OptimizationObjectiveConfig
            other =
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .OptimizationObjectiveConfig)
                    obj;

        if (!getTargetField().equals(other.getTargetField())) return false;
        if (java.lang.Float.floatToIntBits(getTargetFieldValueFloat())
            != java.lang.Float.floatToIntBits(other.getTargetFieldValueFloat())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TARGET_FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getTargetField().hashCode();
        hash = (37 * hash) + TARGET_FIELD_VALUE_FLOAT_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getTargetFieldValueFloat());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Custom threshold for `cvr` optimization_objective.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig)
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .OptimizationObjectiveConfig.class,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .OptimizationObjectiveConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          targetField_ = "";
          targetFieldValueFloat_ = 0F;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .OptimizationObjectiveConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .OptimizationObjectiveConfig
            build() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .OptimizationObjectiveConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig
              result =
                  new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .OptimizationObjectiveConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .OptimizationObjectiveConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.targetField_ = targetField_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.targetFieldValueFloat_ = targetFieldValueFloat_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .OptimizationObjectiveConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .OptimizationObjectiveConfig
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig.getDefaultInstance()) return this;
          if (!other.getTargetField().isEmpty()) {
            targetField_ = other.targetField_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.getTargetFieldValueFloat() != 0F) {
            setTargetFieldValueFloat(other.getTargetFieldValueFloat());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    targetField_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    targetFieldValueFloat_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object targetField_ = "";

        /**
         *
         *
         * <pre>
         * Required. The name of the field to target. Currently supported
         * values: `watch-percentage`, `watch-time`.
         * </pre>
         *
         * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The targetField.
         */
        public java.lang.String getTargetField() {
          java.lang.Object ref = targetField_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            targetField_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the field to target. Currently supported
         * values: `watch-percentage`, `watch-time`.
         * </pre>
         *
         * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for targetField.
         */
        public com.google.protobuf.ByteString getTargetFieldBytes() {
          java.lang.Object ref = targetField_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            targetField_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the field to target. Currently supported
         * values: `watch-percentage`, `watch-time`.
         * </pre>
         *
         * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The targetField to set.
         * @return This builder for chaining.
         */
        public Builder setTargetField(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          targetField_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the field to target. Currently supported
         * values: `watch-percentage`, `watch-time`.
         * </pre>
         *
         * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTargetField() {
          targetField_ = getDefaultInstance().getTargetField();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The name of the field to target. Currently supported
         * values: `watch-percentage`, `watch-time`.
         * </pre>
         *
         * <code>string target_field = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for targetField to set.
         * @return This builder for chaining.
         */
        public Builder setTargetFieldBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          targetField_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private float targetFieldValueFloat_;

        /**
         *
         *
         * <pre>
         * Required. The threshold to be applied to the target (e.g., 0.5).
         * </pre>
         *
         * <code>float target_field_value_float = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The targetFieldValueFloat.
         */
        @java.lang.Override
        public float getTargetFieldValueFloat() {
          return targetFieldValueFloat_;
        }

        /**
         *
         *
         * <pre>
         * Required. The threshold to be applied to the target (e.g., 0.5).
         * </pre>
         *
         * <code>float target_field_value_float = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @param value The targetFieldValueFloat to set.
         * @return This builder for chaining.
         */
        public Builder setTargetFieldValueFloat(float value) {

          targetFieldValueFloat_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The threshold to be applied to the target (e.g., 0.5).
         * </pre>
         *
         * <code>float target_field_value_float = 2 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTargetFieldValueFloat() {
          bitField0_ = (bitField0_ & ~0x00000002);
          targetFieldValueFloat_ = 0F;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig)
      private static final com.google.cloud.discoveryengine.v1.Engine
              .MediaRecommendationEngineConfig.OptimizationObjectiveConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .OptimizationObjectiveConfig();
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OptimizationObjectiveConfig> PARSER =
          new com.google.protobuf.AbstractParser<OptimizationObjectiveConfig>() {
            @java.lang.Override
            public OptimizationObjectiveConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<OptimizationObjectiveConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OptimizationObjectiveConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface EngineFeaturesConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Recommended for you engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
       * </code>
       *
       * @return Whether the recommendedForYouConfig field is set.
       */
      boolean hasRecommendedForYouConfig();

      /**
       *
       *
       * <pre>
       * Recommended for you engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
       * </code>
       *
       * @return The recommendedForYouConfig.
       */
      com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          getRecommendedForYouConfig();

      /**
       *
       *
       * <pre>
       * Recommended for you engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfigOrBuilder
          getRecommendedForYouConfigOrBuilder();

      /**
       *
       *
       * <pre>
       * Most popular engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
       * </code>
       *
       * @return Whether the mostPopularConfig field is set.
       */
      boolean hasMostPopularConfig();

      /**
       *
       *
       * <pre>
       * Most popular engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
       * </code>
       *
       * @return The mostPopularConfig.
       */
      com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          getMostPopularConfig();

      /**
       *
       *
       * <pre>
       * Most popular engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
       * </code>
       */
      com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfigOrBuilder
          getMostPopularConfigOrBuilder();

      com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig.TypeDedicatedConfigCase
          getTypeDedicatedConfigCase();
    }

    /**
     *
     *
     * <pre>
     * More feature configs of the selected engine type.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig}
     */
    public static final class EngineFeaturesConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig)
        EngineFeaturesConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use EngineFeaturesConfig.newBuilder() to construct.
      private EngineFeaturesConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private EngineFeaturesConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new EngineFeaturesConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_EngineFeaturesConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_EngineFeaturesConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .EngineFeaturesConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .EngineFeaturesConfig.Builder.class);
      }

      private int typeDedicatedConfigCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object typeDedicatedConfig_;

      public enum TypeDedicatedConfigCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        RECOMMENDED_FOR_YOU_CONFIG(1),
        MOST_POPULAR_CONFIG(2),
        TYPEDEDICATEDCONFIG_NOT_SET(0);
        private final int value;

        private TypeDedicatedConfigCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static TypeDedicatedConfigCase valueOf(int value) {
          return forNumber(value);
        }

        public static TypeDedicatedConfigCase forNumber(int value) {
          switch (value) {
            case 1:
              return RECOMMENDED_FOR_YOU_CONFIG;
            case 2:
              return MOST_POPULAR_CONFIG;
            case 0:
              return TYPEDEDICATEDCONFIG_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public TypeDedicatedConfigCase getTypeDedicatedConfigCase() {
        return TypeDedicatedConfigCase.forNumber(typeDedicatedConfigCase_);
      }

      public static final int RECOMMENDED_FOR_YOU_CONFIG_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * Recommended for you engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
       * </code>
       *
       * @return Whether the recommendedForYouConfig field is set.
       */
      @java.lang.Override
      public boolean hasRecommendedForYouConfig() {
        return typeDedicatedConfigCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Recommended for you engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
       * </code>
       *
       * @return The recommendedForYouConfig.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          getRecommendedForYouConfig() {
        if (typeDedicatedConfigCase_ == 1) {
          return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .RecommendedForYouFeatureConfig)
              typeDedicatedConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .RecommendedForYouFeatureConfig.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Recommended for you engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfigOrBuilder
          getRecommendedForYouConfigOrBuilder() {
        if (typeDedicatedConfigCase_ == 1) {
          return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .RecommendedForYouFeatureConfig)
              typeDedicatedConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .RecommendedForYouFeatureConfig.getDefaultInstance();
      }

      public static final int MOST_POPULAR_CONFIG_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * Most popular engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
       * </code>
       *
       * @return Whether the mostPopularConfig field is set.
       */
      @java.lang.Override
      public boolean hasMostPopularConfig() {
        return typeDedicatedConfigCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Most popular engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
       * </code>
       *
       * @return The mostPopularConfig.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          getMostPopularConfig() {
        if (typeDedicatedConfigCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .MostPopularFeatureConfig)
              typeDedicatedConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .MostPopularFeatureConfig.getDefaultInstance();
      }

      /**
       *
       *
       * <pre>
       * Most popular engine feature config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfigOrBuilder
          getMostPopularConfigOrBuilder() {
        if (typeDedicatedConfigCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .MostPopularFeatureConfig)
              typeDedicatedConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .MostPopularFeatureConfig.getDefaultInstance();
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (typeDedicatedConfigCase_ == 1) {
          output.writeMessage(
              1,
              (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig)
                  typeDedicatedConfig_);
        }
        if (typeDedicatedConfigCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig)
                  typeDedicatedConfig_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (typeDedicatedConfigCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  1,
                  (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                          .RecommendedForYouFeatureConfig)
                      typeDedicatedConfig_);
        }
        if (typeDedicatedConfigCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                          .MostPopularFeatureConfig)
                      typeDedicatedConfig_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .EngineFeaturesConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .EngineFeaturesConfig
            other =
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .EngineFeaturesConfig)
                    obj;

        if (!getTypeDedicatedConfigCase().equals(other.getTypeDedicatedConfigCase())) return false;
        switch (typeDedicatedConfigCase_) {
          case 1:
            if (!getRecommendedForYouConfig().equals(other.getRecommendedForYouConfig()))
              return false;
            break;
          case 2:
            if (!getMostPopularConfig().equals(other.getMostPopularConfig())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (typeDedicatedConfigCase_) {
          case 1:
            hash = (37 * hash) + RECOMMENDED_FOR_YOU_CONFIG_FIELD_NUMBER;
            hash = (53 * hash) + getRecommendedForYouConfig().hashCode();
            break;
          case 2:
            hash = (37 * hash) + MOST_POPULAR_CONFIG_FIELD_NUMBER;
            hash = (53 * hash) + getMostPopularConfig().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * More feature configs of the selected engine type.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig)
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_EngineFeaturesConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_EngineFeaturesConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .EngineFeaturesConfig.class,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .EngineFeaturesConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (recommendedForYouConfigBuilder_ != null) {
            recommendedForYouConfigBuilder_.clear();
          }
          if (mostPopularConfigBuilder_ != null) {
            mostPopularConfigBuilder_.clear();
          }
          typeDedicatedConfigCase_ = 0;
          typeDedicatedConfig_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_EngineFeaturesConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .EngineFeaturesConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .EngineFeaturesConfig
            build() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .EngineFeaturesConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig
              result =
                  new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .EngineFeaturesConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .EngineFeaturesConfig
                result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .EngineFeaturesConfig
                result) {
          result.typeDedicatedConfigCase_ = typeDedicatedConfigCase_;
          result.typeDedicatedConfig_ = this.typeDedicatedConfig_;
          if (typeDedicatedConfigCase_ == 1 && recommendedForYouConfigBuilder_ != null) {
            result.typeDedicatedConfig_ = recommendedForYouConfigBuilder_.build();
          }
          if (typeDedicatedConfigCase_ == 2 && mostPopularConfigBuilder_ != null) {
            result.typeDedicatedConfig_ = mostPopularConfigBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .EngineFeaturesConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .EngineFeaturesConfig
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig.getDefaultInstance()) return this;
          switch (other.getTypeDedicatedConfigCase()) {
            case RECOMMENDED_FOR_YOU_CONFIG:
              {
                mergeRecommendedForYouConfig(other.getRecommendedForYouConfig());
                break;
              }
            case MOST_POPULAR_CONFIG:
              {
                mergeMostPopularConfig(other.getMostPopularConfig());
                break;
              }
            case TYPEDEDICATEDCONFIG_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getRecommendedForYouConfigFieldBuilder().getBuilder(), extensionRegistry);
                    typeDedicatedConfigCase_ = 1;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getMostPopularConfigFieldBuilder().getBuilder(), extensionRegistry);
                    typeDedicatedConfigCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int typeDedicatedConfigCase_ = 0;
        private java.lang.Object typeDedicatedConfig_;

        public TypeDedicatedConfigCase getTypeDedicatedConfigCase() {
          return TypeDedicatedConfigCase.forNumber(typeDedicatedConfigCase_);
        }

        public Builder clearTypeDedicatedConfig() {
          typeDedicatedConfigCase_ = 0;
          typeDedicatedConfig_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfigOrBuilder>
            recommendedForYouConfigBuilder_;

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         *
         * @return Whether the recommendedForYouConfig field is set.
         */
        @java.lang.Override
        public boolean hasRecommendedForYouConfig() {
          return typeDedicatedConfigCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         *
         * @return The recommendedForYouConfig.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig
            getRecommendedForYouConfig() {
          if (recommendedForYouConfigBuilder_ == null) {
            if (typeDedicatedConfigCase_ == 1) {
              return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig)
                  typeDedicatedConfig_;
            }
            return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig.getDefaultInstance();
          } else {
            if (typeDedicatedConfigCase_ == 1) {
              return recommendedForYouConfigBuilder_.getMessage();
            }
            return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         */
        public Builder setRecommendedForYouConfig(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig
                value) {
          if (recommendedForYouConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            typeDedicatedConfig_ = value;
            onChanged();
          } else {
            recommendedForYouConfigBuilder_.setMessage(value);
          }
          typeDedicatedConfigCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         */
        public Builder setRecommendedForYouConfig(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig.Builder
                builderForValue) {
          if (recommendedForYouConfigBuilder_ == null) {
            typeDedicatedConfig_ = builderForValue.build();
            onChanged();
          } else {
            recommendedForYouConfigBuilder_.setMessage(builderForValue.build());
          }
          typeDedicatedConfigCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         */
        public Builder mergeRecommendedForYouConfig(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig
                value) {
          if (recommendedForYouConfigBuilder_ == null) {
            if (typeDedicatedConfigCase_ == 1
                && typeDedicatedConfig_
                    != com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .RecommendedForYouFeatureConfig.getDefaultInstance()) {
              typeDedicatedConfig_ =
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig.newBuilder(
                          (com.google.cloud.discoveryengine.v1.Engine
                                  .MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig)
                              typeDedicatedConfig_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              typeDedicatedConfig_ = value;
            }
            onChanged();
          } else {
            if (typeDedicatedConfigCase_ == 1) {
              recommendedForYouConfigBuilder_.mergeFrom(value);
            } else {
              recommendedForYouConfigBuilder_.setMessage(value);
            }
          }
          typeDedicatedConfigCase_ = 1;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         */
        public Builder clearRecommendedForYouConfig() {
          if (recommendedForYouConfigBuilder_ == null) {
            if (typeDedicatedConfigCase_ == 1) {
              typeDedicatedConfigCase_ = 0;
              typeDedicatedConfig_ = null;
              onChanged();
            }
          } else {
            if (typeDedicatedConfigCase_ == 1) {
              typeDedicatedConfigCase_ = 0;
              typeDedicatedConfig_ = null;
            }
            recommendedForYouConfigBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig.Builder
            getRecommendedForYouConfigBuilder() {
          return getRecommendedForYouConfigFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfigOrBuilder
            getRecommendedForYouConfigOrBuilder() {
          if ((typeDedicatedConfigCase_ == 1) && (recommendedForYouConfigBuilder_ != null)) {
            return recommendedForYouConfigBuilder_.getMessageOrBuilder();
          } else {
            if (typeDedicatedConfigCase_ == 1) {
              return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig)
                  typeDedicatedConfig_;
            }
            return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Recommended for you engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig recommended_for_you_config = 1;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfigOrBuilder>
            getRecommendedForYouConfigFieldBuilder() {
          if (recommendedForYouConfigBuilder_ == null) {
            if (!(typeDedicatedConfigCase_ == 1)) {
              typeDedicatedConfig_ =
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig.getDefaultInstance();
            }
            recommendedForYouConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .RecommendedForYouFeatureConfig,
                    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .RecommendedForYouFeatureConfig.Builder,
                    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .RecommendedForYouFeatureConfigOrBuilder>(
                    (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                            .RecommendedForYouFeatureConfig)
                        typeDedicatedConfig_,
                    getParentForChildren(),
                    isClean());
            typeDedicatedConfig_ = null;
          }
          typeDedicatedConfigCase_ = 1;
          onChanged();
          return recommendedForYouConfigBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfigOrBuilder>
            mostPopularConfigBuilder_;

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         *
         * @return Whether the mostPopularConfig field is set.
         */
        @java.lang.Override
        public boolean hasMostPopularConfig() {
          return typeDedicatedConfigCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         *
         * @return The mostPopularConfig.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig
            getMostPopularConfig() {
          if (mostPopularConfigBuilder_ == null) {
            if (typeDedicatedConfigCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig)
                  typeDedicatedConfig_;
            }
            return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig.getDefaultInstance();
          } else {
            if (typeDedicatedConfigCase_ == 2) {
              return mostPopularConfigBuilder_.getMessage();
            }
            return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         */
        public Builder setMostPopularConfig(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig
                value) {
          if (mostPopularConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            typeDedicatedConfig_ = value;
            onChanged();
          } else {
            mostPopularConfigBuilder_.setMessage(value);
          }
          typeDedicatedConfigCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         */
        public Builder setMostPopularConfig(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig.Builder
                builderForValue) {
          if (mostPopularConfigBuilder_ == null) {
            typeDedicatedConfig_ = builderForValue.build();
            onChanged();
          } else {
            mostPopularConfigBuilder_.setMessage(builderForValue.build());
          }
          typeDedicatedConfigCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         */
        public Builder mergeMostPopularConfig(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig
                value) {
          if (mostPopularConfigBuilder_ == null) {
            if (typeDedicatedConfigCase_ == 2
                && typeDedicatedConfig_
                    != com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .MostPopularFeatureConfig.getDefaultInstance()) {
              typeDedicatedConfig_ =
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig.newBuilder(
                          (com.google.cloud.discoveryengine.v1.Engine
                                  .MediaRecommendationEngineConfig.MostPopularFeatureConfig)
                              typeDedicatedConfig_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              typeDedicatedConfig_ = value;
            }
            onChanged();
          } else {
            if (typeDedicatedConfigCase_ == 2) {
              mostPopularConfigBuilder_.mergeFrom(value);
            } else {
              mostPopularConfigBuilder_.setMessage(value);
            }
          }
          typeDedicatedConfigCase_ = 2;
          return this;
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         */
        public Builder clearMostPopularConfig() {
          if (mostPopularConfigBuilder_ == null) {
            if (typeDedicatedConfigCase_ == 2) {
              typeDedicatedConfigCase_ = 0;
              typeDedicatedConfig_ = null;
              onChanged();
            }
          } else {
            if (typeDedicatedConfigCase_ == 2) {
              typeDedicatedConfigCase_ = 0;
              typeDedicatedConfig_ = null;
            }
            mostPopularConfigBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig.Builder
            getMostPopularConfigBuilder() {
          return getMostPopularConfigFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfigOrBuilder
            getMostPopularConfigOrBuilder() {
          if ((typeDedicatedConfigCase_ == 2) && (mostPopularConfigBuilder_ != null)) {
            return mostPopularConfigBuilder_.getMessageOrBuilder();
          } else {
            if (typeDedicatedConfigCase_ == 2) {
              return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig)
                  typeDedicatedConfig_;
            }
            return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig.getDefaultInstance();
          }
        }

        /**
         *
         *
         * <pre>
         * Most popular engine feature config.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig most_popular_config = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfigOrBuilder>
            getMostPopularConfigFieldBuilder() {
          if (mostPopularConfigBuilder_ == null) {
            if (!(typeDedicatedConfigCase_ == 2)) {
              typeDedicatedConfig_ =
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig.getDefaultInstance();
            }
            mostPopularConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .MostPopularFeatureConfig,
                    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .MostPopularFeatureConfig.Builder,
                    com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .MostPopularFeatureConfigOrBuilder>(
                    (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                            .MostPopularFeatureConfig)
                        typeDedicatedConfig_,
                    getParentForChildren(),
                    isClean());
            typeDedicatedConfig_ = null;
          }
          typeDedicatedConfigCase_ = 2;
          onChanged();
          return mostPopularConfigBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig)
      private static final com.google.cloud.discoveryengine.v1.Engine
              .MediaRecommendationEngineConfig.EngineFeaturesConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .EngineFeaturesConfig();
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<EngineFeaturesConfig> PARSER =
          new com.google.protobuf.AbstractParser<EngineFeaturesConfig>() {
            @java.lang.Override
            public EngineFeaturesConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<EngineFeaturesConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<EngineFeaturesConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface RecommendedForYouFeatureConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The type of event with which the engine is queried at prediction time.
       * If set to `generic`, only `view-item`, `media-play`,and
       * `media-complete` will be used as `context-event` in engine training. If
       * set to `view-home-page`, `view-home-page` will also be used as
       * `context-events` in addition to `view-item`, `media-play`, and
       * `media-complete`. Currently supported for the `recommended-for-you`
       * engine. Currently supported values: `view-home-page`, `generic`.
       * </pre>
       *
       * <code>string context_event_type = 1;</code>
       *
       * @return The contextEventType.
       */
      java.lang.String getContextEventType();

      /**
       *
       *
       * <pre>
       * The type of event with which the engine is queried at prediction time.
       * If set to `generic`, only `view-item`, `media-play`,and
       * `media-complete` will be used as `context-event` in engine training. If
       * set to `view-home-page`, `view-home-page` will also be used as
       * `context-events` in addition to `view-item`, `media-play`, and
       * `media-complete`. Currently supported for the `recommended-for-you`
       * engine. Currently supported values: `view-home-page`, `generic`.
       * </pre>
       *
       * <code>string context_event_type = 1;</code>
       *
       * @return The bytes for contextEventType.
       */
      com.google.protobuf.ByteString getContextEventTypeBytes();
    }

    /**
     *
     *
     * <pre>
     * Additional feature configurations for creating a `recommended-for-you`
     * engine.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig}
     */
    public static final class RecommendedForYouFeatureConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig)
        RecommendedForYouFeatureConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use RecommendedForYouFeatureConfig.newBuilder() to construct.
      private RecommendedForYouFeatureConfig(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private RecommendedForYouFeatureConfig() {
        contextEventType_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new RecommendedForYouFeatureConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_RecommendedForYouFeatureConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_RecommendedForYouFeatureConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig.Builder.class);
      }

      public static final int CONTEXT_EVENT_TYPE_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object contextEventType_ = "";

      /**
       *
       *
       * <pre>
       * The type of event with which the engine is queried at prediction time.
       * If set to `generic`, only `view-item`, `media-play`,and
       * `media-complete` will be used as `context-event` in engine training. If
       * set to `view-home-page`, `view-home-page` will also be used as
       * `context-events` in addition to `view-item`, `media-play`, and
       * `media-complete`. Currently supported for the `recommended-for-you`
       * engine. Currently supported values: `view-home-page`, `generic`.
       * </pre>
       *
       * <code>string context_event_type = 1;</code>
       *
       * @return The contextEventType.
       */
      @java.lang.Override
      public java.lang.String getContextEventType() {
        java.lang.Object ref = contextEventType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          contextEventType_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The type of event with which the engine is queried at prediction time.
       * If set to `generic`, only `view-item`, `media-play`,and
       * `media-complete` will be used as `context-event` in engine training. If
       * set to `view-home-page`, `view-home-page` will also be used as
       * `context-events` in addition to `view-item`, `media-play`, and
       * `media-complete`. Currently supported for the `recommended-for-you`
       * engine. Currently supported values: `view-home-page`, `generic`.
       * </pre>
       *
       * <code>string context_event_type = 1;</code>
       *
       * @return The bytes for contextEventType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContextEventTypeBytes() {
        java.lang.Object ref = contextEventType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          contextEventType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contextEventType_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, contextEventType_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contextEventType_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, contextEventType_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig
            other =
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .RecommendedForYouFeatureConfig)
                    obj;

        if (!getContextEventType().equals(other.getContextEventType())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONTEXT_EVENT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getContextEventType().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .RecommendedForYouFeatureConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Additional feature configurations for creating a `recommended-for-you`
       * engine.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig)
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_RecommendedForYouFeatureConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_RecommendedForYouFeatureConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig.class,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          contextEventType_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_RecommendedForYouFeatureConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig
            build() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .RecommendedForYouFeatureConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .RecommendedForYouFeatureConfig
              result =
                  new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .RecommendedForYouFeatureConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.contextEventType_ = contextEventType_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .RecommendedForYouFeatureConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .RecommendedForYouFeatureConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .RecommendedForYouFeatureConfig
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .RecommendedForYouFeatureConfig.getDefaultInstance()) return this;
          if (!other.getContextEventType().isEmpty()) {
            contextEventType_ = other.contextEventType_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    contextEventType_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object contextEventType_ = "";

        /**
         *
         *
         * <pre>
         * The type of event with which the engine is queried at prediction time.
         * If set to `generic`, only `view-item`, `media-play`,and
         * `media-complete` will be used as `context-event` in engine training. If
         * set to `view-home-page`, `view-home-page` will also be used as
         * `context-events` in addition to `view-item`, `media-play`, and
         * `media-complete`. Currently supported for the `recommended-for-you`
         * engine. Currently supported values: `view-home-page`, `generic`.
         * </pre>
         *
         * <code>string context_event_type = 1;</code>
         *
         * @return The contextEventType.
         */
        public java.lang.String getContextEventType() {
          java.lang.Object ref = contextEventType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            contextEventType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The type of event with which the engine is queried at prediction time.
         * If set to `generic`, only `view-item`, `media-play`,and
         * `media-complete` will be used as `context-event` in engine training. If
         * set to `view-home-page`, `view-home-page` will also be used as
         * `context-events` in addition to `view-item`, `media-play`, and
         * `media-complete`. Currently supported for the `recommended-for-you`
         * engine. Currently supported values: `view-home-page`, `generic`.
         * </pre>
         *
         * <code>string context_event_type = 1;</code>
         *
         * @return The bytes for contextEventType.
         */
        public com.google.protobuf.ByteString getContextEventTypeBytes() {
          java.lang.Object ref = contextEventType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            contextEventType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The type of event with which the engine is queried at prediction time.
         * If set to `generic`, only `view-item`, `media-play`,and
         * `media-complete` will be used as `context-event` in engine training. If
         * set to `view-home-page`, `view-home-page` will also be used as
         * `context-events` in addition to `view-item`, `media-play`, and
         * `media-complete`. Currently supported for the `recommended-for-you`
         * engine. Currently supported values: `view-home-page`, `generic`.
         * </pre>
         *
         * <code>string context_event_type = 1;</code>
         *
         * @param value The contextEventType to set.
         * @return This builder for chaining.
         */
        public Builder setContextEventType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          contextEventType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of event with which the engine is queried at prediction time.
         * If set to `generic`, only `view-item`, `media-play`,and
         * `media-complete` will be used as `context-event` in engine training. If
         * set to `view-home-page`, `view-home-page` will also be used as
         * `context-events` in addition to `view-item`, `media-play`, and
         * `media-complete`. Currently supported for the `recommended-for-you`
         * engine. Currently supported values: `view-home-page`, `generic`.
         * </pre>
         *
         * <code>string context_event_type = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContextEventType() {
          contextEventType_ = getDefaultInstance().getContextEventType();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of event with which the engine is queried at prediction time.
         * If set to `generic`, only `view-item`, `media-play`,and
         * `media-complete` will be used as `context-event` in engine training. If
         * set to `view-home-page`, `view-home-page` will also be used as
         * `context-events` in addition to `view-item`, `media-play`, and
         * `media-complete`. Currently supported for the `recommended-for-you`
         * engine. Currently supported values: `view-home-page`, `generic`.
         * </pre>
         *
         * <code>string context_event_type = 1;</code>
         *
         * @param value The bytes for contextEventType to set.
         * @return This builder for chaining.
         */
        public Builder setContextEventTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          contextEventType_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig)
      private static final com.google.cloud.discoveryengine.v1.Engine
              .MediaRecommendationEngineConfig.RecommendedForYouFeatureConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .RecommendedForYouFeatureConfig();
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RecommendedForYouFeatureConfig> PARSER =
          new com.google.protobuf.AbstractParser<RecommendedForYouFeatureConfig>() {
            @java.lang.Override
            public RecommendedForYouFeatureConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<RecommendedForYouFeatureConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RecommendedForYouFeatureConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .RecommendedForYouFeatureConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MostPopularFeatureConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The time window of which the engine is queried at training and
       * prediction time. Positive integers only. The value translates to the
       * last X days of events. Currently required for the `most-popular-items`
       * engine.
       * </pre>
       *
       * <code>int64 time_window_days = 1;</code>
       *
       * @return The timeWindowDays.
       */
      long getTimeWindowDays();
    }

    /**
     *
     *
     * <pre>
     * Feature configurations that are required for creating a Most Popular
     * engine.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig}
     */
    public static final class MostPopularFeatureConfig
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig)
        MostPopularFeatureConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use MostPopularFeatureConfig.newBuilder() to construct.
      private MostPopularFeatureConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MostPopularFeatureConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MostPopularFeatureConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_MostPopularFeatureConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_MostPopularFeatureConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig.Builder.class);
      }

      public static final int TIME_WINDOW_DAYS_FIELD_NUMBER = 1;
      private long timeWindowDays_ = 0L;

      /**
       *
       *
       * <pre>
       * The time window of which the engine is queried at training and
       * prediction time. Positive integers only. The value translates to the
       * last X days of events. Currently required for the `most-popular-items`
       * engine.
       * </pre>
       *
       * <code>int64 time_window_days = 1;</code>
       *
       * @return The timeWindowDays.
       */
      @java.lang.Override
      public long getTimeWindowDays() {
        return timeWindowDays_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (timeWindowDays_ != 0L) {
          output.writeInt64(1, timeWindowDays_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (timeWindowDays_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, timeWindowDays_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig
            other =
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .MostPopularFeatureConfig)
                    obj;

        if (getTimeWindowDays() != other.getTimeWindowDays()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TIME_WINDOW_DAYS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTimeWindowDays());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .MostPopularFeatureConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Feature configurations that are required for creating a Most Popular
       * engine.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig)
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_MostPopularFeatureConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_MostPopularFeatureConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig.class,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          timeWindowDays_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_MostPopularFeatureConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig
            build() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .MostPopularFeatureConfig
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .MostPopularFeatureConfig
              result =
                  new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .MostPopularFeatureConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.timeWindowDays_ = timeWindowDays_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .MostPopularFeatureConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                        .MostPopularFeatureConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .MostPopularFeatureConfig
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .MostPopularFeatureConfig.getDefaultInstance()) return this;
          if (other.getTimeWindowDays() != 0L) {
            setTimeWindowDays(other.getTimeWindowDays());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    timeWindowDays_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long timeWindowDays_;

        /**
         *
         *
         * <pre>
         * The time window of which the engine is queried at training and
         * prediction time. Positive integers only. The value translates to the
         * last X days of events. Currently required for the `most-popular-items`
         * engine.
         * </pre>
         *
         * <code>int64 time_window_days = 1;</code>
         *
         * @return The timeWindowDays.
         */
        @java.lang.Override
        public long getTimeWindowDays() {
          return timeWindowDays_;
        }

        /**
         *
         *
         * <pre>
         * The time window of which the engine is queried at training and
         * prediction time. Positive integers only. The value translates to the
         * last X days of events. Currently required for the `most-popular-items`
         * engine.
         * </pre>
         *
         * <code>int64 time_window_days = 1;</code>
         *
         * @param value The timeWindowDays to set.
         * @return This builder for chaining.
         */
        public Builder setTimeWindowDays(long value) {

          timeWindowDays_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The time window of which the engine is queried at training and
         * prediction time. Positive integers only. The value translates to the
         * last X days of events. Currently required for the `most-popular-items`
         * engine.
         * </pre>
         *
         * <code>int64 time_window_days = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTimeWindowDays() {
          bitField0_ = (bitField0_ & ~0x00000001);
          timeWindowDays_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.MostPopularFeatureConfig)
      private static final com.google.cloud.discoveryengine.v1.Engine
              .MediaRecommendationEngineConfig.MostPopularFeatureConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .MostPopularFeatureConfig();
      }

      public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MostPopularFeatureConfig> PARSER =
          new com.google.protobuf.AbstractParser<MostPopularFeatureConfig>() {
            @java.lang.Override
            public MostPopularFeatureConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MostPopularFeatureConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MostPopularFeatureConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .MostPopularFeatureConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Required. The type of engine. e.g., `recommended-for-you`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `more-like-this`, `most-popular-items`.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The type of engine. e.g., `recommended-for-you`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported values: `recommended-for-you`, `others-you-may-like`,
     * `more-like-this`, `most-popular-items`.
     * </pre>
     *
     * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OPTIMIZATION_OBJECTIVE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object optimizationObjective_ = "";

    /**
     *
     *
     * <pre>
     * The optimization objective. e.g., `cvr`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported
     * values: `ctr`, `cvr`.
     *
     *  If not specified, we choose default based on engine type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     * </pre>
     *
     * <code>string optimization_objective = 2;</code>
     *
     * @return The optimizationObjective.
     */
    @java.lang.Override
    public java.lang.String getOptimizationObjective() {
      java.lang.Object ref = optimizationObjective_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        optimizationObjective_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The optimization objective. e.g., `cvr`.
     *
     * This field together with
     * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
     * describe engine metadata to use to control engine training and serving.
     *
     * Currently supported
     * values: `ctr`, `cvr`.
     *
     *  If not specified, we choose default based on engine type.
     * Default depends on type of recommendation:
     *
     * `recommended-for-you` =&gt; `ctr`
     *
     * `others-you-may-like` =&gt; `ctr`
     * </pre>
     *
     * <code>string optimization_objective = 2;</code>
     *
     * @return The bytes for optimizationObjective.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOptimizationObjectiveBytes() {
      java.lang.Object ref = optimizationObjective_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        optimizationObjective_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OPTIMIZATION_OBJECTIVE_CONFIG_FIELD_NUMBER = 3;
    private com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .OptimizationObjectiveConfig
        optimizationObjectiveConfig_;

    /**
     *
     *
     * <pre>
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
     * </code>
     *
     * @return Whether the optimizationObjectiveConfig field is set.
     */
    @java.lang.Override
    public boolean hasOptimizationObjectiveConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
     * </code>
     *
     * @return The optimizationObjectiveConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .OptimizationObjectiveConfig
        getOptimizationObjectiveConfig() {
      return optimizationObjectiveConfig_ == null
          ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig.getDefaultInstance()
          : optimizationObjectiveConfig_;
    }

    /**
     *
     *
     * <pre>
     * Name and value of the custom threshold for cvr optimization_objective.
     * For target_field `watch-time`, target_field_value must be an integer
     * value indicating the media progress time in seconds between (0, 86400]
     * (excludes 0, includes 86400) (e.g., 90).
     * For target_field `watch-percentage`, the target_field_value must be a
     * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
     * 0.5).
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .OptimizationObjectiveConfigOrBuilder
        getOptimizationObjectiveConfigOrBuilder() {
      return optimizationObjectiveConfig_ == null
          ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig.getDefaultInstance()
          : optimizationObjectiveConfig_;
    }

    public static final int TRAINING_STATE_FIELD_NUMBER = 4;
    private int trainingState_ = 0;

    /**
     *
     *
     * <pre>
     * The training state that the engine is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * engine in order to control cost. If not specified: the default value for
     * `CreateEngine` method is `TRAINING`. The default value for
     * `UpdateEngine` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for trainingState.
     */
    @java.lang.Override
    public int getTrainingStateValue() {
      return trainingState_;
    }

    /**
     *
     *
     * <pre>
     * The training state that the engine is in (e.g.
     * `TRAINING` or `PAUSED`).
     *
     * Since part of the cost of running the service
     * is frequency of training - this can be used to determine when to train
     * engine in order to control cost. If not specified: the default value for
     * `CreateEngine` method is `TRAINING`. The default value for
     * `UpdateEngine` method is to keep the state the same as before.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
     * </code>
     *
     * @return The trainingState.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState
        getTrainingState() {
      com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState
          result =
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .TrainingState.forNumber(trainingState_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState
              .UNRECOGNIZED
          : result;
    }

    public static final int ENGINE_FEATURES_CONFIG_FIELD_NUMBER = 5;
    private com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .EngineFeaturesConfig
        engineFeaturesConfig_;

    /**
     *
     *
     * <pre>
     * Optional. Additional engine features config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the engineFeaturesConfig field is set.
     */
    @java.lang.Override
    public boolean hasEngineFeaturesConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Additional engine features config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The engineFeaturesConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .EngineFeaturesConfig
        getEngineFeaturesConfig() {
      return engineFeaturesConfig_ == null
          ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig.getDefaultInstance()
          : engineFeaturesConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Additional engine features config.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .EngineFeaturesConfigOrBuilder
        getEngineFeaturesConfigOrBuilder() {
      return engineFeaturesConfig_ == null
          ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig.getDefaultInstance()
          : engineFeaturesConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizationObjective_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, optimizationObjective_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getOptimizationObjectiveConfig());
      }
      if (trainingState_
          != com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .TrainingState.TRAINING_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, trainingState_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(5, getEngineFeaturesConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(optimizationObjective_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, optimizationObjective_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, getOptimizationObjectiveConfig());
      }
      if (trainingState_
          != com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .TrainingState.TRAINING_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, trainingState_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEngineFeaturesConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig other =
          (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig) obj;

      if (!getType().equals(other.getType())) return false;
      if (!getOptimizationObjective().equals(other.getOptimizationObjective())) return false;
      if (hasOptimizationObjectiveConfig() != other.hasOptimizationObjectiveConfig()) return false;
      if (hasOptimizationObjectiveConfig()) {
        if (!getOptimizationObjectiveConfig().equals(other.getOptimizationObjectiveConfig()))
          return false;
      }
      if (trainingState_ != other.trainingState_) return false;
      if (hasEngineFeaturesConfig() != other.hasEngineFeaturesConfig()) return false;
      if (hasEngineFeaturesConfig()) {
        if (!getEngineFeaturesConfig().equals(other.getEngineFeaturesConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (37 * hash) + OPTIMIZATION_OBJECTIVE_FIELD_NUMBER;
      hash = (53 * hash) + getOptimizationObjective().hashCode();
      if (hasOptimizationObjectiveConfig()) {
        hash = (37 * hash) + OPTIMIZATION_OBJECTIVE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getOptimizationObjectiveConfig().hashCode();
      }
      hash = (37 * hash) + TRAINING_STATE_FIELD_NUMBER;
      hash = (53 * hash) + trainingState_;
      if (hasEngineFeaturesConfig()) {
        hash = (37 * hash) + ENGINE_FEATURES_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getEngineFeaturesConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Additional config specs for a Media Recommendation engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getOptimizationObjectiveConfigFieldBuilder();
          getEngineFeaturesConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = "";
        optimizationObjective_ = "";
        optimizationObjectiveConfig_ = null;
        if (optimizationObjectiveConfigBuilder_ != null) {
          optimizationObjectiveConfigBuilder_.dispose();
          optimizationObjectiveConfigBuilder_ = null;
        }
        trainingState_ = 0;
        engineFeaturesConfig_ = null;
        if (engineFeaturesConfigBuilder_ != null) {
          engineFeaturesConfigBuilder_.dispose();
          engineFeaturesConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_MediaRecommendationEngineConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig build() {
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
          buildPartial() {
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig result =
            new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.optimizationObjective_ = optimizationObjective_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.optimizationObjectiveConfig_ =
              optimizationObjectiveConfigBuilder_ == null
                  ? optimizationObjectiveConfig_
                  : optimizationObjectiveConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.trainingState_ = trainingState_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.engineFeaturesConfig_ =
              engineFeaturesConfigBuilder_ == null
                  ? engineFeaturesConfig_
                  : engineFeaturesConfigBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .getDefaultInstance()) return this;
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getOptimizationObjective().isEmpty()) {
          optimizationObjective_ = other.optimizationObjective_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasOptimizationObjectiveConfig()) {
          mergeOptimizationObjectiveConfig(other.getOptimizationObjectiveConfig());
        }
        if (other.trainingState_ != 0) {
          setTrainingStateValue(other.getTrainingStateValue());
        }
        if (other.hasEngineFeaturesConfig()) {
          mergeEngineFeaturesConfig(other.getEngineFeaturesConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  type_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  optimizationObjective_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getOptimizationObjectiveConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  trainingState_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(
                      getEngineFeaturesConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";

      /**
       *
       *
       * <pre>
       * Required. The type of engine. e.g., `recommended-for-you`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported values: `recommended-for-you`, `others-you-may-like`,
       * `more-like-this`, `most-popular-items`.
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The type of engine. e.g., `recommended-for-you`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported values: `recommended-for-you`, `others-you-may-like`,
       * `more-like-this`, `most-popular-items`.
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The type of engine. e.g., `recommended-for-you`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported values: `recommended-for-you`, `others-you-may-like`,
       * `more-like-this`, `most-popular-items`.
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of engine. e.g., `recommended-for-you`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported values: `recommended-for-you`, `others-you-may-like`,
       * `more-like-this`, `most-popular-items`.
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        type_ = getDefaultInstance().getType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of engine. e.g., `recommended-for-you`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.optimization_objective]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported values: `recommended-for-you`, `others-you-may-like`,
       * `more-like-this`, `most-popular-items`.
       * </pre>
       *
       * <code>string type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object optimizationObjective_ = "";

      /**
       *
       *
       * <pre>
       * The optimization objective. e.g., `cvr`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported
       * values: `ctr`, `cvr`.
       *
       *  If not specified, we choose default based on engine type.
       * Default depends on type of recommendation:
       *
       * `recommended-for-you` =&gt; `ctr`
       *
       * `others-you-may-like` =&gt; `ctr`
       * </pre>
       *
       * <code>string optimization_objective = 2;</code>
       *
       * @return The optimizationObjective.
       */
      public java.lang.String getOptimizationObjective() {
        java.lang.Object ref = optimizationObjective_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          optimizationObjective_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The optimization objective. e.g., `cvr`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported
       * values: `ctr`, `cvr`.
       *
       *  If not specified, we choose default based on engine type.
       * Default depends on type of recommendation:
       *
       * `recommended-for-you` =&gt; `ctr`
       *
       * `others-you-may-like` =&gt; `ctr`
       * </pre>
       *
       * <code>string optimization_objective = 2;</code>
       *
       * @return The bytes for optimizationObjective.
       */
      public com.google.protobuf.ByteString getOptimizationObjectiveBytes() {
        java.lang.Object ref = optimizationObjective_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          optimizationObjective_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The optimization objective. e.g., `cvr`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported
       * values: `ctr`, `cvr`.
       *
       *  If not specified, we choose default based on engine type.
       * Default depends on type of recommendation:
       *
       * `recommended-for-you` =&gt; `ctr`
       *
       * `others-you-may-like` =&gt; `ctr`
       * </pre>
       *
       * <code>string optimization_objective = 2;</code>
       *
       * @param value The optimizationObjective to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizationObjective(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        optimizationObjective_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The optimization objective. e.g., `cvr`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported
       * values: `ctr`, `cvr`.
       *
       *  If not specified, we choose default based on engine type.
       * Default depends on type of recommendation:
       *
       * `recommended-for-you` =&gt; `ctr`
       *
       * `others-you-may-like` =&gt; `ctr`
       * </pre>
       *
       * <code>string optimization_objective = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOptimizationObjective() {
        optimizationObjective_ = getDefaultInstance().getOptimizationObjective();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The optimization objective. e.g., `cvr`.
       *
       * This field together with
       * [optimization_objective][google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.type]
       * describe engine metadata to use to control engine training and serving.
       *
       * Currently supported
       * values: `ctr`, `cvr`.
       *
       *  If not specified, we choose default based on engine type.
       * Default depends on type of recommendation:
       *
       * `recommended-for-you` =&gt; `ctr`
       *
       * `others-you-may-like` =&gt; `ctr`
       * </pre>
       *
       * <code>string optimization_objective = 2;</code>
       *
       * @param value The bytes for optimizationObjective to set.
       * @return This builder for chaining.
       */
      public Builder setOptimizationObjectiveBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        optimizationObjective_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          optimizationObjectiveConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig.Builder,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfigOrBuilder>
          optimizationObjectiveConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       *
       * @return Whether the optimizationObjectiveConfig field is set.
       */
      public boolean hasOptimizationObjectiveConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       *
       * @return The optimizationObjectiveConfig.
       */
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig
          getOptimizationObjectiveConfig() {
        if (optimizationObjectiveConfigBuilder_ == null) {
          return optimizationObjectiveConfig_ == null
              ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig.getDefaultInstance()
              : optimizationObjectiveConfig_;
        } else {
          return optimizationObjectiveConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       */
      public Builder setOptimizationObjectiveConfig(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig
              value) {
        if (optimizationObjectiveConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          optimizationObjectiveConfig_ = value;
        } else {
          optimizationObjectiveConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       */
      public Builder setOptimizationObjectiveConfig(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig.Builder
              builderForValue) {
        if (optimizationObjectiveConfigBuilder_ == null) {
          optimizationObjectiveConfig_ = builderForValue.build();
        } else {
          optimizationObjectiveConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       */
      public Builder mergeOptimizationObjectiveConfig(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig
              value) {
        if (optimizationObjectiveConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && optimizationObjectiveConfig_ != null
              && optimizationObjectiveConfig_
                  != com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .OptimizationObjectiveConfig.getDefaultInstance()) {
            getOptimizationObjectiveConfigBuilder().mergeFrom(value);
          } else {
            optimizationObjectiveConfig_ = value;
          }
        } else {
          optimizationObjectiveConfigBuilder_.mergeFrom(value);
        }
        if (optimizationObjectiveConfig_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       */
      public Builder clearOptimizationObjectiveConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        optimizationObjectiveConfig_ = null;
        if (optimizationObjectiveConfigBuilder_ != null) {
          optimizationObjectiveConfigBuilder_.dispose();
          optimizationObjectiveConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfig.Builder
          getOptimizationObjectiveConfigBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getOptimizationObjectiveConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .OptimizationObjectiveConfigOrBuilder
          getOptimizationObjectiveConfigOrBuilder() {
        if (optimizationObjectiveConfigBuilder_ != null) {
          return optimizationObjectiveConfigBuilder_.getMessageOrBuilder();
        } else {
          return optimizationObjectiveConfig_ == null
              ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig.getDefaultInstance()
              : optimizationObjectiveConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Name and value of the custom threshold for cvr optimization_objective.
       * For target_field `watch-time`, target_field_value must be an integer
       * value indicating the media progress time in seconds between (0, 86400]
       * (excludes 0, includes 86400) (e.g., 90).
       * For target_field `watch-percentage`, the target_field_value must be a
       * valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
       * 0.5).
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig optimization_objective_config = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfig.Builder,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .OptimizationObjectiveConfigOrBuilder>
          getOptimizationObjectiveConfigFieldBuilder() {
        if (optimizationObjectiveConfigBuilder_ == null) {
          optimizationObjectiveConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .OptimizationObjectiveConfig,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .OptimizationObjectiveConfig.Builder,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .OptimizationObjectiveConfigOrBuilder>(
                  getOptimizationObjectiveConfig(), getParentForChildren(), isClean());
          optimizationObjectiveConfig_ = null;
        }
        return optimizationObjectiveConfigBuilder_;
      }

      private int trainingState_ = 0;

      /**
       *
       *
       * <pre>
       * The training state that the engine is in (e.g.
       * `TRAINING` or `PAUSED`).
       *
       * Since part of the cost of running the service
       * is frequency of training - this can be used to determine when to train
       * engine in order to control cost. If not specified: the default value for
       * `CreateEngine` method is `TRAINING`. The default value for
       * `UpdateEngine` method is to keep the state the same as before.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for trainingState.
       */
      @java.lang.Override
      public int getTrainingStateValue() {
        return trainingState_;
      }

      /**
       *
       *
       * <pre>
       * The training state that the engine is in (e.g.
       * `TRAINING` or `PAUSED`).
       *
       * Since part of the cost of running the service
       * is frequency of training - this can be used to determine when to train
       * engine in order to control cost. If not specified: the default value for
       * `CreateEngine` method is `TRAINING`. The default value for
       * `UpdateEngine` method is to keep the state the same as before.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for trainingState to set.
       * @return This builder for chaining.
       */
      public Builder setTrainingStateValue(int value) {
        trainingState_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The training state that the engine is in (e.g.
       * `TRAINING` or `PAUSED`).
       *
       * Since part of the cost of running the service
       * is frequency of training - this can be used to determine when to train
       * engine in order to control cost. If not specified: the default value for
       * `CreateEngine` method is `TRAINING`. The default value for
       * `UpdateEngine` method is to keep the state the same as before.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
       * </code>
       *
       * @return The trainingState.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .TrainingState
          getTrainingState() {
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState
            result =
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .TrainingState.forNumber(trainingState_);
        return result == null
            ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                .TrainingState.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The training state that the engine is in (e.g.
       * `TRAINING` or `PAUSED`).
       *
       * Since part of the cost of running the service
       * is frequency of training - this can be used to determine when to train
       * engine in order to control cost. If not specified: the default value for
       * `CreateEngine` method is `TRAINING`. The default value for
       * `UpdateEngine` method is to keep the state the same as before.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
       * </code>
       *
       * @param value The trainingState to set.
       * @return This builder for chaining.
       */
      public Builder setTrainingState(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        trainingState_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The training state that the engine is in (e.g.
       * `TRAINING` or `PAUSED`).
       *
       * Since part of the cost of running the service
       * is frequency of training - this can be used to determine when to train
       * engine in order to control cost. If not specified: the default value for
       * `CreateEngine` method is `TRAINING`. The default value for
       * `UpdateEngine` method is to keep the state the same as before.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.TrainingState training_state = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrainingState() {
        bitField0_ = (bitField0_ & ~0x00000008);
        trainingState_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          engineFeaturesConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig.Builder,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfigOrBuilder>
          engineFeaturesConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the engineFeaturesConfig field is set.
       */
      public boolean hasEngineFeaturesConfig() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The engineFeaturesConfig.
       */
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig
          getEngineFeaturesConfig() {
        if (engineFeaturesConfigBuilder_ == null) {
          return engineFeaturesConfig_ == null
              ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig.getDefaultInstance()
              : engineFeaturesConfig_;
        } else {
          return engineFeaturesConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEngineFeaturesConfig(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig
              value) {
        if (engineFeaturesConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          engineFeaturesConfig_ = value;
        } else {
          engineFeaturesConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEngineFeaturesConfig(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig.Builder
              builderForValue) {
        if (engineFeaturesConfigBuilder_ == null) {
          engineFeaturesConfig_ = builderForValue.build();
        } else {
          engineFeaturesConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeEngineFeaturesConfig(
          com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig
              value) {
        if (engineFeaturesConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && engineFeaturesConfig_ != null
              && engineFeaturesConfig_
                  != com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .EngineFeaturesConfig.getDefaultInstance()) {
            getEngineFeaturesConfigBuilder().mergeFrom(value);
          } else {
            engineFeaturesConfig_ = value;
          }
        } else {
          engineFeaturesConfigBuilder_.mergeFrom(value);
        }
        if (engineFeaturesConfig_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearEngineFeaturesConfig() {
        bitField0_ = (bitField0_ & ~0x00000010);
        engineFeaturesConfig_ = null;
        if (engineFeaturesConfigBuilder_ != null) {
          engineFeaturesConfigBuilder_.dispose();
          engineFeaturesConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfig.Builder
          getEngineFeaturesConfigBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getEngineFeaturesConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
              .EngineFeaturesConfigOrBuilder
          getEngineFeaturesConfigOrBuilder() {
        if (engineFeaturesConfigBuilder_ != null) {
          return engineFeaturesConfigBuilder_.getMessageOrBuilder();
        } else {
          return engineFeaturesConfig_ == null
              ? com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig.getDefaultInstance()
              : engineFeaturesConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Additional engine features config.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.EngineFeaturesConfig engine_features_config = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfig.Builder,
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .EngineFeaturesConfigOrBuilder>
          getEngineFeaturesConfigFieldBuilder() {
        if (engineFeaturesConfigBuilder_ == null) {
          engineFeaturesConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .EngineFeaturesConfig,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .EngineFeaturesConfig.Builder,
                  com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                      .EngineFeaturesConfigOrBuilder>(
                  getEngineFeaturesConfig(), getParentForChildren(), isClean());
          engineFeaturesConfig_ = null;
        }
        return engineFeaturesConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
    private static final com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig();
    }

    public static com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MediaRecommendationEngineConfig> PARSER =
        new com.google.protobuf.AbstractParser<MediaRecommendationEngineConfig>() {
          @java.lang.Override
          public MediaRecommendationEngineConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MediaRecommendationEngineConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MediaRecommendationEngineConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ChatEngineConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return Whether the agentCreationConfig field is set.
     */
    boolean hasAgentCreationConfig();

    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return The agentCreationConfig.
     */
    com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
        getAgentCreationConfig();

    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfigOrBuilder
        getAgentCreationConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The dialogflowAgentToLink.
     */
    java.lang.String getDialogflowAgentToLink();

    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The bytes for dialogflowAgentToLink.
     */
    com.google.protobuf.ByteString getDialogflowAgentToLinkBytes();

    /**
     *
     *
     * <pre>
     * Optional. If the flag set to true, we allow the agent and engine are in
     * different locations, otherwise the agent and engine are required to be in
     * the same location. The flag is set to false by default.
     *
     * Note that the `allow_cross_region` are one-time consumed by and
     * passed to
     * [EngineService.CreateEngine][google.cloud.discoveryengine.v1.EngineService.CreateEngine].
     * It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>bool allow_cross_region = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowCrossRegion.
     */
    boolean getAllowCrossRegion();
  }

  /**
   *
   *
   * <pre>
   * Configurations for a Chat Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.ChatEngineConfig}
   */
  public static final class ChatEngineConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig)
      ChatEngineConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ChatEngineConfig.newBuilder() to construct.
    private ChatEngineConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChatEngineConfig() {
      dialogflowAgentToLink_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChatEngineConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.class,
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.Builder.class);
    }

    public interface AgentCreationConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The business.
       */
      java.lang.String getBusiness();

      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The bytes for business.
       */
      com.google.protobuf.ByteString getBusinessBytes();

      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The defaultLanguageCode.
       */
      java.lang.String getDefaultLanguageCode();

      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The bytes for defaultLanguageCode.
       */
      com.google.protobuf.ByteString getDefaultLanguageCodeBytes();

      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The timeZone.
       */
      java.lang.String getTimeZone();

      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for timeZone.
       */
      com.google.protobuf.ByteString getTimeZoneBytes();

      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The location.
       */
      java.lang.String getLocation();

      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The bytes for location.
       */
      com.google.protobuf.ByteString getLocationBytes();
    }

    /**
     *
     *
     * <pre>
     * Configurations for generating a Dialogflow agent.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig}
     */
    public static final class AgentCreationConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig)
        AgentCreationConfigOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use AgentCreationConfig.newBuilder() to construct.
      private AgentCreationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AgentCreationConfig() {
        business_ = "";
        defaultLanguageCode_ = "";
        timeZone_ = "";
        location_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AgentCreationConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_AgentCreationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_AgentCreationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                    .class,
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                    .Builder.class);
      }

      public static final int BUSINESS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object business_ = "";

      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The business.
       */
      @java.lang.Override
      public java.lang.String getBusiness() {
        java.lang.Object ref = business_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          business_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the company, organization or other entity that the agent
       * represents. Used for knowledge connector LLM prompt and for knowledge
       * search.
       * </pre>
       *
       * <code>string business = 1;</code>
       *
       * @return The bytes for business.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBusinessBytes() {
        java.lang.Object ref = business_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          business_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DEFAULT_LANGUAGE_CODE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object defaultLanguageCode_ = "";

      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The defaultLanguageCode.
       */
      @java.lang.Override
      public java.lang.String getDefaultLanguageCode() {
        java.lang.Object ref = defaultLanguageCode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultLanguageCode_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The default language of the agent as a language tag.
       * See [Language
       * Support](https://cloud.google.com/dialogflow/docs/reference/language)
       * for a list of the currently supported language codes.
       * </pre>
       *
       * <code>string default_language_code = 2;</code>
       *
       * @return The bytes for defaultLanguageCode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
        java.lang.Object ref = defaultLanguageCode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultLanguageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TIME_ZONE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object timeZone_ = "";

      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The timeZone.
       */
      @java.lang.Override
      public java.lang.String getTimeZone() {
        java.lang.Object ref = timeZone_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          timeZone_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The time zone of the agent from the [time zone
       * database](https://www.iana.org/time-zones), e.g., America/New_York,
       * Europe/Paris.
       * </pre>
       *
       * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for timeZone.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTimeZoneBytes() {
        java.lang.Object ref = timeZone_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          timeZone_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LOCATION_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object location_ = "";

      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The location.
       */
      @java.lang.Override
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Agent location for Agent creation, supported values: global/us/eu.
       * If not provided, us Engine will create Agent using us-central-1 by
       * default; eu Engine will create Agent using eu-west-1 by default.
       * </pre>
       *
       * <code>string location = 4;</code>
       *
       * @return The bytes for location.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(business_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, business_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, defaultLanguageCode_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, timeZone_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, location_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(business_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, business_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, defaultLanguageCode_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, timeZone_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, location_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig other =
            (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig) obj;

        if (!getBusiness().equals(other.getBusiness())) return false;
        if (!getDefaultLanguageCode().equals(other.getDefaultLanguageCode())) return false;
        if (!getTimeZone().equals(other.getTimeZone())) return false;
        if (!getLocation().equals(other.getLocation())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + BUSINESS_FIELD_NUMBER;
        hash = (53 * hash) + getBusiness().hashCode();
        hash = (37 * hash) + DEFAULT_LANGUAGE_CODE_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultLanguageCode().hashCode();
        hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeZone().hashCode();
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Configurations for generating a Dialogflow agent.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig)
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_AgentCreationConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_AgentCreationConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                      .class,
                  com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          business_ = "";
          defaultLanguageCode_ = "";
          timeZone_ = "";
          location_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1.EngineProto
              .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_AgentCreationConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
            build() {
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
            buildPartial() {
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig result =
              new com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.business_ = business_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.defaultLanguageCode_ = defaultLanguageCode_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.timeZone_ = timeZone_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.location_ = location_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig other) {
          if (other
              == com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                  .getDefaultInstance()) return this;
          if (!other.getBusiness().isEmpty()) {
            business_ = other.business_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getDefaultLanguageCode().isEmpty()) {
            defaultLanguageCode_ = other.defaultLanguageCode_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getTimeZone().isEmpty()) {
            timeZone_ = other.timeZone_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getLocation().isEmpty()) {
            location_ = other.location_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    business_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    defaultLanguageCode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    timeZone_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    location_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object business_ = "";

        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @return The business.
         */
        public java.lang.String getBusiness() {
          java.lang.Object ref = business_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            business_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @return The bytes for business.
         */
        public com.google.protobuf.ByteString getBusinessBytes() {
          java.lang.Object ref = business_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            business_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @param value The business to set.
         * @return This builder for chaining.
         */
        public Builder setBusiness(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          business_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBusiness() {
          business_ = getDefaultInstance().getBusiness();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Name of the company, organization or other entity that the agent
         * represents. Used for knowledge connector LLM prompt and for knowledge
         * search.
         * </pre>
         *
         * <code>string business = 1;</code>
         *
         * @param value The bytes for business to set.
         * @return This builder for chaining.
         */
        public Builder setBusinessBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          business_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object defaultLanguageCode_ = "";

        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @return The defaultLanguageCode.
         */
        public java.lang.String getDefaultLanguageCode() {
          java.lang.Object ref = defaultLanguageCode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            defaultLanguageCode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @return The bytes for defaultLanguageCode.
         */
        public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
          java.lang.Object ref = defaultLanguageCode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            defaultLanguageCode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @param value The defaultLanguageCode to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultLanguageCode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultLanguageCode_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultLanguageCode() {
          defaultLanguageCode_ = getDefaultInstance().getDefaultLanguageCode();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The default language of the agent as a language tag.
         * See [Language
         * Support](https://cloud.google.com/dialogflow/docs/reference/language)
         * for a list of the currently supported language codes.
         * </pre>
         *
         * <code>string default_language_code = 2;</code>
         *
         * @param value The bytes for defaultLanguageCode to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultLanguageCodeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          defaultLanguageCode_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object timeZone_ = "";

        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The timeZone.
         */
        public java.lang.String getTimeZone() {
          java.lang.Object ref = timeZone_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            timeZone_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The bytes for timeZone.
         */
        public com.google.protobuf.ByteString getTimeZoneBytes() {
          java.lang.Object ref = timeZone_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            timeZone_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The timeZone to set.
         * @return This builder for chaining.
         */
        public Builder setTimeZone(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeZone_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearTimeZone() {
          timeZone_ = getDefaultInstance().getTimeZone();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. The time zone of the agent from the [time zone
         * database](https://www.iana.org/time-zones), e.g., America/New_York,
         * Europe/Paris.
         * </pre>
         *
         * <code>string time_zone = 3 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes for timeZone to set.
         * @return This builder for chaining.
         */
        public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          timeZone_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object location_ = "";

        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @return The location.
         */
        public java.lang.String getLocation() {
          java.lang.Object ref = location_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            location_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @return The bytes for location.
         */
        public com.google.protobuf.ByteString getLocationBytes() {
          java.lang.Object ref = location_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            location_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @param value The location to set.
         * @return This builder for chaining.
         */
        public Builder setLocation(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLocation() {
          location_ = getDefaultInstance().getLocation();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Agent location for Agent creation, supported values: global/us/eu.
         * If not provided, us Engine will create Agent using us-central-1 by
         * default; eu Engine will create Agent using eu-west-1 by default.
         * </pre>
         *
         * <code>string location = 4;</code>
         *
         * @param value The bytes for location to set.
         * @return This builder for chaining.
         */
        public Builder setLocationBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          location_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig)
      private static final com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
              .AgentCreationConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig();
      }

      public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AgentCreationConfig> PARSER =
          new com.google.protobuf.AbstractParser<AgentCreationConfig>() {
            @java.lang.Override
            public AgentCreationConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AgentCreationConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AgentCreationConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int AGENT_CREATION_CONFIG_FIELD_NUMBER = 1;
    private com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
        agentCreationConfig_;

    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return Whether the agentCreationConfig field is set.
     */
    @java.lang.Override
    public boolean hasAgentCreationConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     *
     * @return The agentCreationConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
        getAgentCreationConfig() {
      return agentCreationConfig_ == null
          ? com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
              .getDefaultInstance()
          : agentCreationConfig_;
    }

    /**
     *
     *
     * <pre>
     * The configurationt generate the Dialogflow agent that is associated to
     * this Engine.
     *
     * Note that these configurations are one-time consumed by
     * and passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfigOrBuilder
        getAgentCreationConfigOrBuilder() {
      return agentCreationConfig_ == null
          ? com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
              .getDefaultInstance()
          : agentCreationConfig_;
    }

    public static final int DIALOGFLOW_AGENT_TO_LINK_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dialogflowAgentToLink_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The dialogflowAgentToLink.
     */
    @java.lang.Override
    public java.lang.String getDialogflowAgentToLink() {
      java.lang.Object ref = dialogflowAgentToLink_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dialogflowAgentToLink_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of an exist Dialogflow agent to link to this Chat
     * Engine. Customers can either provide `agent_creation_config` to create
     * agent or provide an agent name that links the agent with the Chat engine.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     *
     * Note that the `dialogflow_agent_to_link` are one-time consumed by and
     * passed to Dialogflow service. It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation. Use
     * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
     * for actual agent association after Engine is created.
     * </pre>
     *
     * <code>string dialogflow_agent_to_link = 2;</code>
     *
     * @return The bytes for dialogflowAgentToLink.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDialogflowAgentToLinkBytes() {
      java.lang.Object ref = dialogflowAgentToLink_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dialogflowAgentToLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_CROSS_REGION_FIELD_NUMBER = 3;
    private boolean allowCrossRegion_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If the flag set to true, we allow the agent and engine are in
     * different locations, otherwise the agent and engine are required to be in
     * the same location. The flag is set to false by default.
     *
     * Note that the `allow_cross_region` are one-time consumed by and
     * passed to
     * [EngineService.CreateEngine][google.cloud.discoveryengine.v1.EngineService.CreateEngine].
     * It means they cannot be retrieved using
     * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
     * or
     * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
     * API after engine creation.
     * </pre>
     *
     * <code>bool allow_cross_region = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowCrossRegion.
     */
    @java.lang.Override
    public boolean getAllowCrossRegion() {
      return allowCrossRegion_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getAgentCreationConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgentToLink_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dialogflowAgentToLink_);
      }
      if (allowCrossRegion_ != false) {
        output.writeBool(3, allowCrossRegion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAgentCreationConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgentToLink_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dialogflowAgentToLink_);
      }
      if (allowCrossRegion_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, allowCrossRegion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig other =
          (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) obj;

      if (hasAgentCreationConfig() != other.hasAgentCreationConfig()) return false;
      if (hasAgentCreationConfig()) {
        if (!getAgentCreationConfig().equals(other.getAgentCreationConfig())) return false;
      }
      if (!getDialogflowAgentToLink().equals(other.getDialogflowAgentToLink())) return false;
      if (getAllowCrossRegion() != other.getAllowCrossRegion()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAgentCreationConfig()) {
        hash = (37 * hash) + AGENT_CREATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAgentCreationConfig().hashCode();
      }
      hash = (37 * hash) + DIALOGFLOW_AGENT_TO_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getDialogflowAgentToLink().hashCode();
      hash = (37 * hash) + ALLOW_CROSS_REGION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowCrossRegion());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configurations for a Chat Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.ChatEngineConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig)
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAgentCreationConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        agentCreationConfig_ = null;
        if (agentCreationConfigBuilder_ != null) {
          agentCreationConfigBuilder_.dispose();
          agentCreationConfigBuilder_ = null;
        }
        dialogflowAgentToLink_ = "";
        allowCrossRegion_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig build() {
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig buildPartial() {
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig result =
            new com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.agentCreationConfig_ =
              agentCreationConfigBuilder_ == null
                  ? agentCreationConfig_
                  : agentCreationConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dialogflowAgentToLink_ = dialogflowAgentToLink_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.allowCrossRegion_ = allowCrossRegion_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance())
          return this;
        if (other.hasAgentCreationConfig()) {
          mergeAgentCreationConfig(other.getAgentCreationConfig());
        }
        if (!other.getDialogflowAgentToLink().isEmpty()) {
          dialogflowAgentToLink_ = other.dialogflowAgentToLink_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getAllowCrossRegion() != false) {
          setAllowCrossRegion(other.getAllowCrossRegion());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getAgentCreationConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  dialogflowAgentToLink_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  allowCrossRegion_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          agentCreationConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig,
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                  .Builder,
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
                  .AgentCreationConfigOrBuilder>
          agentCreationConfigBuilder_;

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       *
       * @return Whether the agentCreationConfig field is set.
       */
      public boolean hasAgentCreationConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       *
       * @return The agentCreationConfig.
       */
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
          getAgentCreationConfig() {
        if (agentCreationConfigBuilder_ == null) {
          return agentCreationConfig_ == null
              ? com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                  .getDefaultInstance()
              : agentCreationConfig_;
        } else {
          return agentCreationConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder setAgentCreationConfig(
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig value) {
        if (agentCreationConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          agentCreationConfig_ = value;
        } else {
          agentCreationConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder setAgentCreationConfig(
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig.Builder
              builderForValue) {
        if (agentCreationConfigBuilder_ == null) {
          agentCreationConfig_ = builderForValue.build();
        } else {
          agentCreationConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder mergeAgentCreationConfig(
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig value) {
        if (agentCreationConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && agentCreationConfig_ != null
              && agentCreationConfig_
                  != com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                      .getDefaultInstance()) {
            getAgentCreationConfigBuilder().mergeFrom(value);
          } else {
            agentCreationConfig_ = value;
          }
        } else {
          agentCreationConfigBuilder_.mergeFrom(value);
        }
        if (agentCreationConfig_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public Builder clearAgentCreationConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        agentCreationConfig_ = null;
        if (agentCreationConfigBuilder_ != null) {
          agentCreationConfigBuilder_.dispose();
          agentCreationConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig.Builder
          getAgentCreationConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getAgentCreationConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
              .AgentCreationConfigOrBuilder
          getAgentCreationConfigOrBuilder() {
        if (agentCreationConfigBuilder_ != null) {
          return agentCreationConfigBuilder_.getMessageOrBuilder();
        } else {
          return agentCreationConfig_ == null
              ? com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                  .getDefaultInstance()
              : agentCreationConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * The configurationt generate the Dialogflow agent that is associated to
       * this Engine.
       *
       * Note that these configurations are one-time consumed by
       * and passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig agent_creation_config = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig,
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                  .Builder,
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
                  .AgentCreationConfigOrBuilder>
          getAgentCreationConfigFieldBuilder() {
        if (agentCreationConfigBuilder_ == null) {
          agentCreationConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig,
                  com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.AgentCreationConfig
                      .Builder,
                  com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
                      .AgentCreationConfigOrBuilder>(
                  getAgentCreationConfig(), getParentForChildren(), isClean());
          agentCreationConfig_ = null;
        }
        return agentCreationConfigBuilder_;
      }

      private java.lang.Object dialogflowAgentToLink_ = "";

      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @return The dialogflowAgentToLink.
       */
      public java.lang.String getDialogflowAgentToLink() {
        java.lang.Object ref = dialogflowAgentToLink_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dialogflowAgentToLink_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @return The bytes for dialogflowAgentToLink.
       */
      public com.google.protobuf.ByteString getDialogflowAgentToLinkBytes() {
        java.lang.Object ref = dialogflowAgentToLink_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dialogflowAgentToLink_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @param value The dialogflowAgentToLink to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgentToLink(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialogflowAgentToLink_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDialogflowAgentToLink() {
        dialogflowAgentToLink_ = getDefaultInstance().getDialogflowAgentToLink();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of an exist Dialogflow agent to link to this Chat
       * Engine. Customers can either provide `agent_creation_config` to create
       * agent or provide an agent name that links the agent with the Chat engine.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       *
       * Note that the `dialogflow_agent_to_link` are one-time consumed by and
       * passed to Dialogflow service. It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation. Use
       * [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.dialogflow_agent]
       * for actual agent association after Engine is created.
       * </pre>
       *
       * <code>string dialogflow_agent_to_link = 2;</code>
       *
       * @param value The bytes for dialogflowAgentToLink to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgentToLinkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dialogflowAgentToLink_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean allowCrossRegion_;

      /**
       *
       *
       * <pre>
       * Optional. If the flag set to true, we allow the agent and engine are in
       * different locations, otherwise the agent and engine are required to be in
       * the same location. The flag is set to false by default.
       *
       * Note that the `allow_cross_region` are one-time consumed by and
       * passed to
       * [EngineService.CreateEngine][google.cloud.discoveryengine.v1.EngineService.CreateEngine].
       * It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>bool allow_cross_region = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The allowCrossRegion.
       */
      @java.lang.Override
      public boolean getAllowCrossRegion() {
        return allowCrossRegion_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If the flag set to true, we allow the agent and engine are in
       * different locations, otherwise the agent and engine are required to be in
       * the same location. The flag is set to false by default.
       *
       * Note that the `allow_cross_region` are one-time consumed by and
       * passed to
       * [EngineService.CreateEngine][google.cloud.discoveryengine.v1.EngineService.CreateEngine].
       * It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>bool allow_cross_region = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The allowCrossRegion to set.
       * @return This builder for chaining.
       */
      public Builder setAllowCrossRegion(boolean value) {

        allowCrossRegion_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If the flag set to true, we allow the agent and engine are in
       * different locations, otherwise the agent and engine are required to be in
       * the same location. The flag is set to false by default.
       *
       * Note that the `allow_cross_region` are one-time consumed by and
       * passed to
       * [EngineService.CreateEngine][google.cloud.discoveryengine.v1.EngineService.CreateEngine].
       * It means they cannot be retrieved using
       * [EngineService.GetEngine][google.cloud.discoveryengine.v1.EngineService.GetEngine]
       * or
       * [EngineService.ListEngines][google.cloud.discoveryengine.v1.EngineService.ListEngines]
       * API after engine creation.
       * </pre>
       *
       * <code>bool allow_cross_region = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowCrossRegion() {
        bitField0_ = (bitField0_ & ~0x00000004);
        allowCrossRegion_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.ChatEngineConfig)
    private static final com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig();
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChatEngineConfig> PARSER =
        new com.google.protobuf.AbstractParser<ChatEngineConfig>() {
          @java.lang.Override
          public ChatEngineConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChatEngineConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChatEngineConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CommonConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.CommonConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the company, business or entity that is associated with the
     * engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1;</code>
     *
     * @return The companyName.
     */
    java.lang.String getCompanyName();

    /**
     *
     *
     * <pre>
     * The name of the company, business or entity that is associated with the
     * engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1;</code>
     *
     * @return The bytes for companyName.
     */
    com.google.protobuf.ByteString getCompanyNameBytes();
  }

  /**
   *
   *
   * <pre>
   * Common configurations for an Engine.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.CommonConfig}
   */
  public static final class CommonConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.CommonConfig)
      CommonConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CommonConfig.newBuilder() to construct.
    private CommonConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CommonConfig() {
      companyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CommonConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_CommonConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_CommonConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Engine.CommonConfig.class,
              com.google.cloud.discoveryengine.v1.Engine.CommonConfig.Builder.class);
    }

    public static final int COMPANY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object companyName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the company, business or entity that is associated with the
     * engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1;</code>
     *
     * @return The companyName.
     */
    @java.lang.Override
    public java.lang.String getCompanyName() {
      java.lang.Object ref = companyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        companyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the company, business or entity that is associated with the
     * engine. Setting this may help improve LLM related features.
     * </pre>
     *
     * <code>string company_name = 1;</code>
     *
     * @return The bytes for companyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCompanyNameBytes() {
      java.lang.Object ref = companyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        companyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(companyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, companyName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(companyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, companyName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Engine.CommonConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Engine.CommonConfig other =
          (com.google.cloud.discoveryengine.v1.Engine.CommonConfig) obj;

      if (!getCompanyName().equals(other.getCompanyName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COMPANY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getCompanyName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Engine.CommonConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Common configurations for an Engine.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.CommonConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.CommonConfig)
        com.google.cloud.discoveryengine.v1.Engine.CommonConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_CommonConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_CommonConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.CommonConfig.class,
                com.google.cloud.discoveryengine.v1.Engine.CommonConfig.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Engine.CommonConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        companyName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_CommonConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.CommonConfig getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Engine.CommonConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.CommonConfig build() {
        com.google.cloud.discoveryengine.v1.Engine.CommonConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.CommonConfig buildPartial() {
        com.google.cloud.discoveryengine.v1.Engine.CommonConfig result =
            new com.google.cloud.discoveryengine.v1.Engine.CommonConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.discoveryengine.v1.Engine.CommonConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.companyName_ = companyName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Engine.CommonConfig) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Engine.CommonConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Engine.CommonConfig other) {
        if (other == com.google.cloud.discoveryengine.v1.Engine.CommonConfig.getDefaultInstance())
          return this;
        if (!other.getCompanyName().isEmpty()) {
          companyName_ = other.companyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  companyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object companyName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the company, business or entity that is associated with the
       * engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1;</code>
       *
       * @return The companyName.
       */
      public java.lang.String getCompanyName() {
        java.lang.Object ref = companyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          companyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the company, business or entity that is associated with the
       * engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1;</code>
       *
       * @return The bytes for companyName.
       */
      public com.google.protobuf.ByteString getCompanyNameBytes() {
        java.lang.Object ref = companyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          companyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the company, business or entity that is associated with the
       * engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1;</code>
       *
       * @param value The companyName to set.
       * @return This builder for chaining.
       */
      public Builder setCompanyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        companyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the company, business or entity that is associated with the
       * engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCompanyName() {
        companyName_ = getDefaultInstance().getCompanyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the company, business or entity that is associated with the
       * engine. Setting this may help improve LLM related features.
       * </pre>
       *
       * <code>string company_name = 1;</code>
       *
       * @param value The bytes for companyName to set.
       * @return This builder for chaining.
       */
      public Builder setCompanyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        companyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.CommonConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.CommonConfig)
    private static final com.google.cloud.discoveryengine.v1.Engine.CommonConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Engine.CommonConfig();
    }

    public static com.google.cloud.discoveryengine.v1.Engine.CommonConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CommonConfig> PARSER =
        new com.google.protobuf.AbstractParser<CommonConfig>() {
          @java.lang.Override
          public CommonConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CommonConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CommonConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.CommonConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ChatEngineMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The dialogflowAgent.
     */
    java.lang.String getDialogflowAgent();

    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The bytes for dialogflowAgent.
     */
    com.google.protobuf.ByteString getDialogflowAgentBytes();
  }

  /**
   *
   *
   * <pre>
   * Additional information of a Chat Engine.
   * Fields in this message are output only.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata}
   */
  public static final class ChatEngineMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata)
      ChatEngineMetadataOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ChatEngineMetadata.newBuilder() to construct.
    private ChatEngineMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ChatEngineMetadata() {
      dialogflowAgent_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ChatEngineMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.class,
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.Builder.class);
    }

    public static final int DIALOGFLOW_AGENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dialogflowAgent_ = "";

    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The dialogflowAgent.
     */
    @java.lang.Override
    public java.lang.String getDialogflowAgent() {
      java.lang.Object ref = dialogflowAgent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dialogflowAgent_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of a Dialogflow agent, that this Chat Engine refers
     * to.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;`.
     * </pre>
     *
     * <code>string dialogflow_agent = 1;</code>
     *
     * @return The bytes for dialogflowAgent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDialogflowAgentBytes() {
      java.lang.Object ref = dialogflowAgent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dialogflowAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dialogflowAgent_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowAgent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dialogflowAgent_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata other =
          (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) obj;

      if (!getDialogflowAgent().equals(other.getDialogflowAgent())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DIALOGFLOW_AGENT_FIELD_NUMBER;
      hash = (53 * hash) + getDialogflowAgent().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Additional information of a Chat Engine.
     * Fields in this message are output only.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata)
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.class,
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.Builder.class);
      }

      // Construct using com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dialogflowAgent_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.EngineProto
            .internal_static_google_cloud_discoveryengine_v1_Engine_ChatEngineMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata build() {
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata buildPartial() {
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata result =
            new com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dialogflowAgent_ = dialogflowAgent_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) {
          return mergeFrom((com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata other) {
        if (other
            == com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance())
          return this;
        if (!other.getDialogflowAgent().isEmpty()) {
          dialogflowAgent_ = other.dialogflowAgent_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dialogflowAgent_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dialogflowAgent_ = "";

      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @return The dialogflowAgent.
       */
      public java.lang.String getDialogflowAgent() {
        java.lang.Object ref = dialogflowAgent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dialogflowAgent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @return The bytes for dialogflowAgent.
       */
      public com.google.protobuf.ByteString getDialogflowAgentBytes() {
        java.lang.Object ref = dialogflowAgent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dialogflowAgent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @param value The dialogflowAgent to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialogflowAgent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDialogflowAgent() {
        dialogflowAgent_ = getDefaultInstance().getDialogflowAgent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource name of a Dialogflow agent, that this Chat Engine refers
       * to.
       *
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
       * ID&gt;`.
       * </pre>
       *
       * <code>string dialogflow_agent = 1;</code>
       *
       * @param value The bytes for dialogflowAgent to set.
       * @return This builder for chaining.
       */
      public Builder setDialogflowAgentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dialogflowAgent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata)
    private static final com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata();
    }

    public static com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChatEngineMetadata> PARSER =
        new com.google.protobuf.AbstractParser<ChatEngineMetadata>() {
          @java.lang.Override
          public ChatEngineMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ChatEngineMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChatEngineMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int engineConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object engineConfig_;

  public enum EngineConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CHAT_ENGINE_CONFIG(11),
    SEARCH_ENGINE_CONFIG(13),
    MEDIA_RECOMMENDATION_ENGINE_CONFIG(14),
    ENGINECONFIG_NOT_SET(0);
    private final int value;

    private EngineConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EngineConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static EngineConfigCase forNumber(int value) {
      switch (value) {
        case 11:
          return CHAT_ENGINE_CONFIG;
        case 13:
          return SEARCH_ENGINE_CONFIG;
        case 14:
          return MEDIA_RECOMMENDATION_ENGINE_CONFIG;
        case 0:
          return ENGINECONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EngineConfigCase getEngineConfigCase() {
    return EngineConfigCase.forNumber(engineConfigCase_);
  }

  private int engineMetadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object engineMetadata_;

  public enum EngineMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CHAT_ENGINE_METADATA(12),
    ENGINEMETADATA_NOT_SET(0);
    private final int value;

    private EngineMetadataCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EngineMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static EngineMetadataCase forNumber(int value) {
      switch (value) {
        case 12:
          return CHAT_ENGINE_METADATA;
        case 0:
          return ENGINEMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EngineMetadataCase getEngineMetadataCase() {
    return EngineMetadataCase.forNumber(engineMetadataCase_);
  }

  public static final int CHAT_ENGINE_CONFIG_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * Configurations for the Chat Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;</code>
   *
   * @return Whether the chatEngineConfig field is set.
   */
  @java.lang.Override
  public boolean hasChatEngineConfig() {
    return engineConfigCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * Configurations for the Chat Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;</code>
   *
   * @return The chatEngineConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig getChatEngineConfig() {
    if (engineConfigCase_ == 11) {
      return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Configurations for the Chat Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfigOrBuilder
      getChatEngineConfigOrBuilder() {
    if (engineConfigCase_ == 11) {
      return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance();
  }

  public static final int SEARCH_ENGINE_CONFIG_FIELD_NUMBER = 13;

  /**
   *
   *
   * <pre>
   * Configurations for the Search Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
   * </code>
   *
   * @return Whether the searchEngineConfig field is set.
   */
  @java.lang.Override
  public boolean hasSearchEngineConfig() {
    return engineConfigCase_ == 13;
  }

  /**
   *
   *
   * <pre>
   * Configurations for the Search Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
   * </code>
   *
   * @return The searchEngineConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig getSearchEngineConfig() {
    if (engineConfigCase_ == 13) {
      return (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Configurations for the Search Engine. Only applicable if
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfigOrBuilder
      getSearchEngineConfigOrBuilder() {
    if (engineConfigCase_ == 13) {
      return (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance();
  }

  public static final int MEDIA_RECOMMENDATION_ENGINE_CONFIG_FIELD_NUMBER = 14;

  /**
   *
   *
   * <pre>
   * Configurations for the Media Engine. Only applicable on the data
   * stores with
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * and
   * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
   * vertical.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
   * </code>
   *
   * @return Whether the mediaRecommendationEngineConfig field is set.
   */
  @java.lang.Override
  public boolean hasMediaRecommendationEngineConfig() {
    return engineConfigCase_ == 14;
  }

  /**
   *
   *
   * <pre>
   * Configurations for the Media Engine. Only applicable on the data
   * stores with
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * and
   * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
   * vertical.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
   * </code>
   *
   * @return The mediaRecommendationEngineConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
      getMediaRecommendationEngineConfig() {
    if (engineConfigCase_ == 14) {
      return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
          engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Configurations for the Media Engine. Only applicable on the data
   * stores with
   * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * and
   * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
   * vertical.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfigOrBuilder
      getMediaRecommendationEngineConfigOrBuilder() {
    if (engineConfigCase_ == 14) {
      return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
          engineConfig_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        .getDefaultInstance();
  }

  public static final int CHAT_ENGINE_METADATA_FIELD_NUMBER = 12;

  /**
   *
   *
   * <pre>
   * Output only. Additional information of the Chat Engine. Only applicable
   * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the chatEngineMetadata field is set.
   */
  @java.lang.Override
  public boolean hasChatEngineMetadata() {
    return engineMetadataCase_ == 12;
  }

  /**
   *
   *
   * <pre>
   * Output only. Additional information of the Chat Engine. Only applicable
   * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The chatEngineMetadata.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata getChatEngineMetadata() {
    if (engineMetadataCase_ == 12) {
      return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) engineMetadata_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Output only. Additional information of the Chat Engine. Only applicable
   * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
   * is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadataOrBuilder
      getChatEngineMetadataOrBuilder() {
    if (engineMetadataCase_ == 12) {
      return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) engineMetadata_;
    }
    return com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Identifier. The fully qualified resource name of the engine.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   *
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
   * engine should be 1-63 characters, and valid characters are
   * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Identifier. The fully qualified resource name of the engine.
   *
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   *
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
   * engine should be 1-63 characters, and valid characters are
   * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The display name of the engine. Should be human readable. UTF-8
   * encoded string with limit of 1024 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The display name of the engine. Should be human readable. UTF-8
   * encoded string with limit of 1024 characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was created at.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp the Recommendation Engine was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DATA_STORE_IDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList dataStoreIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the dataStoreIds.
   */
  public com.google.protobuf.ProtocolStringList getDataStoreIdsList() {
    return dataStoreIds_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of dataStoreIds.
   */
  public int getDataStoreIdsCount() {
    return dataStoreIds_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The dataStoreIds at the given index.
   */
  public java.lang.String getDataStoreIds(int index) {
    return dataStoreIds_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The data stores associated with this engine.
   *
   * For
   * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
   * and
   * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
   * type of engines, they can only associate with at most one data store.
   *
   * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
   * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
   * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
   * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
   * associated here.
   *
   * Note that when used in
   * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
   * one DataStore id must be provided as the system will use it for necessary
   * initializations.
   * </pre>
   *
   * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dataStoreIds at the given index.
   */
  public com.google.protobuf.ByteString getDataStoreIdsBytes(int index) {
    return dataStoreIds_.getByteString(index);
  }

  public static final int SOLUTION_TYPE_FIELD_NUMBER = 6;
  private int solutionType_ = 0;

  /**
   *
   *
   * <pre>
   * Required. The solutions of the engine.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for solutionType.
   */
  @java.lang.Override
  public int getSolutionTypeValue() {
    return solutionType_;
  }

  /**
   *
   *
   * <pre>
   * Required. The solutions of the engine.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The solutionType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.SolutionType getSolutionType() {
    com.google.cloud.discoveryengine.v1.SolutionType result =
        com.google.cloud.discoveryengine.v1.SolutionType.forNumber(solutionType_);
    return result == null ? com.google.cloud.discoveryengine.v1.SolutionType.UNRECOGNIZED : result;
  }

  public static final int INDUSTRY_VERTICAL_FIELD_NUMBER = 16;
  private int industryVertical_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The industry vertical that the engine registers.
   * The restriction of the Engine industry vertical is based on
   * [DataStore][google.cloud.discoveryengine.v1.DataStore]: Vertical on Engine
   * has to match vertical of the DataStore linked to the engine.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for industryVertical.
   */
  @java.lang.Override
  public int getIndustryVerticalValue() {
    return industryVertical_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The industry vertical that the engine registers.
   * The restriction of the Engine industry vertical is based on
   * [DataStore][google.cloud.discoveryengine.v1.DataStore]: Vertical on Engine
   * has to match vertical of the DataStore linked to the engine.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The industryVertical.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.IndustryVertical getIndustryVertical() {
    com.google.cloud.discoveryengine.v1.IndustryVertical result =
        com.google.cloud.discoveryengine.v1.IndustryVertical.forNumber(industryVertical_);
    return result == null
        ? com.google.cloud.discoveryengine.v1.IndustryVertical.UNRECOGNIZED
        : result;
  }

  public static final int COMMON_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.discoveryengine.v1.Engine.CommonConfig commonConfig_;

  /**
   *
   *
   * <pre>
   * Common config spec that specifies the metadata of the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
   *
   * @return Whether the commonConfig field is set.
   */
  @java.lang.Override
  public boolean hasCommonConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Common config spec that specifies the metadata of the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
   *
   * @return The commonConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.CommonConfig getCommonConfig() {
    return commonConfig_ == null
        ? com.google.cloud.discoveryengine.v1.Engine.CommonConfig.getDefaultInstance()
        : commonConfig_;
  }

  /**
   *
   *
   * <pre>
   * Common config spec that specifies the metadata of the engine.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine.CommonConfigOrBuilder
      getCommonConfigOrBuilder() {
    return commonConfig_ == null
        ? com.google.cloud.discoveryengine.v1.Engine.CommonConfig.getDefaultInstance()
        : commonConfig_;
  }

  public static final int DISABLE_ANALYTICS_FIELD_NUMBER = 26;
  private boolean disableAnalytics_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether to disable analytics for searches performed on this
   * engine.
   * </pre>
   *
   * <code>bool disable_analytics = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disableAnalytics.
   */
  @java.lang.Override
  public boolean getDisableAnalytics() {
    return disableAnalytics_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    for (int i = 0; i < dataStoreIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dataStoreIds_.getRaw(i));
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, solutionType_);
    }
    if (engineConfigCase_ == 11) {
      output.writeMessage(
          11, (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_);
    }
    if (engineMetadataCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) engineMetadata_);
    }
    if (engineConfigCase_ == 13) {
      output.writeMessage(
          13, (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_);
    }
    if (engineConfigCase_ == 14) {
      output.writeMessage(
          14,
          (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
              engineConfig_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(15, getCommonConfig());
    }
    if (industryVertical_
        != com.google.cloud.discoveryengine.v1.IndustryVertical.INDUSTRY_VERTICAL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(16, industryVertical_);
    }
    if (disableAnalytics_ != false) {
      output.writeBool(26, disableAnalytics_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dataStoreIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(dataStoreIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDataStoreIdsList().size();
    }
    if (solutionType_
        != com.google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, solutionType_);
    }
    if (engineConfigCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_);
    }
    if (engineMetadataCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) engineMetadata_);
    }
    if (engineConfigCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_);
    }
    if (engineConfigCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14,
              (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
                  engineConfig_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getCommonConfig());
    }
    if (industryVertical_
        != com.google.cloud.discoveryengine.v1.IndustryVertical.INDUSTRY_VERTICAL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, industryVertical_);
    }
    if (disableAnalytics_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(26, disableAnalytics_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.Engine)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.Engine other =
        (com.google.cloud.discoveryengine.v1.Engine) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getDataStoreIdsList().equals(other.getDataStoreIdsList())) return false;
    if (solutionType_ != other.solutionType_) return false;
    if (industryVertical_ != other.industryVertical_) return false;
    if (hasCommonConfig() != other.hasCommonConfig()) return false;
    if (hasCommonConfig()) {
      if (!getCommonConfig().equals(other.getCommonConfig())) return false;
    }
    if (getDisableAnalytics() != other.getDisableAnalytics()) return false;
    if (!getEngineConfigCase().equals(other.getEngineConfigCase())) return false;
    switch (engineConfigCase_) {
      case 11:
        if (!getChatEngineConfig().equals(other.getChatEngineConfig())) return false;
        break;
      case 13:
        if (!getSearchEngineConfig().equals(other.getSearchEngineConfig())) return false;
        break;
      case 14:
        if (!getMediaRecommendationEngineConfig()
            .equals(other.getMediaRecommendationEngineConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getEngineMetadataCase().equals(other.getEngineMetadataCase())) return false;
    switch (engineMetadataCase_) {
      case 12:
        if (!getChatEngineMetadata().equals(other.getChatEngineMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getDataStoreIdsCount() > 0) {
      hash = (37 * hash) + DATA_STORE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStoreIdsList().hashCode();
    }
    hash = (37 * hash) + SOLUTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + solutionType_;
    hash = (37 * hash) + INDUSTRY_VERTICAL_FIELD_NUMBER;
    hash = (53 * hash) + industryVertical_;
    if (hasCommonConfig()) {
      hash = (37 * hash) + COMMON_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCommonConfig().hashCode();
    }
    hash = (37 * hash) + DISABLE_ANALYTICS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableAnalytics());
    switch (engineConfigCase_) {
      case 11:
        hash = (37 * hash) + CHAT_ENGINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getChatEngineConfig().hashCode();
        break;
      case 13:
        hash = (37 * hash) + SEARCH_ENGINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSearchEngineConfig().hashCode();
        break;
      case 14:
        hash = (37 * hash) + MEDIA_RECOMMENDATION_ENGINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMediaRecommendationEngineConfig().hashCode();
        break;
      case 0:
      default:
    }
    switch (engineMetadataCase_) {
      case 12:
        hash = (37 * hash) + CHAT_ENGINE_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getChatEngineMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Engine parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.Engine prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Metadata that describes the training and serving parameters of an
   * [Engine][google.cloud.discoveryengine.v1.Engine].
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Engine}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Engine)
      com.google.cloud.discoveryengine.v1.EngineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Engine.class,
              com.google.cloud.discoveryengine.v1.Engine.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.Engine.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getCommonConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (chatEngineConfigBuilder_ != null) {
        chatEngineConfigBuilder_.clear();
      }
      if (searchEngineConfigBuilder_ != null) {
        searchEngineConfigBuilder_.clear();
      }
      if (mediaRecommendationEngineConfigBuilder_ != null) {
        mediaRecommendationEngineConfigBuilder_.clear();
      }
      if (chatEngineMetadataBuilder_ != null) {
        chatEngineMetadataBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      dataStoreIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      solutionType_ = 0;
      industryVertical_ = 0;
      commonConfig_ = null;
      if (commonConfigBuilder_ != null) {
        commonConfigBuilder_.dispose();
        commonConfigBuilder_ = null;
      }
      disableAnalytics_ = false;
      engineConfigCase_ = 0;
      engineConfig_ = null;
      engineMetadataCase_ = 0;
      engineMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.EngineProto
          .internal_static_google_cloud_discoveryengine_v1_Engine_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.Engine.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine build() {
      com.google.cloud.discoveryengine.v1.Engine result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine buildPartial() {
      com.google.cloud.discoveryengine.v1.Engine result =
          new com.google.cloud.discoveryengine.v1.Engine(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.Engine result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        dataStoreIds_.makeImmutable();
        result.dataStoreIds_ = dataStoreIds_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.solutionType_ = solutionType_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.industryVertical_ = industryVertical_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.commonConfig_ =
            commonConfigBuilder_ == null ? commonConfig_ : commonConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.disableAnalytics_ = disableAnalytics_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1.Engine result) {
      result.engineConfigCase_ = engineConfigCase_;
      result.engineConfig_ = this.engineConfig_;
      if (engineConfigCase_ == 11 && chatEngineConfigBuilder_ != null) {
        result.engineConfig_ = chatEngineConfigBuilder_.build();
      }
      if (engineConfigCase_ == 13 && searchEngineConfigBuilder_ != null) {
        result.engineConfig_ = searchEngineConfigBuilder_.build();
      }
      if (engineConfigCase_ == 14 && mediaRecommendationEngineConfigBuilder_ != null) {
        result.engineConfig_ = mediaRecommendationEngineConfigBuilder_.build();
      }
      result.engineMetadataCase_ = engineMetadataCase_;
      result.engineMetadata_ = this.engineMetadata_;
      if (engineMetadataCase_ == 12 && chatEngineMetadataBuilder_ != null) {
        result.engineMetadata_ = chatEngineMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.Engine) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.Engine) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Engine other) {
      if (other == com.google.cloud.discoveryengine.v1.Engine.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.dataStoreIds_.isEmpty()) {
        if (dataStoreIds_.isEmpty()) {
          dataStoreIds_ = other.dataStoreIds_;
          bitField0_ |= 0x00000100;
        } else {
          ensureDataStoreIdsIsMutable();
          dataStoreIds_.addAll(other.dataStoreIds_);
        }
        onChanged();
      }
      if (other.solutionType_ != 0) {
        setSolutionTypeValue(other.getSolutionTypeValue());
      }
      if (other.industryVertical_ != 0) {
        setIndustryVerticalValue(other.getIndustryVerticalValue());
      }
      if (other.hasCommonConfig()) {
        mergeCommonConfig(other.getCommonConfig());
      }
      if (other.getDisableAnalytics() != false) {
        setDisableAnalytics(other.getDisableAnalytics());
      }
      switch (other.getEngineConfigCase()) {
        case CHAT_ENGINE_CONFIG:
          {
            mergeChatEngineConfig(other.getChatEngineConfig());
            break;
          }
        case SEARCH_ENGINE_CONFIG:
          {
            mergeSearchEngineConfig(other.getSearchEngineConfig());
            break;
          }
        case MEDIA_RECOMMENDATION_ENGINE_CONFIG:
          {
            mergeMediaRecommendationEngineConfig(other.getMediaRecommendationEngineConfig());
            break;
          }
        case ENGINECONFIG_NOT_SET:
          {
            break;
          }
      }
      switch (other.getEngineMetadataCase()) {
        case CHAT_ENGINE_METADATA:
          {
            mergeChatEngineMetadata(other.getChatEngineMetadata());
            break;
          }
        case ENGINEMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDataStoreIdsIsMutable();
                dataStoreIds_.add(s);
                break;
              } // case 42
            case 48:
              {
                solutionType_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 48
            case 90:
              {
                input.readMessage(
                    getChatEngineConfigFieldBuilder().getBuilder(), extensionRegistry);
                engineConfigCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getChatEngineMetadataFieldBuilder().getBuilder(), extensionRegistry);
                engineMetadataCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getSearchEngineConfigFieldBuilder().getBuilder(), extensionRegistry);
                engineConfigCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getMediaRecommendationEngineConfigFieldBuilder().getBuilder(),
                    extensionRegistry);
                engineConfigCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getCommonConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 122
            case 128:
              {
                industryVertical_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 128
            case 208:
              {
                disableAnalytics_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 208
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int engineConfigCase_ = 0;
    private java.lang.Object engineConfig_;

    public EngineConfigCase getEngineConfigCase() {
      return EngineConfigCase.forNumber(engineConfigCase_);
    }

    public Builder clearEngineConfig() {
      engineConfigCase_ = 0;
      engineConfig_ = null;
      onChanged();
      return this;
    }

    private int engineMetadataCase_ = 0;
    private java.lang.Object engineMetadata_;

    public EngineMetadataCase getEngineMetadataCase() {
      return EngineMetadataCase.forNumber(engineMetadataCase_);
    }

    public Builder clearEngineMetadata() {
      engineMetadataCase_ = 0;
      engineMetadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfigOrBuilder>
        chatEngineConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     *
     * @return Whether the chatEngineConfig field is set.
     */
    @java.lang.Override
    public boolean hasChatEngineConfig() {
      return engineConfigCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     *
     * @return The chatEngineConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig getChatEngineConfig() {
      if (chatEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 11) {
          return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance();
      } else {
        if (engineConfigCase_ == 11) {
          return chatEngineConfigBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder setChatEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig value) {
      if (chatEngineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        engineConfig_ = value;
        onChanged();
      } else {
        chatEngineConfigBuilder_.setMessage(value);
      }
      engineConfigCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder setChatEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.Builder builderForValue) {
      if (chatEngineConfigBuilder_ == null) {
        engineConfig_ = builderForValue.build();
        onChanged();
      } else {
        chatEngineConfigBuilder_.setMessage(builderForValue.build());
      }
      engineConfigCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder mergeChatEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig value) {
      if (chatEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 11
            && engineConfig_
                != com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig
                    .getDefaultInstance()) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          engineConfig_ = value;
        }
        onChanged();
      } else {
        if (engineConfigCase_ == 11) {
          chatEngineConfigBuilder_.mergeFrom(value);
        } else {
          chatEngineConfigBuilder_.setMessage(value);
        }
      }
      engineConfigCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public Builder clearChatEngineConfig() {
      if (chatEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 11) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
          onChanged();
        }
      } else {
        if (engineConfigCase_ == 11) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
        }
        chatEngineConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.Builder
        getChatEngineConfigBuilder() {
      return getChatEngineConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfigOrBuilder
        getChatEngineConfigOrBuilder() {
      if ((engineConfigCase_ == 11) && (chatEngineConfigBuilder_ != null)) {
        return chatEngineConfigBuilder_.getMessageOrBuilder();
      } else {
        if (engineConfigCase_ == 11) {
          return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Chat Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig chat_engine_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfigOrBuilder>
        getChatEngineConfigFieldBuilder() {
      if (chatEngineConfigBuilder_ == null) {
        if (!(engineConfigCase_ == 11)) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.getDefaultInstance();
        }
        chatEngineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig,
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfigOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Engine.ChatEngineConfig) engineConfig_,
                getParentForChildren(),
                isClean());
        engineConfig_ = null;
      }
      engineConfigCase_ = 11;
      onChanged();
      return chatEngineConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig,
            com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfigOrBuilder>
        searchEngineConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     *
     * @return Whether the searchEngineConfig field is set.
     */
    @java.lang.Override
    public boolean hasSearchEngineConfig() {
      return engineConfigCase_ == 13;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     *
     * @return The searchEngineConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig getSearchEngineConfig() {
      if (searchEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 13) {
          return (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance();
      } else {
        if (engineConfigCase_ == 13) {
          return searchEngineConfigBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder setSearchEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig value) {
      if (searchEngineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        engineConfig_ = value;
        onChanged();
      } else {
        searchEngineConfigBuilder_.setMessage(value);
      }
      engineConfigCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder setSearchEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.Builder builderForValue) {
      if (searchEngineConfigBuilder_ == null) {
        engineConfig_ = builderForValue.build();
        onChanged();
      } else {
        searchEngineConfigBuilder_.setMessage(builderForValue.build());
      }
      engineConfigCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder mergeSearchEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig value) {
      if (searchEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 13
            && engineConfig_
                != com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig
                    .getDefaultInstance()) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          engineConfig_ = value;
        }
        onChanged();
      } else {
        if (engineConfigCase_ == 13) {
          searchEngineConfigBuilder_.mergeFrom(value);
        } else {
          searchEngineConfigBuilder_.setMessage(value);
        }
      }
      engineConfigCase_ = 13;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public Builder clearSearchEngineConfig() {
      if (searchEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 13) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
          onChanged();
        }
      } else {
        if (engineConfigCase_ == 13) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
        }
        searchEngineConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.Builder
        getSearchEngineConfigBuilder() {
      return getSearchEngineConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfigOrBuilder
        getSearchEngineConfigOrBuilder() {
      if ((engineConfigCase_ == 13) && (searchEngineConfigBuilder_ != null)) {
        return searchEngineConfigBuilder_.getMessageOrBuilder();
      } else {
        if (engineConfigCase_ == 13) {
          return (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Search Engine. Only applicable if
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig search_engine_config = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig,
            com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfigOrBuilder>
        getSearchEngineConfigFieldBuilder() {
      if (searchEngineConfigBuilder_ == null) {
        if (!(engineConfigCase_ == 13)) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.getDefaultInstance();
        }
        searchEngineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig,
                com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfigOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Engine.SearchEngineConfig) engineConfig_,
                getParentForChildren(),
                isClean());
        engineConfig_ = null;
      }
      engineConfigCase_ = 13;
      onChanged();
      return searchEngineConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig,
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfigOrBuilder>
        mediaRecommendationEngineConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     *
     * @return Whether the mediaRecommendationEngineConfig field is set.
     */
    @java.lang.Override
    public boolean hasMediaRecommendationEngineConfig() {
      return engineConfigCase_ == 14;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     *
     * @return The mediaRecommendationEngineConfig.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
        getMediaRecommendationEngineConfig() {
      if (mediaRecommendationEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 14) {
          return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
              engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .getDefaultInstance();
      } else {
        if (engineConfigCase_ == 14) {
          return mediaRecommendationEngineConfigBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     */
    public Builder setMediaRecommendationEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig value) {
      if (mediaRecommendationEngineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        engineConfig_ = value;
        onChanged();
      } else {
        mediaRecommendationEngineConfigBuilder_.setMessage(value);
      }
      engineConfigCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     */
    public Builder setMediaRecommendationEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.Builder
            builderForValue) {
      if (mediaRecommendationEngineConfigBuilder_ == null) {
        engineConfig_ = builderForValue.build();
        onChanged();
      } else {
        mediaRecommendationEngineConfigBuilder_.setMessage(builderForValue.build());
      }
      engineConfigCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     */
    public Builder mergeMediaRecommendationEngineConfig(
        com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig value) {
      if (mediaRecommendationEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 14
            && engineConfig_
                != com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                    .getDefaultInstance()) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
                          engineConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          engineConfig_ = value;
        }
        onChanged();
      } else {
        if (engineConfigCase_ == 14) {
          mediaRecommendationEngineConfigBuilder_.mergeFrom(value);
        } else {
          mediaRecommendationEngineConfigBuilder_.setMessage(value);
        }
      }
      engineConfigCase_ = 14;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     */
    public Builder clearMediaRecommendationEngineConfig() {
      if (mediaRecommendationEngineConfigBuilder_ == null) {
        if (engineConfigCase_ == 14) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
          onChanged();
        }
      } else {
        if (engineConfigCase_ == 14) {
          engineConfigCase_ = 0;
          engineConfig_ = null;
        }
        mediaRecommendationEngineConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.Builder
        getMediaRecommendationEngineConfigBuilder() {
      return getMediaRecommendationEngineConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfigOrBuilder
        getMediaRecommendationEngineConfigOrBuilder() {
      if ((engineConfigCase_ == 14) && (mediaRecommendationEngineConfigBuilder_ != null)) {
        return mediaRecommendationEngineConfigBuilder_.getMessageOrBuilder();
      } else {
        if (engineConfigCase_ == 14) {
          return (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
              engineConfig_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Configurations for the Media Engine. Only applicable on the data
     * stores with
     * [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * and
     * [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1.IndustryVertical.MEDIA]
     * vertical.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig media_recommendation_engine_config = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig,
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfigOrBuilder>
        getMediaRecommendationEngineConfigFieldBuilder() {
      if (mediaRecommendationEngineConfigBuilder_ == null) {
        if (!(engineConfigCase_ == 14)) {
          engineConfig_ =
              com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig
                  .getDefaultInstance();
        }
        mediaRecommendationEngineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig,
                com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine
                    .MediaRecommendationEngineConfigOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Engine.MediaRecommendationEngineConfig)
                    engineConfig_,
                getParentForChildren(),
                isClean());
        engineConfig_ = null;
      }
      engineConfigCase_ = 14;
      onChanged();
      return mediaRecommendationEngineConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.Builder,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadataOrBuilder>
        chatEngineMetadataBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the chatEngineMetadata field is set.
     */
    @java.lang.Override
    public boolean hasChatEngineMetadata() {
      return engineMetadataCase_ == 12;
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The chatEngineMetadata.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata getChatEngineMetadata() {
      if (chatEngineMetadataBuilder_ == null) {
        if (engineMetadataCase_ == 12) {
          return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) engineMetadata_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance();
      } else {
        if (engineMetadataCase_ == 12) {
          return chatEngineMetadataBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChatEngineMetadata(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata value) {
      if (chatEngineMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        engineMetadata_ = value;
        onChanged();
      } else {
        chatEngineMetadataBuilder_.setMessage(value);
      }
      engineMetadataCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChatEngineMetadata(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.Builder builderForValue) {
      if (chatEngineMetadataBuilder_ == null) {
        engineMetadata_ = builderForValue.build();
        onChanged();
      } else {
        chatEngineMetadataBuilder_.setMessage(builderForValue.build());
      }
      engineMetadataCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeChatEngineMetadata(
        com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata value) {
      if (chatEngineMetadataBuilder_ == null) {
        if (engineMetadataCase_ == 12
            && engineMetadata_
                != com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata
                    .getDefaultInstance()) {
          engineMetadata_ =
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.newBuilder(
                      (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata)
                          engineMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          engineMetadata_ = value;
        }
        onChanged();
      } else {
        if (engineMetadataCase_ == 12) {
          chatEngineMetadataBuilder_.mergeFrom(value);
        } else {
          chatEngineMetadataBuilder_.setMessage(value);
        }
      }
      engineMetadataCase_ = 12;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChatEngineMetadata() {
      if (chatEngineMetadataBuilder_ == null) {
        if (engineMetadataCase_ == 12) {
          engineMetadataCase_ = 0;
          engineMetadata_ = null;
          onChanged();
        }
      } else {
        if (engineMetadataCase_ == 12) {
          engineMetadataCase_ = 0;
          engineMetadata_ = null;
        }
        chatEngineMetadataBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.Builder
        getChatEngineMetadataBuilder() {
      return getChatEngineMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadataOrBuilder
        getChatEngineMetadataOrBuilder() {
      if ((engineMetadataCase_ == 12) && (chatEngineMetadataBuilder_ != null)) {
        return chatEngineMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (engineMetadataCase_ == 12) {
          return (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) engineMetadata_;
        }
        return com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Additional information of the Chat Engine. Only applicable
     * if [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type]
     * is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata chat_engine_metadata = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.Builder,
            com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadataOrBuilder>
        getChatEngineMetadataFieldBuilder() {
      if (chatEngineMetadataBuilder_ == null) {
        if (!(engineMetadataCase_ == 12)) {
          engineMetadata_ =
              com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.getDefaultInstance();
        }
        chatEngineMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata,
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata.Builder,
                com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadataOrBuilder>(
                (com.google.cloud.discoveryengine.v1.Engine.ChatEngineMetadata) engineMetadata_,
                getParentForChildren(),
                isClean());
        engineMetadata_ = null;
      }
      engineMetadataCase_ = 12;
      onChanged();
      return chatEngineMetadataBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Identifier. The fully qualified resource name of the engine.
     *
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     *
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * engine should be 1-63 characters, and valid characters are
     * /[a-z0-9][a-z0-9-_]*&#47;. Otherwise, an INVALID_ARGUMENT error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = IDENTIFIER];
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the engine. Should be human readable. UTF-8
     * encoded string with limit of 1024 characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was created at.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp the Recommendation Engine was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList dataStoreIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDataStoreIdsIsMutable() {
      if (!dataStoreIds_.isModifiable()) {
        dataStoreIds_ = new com.google.protobuf.LazyStringArrayList(dataStoreIds_);
      }
      bitField0_ |= 0x00000100;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the dataStoreIds.
     */
    public com.google.protobuf.ProtocolStringList getDataStoreIdsList() {
      dataStoreIds_.makeImmutable();
      return dataStoreIds_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of dataStoreIds.
     */
    public int getDataStoreIdsCount() {
      return dataStoreIds_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The dataStoreIds at the given index.
     */
    public java.lang.String getDataStoreIds(int index) {
      return dataStoreIds_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dataStoreIds at the given index.
     */
    public com.google.protobuf.ByteString getDataStoreIdsBytes(int index) {
      return dataStoreIds_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The dataStoreIds to set.
     * @return This builder for chaining.
     */
    public Builder setDataStoreIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDataStoreIdsIsMutable();
      dataStoreIds_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The dataStoreIds to add.
     * @return This builder for chaining.
     */
    public Builder addDataStoreIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDataStoreIdsIsMutable();
      dataStoreIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The dataStoreIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllDataStoreIds(java.lang.Iterable<java.lang.String> values) {
      ensureDataStoreIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataStoreIds_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataStoreIds() {
      dataStoreIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The data stores associated with this engine.
     *
     * For
     * [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_SEARCH]
     * and
     * [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
     * type of engines, they can only associate with at most one data store.
     *
     * If [solution_type][google.cloud.discoveryengine.v1.Engine.solution_type] is
     * [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1.SolutionType.SOLUTION_TYPE_CHAT],
     * multiple [DataStore][google.cloud.discoveryengine.v1.DataStore]s in the
     * same [Collection][google.cloud.discoveryengine.v1.Collection] can be
     * associated here.
     *
     * Note that when used in
     * [CreateEngineRequest][google.cloud.discoveryengine.v1.CreateEngineRequest],
     * one DataStore id must be provided as the system will use it for necessary
     * initializations.
     * </pre>
     *
     * <code>repeated string data_store_ids = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the dataStoreIds to add.
     * @return This builder for chaining.
     */
    public Builder addDataStoreIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDataStoreIdsIsMutable();
      dataStoreIds_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int solutionType_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for solutionType.
     */
    @java.lang.Override
    public int getSolutionTypeValue() {
      return solutionType_;
    }

    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionTypeValue(int value) {
      solutionType_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The solutionType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SolutionType getSolutionType() {
      com.google.cloud.discoveryengine.v1.SolutionType result =
          com.google.cloud.discoveryengine.v1.SolutionType.forNumber(solutionType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.SolutionType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The solutionType to set.
     * @return This builder for chaining.
     */
    public Builder setSolutionType(com.google.cloud.discoveryengine.v1.SolutionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      solutionType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The solutions of the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.SolutionType solution_type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSolutionType() {
      bitField0_ = (bitField0_ & ~0x00000200);
      solutionType_ = 0;
      onChanged();
      return this;
    }

    private int industryVertical_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]: Vertical on Engine
     * has to match vertical of the DataStore linked to the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for industryVertical.
     */
    @java.lang.Override
    public int getIndustryVerticalValue() {
      return industryVertical_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]: Vertical on Engine
     * has to match vertical of the DataStore linked to the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for industryVertical to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryVerticalValue(int value) {
      industryVertical_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]: Vertical on Engine
     * has to match vertical of the DataStore linked to the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The industryVertical.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IndustryVertical getIndustryVertical() {
      com.google.cloud.discoveryengine.v1.IndustryVertical result =
          com.google.cloud.discoveryengine.v1.IndustryVertical.forNumber(industryVertical_);
      return result == null
          ? com.google.cloud.discoveryengine.v1.IndustryVertical.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]: Vertical on Engine
     * has to match vertical of the DataStore linked to the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The industryVertical to set.
     * @return This builder for chaining.
     */
    public Builder setIndustryVertical(com.google.cloud.discoveryengine.v1.IndustryVertical value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      industryVertical_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The industry vertical that the engine registers.
     * The restriction of the Engine industry vertical is based on
     * [DataStore][google.cloud.discoveryengine.v1.DataStore]: Vertical on Engine
     * has to match vertical of the DataStore linked to the engine.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.IndustryVertical industry_vertical = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndustryVertical() {
      bitField0_ = (bitField0_ & ~0x00000400);
      industryVertical_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.Engine.CommonConfig commonConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.CommonConfig,
            com.google.cloud.discoveryengine.v1.Engine.CommonConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.CommonConfigOrBuilder>
        commonConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     *
     * @return Whether the commonConfig field is set.
     */
    public boolean hasCommonConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     *
     * @return The commonConfig.
     */
    public com.google.cloud.discoveryengine.v1.Engine.CommonConfig getCommonConfig() {
      if (commonConfigBuilder_ == null) {
        return commonConfig_ == null
            ? com.google.cloud.discoveryengine.v1.Engine.CommonConfig.getDefaultInstance()
            : commonConfig_;
      } else {
        return commonConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder setCommonConfig(com.google.cloud.discoveryengine.v1.Engine.CommonConfig value) {
      if (commonConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonConfig_ = value;
      } else {
        commonConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder setCommonConfig(
        com.google.cloud.discoveryengine.v1.Engine.CommonConfig.Builder builderForValue) {
      if (commonConfigBuilder_ == null) {
        commonConfig_ = builderForValue.build();
      } else {
        commonConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder mergeCommonConfig(
        com.google.cloud.discoveryengine.v1.Engine.CommonConfig value) {
      if (commonConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && commonConfig_ != null
            && commonConfig_
                != com.google.cloud.discoveryengine.v1.Engine.CommonConfig.getDefaultInstance()) {
          getCommonConfigBuilder().mergeFrom(value);
        } else {
          commonConfig_ = value;
        }
      } else {
        commonConfigBuilder_.mergeFrom(value);
      }
      if (commonConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     */
    public Builder clearCommonConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      commonConfig_ = null;
      if (commonConfigBuilder_ != null) {
        commonConfigBuilder_.dispose();
        commonConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     */
    public com.google.cloud.discoveryengine.v1.Engine.CommonConfig.Builder
        getCommonConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCommonConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     */
    public com.google.cloud.discoveryengine.v1.Engine.CommonConfigOrBuilder
        getCommonConfigOrBuilder() {
      if (commonConfigBuilder_ != null) {
        return commonConfigBuilder_.getMessageOrBuilder();
      } else {
        return commonConfig_ == null
            ? com.google.cloud.discoveryengine.v1.Engine.CommonConfig.getDefaultInstance()
            : commonConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Common config spec that specifies the metadata of the engine.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.Engine.CommonConfig common_config = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.Engine.CommonConfig,
            com.google.cloud.discoveryengine.v1.Engine.CommonConfig.Builder,
            com.google.cloud.discoveryengine.v1.Engine.CommonConfigOrBuilder>
        getCommonConfigFieldBuilder() {
      if (commonConfigBuilder_ == null) {
        commonConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.Engine.CommonConfig,
                com.google.cloud.discoveryengine.v1.Engine.CommonConfig.Builder,
                com.google.cloud.discoveryengine.v1.Engine.CommonConfigOrBuilder>(
                getCommonConfig(), getParentForChildren(), isClean());
        commonConfig_ = null;
      }
      return commonConfigBuilder_;
    }

    private boolean disableAnalytics_;

    /**
     *
     *
     * <pre>
     * Optional. Whether to disable analytics for searches performed on this
     * engine.
     * </pre>
     *
     * <code>bool disable_analytics = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableAnalytics.
     */
    @java.lang.Override
    public boolean getDisableAnalytics() {
      return disableAnalytics_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether to disable analytics for searches performed on this
     * engine.
     * </pre>
     *
     * <code>bool disable_analytics = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disableAnalytics to set.
     * @return This builder for chaining.
     */
    public Builder setDisableAnalytics(boolean value) {

      disableAnalytics_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether to disable analytics for searches performed on this
     * engine.
     * </pre>
     *
     * <code>bool disable_analytics = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableAnalytics() {
      bitField0_ = (bitField0_ & ~0x00001000);
      disableAnalytics_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Engine)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Engine)
  private static final com.google.cloud.discoveryengine.v1.Engine DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Engine();
  }

  public static com.google.cloud.discoveryengine.v1.Engine getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Engine> PARSER =
      new com.google.protobuf.AbstractParser<Engine>() {
        @java.lang.Override
        public Engine parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Engine> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Engine> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Engine getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
