/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/grounding.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Fact Chunk.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.FactChunk}
 */
public final class FactChunk extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.FactChunk)
    FactChunkOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FactChunk.newBuilder() to construct.
  private FactChunk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FactChunk() {
    chunkText_ = "";
    source_ = "";
    uri_ = "";
    title_ = "";
    domain_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FactChunk();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.GroundingProto
        .internal_static_google_cloud_discoveryengine_v1_FactChunk_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetSourceMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.GroundingProto
        .internal_static_google_cloud_discoveryengine_v1_FactChunk_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.FactChunk.class,
            com.google.cloud.discoveryengine.v1.FactChunk.Builder.class);
  }

  public static final int CHUNK_TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object chunkText_ = "";

  /**
   *
   *
   * <pre>
   * Text content of the fact chunk. Can be at most 10K characters long.
   * </pre>
   *
   * <code>string chunk_text = 1;</code>
   *
   * @return The chunkText.
   */
  @java.lang.Override
  public java.lang.String getChunkText() {
    java.lang.Object ref = chunkText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      chunkText_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Text content of the fact chunk. Can be at most 10K characters long.
   * </pre>
   *
   * <code>string chunk_text = 1;</code>
   *
   * @return The bytes for chunkText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getChunkTextBytes() {
    java.lang.Object ref = chunkText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      chunkText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object source_ = "";

  /**
   *
   *
   * <pre>
   * Source from which this fact chunk was retrieved. If it was retrieved
   * from the GroundingFacts provided in the request then this field will
   * contain the index of the specific fact from which this chunk was
   * retrieved.
   * </pre>
   *
   * <code>string source = 2;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public java.lang.String getSource() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      source_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Source from which this fact chunk was retrieved. If it was retrieved
   * from the GroundingFacts provided in the request then this field will
   * contain the index of the specific fact from which this chunk was
   * retrieved.
   * </pre>
   *
   * <code>string source = 2;</code>
   *
   * @return The bytes for source.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBytes() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      source_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_FIELD_NUMBER = 4;
  private int index_ = 0;

  /**
   *
   *
   * <pre>
   * The index of this chunk. Currently, only used for the streaming mode.
   * </pre>
   *
   * <code>int32 index = 4;</code>
   *
   * @return The index.
   */
  @java.lang.Override
  public int getIndex() {
    return index_;
  }

  public static final int SOURCE_METADATA_FIELD_NUMBER = 3;

  private static final class SourceMetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.discoveryengine.v1.GroundingProto
                .internal_static_google_cloud_discoveryengine_v1_FactChunk_SourceMetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> sourceMetadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetSourceMetadata() {
    if (sourceMetadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SourceMetadataDefaultEntryHolder.defaultEntry);
    }
    return sourceMetadata_;
  }

  public int getSourceMetadataCount() {
    return internalGetSourceMetadata().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * More fine-grained information for the source reference.
   * </pre>
   *
   * <code>map&lt;string, string&gt; source_metadata = 3;</code>
   */
  @java.lang.Override
  public boolean containsSourceMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSourceMetadata().getMap().containsKey(key);
  }

  /** Use {@link #getSourceMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getSourceMetadata() {
    return getSourceMetadataMap();
  }

  /**
   *
   *
   * <pre>
   * More fine-grained information for the source reference.
   * </pre>
   *
   * <code>map&lt;string, string&gt; source_metadata = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getSourceMetadataMap() {
    return internalGetSourceMetadata().getMap();
  }

  /**
   *
   *
   * <pre>
   * More fine-grained information for the source reference.
   * </pre>
   *
   * <code>map&lt;string, string&gt; source_metadata = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getSourceMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSourceMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * More fine-grained information for the source reference.
   * </pre>
   *
   * <code>map&lt;string, string&gt; source_metadata = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getSourceMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetSourceMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";

  /**
   *
   *
   * <pre>
   * The URI of the source.
   * </pre>
   *
   * <code>string uri = 5;</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URI of the source.
   * </pre>
   *
   * <code>string uri = 5;</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";

  /**
   *
   *
   * <pre>
   * The title of the source.
   * </pre>
   *
   * <code>string title = 6;</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The title of the source.
   * </pre>
   *
   * <code>string title = 6;</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domain_ = "";

  /**
   *
   *
   * <pre>
   * The domain of the source.
   * </pre>
   *
   * <code>string domain = 7;</code>
   *
   * @return The domain.
   */
  @java.lang.Override
  public java.lang.String getDomain() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domain_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The domain of the source.
   * </pre>
   *
   * <code>string domain = 7;</code>
   *
   * @return The bytes for domain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainBytes() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunkText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, chunkText_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, source_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetSourceMetadata(), SourceMetadataDefaultEntryHolder.defaultEntry, 3);
    if (index_ != 0) {
      output.writeInt32(4, index_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, domain_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(chunkText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, chunkText_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, source_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetSourceMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> sourceMetadata__ =
          SourceMetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, sourceMetadata__);
    }
    if (index_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, index_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, domain_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.FactChunk)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.FactChunk other =
        (com.google.cloud.discoveryengine.v1.FactChunk) obj;

    if (!getChunkText().equals(other.getChunkText())) return false;
    if (!getSource().equals(other.getSource())) return false;
    if (getIndex() != other.getIndex()) return false;
    if (!internalGetSourceMetadata().equals(other.internalGetSourceMetadata())) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getDomain().equals(other.getDomain())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CHUNK_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getChunkText().hashCode();
    hash = (37 * hash) + SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getSource().hashCode();
    hash = (37 * hash) + INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getIndex();
    if (!internalGetSourceMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + SOURCE_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSourceMetadata().hashCode();
    }
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
    hash = (53 * hash) + getDomain().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.FactChunk prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Fact Chunk.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.FactChunk}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.FactChunk)
      com.google.cloud.discoveryengine.v1.FactChunkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.GroundingProto
          .internal_static_google_cloud_discoveryengine_v1_FactChunk_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetSourceMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableSourceMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.GroundingProto
          .internal_static_google_cloud_discoveryengine_v1_FactChunk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.FactChunk.class,
              com.google.cloud.discoveryengine.v1.FactChunk.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.FactChunk.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      chunkText_ = "";
      source_ = "";
      index_ = 0;
      internalGetMutableSourceMetadata().clear();
      uri_ = "";
      title_ = "";
      domain_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.GroundingProto
          .internal_static_google_cloud_discoveryengine_v1_FactChunk_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FactChunk getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.FactChunk.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FactChunk build() {
      com.google.cloud.discoveryengine.v1.FactChunk result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FactChunk buildPartial() {
      com.google.cloud.discoveryengine.v1.FactChunk result =
          new com.google.cloud.discoveryengine.v1.FactChunk(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.FactChunk result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.chunkText_ = chunkText_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.source_ = source_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.index_ = index_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sourceMetadata_ = internalGetSourceMetadata();
        result.sourceMetadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.title_ = title_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.domain_ = domain_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.FactChunk) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.FactChunk) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.FactChunk other) {
      if (other == com.google.cloud.discoveryengine.v1.FactChunk.getDefaultInstance()) return this;
      if (!other.getChunkText().isEmpty()) {
        chunkText_ = other.chunkText_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSource().isEmpty()) {
        source_ = other.source_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getIndex() != 0) {
        setIndex(other.getIndex());
      }
      internalGetMutableSourceMetadata().mergeFrom(other.internalGetSourceMetadata());
      bitField0_ |= 0x00000008;
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getDomain().isEmpty()) {
        domain_ = other.domain_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                chunkText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                source_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> sourceMetadata__ =
                    input.readMessage(
                        SourceMetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableSourceMetadata()
                    .getMutableMap()
                    .put(sourceMetadata__.getKey(), sourceMetadata__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                index_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                domain_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object chunkText_ = "";

    /**
     *
     *
     * <pre>
     * Text content of the fact chunk. Can be at most 10K characters long.
     * </pre>
     *
     * <code>string chunk_text = 1;</code>
     *
     * @return The chunkText.
     */
    public java.lang.String getChunkText() {
      java.lang.Object ref = chunkText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        chunkText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Text content of the fact chunk. Can be at most 10K characters long.
     * </pre>
     *
     * <code>string chunk_text = 1;</code>
     *
     * @return The bytes for chunkText.
     */
    public com.google.protobuf.ByteString getChunkTextBytes() {
      java.lang.Object ref = chunkText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        chunkText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Text content of the fact chunk. Can be at most 10K characters long.
     * </pre>
     *
     * <code>string chunk_text = 1;</code>
     *
     * @param value The chunkText to set.
     * @return This builder for chaining.
     */
    public Builder setChunkText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      chunkText_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Text content of the fact chunk. Can be at most 10K characters long.
     * </pre>
     *
     * <code>string chunk_text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChunkText() {
      chunkText_ = getDefaultInstance().getChunkText();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Text content of the fact chunk. Can be at most 10K characters long.
     * </pre>
     *
     * <code>string chunk_text = 1;</code>
     *
     * @param value The bytes for chunkText to set.
     * @return This builder for chaining.
     */
    public Builder setChunkTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      chunkText_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object source_ = "";

    /**
     *
     *
     * <pre>
     * Source from which this fact chunk was retrieved. If it was retrieved
     * from the GroundingFacts provided in the request then this field will
     * contain the index of the specific fact from which this chunk was
     * retrieved.
     * </pre>
     *
     * <code>string source = 2;</code>
     *
     * @return The source.
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Source from which this fact chunk was retrieved. If it was retrieved
     * from the GroundingFacts provided in the request then this field will
     * contain the index of the specific fact from which this chunk was
     * retrieved.
     * </pre>
     *
     * <code>string source = 2;</code>
     *
     * @return The bytes for source.
     */
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Source from which this fact chunk was retrieved. If it was retrieved
     * from the GroundingFacts provided in the request then this field will
     * contain the index of the specific fact from which this chunk was
     * retrieved.
     * </pre>
     *
     * <code>string source = 2;</code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      source_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source from which this fact chunk was retrieved. If it was retrieved
     * from the GroundingFacts provided in the request then this field will
     * contain the index of the specific fact from which this chunk was
     * retrieved.
     * </pre>
     *
     * <code>string source = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      source_ = getDefaultInstance().getSource();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Source from which this fact chunk was retrieved. If it was retrieved
     * from the GroundingFacts provided in the request then this field will
     * contain the index of the specific fact from which this chunk was
     * retrieved.
     * </pre>
     *
     * <code>string source = 2;</code>
     *
     * @param value The bytes for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      source_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int index_;

    /**
     *
     *
     * <pre>
     * The index of this chunk. Currently, only used for the streaming mode.
     * </pre>
     *
     * <code>int32 index = 4;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }

    /**
     *
     *
     * <pre>
     * The index of this chunk. Currently, only used for the streaming mode.
     * </pre>
     *
     * <code>int32 index = 4;</code>
     *
     * @param value The index to set.
     * @return This builder for chaining.
     */
    public Builder setIndex(int value) {

      index_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The index of this chunk. Currently, only used for the streaming mode.
     * </pre>
     *
     * <code>int32 index = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIndex() {
      bitField0_ = (bitField0_ & ~0x00000004);
      index_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> sourceMetadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetSourceMetadata() {
      if (sourceMetadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SourceMetadataDefaultEntryHolder.defaultEntry);
      }
      return sourceMetadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableSourceMetadata() {
      if (sourceMetadata_ == null) {
        sourceMetadata_ =
            com.google.protobuf.MapField.newMapField(SourceMetadataDefaultEntryHolder.defaultEntry);
      }
      if (!sourceMetadata_.isMutable()) {
        sourceMetadata_ = sourceMetadata_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return sourceMetadata_;
    }

    public int getSourceMetadataCount() {
      return internalGetSourceMetadata().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * More fine-grained information for the source reference.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_metadata = 3;</code>
     */
    @java.lang.Override
    public boolean containsSourceMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSourceMetadata().getMap().containsKey(key);
    }

    /** Use {@link #getSourceMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSourceMetadata() {
      return getSourceMetadataMap();
    }

    /**
     *
     *
     * <pre>
     * More fine-grained information for the source reference.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_metadata = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getSourceMetadataMap() {
      return internalGetSourceMetadata().getMap();
    }

    /**
     *
     *
     * <pre>
     * More fine-grained information for the source reference.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_metadata = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getSourceMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSourceMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * More fine-grained information for the source reference.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_metadata = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getSourceMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSourceMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSourceMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableSourceMetadata().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * More fine-grained information for the source reference.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_metadata = 3;</code>
     */
    public Builder removeSourceMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSourceMetadata().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableSourceMetadata() {
      bitField0_ |= 0x00000008;
      return internalGetMutableSourceMetadata().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * More fine-grained information for the source reference.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_metadata = 3;</code>
     */
    public Builder putSourceMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSourceMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }

    /**
     *
     *
     * <pre>
     * More fine-grained information for the source reference.
     * </pre>
     *
     * <code>map&lt;string, string&gt; source_metadata = 3;</code>
     */
    public Builder putAllSourceMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableSourceMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object uri_ = "";

    /**
     *
     *
     * <pre>
     * The URI of the source.
     * </pre>
     *
     * <code>string uri = 5;</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI of the source.
     * </pre>
     *
     * <code>string uri = 5;</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URI of the source.
     * </pre>
     *
     * <code>string uri = 5;</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI of the source.
     * </pre>
     *
     * <code>string uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI of the source.
     * </pre>
     *
     * <code>string uri = 5;</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";

    /**
     *
     *
     * <pre>
     * The title of the source.
     * </pre>
     *
     * <code>string title = 6;</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The title of the source.
     * </pre>
     *
     * <code>string title = 6;</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The title of the source.
     * </pre>
     *
     * <code>string title = 6;</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The title of the source.
     * </pre>
     *
     * <code>string title = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The title of the source.
     * </pre>
     *
     * <code>string title = 6;</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object domain_ = "";

    /**
     *
     *
     * <pre>
     * The domain of the source.
     * </pre>
     *
     * <code>string domain = 7;</code>
     *
     * @return The domain.
     */
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The domain of the source.
     * </pre>
     *
     * <code>string domain = 7;</code>
     *
     * @return The bytes for domain.
     */
    public com.google.protobuf.ByteString getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The domain of the source.
     * </pre>
     *
     * <code>string domain = 7;</code>
     *
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domain_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The domain of the source.
     * </pre>
     *
     * <code>string domain = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomain() {
      domain_ = getDefaultInstance().getDomain();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The domain of the source.
     * </pre>
     *
     * <code>string domain = 7;</code>
     *
     * @param value The bytes for domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domain_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.FactChunk)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.FactChunk)
  private static final com.google.cloud.discoveryengine.v1.FactChunk DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.FactChunk();
  }

  public static com.google.cloud.discoveryengine.v1.FactChunk getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FactChunk> PARSER =
      new com.google.protobuf.AbstractParser<FactChunk>() {
        @java.lang.Override
        public FactChunk parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FactChunk> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FactChunk> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.FactChunk getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
