/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/site_search_engine_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [SiteSearchEngineService.FetchSitemaps][google.cloud.discoveryengine.v1.SiteSearchEngineService.FetchSitemaps]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.FetchSitemapsRequest}
 */
public final class FetchSitemapsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.FetchSitemapsRequest)
    FetchSitemapsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FetchSitemapsRequest.newBuilder() to construct.
  private FetchSitemapsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FetchSitemapsRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FetchSitemapsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
        .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.class,
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Builder.class);
  }

  public interface UrisMatcherOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @return A list containing the uris.
     */
    java.util.List<java.lang.String> getUrisList();

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @return The count of uris.
     */
    int getUrisCount();

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The uris at the given index.
     */
    java.lang.String getUris(int index);

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the uris at the given index.
     */
    com.google.protobuf.ByteString getUrisBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Matcher for the [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s by
   * their uris.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher}
   */
  public static final class UrisMatcher extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher)
      UrisMatcherOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use UrisMatcher.newBuilder() to construct.
    private UrisMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UrisMatcher() {
      uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UrisMatcher();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_UrisMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_UrisMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.class,
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.Builder.class);
    }

    public static final int URIS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList uris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @return A list containing the uris.
     */
    public com.google.protobuf.ProtocolStringList getUrisList() {
      return uris_;
    }

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @return The count of uris.
     */
    public int getUrisCount() {
      return uris_.size();
    }

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The uris at the given index.
     */
    public java.lang.String getUris(int index) {
      return uris_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
     * </pre>
     *
     * <code>repeated string uris = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the uris at the given index.
     */
    public com.google.protobuf.ByteString getUrisBytes(int index) {
      return uris_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < uris_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uris_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < uris_.size(); i++) {
          dataSize += computeStringSizeNoTag(uris_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getUrisList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher other =
          (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) obj;

      if (!getUrisList().equals(other.getUrisList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getUrisCount() > 0) {
        hash = (37 * hash) + URIS_FIELD_NUMBER;
        hash = (53 * hash) + getUrisList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Matcher for the [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s by
     * their uris.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher)
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcherOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_UrisMatcher_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_UrisMatcher_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.class,
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_UrisMatcher_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher build() {
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher buildPartial() {
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher result =
            new com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          uris_.makeImmutable();
          result.uris_ = uris_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher other) {
        if (other
            == com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
                .getDefaultInstance()) return this;
        if (!other.uris_.isEmpty()) {
          if (uris_.isEmpty()) {
            uris_ = other.uris_;
            bitField0_ |= 0x00000001;
          } else {
            ensureUrisIsMutable();
            uris_.addAll(other.uris_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureUrisIsMutable();
                  uris_.add(s);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList uris_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureUrisIsMutable() {
        if (!uris_.isModifiable()) {
          uris_ = new com.google.protobuf.LazyStringArrayList(uris_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @return A list containing the uris.
       */
      public com.google.protobuf.ProtocolStringList getUrisList() {
        uris_.makeImmutable();
        return uris_;
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @return The count of uris.
       */
      public int getUrisCount() {
        return uris_.size();
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The uris at the given index.
       */
      public java.lang.String getUris(int index) {
        return uris_.get(index);
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the uris at the given index.
       */
      public com.google.protobuf.ByteString getUrisBytes(int index) {
        return uris_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The uris to set.
       * @return This builder for chaining.
       */
      public Builder setUris(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUrisIsMutable();
        uris_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @param value The uris to add.
       * @return This builder for chaining.
       */
      public Builder addUris(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUrisIsMutable();
        uris_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @param values The uris to add.
       * @return This builder for chaining.
       */
      public Builder addAllUris(java.lang.Iterable<java.lang.String> values) {
        ensureUrisIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uris_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUris() {
        uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The [Sitemap][google.cloud.discoveryengine.v1.Sitemap] uris.
       * </pre>
       *
       * <code>repeated string uris = 1;</code>
       *
       * @param value The bytes of the uris to add.
       * @return This builder for chaining.
       */
      public Builder addUrisBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureUrisIsMutable();
        uris_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher)
    private static final com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher();
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UrisMatcher> PARSER =
        new com.google.protobuf.AbstractParser<UrisMatcher>() {
          @java.lang.Override
          public UrisMatcher parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UrisMatcher> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UrisMatcher> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MatcherOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Matcher by sitemap URIs.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
     * </code>
     *
     * @return Whether the urisMatcher field is set.
     */
    boolean hasUrisMatcher();

    /**
     *
     *
     * <pre>
     * Matcher by sitemap URIs.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
     * </code>
     *
     * @return The urisMatcher.
     */
    com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher getUrisMatcher();

    /**
     *
     *
     * <pre>
     * Matcher by sitemap URIs.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcherOrBuilder
        getUrisMatcherOrBuilder();

    com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.MatcherCase getMatcherCase();
  }

  /**
   *
   *
   * <pre>
   * Matcher for the [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s.
   * Currently only supports uris matcher.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher}
   */
  public static final class Matcher extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher)
      MatcherOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Matcher.newBuilder() to construct.
    private Matcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Matcher() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Matcher();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_Matcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_Matcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.class,
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.Builder.class);
    }

    private int matcherCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object matcher_;

    public enum MatcherCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      URIS_MATCHER(1),
      MATCHER_NOT_SET(0);
      private final int value;

      private MatcherCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MatcherCase valueOf(int value) {
        return forNumber(value);
      }

      public static MatcherCase forNumber(int value) {
        switch (value) {
          case 1:
            return URIS_MATCHER;
          case 0:
            return MATCHER_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public MatcherCase getMatcherCase() {
      return MatcherCase.forNumber(matcherCase_);
    }

    public static final int URIS_MATCHER_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Matcher by sitemap URIs.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
     * </code>
     *
     * @return Whether the urisMatcher field is set.
     */
    @java.lang.Override
    public boolean hasUrisMatcher() {
      return matcherCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Matcher by sitemap URIs.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
     * </code>
     *
     * @return The urisMatcher.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher getUrisMatcher() {
      if (matcherCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) matcher_;
      }
      return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Matcher by sitemap URIs.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcherOrBuilder
        getUrisMatcherOrBuilder() {
      if (matcherCase_ == 1) {
        return (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) matcher_;
      }
      return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (matcherCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) matcher_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (matcherCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) matcher_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher other =
          (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher) obj;

      if (!getMatcherCase().equals(other.getMatcherCase())) return false;
      switch (matcherCase_) {
        case 1:
          if (!getUrisMatcher().equals(other.getUrisMatcher())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (matcherCase_) {
        case 1:
          hash = (37 * hash) + URIS_MATCHER_FIELD_NUMBER;
          hash = (53 * hash) + getUrisMatcher().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Matcher for the [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s.
     * Currently only supports uris matcher.
     * </pre>
     *
     * Protobuf type {@code google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher)
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.MatcherOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_Matcher_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_Matcher_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.class,
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (urisMatcherBuilder_ != null) {
          urisMatcherBuilder_.clear();
        }
        matcherCase_ = 0;
        matcher_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
            .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_Matcher_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher build() {
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher buildPartial() {
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher result =
            new com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher result) {
        result.matcherCase_ = matcherCase_;
        result.matcher_ = this.matcher_;
        if (matcherCase_ == 1 && urisMatcherBuilder_ != null) {
          result.matcher_ = urisMatcherBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher other) {
        if (other
            == com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
                .getDefaultInstance()) return this;
        switch (other.getMatcherCase()) {
          case URIS_MATCHER:
            {
              mergeUrisMatcher(other.getUrisMatcher());
              break;
            }
          case MATCHER_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getUrisMatcherFieldBuilder().getBuilder(), extensionRegistry);
                  matcherCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int matcherCase_ = 0;
      private java.lang.Object matcher_;

      public MatcherCase getMatcherCase() {
        return MatcherCase.forNumber(matcherCase_);
      }

      public Builder clearMatcher() {
        matcherCase_ = 0;
        matcher_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher,
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.Builder,
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcherOrBuilder>
          urisMatcherBuilder_;

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       *
       * @return Whether the urisMatcher field is set.
       */
      @java.lang.Override
      public boolean hasUrisMatcher() {
        return matcherCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       *
       * @return The urisMatcher.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher getUrisMatcher() {
        if (urisMatcherBuilder_ == null) {
          if (matcherCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) matcher_;
          }
          return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
              .getDefaultInstance();
        } else {
          if (matcherCase_ == 1) {
            return urisMatcherBuilder_.getMessage();
          }
          return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       */
      public Builder setUrisMatcher(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher value) {
        if (urisMatcherBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          matcher_ = value;
          onChanged();
        } else {
          urisMatcherBuilder_.setMessage(value);
        }
        matcherCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       */
      public Builder setUrisMatcher(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.Builder
              builderForValue) {
        if (urisMatcherBuilder_ == null) {
          matcher_ = builderForValue.build();
          onChanged();
        } else {
          urisMatcherBuilder_.setMessage(builderForValue.build());
        }
        matcherCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       */
      public Builder mergeUrisMatcher(
          com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher value) {
        if (urisMatcherBuilder_ == null) {
          if (matcherCase_ == 1
              && matcher_
                  != com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
                      .getDefaultInstance()) {
            matcher_ =
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.newBuilder(
                        (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher)
                            matcher_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            matcher_ = value;
          }
          onChanged();
        } else {
          if (matcherCase_ == 1) {
            urisMatcherBuilder_.mergeFrom(value);
          } else {
            urisMatcherBuilder_.setMessage(value);
          }
        }
        matcherCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       */
      public Builder clearUrisMatcher() {
        if (urisMatcherBuilder_ == null) {
          if (matcherCase_ == 1) {
            matcherCase_ = 0;
            matcher_ = null;
            onChanged();
          }
        } else {
          if (matcherCase_ == 1) {
            matcherCase_ = 0;
            matcher_ = null;
          }
          urisMatcherBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.Builder
          getUrisMatcherBuilder() {
        return getUrisMatcherFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcherOrBuilder
          getUrisMatcherOrBuilder() {
        if ((matcherCase_ == 1) && (urisMatcherBuilder_ != null)) {
          return urisMatcherBuilder_.getMessageOrBuilder();
        } else {
          if (matcherCase_ == 1) {
            return (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) matcher_;
          }
          return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Matcher by sitemap URIs.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher uris_matcher = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher,
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.Builder,
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcherOrBuilder>
          getUrisMatcherFieldBuilder() {
        if (urisMatcherBuilder_ == null) {
          if (!(matcherCase_ == 1)) {
            matcher_ =
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher
                    .getDefaultInstance();
          }
          urisMatcherBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher,
                  com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher.Builder,
                  com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcherOrBuilder>(
                  (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.UrisMatcher) matcher_,
                  getParentForChildren(),
                  isClean());
          matcher_ = null;
        }
        matcherCase_ = 1;
        onChanged();
        return urisMatcherBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher)
    private static final com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher();
    }

    public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Matcher> PARSER =
        new com.google.protobuf.AbstractParser<Matcher>() {
          @java.lang.Override
          public Matcher parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Matcher> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Matcher> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Parent resource name of the
   * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
   * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Parent resource name of the
   * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
   * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MATCHER_FIELD_NUMBER = 2;
  private com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher_;

  /**
   *
   *
   * <pre>
   * Optional. If specified, fetches the matching
   * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
   * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
   * [DataStore][google.cloud.discoveryengine.v1.DataStore].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the matcher field is set.
   */
  @java.lang.Override
  public boolean hasMatcher() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If specified, fetches the matching
   * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
   * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
   * [DataStore][google.cloud.discoveryengine.v1.DataStore].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The matcher.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher getMatcher() {
    return matcher_ == null
        ? com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.getDefaultInstance()
        : matcher_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If specified, fetches the matching
   * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
   * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
   * [DataStore][google.cloud.discoveryengine.v1.DataStore].
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.MatcherOrBuilder
      getMatcherOrBuilder() {
    return matcher_ == null
        ? com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.getDefaultInstance()
        : matcher_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getMatcher());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMatcher());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.FetchSitemapsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.FetchSitemapsRequest other =
        (com.google.cloud.discoveryengine.v1.FetchSitemapsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasMatcher() != other.hasMatcher()) return false;
    if (hasMatcher()) {
      if (!getMatcher().equals(other.getMatcher())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasMatcher()) {
      hash = (37 * hash) + MATCHER_FIELD_NUMBER;
      hash = (53 * hash) + getMatcher().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.FetchSitemapsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [SiteSearchEngineService.FetchSitemaps][google.cloud.discoveryengine.v1.SiteSearchEngineService.FetchSitemaps]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.FetchSitemapsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.FetchSitemapsRequest)
      com.google.cloud.discoveryengine.v1.FetchSitemapsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.class,
              com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMatcherFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      matcher_ = null;
      if (matcherBuilder_ != null) {
        matcherBuilder_.dispose();
        matcherBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.SiteSearchEngineServiceProto
          .internal_static_google_cloud_discoveryengine_v1_FetchSitemapsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest build() {
      com.google.cloud.discoveryengine.v1.FetchSitemapsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.FetchSitemapsRequest result =
          new com.google.cloud.discoveryengine.v1.FetchSitemapsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.FetchSitemapsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.matcher_ = matcherBuilder_ == null ? matcher_ : matcherBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.FetchSitemapsRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.FetchSitemapsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.FetchSitemapsRequest other) {
      if (other == com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMatcher()) {
        mergeMatcher(other.getMatcher());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMatcherFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Parent resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Parent resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Parent resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Parent resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Parent resource name of the
     * [SiteSearchEngine][google.cloud.discoveryengine.v1.SiteSearchEngine], such
     * as `projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;&#47;siteSearchEngine`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher,
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.Builder,
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.MatcherOrBuilder>
        matcherBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the matcher field is set.
     */
    public boolean hasMatcher() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The matcher.
     */
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher getMatcher() {
      if (matcherBuilder_ == null) {
        return matcher_ == null
            ? com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.getDefaultInstance()
            : matcher_;
      } else {
        return matcherBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMatcher(
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher value) {
      if (matcherBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        matcher_ = value;
      } else {
        matcherBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMatcher(
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.Builder builderForValue) {
      if (matcherBuilder_ == null) {
        matcher_ = builderForValue.build();
      } else {
        matcherBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMatcher(
        com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher value) {
      if (matcherBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && matcher_ != null
            && matcher_
                != com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher
                    .getDefaultInstance()) {
          getMatcherBuilder().mergeFrom(value);
        } else {
          matcher_ = value;
        }
      } else {
        matcherBuilder_.mergeFrom(value);
      }
      if (matcher_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMatcher() {
      bitField0_ = (bitField0_ & ~0x00000002);
      matcher_ = null;
      if (matcherBuilder_ != null) {
        matcherBuilder_.dispose();
        matcherBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.Builder
        getMatcherBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMatcherFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.MatcherOrBuilder
        getMatcherOrBuilder() {
      if (matcherBuilder_ != null) {
        return matcherBuilder_.getMessageOrBuilder();
      } else {
        return matcher_ == null
            ? com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.getDefaultInstance()
            : matcher_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If specified, fetches the matching
     * [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s. If not specified,
     * fetches all [Sitemap][google.cloud.discoveryengine.v1.Sitemap]s in the
     * [DataStore][google.cloud.discoveryengine.v1.DataStore].
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher matcher = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher,
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.Builder,
            com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.MatcherOrBuilder>
        getMatcherFieldBuilder() {
      if (matcherBuilder_ == null) {
        matcherBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher,
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.Matcher.Builder,
                com.google.cloud.discoveryengine.v1.FetchSitemapsRequest.MatcherOrBuilder>(
                getMatcher(), getParentForChildren(), isClean());
        matcher_ = null;
      }
      return matcherBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.FetchSitemapsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.FetchSitemapsRequest)
  private static final com.google.cloud.discoveryengine.v1.FetchSitemapsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.FetchSitemapsRequest();
  }

  public static com.google.cloud.discoveryengine.v1.FetchSitemapsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FetchSitemapsRequest> PARSER =
      new com.google.protobuf.AbstractParser<FetchSitemapsRequest>() {
        @java.lang.Override
        public FetchSitemapsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FetchSitemapsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FetchSitemapsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.FetchSitemapsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
