/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/identity_mapping_store.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Identity Mapping Entry that maps an external identity to an internal
 * identity.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.IdentityMappingEntry}
 */
public final class IdentityMappingEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.IdentityMappingEntry)
    IdentityMappingEntryOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use IdentityMappingEntry.newBuilder() to construct.
  private IdentityMappingEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IdentityMappingEntry() {
    externalIdentity_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IdentityMappingEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
        .internal_static_google_cloud_discoveryengine_v1_IdentityMappingEntry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
        .internal_static_google_cloud_discoveryengine_v1_IdentityMappingEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.IdentityMappingEntry.class,
            com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder.class);
  }

  private int identityProviderIdCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object identityProviderId_;

  public enum IdentityProviderIdCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USER_ID(2),
    GROUP_ID(3),
    IDENTITYPROVIDERID_NOT_SET(0);
    private final int value;

    private IdentityProviderIdCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IdentityProviderIdCase valueOf(int value) {
      return forNumber(value);
    }

    public static IdentityProviderIdCase forNumber(int value) {
      switch (value) {
        case 2:
          return USER_ID;
        case 3:
          return GROUP_ID;
        case 0:
          return IDENTITYPROVIDERID_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IdentityProviderIdCase getIdentityProviderIdCase() {
    return IdentityProviderIdCase.forNumber(identityProviderIdCase_);
  }

  public static final int USER_ID_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * User identifier.
   * For Google Workspace user account, user_id should be the google workspace
   * user email.
   * For non-google identity provider, user_id is the mapped user identifier
   * configured during the workforcepool config.
   * </pre>
   *
   * <code>string user_id = 2;</code>
   *
   * @return Whether the userId field is set.
   */
  public boolean hasUserId() {
    return identityProviderIdCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * User identifier.
   * For Google Workspace user account, user_id should be the google workspace
   * user email.
   * For non-google identity provider, user_id is the mapped user identifier
   * configured during the workforcepool config.
   * </pre>
   *
   * <code>string user_id = 2;</code>
   *
   * @return The userId.
   */
  public java.lang.String getUserId() {
    java.lang.Object ref = "";
    if (identityProviderIdCase_ == 2) {
      ref = identityProviderId_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (identityProviderIdCase_ == 2) {
        identityProviderId_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * User identifier.
   * For Google Workspace user account, user_id should be the google workspace
   * user email.
   * For non-google identity provider, user_id is the mapped user identifier
   * configured during the workforcepool config.
   * </pre>
   *
   * <code>string user_id = 2;</code>
   *
   * @return The bytes for userId.
   */
  public com.google.protobuf.ByteString getUserIdBytes() {
    java.lang.Object ref = "";
    if (identityProviderIdCase_ == 2) {
      ref = identityProviderId_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (identityProviderIdCase_ == 2) {
        identityProviderId_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GROUP_ID_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Group identifier.
   * For Google Workspace user account, group_id should be the google
   * workspace group email.
   * For non-google identity provider, group_id is the mapped group identifier
   * configured during the workforcepool config.
   * </pre>
   *
   * <code>string group_id = 3;</code>
   *
   * @return Whether the groupId field is set.
   */
  public boolean hasGroupId() {
    return identityProviderIdCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Group identifier.
   * For Google Workspace user account, group_id should be the google
   * workspace group email.
   * For non-google identity provider, group_id is the mapped group identifier
   * configured during the workforcepool config.
   * </pre>
   *
   * <code>string group_id = 3;</code>
   *
   * @return The groupId.
   */
  public java.lang.String getGroupId() {
    java.lang.Object ref = "";
    if (identityProviderIdCase_ == 3) {
      ref = identityProviderId_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (identityProviderIdCase_ == 3) {
        identityProviderId_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Group identifier.
   * For Google Workspace user account, group_id should be the google
   * workspace group email.
   * For non-google identity provider, group_id is the mapped group identifier
   * configured during the workforcepool config.
   * </pre>
   *
   * <code>string group_id = 3;</code>
   *
   * @return The bytes for groupId.
   */
  public com.google.protobuf.ByteString getGroupIdBytes() {
    java.lang.Object ref = "";
    if (identityProviderIdCase_ == 3) {
      ref = identityProviderId_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (identityProviderIdCase_ == 3) {
        identityProviderId_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_IDENTITY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalIdentity_ = "";

  /**
   *
   *
   * <pre>
   * Required. Identity outside the customer identity provider.
   * The length limit of external identity will be of 100 characters.
   * </pre>
   *
   * <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The externalIdentity.
   */
  @java.lang.Override
  public java.lang.String getExternalIdentity() {
    java.lang.Object ref = externalIdentity_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalIdentity_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Identity outside the customer identity provider.
   * The length limit of external identity will be of 100 characters.
   * </pre>
   *
   * <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for externalIdentity.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalIdentityBytes() {
    java.lang.Object ref = externalIdentity_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalIdentity_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalIdentity_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, externalIdentity_);
    }
    if (identityProviderIdCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, identityProviderId_);
    }
    if (identityProviderIdCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, identityProviderId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalIdentity_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, externalIdentity_);
    }
    if (identityProviderIdCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, identityProviderId_);
    }
    if (identityProviderIdCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, identityProviderId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.IdentityMappingEntry)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.IdentityMappingEntry other =
        (com.google.cloud.discoveryengine.v1.IdentityMappingEntry) obj;

    if (!getExternalIdentity().equals(other.getExternalIdentity())) return false;
    if (!getIdentityProviderIdCase().equals(other.getIdentityProviderIdCase())) return false;
    switch (identityProviderIdCase_) {
      case 2:
        if (!getUserId().equals(other.getUserId())) return false;
        break;
      case 3:
        if (!getGroupId().equals(other.getGroupId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EXTERNAL_IDENTITY_FIELD_NUMBER;
    hash = (53 * hash) + getExternalIdentity().hashCode();
    switch (identityProviderIdCase_) {
      case 2:
        hash = (37 * hash) + USER_ID_FIELD_NUMBER;
        hash = (53 * hash) + getUserId().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GROUP_ID_FIELD_NUMBER;
        hash = (53 * hash) + getGroupId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.IdentityMappingEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Identity Mapping Entry that maps an external identity to an internal
   * identity.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.IdentityMappingEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.IdentityMappingEntry)
      com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
          .internal_static_google_cloud_discoveryengine_v1_IdentityMappingEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
          .internal_static_google_cloud_discoveryengine_v1_IdentityMappingEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.IdentityMappingEntry.class,
              com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.IdentityMappingEntry.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      externalIdentity_ = "";
      identityProviderIdCase_ = 0;
      identityProviderId_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
          .internal_static_google_cloud_discoveryengine_v1_IdentityMappingEntry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingEntry getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingEntry build() {
      com.google.cloud.discoveryengine.v1.IdentityMappingEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingEntry buildPartial() {
      com.google.cloud.discoveryengine.v1.IdentityMappingEntry result =
          new com.google.cloud.discoveryengine.v1.IdentityMappingEntry(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.IdentityMappingEntry result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.externalIdentity_ = externalIdentity_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1.IdentityMappingEntry result) {
      result.identityProviderIdCase_ = identityProviderIdCase_;
      result.identityProviderId_ = this.identityProviderId_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.IdentityMappingEntry) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.IdentityMappingEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.IdentityMappingEntry other) {
      if (other == com.google.cloud.discoveryengine.v1.IdentityMappingEntry.getDefaultInstance())
        return this;
      if (!other.getExternalIdentity().isEmpty()) {
        externalIdentity_ = other.externalIdentity_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getIdentityProviderIdCase()) {
        case USER_ID:
          {
            identityProviderIdCase_ = 2;
            identityProviderId_ = other.identityProviderId_;
            onChanged();
            break;
          }
        case GROUP_ID:
          {
            identityProviderIdCase_ = 3;
            identityProviderId_ = other.identityProviderId_;
            onChanged();
            break;
          }
        case IDENTITYPROVIDERID_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                externalIdentity_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                identityProviderIdCase_ = 2;
                identityProviderId_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                identityProviderIdCase_ = 3;
                identityProviderId_ = s;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int identityProviderIdCase_ = 0;
    private java.lang.Object identityProviderId_;

    public IdentityProviderIdCase getIdentityProviderIdCase() {
      return IdentityProviderIdCase.forNumber(identityProviderIdCase_);
    }

    public Builder clearIdentityProviderId() {
      identityProviderIdCase_ = 0;
      identityProviderId_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 2;</code>
     *
     * @return Whether the userId field is set.
     */
    @java.lang.Override
    public boolean hasUserId() {
      return identityProviderIdCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 2;</code>
     *
     * @return The userId.
     */
    @java.lang.Override
    public java.lang.String getUserId() {
      java.lang.Object ref = "";
      if (identityProviderIdCase_ == 2) {
        ref = identityProviderId_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (identityProviderIdCase_ == 2) {
          identityProviderId_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 2;</code>
     *
     * @return The bytes for userId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUserIdBytes() {
      java.lang.Object ref = "";
      if (identityProviderIdCase_ == 2) {
        ref = identityProviderId_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (identityProviderIdCase_ == 2) {
          identityProviderId_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 2;</code>
     *
     * @param value The userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      identityProviderIdCase_ = 2;
      identityProviderId_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserId() {
      if (identityProviderIdCase_ == 2) {
        identityProviderIdCase_ = 0;
        identityProviderId_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider, user_id is the mapped user identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 2;</code>
     *
     * @param value The bytes for userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      identityProviderIdCase_ = 2;
      identityProviderId_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 3;</code>
     *
     * @return Whether the groupId field is set.
     */
    @java.lang.Override
    public boolean hasGroupId() {
      return identityProviderIdCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 3;</code>
     *
     * @return The groupId.
     */
    @java.lang.Override
    public java.lang.String getGroupId() {
      java.lang.Object ref = "";
      if (identityProviderIdCase_ == 3) {
        ref = identityProviderId_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (identityProviderIdCase_ == 3) {
          identityProviderId_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 3;</code>
     *
     * @return The bytes for groupId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupIdBytes() {
      java.lang.Object ref = "";
      if (identityProviderIdCase_ == 3) {
        ref = identityProviderId_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (identityProviderIdCase_ == 3) {
          identityProviderId_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 3;</code>
     *
     * @param value The groupId to set.
     * @return This builder for chaining.
     */
    public Builder setGroupId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      identityProviderIdCase_ = 3;
      identityProviderId_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroupId() {
      if (identityProviderIdCase_ == 3) {
        identityProviderIdCase_ = 0;
        identityProviderId_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider, group_id is the mapped group identifier
     * configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 3;</code>
     *
     * @param value The bytes for groupId to set.
     * @return This builder for chaining.
     */
    public Builder setGroupIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      identityProviderIdCase_ = 3;
      identityProviderId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object externalIdentity_ = "";

    /**
     *
     *
     * <pre>
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     * </pre>
     *
     * <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The externalIdentity.
     */
    public java.lang.String getExternalIdentity() {
      java.lang.Object ref = externalIdentity_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalIdentity_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     * </pre>
     *
     * <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for externalIdentity.
     */
    public com.google.protobuf.ByteString getExternalIdentityBytes() {
      java.lang.Object ref = externalIdentity_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalIdentity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     * </pre>
     *
     * <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The externalIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIdentity(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalIdentity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     * </pre>
     *
     * <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalIdentity() {
      externalIdentity_ = getDefaultInstance().getExternalIdentity();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Identity outside the customer identity provider.
     * The length limit of external identity will be of 100 characters.
     * </pre>
     *
     * <code>string external_identity = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for externalIdentity to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIdentityBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalIdentity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.IdentityMappingEntry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.IdentityMappingEntry)
  private static final com.google.cloud.discoveryengine.v1.IdentityMappingEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.IdentityMappingEntry();
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IdentityMappingEntry> PARSER =
      new com.google.protobuf.AbstractParser<IdentityMappingEntry>() {
        @java.lang.Override
        public IdentityMappingEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IdentityMappingEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IdentityMappingEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.IdentityMappingEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
