/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/identity_mapping_store.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Identity Mapping Store which contains Identity Mapping Entries.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.IdentityMappingStore}
 */
public final class IdentityMappingStore extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.IdentityMappingStore)
    IdentityMappingStoreOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use IdentityMappingStore.newBuilder() to construct.
  private IdentityMappingStore(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IdentityMappingStore() {
    name_ = "";
    kmsKeyName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IdentityMappingStore();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
        .internal_static_google_cloud_discoveryengine_v1_IdentityMappingStore_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
        .internal_static_google_cloud_discoveryengine_v1_IdentityMappingStore_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.IdentityMappingStore.class,
            com.google.cloud.discoveryengine.v1.IdentityMappingStore.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the identity mapping store.
   * Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the identity mapping store.
   * Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";

  /**
   *
   *
   * <pre>
   * Input only. The KMS key to be used to protect this Identity Mapping Store
   * at creation time.
   *
   * Must be set for requests that need to comply with CMEK Org Policy
   * protections.
   *
   * If this field is set and processed successfully, the Identity Mapping Store
   * will be protected by the KMS key, as indicated in the cmek_config field.
   * </pre>
   *
   * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Input only. The KMS key to be used to protect this Identity Mapping Store
   * at creation time.
   *
   * Must be set for requests that need to comply with CMEK Org Policy
   * protections.
   *
   * If this field is set and processed successfully, the Identity Mapping Store
   * will be protected by the KMS key, as indicated in the cmek_config field.
   * </pre>
   *
   * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CMEK_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1.CmekConfig cmekConfig_;

  /**
   *
   *
   * <pre>
   * Output only. CMEK-related information for the Identity Mapping Store.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the cmekConfig field is set.
   */
  @java.lang.Override
  public boolean hasCmekConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. CMEK-related information for the Identity Mapping Store.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The cmekConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CmekConfig getCmekConfig() {
    return cmekConfig_ == null
        ? com.google.cloud.discoveryengine.v1.CmekConfig.getDefaultInstance()
        : cmekConfig_;
  }

  /**
   *
   *
   * <pre>
   * Output only. CMEK-related information for the Identity Mapping Store.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.CmekConfigOrBuilder getCmekConfigOrBuilder() {
    return cmekConfig_ == null
        ? com.google.cloud.discoveryengine.v1.CmekConfig.getDefaultInstance()
        : cmekConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, kmsKeyName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCmekConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, kmsKeyName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCmekConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.IdentityMappingStore)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.IdentityMappingStore other =
        (com.google.cloud.discoveryengine.v1.IdentityMappingStore) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (hasCmekConfig() != other.hasCmekConfig()) return false;
    if (hasCmekConfig()) {
      if (!getCmekConfig().equals(other.getCmekConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    if (hasCmekConfig()) {
      hash = (37 * hash) + CMEK_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getCmekConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.IdentityMappingStore prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Identity Mapping Store which contains Identity Mapping Entries.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.IdentityMappingStore}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.IdentityMappingStore)
      com.google.cloud.discoveryengine.v1.IdentityMappingStoreOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
          .internal_static_google_cloud_discoveryengine_v1_IdentityMappingStore_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
          .internal_static_google_cloud_discoveryengine_v1_IdentityMappingStore_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.IdentityMappingStore.class,
              com.google.cloud.discoveryengine.v1.IdentityMappingStore.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.IdentityMappingStore.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCmekConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      kmsKeyName_ = "";
      cmekConfig_ = null;
      if (cmekConfigBuilder_ != null) {
        cmekConfigBuilder_.dispose();
        cmekConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreProto
          .internal_static_google_cloud_discoveryengine_v1_IdentityMappingStore_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingStore getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStore.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingStore build() {
      com.google.cloud.discoveryengine.v1.IdentityMappingStore result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingStore buildPartial() {
      com.google.cloud.discoveryengine.v1.IdentityMappingStore result =
          new com.google.cloud.discoveryengine.v1.IdentityMappingStore(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.IdentityMappingStore result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.cmekConfig_ = cmekConfigBuilder_ == null ? cmekConfig_ : cmekConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.IdentityMappingStore) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.IdentityMappingStore) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.IdentityMappingStore other) {
      if (other == com.google.cloud.discoveryengine.v1.IdentityMappingStore.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCmekConfig()) {
        mergeCmekConfig(other.getCmekConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCmekConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the identity mapping store.
     * Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the identity mapping store.
     * Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the identity mapping store.
     * Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the identity mapping store.
     * Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The full resource name of the identity mapping store.
     * Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
     * This field must be a UTF-8 encoded string with a length limit of 1024
     * characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";

    /**
     *
     *
     * <pre>
     * Input only. The KMS key to be used to protect this Identity Mapping Store
     * at creation time.
     *
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     *
     * If this field is set and processed successfully, the Identity Mapping Store
     * will be protected by the KMS key, as indicated in the cmek_config field.
     * </pre>
     *
     * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. The KMS key to be used to protect this Identity Mapping Store
     * at creation time.
     *
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     *
     * If this field is set and processed successfully, the Identity Mapping Store
     * will be protected by the KMS key, as indicated in the cmek_config field.
     * </pre>
     *
     * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Input only. The KMS key to be used to protect this Identity Mapping Store
     * at creation time.
     *
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     *
     * If this field is set and processed successfully, the Identity Mapping Store
     * will be protected by the KMS key, as indicated in the cmek_config field.
     * </pre>
     *
     * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. The KMS key to be used to protect this Identity Mapping Store
     * at creation time.
     *
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     *
     * If this field is set and processed successfully, the Identity Mapping Store
     * will be protected by the KMS key, as indicated in the cmek_config field.
     * </pre>
     *
     * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. The KMS key to be used to protect this Identity Mapping Store
     * at creation time.
     *
     * Must be set for requests that need to comply with CMEK Org Policy
     * protections.
     *
     * If this field is set and processed successfully, the Identity Mapping Store
     * will be protected by the KMS key, as indicated in the cmek_config field.
     * </pre>
     *
     * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1.CmekConfig cmekConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.CmekConfig,
            com.google.cloud.discoveryengine.v1.CmekConfig.Builder,
            com.google.cloud.discoveryengine.v1.CmekConfigOrBuilder>
        cmekConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the cmekConfig field is set.
     */
    public boolean hasCmekConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The cmekConfig.
     */
    public com.google.cloud.discoveryengine.v1.CmekConfig getCmekConfig() {
      if (cmekConfigBuilder_ == null) {
        return cmekConfig_ == null
            ? com.google.cloud.discoveryengine.v1.CmekConfig.getDefaultInstance()
            : cmekConfig_;
      } else {
        return cmekConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCmekConfig(com.google.cloud.discoveryengine.v1.CmekConfig value) {
      if (cmekConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cmekConfig_ = value;
      } else {
        cmekConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCmekConfig(
        com.google.cloud.discoveryengine.v1.CmekConfig.Builder builderForValue) {
      if (cmekConfigBuilder_ == null) {
        cmekConfig_ = builderForValue.build();
      } else {
        cmekConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCmekConfig(com.google.cloud.discoveryengine.v1.CmekConfig value) {
      if (cmekConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && cmekConfig_ != null
            && cmekConfig_ != com.google.cloud.discoveryengine.v1.CmekConfig.getDefaultInstance()) {
          getCmekConfigBuilder().mergeFrom(value);
        } else {
          cmekConfig_ = value;
        }
      } else {
        cmekConfigBuilder_.mergeFrom(value);
      }
      if (cmekConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCmekConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      cmekConfig_ = null;
      if (cmekConfigBuilder_ != null) {
        cmekConfigBuilder_.dispose();
        cmekConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CmekConfig.Builder getCmekConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCmekConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.CmekConfigOrBuilder getCmekConfigOrBuilder() {
      if (cmekConfigBuilder_ != null) {
        return cmekConfigBuilder_.getMessageOrBuilder();
      } else {
        return cmekConfig_ == null
            ? com.google.cloud.discoveryengine.v1.CmekConfig.getDefaultInstance()
            : cmekConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. CMEK-related information for the Identity Mapping Store.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.CmekConfig,
            com.google.cloud.discoveryengine.v1.CmekConfig.Builder,
            com.google.cloud.discoveryengine.v1.CmekConfigOrBuilder>
        getCmekConfigFieldBuilder() {
      if (cmekConfigBuilder_ == null) {
        cmekConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.CmekConfig,
                com.google.cloud.discoveryengine.v1.CmekConfig.Builder,
                com.google.cloud.discoveryengine.v1.CmekConfigOrBuilder>(
                getCmekConfig(), getParentForChildren(), isClean());
        cmekConfig_ = null;
      }
      return cmekConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.IdentityMappingStore)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.IdentityMappingStore)
  private static final com.google.cloud.discoveryengine.v1.IdentityMappingStore DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.IdentityMappingStore();
  }

  public static com.google.cloud.discoveryengine.v1.IdentityMappingStore getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IdentityMappingStore> PARSER =
      new com.google.protobuf.AbstractParser<IdentityMappingStore>() {
        @java.lang.Override
        public IdentityMappingStore parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IdentityMappingStore> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IdentityMappingStore> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.IdentityMappingStore getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
