/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/identity_mapping_store.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

public interface IdentityMappingStoreOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.IdentityMappingStore)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the identity mapping store.
   * Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Immutable. The full resource name of the identity mapping store.
   * Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identity_mapping_store}`.
   * This field must be a UTF-8 encoded string with a length limit of 1024
   * characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Input only. The KMS key to be used to protect this Identity Mapping Store
   * at creation time.
   *
   * Must be set for requests that need to comply with CMEK Org Policy
   * protections.
   *
   * If this field is set and processed successfully, the Identity Mapping Store
   * will be protected by the KMS key, as indicated in the cmek_config field.
   * </pre>
   *
   * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The kmsKeyName.
   */
  java.lang.String getKmsKeyName();

  /**
   *
   *
   * <pre>
   * Input only. The KMS key to be used to protect this Identity Mapping Store
   * at creation time.
   *
   * Must be set for requests that need to comply with CMEK Org Policy
   * protections.
   *
   * If this field is set and processed successfully, the Identity Mapping Store
   * will be protected by the KMS key, as indicated in the cmek_config field.
   * </pre>
   *
   * <code>string kms_key_name = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for kmsKeyName.
   */
  com.google.protobuf.ByteString getKmsKeyNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. CMEK-related information for the Identity Mapping Store.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the cmekConfig field is set.
   */
  boolean hasCmekConfig();

  /**
   *
   *
   * <pre>
   * Output only. CMEK-related information for the Identity Mapping Store.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The cmekConfig.
   */
  com.google.cloud.discoveryengine.v1.CmekConfig getCmekConfig();

  /**
   *
   *
   * <pre>
   * Output only. CMEK-related information for the Identity Mapping Store.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.CmekConfig cmek_config = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.discoveryengine.v1.CmekConfigOrBuilder getCmekConfigOrBuilder();
}
