/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/import_config.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [CompletionService.ImportSuggestionDenyListEntries][google.cloud.discoveryengine.v1.CompletionService.ImportSuggestionDenyListEntries]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest}
 */
public final class ImportSuggestionDenyListEntriesRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest)
    ImportSuggestionDenyListEntriesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ImportSuggestionDenyListEntriesRequest.newBuilder() to construct.
  private ImportSuggestionDenyListEntriesRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportSuggestionDenyListEntriesRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportSuggestionDenyListEntriesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.class,
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.Builder
                .class);
  }

  public interface InlineSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry> getEntriesList();

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry getEntries(int index);

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getEntriesCount();

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder>
        getEntriesOrBuilderList();

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder getEntriesOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * The inline source for SuggestionDenyListEntry.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource}
   */
  public static final class InlineSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource)
      InlineSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use InlineSource.newBuilder() to construct.
    private InlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InlineSource() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InlineSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_InlineSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_InlineSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                  .InlineSource.class,
              com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                  .InlineSource.Builder.class);
    }

    public static final int ENTRIES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry> entries_;

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry>
        getEntriesList() {
      return entries_;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder>
        getEntriesOrBuilderList() {
      return entries_;
    }

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry getEntries(int index) {
      return entries_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Required. A list of all denylist entries to import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder getEntriesOrBuilder(
        int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(1, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < entries_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
              .InlineSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
          other =
              (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                      .InlineSource)
                  obj;

      if (!getEntriesList().equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The inline source for SuggestionDenyListEntry.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource)
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_InlineSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                    .InlineSource.class,
                com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                    .InlineSource.Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
          build() {
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
            result =
                new com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                    .InlineSource(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
              result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
              result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                .InlineSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                      .InlineSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
              other) {
        if (other
            == com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                .InlineSource.getDefaultInstance()) return this;
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000001);
              entriesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEntriesFieldBuilder()
                      : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.parser(),
                          extensionRegistry);
                  if (entriesBuilder_ == null) {
                    ensureEntriesIsMutable();
                    entries_.add(m);
                  } else {
                    entriesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry> entries_ =
          java.util.Collections.emptyList();

      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          entries_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry>(
                  entries_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry,
              com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder,
              com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder>
          entriesBuilder_;

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry>
          getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry getEntries(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEntries(
          int index, com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setEntries(
          int index,
          com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEntries(com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEntries(
          int index, com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEntries(
          com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addEntries(
          int index,
          com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry>
              values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder getEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder
          getEntriesOrBuilder(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder>
          getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder
          addEntriesBuilder() {
        return getEntriesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder addEntriesBuilder(
          int index) {
        return getEntriesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Required. A list of all denylist entries to import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.SuggestionDenyListEntry entries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder>
          getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry,
              com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder,
              com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder>
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry,
                  com.google.cloud.discoveryengine.v1.SuggestionDenyListEntry.Builder,
                  com.google.cloud.discoveryengine.v1.SuggestionDenyListEntryOrBuilder>(
                  entries_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource)
    private static final com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
              .InlineSource();
    }

    public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InlineSource> PARSER =
        new com.google.protobuf.AbstractParser<InlineSource>() {
          @java.lang.Override
          public InlineSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InlineSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InlineSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_SOURCE(2),
    GCS_SOURCE(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return INLINE_SOURCE;
        case 3:
          return GCS_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_SOURCE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * The Inline source for the input content for suggestion deny list entries.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return Whether the inlineSource field is set.
   */
  @java.lang.Override
  public boolean hasInlineSource() {
    return sourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * The Inline source for the input content for suggestion deny list entries.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return The inlineSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
      getInlineSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
              .InlineSource)
          source_;
    }
    return com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The Inline source for the input content for suggestion deny list entries.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
          .InlineSourceOrBuilder
      getInlineSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
              .InlineSource)
          source_;
    }
    return com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
        .getDefaultInstance();
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   *
   * Only 1 file can be specified that contains all entries to import.
   * Supported values `gcs_source.schema` for autocomplete suggestion deny
   * list entry imports:
   *
   * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
   * per line.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   *
   * Only 1 file can be specified that contains all entries to import.
   * Supported values `gcs_source.schema` for autocomplete suggestion deny
   * list entry imports:
   *
   * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
   * per line.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GcsSource getGcsSource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1.GcsSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   *
   * Only 1 file can be specified that contains all entries to import.
   * Supported values `gcs_source.schema` for autocomplete suggestion deny
   * list entry imports:
   *
   * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
   * per line.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1.GcsSource.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The parent data store resource name for which to import denylist
   * entries. Follows pattern projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The parent data store resource name for which to import denylist
   * entries. Follows pattern projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource)
              source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.discoveryengine.v1.GcsSource) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                      .InlineSource)
                  source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.discoveryengine.v1.GcsSource) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest other =
        (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getInlineSource().equals(other.getInlineSource())) return false;
        break;
      case 3:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [CompletionService.ImportSuggestionDenyListEntries][google.cloud.discoveryengine.v1.CompletionService.ImportSuggestionDenyListEntries]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest)
      com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.class,
              com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineSourceBuilder_ != null) {
        inlineSourceBuilder_.clear();
      }
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      parent_ = "";
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1_ImportSuggestionDenyListEntriesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest build() {
      com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
        buildPartial() {
      com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest result =
          new com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parent_ = parent_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && inlineSourceBuilder_ != null) {
        result.source_ = inlineSourceBuilder_.build();
      }
      if (sourceCase_ == 3 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case INLINE_SOURCE:
          {
            mergeInlineSource(other.getInlineSource());
            break;
          }
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource,
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
                .Builder,
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                .InlineSourceOrBuilder>
        inlineSourceBuilder_;

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
        getInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                  .InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return inlineSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
            value) {
      if (inlineSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
                .Builder
            builderForValue) {
      if (inlineSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder mergeInlineSource(
        com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
            value) {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                    .InlineSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                  .InlineSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                              .InlineSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          inlineSourceBuilder_.mergeFrom(value);
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder clearInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
            .Builder
        getInlineSourceBuilder() {
      return getInlineSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if ((sourceCase_ == 2) && (inlineSourceBuilder_ != null)) {
        return inlineSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                  .InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
            .InlineSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Inline source for the input content for suggestion deny list entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource,
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest.InlineSource
                .Builder,
            com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                .InlineSourceOrBuilder>
        getInlineSourceFieldBuilder() {
      if (inlineSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                  .InlineSource.getDefaultInstance();
        }
        inlineSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                    .InlineSource,
                com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                    .InlineSource.Builder,
                com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                    .InlineSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
                        .InlineSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return inlineSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GcsSource,
            com.google.cloud.discoveryengine.v1.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1.GcsSourceOrBuilder>
        gcsSourceBuilder_;

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1.GcsSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(com.google.cloud.discoveryengine.v1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.discoveryengine.v1.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.discoveryengine.v1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.cloud.discoveryengine.v1.GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1.GcsSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1.GcsSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 3) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1.GcsSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     *
     * Only 1 file can be specified that contains all entries to import.
     * Supported values `gcs_source.schema` for autocomplete suggestion deny
     * list entry imports:
     *
     * * `suggestion_deny_list` (default): One JSON [SuggestionDenyListEntry]
     * per line.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1.GcsSource gcs_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.GcsSource,
            com.google.cloud.discoveryengine.v1.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.discoveryengine.v1.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.GcsSource,
                com.google.cloud.discoveryengine.v1.GcsSource.Builder,
                com.google.cloud.discoveryengine.v1.GcsSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1.GcsSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return gcsSourceBuilder_;
    }

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which to import denylist
     * entries. Follows pattern projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which to import denylist
     * entries. Follows pattern projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which to import denylist
     * entries. Follows pattern projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which to import denylist
     * entries. Follows pattern projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent data store resource name for which to import denylist
     * entries. Follows pattern projects/&#42;&#47;locations/&#42;&#47;collections/&#42;&#47;dataStores/&#42;.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest)
  private static final com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest();
  }

  public static com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportSuggestionDenyListEntriesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportSuggestionDenyListEntriesRequest>() {
        @java.lang.Override
        public ImportSuggestionDenyListEntriesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportSuggestionDenyListEntriesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportSuggestionDenyListEntriesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.ImportSuggestionDenyListEntriesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
