/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/user_license_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

public interface ListUserLicensesRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.ListUserLicensesRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The parent [UserStore][] resource name, format:
   * `projects/{project}/locations/{location}/userStores/{user_store_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The parent [UserStore][] resource name, format:
   * `projects/{project}/locations/{location}/userStores/{user_store_id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional. Requested page size. Server may return fewer items than
   * requested. If unspecified, defaults to 10. The maximum value is 50; values
   * above 50 will be coerced to 50.
   *
   * If this field is negative, an INVALID_ARGUMENT error is returned.
   * </pre>
   *
   * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous `ListUserLicenses` call.
   * Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to `ListUserLicenses`
   * must match the call that provided the page token.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();

  /**
   *
   *
   * <pre>
   * Optional. A page token, received from a previous `ListUserLicenses` call.
   * Provide this to retrieve the subsequent page.
   *
   * When paginating, all other parameters provided to `ListUserLicenses`
   * must match the call that provided the page token.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional. Filter for the list request.
   *
   * Supported fields:
   *
   * * `license_assignment_state`
   *
   * Examples:
   *
   * * `license_assignment_state = ASSIGNED` to list assigned user licenses.
   * * `license_assignment_state = NO_LICENSE` to list not licensed users.
   * * `license_assignment_state = NO_LICENSE_ATTEMPTED_LOGIN` to list users
   * who attempted login but no license assigned.
   * * `license_assignment_state != NO_LICENSE_ATTEMPTED_LOGIN` to filter
   * out users who attempted login but no license assigned.
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();

  /**
   *
   *
   * <pre>
   * Optional. Filter for the list request.
   *
   * Supported fields:
   *
   * * `license_assignment_state`
   *
   * Examples:
   *
   * * `license_assignment_state = ASSIGNED` to list assigned user licenses.
   * * `license_assignment_state = NO_LICENSE` to list not licensed users.
   * * `license_assignment_state = NO_LICENSE_ATTEMPTED_LOGIN` to list users
   * who attempted login but no license assigned.
   * * `license_assignment_state != NO_LICENSE_ATTEMPTED_LOGIN` to filter
   * out users who attempted login but no license assigned.
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();
}
