/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/common.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Principal identifier of a user or a group.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.Principal}
 */
public final class Principal extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.Principal)
    PrincipalOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Principal.newBuilder() to construct.
  private Principal(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Principal() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Principal();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.CommonProto
        .internal_static_google_cloud_discoveryengine_v1_Principal_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.CommonProto
        .internal_static_google_cloud_discoveryengine_v1_Principal_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.Principal.class,
            com.google.cloud.discoveryengine.v1.Principal.Builder.class);
  }

  private int principalCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object principal_;

  public enum PrincipalCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    USER_ID(1),
    GROUP_ID(2),
    EXTERNAL_ENTITY_ID(3),
    PRINCIPAL_NOT_SET(0);
    private final int value;

    private PrincipalCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PrincipalCase valueOf(int value) {
      return forNumber(value);
    }

    public static PrincipalCase forNumber(int value) {
      switch (value) {
        case 1:
          return USER_ID;
        case 2:
          return GROUP_ID;
        case 3:
          return EXTERNAL_ENTITY_ID;
        case 0:
          return PRINCIPAL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PrincipalCase getPrincipalCase() {
    return PrincipalCase.forNumber(principalCase_);
  }

  public static final int USER_ID_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * User identifier.
   * For Google Workspace user account, user_id should be the google workspace
   * user email.
   * For non-google identity provider user account, user_id is the mapped user
   * identifier configured during the workforcepool config.
   * </pre>
   *
   * <code>string user_id = 1;</code>
   *
   * @return Whether the userId field is set.
   */
  public boolean hasUserId() {
    return principalCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * User identifier.
   * For Google Workspace user account, user_id should be the google workspace
   * user email.
   * For non-google identity provider user account, user_id is the mapped user
   * identifier configured during the workforcepool config.
   * </pre>
   *
   * <code>string user_id = 1;</code>
   *
   * @return The userId.
   */
  public java.lang.String getUserId() {
    java.lang.Object ref = "";
    if (principalCase_ == 1) {
      ref = principal_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (principalCase_ == 1) {
        principal_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * User identifier.
   * For Google Workspace user account, user_id should be the google workspace
   * user email.
   * For non-google identity provider user account, user_id is the mapped user
   * identifier configured during the workforcepool config.
   * </pre>
   *
   * <code>string user_id = 1;</code>
   *
   * @return The bytes for userId.
   */
  public com.google.protobuf.ByteString getUserIdBytes() {
    java.lang.Object ref = "";
    if (principalCase_ == 1) {
      ref = principal_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (principalCase_ == 1) {
        principal_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GROUP_ID_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Group identifier.
   * For Google Workspace user account, group_id should be the google
   * workspace group email.
   * For non-google identity provider user account, group_id is the mapped
   * group identifier configured during the workforcepool config.
   * </pre>
   *
   * <code>string group_id = 2;</code>
   *
   * @return Whether the groupId field is set.
   */
  public boolean hasGroupId() {
    return principalCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Group identifier.
   * For Google Workspace user account, group_id should be the google
   * workspace group email.
   * For non-google identity provider user account, group_id is the mapped
   * group identifier configured during the workforcepool config.
   * </pre>
   *
   * <code>string group_id = 2;</code>
   *
   * @return The groupId.
   */
  public java.lang.String getGroupId() {
    java.lang.Object ref = "";
    if (principalCase_ == 2) {
      ref = principal_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (principalCase_ == 2) {
        principal_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Group identifier.
   * For Google Workspace user account, group_id should be the google
   * workspace group email.
   * For non-google identity provider user account, group_id is the mapped
   * group identifier configured during the workforcepool config.
   * </pre>
   *
   * <code>string group_id = 2;</code>
   *
   * @return The bytes for groupId.
   */
  public com.google.protobuf.ByteString getGroupIdBytes() {
    java.lang.Object ref = "";
    if (principalCase_ == 2) {
      ref = principal_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (principalCase_ == 2) {
        principal_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_ENTITY_ID_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * For 3P application identities which are not present in the customer
   * identity provider.
   * </pre>
   *
   * <code>string external_entity_id = 3;</code>
   *
   * @return Whether the externalEntityId field is set.
   */
  public boolean hasExternalEntityId() {
    return principalCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * For 3P application identities which are not present in the customer
   * identity provider.
   * </pre>
   *
   * <code>string external_entity_id = 3;</code>
   *
   * @return The externalEntityId.
   */
  public java.lang.String getExternalEntityId() {
    java.lang.Object ref = "";
    if (principalCase_ == 3) {
      ref = principal_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (principalCase_ == 3) {
        principal_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * For 3P application identities which are not present in the customer
   * identity provider.
   * </pre>
   *
   * <code>string external_entity_id = 3;</code>
   *
   * @return The bytes for externalEntityId.
   */
  public com.google.protobuf.ByteString getExternalEntityIdBytes() {
    java.lang.Object ref = "";
    if (principalCase_ == 3) {
      ref = principal_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (principalCase_ == 3) {
        principal_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (principalCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principal_);
    }
    if (principalCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, principal_);
    }
    if (principalCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, principal_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (principalCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principal_);
    }
    if (principalCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, principal_);
    }
    if (principalCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, principal_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.Principal)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.Principal other =
        (com.google.cloud.discoveryengine.v1.Principal) obj;

    if (!getPrincipalCase().equals(other.getPrincipalCase())) return false;
    switch (principalCase_) {
      case 1:
        if (!getUserId().equals(other.getUserId())) return false;
        break;
      case 2:
        if (!getGroupId().equals(other.getGroupId())) return false;
        break;
      case 3:
        if (!getExternalEntityId().equals(other.getExternalEntityId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (principalCase_) {
      case 1:
        hash = (37 * hash) + USER_ID_FIELD_NUMBER;
        hash = (53 * hash) + getUserId().hashCode();
        break;
      case 2:
        hash = (37 * hash) + GROUP_ID_FIELD_NUMBER;
        hash = (53 * hash) + getGroupId().hashCode();
        break;
      case 3:
        hash = (37 * hash) + EXTERNAL_ENTITY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getExternalEntityId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.Principal parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.discoveryengine.v1.Principal prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Principal identifier of a user or a group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.Principal}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.Principal)
      com.google.cloud.discoveryengine.v1.PrincipalOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.CommonProto
          .internal_static_google_cloud_discoveryengine_v1_Principal_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.CommonProto
          .internal_static_google_cloud_discoveryengine_v1_Principal_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.Principal.class,
              com.google.cloud.discoveryengine.v1.Principal.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.Principal.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      principalCase_ = 0;
      principal_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.CommonProto
          .internal_static_google_cloud_discoveryengine_v1_Principal_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Principal getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.Principal.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Principal build() {
      com.google.cloud.discoveryengine.v1.Principal result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.Principal buildPartial() {
      com.google.cloud.discoveryengine.v1.Principal result =
          new com.google.cloud.discoveryengine.v1.Principal(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1.Principal result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.discoveryengine.v1.Principal result) {
      result.principalCase_ = principalCase_;
      result.principal_ = this.principal_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.Principal) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.Principal) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1.Principal other) {
      if (other == com.google.cloud.discoveryengine.v1.Principal.getDefaultInstance()) return this;
      switch (other.getPrincipalCase()) {
        case USER_ID:
          {
            principalCase_ = 1;
            principal_ = other.principal_;
            onChanged();
            break;
          }
        case GROUP_ID:
          {
            principalCase_ = 2;
            principal_ = other.principal_;
            onChanged();
            break;
          }
        case EXTERNAL_ENTITY_ID:
          {
            principalCase_ = 3;
            principal_ = other.principal_;
            onChanged();
            break;
          }
        case PRINCIPAL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                principalCase_ = 1;
                principal_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                principalCase_ = 2;
                principal_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                principalCase_ = 3;
                principal_ = s;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int principalCase_ = 0;
    private java.lang.Object principal_;

    public PrincipalCase getPrincipalCase() {
      return PrincipalCase.forNumber(principalCase_);
    }

    public Builder clearPrincipal() {
      principalCase_ = 0;
      principal_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 1;</code>
     *
     * @return Whether the userId field is set.
     */
    @java.lang.Override
    public boolean hasUserId() {
      return principalCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 1;</code>
     *
     * @return The userId.
     */
    @java.lang.Override
    public java.lang.String getUserId() {
      java.lang.Object ref = "";
      if (principalCase_ == 1) {
        ref = principal_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (principalCase_ == 1) {
          principal_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 1;</code>
     *
     * @return The bytes for userId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUserIdBytes() {
      java.lang.Object ref = "";
      if (principalCase_ == 1) {
        ref = principal_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (principalCase_ == 1) {
          principal_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 1;</code>
     *
     * @param value The userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      principalCase_ = 1;
      principal_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserId() {
      if (principalCase_ == 1) {
        principalCase_ = 0;
        principal_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * User identifier.
     * For Google Workspace user account, user_id should be the google workspace
     * user email.
     * For non-google identity provider user account, user_id is the mapped user
     * identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string user_id = 1;</code>
     *
     * @param value The bytes for userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      principalCase_ = 1;
      principal_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 2;</code>
     *
     * @return Whether the groupId field is set.
     */
    @java.lang.Override
    public boolean hasGroupId() {
      return principalCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 2;</code>
     *
     * @return The groupId.
     */
    @java.lang.Override
    public java.lang.String getGroupId() {
      java.lang.Object ref = "";
      if (principalCase_ == 2) {
        ref = principal_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (principalCase_ == 2) {
          principal_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 2;</code>
     *
     * @return The bytes for groupId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupIdBytes() {
      java.lang.Object ref = "";
      if (principalCase_ == 2) {
        ref = principal_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (principalCase_ == 2) {
          principal_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 2;</code>
     *
     * @param value The groupId to set.
     * @return This builder for chaining.
     */
    public Builder setGroupId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      principalCase_ = 2;
      principal_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroupId() {
      if (principalCase_ == 2) {
        principalCase_ = 0;
        principal_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Group identifier.
     * For Google Workspace user account, group_id should be the google
     * workspace group email.
     * For non-google identity provider user account, group_id is the mapped
     * group identifier configured during the workforcepool config.
     * </pre>
     *
     * <code>string group_id = 2;</code>
     *
     * @param value The bytes for groupId to set.
     * @return This builder for chaining.
     */
    public Builder setGroupIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      principalCase_ = 2;
      principal_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * For 3P application identities which are not present in the customer
     * identity provider.
     * </pre>
     *
     * <code>string external_entity_id = 3;</code>
     *
     * @return Whether the externalEntityId field is set.
     */
    @java.lang.Override
    public boolean hasExternalEntityId() {
      return principalCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * For 3P application identities which are not present in the customer
     * identity provider.
     * </pre>
     *
     * <code>string external_entity_id = 3;</code>
     *
     * @return The externalEntityId.
     */
    @java.lang.Override
    public java.lang.String getExternalEntityId() {
      java.lang.Object ref = "";
      if (principalCase_ == 3) {
        ref = principal_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (principalCase_ == 3) {
          principal_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * For 3P application identities which are not present in the customer
     * identity provider.
     * </pre>
     *
     * <code>string external_entity_id = 3;</code>
     *
     * @return The bytes for externalEntityId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getExternalEntityIdBytes() {
      java.lang.Object ref = "";
      if (principalCase_ == 3) {
        ref = principal_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (principalCase_ == 3) {
          principal_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * For 3P application identities which are not present in the customer
     * identity provider.
     * </pre>
     *
     * <code>string external_entity_id = 3;</code>
     *
     * @param value The externalEntityId to set.
     * @return This builder for chaining.
     */
    public Builder setExternalEntityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      principalCase_ = 3;
      principal_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * For 3P application identities which are not present in the customer
     * identity provider.
     * </pre>
     *
     * <code>string external_entity_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalEntityId() {
      if (principalCase_ == 3) {
        principalCase_ = 0;
        principal_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * For 3P application identities which are not present in the customer
     * identity provider.
     * </pre>
     *
     * <code>string external_entity_id = 3;</code>
     *
     * @param value The bytes for externalEntityId to set.
     * @return This builder for chaining.
     */
    public Builder setExternalEntityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      principalCase_ = 3;
      principal_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.Principal)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.Principal)
  private static final com.google.cloud.discoveryengine.v1.Principal DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.Principal();
  }

  public static com.google.cloud.discoveryengine.v1.Principal getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Principal> PARSER =
      new com.google.protobuf.AbstractParser<Principal>() {
        @java.lang.Override
        public Principal parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Principal> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Principal> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.Principal getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
