/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/identity_mapping_store_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [IdentityMappingStoreService.PurgeIdentityMappings][google.cloud.discoveryengine.v1.IdentityMappingStoreService.PurgeIdentityMappings]
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest}
 */
public final class PurgeIdentityMappingsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest)
    PurgeIdentityMappingsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PurgeIdentityMappingsRequest.newBuilder() to construct.
  private PurgeIdentityMappingsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PurgeIdentityMappingsRequest() {
    identityMappingStore_ = "";
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PurgeIdentityMappingsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
        .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
        .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.class,
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.Builder.class);
  }

  public interface InlineSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1.IdentityMappingEntry>
        getIdentityMappingEntriesList();

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.IdentityMappingEntry getIdentityMappingEntries(int index);

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    int getIdentityMappingEntriesCount();

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder>
        getIdentityMappingEntriesOrBuilderList();

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder
        getIdentityMappingEntriesOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * The inline source to purge identity mapping entries from.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource}
   */
  public static final class InlineSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
      InlineSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use InlineSource.newBuilder() to construct.
    private InlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InlineSource() {
      identityMappingEntries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InlineSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_InlineSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_InlineSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.class,
              com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.Builder
                  .class);
    }

    public static final int IDENTITY_MAPPING_ENTRIES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1.IdentityMappingEntry>
        identityMappingEntries_;

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1.IdentityMappingEntry>
        getIdentityMappingEntriesList() {
      return identityMappingEntries_;
    }

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder>
        getIdentityMappingEntriesOrBuilderList() {
      return identityMappingEntries_;
    }

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    @java.lang.Override
    public int getIdentityMappingEntriesCount() {
      return identityMappingEntries_.size();
    }

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingEntry getIdentityMappingEntries(
        int index) {
      return identityMappingEntries_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A maximum of 10000 entries can be purged at one time
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder
        getIdentityMappingEntriesOrBuilder(int index) {
      return identityMappingEntries_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < identityMappingEntries_.size(); i++) {
        output.writeMessage(1, identityMappingEntries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < identityMappingEntries_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, identityMappingEntries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource other =
          (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource) obj;

      if (!getIdentityMappingEntriesList().equals(other.getIdentityMappingEntriesList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getIdentityMappingEntriesCount() > 0) {
        hash = (37 * hash) + IDENTITY_MAPPING_ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getIdentityMappingEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
            .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
            .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_InlineSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.class,
                com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (identityMappingEntriesBuilder_ == null) {
          identityMappingEntries_ = java.util.Collections.emptyList();
        } else {
          identityMappingEntries_ = null;
          identityMappingEntriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
            .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource build() {
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource result =
            new com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource result) {
        if (identityMappingEntriesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            identityMappingEntries_ =
                java.util.Collections.unmodifiableList(identityMappingEntries_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.identityMappingEntries_ = identityMappingEntries_;
        } else {
          result.identityMappingEntries_ = identityMappingEntriesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource other) {
        if (other
            == com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
                .getDefaultInstance()) return this;
        if (identityMappingEntriesBuilder_ == null) {
          if (!other.identityMappingEntries_.isEmpty()) {
            if (identityMappingEntries_.isEmpty()) {
              identityMappingEntries_ = other.identityMappingEntries_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureIdentityMappingEntriesIsMutable();
              identityMappingEntries_.addAll(other.identityMappingEntries_);
            }
            onChanged();
          }
        } else {
          if (!other.identityMappingEntries_.isEmpty()) {
            if (identityMappingEntriesBuilder_.isEmpty()) {
              identityMappingEntriesBuilder_.dispose();
              identityMappingEntriesBuilder_ = null;
              identityMappingEntries_ = other.identityMappingEntries_;
              bitField0_ = (bitField0_ & ~0x00000001);
              identityMappingEntriesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getIdentityMappingEntriesFieldBuilder()
                      : null;
            } else {
              identityMappingEntriesBuilder_.addAllMessages(other.identityMappingEntries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1.IdentityMappingEntry m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1.IdentityMappingEntry.parser(),
                          extensionRegistry);
                  if (identityMappingEntriesBuilder_ == null) {
                    ensureIdentityMappingEntriesIsMutable();
                    identityMappingEntries_.add(m);
                  } else {
                    identityMappingEntriesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.discoveryengine.v1.IdentityMappingEntry>
          identityMappingEntries_ = java.util.Collections.emptyList();

      private void ensureIdentityMappingEntriesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          identityMappingEntries_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1.IdentityMappingEntry>(
                  identityMappingEntries_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.IdentityMappingEntry,
              com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder,
              com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder>
          identityMappingEntriesBuilder_;

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.IdentityMappingEntry>
          getIdentityMappingEntriesList() {
        if (identityMappingEntriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(identityMappingEntries_);
        } else {
          return identityMappingEntriesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public int getIdentityMappingEntriesCount() {
        if (identityMappingEntriesBuilder_ == null) {
          return identityMappingEntries_.size();
        } else {
          return identityMappingEntriesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.IdentityMappingEntry getIdentityMappingEntries(
          int index) {
        if (identityMappingEntriesBuilder_ == null) {
          return identityMappingEntries_.get(index);
        } else {
          return identityMappingEntriesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder setIdentityMappingEntries(
          int index, com.google.cloud.discoveryengine.v1.IdentityMappingEntry value) {
        if (identityMappingEntriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIdentityMappingEntriesIsMutable();
          identityMappingEntries_.set(index, value);
          onChanged();
        } else {
          identityMappingEntriesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder setIdentityMappingEntries(
          int index,
          com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder builderForValue) {
        if (identityMappingEntriesBuilder_ == null) {
          ensureIdentityMappingEntriesIsMutable();
          identityMappingEntries_.set(index, builderForValue.build());
          onChanged();
        } else {
          identityMappingEntriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder addIdentityMappingEntries(
          com.google.cloud.discoveryengine.v1.IdentityMappingEntry value) {
        if (identityMappingEntriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIdentityMappingEntriesIsMutable();
          identityMappingEntries_.add(value);
          onChanged();
        } else {
          identityMappingEntriesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder addIdentityMappingEntries(
          int index, com.google.cloud.discoveryengine.v1.IdentityMappingEntry value) {
        if (identityMappingEntriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIdentityMappingEntriesIsMutable();
          identityMappingEntries_.add(index, value);
          onChanged();
        } else {
          identityMappingEntriesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder addIdentityMappingEntries(
          com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder builderForValue) {
        if (identityMappingEntriesBuilder_ == null) {
          ensureIdentityMappingEntriesIsMutable();
          identityMappingEntries_.add(builderForValue.build());
          onChanged();
        } else {
          identityMappingEntriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder addIdentityMappingEntries(
          int index,
          com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder builderForValue) {
        if (identityMappingEntriesBuilder_ == null) {
          ensureIdentityMappingEntriesIsMutable();
          identityMappingEntries_.add(index, builderForValue.build());
          onChanged();
        } else {
          identityMappingEntriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder addAllIdentityMappingEntries(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1.IdentityMappingEntry>
              values) {
        if (identityMappingEntriesBuilder_ == null) {
          ensureIdentityMappingEntriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, identityMappingEntries_);
          onChanged();
        } else {
          identityMappingEntriesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder clearIdentityMappingEntries() {
        if (identityMappingEntriesBuilder_ == null) {
          identityMappingEntries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          identityMappingEntriesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public Builder removeIdentityMappingEntries(int index) {
        if (identityMappingEntriesBuilder_ == null) {
          ensureIdentityMappingEntriesIsMutable();
          identityMappingEntries_.remove(index);
          onChanged();
        } else {
          identityMappingEntriesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder
          getIdentityMappingEntriesBuilder(int index) {
        return getIdentityMappingEntriesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder
          getIdentityMappingEntriesOrBuilder(int index) {
        if (identityMappingEntriesBuilder_ == null) {
          return identityMappingEntries_.get(index);
        } else {
          return identityMappingEntriesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder>
          getIdentityMappingEntriesOrBuilderList() {
        if (identityMappingEntriesBuilder_ != null) {
          return identityMappingEntriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(identityMappingEntries_);
        }
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder
          addIdentityMappingEntriesBuilder() {
        return getIdentityMappingEntriesFieldBuilder()
            .addBuilder(
                com.google.cloud.discoveryengine.v1.IdentityMappingEntry.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder
          addIdentityMappingEntriesBuilder(int index) {
        return getIdentityMappingEntriesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.discoveryengine.v1.IdentityMappingEntry.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A maximum of 10000 entries can be purged at one time
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1.IdentityMappingEntry identity_mapping_entries = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder>
          getIdentityMappingEntriesBuilderList() {
        return getIdentityMappingEntriesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1.IdentityMappingEntry,
              com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder,
              com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder>
          getIdentityMappingEntriesFieldBuilder() {
        if (identityMappingEntriesBuilder_ == null) {
          identityMappingEntriesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1.IdentityMappingEntry,
                  com.google.cloud.discoveryengine.v1.IdentityMappingEntry.Builder,
                  com.google.cloud.discoveryengine.v1.IdentityMappingEntryOrBuilder>(
                  identityMappingEntries_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          identityMappingEntries_ = null;
        }
        return identityMappingEntriesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
    private static final com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest
            .InlineSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource();
    }

    public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InlineSource> PARSER =
        new com.google.protobuf.AbstractParser<InlineSource>() {
          @java.lang.Override
          public InlineSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InlineSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InlineSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_SOURCE(2),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return INLINE_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_SOURCE_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * The inline source to purge identity mapping entries from.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return Whether the inlineSource field is set.
   */
  @java.lang.Override
  public boolean hasInlineSource() {
    return sourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * The inline source to purge identity mapping entries from.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return The inlineSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
      getInlineSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
          source_;
    }
    return com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The inline source to purge identity mapping entries from.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSourceOrBuilder
      getInlineSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
          source_;
    }
    return com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        .getDefaultInstance();
  }

  public static final int IDENTITY_MAPPING_STORE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object identityMappingStore_ = "";

  /**
   *
   *
   * <pre>
   * Required. The name of the Identity Mapping Store to purge Identity Mapping
   * Entries from. Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
   * </pre>
   *
   * <code>
   * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The identityMappingStore.
   */
  @java.lang.Override
  public java.lang.String getIdentityMappingStore() {
    java.lang.Object ref = identityMappingStore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      identityMappingStore_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The name of the Identity Mapping Store to purge Identity Mapping
   * Entries from. Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
   * </pre>
   *
   * <code>
   * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for identityMappingStore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdentityMappingStoreBytes() {
    java.lang.Object ref = identityMappingStore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      identityMappingStore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * Filter matching identity mappings to purge.
   * The eligible field for filtering is:
   * * `update_time`: in ISO 8601 "zulu" format.
   * * `external_id`
   *
   * Examples:
   *
   * * Deleting all identity mappings updated in a time range:
   *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
   *   "2012-04-23T18:30:43.511Z"`
   * * Deleting all identity mappings for a given external_id:
   * `external_id = "id1"`
   * * Deleting all identity mappings inside an identity mapping store:
   *   `*`
   *
   * The filtering fields are assumed to have an implicit AND.
   * Should not be used with source. An error will be thrown, if both are
   * provided.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Filter matching identity mappings to purge.
   * The eligible field for filtering is:
   * * `update_time`: in ISO 8601 "zulu" format.
   * * `external_id`
   *
   * Examples:
   *
   * * Deleting all identity mappings updated in a time range:
   *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
   *   "2012-04-23T18:30:43.511Z"`
   * * Deleting all identity mappings for a given external_id:
   * `external_id = "id1"`
   * * Deleting all identity mappings inside an identity mapping store:
   *   `*`
   *
   * The filtering fields are assumed to have an implicit AND.
   * Should not be used with source. An error will be thrown, if both are
   * provided.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORCE_FIELD_NUMBER = 4;
  private boolean force_ = false;

  /**
   *
   *
   * <pre>
   * Actually performs the purge. If `force` is set to false, return the
   * expected purge count without deleting any identity mappings. This field is
   * only supported for purge with filter. For input source this field is
   * ignored and data will be purged regardless of the value of this field.
   * </pre>
   *
   * <code>optional bool force = 4;</code>
   *
   * @return Whether the force field is set.
   */
  @java.lang.Override
  public boolean hasForce() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Actually performs the purge. If `force` is set to false, return the
   * expected purge count without deleting any identity mappings. This field is
   * only supported for purge with filter. For input source this field is
   * ignored and data will be purged regardless of the value of this field.
   * </pre>
   *
   * <code>optional bool force = 4;</code>
   *
   * @return The force.
   */
  @java.lang.Override
  public boolean getForce() {
    return force_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityMappingStore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, identityMappingStore_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource) source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(4, force_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(identityMappingStore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, identityMappingStore_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
                  source_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, force_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest other =
        (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest) obj;

    if (!getIdentityMappingStore().equals(other.getIdentityMappingStore())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (hasForce() != other.hasForce()) return false;
    if (hasForce()) {
      if (getForce() != other.getForce()) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getInlineSource().equals(other.getInlineSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IDENTITY_MAPPING_STORE_FIELD_NUMBER;
    hash = (53 * hash) + getIdentityMappingStore().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (hasForce()) {
      hash = (37 * hash) + FORCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getForce());
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [IdentityMappingStoreService.PurgeIdentityMappings][google.cloud.discoveryengine.v1.IdentityMappingStoreService.PurgeIdentityMappings]
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest)
      com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.class,
              com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineSourceBuilder_ != null) {
        inlineSourceBuilder_.clear();
      }
      identityMappingStore_ = "";
      filter_ = "";
      force_ = false;
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1.IdentityMappingStoreServiceProto
          .internal_static_google_cloud_discoveryengine_v1_PurgeIdentityMappingsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest build() {
      com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest buildPartial() {
      com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest result =
          new com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.identityMappingStore_ = identityMappingStore_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.force_ = force_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && inlineSourceBuilder_ != null) {
        result.source_ = inlineSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest) {
        return mergeFrom((com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.getDefaultInstance())
        return this;
      if (!other.getIdentityMappingStore().isEmpty()) {
        identityMappingStore_ = other.identityMappingStore_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasForce()) {
        setForce(other.getForce());
      }
      switch (other.getSourceCase()) {
        case INLINE_SOURCE:
          {
            mergeInlineSource(other.getInlineSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                identityMappingStore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                force_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource,
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.Builder,
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSourceOrBuilder>
        inlineSourceBuilder_;

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
        getInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return inlineSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.Builder
            builderForValue) {
      if (inlineSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder mergeInlineSource(
        com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
                  .newBuilder(
                      (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest
                              .InlineSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          inlineSourceBuilder_.mergeFrom(value);
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder clearInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.Builder
        getInlineSourceBuilder() {
      return getInlineSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if ((sourceCase_ == 2) && (inlineSourceBuilder_ != null)) {
        return inlineSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The inline source to purge identity mapping entries from.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource,
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource.Builder,
            com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSourceOrBuilder>
        getInlineSourceFieldBuilder() {
      if (inlineSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
                  .getDefaultInstance();
        }
        inlineSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource,
                com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource
                    .Builder,
                com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest
                    .InlineSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return inlineSourceBuilder_;
    }

    private java.lang.Object identityMappingStore_ = "";

    /**
     *
     *
     * <pre>
     * Required. The name of the Identity Mapping Store to purge Identity Mapping
     * Entries from. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
     * </pre>
     *
     * <code>
     * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The identityMappingStore.
     */
    public java.lang.String getIdentityMappingStore() {
      java.lang.Object ref = identityMappingStore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        identityMappingStore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Identity Mapping Store to purge Identity Mapping
     * Entries from. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
     * </pre>
     *
     * <code>
     * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for identityMappingStore.
     */
    public com.google.protobuf.ByteString getIdentityMappingStoreBytes() {
      java.lang.Object ref = identityMappingStore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        identityMappingStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Identity Mapping Store to purge Identity Mapping
     * Entries from. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
     * </pre>
     *
     * <code>
     * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The identityMappingStore to set.
     * @return This builder for chaining.
     */
    public Builder setIdentityMappingStore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      identityMappingStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Identity Mapping Store to purge Identity Mapping
     * Entries from. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
     * </pre>
     *
     * <code>
     * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIdentityMappingStore() {
      identityMappingStore_ = getDefaultInstance().getIdentityMappingStore();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The name of the Identity Mapping Store to purge Identity Mapping
     * Entries from. Format:
     * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
     * </pre>
     *
     * <code>
     * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for identityMappingStore to set.
     * @return This builder for chaining.
     */
    public Builder setIdentityMappingStoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      identityMappingStore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Filter matching identity mappings to purge.
     * The eligible field for filtering is:
     * * `update_time`: in ISO 8601 "zulu" format.
     * * `external_id`
     *
     * Examples:
     *
     * * Deleting all identity mappings updated in a time range:
     *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
     *   "2012-04-23T18:30:43.511Z"`
     * * Deleting all identity mappings for a given external_id:
     * `external_id = "id1"`
     * * Deleting all identity mappings inside an identity mapping store:
     *   `*`
     *
     * The filtering fields are assumed to have an implicit AND.
     * Should not be used with source. An error will be thrown, if both are
     * provided.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Filter matching identity mappings to purge.
     * The eligible field for filtering is:
     * * `update_time`: in ISO 8601 "zulu" format.
     * * `external_id`
     *
     * Examples:
     *
     * * Deleting all identity mappings updated in a time range:
     *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
     *   "2012-04-23T18:30:43.511Z"`
     * * Deleting all identity mappings for a given external_id:
     * `external_id = "id1"`
     * * Deleting all identity mappings inside an identity mapping store:
     *   `*`
     *
     * The filtering fields are assumed to have an implicit AND.
     * Should not be used with source. An error will be thrown, if both are
     * provided.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Filter matching identity mappings to purge.
     * The eligible field for filtering is:
     * * `update_time`: in ISO 8601 "zulu" format.
     * * `external_id`
     *
     * Examples:
     *
     * * Deleting all identity mappings updated in a time range:
     *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
     *   "2012-04-23T18:30:43.511Z"`
     * * Deleting all identity mappings for a given external_id:
     * `external_id = "id1"`
     * * Deleting all identity mappings inside an identity mapping store:
     *   `*`
     *
     * The filtering fields are assumed to have an implicit AND.
     * Should not be used with source. An error will be thrown, if both are
     * provided.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Filter matching identity mappings to purge.
     * The eligible field for filtering is:
     * * `update_time`: in ISO 8601 "zulu" format.
     * * `external_id`
     *
     * Examples:
     *
     * * Deleting all identity mappings updated in a time range:
     *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
     *   "2012-04-23T18:30:43.511Z"`
     * * Deleting all identity mappings for a given external_id:
     * `external_id = "id1"`
     * * Deleting all identity mappings inside an identity mapping store:
     *   `*`
     *
     * The filtering fields are assumed to have an implicit AND.
     * Should not be used with source. An error will be thrown, if both are
     * provided.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Filter matching identity mappings to purge.
     * The eligible field for filtering is:
     * * `update_time`: in ISO 8601 "zulu" format.
     * * `external_id`
     *
     * Examples:
     *
     * * Deleting all identity mappings updated in a time range:
     *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
     *   "2012-04-23T18:30:43.511Z"`
     * * Deleting all identity mappings for a given external_id:
     * `external_id = "id1"`
     * * Deleting all identity mappings inside an identity mapping store:
     *   `*`
     *
     * The filtering fields are assumed to have an implicit AND.
     * Should not be used with source. An error will be thrown, if both are
     * provided.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean force_;

    /**
     *
     *
     * <pre>
     * Actually performs the purge. If `force` is set to false, return the
     * expected purge count without deleting any identity mappings. This field is
     * only supported for purge with filter. For input source this field is
     * ignored and data will be purged regardless of the value of this field.
     * </pre>
     *
     * <code>optional bool force = 4;</code>
     *
     * @return Whether the force field is set.
     */
    @java.lang.Override
    public boolean hasForce() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Actually performs the purge. If `force` is set to false, return the
     * expected purge count without deleting any identity mappings. This field is
     * only supported for purge with filter. For input source this field is
     * ignored and data will be purged regardless of the value of this field.
     * </pre>
     *
     * <code>optional bool force = 4;</code>
     *
     * @return The force.
     */
    @java.lang.Override
    public boolean getForce() {
      return force_;
    }

    /**
     *
     *
     * <pre>
     * Actually performs the purge. If `force` is set to false, return the
     * expected purge count without deleting any identity mappings. This field is
     * only supported for purge with filter. For input source this field is
     * ignored and data will be purged regardless of the value of this field.
     * </pre>
     *
     * <code>optional bool force = 4;</code>
     *
     * @param value The force to set.
     * @return This builder for chaining.
     */
    public Builder setForce(boolean value) {

      force_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Actually performs the purge. If `force` is set to false, return the
     * expected purge count without deleting any identity mappings. This field is
     * only supported for purge with filter. For input source this field is
     * ignored and data will be purged regardless of the value of this field.
     * </pre>
     *
     * <code>optional bool force = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForce() {
      bitField0_ = (bitField0_ & ~0x00000008);
      force_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest)
  private static final com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest();
  }

  public static com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PurgeIdentityMappingsRequest> PARSER =
      new com.google.protobuf.AbstractParser<PurgeIdentityMappingsRequest>() {
        @java.lang.Override
        public PurgeIdentityMappingsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PurgeIdentityMappingsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PurgeIdentityMappingsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
