/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1/identity_mapping_store_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.discoveryengine.v1;

public interface PurgeIdentityMappingsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The inline source to purge identity mapping entries from.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return Whether the inlineSource field is set.
   */
  boolean hasInlineSource();

  /**
   *
   *
   * <pre>
   * The inline source to purge identity mapping entries from.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return The inlineSource.
   */
  com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource getInlineSource();

  /**
   *
   *
   * <pre>
   * The inline source to purge identity mapping entries from.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSource inline_source = 2;
   * </code>
   */
  com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.InlineSourceOrBuilder
      getInlineSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The name of the Identity Mapping Store to purge Identity Mapping
   * Entries from. Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
   * </pre>
   *
   * <code>
   * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The identityMappingStore.
   */
  java.lang.String getIdentityMappingStore();

  /**
   *
   *
   * <pre>
   * Required. The name of the Identity Mapping Store to purge Identity Mapping
   * Entries from. Format:
   * `projects/{project}/locations/{location}/identityMappingStores/{identityMappingStore}`
   * </pre>
   *
   * <code>
   * string identity_mapping_store = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for identityMappingStore.
   */
  com.google.protobuf.ByteString getIdentityMappingStoreBytes();

  /**
   *
   *
   * <pre>
   * Filter matching identity mappings to purge.
   * The eligible field for filtering is:
   * * `update_time`: in ISO 8601 "zulu" format.
   * * `external_id`
   *
   * Examples:
   *
   * * Deleting all identity mappings updated in a time range:
   *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
   *   "2012-04-23T18:30:43.511Z"`
   * * Deleting all identity mappings for a given external_id:
   * `external_id = "id1"`
   * * Deleting all identity mappings inside an identity mapping store:
   *   `*`
   *
   * The filtering fields are assumed to have an implicit AND.
   * Should not be used with source. An error will be thrown, if both are
   * provided.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();

  /**
   *
   *
   * <pre>
   * Filter matching identity mappings to purge.
   * The eligible field for filtering is:
   * * `update_time`: in ISO 8601 "zulu" format.
   * * `external_id`
   *
   * Examples:
   *
   * * Deleting all identity mappings updated in a time range:
   *   `update_time &gt; "2012-04-23T18:25:43.511Z" AND update_time &lt;
   *   "2012-04-23T18:30:43.511Z"`
   * * Deleting all identity mappings for a given external_id:
   * `external_id = "id1"`
   * * Deleting all identity mappings inside an identity mapping store:
   *   `*`
   *
   * The filtering fields are assumed to have an implicit AND.
   * Should not be used with source. An error will be thrown, if both are
   * provided.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * Actually performs the purge. If `force` is set to false, return the
   * expected purge count without deleting any identity mappings. This field is
   * only supported for purge with filter. For input source this field is
   * ignored and data will be purged regardless of the value of this field.
   * </pre>
   *
   * <code>optional bool force = 4;</code>
   *
   * @return Whether the force field is set.
   */
  boolean hasForce();

  /**
   *
   *
   * <pre>
   * Actually performs the purge. If `force` is set to false, return the
   * expected purge count without deleting any identity mappings. This field is
   * only supported for purge with filter. For input source this field is
   * ignored and data will be purged regardless of the value of this field.
   * </pre>
   *
   * <code>optional bool force = 4;</code>
   *
   * @return The force.
   */
  boolean getForce();

  com.google.cloud.discoveryengine.v1.PurgeIdentityMappingsRequest.SourceCase getSourceCase();
}
